/*
 * Decompiled with CFR 0.152.
 */
package android.os.yx;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class YxWiegand {
    private static final String TAG = "YxWiegand";
    private final boolean DBG = true;
    private Context mContext;
    private static YxWiegand yxWiegand;
    private YxWiegandCallBack mCallBack;
    private static boolean mHasStartReading;
    private static Handler mUIHandler;
    private HandlerThread mHandlerThread;
    private MyHandler mHandler;

    private YxWiegand(Context context) {
        this.mContext = context;
        mUIHandler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        byte[] data = (byte[])msg.obj;
                        if (YxWiegand.this.mCallBack == null || data == null) break;
                        YxWiegand.this.mCallBack.onNewValue(data);
                    }
                }
            }
        };
        this.mHandlerThread = new HandlerThread("WiegandReading");
        this.mHandlerThread.start();
        this.mHandler = new MyHandler(this.mHandlerThread.getLooper());
        mHasStartReading = false;
    }

    public static synchronized YxWiegand getInstance(Context context) {
        if (yxWiegand == null) {
            yxWiegand = new YxWiegand(context);
        }
        return yxWiegand;
    }

    public boolean write(byte[] wiegand) {
        byte[] buf = new byte[wiegand.length];
        System.arraycopy(wiegand, 0, buf, 0, buf.length);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, buf));
        return true;
    }

    public boolean startReading(YxWiegandCallBack callBack) {
        if (mHasStartReading) {
            Log.e((String)TAG, (String)"The wiegand reading has been started.");
            return false;
        }
        this.mCallBack = callBack;
        mHasStartReading = true;
        this.mHandler.sendEmptyMessage(1);
        return true;
    }

    public void stopReading() {
        if (mHasStartReading) {
            mHasStartReading = false;
            if (mUIHandler.hasMessages(1)) {
                mUIHandler.removeMessages(1);
            }
            this.mHandler.sendEmptyMessage(2);
            this.mCallBack = null;
        }
    }

    public void realese() {
        this.mHandler = null;
        mUIHandler = null;
        this.mHandlerThread.quit();
        this.mHandlerThread = null;
    }

    protected class MyHandler
    extends Handler {
        public static final int MSG_START_READING = 1;
        public static final int MSG_STOP_READING = 2;
        public static final int MSG_WRITE_DATA = 3;
        private File mWiegand;
        private FileInputStream mReader;
        private byte[] mWriteBuffer;
        private boolean mReading;

        public MyHandler(Looper looper) {
            super(looper);
            this.mWiegand = null;
            this.mReader = null;
            this.mWriteBuffer = null;
            this.mReading = false;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (this.mWiegand == null) {
                        this.mWiegand = new File("/dev/wiegand");
                    }
                    if (!this.mWiegand.exists()) {
                        this.mWiegand = null;
                        Log.e((String)YxWiegand.TAG, (String)"The wiegand file isn't exist.");
                        break;
                    }
                    if (this.mReader == null) {
                        try {
                            this.mReader = new FileInputStream(this.mWiegand);
                        }
                        catch (FileNotFoundException var7) {
                            var7.printStackTrace();
                            break;
                        }
                    }
                    byte[] temp = new byte[4];
                    int count = 0;
                    this.mReading = true;
                    try {
                        count = this.mReader.read(temp);
                    }
                    catch (IOException var6) {
                        var6.printStackTrace();
                    }
                    if (mUIHandler == null) break;
                    if (count > 0) {
                        byte[] result = new byte[count];
                        System.arraycopy(temp, 0, result, 0, count);
                        mUIHandler.sendMessage(mUIHandler.obtainMessage(1, (Object)result));
                    }
                    this.checkAndWriteData();
                    SystemClock.sleep((long)10L);
                    this.sendEmptyMessage(1);
                    break;
                }
                case 2: {
                    if (this.hasMessages(1)) {
                        this.removeMessages(1);
                    }
                    if (this.mReader != null) {
                        try {
                            this.mReader.close();
                        }
                        catch (IOException var5) {
                            var5.printStackTrace();
                        }
                        this.mReader = null;
                    }
                    this.mWiegand = null;
                    this.mReading = false;
                    break;
                }
                case 3: {
                    this.mWriteBuffer = (byte[])msg.obj;
                    if (this.mReading) break;
                    this.checkAndWriteData();
                }
            }
        }

        private void checkAndWriteData() {
            if (this.mWriteBuffer != null) {
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream("/dev/wiegand");
                    out.write(this.mWriteBuffer);
                    out.flush();
                    out.close();
                }
                catch (IOException var3) {
                    var3.printStackTrace();
                }
                this.mWriteBuffer = null;
            }
        }
    }

    public static interface YxWiegandCallBack {
        public void onNewValue(byte[] var1);
    }
}

