/*
 * Decompiled with CFR 0.152.
 */
package android.os.yx;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.yx.IYxDeviceManagementService;
import android.os.yx.IYxGpioListener;
import android.os.yx.IYxInstallListener;
import android.os.yx.Utils.StorageUtils;
import android.os.yx.Utils.Utils;
import android.os.yx.Utils.VersionUtils;
import android.util.Log;
import java.util.Arrays;

public class YxDeviceManager {
    private static final String TAG = "YxDeviceManager";
    private final boolean DBG = true;
    public static final String SYSTEMUI_KEYGUARD_OPEN_ACTION = "android.56iq.intent.action.OPEN_SCREEN";
    public static final String SYSTEMUI_KEYGUARD_CLOSE_ACTION = "android.56iq.intent.action.CLOSE_SCREEN";
    private IYxDeviceManagementService mService;
    private Context mContext;
    private static YxDeviceManager yxManager;

    public YxDeviceManager(Context context) {
        IBinder b = ServiceManager.getService((String)"yx_device_management");
        if (b == null) {
            Log.e((String)TAG, (String)"Unable to connect to yx device management service! - is it running yet?");
            return;
        }
        this.mService = IYxDeviceManagementService.Stub.asInterface(b);
        this.mContext = context;
    }

    public static synchronized YxDeviceManager getInstance(Context context) {
        if (yxManager == null) {
            yxManager = new YxDeviceManager(context);
        }
        return yxManager;
    }

    public String getAndroidModle() {
        return VersionUtils.getAndroidModle();
    }

    public String getAndroidVersion() {
        return Build.VERSION.SDK;
    }

    public String getRunningMemory() {
        return StorageUtils.getRealMeoSize();
    }

    public String getInternalStorageMemory() {
        return StorageUtils.getRealSizeOfNand();
    }

    public String getKernelVersion() {
        return VersionUtils.getKernelVersion();
    }

    public String getAndroidDisplay() {
        return VersionUtils.getSystemVersionInfo();
    }

    public String getCPUType() {
        return VersionUtils.getCpuInfo()[0];
    }

    public String getFirmwareDate() {
        return VersionUtils.getFirmwareDate();
    }

    private void sendMyBroadcast(String action) {
        if (this.mContext != null) {
            Intent intent = new Intent();
            intent.setAction(action);
            this.mContext.sendBroadcast(intent);
        }
    }

    public boolean getRootStatus() {
        return Utils.isRoot();
    }

    public String getApiVersion() {
        return "2022-09-30";
    }

    public void replaceBootanimation(String path) {
        if (Build.VERSION.SDK_INT < 27) {
            String[] commands = new String[]{"mount -o rw,remount -t ext4 /system", "rm -rf system/media/bootanimation.zip", "cp  " + path + " system/media/bootanimation.zip", "chmod 644 system/media/bootanimation.zip", "sync", "mount -o ro,remount -t ext4 /system"};
            for (int i = 0; i < commands.length; ++i) {
                Utils.execFor7(commands[i]);
            }
        } else if (Build.VERSION.SDK_INT == 30) {
            String[] commands = new String[]{"mount -o rw,remount -t ext4 /odm", "rm -rf /odm/media/bootanimation.zip", "cp  " + path + " /odm/media/bootanimation.zip", "chmod 644 /odm/media/bootanimation.zip", "sync", "mount -o ro,remount -t ext4 /odm"};
            for (int i = 0; i < commands.length; ++i) {
                Utils.execFor7(commands[i]);
            }
        } else {
            String[] commands = new String[]{"mount -o rw,remount -t ext4 /oem", "rm -rf oem/media/bootanimation.zip", "cp  " + path + " oem/media/bootanimation.zip", "chmod 644 oem/media/bootanimation.zip", "sync", "mount -o ro,remount -t ext4 /oem"};
            for (int i = 0; i < commands.length; ++i) {
                Utils.execFor7(commands[i]);
            }
        }
        this.rebootNow();
    }

    public void setSystemTime(long modify_time) {
        Intent intent = new Intent("com.yt.modify.time");
        intent.putExtra("modify_time", modify_time);
        this.mContext.sendBroadcast(intent);
    }

    public void enableWatchdog() {
        try {
            this.mService.enableWatchdog();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error enableWatchdog:" + exception));
        }
    }

    public void feedWatchdog() {
        try {
            this.mService.feedWatchdog();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error feedWatchdog:" + exception));
        }
    }

    public void disableWatchdog() {
        try {
            this.mService.disableWatchdog();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error disableWatchdog:" + exception));
        }
    }

    public void setNavBar(boolean flag) {
        if (flag) {
            this.sendMyBroadcast("action.sys.navbar.show");
        } else {
            this.sendMyBroadcast("action.sys.navbar.hide");
        }
    }

    public void setStaBar(boolean flag) {
        if (flag) {
            this.sendMyBroadcast("action.sys.statusbar.show");
        } else {
            this.sendMyBroadcast("action.sys.statusbar.hide");
        }
    }

    public int setNavBarNew(boolean flag) {
        int ret;
        try {
            ret = this.mService.setNavBar(flag);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error setNavBar :" + e));
            return -1;
        }
        return ret;
    }

    public int setStaBarNew(boolean flag) {
        int ret;
        try {
            ret = this.mService.setStaBar(flag);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error setStaBar :" + e));
            return -1;
        }
        return ret;
    }

    public int setScreenRotation(int value) {
        int ret;
        try {
            ret = this.mService.setScreenRotation(value);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error setScreenRotation:" + e));
            return -1;
        }
        return ret;
    }

    public int getScreenRotation() {
        int ret;
        try {
            ret = this.mService.getScreenRotation();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error getScreenRotation:" + e));
            return -1;
        }
        return ret;
    }

    public int shutDownNow() {
        int ret;
        try {
            ret = this.mService.shutDownNow();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error shutDownNow :" + e));
            return -1;
        }
        return ret;
    }

    public int rebootNow() {
        int ret;
        try {
            ret = this.mService.rebootNow();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error rebootNow :" + e));
            return -1;
        }
        return ret;
    }

    public boolean setGpioDirection(int gpio, int arg) {
        boolean ret = false;
        try {
            ret = this.mService.setGpioDirection(gpio, arg);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error setGpioValue :" + e));
            return false;
        }
        return ret;
    }

    public String getGpioDirection(int gpio) {
        String ret = "";
        try {
            ret = this.mService.getGpioDirection(gpio);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error setGpioValue :" + e));
        }
        return ret;
    }

    public int setGpioValue(int id, int value) {
        int ret;
        try {
            ret = this.mService.setGpioValue(id, value);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error setGpioValue :" + e));
            return -1;
        }
        return ret;
    }

    public int getGpioValue(int id) {
        int ret;
        try {
            ret = this.mService.getGpioValue(id);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error getGpioValue :" + e));
            return -1;
        }
        return ret;
    }

    public String getSerialno() {
        if (Build.VERSION.SDK_INT >= 28) {
            String defaultSn = "";
            try {
                defaultSn = this.mService.getSerialno();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return defaultSn;
        }
        return Build.SERIAL;
    }

    public String getTelephonyImei() {
        String defaultImei = "";
        try {
            defaultImei = this.mService.getTelephonyImei();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultImei;
    }

    public String getSimSerialNumber() {
        String defaultSerial = "";
        try {
            defaultSerial = this.mService.getSimSerialNumber();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultSerial;
    }

    public String getOtgMode() {
        String defaultmode = "otg";
        try {
            defaultmode = this.mService.getOtgMode();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultmode;
    }

    public int setOtgMode(boolean value) {
        int ret;
        try {
            ret = this.mService.setOtgMode(value);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error setOtgMode :" + e));
            return -1;
        }
        return ret;
    }

    public boolean register(IYxGpioListener aListener, int gpio) {
        if (aListener == null) {
            return false;
        }
        try {
            this.mService.register(aListener, gpio);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void unregistListener(IYxGpioListener aListener, int gpio) {
        if (aListener == null) {
            return;
        }
        try {
            if (aListener != null) {
                this.mService.unregistListener(aListener, gpio);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void silentInstallApk(String apkPath) {
        Intent intent = new Intent("android.intent.action.SILENCE_INSTALL");
        intent.putExtra("apkFilePath", apkPath);
        this.mContext.sendBroadcast(intent);
    }

    public void silentInstallApk(String apkPath, boolean start) {
        Intent intent = new Intent("android.intent.action.SILENCE_INSTALL");
        intent.putExtra("apkFilePath", apkPath);
        intent.putExtra("autostart", start);
        this.mContext.sendBroadcast(intent);
    }

    public boolean silentInstallApk(IYxInstallListener aListener, String apkPath, boolean start) {
        if (aListener == null) {
            return false;
        }
        try {
            this.mService.registerinstall(aListener, apkPath, start);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void unInstallApk(String packagename) {
        Intent intent = new Intent("android.intent.action.SILENCE_UNINSTALL");
        intent.putExtra("pkaName", packagename);
        this.mContext.sendBroadcast(intent);
    }

    public void setScreenKeyGuard(boolean enable) {
        if (enable) {
            Intent intent = new Intent(SYSTEMUI_KEYGUARD_OPEN_ACTION);
            this.mContext.sendBroadcast(intent);
        } else {
            Intent intent = new Intent(SYSTEMUI_KEYGUARD_CLOSE_ACTION);
            this.mContext.sendBroadcast(intent);
        }
    }

    public int setDeviceSerialno(String value) {
        int ret;
        try {
            ret = this.mService.setDeviceSerialno(value);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error setDeviceSerialno :" + e));
            return -1;
        }
        return ret;
    }

    public int setDeviceMacaddress(String value) {
        int ret;
        try {
            ret = this.mService.setDeviceMacaddress(value);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error setDeviceMacaddress :" + e));
            return -1;
        }
        return ret;
    }

    public String getDeviceMacaddress() {
        String secret = "";
        try {
            secret = this.mService.getDeviceMacaddress();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error getDeviceMacaddress :" + exception));
        }
        return secret;
    }

    public String getEthMode() {
        String secret = "";
        try {
            secret = this.mService.getEthMode();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error getEthMode :" + exception));
        }
        return secret;
    }

    public boolean getEthStatus() {
        boolean flag = false;
        try {
            flag = this.mService.getEthStatus();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error getEthStatus :" + exception));
        }
        return flag;
    }

    public String getNetMask() {
        String secret = "";
        try {
            secret = this.mService.getNetMask();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error getNetMask :" + exception));
        }
        return secret;
    }

    public String getGateway() {
        String secret = "";
        try {
            secret = this.mService.getGateway();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error Gateway :" + exception));
        }
        return secret;
    }

    public String getEthDns1() {
        String secret = "";
        try {
            secret = this.mService.getEthDns1();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error getEthDns1 :" + exception));
        }
        return secret;
    }

    public String getEthDns2() {
        String secret = "";
        try {
            secret = this.mService.getEthDns2();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error getEthDns2 :" + exception));
        }
        return secret;
    }

    public String getIpAddress() {
        String secret = "";
        try {
            secret = this.mService.getIpAddress();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error getIpAddress :" + exception));
        }
        return secret;
    }

    public void ethEnabled(boolean enable) {
        try {
            this.mService.ethEnabled(enable);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error ethEnabled:" + exception));
        }
    }

    public void setStaticEthIPAddress(String IPaddr, String gateWay, String mask, String dns1, String dns2) {
        try {
            this.mService.setStaticEthIPAddress(IPaddr, gateWay, mask, dns1, dns2);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error setStaticEthIPAddress:" + exception));
        }
    }

    public int setDeviceCustom(int ID, String value) {
        int ret;
        if (ID < 16) {
            return -1;
        }
        try {
            ret = this.mService.setDeviceCustom(ID, value);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error ssetDeviceCustom :" + e));
            return -1;
        }
        return ret;
    }

    public String getDeviceCustom(int ID) {
        String secret = "";
        if (ID < 16) {
            return secret;
        }
        try {
            secret = this.mService.getDeviceCustom(ID);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error getDeviceCustom :" + exception));
        }
        return secret;
    }

    public int setLedStatus(int id, boolean status) {
        int ret = -1;
        try {
            ret = this.mService.setLedStatus(id, status);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error setLedStatus :" + exception));
        }
        return ret;
    }

    public int getLedStatus(int id) {
        int ret = -1;
        try {
            ret = this.mService.getLedStatus(id);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error getLedStatus :" + exception));
        }
        return ret;
    }

    public int setBrightness(int paramInt) {
        int ret = -1;
        try {
            ret = this.mService.setBrightness(paramInt);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error setBrightness :" + exception));
        }
        return ret;
    }

    public int getBrightness() {
        int ret = -1;
        try {
            ret = this.mService.getBrightness();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error getBrightness :" + exception));
        }
        return ret;
    }

    public int getDcStatus() {
        int ret = -1;
        try {
            ret = this.mService.getDcStatus();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error getDcStatus :" + exception));
        }
        return ret;
    }

    public int changeMobileCarrier(int paramInt) {
        int ret = -1;
        try {
            ret = this.mService.changeMobileCarrier(paramInt);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error changeMobileCarrier :" + exception));
        }
        return ret;
    }

    public int setMcuReboot() {
        int ret = -1;
        try {
            ret = this.mService.setMcuReboot();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error setMcuReboot :" + exception));
        }
        return ret;
    }

    public void turnOffBacklight() {
        try {
            this.mService.turnOffBacklight();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error turnOffBacklight :" + exception));
        }
    }

    public void turnOnBacklight() {
        try {
            this.mService.turnOnBacklight();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error turnOnBacklight :" + exception));
        }
    }

    public boolean isBacklightOn() {
        boolean ret = false;
        try {
            ret = this.mService.isBacklightOn();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error isBacklightOn :" + e));
        }
        return ret;
    }

    public int getSystemBrightness() {
        int ret = -1;
        try {
            ret = this.mService.getSystemBrightness();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error getSystemBrightness :" + exception));
        }
        return ret;
    }

    public void turnOffBacklightExtend() {
        try {
            this.mService.turnOffBacklightExtend();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error turnOffBacklightExtend :" + exception));
        }
    }

    public void turnOnBacklightExtend() {
        try {
            this.mService.turnOnBacklightExtend();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error turnOnBacklightExtend :" + exception));
        }
    }

    public boolean isBacklightOnExtend() {
        boolean ret = false;
        try {
            ret = this.mService.isBacklightOnExtend();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error isBacklightOnExtend :" + e));
        }
        return ret;
    }

    public int getSystemBrightnessExtend() {
        int ret = -1;
        try {
            ret = this.mService.getSystemBrightnessExtend();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error getSystemBrightnessExtend :" + exception));
        }
        return ret;
    }

    public void turnOffHDMI() {
    }

    public void turnOnHDMI() {
    }

    public int setBugReport(boolean param) {
        int ret;
        try {
            ret = this.mService.setBugReport(param);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error setBugReport :" + e));
            return -1;
        }
        return ret;
    }

    public boolean getBugReport() {
        boolean ret = false;
        try {
            ret = this.mService.getBugReport();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error setBugReport :" + e));
        }
        return ret;
    }

    public void setOemFunc(String value) {
        try {
            this.mService.setOemFunc(value);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error setOemFunc:" + exception));
        }
    }

    public int setSensorReport(int value) {
        int ret;
        try {
            ret = this.mService.setSensorReport(value);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error setSensorReport :" + e));
            return -1;
        }
        return ret;
    }

    public int getSensorReport() {
        int ret;
        try {
            ret = this.mService.getSensorReport();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error setSensorReport :" + e));
            return -1;
        }
        return ret;
    }

    public void upgradeSystem(String absolutePath) {
        try {
            this.mService.upgradeSystem(absolutePath);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error upgradeSystem:" + exception));
        }
    }

    public void setUpdateSystemWithDialog(boolean flag) {
        try {
            this.mService.setUpdateSystemWithDialog(flag);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error setUpdateSystemWithDialog:" + exception));
        }
    }

    public void setUpdateSystemDelete(boolean flag) {
        try {
            this.mService.setUpdateSystemDelete(flag);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error setUpdateSystemDelete:" + exception));
        }
    }

    public void setPowerOnOffWithWeekly(int[] powerOnTime, int[] powerOffTime, int[] weekdays) {
        Intent intent = new Intent("android.intent.action.setyspoweronoff");
        intent.putExtra("timeon", powerOnTime);
        intent.putExtra("timeoff", powerOffTime);
        intent.putExtra("wkdays", weekdays);
        intent.putExtra("enable", true);
        intent.setPackage("com.adtv");
        this.mContext.sendBroadcast(intent);
        Log.d((String)"MyManager", (String)("poweron:" + Arrays.toString(powerOnTime) + "/ poweroff:" + Arrays.toString(powerOffTime) + "/weekday:" + Arrays.toString(weekdays)));
    }

    public void setPowerOnOff(int[] powerOnTime, int[] powerOffTime) {
        Intent intent = new Intent("android.intent.action.setpoweronoff");
        intent.putExtra("timeon", powerOnTime);
        intent.putExtra("timeoff", powerOffTime);
        intent.putExtra("enable", true);
        intent.setPackage("com.adtv");
        this.mContext.sendBroadcast(intent);
        Log.d((String)"MyManager", (String)("poweron:" + Arrays.toString(powerOnTime) + "/ poweroff:" + Arrays.toString(powerOffTime)));
    }

    public String getPowerOnMode() {
        String mode = SystemProperties.get((String)"persist.sys.poweronmode", (String)"0");
        return mode;
    }

    public String getPowerOnTime() {
        String mode = SystemProperties.get((String)"persist.sys.poweronmode", (String)"0");
        if ("2".equals(mode)) {
            return SystemProperties.get((String)"persist.sys.powerontimenum", (String)"0");
        }
        return SystemProperties.get((String)"persist.sys.powerontime", (String)"0");
    }

    public String getPowerOffTime() {
        String mode = SystemProperties.get((String)"persist.sys.poweronmode", (String)"0");
        if ("2".equals(mode)) {
            return SystemProperties.get((String)"persist.sys.powerofftimenum", (String)"0");
        }
        return SystemProperties.get((String)"persist.sys.powerofftime", (String)"0");
    }

    public String getLastestPowerOnTime() {
        return SystemProperties.get((String)"persist.sys.powerontimeper", (String)"0");
    }

    public String getLastestPowerOffTime() {
        return SystemProperties.get((String)"persist.sys.powerofftimeper", (String)"0");
    }

    public void clearPowerOnOffTime() {
        Intent intent = new Intent("android.intent.ClearOnOffTime");
        intent.setPackage("com.adtv");
        this.mContext.sendBroadcast(intent);
    }

    public boolean isSetPowerOnTime() {
        return !"0".equals(this.getPowerOnTime());
    }
}

