/*
 * Decompiled with CFR 0.152.
 */
package android.os.yx.Utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.IBinder;
import android.util.Log;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;

public class Utils {
    public static void setValueToProp(String key, String val) {
        try {
            Class<?> classType = Class.forName("android.os.SystemProperties");
            Method method = classType.getDeclaredMethod("set", String.class, String.class);
            method.invoke(classType, key, val);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getValueFromProp(String key) {
        String value = "";
        try {
            Class<?> classType = Class.forName("android.os.SystemProperties");
            Method getMethod = classType.getDeclaredMethod("get", String.class);
            value = (String)getMethod.invoke(classType, key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static void do_exec(String cmd) {
        try {
            Process su = Runtime.getRuntime().exec("su");
            String str = cmd + "\nexit\n";
            su.getOutputStream().write(str.getBytes());
            if (su.waitFor() != 0) {
                System.out.println("cmd=" + cmd + " error!");
                throw new SecurityException();
            }
        }
        catch (Exception e) {
            Log.d((String)"chenhuan", (String)("e = " + e.getMessage()));
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execFor7AndReboot(String command) {
        Log.d((String)"execFor7", (String)("command = " + command));
        boolean result = false;
        FilterOutputStream dataOutputStream = null;
        BufferedReader errorStream = null;
        try {
            String line;
            Process process = Runtime.getRuntime().exec("su");
            dataOutputStream = new DataOutputStream(process.getOutputStream());
            String s = command + "\n";
            dataOutputStream.write(s.getBytes(Charset.forName("utf-8")));
            ((DataOutputStream)dataOutputStream).flush();
            ((DataOutputStream)dataOutputStream).writeBytes("exit\n");
            ((DataOutputStream)dataOutputStream).flush();
            process.waitFor();
            errorStream = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String msg = "";
            while ((line = errorStream.readLine()) != null) {
                msg = msg + line;
            }
            Log.d((String)"execFor7", (String)("execFor7 msg is " + msg));
            if (!msg.contains("Failure")) {
                result = true;
            }
        }
        catch (Exception e) {
            Log.e((String)"execFor7", (String)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (dataOutputStream != null) {
                    dataOutputStream.close();
                }
                if (errorStream != null) {
                    errorStream.close();
                }
            }
            catch (IOException e) {
                Log.e((String)"TAG", (String)e.getMessage(), (Throwable)e);
            }
        }
        Utils.execFor7("reboot");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execFor7(String command) {
        Log.d((String)"execFor7", (String)("command = " + command));
        boolean result = false;
        FilterOutputStream dataOutputStream = null;
        BufferedReader errorStream = null;
        try {
            String line;
            Process process = Runtime.getRuntime().exec("su");
            dataOutputStream = new DataOutputStream(process.getOutputStream());
            String s = command + "\n";
            dataOutputStream.write(s.getBytes(Charset.forName("utf-8")));
            ((DataOutputStream)dataOutputStream).flush();
            ((DataOutputStream)dataOutputStream).writeBytes("exit\n");
            ((DataOutputStream)dataOutputStream).flush();
            process.waitFor();
            errorStream = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String msg = "";
            while ((line = errorStream.readLine()) != null) {
                msg = msg + line;
            }
            Log.d((String)"execFor7", (String)("execFor7 msg is " + msg));
            if (!msg.contains("Failure")) {
                result = true;
            }
        }
        catch (Exception e) {
            Log.e((String)"execFor7", (String)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (dataOutputStream != null) {
                    dataOutputStream.close();
                }
                if (errorStream != null) {
                    errorStream.close();
                }
            }
            catch (IOException e) {
                Log.e((String)"TAG", (String)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public static void reboot() {
        Utils.execFor7("reboot");
    }

    public static String getEthernet(Context context) {
        String value = "";
        try {
            Class<?> classType = Class.forName("android.net.EthernetManager");
            Method getMethod = classType.getDeclaredMethod("getIpAddress", new Class[0]);
            Object obj = context.getSystemService("ethernet");
            value = (String)getMethod.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public static Bitmap compressImage(Bitmap image) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        int options = 90;
        while (baos.toByteArray().length / 1024 > 100) {
            baos.reset();
            image.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)baos);
            options -= 10;
        }
        ByteArrayInputStream isBm = new ByteArrayInputStream(baos.toByteArray());
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)isBm, null, null);
        return bitmap;
    }

    public static Bitmap compressScale(Bitmap image) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        baos.reset();
        image.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)baos);
        ByteArrayInputStream isBm = new ByteArrayInputStream(baos.toByteArray());
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)isBm, null, (BitmapFactory.Options)newOpts);
        newOpts.inJustDecodeBounds = false;
        int w = newOpts.outWidth;
        int h = newOpts.outHeight;
        Log.i((String)"Utils", (String)(w + "---------------" + h));
        float hh = 800.0f;
        float ww = 480.0f;
        int be = 1;
        if (w > h && (float)w > ww) {
            be = (int)((float)newOpts.outWidth / ww);
        } else if (w < h && (float)h > hh) {
            be = (int)((float)newOpts.outHeight / hh);
        }
        if (be <= 0) {
            be = 1;
        }
        newOpts.inSampleSize = be;
        newOpts.inPreferredConfig = Bitmap.Config.RGB_565;
        isBm = new ByteArrayInputStream(baos.toByteArray());
        bitmap = BitmapFactory.decodeStream((InputStream)isBm, null, (BitmapFactory.Options)newOpts);
        return Utils.compressImage(bitmap);
    }

    public static void hideBar() {
        try {
            Class<?> classType = Class.forName("com.android.internal.statusbar.IStatusBarService$Stub");
            Method asInterface = classType.getDeclaredMethod("asInterface", IBinder.class);
            Object IStatusBarService = asInterface.invoke(null, Utils.getService("statusbar"));
            Method hideNavigationBar = IStatusBarService.getClass().getDeclaredMethod("hideBar", new Class[0]);
            hideNavigationBar.invoke(IStatusBarService, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void hideNavigationBar() {
        try {
            Class<?> classType = Class.forName("com.android.internal.statusbar.IStatusBarService$Stub");
            Method asInterface = classType.getDeclaredMethod("asInterface", IBinder.class);
            Object IStatusBarService = asInterface.invoke(null, Utils.getService("statusbar"));
            Method hideNavigationBar = IStatusBarService.getClass().getDeclaredMethod("hideNavigationBar", new Class[0]);
            hideNavigationBar.invoke(IStatusBarService, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static IBinder getService(String name) {
        IBinder iBinder = null;
        try {
            Class<?> clz = Class.forName("android.os.ServiceManager");
            Method checkService = clz.getMethod("getService", String.class);
            iBinder = (IBinder)checkService.invoke(clz.newInstance(), name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iBinder;
    }

    public static boolean isRoot() {
        Process process = null;
        DataOutputStream os = null;
        try {
            process = Runtime.getRuntime().exec("su");
            os = new DataOutputStream(process.getOutputStream());
            os.writeBytes("exit\n");
            os.flush();
            int exitValue = process.waitFor();
            return exitValue == 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }
}

