/*
 * Decompiled with CFR 0.152.
 */
package com.example.serialPort;

import android.content.Context;
import android.widget.Toast;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.common.WXModule;
import java.io.File;
import java.util.List;
import me.f1reking.serialportlib.SerialPortHelper;
import me.f1reking.serialportlib.listener.IOpenSerialPortListener;
import me.f1reking.serialportlib.listener.ISerialPortDataListener;
import me.f1reking.serialportlib.listener.Status;

public class UniSerialPort
extends WXModule {
    private SerialPortHelper serialPortHelper = new SerialPortHelper();

    @JSMethod(uiThread=true)
    public void test() {
        Toast.makeText((Context)this.mWXSDKInstance.getContext(), (CharSequence)"d fvv", (int)1).show();
    }

    @JSMethod(uiThread=true)
    public void setPath(String port) {
        this.serialPortHelper.setPort(port);
    }

    @JSMethod(uiThread=true)
    public void setBaudRate(Integer baudRate) {
        this.serialPortHelper.setBaudRate(baudRate.intValue());
    }

    @JSMethod(uiThread=true)
    public void setStopBits(Integer stopBits) {
        this.serialPortHelper.setStopBits(stopBits.intValue());
    }

    @JSMethod(uiThread=true)
    public void setDataBits(Integer dataBits) {
        this.serialPortHelper.setDataBits(dataBits.intValue());
    }

    @JSMethod(uiThread=true)
    public void setParity(Integer parity) {
        this.serialPortHelper.setParity(parity.intValue());
    }

    @JSMethod(uiThread=true)
    public void setFlowCon(Integer flowCon) {
        this.serialPortHelper.setFlowCon(flowCon.intValue());
    }

    @JSMethod(uiThread=true)
    public void setFlags(Integer flags) {
        this.serialPortHelper.setFlags(flags.intValue());
    }

    @JSMethod(uiThread=true)
    public void getAllDeviceList(JSCallback callback) {
        List list = this.serialPortHelper.getAllDevices();
        if (callback != null) {
            callback.invoke((Object)list);
        }
    }

    @JSMethod(uiThread=true)
    public void getAllDevicePath(JSCallback callback) {
        String[] list = this.serialPortHelper.getAllDeicesPath();
        if (callback != null) {
            callback.invoke((Object)list);
        }
    }

    @JSMethod(uiThread=true)
    public void open(final JSCallback callback) {
        this.serialPortHelper.setIOpenSerialPortListener(new IOpenSerialPortListener(){

            public void onSuccess(File device) {
                JSONObject data = new JSONObject();
                data.put("status", (Object)true);
                data.put("msg", (Object)"");
                callback.invoke((Object)data);
            }

            public void onFail(File device, Status status) {
                JSONObject data = new JSONObject();
                data.put("status", (Object)false);
                data.put("msg", (Object)status);
                callback.invoke((Object)data);
            }
        });
        try {
            this.serialPortHelper.open();
        }
        catch (Exception e) {
            JSONObject data = new JSONObject();
            data.put("status", (Object)false);
            data.put("msg", (Object)"NO_READ_WRITE_PERMISSION");
            callback.invoke((Object)data);
        }
    }

    @JSMethod(uiThread=true)
    public void onMessage(final JSCallback callback, final JSCallback sendCallback) {
        this.serialPortHelper.setISerialPortDataListener(new ISerialPortDataListener(){

            public void onDataReceived(byte[] bytes) {
                callback.invokeAndKeepAlive((Object)bytes);
            }

            public void onDataSend(byte[] bytes) {
                if (sendCallback != null) {
                    sendCallback.invokeAndKeepAlive((Object)bytes);
                }
            }
        });
    }

    @JSMethod(uiThread=true)
    public void onMessageHex(final JSCallback callback, final JSCallback sendCallback) {
        this.serialPortHelper.setISerialPortDataListener(new ISerialPortDataListener(){

            public void onDataReceived(byte[] bytes) {
                callback.invokeAndKeepAlive((Object)UniSerialPort.byteToHex(bytes));
            }

            public void onDataSend(byte[] bytes) {
                if (sendCallback != null) {
                    sendCallback.invokeAndKeepAlive((Object)UniSerialPort.byteToHex(bytes));
                }
            }
        });
    }

    @JSMethod(uiThread=true)
    public void onMessageASCII(final JSCallback callback, final JSCallback sendCallback) {
        this.serialPortHelper.setISerialPortDataListener(new ISerialPortDataListener(){

            public void onDataReceived(byte[] bytes) {
                callback.invokeAndKeepAlive((Object)new String(bytes));
            }

            public void onDataSend(byte[] bytes) {
                if (sendCallback != null) {
                    sendCallback.invokeAndKeepAlive((Object)new String(bytes));
                }
            }
        });
    }

    @JSMethod(uiThread=false)
    public static String byteToHex(byte[] bytes) {
        String strHex = "";
        StringBuilder sb = new StringBuilder("");
        for (int n = 0; n < bytes.length; ++n) {
            strHex = Integer.toHexString(bytes[n] & 0xFF);
            sb.append(strHex.length() == 1 ? "0" + strHex : strHex);
        }
        return sb.toString().trim();
    }

    @JSMethod(uiThread=false)
    public boolean isOpen() {
        return this.serialPortHelper.isOpen();
    }

    @JSMethod(uiThread=true)
    public void close() {
        this.serialPortHelper.close();
    }

    @JSMethod(uiThread=true)
    public void sendBytes(byte[] bytes) {
        this.serialPortHelper.sendBytes(bytes);
    }

    @JSMethod(uiThread=true)
    public void sendHex(String hex) {
        this.serialPortHelper.sendHex(hex);
    }

    @JSMethod(uiThread=true)
    public void sendASCII(String string) {
        this.serialPortHelper.sendTxt(string);
    }
}

