/*
 * Decompiled with CFR 0.152.
 */
package jnpf.onlinedev.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.xuyanwu.spring.file.storage.FileInfo;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import jnpf.base.ActionResult;
import jnpf.base.ActionResultCode;
import jnpf.base.controller.SuperController;
import jnpf.base.entity.ModuleEntity;
import jnpf.base.entity.SuperBaseEntity;
import jnpf.base.entity.VisualAliasEntity;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.entity.VisualdevReleaseEntity;
import jnpf.base.model.ColumnDataModel;
import jnpf.base.model.OnlineImport.ExcelImportModel;
import jnpf.base.model.OnlineImport.ImportExcelFieldModel;
import jnpf.base.model.OnlineImport.VisualImportModel;
import jnpf.base.model.OnlineImport.VisualdevModelDataInfoVO;
import jnpf.base.model.VisualDevJsonModel;
import jnpf.base.model.VisualWebTypeEnum;
import jnpf.base.model.flow.DataModel;
import jnpf.base.model.flow.FlowLaunchModel;
import jnpf.base.model.module.PropertyJsonModel;
import jnpf.base.service.ModuleService;
import jnpf.base.service.VisualAliasService;
import jnpf.base.service.VisualdevReleaseService;
import jnpf.base.service.VisualdevService;
import jnpf.base.util.FormExecelUtils;
import jnpf.base.util.VisualUtil;
import jnpf.base.util.VisualUtils;
import jnpf.base.vo.DownloadVO;
import jnpf.base.vo.PaginationVO;
import jnpf.config.ConfigValueUtil;
import jnpf.constant.JnpfConst;
import jnpf.constant.MsgCode;
import jnpf.emnus.ExportModelTypeEnum;
import jnpf.emnus.ModuleTypeEnum;
import jnpf.exception.DataException;
import jnpf.exception.WorkFlowException;
import jnpf.flowable.entity.TaskEntity;
import jnpf.flowable.model.task.FlowModel;
import jnpf.integrate.util.IntegrateUtil;
import jnpf.model.ExcelModel;
import jnpf.model.OnlineDevData;
import jnpf.model.TransferModel;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.FormDataModel;
import jnpf.model.visualJson.UploaderTemplateModel;
import jnpf.model.visualJson.config.HeaderModel;
import jnpf.onlinedev.entity.VisualdevModelDataEntity;
import jnpf.onlinedev.model.AsyncExecuteModel;
import jnpf.onlinedev.model.BaseDevModelVO;
import jnpf.onlinedev.model.BatchRemoveIdsVo;
import jnpf.onlinedev.model.ColumnDataInfoVO;
import jnpf.onlinedev.model.DataInfoVO;
import jnpf.onlinedev.model.OnlineInfoModel;
import jnpf.onlinedev.model.PaginationModel;
import jnpf.onlinedev.model.PaginationModelExport;
import jnpf.onlinedev.model.VisualInfoParam;
import jnpf.onlinedev.model.VisualdevModelDataCrForm;
import jnpf.onlinedev.model.VisualdevModelDataUpForm;
import jnpf.onlinedev.service.VisualDevInfoService;
import jnpf.onlinedev.service.VisualDevListService;
import jnpf.onlinedev.service.VisualPersonalService;
import jnpf.onlinedev.service.VisualdevModelDataService;
import jnpf.onlinedev.util.onlineDevUtil.OnlineDevListUtils;
import jnpf.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import jnpf.onlinedev.util.onlineDevUtil.OnlineSwapDataUtils;
import jnpf.permission.service.UserService;
import jnpf.util.DateUtil;
import jnpf.util.ExcelUtil;
import jnpf.util.FileExport;
import jnpf.util.FileUploadUtils;
import jnpf.util.FileUtil;
import jnpf.util.JsonUtil;
import jnpf.util.RandomUtil;
import jnpf.util.StringUtil;
import jnpf.util.UpUtil;
import jnpf.util.UserProvider;
import jnpf.util.XSSEscape;
import jnpf.util.context.RequestContext;
import jnpf.workflow.service.TaskApi;
import jnpf.workflow.service.TriggerApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="0\u4ee3\u7801\u65e0\u8868\u5f00\u53d1", description="OnlineDev")
@RestController
@RequestMapping(value={"/api/visualdev/OnlineDev"})
public class VisualdevModelDataController
extends SuperController<VisualdevModelDataService, VisualdevModelDataEntity> {
    private static final Logger log = LoggerFactory.getLogger(VisualdevModelDataController.class);
    @Autowired
    private VisualdevModelDataService visualdevModelDataService;
    @Autowired
    private VisualdevService visualdevService;
    @Autowired
    private FileExport fileExport;
    @Autowired
    private VisualDevListService visualDevListService;
    @Autowired
    private VisualDevInfoService visualDevInfoService;
    @Autowired
    private VisualdevReleaseService visualdevReleaseService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private OnlineSwapDataUtils onlineSwapDataUtils;
    @Autowired
    private IntegrateUtil integrateUtil;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private VisualAliasService aliasService;
    @Autowired
    private TaskApi taskApi;
    @Autowired
    private TriggerApi triggerApi;
    @Autowired
    private VisualPersonalService visualPersonalService;
    @Autowired
    private UserService userService;
    private List<Integer> FLOW_STATE_DELETE = ImmutableList.of((Object)0, (Object)9);

    @Operation(summary="\u83b7\u53d6\u6570\u636e\u5217\u8868")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid")})
    @PostMapping(value={"/{modelId}/List"})
    public ActionResult list(@PathVariable(value="modelId") String modelId, @RequestBody PaginationModel paginationModel) throws WorkFlowException {
        StpUtil.checkPermission((String)modelId);
        VisualdevReleaseEntity visualdevEntity = (VisualdevReleaseEntity)this.visualdevReleaseService.getById((Serializable)((Object)modelId));
        VisualDevJsonModel visualJsonModel = OnlinePublicUtils.getVisualJsonModel((VisualdevReleaseEntity)visualdevEntity);
        if (!RequestContext.isOrignPc()) {
            visualJsonModel.setColumnData(visualJsonModel.getAppColumnData());
        }
        ColumnDataModel columnDataModel = visualJsonModel.getColumnData();
        List realList = VisualWebTypeEnum.FORM.getType().equals(visualdevEntity.getWebType()) ? new ArrayList() : (VisualWebTypeEnum.DATA_VIEW.getType().equals(visualdevEntity.getWebType()) ? this.onlineSwapDataUtils.getInterfaceData(visualdevEntity, paginationModel, columnDataModel) : this.visualDevListService.getDataList(visualJsonModel, paginationModel));
        if (OnlineDevData.COLUMNTYPE_THREE.equals(columnDataModel.getType()) && StringUtil.isEmpty((String)paginationModel.getExtraQueryJson())) {
            realList = OnlineDevListUtils.groupData(realList, (ColumnDataModel)columnDataModel);
        }
        if (OnlineDevData.COLUMNTYPE_FIVE.equals(columnDataModel.getType()) && StringUtil.isEmpty((String)paginationModel.getExtraQueryJson())) {
            realList = OnlineDevListUtils.treeListData(realList, (ColumnDataModel)columnDataModel);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)paginationModel, PaginationVO.class);
        return ActionResult.page(realList, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u6811\u5f62\u5f02\u6b65\u67e5\u8be2\u5b50\u5217\u8868\u63a5\u53e3")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid"), @Parameter(name="id", description="\u6570\u636eid")})
    @PostMapping(value={"/{modelId}/List/{id}"})
    public ActionResult listTree(@PathVariable(value="modelId") String modelId, @RequestBody PaginationModel paginationModel, @PathVariable(value="id") String id) throws WorkFlowException {
        StpUtil.checkPermission((String)modelId);
        VisualdevReleaseEntity visualdevEntity = (VisualdevReleaseEntity)this.visualdevReleaseService.getById((Serializable)((Object)modelId));
        VisualDevJsonModel visualJsonModel = OnlinePublicUtils.getVisualJsonModel((VisualdevReleaseEntity)visualdevEntity);
        if (!RequestContext.isOrignPc()) {
            visualJsonModel.setColumnData(visualJsonModel.getAppColumnData());
        }
        List realList = this.visualDevListService.getDataList(visualJsonModel, paginationModel);
        ColumnDataModel columnDataModel = visualJsonModel.getColumnData();
        String parentField = columnDataModel.getParentField() + "_id";
        List collect = realList.stream().filter(item -> id.equals(item.get(parentField))).collect(Collectors.toList());
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)paginationModel, PaginationVO.class);
        return ActionResult.page(collect, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u83b7\u53d6\u5217\u8868\u8868\u5355\u914d\u7f6eJSON")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid"), @Parameter(name="type", description="\u7c7b\u578b0-\u8349\u7a3f\uff0c1-\u53d1\u5e03")})
    @GetMapping(value={"/{modelId}/Config"})
    public ActionResult getData(@PathVariable(value="modelId") String modelId, @RequestParam(value="type", required=false) String type, @RequestParam(value="personal", required=false) Integer personal, @RequestParam(value="menuId", required=false) String menuId) throws WorkFlowException {
        VisualdevEntity entity;
        StpUtil.checkPermissionOr((String[])new String[]{modelId, "onlineDev.webDesign", "generator.webForm", "generator.flowForm"});
        if ("0".equals(type)) {
            entity = this.visualdevService.getInfo(modelId);
        } else {
            VisualdevReleaseEntity releaseEntity = (VisualdevReleaseEntity)this.visualdevReleaseService.getById((Serializable)((Object)modelId));
            entity = (VisualdevEntity)JsonUtil.getJsonToBean((Object)releaseEntity, VisualdevEntity.class);
        }
        if (entity == null) {
            return ActionResult.fail((String)MsgCode.VS412.get(new Object[0]));
        }
        String s = VisualUtil.checkPublishVisualModel((VisualdevEntity)entity, (String)MsgCode.VS005.get(new Object[0]));
        if (s != null) {
            return ActionResult.fail((String)s);
        }
        DataInfoVO vo = (DataInfoVO)JsonUtil.getJsonToBean((Object)entity, DataInfoVO.class);
        if (Objects.equals(entity.getType(), 1) && !VisualWebTypeEnum.DATA_VIEW.getType().equals(entity.getWebType())) {
            vo.setPropsValueList(this.visualdevService.storedFieldList(entity));
        }
        if (Objects.equals(1, personal)) {
            this.visualPersonalService.setDataInfoVO(menuId, vo);
        }
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u83b7\u53d6\u8868\u5355\u914d\u7f6eJSON")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid")})
    @GetMapping(value={"/{modelId}/FormData"})
    public ActionResult<ColumnDataInfoVO> getFormData(@PathVariable(value="modelId") String modelId) {
        StpUtil.checkPermission((String)modelId);
        VisualdevEntity entity = this.visualdevService.getInfo(modelId);
        return ActionResult.success((String)entity.getFormData());
    }

    @Operation(summary="\u83b7\u53d6\u6570\u636e\u4fe1\u606f")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid")})
    @GetMapping(value={"/{modelId}/{id}"})
    public ActionResult info(@PathVariable(value="id") String id, @PathVariable(value="modelId") String modelId) throws DataException {
        StpUtil.checkPermission((String)modelId);
        VisualdevEntity visualdevEntity = this.visualdevService.getReleaseInfo(modelId);
        VisualdevModelDataInfoVO editDataInfo = this.visualDevInfoService.getEditDataInfo(id, visualdevEntity);
        return ActionResult.success((Object)editDataInfo);
    }

    @Operation(summary="\u83b7\u53d6\u6570\u636e\u4fe1\u606f(\u5e26\u8f6c\u6362\u6570\u636e)")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid"), @Parameter(name="id", description="\u6570\u636eid"), @Parameter(name="propsValue", description="\u5b58\u50a8\u5b57\u6bb5\uff08\u975e\u5fc5\u4f20\uff09")})
    @PostMapping(value={"/{modelId}/DataChange"})
    public ActionResult infoWithDataChange(@PathVariable(value="modelId") String modelId, @RequestBody VisualInfoParam visualInfoParam) {
        StpUtil.checkPermission((String)modelId);
        String id = visualInfoParam.getId() instanceof String ? (String)visualInfoParam.getId() : JsonUtil.getObjectToString((Object)visualInfoParam.getId());
        String propsValue = StringUtil.isNotEmpty((String)visualInfoParam.getPropsValue()) && visualInfoParam.getPropsValue().contains(JnpfConst.FIELD_SUFFIX_JNPFID) ? visualInfoParam.getPropsValue().split(JnpfConst.FIELD_SUFFIX_JNPFID)[0] : visualInfoParam.getPropsValue();
        VisualdevEntity visualdevEntity = this.visualdevService.getReleaseInfo(modelId);
        String columnData = RequestContext.isOrignPc() ? visualdevEntity.getColumnData() : visualdevEntity.getAppColumnData();
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)columnData, ColumnDataModel.class);
        if (columnDataModel != null && columnDataModel.getUseBtnPermission().booleanValue()) {
            StpUtil.checkPermission((String)(modelId + "::btn_detail"));
        }
        VisualdevModelDataInfoVO vo = this.visualDevInfoService.getDetailsDataInfo(id, visualdevEntity, OnlineInfoModel.builder().needRlationFiled(true).needSwap(true).propsValue(propsValue).build());
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u6dfb\u52a0\u6570\u636e")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid"), @Parameter(name="visualdevModelDataCrForm", description="\u529f\u80fd\u6570\u636e\u521b\u5efa\u8868\u5355")})
    @PostMapping(value={"/{modelId}"})
    public ActionResult create(@PathVariable(value="modelId") String modelId, @RequestBody VisualdevModelDataCrForm visualdevModelDataCrForm) throws Exception {
        StpUtil.checkPermission((String)modelId);
        VisualdevEntity visualdevEntity = this.visualdevService.getReleaseInfo(modelId);
        String columnData = RequestContext.isOrignPc() ? visualdevEntity.getColumnData() : visualdevEntity.getAppColumnData();
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)columnData, ColumnDataModel.class);
        if (columnDataModel != null && columnDataModel.getUseBtnPermission().booleanValue()) {
            StpUtil.checkPermission((String)(modelId + "::btn_add"));
        }
        Map map = JsonUtil.stringToMap((String)visualdevModelDataCrForm.getData());
        DataModel dataModel = this.visualdevModelDataService.visualCreate(visualdevEntity, map);
        AsyncExecuteModel build = AsyncExecuteModel.builder().modelId(modelId).trigger(Integer.valueOf(1)).dataId((List)ImmutableList.of((Object)dataModel.getMainId())).userInfo(UserProvider.getUser()).build();
        this.integrateUtil.asyncExecute(build);
        return ActionResult.success((String)MsgCode.SU001.get(new Object[0]));
    }

    @Operation(summary="\u4fee\u6539\u6570\u636e")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid"), @Parameter(name="id", description="\u6570\u636eid"), @Parameter(name="visualdevModelDataUpForm", description="\u529f\u80fd\u6570\u636e\u4fee\u6539\u8868\u5355")})
    @PutMapping(value={"/{modelId}/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @PathVariable(value="modelId") String modelId, @RequestBody VisualdevModelDataUpForm visualdevModelDataUpForm) throws Exception {
        StpUtil.checkPermission((String)modelId);
        Map data = JsonUtil.stringToMap((String)visualdevModelDataUpForm.getData());
        VisualdevEntity visualdevEntity = this.visualdevService.getReleaseInfo(modelId);
        String columnData = RequestContext.isOrignPc() ? visualdevEntity.getColumnData() : visualdevEntity.getAppColumnData();
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)columnData, ColumnDataModel.class);
        if (columnDataModel != null && columnDataModel.getUseBtnPermission().booleanValue()) {
            StpUtil.checkPermission((String)(modelId + "::btn_edit"));
        }
        DataModel dataModel = this.visualdevModelDataService.visualUpdate(visualdevEntity, data, id);
        AsyncExecuteModel build = AsyncExecuteModel.builder().modelId(modelId).trigger(Integer.valueOf(2)).dataId((List)ImmutableList.of((Object)id)).dataModel(dataModel).userInfo(UserProvider.getUser()).build();
        this.integrateUtil.asyncExecute(build);
        return ActionResult.success((String)MsgCode.SU004.get(new Object[0]));
    }

    @Operation(summary="\u5220\u9664\u6570\u636e")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid"), @Parameter(name="id", description="\u6570\u636eid")})
    @DeleteMapping(value={"/{modelId}/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id, @PathVariable(value="modelId") String modelId) throws Exception {
        StpUtil.checkPermission((String)modelId);
        VisualdevEntity visualdevEntity = this.visualdevService.getReleaseInfo(modelId);
        String columnData = RequestContext.isOrignPc() ? visualdevEntity.getColumnData() : visualdevEntity.getAppColumnData();
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)columnData, ColumnDataModel.class);
        if (columnDataModel != null && columnDataModel.getUseBtnPermission().booleanValue()) {
            StpUtil.checkPermissionOr((String[])new String[]{modelId + "::btn_remove", modelId + "::btn_batchRemove"});
        }
        VisualDevJsonModel visualJsonModel = OnlinePublicUtils.getVisualJsonModel((VisualdevEntity)visualdevEntity);
        if (!RequestContext.isOrignPc()) {
            visualJsonModel.setColumnData(visualJsonModel.getAppColumnData());
        }
        if (!StringUtil.isEmpty((String)visualdevEntity.getVisualTables()) && !"[]".equals(visualdevEntity.getVisualTables())) {
            if (OnlineDevData.COLUMNTYPE_FIVE.equals(visualJsonModel.getColumnData().getType())) {
                try {
                    Map map;
                    List list;
                    ActionResult listTreeAction = this.listTree(modelId, new PaginationModel(), id);
                    if (listTreeAction != null && listTreeAction.getCode() == 200 && listTreeAction.getData() instanceof Object && (list = JsonUtil.getJsonToListMap((String)(map = (Map)JsonUtil.getJsonToBean((Object)listTreeAction.getData(), Map.class)).get("list").toString())).size() > 0) {
                        for (Map item : list) {
                            this.delete(item.get("id").toString(), modelId);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u5b50\u6570\u636e\u5220\u9664\u5f02\u5e38:{}", (Object)e.getMessage());
                }
            }
            ArrayList<VisualdevModelDataInfoVO> dataInfoVOList = new ArrayList<VisualdevModelDataInfoVO>();
            VisualdevModelDataInfoVO editDataInfo = this.visualDevInfoService.getEditDataInfo(id, visualdevEntity);
            dataInfoVOList.add(editDataInfo);
            List deleteData = this.integrateUtil.dataList(modelId, Integer.valueOf(3), (List)ImmutableList.of((Object)id));
            boolean result = this.visualdevModelDataService.tableDelete(id, visualJsonModel);
            if (result) {
                AsyncExecuteModel build = AsyncExecuteModel.builder().modelId(modelId).trigger(Integer.valueOf(3)).dataId((List)ImmutableList.of((Object)id)).userInfo(UserProvider.getUser()).build();
                this.integrateUtil.asyncExecute(build);
                return ActionResult.success((String)MsgCode.SU003.get(new Object[0]));
            }
            return ActionResult.fail((String)MsgCode.FA003.get(new Object[0]));
        }
        return ActionResult.fail((String)MsgCode.FA003.get(new Object[0]));
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664\u6570\u636e")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid"), @Parameter(name="idsVo", description="\u6279\u91cf\u5904\u7406\u53c2\u6570")})
    @PostMapping(value={"/batchDelete/{modelId}"})
    public ActionResult batchDelete(@RequestBody BatchRemoveIdsVo idsVo, @PathVariable(value="modelId") String modelId) throws Exception {
        StpUtil.checkPermission((String)modelId);
        VisualdevEntity visualdevEntity = this.visualdevService.getReleaseInfo(modelId);
        String columnData = RequestContext.isOrignPc() ? visualdevEntity.getColumnData() : visualdevEntity.getAppColumnData();
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)columnData, ColumnDataModel.class);
        if (columnDataModel != null && columnDataModel.getUseBtnPermission().booleanValue()) {
            StpUtil.checkPermissionOr((String[])new String[]{modelId + "::btn_remove", modelId + "::btn_batchRemove"});
        }
        VisualDevJsonModel visualJsonModel = OnlinePublicUtils.getVisualJsonModel((VisualdevEntity)visualdevEntity);
        if (!RequestContext.isOrignPc()) {
            visualJsonModel.setColumnData(visualJsonModel.getAppColumnData());
        }
        ArrayList<String> idsList = new ArrayList<String>();
        List<String> idsVoList = Arrays.asList(idsVo.getIds());
        String errMess = "";
        for (String id : idsVoList) {
            VisualdevModelDataInfoVO editDataInfo = this.visualDevInfoService.getEditDataInfo(id, visualdevEntity);
            Map map = JsonUtil.stringToMap((String)editDataInfo.getData());
            if (StringUtil.isNotBlank((CharSequence)idsVo.getFlowId())) {
                TaskEntity taskEntity = this.taskApi.getInfoSubmit(map.get("flowTaskId").toString(), new SFunction[]{SuperBaseEntity.SuperIBaseEntity::getId, TaskEntity::getParentId, TaskEntity::getFullName, TaskEntity::getStatus});
                if (taskEntity != null) {
                    try {
                        this.taskApi.delete(taskEntity);
                        idsList.add(id);
                    }
                    catch (Exception e) {
                        errMess = e.getMessage();
                    }
                    continue;
                }
                idsList.add(id);
                continue;
            }
            idsList.add(id);
        }
        if (idsList.size() == 0) {
            return ActionResult.fail((String)errMess);
        }
        List dataInfoVOList = this.integrateUtil.dataList(modelId, Integer.valueOf(3), idsList);
        if (!StringUtil.isEmpty((String)visualdevEntity.getVisualTables()) && !"[]".equals(visualdevEntity.getVisualTables())) {
            ActionResult result = this.visualdevModelDataService.tableDeleteMore(idsList, visualJsonModel);
            AsyncExecuteModel build = AsyncExecuteModel.builder().modelId(modelId).trigger(Integer.valueOf(3)).dataId(idsList).userInfo(UserProvider.getUser()).build();
            this.integrateUtil.asyncExecute(build);
            return result;
        }
        return ActionResult.fail((String)MsgCode.FA003.get(new Object[0]));
    }

    @Operation(summary="\u5bfc\u5165\u6570\u636e")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid"), @Parameter(name="visualImportModel", description="\u5bfc\u5165\u53c2\u6570")})
    @PostMapping(value={"{modelId}/ImportData"})
    public ActionResult<ExcelImportModel> imports(@PathVariable(value="modelId") String modelId, @RequestBody VisualImportModel visualImportModel) throws WorkFlowException {
        StpUtil.checkPermission((String)modelId);
        VisualdevEntity visualdevEntity = this.visualdevService.getReleaseInfo(modelId);
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getColumnData(), ColumnDataModel.class);
        if (columnDataModel != null && columnDataModel.getUseBtnPermission().booleanValue()) {
            StpUtil.checkPermission((String)(modelId + "::btn_upload"));
        }
        VisualDevJsonModel visualJsonModel = OnlinePublicUtils.getVisualJsonModel((VisualdevEntity)visualdevEntity);
        FormDataModel formData = visualJsonModel.getFormData();
        List fieldsModelList = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        ArrayList allFieLds = new ArrayList();
        VisualUtils.recursionFields((List)fieldsModelList, allFieLds);
        visualJsonModel.setFormListModels(allFieLds);
        visualJsonModel.setFlowId(visualImportModel.getFlowId());
        List mapList = VisualUtils.complexImportsDataOnline((List)visualImportModel.getList(), (VisualdevEntity)visualdevEntity);
        ExcelImportModel excelData = this.onlineSwapDataUtils.createExcelData(mapList, visualJsonModel, visualdevEntity);
        List dataInfoList = excelData.getDataInfoList();
        ArrayList<String> addIdList = new ArrayList<String>();
        ArrayList<String> updateIdList = new ArrayList<String>();
        for (VisualdevModelDataInfoVO dataInfoVO : dataInfoList) {
            Integer trigger = StringUtil.isEmpty((String)dataInfoVO.getIntegrateId()) ? 1 : 2;
            if (Objects.equals(trigger, 1)) {
                addIdList.add(dataInfoVO.getId().toString());
                continue;
            }
            updateIdList.add(dataInfoVO.getId().toString());
        }
        List addData = this.integrateUtil.dataList(modelId, Integer.valueOf(1), addIdList);
        this.integrateUtil.asyncList(addData, UserProvider.getUser());
        List updateData = this.integrateUtil.dataList(modelId, Integer.valueOf(2), updateIdList);
        this.integrateUtil.asyncList(updateData, UserProvider.getUser());
        List complexHeaderList = columnDataModel.getComplexHeaderList();
        if (!Objects.equals(columnDataModel.getType(), 3) && !Objects.equals(columnDataModel.getType(), 5)) {
            List mapList1 = VisualUtils.complexHeaderDataHandel((List)excelData.getFailResult(), (List)complexHeaderList, (boolean)false);
            excelData.setFailResult(mapList1);
        }
        return ActionResult.success((Object)excelData);
    }

    @Operation(summary="\u5bfc\u51fa")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid"), @Parameter(name="paginationModelExport", description="\u5bfc\u51fa\u53c2\u6570")})
    @PostMapping(value={"/{modelId}/Actions/ExportData"})
    public ActionResult export(@PathVariable(value="modelId") String modelId, @RequestBody PaginationModelExport paginationModelExport) throws ParseException, IOException, SQLException, DataException {
        DownloadVO vo;
        StpUtil.checkPermission((String)modelId);
        ModuleEntity menuInfo = this.moduleService.getInfo(paginationModelExport.getMenuId());
        VisualdevEntity visualdevEntity = this.visualdevService.getReleaseInfo(modelId);
        if (visualdevEntity == null) {
            ActionResult.fail((String)MsgCode.FA001.get(new Object[0]));
        }
        String excelName = "";
        excelName = menuInfo != null ? menuInfo.getFullName() : visualdevEntity.getFullName();
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getColumnData(), ColumnDataModel.class);
        if (columnDataModel != null && columnDataModel.getUseBtnPermission().booleanValue()) {
            StpUtil.checkPermission((String)(modelId + "::btn_download"));
        }
        VisualDevJsonModel visualJsonModel = OnlinePublicUtils.getVisualJsonModel((VisualdevEntity)visualdevEntity);
        if (!RequestContext.isOrignPc()) {
            visualJsonModel.setColumnData(visualJsonModel.getAppColumnData());
        }
        String[] keys = paginationModelExport.getSelectKey();
        List<String> selectKey = Arrays.asList(paginationModelExport.getSelectKey());
        List<Object> selectIds = Arrays.asList(paginationModelExport.getSelectIds());
        if (VisualWebTypeEnum.DATA_VIEW.getType().equals(visualdevEntity.getWebType())) {
            VisualdevReleaseEntity visualdevREntity = (VisualdevReleaseEntity)JsonUtil.getJsonToBean((Object)visualdevEntity, VisualdevReleaseEntity.class);
            List realList = this.onlineSwapDataUtils.getInterfaceData(visualdevREntity, (PaginationModel)paginationModelExport, visualJsonModel.getColumnData());
            if ("2".equals(paginationModelExport.getDataType()) && StringUtil.isBlank((CharSequence)columnDataModel.getViewKey())) {
                ActionResult.fail((String)MsgCode.VS029.get(new Object[0]));
            }
            realList = "2".equals(paginationModelExport.getDataType()) ? realList.stream().filter(t -> selectIds.contains(t.get(columnDataModel.getViewKey()))).collect(Collectors.toList()) : realList;
            vo = VisualUtils.createModelExcelApiData((String)visualdevEntity.getColumnData(), realList, Arrays.asList(keys), (String)"\u8868\u5355\u4fe1\u606f", (String)excelName, (ExcelModel)new ExcelModel());
        } else {
            ExcelModel excelModel = this.onlineSwapDataUtils.getDefaultValue(visualdevEntity.getFormData(), selectKey);
            List realList = this.visualdevModelDataService.exportData(keys, paginationModelExport, visualJsonModel);
            realList = "2".equals(paginationModelExport.getDataType()) ? realList.stream().filter(t -> selectIds.contains(t.get("id"))).collect(Collectors.toList()) : realList;
            vo = VisualUtils.createModelExcel((VisualdevEntity)visualdevEntity, realList, Arrays.asList(keys), (String)"\u8868\u5355\u4fe1\u606f", (String)excelName, (ExcelModel)excelModel);
        }
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u529f\u80fd\u5bfc\u51fa")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid")})
    @PostMapping(value={"/{modelId}/Actions/Export"})
    @SaCheckPermission(value={"onlineDev.webDesign"})
    public ActionResult exportData(@PathVariable(value="modelId") String modelId) {
        VisualdevEntity visualdevEntity = this.visualdevService.getReleaseInfo(modelId);
        BaseDevModelVO vo = (BaseDevModelVO)JsonUtil.getJsonToBean((Object)visualdevEntity, BaseDevModelVO.class);
        List list = this.aliasService.getList((String)visualdevEntity.getId());
        vo.setAliasListJson(JsonUtil.getObjectToString((Object)list));
        vo.setModelType(ExportModelTypeEnum.Design.getMessage());
        DownloadVO downloadVO = this.fileExport.exportFile((Object)vo, this.configValueUtil.getTemporaryFilePath(), visualdevEntity.getFullName(), ModuleTypeEnum.VISUAL_DEV.getTableName());
        return ActionResult.success((Object)downloadVO);
    }

    @Operation(summary="\u529f\u80fd\u5bfc\u5165")
    @PostMapping(value={"/Actions/Import"}, consumes={"multipart/form-data"})
    @SaCheckPermission(value={"onlineDev.webDesign"})
    public ActionResult ImportData(@RequestParam(value="type") Integer type, @RequestPart(value="file") MultipartFile multipartFile) throws WorkFlowException {
        if (FileUtil.existsSuffix((MultipartFile)multipartFile, (String)ModuleTypeEnum.VISUAL_DEV.getTableName())) {
            return ActionResult.fail((String)MsgCode.IMP002.get(new Object[0]));
        }
        String fileContent = FileUtil.getFileContent((MultipartFile)multipartFile);
        BaseDevModelVO vo = (BaseDevModelVO)JsonUtil.getJsonToBean((String)fileContent, BaseDevModelVO.class);
        VisualdevEntity visualdevEntity = (VisualdevEntity)JsonUtil.getJsonToBean((Object)vo, VisualdevEntity.class);
        StringJoiner errList = new StringJoiner("\u3001");
        String copyNum = UUID.randomUUID().toString().substring(0, 5);
        if (this.visualdevService.getInfo((String)visualdevEntity.getId()) != null) {
            if (Objects.equals(type, 0)) {
                errList.add("ID");
            } else {
                visualdevEntity.setId((Object)RandomUtil.uuId());
            }
        }
        if (this.visualdevService.getObjByEncode(visualdevEntity.getEnCode(), visualdevEntity.getType()) > 0) {
            if (Objects.equals(type, 0)) {
                errList.add(MsgCode.IMP009.get(new Object[0]));
            } else {
                visualdevEntity.setEnCode(visualdevEntity.getEnCode() + copyNum);
            }
        }
        if (this.visualdevService.getCountByName(visualdevEntity.getFullName(), visualdevEntity.getType()) > 0) {
            if (Objects.equals(type, 0)) {
                errList.add(MsgCode.IMP008.get(new Object[0]));
            } else {
                visualdevEntity.setFullName(visualdevEntity.getFullName() + ".\u526f\u672c" + copyNum);
            }
        }
        if (Objects.equals(type, 0) && errList.length() > 0) {
            return ActionResult.fail((String)(String.valueOf(errList) + MsgCode.IMP007.get(new Object[0])));
        }
        if (visualdevEntity.getId() != null) {
            this.visualdevService.setIgnoreLogicDelete().removeById((Serializable)visualdevEntity.getId());
            this.visualdevService.clearIgnoreLogicDelete();
        }
        visualdevEntity.setCreatorTime(DateUtil.getNowDate());
        visualdevEntity.setCreatorUserId(UserProvider.getUser().getUserId());
        visualdevEntity.setLastModifyTime(null);
        visualdevEntity.setLastModifyUserId(null);
        visualdevEntity.setDbLinkId("0");
        visualdevEntity.setState(Integer.valueOf(0));
        this.visualdevService.save((Object)visualdevEntity);
        if (StringUtil.isNotEmpty((String)vo.getAliasListJson())) {
            List jsonToList = JsonUtil.getJsonToList((String)vo.getAliasListJson(), VisualAliasEntity.class);
            for (VisualAliasEntity aliasEntity : jsonToList) {
                this.aliasService.copyEntity(aliasEntity, (String)visualdevEntity.getId());
            }
        }
        return ActionResult.success((String)MsgCode.IMP001.get(new Object[0]));
    }

    @Operation(summary="\u6a21\u677f\u4e0b\u8f7d")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid"), @Parameter(name="menuId", description="\u83dc\u5355id")})
    @GetMapping(value={"/{modelId}/TemplateDownload"})
    public ActionResult<DownloadVO> templateDownload(@PathVariable(value="modelId") String modelId, @RequestParam(value="menuId", required=false) String menuId) {
        StpUtil.checkPermission((String)modelId);
        ModuleEntity menuInfo = this.moduleService.getInfo(menuId);
        VisualdevEntity visualdevEntity = this.visualdevService.getReleaseInfo(modelId);
        if (visualdevEntity == null) {
            ActionResult.fail((String)MsgCode.FA001.get(new Object[0]));
        }
        String menuFullName = "";
        menuFullName = menuInfo != null ? menuInfo.getFullName() : visualdevEntity.getFullName();
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getColumnData(), ColumnDataModel.class);
        if (columnDataModel != null && columnDataModel.getUseBtnPermission().booleanValue()) {
            StpUtil.checkPermission((String)(modelId + "::btn_download"));
        }
        UploaderTemplateModel uploaderTemplateModel = (UploaderTemplateModel)JsonUtil.getJsonToBean((String)columnDataModel.getUploaderTemplateJson(), UploaderTemplateModel.class);
        List selectKey = uploaderTemplateModel.getSelectKey();
        ExcelModel excelModel = this.onlineSwapDataUtils.getDefaultValue(visualdevEntity.getFormData(), selectKey);
        ArrayList<Map> dataList = new ArrayList<Map>();
        dataList.add(excelModel.getDataMap());
        DownloadVO vo = VisualUtils.createModelExcel((VisualdevEntity)visualdevEntity, dataList, (Collection)selectKey, (String)"\u5bfc\u5165\u6a21\u677f", (String)(menuFullName + "\u5bfc\u5165\u6a21\u677f"), (ExcelModel)excelModel);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/Uploader"})
    public ActionResult<Object> Uploader() {
        List list = UpUtil.getFileAll();
        MultipartFile file = (MultipartFile)list.get(0);
        if (file.getOriginalFilename().endsWith(".xlsx") || file.getOriginalFilename().endsWith(".xls")) {
            String filePath = XSSEscape.escape((String)this.configValueUtil.getTemporaryFilePath());
            String fileName = XSSEscape.escape((String)(RandomUtil.uuId() + "." + UpUtil.getFileType((MultipartFile)file)));
            FileInfo fileInfo = FileUploadUtils.uploadFile((MultipartFile)file, (String)filePath, (String)fileName);
            DownloadVO vo = DownloadVO.builder().build();
            vo.setName(fileInfo.getFilename());
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)MsgCode.ETD110.get(new Object[0]));
    }

    @Operation(summary="\u5bfc\u5165\u9884\u89c8")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid"), @Parameter(name="fileName", description="\u6587\u4ef6\u540d")})
    @GetMapping(value={"/{modelId}/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(@PathVariable(value="modelId") String modelId, String fileName) throws Exception {
        StpUtil.checkPermission((String)modelId);
        HashMap<String, List> previewMap = null;
        try {
            VisualdevReleaseEntity entity = (VisualdevReleaseEntity)this.visualdevReleaseService.getById((Serializable)((Object)modelId));
            ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)entity.getColumnData(), ColumnDataModel.class);
            if (columnDataModel != null && columnDataModel.getUseBtnPermission().booleanValue()) {
                StpUtil.checkPermission((String)(modelId + "::btn_upload"));
            }
            FormDataModel formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFormData(), FormDataModel.class);
            UploaderTemplateModel uploaderTemplateModel = (UploaderTemplateModel)JsonUtil.getJsonToBean((String)columnDataModel.getUploaderTemplateJson(), UploaderTemplateModel.class);
            List fieLdsModels = JsonUtil.getJsonToList((String)formDataModel.getFields(), FieLdsModel.class);
            ArrayList allFields = new ArrayList();
            OnlinePublicUtils.recursionFormFields(allFields, (List)fieLdsModels);
            List selectKey = uploaderTemplateModel.getSelectKey();
            Set tablefield1 = selectKey.stream().filter(s -> s.toLowerCase().startsWith("tablefield")).map(s -> s.substring(0, s.indexOf("-"))).collect(Collectors.toSet());
            String filePath = FileUploadUtils.getLocalBasePath() + this.configValueUtil.getTemporaryFilePath();
            FileUploadUtils.downLocal((String)this.configValueUtil.getTemporaryFilePath(), (String)filePath, (String)fileName);
            File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
            String tablefield = selectKey.stream().filter(s -> s.toLowerCase().startsWith("tablefield")).findFirst().orElse(null);
            boolean hasComplex = false;
            for (HeaderModel item : columnDataModel.getComplexHeaderList()) {
                if (item.getChildColumns() == null || item.getChildColumns().size() <= 0) continue;
                ArrayList childColumns = new ArrayList(item.getChildColumns());
                childColumns.retainAll(selectKey);
                if (childColumns.size() <= 0) continue;
                hasComplex = true;
            }
            Integer i = tablefield != null || hasComplex ? 2 : 1;
            InputStream inputStream = ExcelUtil.solveOrginTitle((File)temporary, (Integer)i);
            List excelDataList = ExcelUtil.importExcelByInputStream((InputStream)inputStream, (Integer)0, (Integer)i, Map.class);
            if (excelDataList != null && excelDataList.size() > 1000) {
                return ActionResult.fail((String)MsgCode.ETD117.get(new Object[0]));
            }
            ExcelUtil.imoportExcelToMap((File)temporary, (Integer)i, (List)excelDataList);
            List<HashMap<String, Object>> columns = new ArrayList();
            ArrayList chiImList = new ArrayList();
            ArrayList<ImportExcelFieldModel> allImList = new ArrayList<ImportExcelFieldModel>();
            selectKey.stream().forEach(s -> {
                String requiredStr = "";
                ImportExcelFieldModel importExcel = new ImportExcelFieldModel();
                if (s.toLowerCase().startsWith("tablefield")) {
                    String table = s.substring(0, s.indexOf("-"));
                    String field = s.substring(s.indexOf("-") + 1);
                    FieLdsModel fieLdsModel = allFields.stream().filter(t -> t.getVModel().equals(table)).findFirst().orElse(null);
                    List children = fieLdsModel.getConfig().getChildren();
                    FieLdsModel fieLdsModel1 = children.stream().filter(t -> t.getVModel().equals(field)).findFirst().orElse(null);
                    requiredStr = fieLdsModel1.getConfig().isRequired() ? "*" : "";
                    importExcel.setField(field);
                    importExcel.setTableField(table);
                    importExcel.setFullName(requiredStr + fieLdsModel1.getConfig().getLabel());
                    importExcel.setJnpfKey(fieLdsModel1.getConfig().getJnpfKey());
                    chiImList.add(importExcel);
                } else {
                    FieLdsModel fieLdsModel = allFields.stream().filter(t -> t.getVModel().equals(s)).findFirst().orElse(null);
                    requiredStr = fieLdsModel.getConfig().isRequired() ? "*" : "";
                    importExcel.setField(s);
                    importExcel.setFullName(requiredStr + fieLdsModel.getConfig().getLabel());
                    importExcel.setJnpfKey(fieLdsModel.getConfig().getJnpfKey());
                    allImList.add(importExcel);
                }
            });
            Map groups = chiImList.stream().collect(Collectors.groupingBy(ImportExcelFieldModel::getTableField, LinkedHashMap::new, Collectors.toList()));
            for (Map.Entry entry : groups.entrySet()) {
                ImportExcelFieldModel importExcel = new ImportExcelFieldModel();
                List value = (List)entry.getValue();
                ImportExcelFieldModel im = (ImportExcelFieldModel)value.get(0);
                FieLdsModel fieLdsModel = allFields.stream().filter(f -> ((String)entry.getKey()).equals(f.getVModel())).findFirst().orElse(null);
                String tableName = fieLdsModel.getConfig().getLabel();
                importExcel.setField((String)entry.getKey());
                importExcel.setFullName(tableName);
                importExcel.setJnpfKey("table");
                importExcel.setChildren(value);
                allImList.add(importExcel);
            }
            for (ImportExcelFieldModel importExcel : allImList) {
                HashMap<String, Object> selectMap = new HashMap<String, Object>(16);
                selectMap.put("id", importExcel.getField());
                selectMap.put("fullName", importExcel.getFullName());
                selectMap.put("jnpfKey", importExcel.getJnpfKey());
                if (importExcel.getChildren() != null) {
                    List children = importExcel.getChildren();
                    ArrayList childMapList = new ArrayList();
                    for (ImportExcelFieldModel childIm : children) {
                        HashMap<String, String> childMap = new HashMap<String, String>(16);
                        childMap.put("id", childIm.getField());
                        childMap.put("fullName", childIm.getFullName());
                        childMap.put("jnpfKey", childIm.getJnpfKey());
                        childMapList.add(childMap);
                    }
                    selectMap.put("children", childMapList);
                }
                columns.add(selectMap);
            }
            List results = FormExecelUtils.dataMergeChildTable((List)excelDataList, (List)selectKey);
            previewMap = new HashMap<String, List>();
            List complexHeaderList = columnDataModel.getComplexHeaderList();
            if (!Objects.equals(columnDataModel.getType(), 3) && !Objects.equals(columnDataModel.getType(), 5)) {
                columns = VisualUtils.complexHeaderHandelOnline(columns, (List)complexHeaderList);
            }
            previewMap.put("dataRow", results);
            previewMap.put("headerRow", columns);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ActionResult.fail((String)MsgCode.VS407.get(new Object[0]));
        }
        return ActionResult.success(previewMap);
    }

    @Operation(summary="\u5bfc\u51fa\u5f02\u5e38\u62a5\u544a")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid"), @Parameter(name="visualImportModel", description="\u5bfc\u51fa\u53c2\u6570")})
    @PostMapping(value={"/{modelId}/ImportExceptionData"})
    public ActionResult<DownloadVO> ImportExceptionData(@PathVariable(value="modelId") String modelId, @RequestBody VisualImportModel visualImportModel) {
        VisualdevEntity visualdevEntity;
        ColumnDataModel columnDataModel;
        ModuleEntity menuInfo;
        StpUtil.checkPermission((String)modelId);
        String menuFullName = "";
        if (StringUtil.isNotEmpty((String)visualImportModel.getMenuId()) && (menuInfo = this.moduleService.getInfo(visualImportModel.getMenuId())) != null && StringUtil.isNotEmpty((String)menuInfo.getFullName())) {
            menuFullName = menuInfo.getFullName();
        }
        if ((columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)(visualdevEntity = this.visualdevService.getReleaseInfo(modelId)).getColumnData(), ColumnDataModel.class)) != null && columnDataModel.getUseBtnPermission().booleanValue()) {
            StpUtil.checkPermission((String)(modelId + "::btn_download"));
        }
        UploaderTemplateModel uploaderTemplateModel = (UploaderTemplateModel)JsonUtil.getJsonToBean((String)columnDataModel.getUploaderTemplateJson(), UploaderTemplateModel.class);
        List selectKey = uploaderTemplateModel.getSelectKey();
        ExcelModel excelModel = this.onlineSwapDataUtils.getDefaultValue(visualdevEntity.getFormData(), selectKey);
        DownloadVO vo = VisualUtils.createModelExcel((VisualdevEntity)visualdevEntity, (List)visualImportModel.getList(), (Collection)selectKey, (String)"\u9519\u8bef\u62a5\u544a", (String)(menuFullName + "\u9519\u8bef\u62a5\u544a"), (ExcelModel)excelModel);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u81ea\u5b9a\u4e49\u6309\u94ae\u53d1\u8d77\u5ba1\u6279")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid"), @Parameter(name="visualImportModel", description="\u5bfc\u51fa\u53c2\u6570")})
    @PostMapping(value={"/{modelId}/actionLaunchFlow"})
    public ActionResult<DownloadVO> actionLaunchFlow(@PathVariable(value="modelId") String modelId, @RequestBody FlowLaunchModel model) {
        StpUtil.checkPermission((String)modelId);
        VisualdevEntity visualdevEntity = this.visualdevService.getReleaseInfo(modelId);
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getColumnData(), ColumnDataModel.class);
        if (columnDataModel != null && columnDataModel.getUseBtnPermission().booleanValue()) {
            StpUtil.checkPermission((String)(modelId + "::" + model.getBtnCode()));
        }
        ArrayList<String> userList = new ArrayList<String>();
        if (Objects.equals(1, model.getCurrentUser())) {
            userList.add(UserProvider.getUser().getUserId());
        }
        if (Objects.equals(1, model.getCustomUser()) && CollectionUtil.isNotEmpty((Collection)model.getInitiator())) {
            userList.addAll(this.userService.getUserIdList(model.getInitiator(), null));
            userList = new ArrayList(new HashSet(userList));
        }
        ArrayList formDataList = new ArrayList();
        List dataList = model.getDataList();
        if (CollectionUtil.isNotEmpty((Collection)dataList)) {
            for (List itemList : dataList) {
                if (!CollectionUtil.isNotEmpty((Collection)itemList)) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (TransferModel transferModel : itemList) {
                    map.put(transferModel.getTargetField(), transferModel.getSourceValue());
                }
                formDataList.add(map);
            }
        }
        FlowModel flowModel = new FlowModel();
        flowModel.setTemplateId(model.getTemplate());
        flowModel.setUserIds(userList);
        flowModel.setFormDataList(formDataList);
        ActionResult actionResult = this.taskApi.launchFlow(flowModel);
        if (actionResult == null || !ActionResultCode.Success.getCode().equals(actionResult.getCode())) {
            return ActionResult.fail((String)actionResult.getMsg());
        }
        return ActionResult.success((String)actionResult.getMsg());
    }

    @Operation(summary="\u6839\u636e\u83dc\u5355\u83b7\u53d6\u529f\u80fd\u914d\u7f6e")
    @Parameters(value={@Parameter(name="menuId", description="\u83dc\u5355id")})
    @GetMapping(value={"/Config"})
    public ActionResult getConfigByMenu(@RequestParam(value="menuId", required=false) String menuId, @RequestParam(value="systemId", required=false) String systemId) {
        StpUtil.checkPermissionOr((String[])new String[]{menuId, "onlineDev.webDesign", "generator.webForm", "generator.flowForm"});
        VisualdevReleaseEntity releaseEntity = null;
        ModuleEntity info = this.moduleService.getInfo(menuId);
        if (info != null && StringUtil.isNotEmpty((String)info.getPropertyJson())) {
            PropertyJsonModel propertyJsonModel = (PropertyJsonModel)JsonUtil.getJsonToBean((String)info.getPropertyJson(), PropertyJsonModel.class);
            String modelId = propertyJsonModel.getModuleId();
            releaseEntity = (VisualdevReleaseEntity)this.visualdevReleaseService.getById((Serializable)((Object)modelId));
        }
        if (releaseEntity == null || StringUtil.isNotEmpty((String)systemId) && !Objects.equals(info.getSystemId(), systemId)) {
            return ActionResult.fail((String)MsgCode.FA001.get(new Object[0]));
        }
        VisualdevEntity entity = (VisualdevEntity)JsonUtil.getJsonToBean(releaseEntity, VisualdevEntity.class);
        String s = VisualUtil.checkPublishVisualModel((VisualdevEntity)entity, (String)MsgCode.VS005.get(new Object[0]));
        if (s != null) {
            return ActionResult.fail((String)s);
        }
        DataInfoVO vo = (DataInfoVO)JsonUtil.getJsonToBean((Object)entity, DataInfoVO.class);
        return ActionResult.success((Object)vo);
    }
}

