/*
 * Decompiled with CFR 0.152.
 */
package jnpf.onlinedev.util.onlineDevUtil;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jnpf.base.ActionResult;
import jnpf.base.UserInfo;
import jnpf.base.entity.DataInterfaceEntity;
import jnpf.base.entity.DictionaryDataEntity;
import jnpf.base.entity.ProvinceEntity;
import jnpf.base.entity.SuperBaseEntity;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.entity.VisualdevReleaseEntity;
import jnpf.base.mapper.FlowFormDataMapper;
import jnpf.base.model.ColumnDataModel;
import jnpf.base.model.OnlineImport.ExcelImportModel;
import jnpf.base.model.OnlineImport.ImportDataModel;
import jnpf.base.model.OnlineImport.ImportFormCheckUniqueModel;
import jnpf.base.model.OnlineImport.VisualdevModelDataInfoVO;
import jnpf.base.model.VisualDevJsonModel;
import jnpf.base.model.datainterface.DataInterfaceModel;
import jnpf.base.model.datainterface.DataInterfacePage;
import jnpf.base.model.flow.DataModel;
import jnpf.base.service.DataInterfaceService;
import jnpf.base.service.DbLinkService;
import jnpf.base.service.DictionaryDataService;
import jnpf.base.service.ProvinceService;
import jnpf.base.service.VisualdevService;
import jnpf.base.util.DateTimeFormatConstant;
import jnpf.base.util.FlowFormDataUtil;
import jnpf.base.util.FormCheckUtils;
import jnpf.base.util.FormInfoUtils;
import jnpf.base.util.FormPublicUtils;
import jnpf.base.util.VisualUtils;
import jnpf.base.vo.PageListVO;
import jnpf.base.vo.PaginationVO;
import jnpf.constant.JnpfConst;
import jnpf.constant.MsgCode;
import jnpf.database.model.entity.DbLinkEntity;
import jnpf.database.util.DynamicDataSourceUtil;
import jnpf.exception.DataException;
import jnpf.exception.WorkFlowException;
import jnpf.flowable.entity.TaskEntity;
import jnpf.flowable.entity.TemplateJsonEntity;
import jnpf.model.ExcelColumnAttr;
import jnpf.model.ExcelModel;
import jnpf.model.visualJson.AbleUtil;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.FormDataModel;
import jnpf.model.visualJson.OnlineCusCheckModel;
import jnpf.model.visualJson.TableFields;
import jnpf.model.visualJson.TableModel;
import jnpf.model.visualJson.TemplateJsonModel;
import jnpf.model.visualJson.UploaderTemplateModel;
import jnpf.model.visualJson.config.ConfigModel;
import jnpf.model.visualJson.config.RegListModel;
import jnpf.model.visualJson.props.PropsModel;
import jnpf.onlinedev.model.OnlineDevEnum.CacheKeyEnum;
import jnpf.onlinedev.model.OnlineDevEnum.MultipleControlEnum;
import jnpf.onlinedev.model.OnlineDevEnum.OnlineDataTypeEnum;
import jnpf.onlinedev.model.OnlineDevListModel.InterefaceParamModel;
import jnpf.onlinedev.model.OnlineInfoModel;
import jnpf.onlinedev.model.PaginationModel;
import jnpf.onlinedev.model.VisualErrInfo;
import jnpf.onlinedev.service.VisualDevInfoService;
import jnpf.onlinedev.service.VisualdevModelDataService;
import jnpf.onlinedev.util.onlineDevUtil.OnlineDevInfoUtils;
import jnpf.onlinedev.util.onlineDevUtil.OnlineExecutor;
import jnpf.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import jnpf.permission.entity.OrganizeEntity;
import jnpf.permission.entity.OrganizeRelationEntity;
import jnpf.permission.entity.UserRelationEntity;
import jnpf.permission.model.authorize.AuthorizeConditionEnum;
import jnpf.permission.model.organize.OrganizeConditionModel;
import jnpf.permission.model.organize.OrganizeModel;
import jnpf.permission.service.GroupService;
import jnpf.permission.service.OrganizeAdministratorService;
import jnpf.permission.service.OrganizeRelationService;
import jnpf.permission.service.OrganizeService;
import jnpf.permission.service.PositionService;
import jnpf.permission.service.RoleService;
import jnpf.permission.service.UserRelationService;
import jnpf.permission.service.UserService;
import jnpf.util.DateUtil;
import jnpf.util.JsonUtil;
import jnpf.util.RandomUtil;
import jnpf.util.RedisUtil;
import jnpf.util.StringUtil;
import jnpf.util.TableFeildsEnum;
import jnpf.util.TenantHolder;
import jnpf.util.UserProvider;
import jnpf.util.XSSEscape;
import jnpf.util.visiual.JnpfKeyConsts;
import jnpf.workflow.service.TaskApi;
import jnpf.workflow.service.TemplateApi;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.render.RenderingStrategies;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.join.EqualTo;
import org.mybatis.dynamic.sql.select.join.JoinCondition;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OnlineSwapDataUtils {
    private static final Logger log = LoggerFactory.getLogger(OnlineSwapDataUtils.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private DictionaryDataService dictionaryDataApi;
    @Autowired
    private UserService userApi;
    @Autowired
    private PositionService positionApi;
    @Autowired
    private ProvinceService areaApi;
    @Autowired
    private OrganizeService organizeApi;
    @Autowired
    private OrganizeAdministratorService organizeAdministratorService;
    @Autowired
    private VisualdevService visualdevService;
    @Autowired
    private VisualdevModelDataService visualdevModelDataService;
    @Autowired
    private DataInterfaceService dataInterFaceApi;
    @Autowired
    private VisualDevInfoService visualDevInfoService;
    @Autowired
    private RoleService roleApi;
    @Autowired
    private GroupService groupApi;
    @Autowired
    private DbLinkService dataSourceApi;
    @Autowired
    private OnlineDevInfoUtils onlineDevInfoUtils;
    @Autowired
    private FlowFormDataMapper flowFormDataMapper;
    @Autowired
    private UserRelationService userRelationApi;
    @Autowired
    private OrganizeRelationService organizeRelationApi;
    @Autowired
    private FlowFormDataUtil flowDataUtil;
    @Autowired
    private OnlineExecutor executor;
    @Autowired
    private ProvinceService provinceService;
    @Autowired
    private FormCheckUtils formCheckUtils;
    @Autowired
    private TemplateApi templateApi;
    @Autowired
    private TaskApi taskApi;
    public static final long DEFAULT_CACHE_TIME = 300L;
    public static final boolean NEEDCACHE_SYS = true;
    public static final boolean NEEDCACHE_REMOTE = true;
    public static final boolean NEEDCACHE_RELATION = true;

    public List<Map<String, Object>> getSwapList(List<Map<String, Object>> list, List<FieLdsModel> swapDataVoList, String visualDevId, Boolean inlineEdit) {
        if (list.isEmpty()) {
            return list;
        }
        return this.getSwapList(list, swapDataVoList, visualDevId, inlineEdit, null, true, null);
    }

    public List<Map<String, Object>> getSwapInfo(List<Map<String, Object>> list, List<FieLdsModel> swapDataVoList, String visualDevId, Boolean inlineEdit, Map<String, Object> mainAndMast) {
        if (list.isEmpty()) {
            return list;
        }
        return this.getSwapList(list, swapDataVoList, visualDevId, inlineEdit, null, false, mainAndMast);
    }

    public List<Map<String, Object>> getSwapList(List<Map<String, Object>> list, List<FieLdsModel> swapDataVoList, String visualDevId, Boolean inlineEdit, Map<String, Object> localCacheParent, boolean isList, Map<String, Object> mainAndMast) {
        try {
            DynamicDataSourceUtil.switchToDataSource(null);
            if (list.isEmpty()) {
                List<Map<String, Object>> list2 = list;
                return list2;
            }
            Map localCache = Optional.ofNullable(localCacheParent).orElse(new ConcurrentHashMap());
            this.executor.executorRedis(localCache, swapDataVoList, visualDevId, inlineEdit, list, mainAndMast);
            String dsName = Optional.ofNullable(TenantHolder.getDatasourceId()).orElse("");
            this.writeRedisAndList(localCache, swapDataVoList, dsName, visualDevId, inlineEdit, list, isList, mainAndMast);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            DynamicDataSourceUtil.clearSwitchDataSource();
        }
        return list;
    }

    private List<Map<String, Object>> writeRedisAndList(Map<String, Object> localCache, List<FieLdsModel> swapDataVoList, String dsName, String visualDevId, Boolean inlineEdit, List<Map<String, Object>> list, boolean isList, Map<String, Object> mainAndMast) {
        Map userMap = (Map)localCache.get("__user_map");
        Map orgMap = (Map)localCache.get("__org_map");
        Map posMap = (Map)localCache.get("__pos_map");
        Map orgTreeMap = (Map)localCache.get("__orgTree_map");
        Map roleMap = (Map)localCache.get("__role_map");
        Map groupMap = (Map)localCache.get("__group_map");
        List proMapList = (List)localCache.get("__pro_maplist");
        ArrayList arrJnpfKey = new ArrayList(){
            {
                this.add("uploadFile");
                this.add("uploadImg");
            }
        };
        for (int x = 0; x < list.size(); ++x) {
            Map<String, Object> dataMap = list.get(x);
            if (dataMap == null) {
                dataMap = new HashMap<String, Object>();
                list.set(x, dataMap);
            }
            HashMap<String, Object> dataCopyMap = new HashMap<String, Object>(dataMap);
            for (FieLdsModel swapDataVo : swapDataVoList) {
                String jnpfKey = swapDataVo.getConfig().getJnpfKey();
                if (StringUtil.isEmpty((String)swapDataVo.getVModel())) continue;
                String swapVModel = swapDataVo.getVModel();
                String vModel = inlineEdit != false && isList ? swapDataVo.getVModel() + "_name" : swapDataVo.getVModel();
                String dataType = swapDataVo.getConfig().getDataType();
                Boolean isMultiple = Objects.nonNull(swapDataVo.getMultiple()) ? swapDataVo.getMultiple() : false;
                FormInfoUtils.swapClob(dataMap, (String)swapDataVo.getVModel());
                try {
                    HashMap<String, Map<String, Object>> dataDetailMap = new HashMap<String, Map<String, Object>>();
                    FormPublicUtils.relationGetJnpfId(dataMap, (String)jnpfKey, (Object)dataMap.get(swapVModel), (String)swapVModel);
                    if (StringUtil.isEmpty((String)String.valueOf(dataMap.get(swapVModel))) || String.valueOf(dataMap.get(swapVModel)).equals("[]") || String.valueOf(dataMap.get(swapVModel)).equals("null")) {
                        if (jnpfKey.equals("table")) {
                            dataMap.put(vModel, new ArrayList());
                            continue;
                        }
                        if (arrJnpfKey.contains(jnpfKey)) {
                            dataMap.put(swapVModel, new ArrayList());
                            continue;
                        }
                        if (inlineEdit.booleanValue()) {
                            dataMap.put(swapVModel, null);
                        }
                        dataMap.put(vModel, null);
                        continue;
                    }
                    String separator = swapDataVo.getSeparator();
                    switch (jnpfKey) {
                        case "calculate": 
                        case "inputNumber": {
                            Object decimalValue = dataCopyMap.get(swapDataVo.getVModel());
                            Integer precision = swapDataVo.getPrecision();
                            if (decimalValue instanceof BigDecimal) {
                                BigDecimal bd = (BigDecimal)decimalValue;
                                String value = bd.toPlainString();
                                ImmutableList IntegerType = ImmutableList.of((Object)3, (Object)4);
                                if (!IntegerType.contains(swapDataVo.getRoundType())) {
                                    if (precision != null && precision > 0) {
                                        String formatZ = "000000000000000";
                                        String format = formatZ.substring(0, precision);
                                        DecimalFormat decimalFormat = new DecimalFormat("0." + format);
                                        value = decimalFormat.format(bd);
                                    } else {
                                        value = String.valueOf(bd.stripTrailingZeros().toPlainString());
                                    }
                                } else {
                                    value = bd.stripTrailingZeros().toPlainString();
                                }
                                dataMap.put(vModel, value);
                                break;
                            }
                            dataMap.put(vModel, decimalValue);
                            break;
                        }
                        case "organizeSelect": 
                        case "depSelect": 
                        case "currDept": {
                            dataMap.put(vModel, OnlinePublicUtils.getDataInMethod(orgMap, dataMap.get(swapVModel), isMultiple));
                            break;
                        }
                        case "currOrganize": {
                            String orgIds = String.valueOf(dataMap.get(swapVModel));
                            String orgName = " ";
                            List jsonToList = new ArrayList<String>();
                            try {
                                jsonToList = JsonUtil.getJsonToList((String)orgIds, String.class);
                            }
                            catch (Exception e) {
                                jsonToList.add(orgIds);
                            }
                            if (!jsonToList.isEmpty()) {
                                if ("all".equals(swapDataVo.getShowLevel())) {
                                    orgName = orgTreeMap.get(StringUtils.join(jsonToList, (String)",")) != null ? orgTreeMap.get(StringUtils.join(jsonToList, (String)",")).toString() : "";
                                } else {
                                    OrganizeEntity organizeEntity;
                                    String orgId = (String)jsonToList.get(jsonToList.size() - 1);
                                    OrganizeEntity organizeEntity2 = organizeEntity = StringUtil.isNotEmpty((String)orgId) ? this.organizeApi.getInfo(orgId) : null;
                                    if (organizeEntity != null && "department".equals(organizeEntity.getCategory())) {
                                        orgName = organizeEntity.getFullName();
                                    }
                                }
                            }
                            dataMap.put(vModel, orgName);
                            break;
                        }
                        case "posSelect": 
                        case "currPosition": {
                            String posData = OnlinePublicUtils.getDataInMethod(posMap, dataMap.get(swapVModel), isMultiple);
                            if (ObjectUtil.isEmpty((Object)dataMap.get(swapVModel))) {
                                dataMap.put(vModel, " ");
                                break;
                            }
                            dataMap.put(vModel, posData);
                            break;
                        }
                        case "userSelect": 
                        case "createUser": 
                        case "modifyUser": {
                            String userData = OnlinePublicUtils.getDataInMethod(userMap, dataMap.get(swapVModel), isMultiple);
                            dataMap.put(vModel, userData);
                            break;
                        }
                        case "usersSelect": {
                            List<String> dataNoSwapInMethod = OnlinePublicUtils.getDataNoSwapInMethod(dataMap.get(swapVModel));
                            StringJoiner valueJoin = new StringJoiner(",");
                            for (String data : dataNoSwapInMethod) {
                                String type;
                                String id = data.contains("--") ? data.substring(0, data.lastIndexOf("--")) : data;
                                valueJoin.add(Optional.ofNullable((switch (type = data.contains("--") ? data.substring(data.lastIndexOf("--") + 2) : "") {
                                    case "role" -> roleMap;
                                    case "position" -> posMap;
                                    case "company", "department" -> orgMap;
                                    case "group" -> groupMap;
                                    default -> userMap;
                                }).get(id)).orElse("").toString());
                            }
                            dataMap.put(vModel, valueJoin.toString());
                            break;
                        }
                        case "roleSelect": {
                            String roleData = OnlinePublicUtils.getDataInMethod(roleMap, dataMap.get(swapVModel), isMultiple);
                            dataMap.put(vModel, roleData);
                            break;
                        }
                        case "groupSelect": {
                            String groupData = OnlinePublicUtils.getDataInMethod(groupMap, dataMap.get(swapVModel), isMultiple);
                            dataMap.put(vModel, groupData);
                            break;
                        }
                        case "areaSelect": {
                            String addressValue = String.valueOf(dataMap.get(swapVModel));
                            if (OnlinePublicUtils.getMultiple(addressValue, MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar()).booleanValue()) {
                                String[][] data = (String[][])JsonUtil.getJsonToBean((String)addressValue, String[][].class);
                                List proDataS = Arrays.stream(data).flatMap(Arrays::stream).collect(Collectors.toList());
                                Map provinceNames = this.provinceService.getProList(proDataS).stream().collect(Collectors.toMap(SuperBaseEntity.SuperIBaseEntity::getId, ProvinceEntity::getFullName, (k1, k2) -> k2, () -> new LinkedHashMap(proDataS.size(), 1.0f)));
                                ArrayList<String> addList = new ArrayList<String>();
                                for (String[] AddressData : data) {
                                    ArrayList<String> adList = new ArrayList<String>();
                                    for (int i = 0; i < AddressData.length; ++i) {
                                        String addressDatum = AddressData[i];
                                        String value = provinceNames.getOrDefault(addressDatum, "");
                                        adList.add(value);
                                    }
                                    addList.add(String.join((CharSequence)"/", adList));
                                }
                                dataMap.put(vModel, String.join((CharSequence)";", addList));
                                break;
                            }
                            if (!OnlinePublicUtils.getMultiple(addressValue, MultipleControlEnum.MULTIPLE_JSON_ONE.getMultipleChar()).booleanValue()) break;
                            List proDataS = JsonUtil.getJsonToList((String)String.valueOf(dataMap.get(swapVModel)), String.class);
                            Map provinceNames = this.provinceService.getProList(proDataS).stream().collect(Collectors.toMap(SuperBaseEntity.SuperIBaseEntity::getId, ProvinceEntity::getFullName, (k1, k2) -> k2, () -> new LinkedHashMap(proDataS.size(), 1.0f)));
                            ArrayList<String> adList = new ArrayList<String>();
                            for (int i = 0; i < proDataS.size(); ++i) {
                                String addressDatum = (String)proDataS.get(i);
                                String value = provinceNames.getOrDefault(addressDatum, "");
                                adList.add(value);
                            }
                            dataMap.put(vModel, String.join((CharSequence)"/", adList));
                            break;
                        }
                        case "switch": {
                            String switchValue = String.valueOf(dataMap.get(swapVModel)).equals("1") ? swapDataVo.getActiveTxt() : swapDataVo.getInactiveTxt();
                            dataMap.put(vModel, switchValue);
                            break;
                        }
                        case "cascader": 
                        case "radio": 
                        case "checkbox": 
                        case "select": 
                        case "treeSelect": {
                            String redisKey;
                            String interfaceChildren;
                            if (StringUtil.isEmpty((String)separator)) {
                                separator = "/";
                            }
                            if ("checkbox".equals(jnpfKey)) {
                                isMultiple = true;
                            }
                            boolean DynamicNeedCache = swapDataVo.getConfig().getTemplateJson().size() == 0;
                            String interfacelabel = swapDataVo.getProps().getLabel() != null ? swapDataVo.getProps().getLabel() : "";
                            String interfaceValue = swapDataVo.getProps().getValue() != null ? swapDataVo.getProps().getValue() : "";
                            String string = interfaceChildren = swapDataVo.getProps().getChildren() != null ? swapDataVo.getProps().getChildren() : "";
                            if (DynamicNeedCache) {
                                Map<String, Object> cascaderMap;
                                redisKey = OnlineDataTypeEnum.STATIC.getType().equals(dataType) ? String.format("%s-%s-%s", visualDevId, swapDataVo.getConfig().getRelationTable() + swapDataVo.getVModel(), OnlineDataTypeEnum.STATIC.getType()) : (dataType.equals(OnlineDataTypeEnum.DYNAMIC.getType()) ? String.format("%s-%s-%s-%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl(), interfaceValue, interfacelabel, interfaceChildren) : String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DICTIONARY.getType(), swapDataVo.getConfig().getDictionaryType()));
                                if (dataType.equals(OnlineDataTypeEnum.DICTIONARY.getType())) {
                                    List checkBoxList = (List)localCache.get(redisKey);
                                    cascaderMap = OnlinePublicUtils.getDataMap(checkBoxList, swapDataVo);
                                } else {
                                    cascaderMap = (Map<String, Object>)localCache.get(redisKey);
                                }
                                dataMap.put(vModel, FormPublicUtils.getDataConversion(cascaderMap, (Object)dataMap.get(swapVModel), (boolean)isMultiple, (String)separator));
                                break;
                            }
                            List templateJsonModels = JsonUtil.getJsonToList((Object)swapDataVo.getConfig().getTemplateJson(), TemplateJsonModel.class);
                            HashMap<String, String> paramMap = new HashMap<String, String>();
                            for (TemplateJsonModel templateJsonModel : templateJsonModels) {
                                String obj;
                                String relationField = Objects.isNull(templateJsonModel.getRelationField()) ? "" : templateJsonModel.getRelationField();
                                String Field2 = templateJsonModel.getField();
                                String string2 = obj = inlineEdit != false ? "" : Optional.ofNullable(dataCopyMap.get(relationField)).orElse("").toString();
                                if (templateJsonModel.getSourceType() != null && !Objects.equals(templateJsonModel.getSourceType(), 1)) {
                                    String dataValue = this.paramSourceTypeReplaceValue(templateJsonModel, dataCopyMap);
                                    paramMap.put(Field2, dataValue);
                                    continue;
                                }
                                if (relationField.toLowerCase().contains("tablefield")) {
                                    String childField = relationField.split("-")[1];
                                    obj = Optional.ofNullable(dataCopyMap.get(childField)).orElse("").toString();
                                } else if (mainAndMast != null) {
                                    obj = Optional.ofNullable(mainAndMast.get(relationField)).orElse("").toString();
                                }
                                paramMap.put(Field2, obj);
                            }
                            Object dataList = null;
                            ArrayList<Map<String, Object>> options = new ArrayList<Map<String, Object>>();
                            HashMap dataInterfaceMap = new HashMap();
                            redisKey = String.format("%s-%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl(), Base64.getEncoder().encodeToString(JsonUtil.getObjectToString(paramMap).getBytes(StandardCharsets.UTF_8)));
                            if (localCache.containsKey(redisKey) || this.redisUtil.exists(redisKey)) {
                                if (localCache.containsKey(redisKey)) {
                                    dataList = (List)localCache.get(redisKey);
                                } else {
                                    List tmpList = this.redisUtil.get(redisKey, 0L, -1L);
                                    ArrayList tmpMapList = new ArrayList();
                                    tmpList.forEach(item -> tmpMapList.add(JsonUtil.entityToMap((Object)item)));
                                    dataList = tmpMapList;
                                    localCache.put(redisKey, dataList);
                                }
                            } else {
                                ActionResult data = this.dataInterFaceApi.infoToId(swapDataVo.getConfig().getPropsUrl(), null, paramMap);
                                if (data != null && data.getData() != null && data.getData() instanceof List) {
                                    dataList = (List)data.getData();
                                    if (CollectionUtils.isNotEmpty((Collection)dataList) && !"treeSelect".equals(jnpfKey) && swapDataVo.getConfig().getUseCache().booleanValue()) {
                                        this.redisUtil.insert(redisKey, dataList, 300L);
                                    }
                                    localCache.put(redisKey, dataList);
                                }
                            }
                            if (dataList != null) {
                                JSONArray dataAll = JsonUtil.getListToJsonArray((List)dataList);
                                OnlineSwapDataUtils.treeToList(interfacelabel, interfaceValue, interfaceChildren, dataAll, options);
                                options.stream().forEach(o -> dataInterfaceMap.put(String.valueOf(o.get(interfaceValue)), String.valueOf(o.get(interfacelabel))));
                            }
                            dataMap.put(vModel, FormPublicUtils.getDataConversion(dataInterfaceMap, (Object)dataMap.get(swapVModel), (boolean)isMultiple, (String)separator));
                            break;
                        }
                        case "relationForm": {
                            String redisKey = String.format("%s-%s-%s-%s-%s", dsName, "relationForm", swapDataVo.getModelId(), swapDataVo.getRelationField(), dataMap.get(swapDataVo.getVModel()));
                            VisualdevModelDataInfoVO infoVO = null;
                            if (localCache.containsKey(redisKey) || this.redisUtil.exists(redisKey)) {
                                infoVO = new VisualdevModelDataInfoVO();
                                if (localCache.containsKey(redisKey)) {
                                    infoVO.setData(localCache.get(redisKey).toString());
                                } else {
                                    infoVO.setData(this.redisUtil.getString(redisKey).toString());
                                    localCache.put(redisKey, infoVO.getData());
                                }
                            } else {
                                String propsValue;
                                String keyId = String.valueOf(dataMap.get(swapVModel));
                                VisualdevEntity entity = this.visualdevService.getInfo(swapDataVo.getModelId());
                                String string = propsValue = StringUtil.isNotEmpty((String)swapDataVo.getPropsValue()) && swapDataVo.getPropsValue().contains(JnpfConst.FIELD_SUFFIX_JNPFID) ? swapDataVo.getPropsValue().split(JnpfConst.FIELD_SUFFIX_JNPFID)[0] : swapDataVo.getPropsValue();
                                if (Objects.nonNull(entity)) {
                                    infoVO = !StringUtil.isEmpty((String)entity.getVisualTables()) && !"[]".equals(entity.getVisualTables()) ? this.visualDevInfoService.getDetailsDataInfo(keyId, entity, OnlineInfoModel.builder().needSwap(true).needRlationFiled(false).propsValue(propsValue).build()) : this.visualdevModelDataService.infoDataChange(keyId, entity);
                                }
                                String data = infoVO == null ? "" : infoVO.getData();
                                this.redisUtil.insert(redisKey, (Object)data, 300L);
                                localCache.put(redisKey, data);
                            }
                            if (infoVO == null || !StringUtil.isNotEmpty((String)infoVO.getData())) break;
                            Map formDataMap = JsonUtil.stringToMap((String)infoVO.getData());
                            String relationField = swapDataVo.getRelationField();
                            if (formDataMap == null || formDataMap.size() <= 0) break;
                            dataMap.put(swapDataVo.getVModel() + "_id", dataMap.get(swapVModel));
                            dataMap.put(vModel, formDataMap.get(relationField));
                            dataDetailMap.put(vModel, formDataMap);
                            break;
                        }
                        case "popupSelect": 
                        case "popupTableSelect": {
                            ArrayList mapList;
                            Object obj;
                            List templateJsonModels = JsonUtil.getJsonToList((String)swapDataVo.getTemplateJson(), TemplateJsonModel.class);
                            HashMap popMaps = new HashMap();
                            String value = String.valueOf(dataMap.get(swapVModel));
                            ArrayList<DataInterfaceModel> listParam = new ArrayList<DataInterfaceModel>();
                            for (TemplateJsonModel templateJsonModel : templateJsonModels) {
                                String relationField = templateJsonModel.getRelationField();
                                DataInterfaceModel dataInterfaceModel = (DataInterfaceModel)JsonUtil.getJsonToBean((Object)templateJsonModel, DataInterfaceModel.class);
                                if (templateJsonModel.getSourceType() != null && !Objects.equals(templateJsonModel.getSourceType(), 1)) {
                                    String dataValue = this.paramSourceTypeReplaceValue(templateJsonModel, dataCopyMap);
                                    dataInterfaceModel.setDefaultValue((Object)dataValue);
                                    listParam.add(dataInterfaceModel);
                                    continue;
                                }
                                Object object = obj = inlineEdit != false ? "" : Optional.ofNullable(dataCopyMap.get(relationField)).orElse("").toString();
                                if (relationField.toLowerCase().contains("tablefield")) {
                                    String childField = relationField.split("-")[1];
                                    obj = Optional.ofNullable(dataCopyMap.get(childField)).orElse("").toString();
                                } else if (mainAndMast != null) {
                                    obj = Optional.ofNullable(mainAndMast.get(relationField)).orElse("").toString();
                                }
                                dataInterfaceModel.setDefaultValue(obj);
                                listParam.add(dataInterfaceModel);
                            }
                            DataInterfacePage dataInterfacePage = new DataInterfacePage();
                            dataInterfacePage.setParamList(listParam);
                            dataInterfacePage.setInterfaceId(swapDataVo.getInterfaceId());
                            List<String> ids = new ArrayList<String>();
                            if (value.startsWith("[")) {
                                ids = JsonUtil.getJsonToList((String)value, String.class);
                            } else {
                                ids.add(value);
                            }
                            dataInterfacePage.setIds(ids);
                            String redisKey = String.format("%s-%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getInterfaceId(), Base64.getEncoder().encodeToString(JsonUtil.getObjectToString((Object)dataInterfacePage).getBytes(StandardCharsets.UTF_8)));
                            if (localCache.containsKey(redisKey) || this.redisUtil.exists(redisKey)) {
                                if (localCache.containsKey(redisKey)) {
                                    mapList = (ArrayList)localCache.get(redisKey);
                                } else {
                                    List tmpList = this.redisUtil.get(redisKey, 0L, -1L);
                                    ArrayList tmpMapList = new ArrayList();
                                    tmpList.forEach(item -> tmpMapList.add(JsonUtil.entityToMap((Object)item)));
                                    mapList = tmpMapList;
                                    localCache.put(redisKey, mapList);
                                }
                            } else {
                                dataInterfacePage.setPropsValue(swapDataVo.getPropsValue());
                                dataInterfacePage.setRelationField(swapDataVo.getRelationField());
                                mapList = this.dataInterFaceApi.infoToInfo(swapDataVo.getInterfaceId(), dataInterfacePage);
                                if (swapDataVo.getConfig().getUseCache().booleanValue()) {
                                    this.redisUtil.insert(redisKey, mapList, 300L);
                                }
                                localCache.put(redisKey, mapList);
                            }
                            StringJoiner stringJoiner = new StringJoiner(",");
                            List popList = new ArrayList<String>();
                            if (value.startsWith("[")) {
                                popList = JsonUtil.getJsonToList((String)value, String.class);
                            } else {
                                popList.add(value);
                            }
                            obj = popList.iterator();
                            while (obj.hasNext()) {
                                String va = (String)obj.next();
                                if (popMaps.size() > 0) {
                                    stringJoiner.add(String.valueOf(popMaps.get(va)));
                                    continue;
                                }
                                Map PopMap = mapList.stream().filter(map -> Objects.equals(String.valueOf(map.get(swapDataVo.getPropsValue())), va)).findFirst().orElse(new HashMap());
                                if (PopMap.size() <= 0) continue;
                                dataMap.put(vModel + "_id", dataMap.get(swapVModel));
                                stringJoiner.add(String.valueOf(PopMap.get(swapDataVo.getRelationField())));
                                dataDetailMap.put(vModel, PopMap);
                            }
                            dataMap.put(vModel, String.valueOf(stringJoiner));
                            break;
                        }
                        case "modifyTime": 
                        case "createTime": 
                        case "datePicker": {
                            Object dateObj = dataMap.get(swapVModel);
                            LocalDateTime dateTime = LocalDateTimeUtil.of((Date)new Date(DateTimeFormatConstant.getDateObjToLong((Object)dateObj)));
                            String format = DateTimeFormatConstant.getFormat((String)swapDataVo.getFormat());
                            if (StringUtil.isEmpty((String)format)) {
                                format = DateTimeFormatConstant.YEAR_MOnTH_DHMS;
                            }
                            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
                            String date = dateTimeFormatter.format(dateTime);
                            dataMap.put(vModel, date);
                            if (!"modifyTime".equals(jnpfKey) && !"createTime".equals(jnpfKey)) break;
                            dataMap.put(swapDataVo.getVModel(), date);
                            break;
                        }
                        case "rate": 
                        case "slider": {
                            Double ratevalue = 0.0;
                            if (dataMap.get(swapVModel) != null) {
                                ratevalue = Double.valueOf(dataMap.get(swapVModel).toString());
                            }
                            dataMap.put(vModel, ratevalue);
                            break;
                        }
                        case "uploadFile": 
                        case "uploadImg": {
                            List fileList = new ArrayList();
                            try {
                                fileList = (List)dataMap.get(swapVModel);
                            }
                            catch (Exception e) {
                                try {
                                    fileList = JsonUtil.getJsonToListMap((String)String.valueOf(dataMap.get(swapVModel)));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            dataMap.put(vModel, fileList);
                            break;
                        }
                        case "location": {
                            if (!isList) break;
                            Map omap = JsonUtil.stringToMap((String)String.valueOf(dataMap.get(swapVModel)));
                            dataMap.put(vModel, omap.get("fullAddress") != null ? omap.get("fullAddress") : "");
                            break;
                        }
                        case "table": {
                            List childrens = swapDataVo.getConfig().getChildren();
                            List childList = (List)dataMap.get(swapDataVo.getVModel());
                            List<Map<String, Object>> swapList = this.getSwapList(childList, childrens, visualDevId, inlineEdit, localCache, isList, dataCopyMap);
                            dataMap.put(swapDataVo.getVModel(), swapList);
                            break;
                        }
                        default: {
                            dataMap.put(vModel, dataMap.get(swapVModel));
                        }
                    }
                    if (dataDetailMap.size() <= 0) continue;
                    OnlineSwapDataUtils.getDataAttr(swapDataVoList, dataMap, dataDetailMap);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u5728\u7ebf\u5f00\u53d1\u8f6c\u6362\u6570\u636e\u9519\u8bef:" + e.getMessage());
                }
            }
            OnlineSwapDataUtils.swapCodeDataInfo(swapDataVoList, dataMap, dataCopyMap);
        }
        if (inlineEdit.booleanValue() && isList) {
            for (Map<String, Object> map2 : list) {
                swapDataVoList = swapDataVoList.stream().filter(s -> !s.getVModel().contains("tableField")).collect(Collectors.toList());
                this.onlineDevInfoUtils.getInitLineData(swapDataVoList, map2);
            }
        }
        return list;
    }

    public String paramSourceTypeReplaceValue(TemplateJsonModel item, Map<String, Object> dataMap) {
        String defaultValue = "";
        if (item.getSourceType() != null) {
            switch (item.getSourceType()) {
                case 1: {
                    defaultValue = item.getDefaultValue();
                    break;
                }
                case 2: {
                    defaultValue = item.getRelationField();
                    break;
                }
                case 3: {
                    defaultValue = "";
                    break;
                }
                case 4: {
                    defaultValue = this.getSystemFieldValue(dataMap, item);
                    break;
                }
                default: {
                    defaultValue = item.getDefaultValue();
                    break;
                }
            }
        } else {
            defaultValue = item.getDefaultValue();
        }
        return defaultValue;
    }

    private String getSystemFieldValue(Map<String, Object> dataCopyMap, TemplateJsonModel templateJsonModel) {
        String dataValue;
        UserInfo userInfo = UserProvider.getUser();
        String relationField = templateJsonModel.getRelationField();
        if (AuthorizeConditionEnum.FORMID.getCondition().equals(relationField)) {
            dataValue = String.valueOf(dataCopyMap.get("id"));
        } else if (AuthorizeConditionEnum.USER.getCondition().equals(relationField)) {
            dataValue = userInfo.getUserId();
        } else if (AuthorizeConditionEnum.USERANDUNDER.getCondition().equals(relationField)) {
            List subOrganizeIds = new ArrayList<String>();
            if (userInfo.getSubordinateIds().size() > 0) {
                subOrganizeIds = userInfo.getSubordinateIds();
            }
            subOrganizeIds.add(userInfo.getUserId());
            dataValue = subOrganizeIds.stream().collect(Collectors.joining(","));
        } else if (AuthorizeConditionEnum.ORGANIZE.getCondition().equals(relationField)) {
            String orgId1 = userInfo.getOrganizeId();
            if (StringUtil.isNotEmpty((String)userInfo.getDepartmentId())) {
                orgId1 = userInfo.getDepartmentId();
            }
            dataValue = orgId1;
        } else if (AuthorizeConditionEnum.ORGANIZEANDUNDER.getCondition().equals(relationField)) {
            String orgId1 = userInfo.getOrganizeId();
            if (StringUtil.isNotEmpty((String)userInfo.getDepartmentId())) {
                orgId1 = userInfo.getDepartmentId();
            }
            List underOrganizations = this.organizeApi.getUnderOrganizations(orgId1, false);
            underOrganizations.add(orgId1);
            dataValue = underOrganizations.stream().collect(Collectors.joining(","));
        } else if (AuthorizeConditionEnum.BRANCHMANAGEORG.getCondition().equals(relationField)) {
            List orgIds1 = this.organizeAdministratorService.getOrganizeUserList("@currentOrgAndSubOrg");
            dataValue = orgIds1.stream().collect(Collectors.joining(","));
        } else {
            dataValue = templateJsonModel.getDefaultValue();
        }
        return dataValue;
    }

    public void sysNeedSwapData(List<FieLdsModel> swapDataVoList, String visualDevId, Map<String, Object> localCache) {
        String dsName = Optional.ofNullable(TenantHolder.getDatasourceId()).orElse("");
        try {
            Object redisKey;
            boolean needUser = false;
            boolean needOrg = false;
            boolean needPos = false;
            boolean needRole = false;
            boolean needGroup = false;
            boolean needProvince = false;
            for (FieLdsModel swapDataVo : swapDataVoList) {
                Object children;
                String jnpfKey = swapDataVo.getConfig().getJnpfKey();
                String dataType = swapDataVo.getConfig().getDataType();
                switch (jnpfKey) {
                    case "table": {
                        children = swapDataVo.getConfig().getChildren();
                        this.sysNeedSwapData((List<FieLdsModel>)children, visualDevId, localCache);
                        break;
                    }
                    case "userSelect": 
                    case "createUser": 
                    case "modifyUser": {
                        needUser = true;
                        break;
                    }
                    case "organizeSelect": 
                    case "depSelect": 
                    case "currDept": 
                    case "currOrganize": {
                        needOrg = true;
                        break;
                    }
                    case "posSelect": 
                    case "currPosition": {
                        needPos = true;
                        break;
                    }
                    case "roleSelect": {
                        needRole = true;
                        break;
                    }
                    case "groupSelect": {
                        needGroup = true;
                        break;
                    }
                    case "usersSelect": {
                        needRole = true;
                        needGroup = true;
                        needPos = true;
                        needOrg = true;
                        needUser = true;
                        break;
                    }
                    case "areaSelect": {
                        needProvince = true;
                        break;
                    }
                }
                if (dataType == null) continue;
                String label = swapDataVo.getProps().getLabel() != null ? swapDataVo.getProps().getLabel() : "";
                String value = swapDataVo.getProps().getValue() != null ? swapDataVo.getProps().getValue() : "";
                children = swapDataVo.getProps().getChildren() != null ? swapDataVo.getProps().getChildren() : "";
                ArrayList<Map<String, Object>> options = new ArrayList();
                if (swapDataVo.getConfig().getJnpfKey().equals("popupSelect") || swapDataVo.getConfig().getJnpfKey().equals("popupTableSelect")) {
                    label = swapDataVo.getRelationField();
                    value = swapDataVo.getPropsValue();
                }
                HashMap dataInterfaceMap = new HashMap(16);
                String finalValue = value;
                String finalLabel = label;
                if (dataType.equals(OnlineDataTypeEnum.STATIC.getType()) && !localCache.containsKey(redisKey = String.format("%s-%s-%s", visualDevId, swapDataVo.getConfig().getRelationTable() + swapDataVo.getVModel(), OnlineDataTypeEnum.STATIC.getType()))) {
                    if (!this.redisUtil.exists((String)redisKey)) {
                        if (swapDataVo.getOptions() != null) {
                            options = JsonUtil.getJsonToListMap((String)swapDataVo.getOptions());
                            JSONArray data = JsonUtil.getListToJsonArray(options);
                            OnlineSwapDataUtils.getOptions(label, value, (String)children, data, options);
                        } else {
                            options = JsonUtil.getJsonToListMap((String)swapDataVo.getOptions());
                        }
                        options.stream().forEach(o -> dataInterfaceMap.put(String.valueOf(o.get(finalValue)), String.valueOf(o.get(finalLabel))));
                        this.redisUtil.insert((String)redisKey, dataInterfaceMap, 300L);
                        localCache.put((String)redisKey, dataInterfaceMap);
                    } else {
                        localCache.put((String)redisKey, this.redisUtil.getMap((String)redisKey));
                    }
                }
                if (dataType.equals(OnlineDataTypeEnum.DYNAMIC.getType())) {
                    boolean dynamicIsNeedCache;
                    boolean bl = dynamicIsNeedCache = swapDataVo.getConfig().getTemplateJson().size() == 0;
                    if (dynamicIsNeedCache && !localCache.containsKey(redisKey = String.format("%s-%s-%s-%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl(), value, label, children))) {
                        if (!this.redisUtil.exists((String)redisKey)) {
                            ActionResult data = this.dataInterFaceApi.infoToId(swapDataVo.getConfig().getPropsUrl(), null, null);
                            if (data != null && data.getData() != null) {
                                List dataList = new ArrayList();
                                if (data.getData() instanceof List) {
                                    dataList = (List)data.getData();
                                }
                                JSONArray dataAll = JsonUtil.getListToJsonArray(dataList);
                                OnlineSwapDataUtils.treeToList(label, value, (String)children, dataAll, options);
                                options.stream().forEach(o -> dataInterfaceMap.put(String.valueOf(o.get(finalValue)), String.valueOf(o.get(finalLabel))));
                                if (CollectionUtils.isNotEmpty(dataList) && !"treeSelect".equals(jnpfKey) && swapDataVo.getConfig().getUseCache().booleanValue()) {
                                    this.redisUtil.insert((String)redisKey, dataInterfaceMap, 300L);
                                }
                                localCache.put((String)redisKey, dataInterfaceMap);
                            }
                        } else {
                            localCache.put((String)redisKey, this.redisUtil.getMap((String)redisKey));
                        }
                    }
                }
                if (!dataType.equals(OnlineDataTypeEnum.DICTIONARY.getType()) || localCache.containsKey(redisKey = String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DICTIONARY.getType(), swapDataVo.getConfig().getDictionaryType()))) continue;
                if (!this.redisUtil.exists((String)redisKey)) {
                    List list = this.dictionaryDataApi.getDicList(swapDataVo.getConfig().getDictionaryType());
                    options = list.stream().map(dic -> {
                        HashMap<String, Object> dictionaryMap = new HashMap<String, Object>(16);
                        dictionaryMap.put("id", dic.getId());
                        dictionaryMap.put("enCode", dic.getEnCode());
                        dictionaryMap.put("fullName", dic.getFullName());
                        return dictionaryMap;
                    }).collect(Collectors.toList());
                    String dictionaryData = JsonUtil.getObjectToString(options);
                    this.redisUtil.insert((String)redisKey, (Object)dictionaryData, 300L);
                    localCache.put((String)redisKey, options);
                    continue;
                }
                String dictionaryStringData = this.redisUtil.getString((String)redisKey).toString();
                localCache.put((String)redisKey, JsonUtil.getJsonToListMap((String)dictionaryStringData));
            }
            if (needUser && !localCache.containsKey("__user_map")) {
                Map userMap;
                redisKey = dsName + CacheKeyEnum.USER.getName();
                if (this.redisUtil.exists((String)redisKey)) {
                    userMap = this.redisUtil.getMap((String)redisKey);
                    userMap = Optional.ofNullable(userMap).orElse(new HashMap(20));
                } else {
                    userMap = this.userApi.getUserMap();
                    this.redisUtil.insert((String)redisKey, (Object)userMap, 300L);
                }
                localCache.put("__user_map", userMap);
            }
            if (needOrg && !localCache.containsKey("__org_map")) {
                Map orgMap;
                redisKey = dsName + CacheKeyEnum.ORG.getName();
                if (this.redisUtil.exists((String)redisKey)) {
                    orgMap = this.redisUtil.getMap((String)redisKey);
                    orgMap = Optional.ofNullable(orgMap).orElse(new HashMap(20));
                } else {
                    orgMap = this.organizeApi.getOrgMap();
                    this.redisUtil.insert((String)redisKey, (Object)orgMap, 300L);
                }
                localCache.put("__org_map", orgMap);
            }
            if (needPos && !localCache.containsKey("__pos_map")) {
                Map posMap;
                redisKey = dsName + CacheKeyEnum.POS.getName();
                if (this.redisUtil.exists((String)redisKey)) {
                    posMap = this.redisUtil.getMap((String)redisKey);
                    posMap = Optional.ofNullable(posMap).orElse(new HashMap(20));
                } else {
                    posMap = this.positionApi.getPosMap();
                    this.redisUtil.insert((String)redisKey, (Object)posMap, 300L);
                }
                localCache.put("__pos_map", posMap);
            }
            if (needRole && !localCache.containsKey("__role_map")) {
                Map roleMap;
                redisKey = dsName + CacheKeyEnum.ROLE.getName();
                if (this.redisUtil.exists((String)redisKey)) {
                    roleMap = this.redisUtil.getMap((String)redisKey);
                    roleMap = Optional.ofNullable(roleMap).orElse(new HashMap(20));
                } else {
                    roleMap = this.roleApi.getRoleMap();
                    this.redisUtil.insert((String)redisKey, (Object)roleMap, 300L);
                }
                localCache.put("__role_map", roleMap);
            }
            if (needGroup && !localCache.containsKey("__group_map")) {
                Map groupMap;
                redisKey = dsName + CacheKeyEnum.GROUP.getName();
                if (this.redisUtil.exists((String)redisKey)) {
                    groupMap = this.redisUtil.getMap((String)redisKey);
                    groupMap = Optional.ofNullable(groupMap).orElse(new HashMap(20));
                } else {
                    groupMap = this.groupApi.getGroupMap();
                    this.redisUtil.insert((String)redisKey, (Object)groupMap, 300L);
                }
                localCache.put("__group_map", groupMap);
            }
            if (needProvince && !localCache.containsKey("__pro_maplist")) {
                Map proMap = this.redisUtil.getMap(String.format("%s-%s-%d", dsName, "province", 1));
                List<Object> proMapList = new ArrayList();
                if (proMap.size() == 0) {
                    proMapList = this.fillProMap(dsName);
                } else {
                    for (int i = 1; i <= 4; ++i) {
                        proMapList.add(this.redisUtil.getMap(String.format("%s-%s-%d", dsName, "province", i)));
                    }
                }
                localCache.put("__pro_maplist", proMapList);
            }
        }
        catch (Exception e) {
            log.error("\u5728\u7ebf\u5f00\u53d1\u8f6c\u6362\u6570\u636e\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
    }

    private List<Map<String, String>> fillProMap(String dsName) {
        ArrayList<Map<String, String>> proMapList = new ArrayList<Map<String, String>>();
        for (int i = 1; i <= 4; ++i) {
            String redisKey = String.format("%s-%s-%d", dsName, "province", i);
            if (this.redisUtil.exists(redisKey)) continue;
            List provinceEntityList = this.areaApi.getProListBytype(String.valueOf(i));
            HashMap provinceMap = new HashMap(16);
            if (provinceEntityList != null) {
                provinceEntityList.stream().forEach(p -> provinceMap.put((String)p.getId(), p.getFullName()));
            }
            proMapList.add(provinceMap);
            this.redisUtil.insert(redisKey, provinceMap, 604800L);
        }
        return proMapList;
    }

    public static void treeToList(String value, String label, String children, JSONArray data, List<Map<String, Object>> result) {
        for (int i = 0; i < data.size(); ++i) {
            JSONObject ob = data.getJSONObject(i);
            HashMap<String, String> tree = new HashMap<String, String>(16);
            tree.put(value, String.valueOf(ob.get((Object)value)));
            tree.put(label, String.valueOf(ob.get((Object)label)));
            result.add(tree);
            if (ob.get((Object)children) == null) continue;
            JSONArray childArray = ob.getJSONArray(children);
            OnlineSwapDataUtils.treeToList(value, label, children, childArray, result);
        }
    }

    public static void getOptions(String label, String value, String Children, JSONArray data, List<Map<String, Object>> options) {
        for (int i = 0; i < data.size(); ++i) {
            JSONObject ob = data.getJSONObject(i);
            HashMap<String, String> tree = new HashMap<String, String>(16);
            tree.put(value, String.valueOf(ob.get((Object)value)));
            tree.put(label, String.valueOf(ob.get((Object)label)));
            options.add(tree);
            if (ob.get((Object)Children) == null) continue;
            JSONArray childrenArray = ob.getJSONArray(Children);
            OnlineSwapDataUtils.getOptions(label, value, Children, childrenArray, options);
        }
    }

    private static void getDataAttr(List<FieLdsModel> fieLdsModelList, Map<String, Object> dataMap, Map<String, Map<String, Object>> dataDetailMap) {
        for (FieLdsModel fieLdsModel : fieLdsModelList) {
            boolean isShow;
            ConfigModel config;
            String jnpfKey;
            if (ObjectUtil.isEmpty((Object)fieLdsModel) || !(jnpfKey = (config = fieLdsModel.getConfig()).getJnpfKey()).equals("relationFormAttr") && !jnpfKey.equals("popupAttr") || !(isShow = fieLdsModel.getIsStorage() == 0)) continue;
            String relationField = fieLdsModel.getRelationField();
            if (relationField.contains("_jnpfTable_")) {
                relationField = relationField.split("_jnpfTable_")[0];
            }
            String showField = fieLdsModel.getShowField();
            Map<String, Object> formDataMap = dataDetailMap.get(relationField);
            if (formDataMap == null) continue;
            dataMap.put(relationField + "_" + showField, formDataMap.get(showField));
        }
    }

    public static void swapCodeDataInfo(List<FieLdsModel> codeList, Map<String, Object> swapDataMap, Map<String, Object> dataMap) {
        for (FieLdsModel formModel : codeList) {
            Object relationValue;
            String relationFiled;
            String jnpfKey = formModel.getConfig().getJnpfKey();
            if (!jnpfKey.equals("qrcode") && !jnpfKey.equals("barcode")) continue;
            String codeDataType = formModel.getDataType();
            if (!OnlineDataTypeEnum.RELATION.getType().equals(codeDataType) || !StringUtil.isNotEmpty((String)(relationFiled = formModel.getRelationField())) || !ObjectUtil.isNotEmpty((Object)(relationValue = dataMap.get(relationFiled)))) continue;
            swapDataMap.put(relationFiled + "_id", relationValue);
        }
    }

    public ExcelImportModel createExcelData(List<Map<String, Object>> dataList, VisualDevJsonModel visualJsonModel, VisualdevEntity visualdevEntity) throws WorkFlowException {
        ExcelImportModel excelImportModel = new ExcelImportModel();
        Integer primaryKeyPolicy = visualJsonModel.getFormData().getPrimaryKeyPolicy();
        String uploaderTemplateJson = visualJsonModel.getColumnData().getUploaderTemplateJson();
        UploaderTemplateModel uploaderTemplateModel = (UploaderTemplateModel)JsonUtil.getJsonToBean((String)uploaderTemplateJson, UploaderTemplateModel.class);
        String dataType = uploaderTemplateModel.getDataType();
        ImportFormCheckUniqueModel uniqueModel = new ImportFormCheckUniqueModel();
        uniqueModel.setMain(true);
        uniqueModel.setDbLinkId(visualJsonModel.getDbLinkId());
        uniqueModel.setUpdate(dataType.equals("2"));
        uniqueModel.setPrimaryKeyPolicy(primaryKeyPolicy);
        uniqueModel.setLogicalDelete(visualJsonModel.getFormData().getLogicalDelete());
        uniqueModel.setTableModelList(visualJsonModel.getVisualTables());
        String mainFlowID = null;
        if (StringUtil.isNotEmpty((String)visualJsonModel.getFlowId())) {
            List flowVersionIds = this.templateApi.getFlowIdsByTemplate(visualJsonModel.getFlowId());
            uniqueModel.setFlowId(visualJsonModel.getFlowId());
            uniqueModel.setFlowIdList(flowVersionIds.stream().map(SuperBaseEntity.SuperIBaseEntity::getId).distinct().collect(Collectors.toList()));
            mainFlowID = (String)flowVersionIds.stream().filter(t -> Objects.equals(t.getState(), 1)).findFirst().orElse(new TemplateJsonEntity()).getId();
        }
        Map<String, Object> localCache = this.getlocalCache();
        ArrayList<HashMap<String, Object>> failResult = new ArrayList<HashMap<String, Object>>();
        ArrayList<VisualdevModelDataInfoVO> dataInfo = new ArrayList<VisualdevModelDataInfoVO>();
        try {
            int len = dataList.size();
            for (int i = 0; i < len; ++i) {
                Map<String, Object> data = dataList.get(i);
                data.put("flowId", mainFlowID);
                HashMap<String, Object> resultMap = new HashMap<String, Object>(data);
                StringJoiner errInfo = new StringJoiner(",");
                HashMap<String, Object> errorMap = new HashMap<String, Object>(data);
                List<String> errList = this.checkExcelData(visualJsonModel.getFormListModels(), data, localCache, resultMap, errorMap, uniqueModel);
                VisualErrInfo visualErrInfo = this.formCheckUtils.checkBusinessKey(visualJsonModel.getFormListModels(), resultMap, visualJsonModel.getVisualTables(), visualJsonModel.getFormData(), null);
                if (uniqueModel.isUpdate()) {
                    if (ObjectUtil.isNotEmpty((Object)visualErrInfo) && StringUtil.isNotEmpty((String)visualErrInfo.getId())) {
                        uniqueModel.setId(visualErrInfo.getId());
                        if (StringUtil.isNotEmpty((String)visualErrInfo.getFlowTaskId())) {
                            String finalTaskId = visualErrInfo.getFlowTaskId();
                            ArrayList<String> flowIdList = new ArrayList<String>();
                            flowIdList.add(finalTaskId);
                            List tasks = this.taskApi.getInfosSubmit(flowIdList.toArray(new String[0]), new SFunction[]{TaskEntity::getStatus, SuperBaseEntity.SuperIBaseEntity::getId});
                            if (tasks.size() > 0) {
                                boolean errorMsg = tasks.stream().filter(t -> Objects.equals(t.getStatus(), 0)).count() == 0L;
                                String msg = "\u5df2\u53d1\u8d77\u6d41\u7a0b\uff0c\u5bfc\u5165\u5931\u8d25";
                                if (errorMsg) {
                                    errorMap.put("errorsInfo", msg);
                                    failResult.add(errorMap);
                                    continue;
                                }
                            }
                        }
                    }
                } else if (ObjectUtil.isNotEmpty((Object)visualErrInfo) && StringUtil.isNotEmpty((String)visualErrInfo.getErrMsg())) {
                    errorMap.put("errorsInfo", visualErrInfo.getErrMsg());
                    failResult.add(errorMap);
                    continue;
                }
                this.checkUnique(visualJsonModel.getFormListModels(), data, errList, uniqueModel);
                errList.stream().forEach(t -> {
                    if (StringUtil.isNotEmpty((String)t)) {
                        errInfo.add((CharSequence)t);
                    }
                });
                if (errInfo.length() > 0) {
                    errorMap.put("errorsInfo", errInfo.toString());
                    failResult.add(errorMap);
                    continue;
                }
                VisualdevModelDataInfoVO infoVO = new VisualdevModelDataInfoVO();
                if (StringUtil.isNotEmpty((String)uniqueModel.getId())) {
                    this.visualdevModelDataService.visualUpdate(visualdevEntity, resultMap, uniqueModel.getId(), true);
                    infoVO.setId((Object)uniqueModel.getId());
                    infoVO.setIntegrateId(uniqueModel.getId());
                    infoVO.setData(JsonUtil.getObjectToString(resultMap));
                } else {
                    DataModel dataModel = this.visualdevModelDataService.visualCreate(visualdevEntity, resultMap, false, true);
                    infoVO.setId((Object)dataModel.getMainId());
                    infoVO.setData(JsonUtil.getObjectToString(resultMap));
                }
                dataInfo.add(infoVO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkFlowException(MsgCode.IMP004.get(new Object[0]));
        }
        finally {
            DynamicDataSourceUtil.clearSwitchDataSource();
        }
        excelImportModel.setFnum(failResult.size());
        excelImportModel.setSnum(dataList.size() - failResult.size());
        excelImportModel.setResultType(failResult.size() > 0 ? 1 : 0);
        excelImportModel.setFailResult(failResult);
        excelImportModel.setDataInfoList(dataInfo);
        return excelImportModel;
    }

    public Map<String, Object> getlocalCache() {
        HashMap<String, Object> localCache = new HashMap<String, Object>();
        Map depMap = this.organizeApi.getOrgEncodeAndName("department");
        localCache.put("_dep_map", depMap);
        Map comMap = this.organizeApi.getOrgNameAndId("");
        localCache.put("_com_map", comMap);
        Map posMap = this.positionApi.getPosEncodeAndName();
        localCache.put("_pos_map", posMap);
        Map userMap = this.userApi.getUserNameAndIdMap();
        localCache.put("_user_map", userMap);
        Map roleMap = this.roleApi.getRoleNameAndIdMap();
        localCache.put("_role_map", roleMap);
        Map groupMap = this.groupApi.getGroupEncodeMap();
        localCache.put("_group_map", groupMap);
        Map allOrgsTreeName = this.organizeApi.getAllOrgsTreeName();
        localCache.put("_com_tree_map", allOrgsTreeName);
        Map orgIdNameMaps = this.organizeApi.getInfoList();
        ArrayList<String> idAll = new ArrayList<String>();
        List<String> orgList = this.orgList("@currentOrg--system", false, orgIdNameMaps);
        localCache.put("_org_list", orgList);
        List<String> orgSubList = this.orgList("@currentOrgAndSubOrg--system", false, orgIdNameMaps);
        localCache.put("_orgSub_list", orgSubList);
        List<String> gradeList = this.orgList("@currentGradeOrg--system", false, orgIdNameMaps);
        localCache.put("_grade_list", gradeList);
        List<String> orgListStr = this.orgList("@currentOrg--system", true, orgIdNameMaps);
        localCache.put("_org_listStr", orgListStr);
        List<String> orgSubListStr = this.orgList("@currentOrgAndSubOrg--system", true, orgIdNameMaps);
        localCache.put("_orgSub_listStr", orgSubListStr);
        List<String> gradeListStr = this.orgList("@currentGradeOrg--system", true, orgIdNameMaps);
        localCache.put("_grade_listStr", gradeListStr);
        idAll.addAll(orgList);
        idAll.addAll(orgSubList);
        idAll.addAll(gradeList);
        List relationList = this.organizeRelationApi.getRelationListByOrganizeId(idAll, "");
        List listByObjectIdAll = this.userRelationApi.getListByObjectIdAll(idAll);
        for (UserRelationEntity userRelationEntity : listByObjectIdAll) {
            OrganizeRelationEntity model = new OrganizeRelationEntity();
            model.setObjectType("user");
            model.setOrganizeId(userRelationEntity.getObjectId());
            model.setObjectId(userRelationEntity.getUserId());
            relationList.add(model);
        }
        localCache.put("_relation_list", relationList);
        return localCache;
    }

    public List<String> orgList(final String type, boolean isTree, Map<String, String> orgIdNameMaps) {
        ArrayList org = new ArrayList(){
            {
                this.add(type);
            }
        };
        OrganizeConditionModel orgType = new OrganizeConditionModel();
        orgType.setDepartIds((List)org);
        orgType.setOrgIdNameMaps(orgIdNameMaps);
        ArrayList<String> orgList = new ArrayList<String>();
        List orgIdsList = this.organizeRelationApi.getOrgIdsList(orgType);
        for (OrganizeModel organizeModel : orgIdsList) {
            if (isTree) {
                ArrayList treeList = StringUtil.isNotEmpty((String)organizeModel.getOrganizeIdTree()) ? Arrays.asList(organizeModel.getOrganizeIdTree().split(",")) : new ArrayList();
                orgList.add(JsonUtil.getListToJsonArray(treeList).toJSONString());
                continue;
            }
            orgList.add(organizeModel.getId());
        }
        return orgList;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public List<String> checkExcelData(List<FieLdsModel> modelList, Map<String, Object> data, Map<String, Object> localCache, Map<String, Object> insMap, Map<String, Object> errorMap, ImportFormCheckUniqueModel uniqueModel) {
        errList = new ArrayList<String>(modelList.size());
        try {
            userInfo = UserProvider.getUser();
            userEntity = this.userApi.getInfo(userInfo.getUserId());
            depMap = (Map)localCache.get("_dep_map");
            comMap = (Map)localCache.get("_com_map");
            posMap = (Map)localCache.get("_pos_map");
            userMap = (Map)localCache.get("_user_map");
            roleMap = (Map)localCache.get("_role_map");
            groupMap = (Map)localCache.get("_group_map");
            allOrgsTreeName = (Map)localCache.get("_com_tree_map");
            orgList = (List)localCache.get("_org_list");
            orgSubList = (List)localCache.get("_orgSub_list");
            gradeList = (List)localCache.get("_grade_list");
            orgListStr = (List)localCache.get("_org_listStr");
            orgSubListStr = (List)localCache.get("_orgSub_listStr");
            gradeListStr = (List)localCache.get("_grade_listStr");
            relationListAll = (List)localCache.get("_relation_list");
            for (i = 0; i < modelList.size(); ++i) {
                swapDataVo = modelList.get(i);
                errList.add(i, "");
                try {
                    jnpfKey = swapDataVo.getConfig().getJnpfKey();
                    dataType = swapDataVo.getConfig().getDataType();
                    valueO = data.get(swapDataVo.getVModel());
                    label = swapDataVo.getConfig().getLabel();
                    if (JnpfKeyConsts.getUploadMaybeNull().contains(jnpfKey)) {
                        insMap.put(swapDataVo.getVModel(), null);
                        continue;
                    }
                    required = swapDataVo.getConfig().isRequired();
                    if (valueO == null || "null".equals(valueO) || StringUtil.isEmpty((String)String.valueOf(valueO))) {
                        if (!required) continue;
                        errList.set(i, label + "\u4e0d\u80fd\u4e3a\u7a7a");
                        continue;
                    }
                    value = String.valueOf(valueO);
                    if (StringUtil.isEmpty((String)value)) continue;
                    multiple = swapDataVo.getMultiple();
                    if ("checkbox".equals(jnpfKey)) {
                        multiple = true;
                    }
                    if ("cascader".equals(jnpfKey)) {
                        multiple = swapDataVo.getMultiple();
                    }
                    valueMul = value.contains(",");
                    value = value.trim();
                    v0 = valueList = valueMul != false ? Arrays.asList(value.split(",")) : new ArrayList<E>();
                    if (!valueMul) {
                        valueList.add(value);
                    }
                    ableIds = swapDataVo.getAbleIds() != null ? swapDataVo.getAbleIds() : "[]";
                    cusCheckModel = AbleUtil.ableModel((String)ableIds, (String)jnpfKey);
                    ableSystemIds = cusCheckModel.getAbleSystemIds();
                    idList = new ArrayList<E>();
                    idStr = new ArrayList<E>();
                    orgUserList = new ArrayList<E>();
                    for (String systemId : ableSystemIds) {
                        if ("@currentOrg--system".equals(systemId) || "@currentOrg".equals(systemId)) {
                            idList.addAll(orgList);
                            idStr.addAll(orgListStr);
                            orgUserList.addAll(orgList);
                        }
                        if ("@currentGradeOrg--system".equals(systemId) || "@currentGradeOrg".equals(systemId)) {
                            idList.addAll(gradeList);
                            idStr.addAll(gradeListStr);
                            orgUserList.addAll(gradeList);
                        }
                        if (!"@currentOrgAndSubOrg--system".equals(systemId) && !"@currentOrgAndSubOrg".equals(systemId)) continue;
                        idList.addAll(orgSubList);
                        idStr.addAll(orgSubListStr);
                        orgUserList.addAll(orgSubList);
                    }
                    cusCheckModel.getAbleComIds().addAll(idList);
                    cusCheckModel.getAbleDepIds().addAll(idList);
                    cusCheckModel.getAbleComIdsStr().addAll(idStr);
                    relationList = relationListAll.stream().filter((Predicate<OrganizeRelationEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$checkExcelData$16(java.util.List jnpf.permission.entity.OrganizeRelationEntity ), (Ljnpf/permission/entity/OrganizeRelationEntity;)Z)(orgUserList)).collect(Collectors.toList());
                    relationMap = relationList.stream().collect(Collectors.groupingBy((Function<OrganizeRelationEntity, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getObjectType(), (Ljnpf/permission/entity/OrganizeRelationEntity;)Ljava/lang/String;)()));
                    for (String key : relationMap.keySet()) {
                        list = relationMap.get(key).stream().map((Function<OrganizeRelationEntity, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getObjectId(), (Ljnpf/permission/entity/OrganizeRelationEntity;)Ljava/lang/String;)()).collect(Collectors.toList());
                        for (String objectId : list) {
                            if ("Role".equalsIgnoreCase(key)) {
                                cusCheckModel.getAbleRoleIds().add(objectId);
                                cusCheckModel.getAbleIds().add(objectId + "--" + "Role".toLowerCase());
                            }
                            if ("Position".equalsIgnoreCase(key)) {
                                cusCheckModel.getAblePosIds().add(objectId);
                                cusCheckModel.getAbleIds().add(objectId + "--" + "Position".toLowerCase());
                            }
                            if ("user".equalsIgnoreCase(key)) {
                                cusCheckModel.getAbleUserIds().add(objectId);
                                cusCheckModel.getAbleIds().add(objectId + "--" + "user".toLowerCase());
                            }
                            if ("Group".equalsIgnoreCase(key)) {
                                cusCheckModel.getAbleGroupIds().add(objectId);
                                cusCheckModel.getAbleIds().add(objectId + "--" + "Group".toLowerCase());
                            }
                            if ("department".equalsIgnoreCase(key)) {
                                cusCheckModel.getAbleDepIds().add(objectId);
                                cusCheckModel.getAbleIds().add(objectId + "--" + "department".toLowerCase());
                            }
                            if (!"Organize".equalsIgnoreCase(key)) continue;
                            cusCheckModel.getAbleComIds().add(objectId);
                            cusCheckModel.getAbleIds().add(objectId + "--" + "Organize".toLowerCase());
                        }
                    }
                    cusCheckModel.setControlType(jnpfKey);
                    key = jnpfKey;
                    list = -1;
                    switch (key.hashCode()) {
                        case -448356429: {
                            if (!key.equals("inputNumber")) break;
                            list = 0;
                            break;
                        }
                        case 1674419327: {
                            if (!key.equals("organizeSelect")) break;
                            list = 1;
                            break;
                        }
                        case -1632625173: {
                            if (!key.equals("depSelect")) break;
                            list = 2;
                            break;
                        }
                        case 1063502960: {
                            if (!key.equals("posSelect")) break;
                            list = 3;
                            break;
                        }
                        case 1578092711: {
                            if (!key.equals("userSelect")) break;
                            list = 4;
                            break;
                        }
                        case -509998812: {
                            if (!key.equals("usersSelect")) break;
                            list = 5;
                            break;
                        }
                        case 1469640978: {
                            if (!key.equals("roleSelect")) break;
                            list = 6;
                            break;
                        }
                        case 745274459: {
                            if (!key.equals("groupSelect")) break;
                            list = 7;
                            break;
                        }
                        case 818189289: {
                            if (!key.equals("areaSelect")) break;
                            list = 8;
                            break;
                        }
                        case 666327541: {
                            if (!key.equals("currOrganize")) break;
                            list = 9;
                            break;
                        }
                        case 574410647: {
                            if (!key.equals("currDept")) break;
                            list = 10;
                            break;
                        }
                        case 1369252583: {
                            if (!key.equals("createUser")) break;
                            list = 11;
                            break;
                        }
                        case 1369213417: {
                            if (!key.equals("createTime")) break;
                            list = 12;
                            break;
                        }
                        case 1211388583: {
                            if (!key.equals("modifyTime")) break;
                            list = 13;
                            break;
                        }
                        case 1211427749: {
                            if (!key.equals("modifyUser")) break;
                            list = 14;
                            break;
                        }
                        case 97743227: {
                            if (!key.equals("currPosition")) break;
                            list = 15;
                            break;
                        }
                        case -889473228: {
                            if (!key.equals("switch")) break;
                            list = 16;
                            break;
                        }
                        case 3493088: {
                            if (!key.equals("rate")) break;
                            list = 17;
                            break;
                        }
                        case -899647263: {
                            if (!key.equals("slider")) break;
                            list = 18;
                            break;
                        }
                        case -1003243718: {
                            if (!key.equals("textarea")) break;
                            list = 19;
                            break;
                        }
                        case 100358090: {
                            if (!key.equals("input")) break;
                            list = 20;
                            break;
                        }
                        case 696793531: {
                            if (!key.equals("timePicker")) break;
                            list = 21;
                            break;
                        }
                        case 435546588: {
                            if (!key.equals("datePicker")) break;
                            list = 22;
                            break;
                        }
                        case 110115790: {
                            if (!key.equals("table")) break;
                            list = 23;
                        }
                    }
                    switch (list) {
                        case 0: {
                            regNum = "-?\\d+(\\.\\d+)?";
                            if (StringUtil.isNotEmpty((String)value) && !value.matches(regNum)) {
                                errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
                                break;
                            }
                            valueDecimal = null;
                            try {
                                valueDecimal = new BigDecimal(value);
                            }
                            catch (Exception var48_52) {
                                // empty catch block
                            }
                            if (valueDecimal == null) {
                                errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
                                break;
                            }
                            v1 = configPrecision = swapDataVo.getPrecision() == null ? 0 : swapDataVo.getPrecision();
                            if (valueDecimal.scale() > configPrecision) {
                                errList.set(i, label + "\u503c\u7684\u7cbe\u5ea6\u4e0d\u6b63\u786e");
                                break;
                            }
                            if (swapDataVo.getMin() != null && valueDecimal.compareTo(new BigDecimal(swapDataVo.getMin())) < 0) {
                                errList.set(i, label + "\u503c\u4e0d\u80fd\u5c0f\u4e8e\u6700\u5c0f\u503c");
                                break;
                            }
                            if (swapDataVo.getMax() == null || valueDecimal.compareTo(new BigDecimal(swapDataVo.getMax())) <= 0) break;
                            errList.set(i, label + "\u503c\u4e0d\u80fd\u5927\u4e8e\u6700\u5927\u503c");
                            break;
                        }
                        case 1: {
                            if (!multiple.booleanValue() && valueList.size() > 1) {
                                errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
                                break;
                            }
                            comTwoList = new ArrayList<List<String>>();
                            comOneList = new ArrayList<String>();
                            comErrorHapen = false;
                            for (Object comValue : valueList) {
                                if (StringUtil.isEmpty((String)comValue)) {
                                    errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
                                    comErrorHapen = true;
                                    break;
                                }
                                find = false;
                                for (String key : allOrgsTreeName.keySet()) {
                                    o = allOrgsTreeName.get(key);
                                    if (!comValue.equals(o.toString())) continue;
                                    split = key.split(",");
                                    comOneList.addAll(Arrays.asList(split));
                                    comTwoList.add(Arrays.asList(split));
                                    find = true;
                                    break;
                                }
                                if (find) continue;
                                errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
                                comErrorHapen = true;
                                break;
                            }
                            if (comErrorHapen) break;
                            insMap.put(swapDataVo.getVModel(), multiple == false ? JsonUtil.getObjectToString(comOneList) : JsonUtil.getObjectToString(comTwoList));
                            if (!"custom".equals(swapDataVo.getSelectType())) break;
                            strList = new ArrayList<String>();
                            comValue = comTwoList.iterator();
                            while (comValue.hasNext()) {
                                strings = (List)comValue.next();
                                strList.add(JsonUtil.getListToJsonArray((List)strings).toJSONString());
                            }
                            cusCheckModel.setDataList(strList);
                            this.checkCustomControl(cusCheckModel, errList, i, label);
                            break;
                        }
                        case 2: {
                            dataList = this.checkOptionsControl(multiple, insMap, swapDataVo.getVModel(), label, depMap, valueList, errList, i);
                            if (dataList.size() != valueList.size() || !swapDataVo.getSelectType().equals("custom")) break;
                            cusCheckModel.setDataList(dataList);
                            this.checkCustomControl(cusCheckModel, errList, i, label);
                            break;
                        }
                        case 3: {
                            dataList = this.checkOptionsControl(multiple, insMap, swapDataVo.getVModel(), label, posMap, valueList, errList, i);
                            if (dataList.size() != valueList.size() || !swapDataVo.getSelectType().equals("custom")) break;
                            cusCheckModel.setDataList(dataList);
                            this.checkCustomControl(cusCheckModel, errList, i, label);
                            break;
                        }
                        case 4: {
                            dataList = this.checkOptionsControl(multiple, insMap, swapDataVo.getVModel(), label, userMap, valueList, errList, i);
                            if (dataList.size() != valueList.size() || !swapDataVo.getSelectType().equals("custom")) break;
                            cusCheckModel.setDataList(dataList);
                            this.checkCustomControl(cusCheckModel, errList, i, label);
                            break;
                        }
                        case 5: {
                            cusUserErrorHapen = false;
                            if (!multiple.booleanValue() && valueList.size() > 1) {
                                cusUserErrorHapen = true;
                                errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
                            }
                            if (cusUserErrorHapen) break;
                            cusUserErrorHapen1 = false;
                            cusUserList = new ArrayList<CallSite>();
                            for (Object va : valueList) {
                                if (StringUtil.isEmpty((String)va)) {
                                    cusUserErrorHapen1 = true;
                                    break;
                                }
                                type = null;
                                id = null;
                                if (groupMap.get(va) != null) {
                                    type = "group";
                                    id = groupMap.get(va).toString();
                                } else if (roleMap.get(va) != null) {
                                    type = "role";
                                    id = roleMap.get(va).toString();
                                } else if (depMap.get(va) != null) {
                                    type = "department";
                                    id = depMap.get(va).toString();
                                } else if (comMap.get(va) != null) {
                                    type = "company";
                                    id = comMap.get(va).toString();
                                } else if (posMap.get(va) != null) {
                                    type = "position";
                                    id = posMap.get(va).toString();
                                } else if (userMap.get(va) != null) {
                                    type = "user";
                                    id = userMap.get(va).toString();
                                }
                                if (type == null && id == null) {
                                    cusUserErrorHapen1 = true;
                                    continue;
                                }
                                lastCusId = id + "--" + type;
                                cusUserList.add((CallSite)lastCusId);
                            }
                            if (cusUserErrorHapen1) {
                                errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
                                break;
                            }
                            insMap.put(swapDataVo.getVModel(), multiple == false ? cusUserList.get(0) : JsonUtil.getObjectToString(cusUserList));
                            if (!swapDataVo.getSelectType().equals("custom")) break;
                            cusCheckModel.setDataList(cusUserList);
                            this.checkCustomControl(cusCheckModel, errList, i, label);
                            break;
                        }
                        case 6: {
                            dataList = this.checkOptionsControl(multiple, insMap, swapDataVo.getVModel(), label, roleMap, valueList, errList, i);
                            if (dataList.size() != valueList.size() || !swapDataVo.getSelectType().equals("custom")) break;
                            cusCheckModel.setDataList(dataList);
                            this.checkCustomControl(cusCheckModel, errList, i, label);
                            break;
                        }
                        case 7: {
                            dataList = this.checkOptionsControl(multiple, insMap, swapDataVo.getVModel(), label, groupMap, valueList, errList, i);
                            if (dataList.size() != valueList.size() || !swapDataVo.getSelectType().equals("custom")) break;
                            cusCheckModel.setDataList(dataList);
                            this.checkCustomControl(cusCheckModel, errList, i, label);
                            break;
                        }
                        case 8: {
                            if (!multiple.booleanValue() && valueList.size() > 1) {
                                errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
                                break;
                            }
                            errorHapen = false;
                            valueList = Arrays.asList(value.split(","));
                            addresss = new ArrayList<String[]>();
                            addressList1 = new ArrayList<E>();
                            va = valueList.iterator();
                            while (va.hasNext()) {
                                va = (String)va.next();
                                if (StringUtil.isEmpty((String)va)) {
                                    errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
                                    errorHapen = true;
                                    break;
                                }
                                addressSplit = va.split("/");
                                if (addressSplit.length != swapDataVo.getLevel() + 1) {
                                    errList.set(i, label + "\u503c\u7684\u683c\u5f0f\u4e0d\u6b63\u786e");
                                    errorHapen = true;
                                    break;
                                }
                                addressJoined = new ArrayList<String>();
                                addressParentID = new ArrayList<String>();
                                for (String add : addressSplit) {
                                    PRO = this.areaApi.getInfo(add, addressParentID);
                                    if (PRO == null) {
                                        errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
                                        errorHapen = true;
                                        break;
                                    }
                                    addressJoined.add((String)PRO.getId());
                                    addressParentID.add((String)PRO.getId());
                                }
                                if (errorHapen) break;
                                addressList1.addAll(addressJoined);
                                addresss.add(addressJoined.toArray(new String[addressJoined.size()]));
                            }
                            if (errorHapen) break;
                            insMap.put(swapDataVo.getVModel(), multiple != false ? JsonUtil.getObjectToString(addresss) : JsonUtil.getObjectToString(addressList1));
                            break;
                        }
                        case 9: {
                            OrgRelations = this.userRelationApi.getListByUserId(userInfo.getUserId(), "Organize");
                            insMap.put(swapDataVo.getVModel(), OrgRelations.size() > 0 ? ((UserRelationEntity)OrgRelations.get(0)).getObjectId() : null);
                            break;
                        }
                        case 10: {
                            depUserRelations = this.userRelationApi.getListByUserId(userInfo.getUserId(), "department");
                            insMap.put(swapDataVo.getVModel(), depUserRelations.size() > 0 ? ((UserRelationEntity)depUserRelations.get(0)).getObjectId() : null);
                            break;
                        }
                        case 11: {
                            insMap.put(swapDataVo.getVModel(), userEntity.getId());
                            break;
                        }
                        case 12: {
                            insMap.put(swapDataVo.getVModel(), DateUtil.getNow());
                            break;
                        }
                        case 13: {
                            break;
                        }
                        case 14: {
                            break;
                        }
                        case 15: {
                            insMap.put(swapDataVo.getVModel(), userEntity.getPositionId());
                            break;
                        }
                        case 16: {
                            activeTxt = swapDataVo.getActiveTxt();
                            inactiveTxt = swapDataVo.getInactiveTxt();
                            if (value.equals(activeTxt)) {
                                insMap.put(swapDataVo.getVModel(), 1);
                                break;
                            }
                            if (value.equals(inactiveTxt)) {
                                insMap.put(swapDataVo.getVModel(), 0);
                                break;
                            }
                            errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
                            break;
                        }
                        case 17: {
                            ratevalue = null;
                            try {
                                ratevalue = Double.valueOf(value);
                                if (ratevalue == null) {
                                    errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
                                }
                                ** GOTO lbl480
                            }
                            catch (Exception e) {
                                errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
                            }
                            break;
lbl480:
                            // 1 sources

                            maxvalue = 0.0;
                            if (swapDataVo.getCount() != -1) {
                                maxvalue = (double)swapDataVo.getCount();
                            }
                            if (ratevalue > maxvalue) {
                                errList.set(i, label + "\u503c\u4e0d\u80fd\u5927\u4e8e\u6700\u5927\u503c");
                                break;
                            }
                            if (swapDataVo.getAllowhalf().booleanValue()) {
                                if (ratevalue % 0.5 != 0.0 || ratevalue < 0.0) {
                                    errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
                                }
                            } else if (ratevalue % 1.0 != 0.0 || ratevalue < 0.0) {
                                errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
                            }
                            insMap.put(swapDataVo.getVModel(), ratevalue);
                            break;
                        }
                        case 18: {
                            Ivalue = null;
                            try {
                                Ivalue = new BigDecimal(value);
                                if (Ivalue == null) {
                                    errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
                                }
                                ** GOTO lbl511
                            }
                            catch (Exception e) {
                                errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
                            }
                            break;
lbl511:
                            // 1 sources

                            if (swapDataVo.getMin() != null && Ivalue.compareTo(min = new BigDecimal(swapDataVo.getMin())) == -1) {
                                errList.set(i, label + "\u503c\u4e0d\u80fd\u5c0f\u4e8e\u6700\u5c0f\u503c");
                                break;
                            }
                            if (swapDataVo.getMax() != null && Ivalue.compareTo(max = new BigDecimal(swapDataVo.getMax())) == 1) {
                                errList.set(i, label + "\u503c\u4e0d\u80fd\u5927\u4e8e\u6700\u5927\u503c");
                                break;
                            }
                            insMap.put(swapDataVo.getVModel(), Ivalue);
                            break;
                        }
                        case 19: {
                            if (!StringUtil.isNotEmpty((String)swapDataVo.getMaxlength()) || value.length() <= Integer.valueOf(swapDataVo.getMaxlength())) break;
                            errList.set(i, label + "\u503c\u8d85\u51fa\u6700\u591a\u8f93\u5165\u5b57\u7b26\u9650\u5236");
                            break;
                        }
                        case 20: {
                            unique = swapDataVo.getConfig().getUnique();
                            if (uniqueModel.isMain()) break;
                            if (StringUtil.isNotEmpty((String)swapDataVo.getMaxlength()) && value.length() > Integer.valueOf(swapDataVo.getMaxlength())) {
                                errList.set(i, label + "\u503c\u8d85\u51fa\u6700\u591a\u8f93\u5165\u5b57\u7b26\u9650\u5236");
                                break;
                            }
                            comInputError = false;
                            if (unique.booleanValue() && insMap.get("child_table_list") != null) {
                                childList = uniqueModel.getChildMap();
                                finalValue = value;
                                for (j = 0; j < childList.size(); ++j) {
                                    t = (Map)childList.get(j);
                                    if (!finalValue.equals(t.get(swapDataVo.getVModel()))) continue;
                                    comInputError = true;
                                    errList.set(i, label + "\u503c\u5df2\u5b58\u5728");
                                    uniqueModel.setChildIndex(Integer.valueOf(j));
                                    break;
                                }
                            }
                            if (StringUtil.isNotEmpty((Collection)swapDataVo.getConfig().getRegList())) {
                                regList = JsonUtil.getJsonToList((Object)swapDataVo.getConfig().getRegList(), RegListModel.class);
                                for (RegListModel regListModel : regList) {
                                    reg = regListModel.getPattern();
                                    if (reg.startsWith("/") && reg.endsWith("/")) {
                                        reg = reg.substring(1, reg.length() - 1);
                                    }
                                    if (matches = value.matches(reg)) continue;
                                    comInputError = true;
                                    errList.set(i, label + regListModel.getMessage());
                                }
                            }
                            if (comInputError) break;
                            insMap.put(swapDataVo.getVModel(), value);
                            break;
                        }
                        case 21: {
                            dataFomrat = "yyyy-MM-dd " + swapDataVo.getFormat();
                            valueTime = DateUtil.daFormat((Date)new Date()) + " " + value;
                            try {
                                if (swapDataVo.getFormat().length() != value.length()) {
                                    throw new DataException();
                                }
                                formatter = new SimpleDateFormat(dataFomrat);
                                formatter.setLenient(false);
                                regListModel = formatter.parse(valueTime);
                            }
                            catch (Exception e) {
                                errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
                                break;
                            }
                            try {
                                timeHasRangeError = FormPublicUtils.dateTimeCondition((FieLdsModel)swapDataVo, (String)dataFomrat, (Object)valueTime, data, (String)jnpfKey);
                                if (!timeHasRangeError) break;
                                errList.set(i, label + "\u503c\u4e0d\u5728\u8303\u56f4\u5185");
                            }
                            catch (Exception e) {
                                errList.set(i, label + "\u503c\u4e0d\u5728\u8303\u56f4\u5185");
                            }
                            break;
                        }
                        case 22: {
                            format = swapDataVo.getFormat();
                            valueDate = null;
                            try {
                                if (format.length() != value.length()) {
                                    throw new DataException();
                                }
                                formatter = new SimpleDateFormat(format);
                                formatter.setLenient(false);
                                valueDate = formatter.parse(value);
                            }
                            catch (Exception e) {
                                errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
                                break;
                            }
                            try {
                                timeHasRangeError = FormPublicUtils.dateTimeCondition((FieLdsModel)swapDataVo, (String)format, (Object)value, data, (String)jnpfKey);
                                if (timeHasRangeError) {
                                    errList.set(i, label + "\u503c\u4e0d\u5728\u8303\u56f4\u5185");
                                }
                                ** GOTO lbl610
                            }
                            catch (Exception e) {
                                errList.set(i, label + "\u503c\u4e0d\u5728\u8303\u56f4\u5185");
                            }
                            break;
lbl610:
                            // 1 sources

                            insMap.put(swapDataVo.getVModel(), valueDate.getTime());
                            break;
                        }
                        case 23: {
                            childJoiner = new StringJoiner(",");
                            childAllData = (List)data.get(swapDataVo.getVModel());
                            childTable = new ArrayList<HashMap<String, Object>>(childAllData.size());
                            uniqueModel.setChildMap(new ArrayList<E>());
                            childLen = childAllData.size();
                            for (childI = 0; childI < childLen; ++childI) {
                                item = (Map)childAllData.get(childI);
                                childMap = new HashMap<String, Object>(item);
                                childMap.put("mainAndMast", data);
                                childMap.put("child_table_list", data.get(swapDataVo.getVModel()));
                                childTableMap = new HashMap<String, Object>(childMap);
                                childerrorMap = new HashMap<String, Object>(childMap);
                                uniqueModel.setMain(false);
                                childJoiner1 = new StringJoiner(",");
                                childErrList = this.checkExcelData(swapDataVo.getConfig().getChildren(), childMap, localCache, childTableMap, childerrorMap, uniqueModel);
                                childErrList.stream().forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$checkExcelData$17(java.util.StringJoiner java.lang.String ), (Ljava/lang/String;)V)((StringJoiner)childJoiner1));
                                childList = uniqueModel.getChildMap();
                                if (childJoiner1.length() > 0) {
                                    if (uniqueModel.isUpdate() && uniqueModel.getChildIndex() != null && childJoiner1.toString().split(",").length == 1 && childJoiner1.toString().contains("\u503c\u5df2\u5b58\u5728")) {
                                        childList.set(uniqueModel.getChildIndex(), childTableMap);
                                        continue;
                                    }
                                    childJoiner.add(childJoiner1.toString());
                                    continue;
                                }
                                childList.add(childTableMap);
                                childTable.add(childTableMap);
                            }
                            if (childJoiner.length() == 0) {
                                insMap.put(swapDataVo.getVModel(), childTable);
                            } else {
                                errList.set(i, childJoiner.toString());
                            }
                            uniqueModel.setMain(true);
                            break;
                        }
                    }
                    if (dataType == null) continue;
                    options = new ArrayList<E>();
                    dataLabel = swapDataVo.getProps().getLabel() != null ? swapDataVo.getProps().getLabel() : "";
                    dataValue = swapDataVo.getProps().getValue() != null ? swapDataVo.getProps().getValue() : "";
                    children = swapDataVo.getProps().getChildren() != null ? swapDataVo.getProps().getChildren() : "";
                    isCascader = "cascader".equals(jnpfKey);
                    dataInterfaceMap /* !! */  = new HashMap<K, V>();
                    if (dataType.equals(OnlineDataTypeEnum.STATIC.getType())) {
                        localCacheKey = String.format("%s-%s", new Object[]{swapDataVo.getConfig().getRelationTable() + swapDataVo.getVModel(), OnlineDataTypeEnum.STATIC.getType()});
                        if (!localCache.containsKey(localCacheKey)) {
                            if (swapDataVo.getOptions() != null) {
                                options = JsonUtil.getJsonToListMap((String)swapDataVo.getOptions());
                                Children = swapDataVo.getProps().getChildren();
                                staticData = JsonUtil.getListToJsonArray(options);
                                OnlineSwapDataUtils.getOptions(dataLabel, dataValue, Children, staticData, options);
                            } else {
                                options = JsonUtil.getJsonToListMap((String)swapDataVo.getOptions());
                            }
                            finalDataInterfaceMap = new HashMap<K, V>(16);
                            finalDataLabel = dataLabel;
                            finalDataValue = dataValue;
                            options.stream().forEach((Consumer<Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$checkExcelData$18(java.util.Map java.lang.String java.lang.String java.util.Map ), (Ljava/util/Map;)V)(finalDataInterfaceMap, (String)finalDataLabel, (String)finalDataValue));
                            localCache.put(localCacheKey, finalDataInterfaceMap);
                            dataInterfaceMap /* !! */  = finalDataInterfaceMap;
                        } else {
                            dataInterfaceMap /* !! */  = (Map)localCache.get(localCacheKey);
                        }
                        this.checkFormDataInteface(multiple, insMap, swapDataVo.getVModel(), label, dataInterfaceMap /* !! */ , valueList, errList, i, isCascader);
                        continue;
                    }
                    if (dataType.equals(OnlineDataTypeEnum.DYNAMIC.getType())) {
                        localCacheKey = String.format("%s-%s-%s-%s", new Object[]{OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl(), dataValue, dataLabel});
                        if (!localCache.containsKey(localCacheKey)) {
                            templateJson = swapDataVo.getConfig().getTemplateJson();
                            param = new HashMap<String, String>();
                            for (TemplateJsonModel tm : templateJson) {
                                param.put(tm.getField(), tm.getDefaultValue());
                            }
                            actionResult = this.dataInterFaceApi.infoToId(swapDataVo.getConfig().getPropsUrl(), null, param);
                            if (actionResult != null && actionResult.getData() != null) {
                                dycDataList /* !! */  = new ArrayList<E>();
                                if (actionResult.getData() instanceof List) {
                                    dycDataList /* !! */  = (List)actionResult.getData();
                                }
                                dataAll = JsonUtil.getListToJsonArray(dycDataList /* !! */ );
                                OnlineSwapDataUtils.treeToList(dataLabel, dataValue, children, dataAll, options);
                                finalDataInterfaceMap1 = new HashMap<K, V>(16);
                                finalDataLabel2 = dataLabel;
                                finalDataValue1 = dataValue;
                                options.stream().forEach((Consumer<Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$checkExcelData$19(java.util.Map java.lang.String java.lang.String java.util.Map ), (Ljava/util/Map;)V)(finalDataInterfaceMap1, (String)finalDataLabel2, (String)finalDataValue1));
                                dataInterfaceMap /* !! */  = finalDataInterfaceMap1;
                                localCache.put(localCacheKey, dataInterfaceMap /* !! */ );
                            }
                        } else {
                            dataInterfaceMap /* !! */  = (Map)localCache.get(localCacheKey);
                        }
                        this.checkFormDataInteface(multiple, insMap, swapDataVo.getVModel(), label, dataInterfaceMap /* !! */ , valueList, errList, i, isCascader);
                        continue;
                    }
                    if (!dataType.equals(OnlineDataTypeEnum.DICTIONARY.getType())) continue;
                    localCacheKey = String.format("%s-%s", new Object[]{OnlineDataTypeEnum.DICTIONARY.getType(), swapDataVo.getConfig().getDictionaryType()});
                    dataLabel = swapDataVo.getProps().getLabel();
                    dataValue = swapDataVo.getProps().getValue();
                    if (!localCache.containsKey(localCacheKey)) {
                        list = this.dictionaryDataApi.getDicList(swapDataVo.getConfig().getDictionaryType());
                        options = list.stream().map((Function<DictionaryDataEntity, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkExcelData$20(jnpf.base.entity.DictionaryDataEntity ), (Ljnpf/base/entity/DictionaryDataEntity;)Ljava/util/Map;)()).collect(Collectors.toList());
                        localCache.put(localCacheKey, options);
                    } else {
                        options = (List)localCache.get(localCacheKey);
                    }
                    finalDataInterfaceMap1 = new HashMap<String, Object>(16);
                    finalDataLabel3 = dataLabel;
                    finalDataValue3 = dataValue;
                    options.stream().forEach((Consumer<Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$checkExcelData$21(java.util.Map java.lang.String java.lang.String java.util.Map ), (Ljava/util/Map;)V)(finalDataInterfaceMap1, (String)finalDataLabel3, (String)finalDataValue3));
                    this.checkFormDataInteface(multiple, insMap, swapDataVo.getVModel(), label, finalDataInterfaceMap1, valueList, errList, i, isCascader);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errList.set(i, e.getMessage());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return errList;
    }

    private List<String> checkOptionsControl(boolean multiple, Map<String, Object> insMap, String vModel, String label, Map<String, Object> cacheMap, List<String> valueList, List<String> errList, int i) {
        boolean error = false;
        if (!multiple && valueList.size() > 1) {
            error = true;
            errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
        }
        ArrayList<String> dataList = new ArrayList<String>();
        if (!error) {
            boolean errorHapen = false;
            for (String va : valueList) {
                if (StringUtil.isEmpty((String)va)) {
                    errorHapen = true;
                    break;
                }
                Object vo = cacheMap.get(va);
                if (vo == null) {
                    errorHapen = true;
                    break;
                }
                dataList.add(vo.toString());
            }
            if (errorHapen) {
                errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
            } else {
                insMap.put(vModel, !multiple ? dataList.get(0) : JsonUtil.getObjectToString(dataList));
            }
        }
        return dataList;
    }

    public void checkCustomControl(OnlineCusCheckModel cusCheckModel, List<String> errList, int i, String label) {
        ArrayList<CallSite> ableIdsAll = new ArrayList<CallSite>();
        List ableDepIds = cusCheckModel.getAbleDepIds();
        List ableGroupIds = cusCheckModel.getAbleGroupIds();
        List ablePosIds = cusCheckModel.getAblePosIds();
        List ableRoleIds = cusCheckModel.getAbleRoleIds();
        List ableUserIds = cusCheckModel.getAbleUserIds();
        List ableComIds = cusCheckModel.getAbleComIds();
        List ableComIdsStr = cusCheckModel.getAbleComIdsStr();
        List dataList = cusCheckModel.getDataList();
        String controlType = cusCheckModel.getControlType();
        switch (controlType) {
            case "groupSelect": {
                ableIdsAll.addAll(ableGroupIds);
                break;
            }
            case "roleSelect": {
                ableIdsAll.addAll(ableRoleIds);
                break;
            }
            case "depSelect": {
                ableIdsAll.addAll(ableDepIds);
                break;
            }
            case "organizeSelect": {
                ableIdsAll.addAll(ableComIdsStr);
                break;
            }
            case "usersSelect": {
                for (Object id : ableDepIds) {
                    ableIdsAll.add((CallSite)((Object)((String)id + "--department")));
                }
                for (Object id : ableGroupIds) {
                    ableIdsAll.add((CallSite)((Object)((String)id + "--group")));
                }
                for (Object id : ablePosIds) {
                    ableIdsAll.add((CallSite)((Object)((String)id + "--position")));
                }
                for (Object id : ableRoleIds) {
                    ableIdsAll.add((CallSite)((Object)((String)id + "--role")));
                }
                for (Object id : ableUserIds) {
                    ableIdsAll.add((CallSite)((Object)((String)id + "--user")));
                }
                for (Object id : ableComIds) {
                    ableIdsAll.add((CallSite)((Object)((String)id + "--company")));
                }
                ableIdsAll.addAll(ableDepIds);
                ableIdsAll.addAll(ableGroupIds);
                ableIdsAll.addAll(ablePosIds);
                ableIdsAll.addAll(ableRoleIds);
                ableIdsAll.addAll(ableUserIds);
                ableIdsAll.addAll(ableComIds);
                List listByObjectIdAll = this.userRelationApi.getListByObjectIdAll(ableIdsAll);
                for (UserRelationEntity userRelationEntity : listByObjectIdAll) {
                    ableIdsAll.add((CallSite)((Object)(userRelationEntity.getUserId() + "--user")));
                }
                break;
            }
            case "userSelect": {
                ArrayList<String> lastIds;
                ArrayList objIds = new ArrayList();
                if (ableComIds.size() > 0) {
                    lastIds = new ArrayList<String>();
                    for (String str : ableComIds) {
                        lastIds.add(str);
                    }
                    objIds.addAll(lastIds);
                }
                if (ableDepIds.size() > 0) {
                    lastIds = new ArrayList();
                    for (String str : ableDepIds) {
                        lastIds.add(str);
                    }
                    objIds.addAll(lastIds);
                }
                if (ableGroupIds.size() > 0) {
                    objIds.addAll(ableGroupIds);
                }
                if (ablePosIds.size() > 0) {
                    objIds.addAll(ablePosIds);
                }
                if (ableRoleIds.size() > 0) {
                    objIds.addAll(ableRoleIds);
                }
                List UserIds = this.userRelationApi.getListByObjectIdAll(objIds).stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
                UserIds.addAll(ableUserIds);
                ableIdsAll.addAll(UserIds);
                break;
            }
            case "posSelect": {
                ArrayList posIds = new ArrayList();
                if (ableDepIds.size() > 0) {
                    List depIds = this.positionApi.getListByOrganizeId(ableDepIds, false).stream().map(SuperBaseEntity.SuperIBaseEntity::getId).collect(Collectors.toList());
                    posIds.addAll(depIds);
                }
                if (ablePosIds.size() > 0) {
                    posIds.addAll(ablePosIds);
                }
                ableIdsAll.addAll(posIds);
                break;
            }
        }
        if (ableIdsAll.size() > 0) {
            for (String id : dataList) {
                boolean contains = ableIdsAll.contains(id);
                if (contains) continue;
                errList.set(i, label + "\u503c\u4e0d\u5728\u8303\u56f4\u5185");
                break;
            }
        }
    }

    public void checkFormDataInteface(boolean multiple, Map<String, Object> insMap, String vModel, String label, Map<String, Object> cacheMap, List<String> valueList, List<String> errList, int i, boolean isCascader) {
        ArrayList<String[]> staticStrData = new ArrayList<String[]>();
        ArrayList<String> staticStrDataList1 = new ArrayList<String>();
        if (!multiple && valueList.size() > 1) {
            errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
            return;
        }
        boolean hasError = false;
        boolean takeOne = false;
        for (String dicValue : valueList) {
            if (isCascader) {
                ArrayList<String> staticStrDataList2 = new ArrayList<String>();
                if (!multiple && valueList.size() > 1) {
                    hasError = true;
                }
                if (dicValue.contains("/")) {
                    String[] split;
                    for (String s : split = dicValue.split("/")) {
                        Object s1 = cacheMap.get(s);
                        if (s1 != null) {
                            staticStrDataList2.add(s1.toString());
                            staticStrDataList1.add(s1.toString());
                            continue;
                        }
                        hasError = true;
                    }
                    staticStrData.add(staticStrDataList2.toArray(new String[staticStrDataList2.size()]));
                    continue;
                }
                if (cacheMap.get(dicValue) == null) {
                    hasError = true;
                    continue;
                }
                staticStrDataList1.add(cacheMap.get(dicValue).toString());
                staticStrData.add(new String[]{cacheMap.get(dicValue).toString()});
                continue;
            }
            takeOne = true;
            Object s1 = cacheMap.get(dicValue);
            if (s1 != null) {
                staticStrDataList1.add(s1.toString());
                continue;
            }
            hasError = true;
        }
        if (hasError) {
            errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
        } else {
            String v = multiple ? (takeOne ? JsonUtil.getObjectToString(staticStrDataList1) : JsonUtil.getObjectToString(staticStrData)) : (takeOne ? (String)staticStrDataList1.get(0) : JsonUtil.getObjectToString(staticStrDataList1));
            insMap.put(vModel, v);
        }
    }

    public List<Map<String, Object>> getInterfaceData(VisualdevReleaseEntity visualdevEntity, PaginationModel paginationModel, ColumnDataModel columnDataModel) {
        List<Map<String, Object>> realList = new ArrayList<Map<String, Object>>();
        try {
            Map queryMap = JsonUtil.stringToMap((String)paginationModel.getQueryJson());
            Map extraMap = JsonUtil.stringToMap((String)paginationModel.getExtraQueryJson());
            extraMap = extraMap == null ? new HashMap() : extraMap;
            DataInterfaceEntity info = this.dataInterFaceApi.getInfo(visualdevEntity.getInterfaceId());
            if (info.getHasPage() == 1) {
                DataInterfacePage page = new DataInterfacePage();
                page.setCurrentPage(paginationModel.getCurrentPage());
                page.setPageSize(paginationModel.getPageSize());
                if ("1".equals(paginationModel.getDataType())) {
                    page.setPageSize(99999999L);
                }
                List jsonToList = JsonUtil.getJsonToList((String)visualdevEntity.getInterfaceParam(), DataInterfaceModel.class);
                for (DataInterfaceModel df : jsonToList) {
                    String thisValue;
                    if (queryMap != null && queryMap.containsKey(df.getField()) && queryMap.get(df.getField()) != null && StringUtil.isNotEmpty((String)queryMap.get(df.getField()).toString())) {
                        thisValue = queryMap.get(df.getField()).toString();
                        if (extraMap.containsKey(df.getField())) {
                            thisValue = extraMap.get(df.getField()).toString();
                        }
                        if (Objects.equals(df.getSourceType(), 2)) {
                            df.setRelationField(thisValue);
                        }
                        df.setDefaultValue((Object)thisValue);
                        continue;
                    }
                    if (!extraMap.containsKey(df.getField())) continue;
                    thisValue = extraMap.get(df.getField()).toString();
                    if (Objects.equals(df.getSourceType(), 2)) {
                        df.setRelationField(thisValue);
                    }
                    df.setDefaultValue((Object)thisValue);
                }
                page.setParamList(jsonToList);
                ActionResult actionResult = this.dataInterFaceApi.infoToIdPageList(visualdevEntity.getInterfaceId(), page);
                if (actionResult.getCode() == 200) {
                    PageListVO data = (PageListVO)JsonUtil.getJsonToBean((Object)actionResult.getData(), PageListVO.class);
                    realList = data.getList();
                    PaginationVO pagination = data.getPagination();
                    paginationModel.setTotal((long)pagination.getTotal().intValue());
                }
            } else {
                HashMap<String, String> parameterMap = new HashMap<String, String>();
                if (StringUtil.isNotEmpty((String)visualdevEntity.getInterfaceParam())) {
                    List jsonToList = JsonUtil.getJsonToList((String)visualdevEntity.getInterfaceParam(), InterefaceParamModel.class);
                    for (InterefaceParamModel mapStr : jsonToList) {
                        TemplateJsonModel jsonToBean = (TemplateJsonModel)JsonUtil.getJsonToBean((Object)mapStr, TemplateJsonModel.class);
                        String dataValue = this.paramSourceTypeReplaceValue(jsonToBean, null);
                        mapStr.setDefaultValue(dataValue);
                        if (mapStr.getUseSearch() != null && Objects.equals(mapStr.getUseSearch(), true)) {
                            Map keyJsonMap = queryMap;
                            if (keyJsonMap != null && keyJsonMap.get(mapStr.getField()) != null && StringUtil.isNotEmpty((String)keyJsonMap.get(mapStr.getField()).toString())) {
                                parameterMap.put(mapStr.getField(), keyJsonMap.get(mapStr.getField()).toString());
                                continue;
                            }
                            parameterMap.put(mapStr.getField(), null);
                            continue;
                        }
                        parameterMap.put(mapStr.getField(), mapStr.getDefaultValue());
                    }
                }
                List<FieLdsModel> queryCondition = this.getQueryCondition(paginationModel, columnDataModel);
                OnlinePublicUtils.getViewQuerySql(info, queryCondition, parameterMap, extraMap);
                ActionResult dataInterfaceInfo = this.dataInterFaceApi.infoToId(visualdevEntity.getInterfaceId(), null, parameterMap);
                if (dataInterfaceInfo.getCode() == 200) {
                    List dataRes = (List)dataInterfaceInfo.getData();
                    List<Map<String, Object>> dataInterfaceList = OnlinePublicUtils.getViewQueryNotSql(info, queryCondition, dataRes, extraMap);
                    dataInterfaceList.forEach(item -> {
                        if (item.get("id") == null) {
                            item.put("id", RandomUtil.uuId());
                        }
                        if (item.get("f_id") != null) {
                            item.put("id", item.get("f_id"));
                        }
                        if (item.get("children") != null) {
                            item.remove("children");
                        }
                    });
                    if (StringUtil.isNotEmpty((String)paginationModel.getSidx())) {
                        final String[] split = paginationModel.getSidx().split(",");
                        Collections.sort(dataInterfaceList, new Comparator<Map<String, Object>>(){

                            @Override
                            public int compare(Map<String, Object> a, Map<String, Object> b) {
                                String[] stringArray = split;
                                int n = stringArray.length;
                                for (int i = 0; i < n; ++i) {
                                    String sidx;
                                    String key = sidx = stringArray[i];
                                    if (sidx.startsWith("-")) {
                                        key = sidx.substring(1);
                                    }
                                    if (a.get(key) == null) {
                                        if (b.get(key) == null) {
                                            return 0;
                                        }
                                        return 1;
                                    }
                                    if (b.get(key) == null) {
                                        return -1;
                                    }
                                    if (a.get(key).equals(b.get(key))) continue;
                                    return String.valueOf(b.get(key)).compareTo(String.valueOf(a.get(key)));
                                }
                                return 0;
                            }
                        });
                    }
                    if ("1".equals(paginationModel.getDataType())) {
                        return dataInterfaceList;
                    }
                    if (columnDataModel.getHasPage().booleanValue() && CollectionUtils.isNotEmpty(dataInterfaceList)) {
                        List partition = Lists.partition(dataInterfaceList, (int)((int)paginationModel.getPageSize()));
                        int i = (int)paginationModel.getCurrentPage() - 1;
                        realList = partition.size() > i ? (List)partition.get(i) : Collections.emptyList();
                        paginationModel.setTotal((long)dataInterfaceList.size());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u6570\u636e\u89c6\u56fe\uff0c\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25!message={}", (Object)e.getMessage());
        }
        this.dataId(realList, columnDataModel.getViewKey());
        return realList;
    }

    private void dataId(List<Map<String, Object>> data, String key) {
        for (Map<String, Object> item : data) {
            if (item.get("id") == null) {
                item.put("id", RandomUtil.uuId());
            }
            if (item.get("f_id") != null) {
                item.put("id", item.get("f_id"));
            }
            if (item.get(key) != null) {
                item.put("id", item.get(key));
            }
            if (item.get("children") == null) continue;
            ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
            try {
                children.addAll(JsonUtil.getJsonToListMap((String)String.valueOf(item.get("children"))));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (children.size() <= 0) continue;
            this.dataId(children, null);
            item.put("children", children);
        }
    }

    public static List convertToList(Object obj) {
        if (obj instanceof List) {
            List arrayList = (List)obj;
            return arrayList;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(obj);
        return arrayList;
    }

    public static String convertValueToString(String obj, boolean mult, boolean isOrg) {
        if (StringUtil.isNotEmpty((String)obj)) {
            String prefix = "[";
            if (isOrg) {
                prefix = "[[";
            }
            if (mult) {
                if (!obj.startsWith(prefix)) {
                    JSONArray arr = new JSONArray();
                    if (isOrg) {
                        arr.add(JSONArray.parse((String)obj));
                    } else {
                        arr.add((Object)obj);
                    }
                    return arr.toJSONString();
                }
            } else if (obj.startsWith(prefix)) {
                JSONArray objects = JSONArray.parseArray((String)obj);
                return objects.size() > 0 ? objects.get(0).toString() : "";
            }
        }
        return obj;
    }

    public static String getLastOrganizeId(Object data) {
        if (data instanceof List) {
            List listData = (List)data;
            data = listData.get(listData.size() - 1);
            return OnlineSwapDataUtils.getLastOrganizeId(data);
        }
        if (data instanceof String) {
            String strData = (String)data;
            if (strData.startsWith("[")) {
                JSONArray jsonArray = JSONArray.parseArray((String)strData);
                return OnlineSwapDataUtils.getLastOrganizeId(jsonArray);
            }
            return strData;
        }
        return data.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void swapDatetime(List<FieLdsModel> list, Map<String, Object> map) {
        ArrayList fields = new ArrayList();
        FormPublicUtils.recursionFieldsExceptChild(fields, list);
        for (FieLdsModel field : fields) {
            try {
                String s;
                String vModel = field.getVModel();
                String format = DateTimeFormatConstant.getFormat((String)field.getFormat());
                ConfigModel config = field.getConfig();
                if (map.get(vModel) != null && (StringUtil.isBlank((CharSequence)(s = map.get(vModel).toString())) || "[]".equals(s) || "[[]]".equals(s))) {
                    map.replace(vModel, null);
                }
                if (map.get(vModel) == null) {
                    String dbType = "";
                    try {
                        Connection connection = DynamicDataSourceUtil.getCurrentConnection();
                        try {
                            dbType = connection.getMetaData().getDatabaseProductName().trim();
                        }
                        finally {
                            if (Collections.singletonList(connection).get(0) != null) {
                                connection.close();
                            }
                        }
                    }
                    catch (Exception connection) {
                        // empty catch block
                    }
                    if (JnpfKeyConsts.getTextField().contains(config.getJnpfKey()) && "Microsoft SQL Server".equals(dbType)) {
                        map.put(vModel, "");
                    }
                }
                if ("datePicker".equals(config.getJnpfKey()) && map.get(vModel) != null) {
                    Date date = new Date(Long.parseLong(String.valueOf(map.get(vModel))));
                    Object completionStr = "";
                    switch (format) {
                        case "yyyy": {
                            completionStr = "-01-01 00:00:00";
                            break;
                        }
                        case "yyyy-MM": {
                            completionStr = "-01 00:00:00";
                            break;
                        }
                        case "yyyy-MM-dd": {
                            completionStr = " 00:00:00";
                            break;
                        }
                        case "yyyy-MM-dd HH": {
                            completionStr = ":00:00";
                            break;
                        }
                        case "yyyy-MM-dd HH:mm": {
                            completionStr = ":00";
                            break;
                        }
                    }
                    String datestr = DateUtil.dateToString((Date)date, (String)format);
                    long time = DateUtil.stringToDate((String)(datestr + (String)completionStr)).getTime();
                    map.replace(vModel, time);
                }
                if (!"editor".equals(config.getJnpfKey()) || map.get(vModel) == null) continue;
                map.replace(vModel, XSSEscape.escapeImgOnlyBase64((String)map.get(vModel).toString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (FieLdsModel field : fields) {
            List listObj;
            String tableFieldKey;
            List children;
            if (!field.getVModel().toLowerCase().startsWith("tablefield") || !CollectionUtils.isNotEmpty((Collection)(children = field.getConfig().getChildren()))) continue;
            String tableKey = field.getConfig().getTableName() + "List";
            if (map.get(tableKey) != null) {
                List listObj2 = (List)map.get(tableKey);
                if (CollectionUtils.isEmpty((Collection)listObj2)) continue;
                ArrayList<Map> listObjNew = new ArrayList<Map>();
                for (Object o : listObj2) {
                    Map stringObjectMap = JsonUtil.entityToMap(o);
                    OnlineSwapDataUtils.swapDatetime(children, stringObjectMap);
                    listObjNew.add(stringObjectMap);
                }
                if (CollectionUtils.isNotEmpty(listObjNew)) {
                    map.replace(tableKey, listObjNew);
                }
            }
            if (map.get(tableFieldKey = field.getVModel()) == null || CollectionUtils.isEmpty((Collection)(listObj = (List)map.get(tableFieldKey)))) continue;
            ArrayList<Map> listObjNew = new ArrayList<Map>();
            for (Object o : listObj) {
                Map stringObjectMap = JsonUtil.entityToMap(o);
                OnlineSwapDataUtils.swapDatetime(children, stringObjectMap);
                listObjNew.add(stringObjectMap);
            }
            if (!CollectionUtils.isNotEmpty(listObjNew)) continue;
            map.replace(tableFieldKey, listObjNew);
        }
    }

    private boolean orgListRight(List<List<String>> comTwoList, List<String> comOneList) {
        if (CollectionUtils.isNotEmpty(comOneList)) {
            String one = comOneList.get(comOneList.size() - 1);
            List<Object> realOrgs = new ArrayList();
            OrganizeEntity organizeEntity = this.organizeApi.getInfo(one);
            if (organizeEntity != null && StringUtil.isNotEmpty((String)organizeEntity.getOrganizeIdTree())) {
                String[] split = organizeEntity.getOrganizeIdTree().split(",");
                if (split.length > 0) {
                    realOrgs = Arrays.asList(split);
                }
                if (!JsonUtil.getObjectToString(comOneList).equals(JsonUtil.getObjectToString(realOrgs))) {
                    return true;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(comTwoList) && comTwoList.size() > 0) {
            for (List<String> two : comTwoList) {
                if (two.size() <= 0) {
                    return false;
                }
                String one = two.get(two.size() - 1);
                List<Object> realOrgs = new ArrayList();
                OrganizeEntity organizeEntity = this.organizeApi.getInfo(one);
                if (organizeEntity == null || !StringUtil.isNotEmpty((String)organizeEntity.getOrganizeIdTree())) continue;
                String[] split = organizeEntity.getOrganizeIdTree().split(",");
                if (split.length > 0) {
                    realOrgs = Arrays.asList(split);
                }
                if (JsonUtil.getObjectToString(comOneList).equals(JsonUtil.getObjectToString(realOrgs))) continue;
                return true;
            }
        }
        return false;
    }

    public List<FieLdsModel> getQueryCondition(PaginationModel paginationModel, ColumnDataModel columnDataModel) {
        List searchVOList = JsonUtil.getJsonToList((String)columnDataModel.getSearchList(), FieLdsModel.class);
        Map keyJsonMap = JsonUtil.stringToMap((String)paginationModel.getQueryJson());
        ArrayList<FieLdsModel> searchResList = new ArrayList<FieLdsModel>();
        if (keyJsonMap == null) {
            return searchResList;
        }
        for (String key : keyJsonMap.keySet()) {
            for (FieLdsModel item : searchVOList) {
                String jnpfKey;
                String vModel = item.getVModel();
                if (!key.equals(vModel) || keyJsonMap.get(key) == null || item.getConfig().getIsFromParam().booleanValue()) continue;
                FieLdsModel model = (FieLdsModel)BeanUtil.copyProperties((Object)item, FieLdsModel.class, (String[])new String[0]);
                switch (jnpfKey = model.getConfig().getJnpfKey()) {
                    case "input": {
                        if (Objects.equals(model.getSearchType(), 3)) {
                            model.setSearchType(Integer.valueOf(2));
                        }
                        model.setFieldValue(String.valueOf(keyJsonMap.get(vModel)));
                        break;
                    }
                    case "inputNumber": {
                        model.setSearchType(Integer.valueOf(3));
                        List integerList = JsonUtil.getJsonToList(keyJsonMap.get(vModel), Long.class);
                        model.setFieldValueOne(integerList.get(0));
                        model.setFieldValueTwo(integerList.get(1));
                        break;
                    }
                    case "datePicker": {
                        model.setSearchType(Integer.valueOf(3));
                        List dateList = JsonUtil.getJsonToList(keyJsonMap.get(vModel), Long.class);
                        String timeOne = FormPublicUtils.getTimeFormat((String)DateUtil.dateToString((Date)new Date((Long)dateList.get(0)), (String)model.getFormat()));
                        String timeTwo = FormPublicUtils.getTimeFormat((String)DateUtil.dateToString((Date)new Date((Long)dateList.get(1)), (String)model.getFormat()));
                        model.setFieldValueOne((Object)timeOne);
                        model.setFieldValueTwo((Object)timeTwo);
                        break;
                    }
                    case "timePicker": {
                        model.setSearchType(Integer.valueOf(3));
                        List stringList = JsonUtil.getJsonToList(keyJsonMap.get(vModel), String.class);
                        model.setFieldValueOne(stringList.get(0));
                        model.setFieldValueTwo(stringList.get(1));
                        break;
                    }
                    case "select": 
                    case "posSelect": 
                    case "roleSelect": 
                    case "groupSelect": {
                        model.setSearchType(Integer.valueOf(4));
                        ArrayList<String> dataList = new ArrayList<String>();
                        try {
                            List list = JsonUtil.getJsonToList(keyJsonMap.get(vModel), String.class);
                            dataList.addAll(list);
                        }
                        catch (Exception e1) {
                            dataList.add(String.valueOf(keyJsonMap.get(vModel)));
                        }
                        model.setDataList(dataList);
                        break;
                    }
                    case "organizeSelect": {
                        model.setSearchType(Integer.valueOf(4));
                        ArrayList<String> listOrg = new ArrayList<String>();
                        ArrayList<String> orgListRes = new ArrayList<String>();
                        if (model.getSearchMultiple().booleanValue()) {
                            list = (List)JsonUtil.getJsonToBean(keyJsonMap.get(vModel), List.class);
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                List a = (List)iterator.next();
                                listOrg.add((String)a.get(a.size() - 1));
                                orgListRes.add(JSONArray.toJSONString((Object)a));
                            }
                        } else {
                            list = (List)JsonUtil.getJsonToBean(keyJsonMap.get(vModel), List.class);
                            listOrg.add((String)list.get(list.size() - 1));
                            orgListRes.add(JSONArray.toJSONString((Object)list));
                        }
                        if (model.getIsIncludeSubordinate().booleanValue()) {
                            for (String org : listOrg) {
                                List underOrganizations = this.organizeApi.getUnderOrganizations(org, false);
                                for (String itemOrg : underOrganizations) {
                                    String[] split;
                                    OrganizeEntity organizeEntity = this.organizeApi.getInfo(itemOrg);
                                    if (organizeEntity == null || !StringUtil.isNotEmpty((String)organizeEntity.getOrganizeIdTree()) || (split = organizeEntity.getOrganizeIdTree().split(",")).length <= 0) continue;
                                    orgListRes.add(JSONArray.toJSONString(Arrays.asList(split)));
                                }
                            }
                            model.setDataList(orgListRes);
                            break;
                        }
                        model.setDataList(orgListRes);
                        break;
                    }
                    case "depSelect": {
                        model.setSearchType(Integer.valueOf(4));
                        ArrayList<String> listDep = new ArrayList<String>();
                        ArrayList<String> depListRes = new ArrayList<String>();
                        if (model.getSearchMultiple().booleanValue()) {
                            List list = (List)JsonUtil.getJsonToBean(keyJsonMap.get(vModel), List.class);
                            listDep.addAll(list);
                            depListRes.addAll(list);
                        } else {
                            listDep.add(String.valueOf(keyJsonMap.get(vModel)));
                            depListRes.add(String.valueOf(keyJsonMap.get(vModel)));
                        }
                        if (model.getIsIncludeSubordinate().booleanValue()) {
                            for (String org : listDep) {
                                List underOrganizations = this.organizeApi.getUnderOrganizations(org, false);
                                depListRes.addAll(underOrganizations);
                            }
                            model.setDataList(depListRes);
                            break;
                        }
                        model.setDataList(depListRes);
                        break;
                    }
                    case "userSelect": {
                        model.setSearchType(Integer.valueOf(4));
                        ArrayList<String> listUser = new ArrayList<String>();
                        ArrayList<String> userListRes = new ArrayList<String>();
                        if (model.getSearchMultiple().booleanValue()) {
                            List list = (List)JsonUtil.getJsonToBean(keyJsonMap.get(vModel), List.class);
                            listUser.addAll(list);
                            userListRes.addAll(list);
                        } else {
                            listUser.add(String.valueOf(keyJsonMap.get(vModel)));
                            userListRes.add(String.valueOf(keyJsonMap.get(vModel)));
                        }
                        if (model.getIsIncludeSubordinate().booleanValue()) {
                            for (String userId : listUser) {
                                List underOrganizations = this.userApi.getListByManagerId(userId, null);
                                List collect = underOrganizations.stream().map(SuperBaseEntity.SuperIBaseEntity::getId).collect(Collectors.toList());
                                userListRes.addAll(collect);
                            }
                            model.setDataList(userListRes);
                            break;
                        }
                        model.setDataList(userListRes);
                        break;
                    }
                    default: {
                        model.setFieldValue(String.valueOf(keyJsonMap.get(vModel)));
                    }
                }
                searchResList.add(model);
            }
        }
        return searchResList;
    }

    public ExcelModel getDefaultValue(String formJson, List<String> selectKey) {
        FormDataModel formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)formJson, FormDataModel.class);
        List fieLdsModels = JsonUtil.getJsonToList((String)formDataModel.getFields(), FieLdsModel.class);
        ArrayList allFieLds = new ArrayList();
        VisualUtils.recursionFields((List)fieLdsModels, allFieLds);
        HashMap<Object, String[]> optionMap = new HashMap<Object, String[]>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        ArrayList<ExcelColumnAttr> models = new ArrayList<ExcelColumnAttr>();
        for (String s2 : selectKey.stream().filter(s -> !s.toLowerCase().startsWith("tablefield")).collect(Collectors.toList())) {
            FieLdsModel fieLdsModel = allFieLds.stream().filter(c -> c.getVModel().equals(s2)).findFirst().orElse(null);
            fieLdsModel.setId(fieLdsModel.getVModel());
            models.add(ExcelColumnAttr.builder().key(fieLdsModel.getVModel()).name(fieLdsModel.getLabel()).require(fieLdsModel.getConfig().isRequired()).fontColor(IndexedColors.RED.getIndex()).build());
            dataMap.put(s2, VisualUtils.exampleExcelMessage((FieLdsModel)fieLdsModel));
            String[] options = this.getOptions(fieLdsModel);
            if (options == null || options.length <= 0) continue;
            optionMap.put(fieLdsModel.getVModel(), options);
        }
        List childFields = allFieLds.stream().filter(f -> f.getConfig().getJnpfKey().equals("table")).collect(Collectors.toList());
        for (FieLdsModel child : childFields) {
            List childList = selectKey.stream().filter(s -> s.startsWith(child.getVModel())).collect(Collectors.toList());
            childList.stream().forEach(c -> c.replace(child.getVModel() + "-", ""));
            List children = child.getConfig().getChildren();
            ArrayList childData = new ArrayList();
            HashMap<String, String> childMap = new HashMap<String, String>();
            for (String cl : childList) {
                String substring = cl.substring(cl.indexOf("-") + 1);
                FieLdsModel fieLdsModel = children.stream().filter(c -> c.getVModel().equals(substring)).findFirst().orElse(null);
                String id = fieLdsModel.getConfig().getParentVModel() + "-" + fieLdsModel.getVModel();
                fieLdsModel.setId(id);
                models.add(ExcelColumnAttr.builder().key(cl).name(fieLdsModel.getLabel()).require(fieLdsModel.getConfig().isRequired()).fontColor(IndexedColors.RED.getIndex()).build());
                childMap.put(substring, VisualUtils.exampleExcelMessage((FieLdsModel)fieLdsModel));
                String[] options = this.getOptions(fieLdsModel);
                if (options == null || options.length <= 0) continue;
                optionMap.put(id, options);
            }
            childData.add(childMap);
            dataMap.put(child.getVModel(), childData);
        }
        return ExcelModel.builder().selectKey(selectKey).models(models).dataMap(dataMap).optionMap(optionMap).build();
    }

    public String[] getOptions(FieLdsModel model) {
        String[] options;
        block3: {
            String dataType;
            String labelkey;
            block5: {
                block4: {
                    ConfigModel config = model.getConfig();
                    String jnpfKey = config.getJnpfKey();
                    options = null;
                    if ("switch".equals(jnpfKey)) {
                        options = new String[]{model.getActiveTxt(), model.getInactiveTxt()};
                    }
                    Boolean multiple = model.getMultiple();
                    if ((!"select".equals(jnpfKey) || multiple.booleanValue()) && !"radio".equals(jnpfKey)) break block3;
                    String selectOptions = model.getOptions();
                    PropsModel props = model.getProps();
                    labelkey = props.getLabel();
                    dataType = model.getConfig().getDataType();
                    if (!"static".equals(dataType)) break block4;
                    List list = JsonUtil.getJsonToList((String)selectOptions, Map.class);
                    options = new String[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        String label;
                        Map map = (Map)list.get(i);
                        options[i] = label = (String)map.get(props.getLabel());
                    }
                    break block3;
                }
                if (!"dictionary".equals(dataType)) break block5;
                List list = this.dictionaryDataApi.getList(model.getConfig().getDictionaryType(), Boolean.valueOf(true));
                options = list.stream().map(DictionaryDataEntity::getFullName).collect(Collectors.toList()).toArray(new String[0]);
                break block3;
            }
            if (!"dynamic".equals(dataType)) break block3;
            ActionResult result = this.dataInterFaceApi.infoToId(model.getConfig().getPropsUrl(), null, new HashMap());
            ArrayList arr = (ArrayList)result.getData();
            options = new String[arr.size()];
            for (int i = 0; i < arr.size(); ++i) {
                Map data = (Map)arr.get(i);
                options[i] = (String)data.get(labelkey);
            }
        }
        return options;
    }

    public void getFlowStatus(List<Map<String, Object>> list) throws WorkFlowException {
        ArrayList<String> ids = new ArrayList<String>();
        for (Map<String, Object> item : list) {
            this.getFLowFields(item);
            if (!Objects.nonNull(item.get("flowTaskId"))) continue;
            ids.add(item.get("flowTaskId").toString());
        }
        List tasks = this.taskApi.getInfosSubmit(ids.toArray(new String[0]), new SFunction[]{TaskEntity::getStatus, SuperBaseEntity.SuperIBaseEntity::getId});
        for (Map<String, Object> m : list) {
            if (m == null || !Objects.nonNull(m.get("flowTaskId"))) continue;
            String flowTaskId = m.get("flowTaskId").toString();
            m.put("flowState", 0);
            tasks.forEach(i -> {
                if (((String)i.getId()).equals(flowTaskId)) {
                    m.put("flowState", i.getStatus());
                }
            });
        }
    }

    public void getFLowFields(Map<String, Object> item) {
        CaseInsensitiveMap t = new CaseInsensitiveMap(item);
        String flowTaskId = "";
        if (t != null && t.get("flowTaskId") != null) {
            flowTaskId = t.get("flowTaskId").toString();
        }
        if (t != null && t.get(TableFeildsEnum.FLOWTASKID.getField()) != null) {
            flowTaskId = t.get(TableFeildsEnum.FLOWTASKID.getField()).toString();
        }
        item.put("flowTaskId", flowTaskId);
        String flowId = "";
        if (t != null && t.get("flowId") != null) {
            flowId = t.get("flowId").toString();
        }
        if (t != null && t.get(TableFeildsEnum.FLOWID.getField()) != null) {
            flowId = t.get(TableFeildsEnum.FLOWID.getField()).toString();
        }
        item.put("flowId", flowId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkUnique(List<FieLdsModel> modelList, Map<String, Object> data, List<String> errList, ImportFormCheckUniqueModel uniqueModel) {
        block12: for (int i = 0; i < modelList.size(); ++i) {
            FieLdsModel swapDataVo = modelList.get(i);
            String jnpfKey = swapDataVo.getConfig().getJnpfKey();
            Object valueO = data.get(swapDataVo.getVModel());
            String label = swapDataVo.getConfig().getLabel();
            String value = String.valueOf(valueO);
            if (ObjectUtil.isEmpty((Object)valueO) || !"input".equals(jnpfKey) || !uniqueModel.isMain()) continue;
            if (StringUtil.isNotEmpty((String)swapDataVo.getMaxlength()) && value.length() > Integer.valueOf(swapDataVo.getMaxlength())) {
                errList.set(i, label + "\u503c\u8d85\u51fa\u6700\u591a\u8f93\u5165\u5b57\u7b26\u9650\u5236");
                break;
            }
            try {
                DbLinkEntity linkEntity = this.dataSourceApi.getInfo(uniqueModel.getDbLinkId());
                DynamicDataSourceUtil.switchToDataSource((DbLinkEntity)linkEntity);
                Connection connection = DynamicDataSourceUtil.getCurrentConnection();
                try {
                    String databaseProductName = connection.getMetaData().getDatabaseProductName().trim();
                    Boolean unique = swapDataVo.getConfig().getUnique();
                    if (unique.booleanValue()) {
                        SelectStatementProvider render;
                        List mapList;
                        int count;
                        TableFields tableFields;
                        boolean exists = false;
                        List importDataModel = uniqueModel.getImportDataModel();
                        List successList = importDataModel.stream().map(ImportDataModel::getResultData).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(successList)) {
                            for (int uniqueIndex = 0; uniqueIndex < successList.size(); ++uniqueIndex) {
                                if (!value.equals(String.valueOf(((Map)successList.get(uniqueIndex)).get(swapDataVo.getVModel())))) continue;
                                errList.set(i, label + "\u503c\u5df2\u5b58\u5728");
                                exists = true;
                                break;
                            }
                        }
                        if (exists) break;
                        String tableName = Optional.ofNullable(swapDataVo.getConfig().getRelationTable()).orElse(swapDataVo.getConfig().getTableName());
                        SqlTable sqlTable = SqlTable.of((String)tableName);
                        String key = this.flowDataUtil.getTableKey(connection, tableName);
                        String vModelThis = swapDataVo.getVModel();
                        String foriegKey = "";
                        String columnName = "";
                        boolean isMain = uniqueModel.isMain();
                        TableModel mainTableModel = new TableModel();
                        TableModel tableModel = new TableModel();
                        for (TableModel item : uniqueModel.getTableModelList()) {
                            if (Objects.equals(item.getTypeId(), "1")) {
                                mainTableModel = item;
                            }
                            if (StringUtil.isNotEmpty((String)swapDataVo.getConfig().getRelationTable())) {
                                if (!swapDataVo.getConfig().getRelationTable().equals(item.getTable())) continue;
                                tableModel = item;
                                continue;
                            }
                            if (!swapDataVo.getConfig().getTableName().equals(item.getTable())) continue;
                            tableModel = item;
                        }
                        if (tableModel != null) {
                            String fieldName = vModelThis;
                            if (vModelThis.contains("_jnpf_")) {
                                fieldName = vModelThis.split("_jnpf_")[1];
                                isMain = false;
                                foriegKey = tableModel.getTableField();
                            }
                            String finalFieldName = fieldName;
                            tableFields = tableModel.getFields().stream().filter(t -> t.getField().equals(finalFieldName)).findFirst().orElse(null);
                            if (tableFields != null) {
                                columnName = StringUtil.isNotEmpty((String)tableFields.getField()) ? tableFields.getField() : fieldName;
                            }
                        }
                        ArrayList<SqlColumn> selectKey = new ArrayList<SqlColumn>();
                        selectKey.add(sqlTable.column(columnName));
                        selectKey.add(sqlTable.column(key));
                        if (StringUtil.isNotEmpty((String)foriegKey)) {
                            String finalForiegKey = foriegKey;
                            tableFields = tableModel.getFields().stream().filter(t -> t.getField().equals(finalForiegKey)).findFirst().orElse(null);
                            if (tableFields != null) {
                                foriegKey = StringUtil.isNotEmpty((String)tableFields.getField()) ? tableFields.getField() : finalForiegKey;
                            }
                            selectKey.add(sqlTable.column(foriegKey));
                        }
                        SqlTable sqlMainTable = SqlTable.of((String)mainTableModel.getTable());
                        String mainKey = this.flowDataUtil.getKey(mainTableModel, databaseProductName);
                        String taskIdField = TableFeildsEnum.FLOWTASKID.getField();
                        if (databaseProductName.contains("Oracle") || databaseProductName.contains("DM DBMS")) {
                            taskIdField = TableFeildsEnum.FLOWTASKID.getField().toUpperCase();
                        }
                        if (StringUtil.isNotEmpty((String)uniqueModel.getFlowId())) {
                            selectKey.add(sqlMainTable.column(taskIdField));
                        }
                        QueryExpressionDSL.QueryExpressionWhereBuilder where = isMain ? (QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select(selectKey).from(sqlTable).where((BindableColumn)sqlTable.column(columnName), (VisitableCondition)SqlBuilder.isEqualTo((Object)value), new AndOrCriteriaGroup[0]) : (QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select(selectKey).from(sqlMainTable).leftJoin(sqlTable).on((BasicColumn)sqlTable.column(tableModel.getTableField()), (JoinCondition)new EqualTo((BasicColumn)sqlMainTable.column(tableModel.getRelationField()))).where((BindableColumn)sqlTable.column(columnName), (VisitableCondition)SqlBuilder.isEqualTo((Object)value), new AndOrCriteriaGroup[0]);
                        if (StringUtil.isNotEmpty((String)uniqueModel.getFlowId())) {
                            where.and((BindableColumn)sqlMainTable.column(TableFeildsEnum.FLOWID.getField()), (VisitableCondition)SqlBuilder.isIn((Collection)uniqueModel.getFlowIdList()), new AndOrCriteriaGroup[0]);
                        } else {
                            where.and((BindableColumn)sqlMainTable.column(TableFeildsEnum.FLOWID.getField()), (VisitableCondition)SqlBuilder.isNull(), new AndOrCriteriaGroup[0]);
                        }
                        if (uniqueModel.getLogicalDelete().booleanValue()) {
                            where.and((BindableColumn)sqlMainTable.column(TableFeildsEnum.DELETEMARK.getField()), (VisitableCondition)SqlBuilder.isNull(), new AndOrCriteriaGroup[0]);
                        }
                        if (StringUtil.isNotEmpty((String)uniqueModel.getId())) {
                            where.and((BindableColumn)sqlTable.column(mainKey), (VisitableCondition)SqlBuilder.isNotEqualTo((Object)uniqueModel.getId()), new AndOrCriteriaGroup[0]);
                        }
                        if ((count = (mapList = this.flowFormDataMapper.selectManyMappedRows(render = ((SelectModel)where.build()).render(RenderingStrategies.MYBATIS3))).size()) > 0) {
                            errList.set(i, label + "\u503c\u5df2\u5b58\u5728");
                            break;
                        }
                    }
                    if (!StringUtil.isNotEmpty((Collection)swapDataVo.getConfig().getRegList())) continue;
                    List regList = JsonUtil.getJsonToList((Object)swapDataVo.getConfig().getRegList(), RegListModel.class);
                    for (RegListModel regListModel : regList) {
                        boolean matches;
                        String reg = regListModel.getPattern();
                        if (reg.startsWith("/") && reg.endsWith("/")) {
                            reg = reg.substring(1, reg.length() - 1);
                        }
                        if (matches = value.matches(reg)) continue;
                        errList.set(i, label + regListModel.getMessage());
                        continue block12;
                    }
                    continue;
                }
                finally {
                    if (Collections.singletonList(connection).get(0) != null) {
                        connection.close();
                    }
                }
            }
            catch (Exception e) {
                errList.set(i, label + "\u503c\u4e0d\u6b63\u786e");
                continue;
            }
            finally {
                DynamicDataSourceUtil.clearSwitchDataSource();
            }
        }
    }

    private static /* synthetic */ void lambda$checkExcelData$21(Map finalDataInterfaceMap1, String finalDataLabel3, String finalDataValue3, Map o) {
        finalDataInterfaceMap1.put(String.valueOf(o.get(finalDataLabel3)), o.get(finalDataValue3));
    }

    private static /* synthetic */ Map lambda$checkExcelData$20(DictionaryDataEntity dic) {
        HashMap<String, Object> dictionaryMap = new HashMap<String, Object>(16);
        dictionaryMap.put("id", dic.getId());
        dictionaryMap.put("enCode", dic.getEnCode());
        dictionaryMap.put("fullName", dic.getFullName());
        return dictionaryMap;
    }

    private static /* synthetic */ void lambda$checkExcelData$19(Map finalDataInterfaceMap1, String finalDataLabel2, String finalDataValue1, Map o) {
        finalDataInterfaceMap1.put(String.valueOf(o.get(finalDataLabel2)), String.valueOf(o.get(finalDataValue1)));
    }

    private static /* synthetic */ void lambda$checkExcelData$18(Map finalDataInterfaceMap, String finalDataLabel, String finalDataValue, Map o) {
        finalDataInterfaceMap.put(String.valueOf(o.get(finalDataLabel)), o.get(finalDataValue));
    }

    private static /* synthetic */ void lambda$checkExcelData$17(StringJoiner childJoiner1, String t) {
        if (StringUtil.isNotEmpty((String)t)) {
            childJoiner1.add(t);
        }
    }

    private static /* synthetic */ boolean lambda$checkExcelData$16(List orgUserList, OrganizeRelationEntity t) {
        return orgUserList.contains(t.getOrganizeId());
    }
}

