/*
 * Decompiled with CFR 0.152.
 */
package jnpf.onlinedev.util.onlineDevUtil;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jnpf.base.ActionResult;
import jnpf.base.model.ColumnDataModel;
import jnpf.base.model.datainterface.DataInterfaceActionVo;
import jnpf.base.service.DataInterfaceService;
import jnpf.base.service.DictionaryDataService;
import jnpf.base.service.ProvinceService;
import jnpf.base.service.VisualdevService;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.onlinedev.model.OnlineDevEnum.MultipleControlEnum;
import jnpf.onlinedev.model.OnlineDevEnum.OnlineDataTypeEnum;
import jnpf.onlinedev.model.OnlineDevListModel.OnlineDevListDataVO;
import jnpf.onlinedev.model.OnlineDevListModel.VisualColumnSearchVO;
import jnpf.onlinedev.service.VisualDevInfoService;
import jnpf.onlinedev.service.VisualdevModelDataService;
import jnpf.onlinedev.util.onlineDevUtil.OnlineDatabaseUtils;
import jnpf.onlinedev.util.onlineDevUtil.OnlineDevInfoUtils;
import jnpf.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import jnpf.permission.service.OrganizeService;
import jnpf.permission.service.PositionService;
import jnpf.permission.service.UserService;
import jnpf.util.DateUtil;
import jnpf.util.JsonUtil;
import jnpf.util.RandomUtil;
import jnpf.util.RedisUtil;
import jnpf.util.StringUtil;
import jnpf.util.TenantHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OnlineDevListUtils {
    private static final Logger log = LoggerFactory.getLogger(OnlineDevListUtils.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private DictionaryDataService dictionaryDataApi;
    @Autowired
    private UserService userApi;
    @Autowired
    private PositionService positionApi;
    @Autowired
    private OrganizeService organizeApi;
    @Autowired
    private VisualdevService visualdevService;
    @Autowired
    private VisualdevModelDataService visualdevModelDataService;
    @Autowired
    private DataInterfaceService dataInterFaceApi;
    @Autowired
    private VisualDevInfoService visualDevInfoService;
    @Autowired
    private ProvinceService areaApi;
    @Autowired
    private OnlineDevInfoUtils onlineDevInfoUtils;
    private Map<String, String> nullDatamap = new HashMap<String, String>();

    public static List<Map<String, Object>> getNoSwapList(List<Map<String, Object>> list, List<VisualColumnSearchVO> searchList) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        if (searchList == null) {
            return list;
        }
        for (Map<String, Object> dataVo : list) {
            int i = 0;
            for (VisualColumnSearchVO vo : searchList) {
                Object dataModel = dataVo.get(vo.getVModel());
                if (dataModel == null || ObjectUtil.isEmpty((Object)dataModel)) continue;
                if (vo.getConfig().getJnpfKey().equals("checkbox") || "cascader".equals(vo.getConfig().getJnpfKey())) {
                    vo.setMultiple(Boolean.valueOf(true));
                }
                if (vo.getSearchType().equals("1")) {
                    if (vo.getMultiple() != null && vo.getMultiple().booleanValue()) {
                        List<String> asList;
                        if (String.valueOf(dataModel).contains("[")) {
                            asList = JsonUtil.getJsonToList((String)String.valueOf(dataModel), String.class);
                        } else {
                            String[] multipleList = String.valueOf(dataModel).split(",");
                            asList = Arrays.asList(multipleList);
                        }
                        boolean b = asList.stream().anyMatch(t -> vo.getValue().toString().contains((CharSequence)t));
                        if (b) {
                            ++i;
                        }
                    } else if (String.valueOf(vo.getValue()).equals(String.valueOf(dataModel))) {
                        ++i;
                    }
                }
                if (vo.getSearchType().equals("2") && String.valueOf(dataModel).contains(String.valueOf(vo.getValue()))) {
                    ++i;
                }
                if (vo.getSearchType().equals("3")) {
                    String key;
                    switch (key = vo.getConfig().getJnpfKey()) {
                        case "modifyTime": 
                        case "createTime": {
                            JSONArray timeStampArray = (JSONArray)vo.getValue();
                            Long o1 = (Long)timeStampArray.get(0);
                            Long o2 = (Long)timeStampArray.get(1);
                            String startTime = DateUtil.daFormat((Long)o1);
                            String endTime = DateUtil.daFormat((Long)o2);
                            endTime = endTime.substring(0, 10);
                            String firstTimeDate = OnlineDatabaseUtils.getTimeFormat(startTime);
                            String lastTimeDate = OnlineDatabaseUtils.getLastTimeFormat(endTime);
                            String value = String.valueOf(dataModel);
                            if (value.contains(".")) {
                                value = value.substring(0, value.lastIndexOf("."));
                            }
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            try {
                                boolean b = DateUtil.isEffectiveDate((Date)sdf.parse(value), (Date)sdf.parse(firstTimeDate), (Date)sdf.parse(lastTimeDate));
                                if (!b) break;
                                ++i;
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        case "inputNumber": 
                        case "calculate": {
                            Float firstValue = null;
                            Float secondValue = null;
                            JSONArray objects = (JSONArray)vo.getValue();
                            for (int k = 0; k < objects.size(); ++k) {
                                Object n = objects.get(k);
                                if (!ObjectUtil.isNotEmpty((Object)n)) continue;
                                if (k == 0) {
                                    firstValue = Float.valueOf(Float.parseFloat(String.valueOf(n)));
                                    continue;
                                }
                                secondValue = Float.valueOf(Float.parseFloat(String.valueOf(n)));
                            }
                            Float numValue = Float.valueOf(Float.parseFloat(String.valueOf(dataModel)));
                            if (firstValue != null && secondValue == null && numValue.floatValue() >= firstValue.floatValue()) {
                                ++i;
                            }
                            if (firstValue != null && secondValue != null && numValue.floatValue() >= firstValue.floatValue() && numValue.floatValue() <= secondValue.floatValue()) {
                                ++i;
                            }
                            if (firstValue != null || secondValue == null || !(numValue.floatValue() <= secondValue.floatValue())) break;
                            ++i;
                            break;
                        }
                        case "datePicker": {
                            String endTimeDates;
                            String starTimeDates;
                            if (dataModel == null) break;
                            if (!String.valueOf(vo.getValue()).contains(":") && !String.valueOf(vo.getValue()).contains("-")) {
                                JSONArray DateTimeStampArray = (JSONArray)vo.getValue();
                                Long d1 = (Long)DateTimeStampArray.get(0);
                                Long d2 = (Long)DateTimeStampArray.get(1);
                                long d1FirstTime = Long.parseLong(String.valueOf(d1));
                                long d2LastTime = Long.parseLong(String.valueOf(d2));
                                starTimeDates = DateUtil.daFormat((Long)d1FirstTime);
                                endTimeDates = DateUtil.daFormat((Long)d2LastTime);
                            } else {
                                String[] keyArray = String.valueOf(vo.getValue()).split(",");
                                starTimeDates = keyArray[0];
                                endTimeDates = keyArray[1];
                            }
                            if (vo.getFormat() == null) {
                                starTimeDates = starTimeDates.substring(0, 10);
                                endTimeDates = endTimeDates.substring(0, 10);
                            }
                            starTimeDates = OnlineDatabaseUtils.getTimeFormat(starTimeDates);
                            endTimeDates = OnlineDatabaseUtils.getLastTimeFormat(endTimeDates);
                            String dateValue = dataModel.toString();
                            if (!dateValue.contains(":") && !dateValue.contains("-")) {
                                Long timeResult = (Long)dataModel;
                                dateValue = DateUtil.daFormat((Long)timeResult);
                            }
                            if (dateValue.contains(".")) {
                                dateValue = dateValue.substring(0, dateValue.lastIndexOf("."));
                            }
                            dateValue = OnlineDatabaseUtils.getTimeFormat(dateValue);
                            SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            try {
                                Boolean b = DateUtil.isEffectiveDate((Date)sdfDate.parse(dateValue), (Date)sdfDate.parse(starTimeDates), (Date)sdfDate.parse(endTimeDates));
                                if (!b.booleanValue()) break;
                                ++i;
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        case "timePicker": {
                            JSONArray timeArray = (JSONArray)vo.getValue();
                            String start = String.valueOf(timeArray.get(0));
                            String end = String.valueOf(timeArray.get(1));
                            start = OnlineDatabaseUtils.getTimeFormat(start);
                            end = OnlineDatabaseUtils.getLastTimeFormat(end);
                            String timeValue = OnlineDatabaseUtils.getTimeFormat(String.valueOf(dataModel));
                            SimpleDateFormat timeSim = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            try {
                                boolean b = DateUtil.isEffectiveDate((Date)timeSim.parse(timeValue), (Date)timeSim.parse(start), (Date)timeSim.parse(end));
                                if (!b) break;
                                ++i;
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                    }
                }
                if (i != searchList.size()) continue;
                resultList.add(dataVo);
            }
        }
        return resultList;
    }

    public static void pageIdList(List<OnlineDevListDataVO> list, List<FieLdsModel> swapDataVoList, Map<String, Object> localCache) {
        Set userList = (Set)localCache.get("__user_list");
        Set orgList = (Set)localCache.get("__org_list");
        Set posList = (Set)localCache.get("__pos_list");
        Set AllOrgList = (Set)localCache.get("__allOrg_list");
        Set roleList = (Set)localCache.get("__role_list");
        for (FieLdsModel swapDataVo : swapDataVoList) {
            String jnpfKey = swapDataVo.getConfig().getJnpfKey();
            String vModel = swapDataVo.getVModel();
            for (OnlineDevListDataVO listVo : list) {
                Map dataMap = listVo.getData();
                if (StringUtil.isEmpty((String)String.valueOf(dataMap.get(vModel))) || dataMap.get(vModel) == null || String.valueOf(dataMap.get(vModel)).equals("[]") || String.valueOf(dataMap.get(vModel)).equals("null")) continue;
                switch (jnpfKey) {
                    case "organizeSelect": 
                    case "depSelect": 
                    case "currDept": 
                    case "currOrganize": {
                        if ("all".equals(swapDataVo.getShowLevel())) {
                            OnlineDevListUtils.getIdInMethod(AllOrgList, dataMap.get(vModel));
                            break;
                        }
                        OnlineDevListUtils.getIdInMethod(orgList, dataMap.get(vModel));
                        break;
                    }
                    case "roleSelect": {
                        OnlineDevListUtils.getIdInMethod(roleList, dataMap.get(vModel));
                        break;
                    }
                    case "posSelect": 
                    case "currPosition": {
                        OnlineDevListUtils.getIdInMethod(posList, dataMap.get(vModel));
                        break;
                    }
                    case "userSelect": 
                    case "createUser": 
                    case "modifyUser": {
                        OnlineDevListUtils.getIdInMethod(userList, dataMap.get(vModel));
                        break;
                    }
                }
            }
        }
    }

    public static Collection<String> getIdInMethod(Collection<String> idList, Object modelData) {
        if (OnlinePublicUtils.getMultiple(String.valueOf(modelData), MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar()).booleanValue()) {
            String[][] data;
            String[][] stringArray = data = (String[][])JsonUtil.getJsonToBean((String)String.valueOf(modelData), String[][].class);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] AddressData;
                for (String s : AddressData = stringArray[i]) {
                    idList.add(s);
                }
            }
        } else if (OnlinePublicUtils.getMultiple(String.valueOf(modelData), MultipleControlEnum.MULTIPLE_JSON_ONE.getMultipleChar()).booleanValue()) {
            idList.addAll(JsonUtil.getJsonToList((String)String.valueOf(modelData), String.class));
        } else {
            String[] modelDatas = String.valueOf(modelData).split(",");
            for (int i = 0; i < modelDatas.length; ++i) {
                idList.add(modelDatas[i]);
            }
        }
        return idList;
    }

    public static List<Map<String, Object>> groupData(List<Map<String, Object>> realList, ColumnDataModel columnDataModel) {
        List columnList = JsonUtil.getJsonToListMap((String)columnDataModel.getColumnList());
        String groupField = columnDataModel.getGroupField();
        List collect = columnList.stream().filter(t -> "left".equals(t.get("fixed")) && !String.valueOf(t.get("prop")).equals(columnDataModel.getGroupField())).collect(Collectors.toList());
        Map map = null;
        map = CollectionUtil.isNotEmpty(collect) ? (Map)collect.stream().filter(t -> !String.valueOf(t.get("prop")).equals(columnDataModel.getGroupField())).findFirst().orElse(null) : (Map)columnList.stream().filter(t -> !String.valueOf(t.get("prop")).equals(columnDataModel.getGroupField())).findFirst().orElse(null);
        if (map == null) {
            map = columnList.stream().filter(t -> String.valueOf(t.get("prop")).equals(columnDataModel.getGroupField())).findFirst().orElse(null);
        }
        String firstField = String.valueOf(map.get("prop"));
        LinkedHashMap<String, List> twoMap = new LinkedHashMap<String, List>(16);
        for (Map<String, Object> realMap : realList) {
            boolean isKey;
            String value = String.valueOf(realMap.get(groupField));
            if (realMap.get(groupField) instanceof Double) {
                value = realMap.get(groupField).toString().replaceAll(".0+?$", "").replaceAll("[.]$", "");
            }
            boolean bl = isKey = twoMap.get(value) != null;
            if (isKey) {
                List maps = (List)twoMap.get(value);
                maps.add(realMap);
                twoMap.put(value, maps);
                continue;
            }
            ArrayList<Map<String, Object>> childrenList = new ArrayList<Map<String, Object>>();
            childrenList.add(realMap);
            twoMap.put(value, childrenList);
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (String key : twoMap.keySet()) {
            HashMap<String, Object> thirdMap = new HashMap<String, Object>(16);
            thirdMap.put(firstField, !key.equals("null") ? key : "");
            thirdMap.put("top", true);
            thirdMap.put("id", RandomUtil.uuId());
            thirdMap.put("children", twoMap.get(key));
            resultList.add(thirdMap);
        }
        return resultList;
    }

    public static void getOptions(String label, String value, String Children, JSONArray data, List<Map<String, Object>> options) {
        for (int i = 0; i < data.size(); ++i) {
            JSONObject ob = data.getJSONObject(i);
            HashMap<String, String> tree = new HashMap<String, String>(16);
            tree.put(value, String.valueOf(ob.get((Object)value)));
            tree.put(label, String.valueOf(ob.get((Object)label)));
            options.add(tree);
            if (ob.get((Object)Children) == null) continue;
            JSONArray childrenArray = ob.getJSONArray(Children);
            OnlineDevListUtils.getOptions(label, value, Children, childrenArray, options);
        }
    }

    public static List<Map<String, Object>> treeListData(List<Map<String, Object>> realList, ColumnDataModel columnDataModel) {
        String parentField = columnDataModel.getParentField() + "_id";
        String childField = columnDataModel.getSubField();
        for (int i = 0; i < realList.size(); ++i) {
            Map<String, Object> item = realList.get(i);
            if ((item.get(parentField) == null || StringUtil.isNotEmpty((String)item.get(parentField).toString())) && (item.get(parentField) == null || "[]".equals(item.get(parentField).toString())) || !OnlineDevListUtils.addChild(item, realList, parentField, childField) || realList.size() <= 0) continue;
            realList.remove(item);
            --i;
        }
        return realList;
    }

    private static void treeToList(String value, String label, String children, JSONArray data, List<Map<String, Object>> result) {
        for (int i = 0; i < data.size(); ++i) {
            JSONObject ob = data.getJSONObject(i);
            HashMap<String, String> tree = new HashMap<String, String>(16);
            tree.put(value, String.valueOf(ob.get((Object)value)));
            tree.put(label, String.valueOf(ob.get((Object)label)));
            result.add(tree);
            if (ob.get((Object)children) == null) continue;
            JSONArray childArray = ob.getJSONArray(children);
            OnlineDevListUtils.treeToList(value, label, children, childArray, result);
        }
    }

    private static boolean addChild(Map<String, Object> node, List<Map<String, Object>> list, String parentField, String childField) {
        for (int i = 0; i < list.size(); ++i) {
            List children;
            Map<String, Object> ele = list.get(i);
            if (ele.get(childField).equals(node.get(parentField))) {
                if (ele.get("children") == null) {
                    ele.put("children", new ArrayList());
                }
                children = (List)ele.get("children");
                children.add(node);
                ele.put("children", children);
                return true;
            }
            if (ele.get("children") == null || !OnlineDevListUtils.addChild(node, children = (List)ele.get("children"), parentField, childField)) continue;
            return true;
        }
        return false;
    }

    public void sysNeedSwapData(List<FieLdsModel> swapDataVoList, String visualDevId, Map<String, Object> localCache) {
        String dsName = Optional.ofNullable(TenantHolder.getDatasourceId()).orElse("");
        try {
            for (FieLdsModel swapDataVo : swapDataVoList) {
                JSONArray data;
                String redisKey;
                String jnpfKey = swapDataVo.getConfig().getJnpfKey();
                String dataType = swapDataVo.getConfig().getDataType();
                switch (jnpfKey) {
                    case "areaSelect": {
                        redisKey = "";
                        if (!this.redisUtil.exists("")) {
                            ArrayList provinceEntityList = new ArrayList();
                            HashMap provinceMap = new HashMap(16);
                            provinceEntityList.stream().forEach(p -> provinceMap.put((String)p.getId(), p.getFullName()));
                            this.redisUtil.insert(redisKey, provinceMap, 604800L);
                        }
                        if (localCache.containsKey(redisKey)) break;
                        localCache.put(redisKey, this.redisUtil.getMap(redisKey));
                        break;
                    }
                }
                if (dataType == null) continue;
                String label = swapDataVo.getProps().getLabel();
                String value = swapDataVo.getProps().getValue();
                String children = swapDataVo.getProps().getChildren();
                ArrayList<Map<String, Object>> options = new ArrayList();
                HashMap dataInterfaceMap = new HashMap(16);
                if (dataType.equals(OnlineDataTypeEnum.STATIC.getType())) {
                    redisKey = String.format("%s-%s-%s", visualDevId, swapDataVo.getVModel(), OnlineDataTypeEnum.STATIC.getType());
                    if (!this.redisUtil.exists(redisKey)) {
                        if (swapDataVo.getOptions() != null) {
                            options = JsonUtil.getJsonToListMap((String)swapDataVo.getOptions());
                            String Children = swapDataVo.getProps().getChildren();
                            data = JsonUtil.getListToJsonArray(options);
                            OnlineDevListUtils.getOptions(label, value, Children, data, options);
                        } else {
                            options = JsonUtil.getJsonToListMap((String)swapDataVo.getOptions());
                        }
                        options.stream().forEach(o -> dataInterfaceMap.put(String.valueOf(o.get(value)), String.valueOf(o.get(label))));
                        String staticData = JsonUtil.getObjectToString(dataInterfaceMap);
                        this.redisUtil.insert(redisKey, (Object)staticData, 300L);
                        if (!localCache.containsKey(redisKey)) {
                            localCache.put(redisKey, dataInterfaceMap);
                        }
                    } else if (!localCache.containsKey(redisKey)) {
                        String staticDataString = this.redisUtil.getString(redisKey).toString();
                        localCache.put(redisKey, JsonUtil.stringToMap((String)staticDataString));
                    }
                }
                if (dataType.equals(OnlineDataTypeEnum.DYNAMIC.getType())) {
                    redisKey = String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl());
                    String redisKey2 = String.format("%s-%s-%s-%s-%s-%s", dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl(), label, value, children);
                    if (!this.redisUtil.exists(redisKey2)) {
                        data = null;
                        if (!this.redisUtil.exists(redisKey)) {
                            data = this.dataInterFaceApi.infoToId(swapDataVo.getConfig().getPropsUrl(), null, null);
                            this.redisUtil.insert(redisKey, (Object)JSONObject.toJSONString((Object)data), 300L);
                        } else {
                            data = (ActionResult)JSONObject.parseObject((String)String.valueOf(this.redisUtil.getString(redisKey)), ActionResult.class);
                        }
                        if (!localCache.containsKey(redisKey)) {
                            localCache.put(redisKey, data);
                        }
                        if (data != null && data.getData() != null) {
                            List dataList = new ArrayList();
                            if (data.getData() instanceof DataInterfaceActionVo) {
                                DataInterfaceActionVo actionVo = (DataInterfaceActionVo)data.getData();
                                if (actionVo.getData() instanceof List) {
                                    dataList = (List)actionVo.getData();
                                }
                            } else if (data.getData() instanceof List) {
                                dataList = (List)data.getData();
                            }
                            JSONArray dataAll = JsonUtil.getListToJsonArray(dataList);
                            OnlineDevListUtils.treeToList(label, value, children, dataAll, options);
                            options.stream().forEach(o -> dataInterfaceMap.put(String.valueOf(o.get(value)), String.valueOf(o.get(label))));
                            String dynamicData = JsonUtil.getObjectToString(dataInterfaceMap);
                            this.redisUtil.insert(redisKey2, (Object)dynamicData, 300L);
                            localCache.put(redisKey2, dataInterfaceMap);
                        }
                    } else {
                        if (!localCache.containsKey(redisKey)) {
                            localCache.put(redisKey, JSONObject.parseObject((String)String.valueOf(this.redisUtil.getString(redisKey)), ActionResult.class));
                        }
                        if (!localCache.containsKey(redisKey2)) {
                            String dynamicString = this.redisUtil.getString(redisKey2).toString();
                            localCache.put(redisKey2, JsonUtil.stringToMap((String)dynamicString));
                        }
                    }
                }
                if (!dataType.equals(OnlineDataTypeEnum.DICTIONARY.getType())) continue;
                redisKey = String.format("%s-%s-%s", dsName, OnlineDataTypeEnum.DICTIONARY.getType(), swapDataVo.getConfig().getDictionaryType());
                if (!this.redisUtil.exists(redisKey)) {
                    List list = this.dictionaryDataApi.getDicList(swapDataVo.getConfig().getDictionaryType());
                    options = list.stream().map(dic -> {
                        HashMap<String, Object> dictionaryMap = new HashMap<String, Object>(16);
                        dictionaryMap.put("id", dic.getId());
                        dictionaryMap.put("enCode", dic.getEnCode());
                        dictionaryMap.put("fullName", dic.getFullName());
                        return dictionaryMap;
                    }).collect(Collectors.toList());
                    String dictionaryData = JsonUtil.getObjectToString(options);
                    this.redisUtil.insert(redisKey, (Object)dictionaryData, 300L);
                    localCache.put(redisKey, options);
                    continue;
                }
                if (localCache.containsKey(redisKey)) continue;
                String dictionaryStringData = this.redisUtil.getString(redisKey).toString();
                localCache.put(redisKey, JsonUtil.getJsonToListMap((String)dictionaryStringData));
            }
        }
        catch (Exception e) {
            log.error("\u5728\u7ebf\u5f00\u53d1\u8f6c\u6362\u6570\u636e\u5f02\u5e38:" + e.getMessage());
            e.printStackTrace();
        }
    }
}

