/*
 * Decompiled with CFR 0.152.
 */
package jnpf.onlinedev.util.onlineDevUtil;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jnpf.base.UserInfo;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.model.CheckFormModel;
import jnpf.base.model.OnlineImport.VisualdevModelDataInfoVO;
import jnpf.base.model.VisualLogModel;
import jnpf.base.model.flow.DataModel;
import jnpf.base.model.flow.FlowFormDataModel;
import jnpf.base.util.FlowFormDataUtil;
import jnpf.base.util.FormCheckUtils;
import jnpf.base.util.ServiceBaseUtil;
import jnpf.constant.MsgCode;
import jnpf.database.model.entity.DbLinkEntity;
import jnpf.exception.DataException;
import jnpf.exception.WorkFlowException;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.FormCloumnUtil;
import jnpf.model.visualJson.FormDataModel;
import jnpf.model.visualJson.TableModel;
import jnpf.model.visualJson.analysis.RecursionForm;
import jnpf.onlinedev.model.OnlineInfoModel;
import jnpf.onlinedev.model.log.VisualLogForm;
import jnpf.onlinedev.service.VisualDevInfoService;
import jnpf.onlinedev.service.VisualLogService;
import jnpf.permission.entity.UserEntity;
import jnpf.util.JsonUtil;
import jnpf.util.StringUtil;
import jnpf.util.TableFeildsEnum;
import jnpf.util.UserProvider;
import org.mybatis.dynamic.sql.SqlTable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowFormCustomUtils {
    @Autowired
    private FlowFormDataUtil flowDataUtil;
    @Autowired
    private FormCheckUtils formCheckUtils;
    @Autowired
    private ServiceBaseUtil serviceUtil;
    @Autowired
    private VisualLogService visualLogService;
    @Autowired
    private VisualDevInfoService visualDevInfoService;

    public void create(VisualdevEntity visualdevEntity, FlowFormDataModel flowFormDataModel) throws WorkFlowException {
        UserEntity userEntity;
        CheckFormModel checkFormModel;
        String b;
        String id = flowFormDataModel.getId();
        Map map = flowFormDataModel.getMap();
        UserEntity delegateUser = flowFormDataModel.getDelegateUser();
        List listFlowOperate = flowFormDataModel.getFormOperates();
        FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getFormData(), FormDataModel.class);
        List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        List tableModels = JsonUtil.getJsonToList((String)visualdevEntity.getVisualTables(), TableModel.class);
        DbLinkEntity linkEntity = this.serviceUtil.getDbLink(visualdevEntity.getDbLinkId());
        RecursionForm recursionForm = new RecursionForm(list, tableModels);
        ArrayList formAllModel = new ArrayList();
        FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
        Boolean concurrency = false;
        Integer primaryKeyPolicy = formData.getPrimaryKeyPolicy();
        if (formData.getConcurrencyLock().booleanValue()) {
            map.put(TableFeildsEnum.VERSION.getField(), 0);
            concurrency = true;
        }
        if (StringUtil.isNotEmpty((String)(b = this.formCheckUtils.checkForm(checkFormModel = CheckFormModel.builder().formFieldList(list).dataMap(map).linkEntity(linkEntity).tableModelList(tableModels).visualdevEntity(visualdevEntity).id(null).isTransfer(flowFormDataModel.getIsTransfer()).build())))) {
            throw new WorkFlowException(b);
        }
        String mainId = id;
        UserInfo userInfo = UserProvider.getUser();
        if (delegateUser != null) {
            delegateUser.setId((Object)userInfo.getUserId());
            userEntity = delegateUser;
        } else {
            userEntity = this.serviceUtil.getUserInfo(userInfo.getUserId());
        }
        DataModel dataModel = DataModel.builder().visualId((String)visualdevEntity.getId()).dataNewMap(map).fieLdsModelList(list).tableModelList(tableModels).formAllModel(formAllModel).mainId(mainId).link(linkEntity).userEntity(userEntity).concurrencyLock(concurrency).primaryKeyPolicy(primaryKeyPolicy).flowFormOperates(listFlowOperate).build();
        this.flowDataUtil.create(dataModel);
        if (formData.isDataLog()) {
            this.visualLogService.createEventLog(VisualLogForm.builder().modelId((String)visualdevEntity.getId()).dataId(dataModel.getMainId()).newData(map).type(Integer.valueOf(0)).build());
        }
    }

    public DataModel update(VisualdevEntity visualdevEntity, FlowFormDataModel flowFormDataModel) throws WorkFlowException, SQLException, DataException {
        CheckFormModel checkFormModel;
        String b;
        Map map = flowFormDataModel.getMap();
        String id = flowFormDataModel.getId();
        List listFlowOperate = flowFormDataModel.getFormOperates();
        FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getFormData(), FormDataModel.class);
        List tableModels = JsonUtil.getJsonToList((String)visualdevEntity.getVisualTables(), TableModel.class);
        TableModel mainT = tableModels.stream().filter(t -> t.getTypeId().equals("1")).findFirst().orElse(null);
        DbLinkEntity linkEntity = this.serviceUtil.getDbLink(visualdevEntity.getDbLinkId());
        List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        RecursionForm recursionForm = new RecursionForm(list, tableModels);
        ArrayList formAllModel = new ArrayList();
        FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
        Boolean isConcurrencyLock = false;
        Integer primaryKeyPolicy = formData.getPrimaryKeyPolicy();
        if (formData.getConcurrencyLock().booleanValue()) {
            if (map.get(TableFeildsEnum.VERSION.getField()) == null) {
                map.put(TableFeildsEnum.VERSION.getField(), 0);
            } else {
                boolean version;
                Object realId = id;
                if (Objects.equals(primaryKeyPolicy, 2)) {
                    realId = Long.parseLong(id);
                }
                if (!(version = this.flowDataUtil.getVersion(mainT.getTable(), linkEntity, map, realId).booleanValue())) {
                    throw new WorkFlowException(MsgCode.VS405.get(new Object[0]));
                }
                Integer vs = Integer.valueOf(String.valueOf(map.get(TableFeildsEnum.VERSION.getField())));
                map.put(TableFeildsEnum.VERSION.getField(), vs + 1);
            }
            isConcurrencyLock = true;
        }
        if (StringUtil.isNotEmpty((String)(b = this.formCheckUtils.checkForm(checkFormModel = CheckFormModel.builder().formFieldList(list).dataMap(map).linkEntity(linkEntity).tableModelList(tableModels).visualdevEntity(visualdevEntity).id(id).isTransfer(flowFormDataModel.getIsTransfer()).build())))) {
            throw new WorkFlowException(b);
        }
        VisualdevModelDataInfoVO resOld = this.visualDevInfoService.getDetailsDataInfo(id, visualdevEntity, OnlineInfoModel.builder().needRlationFiled(true).needSwap(false).formAllModel(formAllModel).build());
        Map oldData = JsonUtil.stringToMap((String)resOld.getData());
        UserInfo userInfo = UserProvider.getUser();
        UserEntity userEntity = this.serviceUtil.getUserInfo(userInfo.getUserId());
        DataModel dataModel = DataModel.builder().visualId((String)visualdevEntity.getId()).dataNewMap(map).fieLdsModelList(list).formAllModel(formAllModel).tableModelList(tableModels).mainId(id).link(linkEntity).userEntity(userEntity).concurrencyLock(isConcurrencyLock).primaryKeyPolicy(primaryKeyPolicy).flowFormOperates(listFlowOperate).build();
        this.flowDataUtil.update(dataModel);
        VisualdevModelDataInfoVO res = this.visualDevInfoService.getDetailsDataInfo(id, visualdevEntity, OnlineInfoModel.builder().needRlationFiled(true).needSwap(false).formAllModel(formAllModel).build());
        Map newData = JsonUtil.stringToMap((String)res.getData());
        VisualLogForm form = VisualLogForm.builder().modelId((String)visualdevEntity.getId()).dataId(id).oldData(oldData).newData(newData).type(Integer.valueOf(1)).build();
        ArrayList<VisualLogModel> listLog = new ArrayList<VisualLogModel>();
        this.visualLogService.addLog(form, listLog);
        dataModel.setListLog(listLog);
        if (formData.isDataLog()) {
            form.setListLog(listLog);
            this.visualLogService.createEventLog(form);
        }
        return dataModel;
    }

    public DataModel saveOrUpdate(VisualdevEntity visualdevEntity, FlowFormDataModel flowFormDataModel) throws WorkFlowException, SQLException, DataException {
        SqlTable sqlTable;
        String realId;
        List tableModels = JsonUtil.getJsonToList((String)visualdevEntity.getVisualTables(), TableModel.class);
        TableModel mainT = tableModels.stream().filter(t -> t.getTypeId().equals("1")).findFirst().orElse(null);
        DbLinkEntity linkEntity = this.serviceUtil.getDbLink(visualdevEntity.getDbLinkId());
        FormDataModel formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getFormData(), FormDataModel.class);
        boolean autoIncrement = Objects.equals(formDataModel.getPrimaryKeyPolicy(), 2);
        String id = flowFormDataModel.getId();
        Object mainId = id;
        if (autoIncrement) {
            mainId = Long.parseLong(id);
        }
        if (StringUtil.isNotEmpty((String)(realId = this.formCheckUtils.getCount(mainId, sqlTable = SqlTable.of((String)mainT.getTable()), mainT, linkEntity)))) {
            flowFormDataModel.setId(realId);
            return this.update(visualdevEntity, flowFormDataModel);
        }
        this.create(visualdevEntity, flowFormDataModel);
        return null;
    }

    public Map<String, Object> info(VisualdevEntity visualdevEntity, String id) {
        return this.flowDataUtil.getEditDataInfo(visualdevEntity, id);
    }
}

