/*
 * Decompiled with CFR 0.152.
 */
package jnpf.onlinedev.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import jnpf.base.entity.SuperBaseEntity;
import jnpf.base.entity.VisualdevReleaseEntity;
import jnpf.base.model.VisualLogModel;
import jnpf.base.service.SuperServiceImpl;
import jnpf.base.service.VisualdevReleaseService;
import jnpf.event.ProjectEventListener;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.FormDataModel;
import jnpf.model.visualJson.TableFields;
import jnpf.model.visualJson.TableModel;
import jnpf.model.visualJson.config.ConfigModel;
import jnpf.module.ProjectEventBuilder;
import jnpf.module.ProjectEventInstance;
import jnpf.onlinedev.entity.VisualLogEntity;
import jnpf.onlinedev.mapper.VisualLogMapper;
import jnpf.onlinedev.model.OnlineDevEnum.OnlineDataTypeEnum;
import jnpf.onlinedev.model.log.VisualLogForm;
import jnpf.onlinedev.model.log.VisualLogPage;
import jnpf.onlinedev.service.VisualLogService;
import jnpf.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import jnpf.onlinedev.util.onlineDevUtil.OnlineSwapDataUtils;
import jnpf.util.JsonUtil;
import jnpf.util.PublishEventUtil;
import jnpf.util.TableFeildsEnum;
import jnpf.util.visiual.JnpfKeyConsts;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisualLogServiceImpl
extends SuperServiceImpl<VisualLogMapper, VisualLogEntity>
implements VisualLogService {
    @Autowired
    private VisualdevReleaseService visualdevReleaseService;
    @Autowired
    private OnlineSwapDataUtils onlineSwapDataUtils;

    @Override
    public void createEventLog(VisualLogForm form) {
        PublishEventUtil.publishLocalEvent((ProjectEventBuilder)new ProjectEventBuilder("vslogEventKey", (Object)form));
    }

    @Override
    public List<VisualLogEntity> getList(VisualLogPage pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(VisualLogEntity::getModelId, (Object)pagination.getModelId());
        queryWrapper.lambda().eq(VisualLogEntity::getDataId, (Object)pagination.getDataId());
        queryWrapper.lambda().orderByDesc(SuperBaseEntity.SuperCBaseEntity::getCreatorTime);
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage iPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(iPage.getRecords(), iPage.getTotal());
    }

    @ProjectEventListener(channelRegex={"vslogEventKey.*"})
    public void createLogByEvent(ProjectEventInstance redisEvent) {
        VisualLogForm form = (VisualLogForm)redisEvent.getSource();
        VisualLogEntity visualLogEntity = new VisualLogEntity();
        visualLogEntity.setType(form.getType());
        visualLogEntity.setModelId(form.getModelId());
        visualLogEntity.setDataId(form.getDataId());
        if (Objects.equals(form.getType(), 1)) {
            ArrayList<VisualLogModel> listLog = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)form.getListLog())) {
                listLog = form.getListLog();
            } else {
                this.addLog(form, listLog);
            }
            visualLogEntity.setDataLog(JsonUtil.getObjectToString(listLog));
            if (CollectionUtils.isNotEmpty(listLog)) {
                this.save(visualLogEntity);
            }
        } else {
            this.save(visualLogEntity);
        }
    }

    @Override
    public void addLog(VisualLogForm formSource, List<VisualLogModel> listLog) {
        final VisualLogForm form = (VisualLogForm)BeanUtil.copyProperties((Object)formSource, VisualLogForm.class, (String[])new String[0]);
        VisualdevReleaseEntity visualdevEntity = (VisualdevReleaseEntity)this.visualdevReleaseService.getById((Serializable)((Object)form.getModelId()));
        FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getFormData(), FormDataModel.class);
        List fieLdsModels = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        List tableModels = JsonUtil.getJsonToList((String)visualdevEntity.getVisualTables(), TableModel.class);
        ArrayList<FieLdsModel> fields = new ArrayList<FieLdsModel>();
        OnlinePublicUtils.recursionFields(fields, fieLdsModels);
        List<Map<String, Object>> swapInfoOld = this.onlineSwapDataUtils.getSwapInfo((List<Map<String, Object>>)new ArrayList<Map<String, Object>>(){
            {
                this.add(form.getOldData());
            }
        }, fields, (String)visualdevEntity.getId(), false, null);
        Map<String, Object> oldData = swapInfoOld.get(0);
        List<Map<String, Object>> swapInfoNew = this.onlineSwapDataUtils.getSwapInfo((List<Map<String, Object>>)new ArrayList<Map<String, Object>>(){
            {
                this.add(form.getNewData());
            }
        }, fields, (String)visualdevEntity.getId(), false, null);
        Map<String, Object> newData = swapInfoNew.get(0);
        for (FieLdsModel item : fields) {
            ConfigModel config = item.getConfig();
            String jnpfKey = config.getJnpfKey();
            String label = config.getLabel();
            String dataType = config.getDataType();
            if (this.isSkipFields(item)) continue;
            if ("table".equals(jnpfKey)) {
                TableModel tableModel = tableModels.stream().filter(t -> t.getTable().equals(config.getTableName())).findFirst().orElse(null);
                TableFields mainField = tableModel.getFields().stream().filter(t -> Objects.equals(t.getPrimaryKey(), 1) && !t.getField().equalsIgnoreCase(TableFeildsEnum.TENANTID.getField())).findFirst().orElse(null);
                String mainKey = mainField.getField();
                List children = item.getConfig().getChildren();
                String vModel = item.getVModel();
                ArrayList childData = new ArrayList();
                ArrayList childField = new ArrayList();
                for (FieLdsModel childItem : children) {
                    String jnpfKeyChild = childItem.getConfig().getJnpfKey();
                    if (this.isSkipFields(childItem)) continue;
                    HashMap<String, Object> childItemMap = new HashMap<String, Object>();
                    childItemMap.put("prop", childItem.getVModel());
                    childItemMap.put("label", childItem.getConfig().getLabel());
                    childItemMap.put("jnpfKey", jnpfKeyChild);
                    boolean nameModified = false;
                    if (JnpfKeyConsts.getNameModified().contains(jnpfKeyChild) && (JnpfKeyConsts.getNameModifiedNotDynamic().contains(jnpfKeyChild) || OnlineDataTypeEnum.DYNAMIC.getType().equals(childItem.getConfig().getDataType()))) {
                        nameModified = true;
                    }
                    childItemMap.put("nameModified", nameModified);
                    childField.add(childItemMap);
                }
                List childOld = oldData.get(vModel) == null ? new ArrayList() : (List)oldData.get(vModel);
                List childNew = newData.get(vModel) == null ? new ArrayList() : (List)newData.get(vModel);
                List newIds = childNew.stream().map(t -> t.get(mainKey)).collect(Collectors.toList());
                List deleteMap = childOld.stream().filter(t -> !newIds.contains(t.get(mainKey))).collect(Collectors.toList());
                for (Map chilMap : deleteMap) {
                    HashMap<Object, Object> childDataMap = new HashMap<Object, Object>();
                    for (FieLdsModel childItem : children) {
                        String childJnpfKey = childItem.getConfig().getJnpfKey();
                        if (this.isSkipFields(childItem)) continue;
                        String childVmodel = childItem.getVModel();
                        String childVmodel_old = "jnpf_old_" + childItem.getVModel();
                        String oldValue = this.getValueByType(chilMap, childVmodel, childJnpfKey);
                        childDataMap.put(childVmodel, null);
                        childDataMap.put(childVmodel_old, oldValue);
                        childDataMap.put("jnpf_type", 2);
                    }
                    childData.add(childDataMap);
                }
                for (Map chilMap : childNew) {
                    Object mainId = chilMap.get(mainKey);
                    Map oldMap = childOld.stream().filter(t -> t.get(mainKey).equals(mainId)).findFirst().orElse(null);
                    Integer jnpf_type = 1;
                    if (oldMap == null) {
                        jnpf_type = 0;
                    }
                    HashMap<Object, Object> childDataMap = new HashMap<Object, Object>();
                    boolean hasChanged = false;
                    for (FieLdsModel childItem : children) {
                        String oldValue;
                        String childJnpfKey = childItem.getConfig().getJnpfKey();
                        if (this.isSkipFields(childItem)) continue;
                        String childVmodel = childItem.getVModel();
                        String childVmodel_old = "jnpf_old_" + childItem.getVModel();
                        String newValue = this.getValueByType(chilMap, childVmodel, childJnpfKey);
                        if (!Objects.equals(newValue, oldValue = this.getValueByType(oldMap, childVmodel, childJnpfKey))) {
                            hasChanged = true;
                        }
                        childDataMap.put(childVmodel, newValue);
                        childDataMap.put(childVmodel_old, oldValue);
                        childDataMap.put("jnpf_type", jnpf_type);
                    }
                    if (!hasChanged) continue;
                    childData.add(childDataMap);
                }
                if (!CollectionUtils.isNotEmpty(childData)) continue;
                VisualLogModel vlogModel = new VisualLogModel();
                vlogModel.setField(vModel);
                vlogModel.setFieldName(label);
                vlogModel.setJnpfKey(jnpfKey);
                vlogModel.setChidData(childData);
                vlogModel.setChidField(childField);
                vlogModel.setType(Integer.valueOf(1));
                listLog.add(vlogModel);
                continue;
            }
            String vModel = item.getVModel();
            if (Objects.equals(oldData.get(vModel), newData.get(vModel))) continue;
            Integer actionType = 1;
            if (oldData.get(vModel) == null || oldData.get(vModel).toString().trim().isEmpty()) {
                actionType = 0;
            }
            boolean nameModified = false;
            if (JnpfKeyConsts.getNameModified().contains(jnpfKey) && (JnpfKeyConsts.getNameModifiedNotDynamic().contains(jnpfKey) || OnlineDataTypeEnum.DYNAMIC.getType().equals(dataType))) {
                nameModified = true;
            }
            String newValue = this.getValueByType(newData, vModel, jnpfKey);
            String oldValue = this.getValueByType(oldData, vModel, jnpfKey);
            VisualLogModel vlogModel = new VisualLogModel();
            vlogModel.setField(vModel);
            vlogModel.setFieldName(label);
            vlogModel.setJnpfKey(jnpfKey);
            vlogModel.setNewData(newValue);
            vlogModel.setOldData(oldValue);
            vlogModel.setType(actionType);
            vlogModel.setNameModified(nameModified);
            listLog.add(vlogModel);
        }
    }

    private boolean isSkipFields(FieLdsModel childItem) {
        ArrayList<String> skipFields = new ArrayList<String>();
        skipFields.addAll(JnpfKeyConsts.getSystemKey());
        skipFields.add("popupAttr");
        skipFields.add("relationFormAttr");
        String jnpfKey = childItem.getConfig().getJnpfKey();
        return skipFields.contains(jnpfKey) || "calculate".equals(jnpfKey) && Objects.equals(childItem.getIsStorage(), 0);
    }

    private String getValueByType(Map<String, Object> map, String vModel, String jnpfKey) {
        if (map != null) {
            Object o = map.get(vModel);
            String value = o == null ? "" : o.toString();
            switch (jnpfKey) {
                case "uploadFile": {
                    List listM = (List)o;
                    if (listM == null) break;
                    StringJoiner sj = new StringJoiner(",");
                    listM.stream().forEach(t -> sj.add(((String)t.get("name")).toString()));
                    value = sj.toString();
                    break;
                }
                case "location": {
                    Map lcationMap = JsonUtil.stringToMap((String)value);
                    if (!MapUtils.isNotEmpty((Map)lcationMap)) break;
                    value = lcationMap.get("fullAddress") != null ? lcationMap.get("fullAddress").toString() : "";
                    break;
                }
            }
            return value;
        }
        return null;
    }
}

