/*
 * Decompiled with CFR 0.152.
 */
package jnpf.onlinedev.service.impl;

import cn.hutool.core.util.ObjectUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.mapper.FlowFormDataMapper;
import jnpf.base.model.OnlineImport.VisualdevModelDataInfoVO;
import jnpf.base.model.VisualConst;
import jnpf.base.service.DbLinkService;
import jnpf.base.util.FlowFormDataUtil;
import jnpf.base.util.FormPublicUtils;
import jnpf.database.model.entity.DbLinkEntity;
import jnpf.database.model.interfaces.DbSourceOrDbLink;
import jnpf.database.util.ConnUtil;
import jnpf.database.util.DynamicDataSourceUtil;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.FormCloumnUtil;
import jnpf.model.visualJson.FormDataModel;
import jnpf.model.visualJson.TableFields;
import jnpf.model.visualJson.TableModel;
import jnpf.model.visualJson.analysis.FormEnum;
import jnpf.model.visualJson.analysis.FormMastTableModel;
import jnpf.model.visualJson.analysis.RecursionForm;
import jnpf.onlinedev.model.OnlineInfoModel;
import jnpf.onlinedev.service.VisualDevInfoService;
import jnpf.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import jnpf.onlinedev.util.onlineDevUtil.OnlineSwapDataUtils;
import jnpf.util.JsonUtil;
import jnpf.util.JsonUtilEx;
import jnpf.util.StringUtil;
import jnpf.util.TableFeildsEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.render.RenderingStrategies;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.join.EqualTo;
import org.mybatis.dynamic.sql.select.join.JoinCondition;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisualDevInfoServiceImpl
implements VisualDevInfoService {
    @Autowired
    private DbLinkService dblinkService;
    @Autowired
    private FlowFormDataMapper flowFormDataMapper;
    @Autowired
    private OnlineSwapDataUtils onlineSwapDataUtils;
    @Autowired
    private FlowFormDataUtil flowDataUtil;

    @Override
    public VisualdevModelDataInfoVO getEditDataInfo(String id, VisualdevEntity visualdevEntity) {
        VisualdevModelDataInfoVO vo = new VisualdevModelDataInfoVO();
        Map editDataInfo = this.flowDataUtil.getEditDataInfo(visualdevEntity, id);
        if (editDataInfo != null && editDataInfo.size() > 0) {
            vo.setId(editDataInfo.get("id"));
            vo.setData(JsonUtilEx.getObjectToString((Object)editDataInfo));
        }
        return vo;
    }

    @Override
    public VisualdevModelDataInfoVO getDetailsDataInfo(String id, VisualdevEntity visualdevEntity) {
        return this.getDetailsDataInfo(id, visualdevEntity, OnlineInfoModel.builder().needRlationFiled(true).needSwap(true).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VisualdevModelDataInfoVO getDetailsDataInfo(String id, VisualdevEntity visualdevEntity, OnlineInfoModel infoModel) {
        VisualdevModelDataInfoVO vo = new VisualdevModelDataInfoVO();
        final HashMap allDataMap = new HashMap();
        Map<Object, Object> allDataResMap = new HashMap();
        FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getFormData(), FormDataModel.class);
        List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        List tableModelList = JsonUtil.getJsonToList((String)visualdevEntity.getVisualTables(), TableModel.class);
        List formAllModel = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)infoModel.getFormAllModel())) {
            formAllModel = infoModel.getFormAllModel();
        } else {
            RecursionForm recursionForm = new RecursionForm(list, tableModelList);
            FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
        }
        List mast = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        List table = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        List mastTable = formAllModel.stream().filter(t -> FormEnum.mastTable.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        ArrayList relationFiled = new ArrayList(){
            {
                this.add("relationForm");
                this.add("relationFormAttr");
            }
        };
        TableModel mainTable = tableModelList.stream().filter(t -> t.getTypeId().equals("1")).findFirst().orElse(null);
        DbLinkEntity linkEntity = "0".equals(visualdevEntity.getDbLinkId()) ? null : this.dblinkService.getInfo(visualdevEntity.getDbLinkId());
        try {
            DynamicDataSourceUtil.switchToDataSource((DbLinkEntity)linkEntity);
            Connection conn = ConnUtil.getConnOrDefault((DbSourceOrDbLink)linkEntity);
            try {
                String databaseProductName = conn.getMetaData().getDatabaseProductName();
                String dbType = conn.getMetaData().getDatabaseProductName().trim();
                boolean toUpperCase = databaseProductName.equalsIgnoreCase("oracle") || databaseProductName.equalsIgnoreCase("DM DBMS");
                TableFields tableFields = mainTable.getFields().stream().filter(t -> Objects.equals(t.getPrimaryKey(), 1) && !t.getField().toLowerCase().contains(TableFeildsEnum.TENANTID.getField())).findFirst().orElse(null);
                String pKeyName = Objects.nonNull(tableFields) ? tableFields.getField() : (toUpperCase ? TableFeildsEnum.FID.getField().toUpperCase() : TableFeildsEnum.FID.getField());
                SqlTable mainSqlTable = SqlTable.of((String)mainTable.getTable());
                Map<String, Object> mainAllMap = this.searchMainData(id, infoModel, mainTable, tableModelList);
                if (mainAllMap.size() == 0) {
                    VisualdevModelDataInfoVO visualdevModelDataInfoVO = vo;
                    return visualdevModelDataInfoVO;
                }
                if (!infoModel.isNeedRlationFiled()) {
                    mast = mast.stream().filter(t -> !relationFiled.contains(t.getFormColumnModel().getFieLdsModel().getConfig().getJnpfKey())).collect(Collectors.toList());
                }
                List mainTableFields = mast.stream().filter(m -> StringUtil.isNotEmpty((String)m.getFormColumnModel().getFieLdsModel().getVModel())).map(s -> s.getFormColumnModel().getFieLdsModel().getVModel()).collect(Collectors.toList());
                List mainTableBasicColumn = mainTableFields.stream().map(m -> SqlTable.of((String)mainTable.getTable()).column(m)).collect(Collectors.toList());
                mainTableBasicColumn.add(SqlTable.of((String)mainTable.getTable()).column(pKeyName));
                SelectStatementProvider mainRender = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select(mainTableBasicColumn).from(mainSqlTable).where((BindableColumn)mainSqlTable.column(pKeyName), (VisitableCondition)SqlBuilder.isEqualTo((Object)mainAllMap.get(pKeyName)), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
                List mapList = this.flowFormDataMapper.selectManyMappedRows(mainRender);
                if (ObjectUtil.isNotEmpty((Object)mapList) && mapList.size() > 0) {
                    allDataMap.putAll((Map)mapList.get(0));
                }
                Map<String, List<FormMastTableModel>> groupByTableNames = mastTable.stream().map(mt -> mt.getFormMastTableModel()).collect(Collectors.groupingBy(ma -> ma.getTable()));
                for (Map.Entry<String, List<FormMastTableModel>> next : groupByTableNames.entrySet()) {
                    SelectStatementProvider mastRender;
                    List childMapList;
                    boolean fogIdTypeString;
                    String childTableName = next.getKey();
                    List<Object> childMastTableList = next.getValue();
                    TableModel childTableModel = tableModelList.stream().filter(t -> t.getTable().equals(childTableName)).findFirst().orElse(null);
                    SqlTable mastSqlTable = SqlTable.of((String)childTableName);
                    if (!infoModel.isNeedRlationFiled()) {
                        childMastTableList = childMastTableList.stream().filter(t -> !relationFiled.contains(t.getMastTable().getFieLdsModel().getConfig().getJnpfKey())).collect(Collectors.toList());
                    }
                    List mastTableBasicColumn = childMastTableList.stream().filter(m -> StringUtil.isNotEmpty((String)m.getField())).map(m -> mastSqlTable.column(m.getField())).collect(Collectors.toList());
                    mastTableBasicColumn.add(mastSqlTable.column(childTableModel.getTableField()));
                    String mainField = childTableModel.getRelationField();
                    Object mainValue = new CaseInsensitiveMap(mainAllMap).get((Object)mainField);
                    String childFoIdFiled = childTableModel.getTableField();
                    TableFields fogIdField = childTableModel.getFields().stream().filter(t -> t.getField().equals(childFoIdFiled)).findFirst().orElse(null);
                    boolean bl = fogIdTypeString = Objects.nonNull(fogIdField) ? fogIdField.getDataType().toLowerCase().contains("varchar") : false;
                    if (fogIdTypeString) {
                        mainValue = mainValue.toString();
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)(childMapList = this.flowFormDataMapper.selectManyMappedRows(mastRender = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select(mastTableBasicColumn).from(mastSqlTable).where((BindableColumn)mastSqlTable.column(childFoIdFiled), (VisitableCondition)SqlBuilder.isEqualTo((Object)mainValue), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3))))) continue;
                    Map soloDataMap = (Map)childMapList.get(0);
                    HashMap renameKeyMap = new HashMap();
                    for (Map.Entry entry : soloDataMap.entrySet()) {
                        FormMastTableModel model = childMastTableList.stream().filter(child -> child.getField().equalsIgnoreCase(String.valueOf(entry.getKey()))).findFirst().orElse(null);
                        if (model == null) continue;
                        renameKeyMap.put(model.getVModel(), entry.getValue());
                    }
                    ArrayList mapList1 = new ArrayList();
                    mapList1.add(renameKeyMap);
                    allDataMap.putAll((Map)mapList1.get(0));
                }
                table.stream().map(t -> t.getChildList()).forEach(t1 -> {
                    SelectStatementProvider childRender;
                    List childMapList;
                    boolean fogIdTypeString;
                    String childTableName = t1.getTableName();
                    TableModel tableModel = tableModelList.stream().filter(tm -> tm.getTable().equals(childTableName)).findFirst().orElse(null);
                    SqlTable childSqlTable = SqlTable.of((String)childTableName);
                    List childFields = t1.getChildList().stream().filter(t2 -> StringUtil.isNotEmpty((String)t2.getFieLdsModel().getVModel())).map(t2 -> childSqlTable.column(t2.getFieLdsModel().getVModel())).collect(Collectors.toList());
                    childFields.add(childSqlTable.column(tableModel.getTableField()));
                    String childKeyName = this.flowDataUtil.getKey(tableModel, dbType);
                    childFields.add(childSqlTable.column(childKeyName));
                    String mainField = tableModel.getRelationField();
                    Object mainValue = new CaseInsensitiveMap(mainAllMap).get((Object)mainField);
                    String childFoIdFiled = tableModel.getTableField();
                    TableFields fogIdField = tableModel.getFields().stream().filter(t -> t.getField().equals(childFoIdFiled)).findFirst().orElse(null);
                    boolean bl = fogIdTypeString = Objects.nonNull(fogIdField) ? fogIdField.getDataType().toLowerCase().contains("varchar") : false;
                    if (fogIdTypeString) {
                        mainValue = mainValue.toString();
                    }
                    if (ObjectUtil.isNotEmpty((Object)(childMapList = this.flowFormDataMapper.selectManyMappedRows(childRender = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select(childFields).from(childSqlTable).where((BindableColumn)childSqlTable.column(tableModel.getTableField()), (VisitableCondition)SqlBuilder.isEqualTo((Object)mainValue), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3))))) {
                        HashMap<String, List> childMap = new HashMap<String, List>(1);
                        childMap.put(t1.getTableModel(), childMapList);
                        allDataMap.putAll(childMap);
                    }
                });
                ArrayList<FieLdsModel> fields = new ArrayList<FieLdsModel>();
                OnlinePublicUtils.recursionFields(fields, list);
                List dataList = FormPublicUtils.addIdToList((List)new ArrayList(){
                    {
                        this.add(allDataMap);
                    }
                }, (String)pKeyName);
                allDataResMap = infoModel.isNeedSwap() ? this.onlineSwapDataUtils.getSwapInfo(dataList, fields, (String)visualdevEntity.getId(), false, null).get(0) : allDataMap;
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            DynamicDataSourceUtil.clearSwitchDataSource();
        }
        vo.setId(allDataResMap.get("id"));
        vo.setData(JsonUtilEx.getObjectToString(allDataResMap));
        return vo;
    }

    private Map<String, Object> searchMainData(String id, OnlineInfoModel model, TableModel mainTable, List<TableModel> tableModelList) {
        SqlTable sqlTable;
        SqlTable mainSqlTable = SqlTable.of((String)mainTable.getTable());
        TableFields mainKeyModel = mainTable.getFields().stream().filter(t -> Objects.equals(t.getPrimaryKey(), 1) && !t.getField().toLowerCase().contains(TableFeildsEnum.TENANTID.getField())).findFirst().orElse(null);
        String propsValue = model.getPropsValue();
        SqlColumn column = null;
        TableFields storedFieldModel = null;
        if (StringUtil.isNotEmpty((String)propsValue)) {
            if (propsValue.contains("_jnpf_")) {
                String[] split = propsValue.split("_jnpf_");
                String thisTable = split[0].substring(5);
                String thisField = split[1];
                TableModel thisTableModel = tableModelList.stream().filter(t -> t.getTable().equalsIgnoreCase(thisTable)).findFirst().orElse(null);
                storedFieldModel = thisTableModel.getFields().stream().filter(t -> t.getField().equalsIgnoreCase(thisField)).findFirst().orElse(null);
                sqlTable = SqlTable.of((String)split[0].substring(5));
                column = sqlTable.column(storedFieldModel.getField());
            } else {
                storedFieldModel = mainTable.getFields().stream().filter(t -> t.getField().equalsIgnoreCase(propsValue)).findFirst().orElse(null);
                column = mainSqlTable.column(storedFieldModel.getField());
            }
        } else {
            storedFieldModel = mainKeyModel;
            column = mainSqlTable.column(storedFieldModel.getField());
        }
        Object idObj = id;
        if (VisualConst.DB_INT_ALL.contains(storedFieldModel.getDataType().toLowerCase())) {
            idObj = Long.parseLong(id);
        }
        QueryExpressionDSL from = SqlBuilder.select((BasicColumn[])new BasicColumn[]{mainSqlTable.allColumns()}).from(mainSqlTable);
        for (TableModel item : tableModelList) {
            if (Objects.equals("1", item.getTypeId())) continue;
            sqlTable = SqlTable.of((String)item.getTable());
            String tableField = item.getTableField();
            String relationField = item.getRelationField();
            from.leftJoin(sqlTable).on((BasicColumn)sqlTable.column(tableField), (JoinCondition)new EqualTo((BasicColumn)mainSqlTable.column(relationField)));
        }
        QueryExpressionDSL.QueryExpressionWhereBuilder where = (QueryExpressionDSL.QueryExpressionWhereBuilder)from.where((BindableColumn)column, (VisitableCondition)SqlBuilder.isEqualTo((Object)idObj), new AndOrCriteriaGroup[0]);
        SelectStatementProvider render = ((SelectModel)where.build()).render(RenderingStrategies.MYBATIS3);
        List maps = this.flowFormDataMapper.selectManyMappedRows(render);
        if (CollectionUtils.isNotEmpty((Collection)maps)) {
            return (Map)maps.get(0);
        }
        return new HashMap<String, Object>();
    }
}

