/*
 * Decompiled with CFR 0.152.
 */
package jnpf.integrate.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jnpf.base.ActionResult;
import jnpf.base.controller.SuperController;
import jnpf.base.vo.PageListVO;
import jnpf.base.vo.PaginationVO;
import jnpf.constant.MsgCode;
import jnpf.integrate.entity.IntegrateTaskEntity;
import jnpf.integrate.model.integrate.IntegratePageModel;
import jnpf.integrate.model.integratetask.IntegrateQueueListVO;
import jnpf.integrate.model.integratetask.IntegrateTaskInfo;
import jnpf.integrate.model.integratetask.IntegrateTaskListVO;
import jnpf.integrate.model.integratetask.IntegrateTaskModel;
import jnpf.integrate.service.IntegrateNodeService;
import jnpf.integrate.service.IntegrateQueueService;
import jnpf.integrate.service.IntegrateTaskService;
import jnpf.integrate.util.IntegrateUtil;
import jnpf.util.JsonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u96c6\u6210\u52a9\u624b\u65e5\u5fd7", description="IntegrateTask")
@RestController
@RequestMapping(value={"/api/visualdev/IntegrateTask"})
public class IntegrateTaskController
extends SuperController<IntegrateTaskService, IntegrateTaskEntity> {
    @Autowired
    private IntegrateTaskService integrateTaskService;
    @Autowired
    private IntegrateNodeService integrateNodeService;
    @Autowired
    private IntegrateUtil integrateUtil;
    @Autowired
    private IntegrateQueueService integrateQueueService;

    @Operation(summary="\u65e5\u5fd7\u5217\u8868")
    @GetMapping
    public ActionResult<PageListVO<IntegrateTaskListVO>> list(IntegratePageModel pagination) {
        List data = this.integrateTaskService.getList(pagination);
        List list = JsonUtil.getJsonToList((Object)data, IntegrateTaskListVO.class);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IntegrateTaskListVO taskListVO;
            taskListVO.setIsRetry(Integer.valueOf("0".equals((taskListVO = (IntegrateTaskListVO)iterator.next()).getParentId()) ? 0 : 1));
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        return ActionResult.page((List)list, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u5220\u9664")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e\u503c", required=true)})
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        this.integrateTaskService.delete(id);
        return ActionResult.success((String)MsgCode.SU003.get(new Object[0]));
    }

    @Operation(summary="\u6267\u884c\u5217\u8868")
    @GetMapping(value={"/queueList"})
    public ActionResult<List<IntegrateQueueListVO>> queueList() {
        List list = this.integrateQueueService.getList();
        List listVO = JsonUtil.getJsonToList((Object)list, IntegrateQueueListVO.class);
        return ActionResult.success((Object)listVO);
    }

    @Operation(summary="\u65e5\u5fd7\u8be6\u60c5")
    @GetMapping(value={"/{id}"})
    public ActionResult<IntegrateTaskInfo> list(final @PathVariable(value="id") String id) {
        IntegrateTaskEntity taskEntity = this.integrateTaskService.getInfo(id);
        List nodeList = this.integrateNodeService.getList((List)new ArrayList(){
            {
                this.add(id);
            }
        }, null);
        List list = JsonUtil.getJsonToList((Object)nodeList, IntegrateTaskModel.class);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IntegrateTaskModel taskModel;
            boolean isType = "0".equals((taskModel = (IntegrateTaskModel)iterator.next()).getParentId());
            taskModel.setType(Integer.valueOf(isType ? 1 : 0));
        }
        IntegrateTaskInfo info = new IntegrateTaskInfo();
        info.setList(list);
        info.setData(taskEntity.getData());
        return ActionResult.success((Object)info);
    }

    @Operation(summary="\u8282\u70b9\u91cd\u8bd5")
    @GetMapping(value={"/{id}/nodeRetry"})
    public ActionResult taskNode(@PathVariable(value="id") String id, String nodeId) {
        IntegrateTaskEntity taskEntity = this.integrateTaskService.getInfo(id);
        if (taskEntity != null) {
            this.integrateUtil.integrate(id, taskEntity.getParentId(), nodeId);
            return ActionResult.success((String)MsgCode.SU005.get(new Object[0]));
        }
        return ActionResult.fail((String)MsgCode.FA007.get(new Object[0]));
    }

    @Operation(summary="\u91cd\u8bd5")
    @PutMapping(value={"/{id}/retry"})
    public ActionResult ImportData(@PathVariable(value="id") String id) {
        IntegrateTaskEntity taskEntity = this.integrateTaskService.getInfo(id);
        if (taskEntity != null) {
            this.integrateUtil.integrate(id, id, "0");
            return ActionResult.success((String)MsgCode.SU005.get(new Object[0]));
        }
        return ActionResult.fail((String)MsgCode.FA007.get(new Object[0]));
    }
}

