/*
 * Decompiled with CFR 0.152.
 */
package jnpf.integrate.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.Method;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import jnpf.base.ActionResult;
import jnpf.base.UserInfo;
import jnpf.base.entity.SuperBaseEntity;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.model.OnlineImport.VisualdevModelDataInfoVO;
import jnpf.base.model.VisualDevJsonModel;
import jnpf.base.model.VisualLogModel;
import jnpf.base.model.flow.DataModel;
import jnpf.base.service.DataInterfaceService;
import jnpf.base.service.VisualdevService;
import jnpf.base.util.SentMessageUtil;
import jnpf.config.ConfigValueUtil;
import jnpf.constant.MsgCode;
import jnpf.database.model.superQuery.SuperJsonModel;
import jnpf.database.model.superQuery.SuperQueryJsonModel;
import jnpf.emnus.TemplateEnum;
import jnpf.exception.WorkFlowException;
import jnpf.flowable.entity.TaskEntity;
import jnpf.flowable.entity.TemplateEntity;
import jnpf.flowable.model.task.FlowModel;
import jnpf.flowable.model.templatejson.FlowFormModel;
import jnpf.flowable.model.trigger.TriggerDataFo;
import jnpf.flowable.model.trigger.TriggerModel;
import jnpf.flowable.service.TaskService;
import jnpf.flowable.service.TemplateJsonService;
import jnpf.flowable.service.TemplateService;
import jnpf.integrate.entity.IntegrateEntity;
import jnpf.integrate.entity.IntegrateNodeEntity;
import jnpf.integrate.entity.IntegrateQueueEntity;
import jnpf.integrate.entity.IntegrateTaskEntity;
import jnpf.integrate.model.childnode.IntegrateChildNode;
import jnpf.integrate.model.childnode.IntegrateMsgModel;
import jnpf.integrate.model.childnode.IntegrateParamModel;
import jnpf.integrate.model.childnode.IntegrateProperties;
import jnpf.integrate.model.childnode.IntegrateTemplateModel;
import jnpf.integrate.model.childnode.TransferModel;
import jnpf.integrate.model.integrate.IntegratePagination;
import jnpf.integrate.model.nodeJson.IntegrateChildNodeList;
import jnpf.integrate.model.nodeJson.IntegrateChildNodeModel;
import jnpf.integrate.service.IntegrateNodeService;
import jnpf.integrate.service.IntegrateQueueService;
import jnpf.integrate.service.IntegrateService;
import jnpf.integrate.service.IntegrateTaskService;
import jnpf.integrate.util.IntegrateHttpModel;
import jnpf.message.model.SentMessageForm;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.onlinedev.model.AsyncExecuteModel;
import jnpf.onlinedev.model.PaginationModel;
import jnpf.onlinedev.service.VisualDevInfoService;
import jnpf.onlinedev.service.VisualDevListService;
import jnpf.onlinedev.service.VisualdevModelDataService;
import jnpf.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import jnpf.permission.entity.UserEntity;
import jnpf.permission.model.authorize.AuthorizeConditionEnum;
import jnpf.permission.service.OrganizeAdministratorService;
import jnpf.permission.service.OrganizeService;
import jnpf.permission.service.UserService;
import jnpf.util.AuthUtil;
import jnpf.util.DateUtil;
import jnpf.util.JsonUtil;
import jnpf.util.RandomUtil;
import jnpf.util.StringUtil;
import jnpf.util.UserProvider;
import jnpf.workflow.service.TriggerApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class IntegrateUtil {
    @Autowired
    private UserService userService;
    @Autowired
    private SentMessageUtil sentMessageUtil;
    @Autowired
    private DataInterfaceService dataInterfaceService;
    @Autowired
    private VisualDevListService visualDevListService;
    @Autowired
    private IntegrateService integrateService;
    @Autowired
    private IntegrateQueueService integrateQueueService;
    @Autowired
    private VisualdevService visualdevService;
    @Autowired
    private VisualDevInfoService visualDevInfoService;
    @Autowired
    private IntegrateTaskService integrateTaskService;
    @Autowired
    private IntegrateNodeService integrateNodeService;
    @Autowired
    private VisualdevModelDataService visualdevModelDataService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private TemplateJsonService templateJsonService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private OrganizeAdministratorService organizeAdministratorService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private TriggerApi triggerApi;

    @Async
    public void asyncList(List<VisualdevModelDataInfoVO> resultData, UserInfo userInfo) {
        if (!resultData.isEmpty()) {
            String url = this.configValueUtil.getApiDomain() + "/api/visualdev/Integrate/execute";
            IntegrateHttpModel model = new IntegrateHttpModel();
            model.setUserInfo(userInfo);
            model.setDataInfoVOList(resultData);
            HttpRequest request = HttpRequest.of((String)url).method(Method.POST).body(JsonUtil.getObjectToString((Object)model));
            request.header("Authorization", userInfo.getToken());
            request.execute().body();
        }
    }

    @Async
    public void asyncExecute(AsyncExecuteModel executeModel) {
        List resultData;
        List listLog;
        String modelId = executeModel.getModelId();
        Integer trigger = executeModel.getTrigger();
        List dataId = executeModel.getDataId();
        UserInfo userInfo = executeModel.getUserInfo();
        DataModel dataModel = executeModel.getDataModel();
        TriggerDataFo fo = new TriggerDataFo();
        fo.setModelId(modelId);
        fo.setTrigger(trigger);
        fo.setDataId(dataId);
        if (dataModel != null && CollectionUtil.isNotEmpty((Collection)(listLog = dataModel.getListLog()))) {
            List<String> updateFields = this.getUpdateFields(listLog);
            fo.setUpdateFields(updateFields);
        }
        if (!(resultData = this.triggerApi.getTriggerDataModel(fo)).isEmpty()) {
            String url = this.configValueUtil.getApiDomain() + "/api/workflow/trigger/Execute";
            TriggerModel model = new TriggerModel();
            model.setUserInfo(userInfo);
            model.setDataList(resultData);
            HttpRequest request = HttpRequest.of((String)url).method(Method.POST).body(JsonUtil.getObjectToString((Object)model));
            request.header("Authorization", userInfo.getToken());
            request.execute().body();
        }
    }

    private List<String> getUpdateFields(List<VisualLogModel> listLog) {
        ArrayList<String> updateFields = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(listLog)) {
            for (VisualLogModel logModel : listLog) {
                String field = logModel.getField();
                List chidField = logModel.getChidField();
                List chidData = logModel.getChidData();
                if (CollectionUtil.isNotEmpty((Collection)chidField) && CollectionUtil.isNotEmpty((Collection)chidData)) {
                    block1: for (Map map : chidField) {
                        String key = (String)map.get("prop");
                        for (Map child : chidData) {
                            if (ObjectUtil.equals(child.get(key), child.get("jnpf_old_" + key))) continue;
                            updateFields.add(field + "-" + key);
                            continue block1;
                        }
                    }
                    continue;
                }
                updateFields.add(field);
            }
        }
        return updateFields;
    }

    public void integrates(List<VisualdevModelDataInfoVO> dataInfoVOList, UserInfo userInfo) {
        for (VisualdevModelDataInfoVO infoVO : dataInfoVOList) {
            String integrateId = infoVO.getIntegrateId();
            List dataList = JsonUtil.getJsonToListMap((String)infoVO.getData());
            this.integrate(integrateId, dataList, userInfo);
        }
    }

    public List<VisualdevModelDataInfoVO> dataList(String modelId, Integer trigger, List<String> dataId) {
        ArrayList<VisualdevModelDataInfoVO> resultData = new ArrayList<VisualdevModelDataInfoVO>();
        List<IntegrateEntity> list = this.integrateList(modelId, trigger);
        for (IntegrateEntity entity : list) {
            IntegrateChildNodeList childNodeModel = (IntegrateChildNodeList)JsonUtil.getJsonToBean((String)entity.getTemplateJson(), IntegrateChildNodeList.class);
            List<Map<String, Object>> dataList = this.dataList(childNodeModel, new HashMap<String, Object>(16), dataId);
            if (dataList.size() <= 0) continue;
            VisualdevModelDataInfoVO vo = new VisualdevModelDataInfoVO();
            vo.setData(JsonUtil.getObjectToString(dataList));
            vo.setIntegrateId((String)entity.getId());
            resultData.add(vo);
        }
        return resultData;
    }

    private List<IntegrateEntity> integrateList(String modelId, Integer trigger) {
        IntegratePagination pagination = new IntegratePagination();
        pagination.setFormId(modelId);
        pagination.setType(Integer.valueOf(1));
        pagination.setTrigger(trigger);
        pagination.setEnabledMark(Integer.valueOf(1));
        List<IntegrateEntity> list = this.integrateService.getList(pagination, false);
        return list;
    }

    public void integrate(String taskId, String parentId, String taskNodeId) {
        IntegrateTaskEntity taskEntity = this.integrateTaskService.getInfo(taskId);
        if (taskEntity != null) {
            ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
            try {
                dataList.addAll(JsonUtil.getJsonToListMap((String)taskEntity.getData()));
            }
            catch (Exception e) {
                dataList.add(JsonUtil.stringToMap((String)taskEntity.getData()));
            }
            this.integrate(taskEntity.getIntegrateId(), dataList, UserProvider.getUser(), parentId, taskNodeId);
        }
    }

    public void integrate(IntegrateQueueEntity queueEntity, UserInfo userInfo) {
        queueEntity.setState(Integer.valueOf(1));
        this.integrateQueueService.update((String)queueEntity.getId(), queueEntity);
        String integrateId = queueEntity.getIntegrateId();
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        IntegrateEntity entity = this.integrateService.getInfo(integrateId);
        if (entity != null) {
            IntegrateChildNode childNode = (IntegrateChildNode)JsonUtil.getJsonToBean((String)entity.getTemplateJson(), IntegrateChildNode.class);
            IntegrateChildNode getDataChildNode = childNode.getChildNode();
            IntegrateChildNodeList dataListNodeMode = (IntegrateChildNodeList)JsonUtil.getJsonToBean((Object)getDataChildNode, IntegrateChildNodeList.class);
            IntegrateProperties properties = dataListNodeMode.getProperties();
            Integer formType = properties.getFormType();
            if (Objects.equals(formType, 3)) {
                dataListNodeMode.getProperties().setTemplateJson(dataListNodeMode.getProperties().getInterfaceTemplateJson());
                try {
                    ActionResult result = this.interfaceTemplateJson(dataListNodeMode, new HashMap<String, Object>(), userInfo);
                    if (result.getData() instanceof List) {
                        dataList.addAll((List)result.getData());
                    }
                }
                catch (Exception exception) {}
            } else {
                dataList.addAll(this.dataList(dataListNodeMode, new HashMap<String, Object>(16), new ArrayList<String>()));
            }
            this.integrate(integrateId, dataList, userInfo);
            this.integrateQueueService.delete(queueEntity);
        }
    }

    private void integrate(String integrateId, List<Map<String, Object>> dataList, UserInfo userInfo) {
        this.integrate(integrateId, dataList, userInfo, "0", "0");
    }

    private void integrate(String integrateId, List<Map<String, Object>> dataList, UserInfo userInfo, String parentId, String taskNodeId) {
        if (dataList.isEmpty()) {
            return;
        }
        IntegrateEntity entity = this.integrateService.getInfo(integrateId);
        if (entity != null) {
            IntegrateTaskEntity parentTask = this.integrateTaskService.getInfo(parentId);
            boolean isParentId = parentTask != null;
            IntegrateNodeEntity info = this.integrateNodeService.getInfo(taskNodeId);
            boolean isTaskNodeId = info != null;
            String retryNodeCode = isTaskNodeId ? info.getNodeCode() : "";
            Date time = new Date();
            String json = isParentId ? entity.getTemplateJson() : entity.getTemplateJson();
            IntegrateChildNode childNode = (IntegrateChildNode)JsonUtil.getJsonToBean((String)json, IntegrateChildNode.class);
            IntegrateChildNode getDataChildNode = childNode.getChildNode();
            IntegrateChildNodeList dataListNodeMode = (IntegrateChildNodeList)JsonUtil.getJsonToBean((Object)getDataChildNode, IntegrateChildNodeList.class);
            dataListNodeMode.setStartTime(time);
            ArrayList<IntegrateChildNodeList> childNodeListAll = new ArrayList<IntegrateChildNodeList>();
            this.childList(childNode, childNodeListAll);
            IntegrateChildNodeList startNode = childNodeListAll.stream().filter(t -> "start".equals(t.getType())).findFirst().orElse(null);
            if (startNode != null) {
                ArrayList<String> idAll = new ArrayList<String>();
                IntegrateTaskEntity taskEntity = new IntegrateTaskEntity();
                ArrayList<IntegrateNodeEntity> errNodeList = new ArrayList<IntegrateNodeEntity>();
                String msg = "";
                HashMap<String, Object> errMsg = new HashMap<String, Object>();
                try {
                    for (int i = 0; i < dataList.size(); ++i) {
                        Map<String, Object> objectMap = dataList.get(i);
                        errMsg.putAll(objectMap);
                        String id = String.valueOf(objectMap.get("id"));
                        ArrayList<IntegrateNodeEntity> nodeList = new ArrayList<IntegrateNodeEntity>();
                        taskEntity.setIntegrateId((String)entity.getId());
                        taskEntity.setType(entity.getType());
                        taskEntity.setTemplateJson(entity.getTemplateJson());
                        taskEntity.setDataId(id);
                        taskEntity.setParentId(isParentId ? (String)parentTask.getId() : parentId);
                        taskEntity.setParentTime(isParentId ? parentTask.getExecutionTime() : null);
                        taskEntity.setResultType(Integer.valueOf(isParentId ? parentTask.getResultType() : 1));
                        taskEntity.setExecutionTime(new Date());
                        taskEntity.setId((Object)(isTaskNodeId ? info.getTaskId() : RandomUtil.uuId()));
                        taskEntity.setData(dataList.size() > 0 ? JsonUtil.getObjectToString(dataList) : JsonUtil.getObjectToString(objectMap));
                        taskEntity.setProcessId((String)taskEntity.getId());
                        idAll.add((String)taskEntity.getId());
                        if (i == 0 && !isParentId) {
                            IntegrateTaskEntity taskEntitys = (IntegrateTaskEntity)JsonUtil.getJsonToBean((Object)taskEntity, IntegrateTaskEntity.class);
                            this.integrateTaskService.saveOrUpdate(taskEntitys);
                        }
                        ArrayList<IntegrateChildNodeList> nodeListAll = new ArrayList<IntegrateChildNodeList>(childNodeListAll);
                        for (int k = 0; k < nodeListAll.size(); ++k) {
                            IntegrateChildNodeList childNodeList = (IntegrateChildNodeList)nodeListAll.get(k);
                            childNodeList.setIntegrateType(taskEntity.getType());
                            IntegrateProperties childProperties = childNodeList.getProperties();
                            IntegrateNodeEntity nodeEntity = new IntegrateNodeEntity();
                            nodeEntity.setResultType(Integer.valueOf(0));
                            nodeEntity.setParentId(taskNodeId);
                            nodeEntity.setNodeType(childNodeList.getType());
                            nodeEntity.setNodeNext(childNodeList.getNextId());
                            nodeEntity.setStartTime(time);
                            nodeEntity.setEndTime(time);
                            nodeEntity.setTaskId((String)taskEntity.getId());
                            nodeEntity.setNodeCode(childNodeList.getNodeId());
                            nodeEntity.setFormId(childProperties.getFormId());
                            nodeEntity.setNodeName(childProperties.getTitle());
                            nodeEntity.setNodePropertyJson(JsonUtil.getObjectToString((Object)childNodeList));
                            nodeEntity.setSortCode(Long.valueOf(Long.parseLong("" + k)));
                            nodeList.add(nodeEntity);
                        }
                        errNodeList = nodeList;
                        IntegrateChildNodeModel childNodeModel = IntegrateChildNodeModel.builder().dataListAll(dataList).data(objectMap).nodeList(nodeList).node(startNode.getNodeId()).entity(entity).retryNodeCode(retryNodeCode).userInfo(userInfo).num(0).build();
                        this.childNode(childNodeModel);
                        boolean failSum = nodeList.stream().filter(t -> t.getResultType() == 0).count() > 0L;
                        taskEntity.setResultType(Integer.valueOf(failSum ? 0 : 1));
                        this.integrateTaskService.update((String)taskEntity.getId(), taskEntity);
                    }
                }
                catch (Exception e) {
                    msg = e.getMessage();
                    taskEntity.setResultType(Integer.valueOf(0));
                }
                this.integrateTaskService.saveOrUpdate(taskEntity);
                idAll.remove(taskEntity.getId());
                if (!idAll.isEmpty()) {
                    QueryWrapper wrapper = new QueryWrapper();
                    wrapper.lambda().in(SuperBaseEntity.SuperIBaseEntity::getId, idAll);
                    this.integrateTaskService.remove((Wrapper)wrapper);
                    QueryWrapper nodeWrapper = new QueryWrapper();
                    nodeWrapper.lambda().in(IntegrateNodeEntity::getTaskId, idAll);
                    this.integrateNodeService.remove((Wrapper)nodeWrapper);
                }
                if (StringUtil.isNotEmpty((String)msg)) {
                    this.end(entity, new HashMap<String, Object>(errMsg), errNodeList, "end", false, userInfo);
                }
            }
        }
    }

    private void childList(IntegrateChildNode childNodeAll, List<IntegrateChildNodeList> listAll) {
        if (childNodeAll != null) {
            IntegrateChildNodeList childNodeList = (IntegrateChildNodeList)JsonUtil.getJsonToBean((Object)childNodeAll, IntegrateChildNodeList.class);
            boolean isNext = childNodeAll.getChildNode() != null;
            String nextId = isNext ? childNodeAll.getChildNode().getNodeId() : "end";
            childNodeList.setNextId(nextId);
            listAll.add(childNodeList);
            if (isNext) {
                this.childList(childNodeAll.getChildNode(), listAll);
            }
            if ("end".equals(nextId)) {
                IntegrateChildNodeList endChildNodeList = listAll.stream().filter(t -> "start".equals(t.getType())).findFirst().orElse(null);
                IntegrateChildNodeList endNode = (IntegrateChildNodeList)JsonUtil.getJsonToBean((Object)endChildNodeList, IntegrateChildNodeList.class);
                endNode.setNodeId(nextId);
                endNode.setType(nextId);
                endNode.setNextId("");
                endNode.getProperties().setTitle("\u7ed3\u675f");
                listAll.add(endNode);
            }
        }
    }

    private void childNode(IntegrateChildNodeModel childNodeModel) throws WorkFlowException {
        Map data = childNodeModel.getData();
        List dataList = childNodeModel.getDataListAll();
        List nodeList = childNodeModel.getNodeList();
        String node = childNodeModel.getNode();
        IntegrateEntity entity = childNodeModel.getEntity();
        String retryNodeCode = childNodeModel.getRetryNodeCode();
        UserInfo userInfo = childNodeModel.getUserInfo();
        IntegrateNodeEntity nodeEntity = nodeList.stream().filter(t -> t.getNodeCode().equals(node)).findFirst().orElse(null);
        if (nodeEntity != null) {
            String[] nodeType = nodeEntity.getNodeType();
            String nodeCode = nodeEntity.getNodeCode();
            String[] nextCodeAll = nodeEntity.getNodeNext().split(",");
            switch (nodeType) {
                case "addData": {
                    this.addData(new HashMap<String, Object>(data), nodeList, nodeCode, retryNodeCode);
                    break;
                }
                case "updateData": {
                    this.updateData(new HashMap<String, Object>(data), nodeList, nodeCode, retryNodeCode);
                    break;
                }
                case "deleteData": {
                    this.deleteData(new HashMap<String, Object>(data), new ArrayList<Map<String, Object>>(dataList), nodeList, nodeCode, retryNodeCode);
                    break;
                }
                case "message": {
                    this.message(new HashMap<String, Object>(data), nodeList, nodeCode, userInfo);
                    break;
                }
                case "dataInterface": {
                    this.dataInterface(new HashMap<String, Object>(data), nodeList, nodeCode, userInfo, retryNodeCode);
                    break;
                }
                case "getData": {
                    this.getData(entity, nodeList, nodeCode);
                    break;
                }
                case "launchFlow": {
                    this.launchFlow(new HashMap<String, Object>(data), nodeList, nodeCode, retryNodeCode);
                    break;
                }
                case "end": {
                    this.end(entity, new HashMap<String, Object>(data), nodeList, nodeCode, true, userInfo);
                    break;
                }
                case "start": {
                    this.start(entity, new HashMap<String, Object>(data), nodeList, nodeCode, true, userInfo, childNodeModel.getNum());
                    break;
                }
            }
            for (String nextCode : nextCodeAll) {
                childNodeModel.setNode(nextCode);
                this.childNode(childNodeModel);
            }
        }
    }

    private void getData(IntegrateEntity entity, List<IntegrateNodeEntity> nodeList, String node) {
        IntegrateNodeEntity nodeEntity = nodeList.stream().filter(t -> t.getNodeCode().equals(node)).findFirst().orElse(null);
        if (nodeEntity != null) {
            nodeEntity.setResultType(Integer.valueOf(1));
            List<IntegrateNodeEntity> list = this.nodeList(nodeEntity);
            if (list.size() == 0) {
                this.integrateNodeService.create(nodeEntity);
            }
        }
    }

    private void start(final IntegrateEntity entity, Map<String, Object> data, List<IntegrateNodeEntity> nodeList, String node, boolean isAdd, UserInfo userInfo, int num) {
        IntegrateNodeEntity nodeEntity = nodeList.stream().filter(t -> t.getNodeCode().equals(node)).findFirst().orElse(null);
        if (nodeEntity != null) {
            List<IntegrateNodeEntity> list = this.nodeList(nodeEntity);
            String templeId = "PZXTJC002";
            if (list.size() == 0) {
                boolean acquiesce;
                nodeEntity.setStartTime(nodeEntity.getStartTime());
                boolean failSum = num == 0;
                IntegrateChildNodeList childNodeList = (IntegrateChildNodeList)JsonUtil.getJsonToBean((String)nodeEntity.getNodePropertyJson(), IntegrateChildNodeList.class);
                IntegrateProperties properties = childNodeList.getProperties();
                IntegrateMsgModel msgConfig = properties.getStartMsgConfig();
                Integer on = msgConfig.getOn();
                boolean bl = acquiesce = on == 3;
                String msgId = on == 0 ? "" : (acquiesce ? templeId : msgConfig.getMsgId());
                List msgUserType = properties.getMsgUserType();
                List msgUserIds = properties.getMsgUserIds();
                HashSet<String> userIdList = new HashSet<String>();
                Iterator iterator = msgUserType.iterator();
                while (iterator.hasNext()) {
                    String type;
                    switch (type = (String)iterator.next()) {
                        case "1": {
                            userIdList.add(entity.getCreatorUserId());
                            break;
                        }
                        case "2": {
                            List adminList = this.userService.getAdminList().stream().map(SuperBaseEntity.SuperIBaseEntity::getId).collect(Collectors.toList());
                            userIdList.addAll(adminList);
                            break;
                        }
                        case "3": {
                            List userList = this.userService.getUserIdList(msgUserIds, null);
                            userIdList.addAll(userList);
                            break;
                        }
                    }
                }
                HashMap dataMap = new HashMap(){
                    {
                        this.put("@Title", entity.getFullName());
                        this.put("@CreatorUserName", "");
                    }
                };
                List templateJson = msgConfig.getTemplateJson();
                try {
                    if (StringUtil.isNotEmpty((String)msgId) && userIdList.size() > 0 && failSum) {
                        HashMap parameterMap = acquiesce ? dataMap : this.templateJson(templateJson, data, userInfo);
                        this.message(msgId, new ArrayList<String>(userIdList), parameterMap, userInfo);
                    }
                    nodeEntity.setResultType(Integer.valueOf(1));
                }
                catch (Exception e) {
                    this.errMsg(nodeEntity, e);
                }
                nodeEntity.setEndTime(nodeEntity.getEndTime());
                if (isAdd) {
                    this.integrateNodeService.create(nodeEntity);
                }
            }
        }
    }

    private void end(final IntegrateEntity entity, Map<String, Object> data, List<IntegrateNodeEntity> nodeList, String node, boolean isAdd, UserInfo userInfo) {
        List<IntegrateNodeEntity> list;
        IntegrateNodeEntity nodeEntity = nodeList.stream().filter(t -> t.getNodeCode().equals(node)).findFirst().orElse(null);
        if (nodeEntity != null && (list = this.nodeList(nodeEntity)).size() == 0) {
            boolean acquiesce;
            String templeId = "PZXTJC001";
            nodeEntity.setStartTime(new Date());
            boolean failSum = !isAdd;
            IntegrateChildNodeList childNodeList = (IntegrateChildNodeList)JsonUtil.getJsonToBean((String)nodeEntity.getNodePropertyJson(), IntegrateChildNodeList.class);
            IntegrateProperties properties = childNodeList.getProperties();
            IntegrateMsgModel msgConfig = properties.getFailMsgConfig();
            Integer on = msgConfig.getOn();
            boolean bl = acquiesce = on == 3;
            String msgId = on == 0 ? "" : (acquiesce ? templeId : msgConfig.getMsgId());
            List msgUserType = properties.getMsgUserType();
            List msgUserIds = properties.getMsgUserIds();
            HashSet<String> userIdList = new HashSet<String>();
            Iterator iterator = msgUserType.iterator();
            while (iterator.hasNext()) {
                String type;
                switch (type = (String)iterator.next()) {
                    case "1": {
                        userIdList.add(entity.getCreatorUserId());
                        break;
                    }
                    case "2": {
                        List adminList = this.userService.getAdminList().stream().map(SuperBaseEntity.SuperIBaseEntity::getId).collect(Collectors.toList());
                        userIdList.addAll(adminList);
                        break;
                    }
                    case "3": {
                        List userList = this.userService.getUserIdList(msgUserIds, null);
                        userIdList.addAll(userList);
                        break;
                    }
                }
            }
            HashMap dataMap = new HashMap(){
                {
                    this.put("@Title", entity.getFullName());
                    this.put("@CreatorUserName", "");
                }
            };
            List templateJson = msgConfig.getTemplateJson();
            try {
                if (StringUtil.isNotEmpty((String)msgId) && userIdList.size() > 0 && failSum) {
                    HashMap parameterMap = acquiesce ? dataMap : this.templateJson(templateJson, data, userInfo);
                    this.message(msgId, new ArrayList<String>(userIdList), parameterMap, userInfo);
                }
                nodeEntity.setResultType(Integer.valueOf(1));
            }
            catch (Exception e) {
                this.errMsg(nodeEntity, e);
            }
            nodeEntity.setEndTime(new Date());
            if (isAdd) {
                this.integrateNodeService.create(nodeEntity);
            }
        }
    }

    private void addData(Map<String, Object> data, List<IntegrateNodeEntity> nodeList, String node, String retryNodeCode) throws WorkFlowException {
        IntegrateNodeEntity nodeEntity = nodeList.stream().filter(t -> t.getNodeCode().equals(node)).findFirst().orElse(null);
        if (nodeEntity != null) {
            List<IntegrateNodeEntity> list = this.nodeList(nodeEntity);
            boolean isRetry = nodeEntity.getNodeCode().equals(retryNodeCode);
            if (list.size() == 0 || isRetry) {
                nodeEntity.setStartTime(new Date());
                IntegrateChildNodeList childNodeList = (IntegrateChildNodeList)JsonUtil.getJsonToBean((String)nodeEntity.getNodePropertyJson(), IntegrateChildNodeList.class);
                IntegrateProperties properties = childNodeList.getProperties();
                boolean isAdd = Objects.equals(childNodeList.getIntegrateType(), 1);
                if (!isAdd) {
                    List<Map<String, Object>> dataList = this.dataList(childNodeList, data, new ArrayList<String>());
                    Integer addRule = properties.getAddRule();
                    isAdd = dataList.size() > 0 && addRule == 1 || dataList.size() == 0;
                }
                String msg = "";
                try {
                    if (isAdd) {
                        String formId = properties.getFormId();
                        String flowId = properties.getFlowId();
                        if (ObjectUtil.isNotEmpty((Object)flowId)) {
                            TemplateEntity template = this.templateService.getInfo(flowId);
                            flowId = template.getFlowId();
                        }
                        VisualdevEntity visualdevEntity = this.visualdevService.getReleaseInfo(formId);
                        List transferList = properties.getTransferList();
                        Map<String, Object> saveData = this.formData(data, transferList);
                        saveData.put("flowId", flowId);
                        this.visualdevModelDataService.visualCreate(visualdevEntity, saveData);
                    }
                    nodeEntity.setResultType(Integer.valueOf(1));
                }
                catch (Exception e) {
                    this.errMsg(nodeEntity, e);
                    msg = e.getMessage();
                }
                nodeEntity.setEndTime(new Date());
                if (isRetry) {
                    this.integrateNodeService.update(nodeEntity.getTaskId(), nodeEntity.getNodeCode());
                }
                this.integrateNodeService.create(nodeEntity);
                if (StringUtil.isNotEmpty((String)msg)) {
                    throw new WorkFlowException(msg);
                }
            }
        }
    }

    private void updateData(Map<String, Object> data, List<IntegrateNodeEntity> nodeList, String node, String retryNodeCode) throws WorkFlowException {
        IntegrateNodeEntity nodeEntity = nodeList.stream().filter(t -> t.getNodeCode().equals(node)).findFirst().orElse(null);
        if (nodeEntity != null) {
            List<IntegrateNodeEntity> list = this.nodeList(nodeEntity);
            boolean isRetry = nodeEntity.getNodeCode().equals(retryNodeCode);
            if (list.size() == 0 || isRetry) {
                nodeEntity.setStartTime(new Date());
                IntegrateChildNodeList childNodeList = (IntegrateChildNodeList)JsonUtil.getJsonToBean((String)nodeEntity.getNodePropertyJson(), IntegrateChildNodeList.class);
                IntegrateProperties properties = childNodeList.getProperties();
                String formId = properties.getFormId();
                VisualdevEntity visualdevEntity = this.visualdevService.getReleaseInfo(formId);
                List transferList = properties.getTransferList();
                List<Map<String, Object>> dataList = this.dataList(childNodeList, data, new ArrayList<String>());
                Integer unFoundRule = properties.getUnFoundRule();
                String msg = "";
                boolean isAdd = dataList.size() == 0 && unFoundRule == 1;
                try {
                    String flowId = properties.getFlowId();
                    if (ObjectUtil.isNotEmpty((Object)flowId)) {
                        TemplateEntity template = this.templateService.getInfo(flowId);
                        flowId = template.getFlowId();
                    }
                    if (isAdd) {
                        Map<String, Object> saveData = this.formData(data, transferList);
                        saveData.put("flowId", flowId);
                        dataList.add(saveData);
                    }
                    for (Map<String, Object> objectMap : dataList) {
                        if (isAdd) {
                            this.visualdevModelDataService.visualCreate(visualdevEntity, objectMap);
                            continue;
                        }
                        String id = String.valueOf(objectMap.get("id"));
                        Map<String, Object> saveData = this.formData(data, objectMap, transferList);
                        HashMap<String, Object> dataObject = new HashMap<String, Object>(saveData);
                        this.visualdevModelDataService.visualUpdate(visualdevEntity, dataObject, id);
                    }
                    nodeEntity.setResultType(Integer.valueOf(1));
                }
                catch (Exception e) {
                    this.errMsg(nodeEntity, e);
                    msg = e.getMessage();
                }
                nodeEntity.setEndTime(new Date());
                if (isRetry) {
                    this.integrateNodeService.update(nodeEntity.getTaskId(), nodeEntity.getNodeCode());
                }
                this.integrateNodeService.create(nodeEntity);
                if (StringUtil.isNotEmpty((String)msg)) {
                    throw new WorkFlowException(msg);
                }
            }
        }
    }

    private void deleteData(Map<String, Object> data, List<Map<String, Object>> dataListAll, List<IntegrateNodeEntity> nodeList, String node, String retryNodeCode) throws WorkFlowException {
        IntegrateNodeEntity nodeEntity = nodeList.stream().filter(t -> t.getNodeCode().equals(node)).findFirst().orElse(null);
        if (nodeEntity != null) {
            List<IntegrateNodeEntity> list = this.nodeList(nodeEntity);
            boolean isRetry = nodeEntity.getNodeCode().equals(retryNodeCode);
            if (list.size() == 0 || isRetry) {
                nodeEntity.setStartTime(new Date());
                String nodeJson = nodeEntity.getNodePropertyJson();
                IntegrateChildNodeList childNodeList = (IntegrateChildNodeList)JsonUtil.getJsonToBean((String)nodeJson, IntegrateChildNodeList.class);
                IntegrateProperties properties = childNodeList.getProperties();
                String formId = properties.getFormId();
                String menuId = properties.getId();
                String flowId = properties.getFlowId();
                Integer deleteRule = Objects.equals(childNodeList.getIntegrateType(), 1) ? 1 : properties.getDeleteRule();
                IntegrateChildNodeList dataChildNode = new IntegrateChildNodeList();
                dataChildNode.setType(childNodeList.getType());
                IntegrateProperties dataChildProperties = dataChildNode.getProperties();
                dataChildProperties.setFormId(formId);
                dataChildProperties.setId(menuId);
                dataChildProperties.setFlowId(flowId);
                boolean delete = Objects.equals(deleteRule, 1);
                List<Map<String, Object>> dataList = this.dataList(delete ? childNodeList : dataChildNode, data, new ArrayList<String>());
                List idList = dataList.stream().filter(t -> ObjectUtil.isNotEmpty(t.get("id"))).map(t -> String.valueOf(t.get("id"))).collect(Collectors.toList());
                ArrayList deleteList = new ArrayList();
                if (delete) {
                    deleteList.addAll(idList);
                } else {
                    ArrayList addList = new ArrayList();
                    for (Map<String, Object> objectMap : dataListAll) {
                        List idAll = this.dataList((IntegrateChildNodeList)JsonUtil.getJsonToBean((String)nodeJson, IntegrateChildNodeList.class), objectMap, new ArrayList<String>()).stream().filter(t -> ObjectUtil.isNotEmpty(t.get("id"))).map(t -> String.valueOf(t.get("id"))).collect(Collectors.toList());
                        addList.addAll(idAll);
                    }
                    idList.removeAll(addList);
                    deleteList.addAll(idList);
                }
                String msg = "";
                try {
                    if (deleteList.size() > 0) {
                        List deleteDataList = dataList.stream().filter(t -> deleteList.contains(String.valueOf(t.get("id")))).collect(Collectors.toList());
                        VisualdevEntity visualdevEntity = this.visualdevService.getReleaseInfo(formId);
                        this.visualdevModelDataService.visualDelete(visualdevEntity, deleteDataList);
                    }
                    nodeEntity.setResultType(Integer.valueOf(1));
                }
                catch (Exception e) {
                    this.errMsg(nodeEntity, e);
                    msg = e.getMessage();
                }
                nodeEntity.setEndTime(new Date());
                if (isRetry) {
                    this.integrateNodeService.update(nodeEntity.getTaskId(), nodeEntity.getNodeCode());
                }
                this.integrateNodeService.create(nodeEntity);
                if (StringUtil.isNotEmpty((String)msg)) {
                    throw new WorkFlowException(msg);
                }
            }
        }
    }

    private void message(Map<String, Object> data, List<IntegrateNodeEntity> nodeList, String node, UserInfo userInfo) throws WorkFlowException {
        IntegrateNodeEntity nodeEntity = nodeList.stream().filter(t -> t.getNodeCode().equals(node)).findFirst().orElse(null);
        if (nodeEntity != null) {
            String msg = "";
            List<IntegrateNodeEntity> list = this.nodeList(nodeEntity);
            if (list.size() == 0) {
                nodeEntity.setStartTime(new Date());
                IntegrateChildNodeList childNodeList = (IntegrateChildNodeList)JsonUtil.getJsonToBean((String)nodeEntity.getNodePropertyJson(), IntegrateChildNodeList.class);
                IntegrateProperties properties = childNodeList.getProperties();
                List userIdList = this.userService.getUserIdList(properties.getMsgUserIds(), null);
                String msgId = properties.getMsgId();
                List templateJson = properties.getTemplateJson();
                try {
                    Map<String, Object> parameterMap = this.templateJson(templateJson, data, userInfo);
                    if (userIdList.size() > 0) {
                        this.message(msgId, userIdList, parameterMap, userInfo);
                    }
                    nodeEntity.setResultType(Integer.valueOf(1));
                }
                catch (Exception e) {
                    this.errMsg(nodeEntity, e);
                    msg = e.getMessage();
                }
                nodeEntity.setEndTime(new Date());
                this.integrateNodeService.create(nodeEntity);
                if (StringUtil.isNotEmpty((String)msg)) {
                    throw new WorkFlowException(msg);
                }
            }
        }
    }

    private void dataInterface(Map<String, Object> data, List<IntegrateNodeEntity> nodeList, String node, UserInfo userInfo, String retryNodeCode) throws WorkFlowException {
        IntegrateNodeEntity nodeEntity = nodeList.stream().filter(t -> t.getNodeCode().equals(node)).findFirst().orElse(null);
        if (nodeEntity != null) {
            String msg = "";
            List<IntegrateNodeEntity> list = this.nodeList(nodeEntity);
            boolean isRetry = nodeEntity.getNodeCode().equals(retryNodeCode);
            if (list.size() == 0 || isRetry) {
                nodeEntity.setStartTime(new Date());
                try {
                    IntegrateChildNodeList childNodeList = (IntegrateChildNodeList)JsonUtil.getJsonToBean((String)nodeEntity.getNodePropertyJson(), IntegrateChildNodeList.class);
                    this.interfaceTemplateJson(childNodeList, data, userInfo);
                    nodeEntity.setResultType(Integer.valueOf(1));
                }
                catch (Exception e) {
                    this.errMsg(nodeEntity, e);
                    msg = e.getMessage();
                }
                nodeEntity.setEndTime(new Date());
                if (isRetry) {
                    this.integrateNodeService.update(nodeEntity.getTaskId(), nodeEntity.getNodeCode());
                }
                this.integrateNodeService.create(nodeEntity);
                if (StringUtil.isNotEmpty((String)msg)) {
                    throw new WorkFlowException(msg);
                }
            }
        }
    }

    private Map<String, Object> formData(Map<String, Object> formData, List<TransferModel> transferList) throws WorkFlowException {
        return this.formData(formData, new HashMap<String, Object>(), transferList);
    }

    private Map<String, Object> formData(Map<String, Object> formData, Map<String, Object> resultData, List<TransferModel> transferList) throws WorkFlowException {
        HashMap<String, Object> result = new HashMap<String, Object>(resultData);
        HashMap<String, Object> oldData = new HashMap<String, Object>(formData);
        HashSet<String> msg = new HashSet<String>();
        for (TransferModel assignMode : transferList) {
            String childData;
            String[] stringArray;
            Boolean required = assignMode.getRequired();
            String targetFieldLabel = assignMode.getTargetFieldLabel();
            Integer sourceType = assignMode.getSourceType();
            boolean isData = ObjectUtil.equals((Object)sourceType, (Object)TemplateEnum.Custom.getCode());
            String parentField = assignMode.getSourceValue();
            if (isData) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = parentField;
            } else {
                stringArray = parentField.split("-");
            }
            String[] parentFieldList = stringArray;
            String childField = assignMode.getTargetField();
            String[] childFieldList = childField.split("-");
            String string = isData ? parentField : (childData = "@formId".equals(parentField) ? formData.get("id") : formData.get(parentField));
            if (childFieldList.length > 1) {
                ArrayList childMapAll = new ArrayList();
                if (result.get(childFieldList[0]) instanceof List) {
                    List childList = (List)result.get(childFieldList[0]);
                    for (Map objectMap : childList) {
                        HashMap childMap = new HashMap(objectMap);
                        childMapAll.add(childMap);
                    }
                }
                if (parentFieldList.length > 1) {
                    if (oldData.get(parentFieldList[0]) instanceof List) {
                        int i;
                        List parentList = (List)oldData.get(parentFieldList[0]);
                        int num = parentList.size() - childMapAll.size();
                        for (i = 0; i < num; ++i) {
                            childMapAll.add(new HashMap());
                        }
                        for (i = 0; i < parentList.size(); ++i) {
                            Map parentMap = (Map)parentList.get(i);
                            Map childMap = (Map)childMapAll.get(i);
                            if (required.booleanValue() && ObjectUtil.isEmpty(parentMap.get(parentFieldList[1]))) {
                                msg.add(targetFieldLabel);
                            }
                            childMap.put(childFieldList[1], parentMap.get(parentFieldList[1]));
                        }
                    }
                } else {
                    if (1 > childMapAll.size()) {
                        childMapAll.add(new HashMap());
                    }
                    Map childMap = (Map)childMapAll.get(0);
                    if (required.booleanValue() && ObjectUtil.isEmpty((Object)childData)) {
                        msg.add(targetFieldLabel);
                    }
                    childMap.put(childFieldList[1], childData);
                }
                result.put(childFieldList[0], childMapAll);
                continue;
            }
            if (parentFieldList.length > 1 && oldData.get(parentFieldList[0]) instanceof List) {
                List parentList = (List)oldData.get(parentFieldList[0]);
                for (int i = 0; i < parentList.size(); ++i) {
                    Map parentMap = (Map)parentList.get(i);
                    if (i != 0) continue;
                    childData = parentMap.get(parentFieldList[1]);
                }
            }
            if (required.booleanValue() && ObjectUtil.isEmpty((Object)childData)) {
                msg.add(targetFieldLabel);
            }
            result.put(childField, childData);
        }
        this.errRequiredMsg(msg);
        return result;
    }

    private List<Map<String, Object>> dataList(IntegrateChildNodeList childNodeList, Map<String, Object> data, List<String> dataId) {
        boolean idDelete = Objects.equals(childNodeList.getType(), "deleteData");
        IntegrateProperties properties = childNodeList.getProperties();
        String formId = properties.getFormId();
        List ruleList = properties.getRuleList();
        String ruleMatchLogic = properties.getRuleMatchLogic();
        String menuId = properties.getId();
        String flowId = properties.getFlowId();
        boolean isFlow = StringUtil.isNotEmpty((String)flowId);
        for (SuperQueryJsonModel superQueryJsonModel : ruleList) {
            List groups = superQueryJsonModel.getGroups();
            for (FieLdsModel fieLdsModel : groups) {
                String fieldValue;
                boolean valueType = "1".equals(fieLdsModel.getFieldValueType());
                String string = fieldValue = data.get(fieLdsModel.getFieldValue()) != null ? String.valueOf(data.get(fieLdsModel.getFieldValue())) : null;
                if ("@formId".equals(fieLdsModel.getFieldValue())) {
                    fieldValue = String.valueOf(data.get("id"));
                }
                fieLdsModel.setFieldValue(valueType ? fieldValue : fieLdsModel.getFieldValue());
            }
        }
        SuperJsonModel superJsonModel = new SuperJsonModel();
        superJsonModel.setConditionList(ruleList);
        superJsonModel.setMatchLogic(StringUtil.isNotEmpty((String)ruleMatchLogic) ? ruleMatchLogic : superJsonModel.getMatchLogic());
        PaginationModel paginationModel = new PaginationModel();
        paginationModel.setPageSize(10000L);
        paginationModel.setMenuId(menuId);
        paginationModel.setSuperQueryJson(ruleList.size() > 0 ? JsonUtil.getObjectToString((Object)superJsonModel) : "");
        VisualdevEntity visualdevEntity = this.visualdevService.getReleaseInfo(formId);
        VisualDevJsonModel visualJsonModel = OnlinePublicUtils.getVisualJsonModel((VisualdevEntity)visualdevEntity);
        ArrayList<Object> idAll = new ArrayList<Object>();
        ArrayList idList = new ArrayList();
        try {
            if (ruleList.size() > 0) {
                visualJsonModel.setSuperQuery(superJsonModel);
            }
            if (isFlow) {
                List flowVersionIds = this.templateJsonService.getListByTemplateIds((List)ImmutableList.of((Object)flowId)).stream().map(SuperBaseEntity.SuperIBaseEntity::getId).collect(Collectors.toList());
                visualJsonModel.setFlowVersionIds(flowVersionIds);
                visualJsonModel.setEnableFlow(flowVersionIds.size() > 0);
            }
            List dataList = this.visualDevListService.getListWithTableList(visualJsonModel, paginationModel, UserProvider.getUser());
            idList.addAll(dataList.stream().map(t -> String.valueOf(t.get("id"))).collect(Collectors.toList()));
        }
        catch (Exception dataList) {
            // empty catch block
        }
        List intersection = idList.stream().filter(item -> dataId.contains(item)).collect(Collectors.toList());
        if (dataId.size() > 0) {
            idAll.addAll(intersection);
        } else {
            idAll.addAll(idList);
        }
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        for (String string : idAll) {
            VisualdevModelDataInfoVO infoVO = this.visualDevInfoService.getEditDataInfo(string, visualdevEntity);
            if (!StringUtil.isNotEmpty((String)infoVO.getData())) continue;
            Map map = JsonUtil.stringToMap((String)infoVO.getData());
            map.put("id", infoVO.getId());
            boolean isAdd = true;
            if (isFlow && !idDelete) {
                TaskEntity infoSubmit = this.taskService.getInfoSubmit(String.valueOf(map.get("flowTaskId")), new SFunction[]{TaskEntity::getEndTime});
                boolean bl = isAdd = infoSubmit != null && infoSubmit.getEndTime() != null;
            }
            if (!isAdd) continue;
            dataList.add(map);
        }
        return dataList;
    }

    private void message(String msgId, List<String> userIdList, Map<String, Object> parameterMap, UserInfo userInfo) {
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setUserInfo(userInfo);
        sentMessageForm.setTemplateId(msgId);
        sentMessageForm.setToUserIds(userIdList);
        sentMessageForm.setParameterMap(parameterMap);
        sentMessageForm.setType(Integer.valueOf(3));
        sentMessageForm.setContentMsg(new HashMap());
        sentMessageForm.setId(msgId);
        this.sentMessageUtil.sendDelegateMsg(sentMessageForm);
    }

    private List<IntegrateNodeEntity> nodeList(final IntegrateNodeEntity nodeEntity) {
        List<IntegrateNodeEntity> list = this.integrateNodeService.getList(new ArrayList(){
            {
                this.add(nodeEntity.getTaskId());
            }
        }, nodeEntity.getNodeCode(), 1);
        IntegrateNodeEntity integrateNode = list.stream().filter(t -> t.getNodeCode().equals(nodeEntity.getNodeCode()) && t.getResultType() == 1).findFirst().orElse(null);
        nodeEntity.setResultType(integrateNode != null ? integrateNode.getResultType() : nodeEntity.getResultType());
        return list;
    }

    private Map<String, Object> templateJson(List<IntegrateTemplateModel> templateJson, Map<String, Object> data, UserInfo userInfo) throws WorkFlowException {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        HashSet<String> msg = new HashSet<String>();
        for (IntegrateTemplateModel templateJsonModel : templateJson) {
            List paramJson = templateJsonModel.getParamJson();
            for (IntegrateParamModel integrateParamModel : paramJson) {
                Object dataList;
                String dataValue;
                Boolean required = integrateParamModel.getRequired();
                String fieldId = integrateParamModel.getField();
                String relationField = integrateParamModel.getRelationField();
                String[] model = StringUtil.isNotEmpty((String)relationField) ? relationField.split("-") : new String[]{};
                String string = dataValue = data.get(relationField) != null ? String.valueOf(data.get(relationField)) : "";
                if ("@formId".equals(relationField)) {
                    String string2 = dataValue = data.get("id") != null ? String.valueOf(data.get("id")) : "";
                }
                if (model.length > 1 && (dataList = data.get(model[0])) instanceof List) {
                    List listAll = (List)dataList;
                    ArrayList dataListAll = new ArrayList();
                    for (Map objectMap : listAll) {
                        dataListAll.add(objectMap.get(model[1]));
                    }
                    if (required.booleanValue() && ObjectUtil.isEmpty(dataListAll)) {
                        msg.add(fieldId);
                    }
                    dataValue = String.valueOf(dataListAll);
                }
                if (required.booleanValue() && ObjectUtil.isEmpty((Object)dataValue)) {
                    msg.add(fieldId);
                }
                parameterMap.put(integrateParamModel.getMsgTemplateId() + fieldId, dataValue);
            }
            ImmutableMap paramMap = ImmutableMap.of((Object)"@CreatorUserName", (Object)userInfo.getUserName(), (Object)"@SendTime", (Object)DateUtil.getNow().substring(11));
            for (String key : paramMap.keySet()) {
                parameterMap.put(templateJsonModel.getId() + key, paramMap.get(key));
            }
        }
        this.errRequiredMsg(msg);
        return parameterMap;
    }

    private void errMsg(IntegrateNodeEntity nodeEntity, Exception e) {
        ActionResult result = new ActionResult();
        result.setCode(Integer.valueOf(400));
        result.setMsg(e.getMessage());
        if (nodeEntity != null) {
            nodeEntity.setErrorMsg(JsonUtil.getObjectToString((Object)result));
        }
    }

    private ActionResult interfaceTemplateJson(IntegrateChildNodeList childNodeList, Map<String, Object> data, UserInfo userInfo) throws WorkFlowException {
        IntegrateProperties properties = childNodeList.getProperties();
        String interId = properties.getFormId();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        List templateJson = properties.getTemplateJson();
        HashSet<String> msg = new HashSet<String>();
        for (IntegrateTemplateModel templateJsonModel : templateJson) {
            Object dataList;
            String[] model;
            String dataValue;
            String fieldId = templateJsonModel.getField();
            Boolean required = templateJsonModel.getRequired();
            String relationField = templateJsonModel.getRelationField();
            String string = dataValue = data.get(relationField) != null ? String.valueOf(data.get(relationField)) : null;
            if (AuthorizeConditionEnum.FORMID.getCondition().equals(relationField)) {
                dataValue = String.valueOf(data.get("id"));
            } else if (AuthorizeConditionEnum.USER.getCondition().equals(relationField)) {
                dataValue = userInfo.getUserId();
            } else if (AuthorizeConditionEnum.USERANDUNDER.getCondition().equals(relationField)) {
                ArrayList<String> subOrganizeIds = new ArrayList<String>();
                subOrganizeIds.addAll(this.userService.getListByManagerId(userInfo.getUserId(), null).stream().map(SuperBaseEntity.SuperIBaseEntity::getId).collect(Collectors.toList()));
                subOrganizeIds.add(userInfo.getUserId());
                dataValue = subOrganizeIds.stream().collect(Collectors.joining(","));
            } else if (AuthorizeConditionEnum.ORGANIZE.getCondition().equals(relationField)) {
                orgId = userInfo.getOrganizeId();
                if (StringUtil.isNotEmpty((String)userInfo.getDepartmentId())) {
                    orgId = userInfo.getDepartmentId();
                }
                dataValue = orgId;
            } else if (AuthorizeConditionEnum.ORGANIZEANDUNDER.getCondition().equals(relationField)) {
                orgId = userInfo.getOrganizeId();
                if (StringUtil.isNotEmpty((String)userInfo.getDepartmentId())) {
                    orgId = userInfo.getDepartmentId();
                }
                List underOrganizations = this.organizeService.getUnderOrganizations(orgId, false);
                underOrganizations.add(orgId);
                dataValue = underOrganizations.stream().collect(Collectors.joining(","));
            } else if (AuthorizeConditionEnum.BRANCHMANAGEORG.getCondition().equals(relationField)) {
                List orgIds = this.organizeAdministratorService.getOrganizeUserList("@currentOrgAndSubOrg");
                dataValue = orgIds.stream().collect(Collectors.joining(","));
            }
            String dataFieldValue = relationField;
            String dataJson = !ObjectUtil.equals((Object)templateJsonModel.getSourceType(), (Object)TemplateEnum.Custom.getCode()) ? dataValue : dataFieldValue;
            String[] stringArray = model = StringUtil.isNotEmpty((String)relationField) ? relationField.split("-") : new String[]{};
            if (model.length > 1 && (dataList = data.get(model[0])) instanceof List) {
                List listAll = (List)dataList;
                ArrayList dataListAll = new ArrayList();
                for (Map objectMap : listAll) {
                    dataListAll.add(objectMap.get(model[1]));
                }
                if (required.booleanValue() && ObjectUtil.isEmpty(dataListAll)) {
                    msg.add(fieldId);
                }
                dataJson = String.valueOf(dataListAll);
            }
            if (required.booleanValue() && ObjectUtil.isEmpty((Object)dataJson)) {
                msg.add(fieldId);
            }
            parameterMap.put(fieldId, dataJson);
        }
        this.errRequiredMsg(msg);
        ActionResult dataInterfaceInfo = this.dataInterfaceService.infoToId(interId, userInfo.getTenantId(), parameterMap, userInfo.getToken(), null, null, null, null);
        if (dataInterfaceInfo.getCode() != 200) {
            throw new WorkFlowException(dataInterfaceInfo.getMsg());
        }
        return dataInterfaceInfo;
    }

    private void errRequiredMsg(Set<String> msg) throws WorkFlowException {
        if (msg.size() > 0) {
            throw new WorkFlowException(String.valueOf(new ArrayList<String>(msg).get(0)) + MsgCode.VS015.get(new Object[0]));
        }
    }

    private void launchFlow(Map<String, Object> data, List<IntegrateNodeEntity> nodeList, String node, String retryNodeCode) throws WorkFlowException {
        IntegrateNodeEntity nodeEntity = nodeList.stream().filter(t -> t.getNodeCode().equals(node)).findFirst().orElse(null);
        if (nodeEntity != null) {
            List<IntegrateNodeEntity> list = this.nodeList(nodeEntity);
            boolean isRetry = nodeEntity.getNodeCode().equals(retryNodeCode);
            if (list.size() == 0 || isRetry) {
                nodeEntity.setStartTime(new Date());
                IntegrateChildNodeList childNodeList = (IntegrateChildNodeList)JsonUtil.getJsonToBean((String)nodeEntity.getNodePropertyJson(), IntegrateChildNodeList.class);
                IntegrateProperties properties = childNodeList.getProperties();
                String msg = "";
                try {
                    String flowId = properties.getFlowId();
                    FlowFormModel formIdAndFlowId = this.templateService.getFormIdAndFlowId(properties.getInitiator(), flowId);
                    List userList = formIdAndFlowId.getUserId();
                    List userName = this.userService.getUserName(userList, true);
                    if (userName.isEmpty()) {
                        throw new WorkFlowException(MsgCode.VS025.get(new Object[0]));
                    }
                    for (UserEntity entity : userName) {
                        UserInfo userInfo = new UserInfo();
                        userInfo.setUserId((String)entity.getId());
                        userInfo.setUserName(entity.getRealName());
                        List transferList = properties.getTransferList();
                        Map<String, Object> saveData = this.formData(data, transferList);
                        FlowModel flowModel = new FlowModel();
                        flowModel.setUserInfo(userInfo);
                        flowModel.setFlowId(flowId);
                        flowModel.setStatus(Integer.valueOf(1));
                        flowModel.setFormData(saveData);
                        this.taskService.saveOrSubmit(flowModel);
                    }
                    nodeEntity.setResultType(Integer.valueOf(1));
                }
                catch (Exception e) {
                    this.errMsg(nodeEntity, e);
                    msg = e.getMessage();
                }
                nodeEntity.setEndTime(new Date());
                if (isRetry) {
                    this.integrateNodeService.update(nodeEntity.getTaskId(), nodeEntity.getNodeCode());
                }
                this.integrateNodeService.create(nodeEntity);
                if (StringUtil.isNotEmpty((String)msg)) {
                    throw new WorkFlowException(msg);
                }
            }
        }
    }

    public void integrate(String id, String tenantId, Map<String, Object> body) throws WorkFlowException {
        IntegrateEntity entity = this.integrateService.getInfo(id);
        if (entity == null) {
            throw new WorkFlowException(MsgCode.VS016.get(new Object[0]));
        }
        if (Objects.equals(entity.getEnabledMark(), 0)) {
            throw new WorkFlowException(MsgCode.VS017.get(new Object[0]));
        }
        IntegrateChildNode childNode = (IntegrateChildNode)JsonUtil.getJsonToBean((String)entity.getTemplateJson(), IntegrateChildNode.class);
        IntegrateProperties properties = childNode.getProperties();
        List formFieldList = properties.getFormFieldList();
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (FieLdsModel fieLdsModel : formFieldList) {
            map.put(fieLdsModel.getId(), body.get(fieLdsModel.getId()));
        }
        dataList.add(map);
        String token = AuthUtil.loginTempUser((String)entity.getCreatorUserId(), (String)tenantId);
        UserInfo userInfo = UserProvider.getUser((String)token);
        UserProvider.setLocalLoginUser((UserInfo)userInfo);
        this.integrate((String)entity.getId(), dataList, userInfo);
    }
}

