/*
 * Decompiled with CFR 0.152.
 */
package jnpf.integrate.job;

import cn.hutool.core.util.ObjectUtil;
import jnpf.base.UserInfo;
import jnpf.integrate.model.nodeJson.IntegrateModel;
import jnpf.util.JsonUtil;
import jnpf.util.RedisUtil;
import jnpf.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrateJobUtil {
    private static final Logger log = LoggerFactory.getLogger(IntegrateJobUtil.class);
    public static final String WORKTIMEOUT_REDIS_KEY = "idgenerator_IntegrateList";
    public static final String IDGENERATOR_REDIS_KEY = "idgenerator_IntegrateModel";
    public static final String IDGENERATORID_REDIS_KEY = "idgenerator_id";

    public static IntegrateModel getModel(IntegrateModel model, RedisUtil redisUtil) {
        String id = model.getId();
        String hashValues = redisUtil.getHashValues(IDGENERATOR_REDIS_KEY, id);
        IntegrateModel integrateModel = StringUtil.isNotEmpty((String)hashValues) ? (IntegrateModel)JsonUtil.getJsonToBean((String)hashValues, IntegrateModel.class) : null;
        return integrateModel;
    }

    public static void insertModel(IntegrateModel model, RedisUtil redisUtil) {
        String integrateId = model.getId();
        redisUtil.insertHash(IDGENERATOR_REDIS_KEY, integrateId, JsonUtil.getObjectToString((Object)model));
        IntegrateJobUtil.insertTenant(model, redisUtil);
    }

    public static void removeModel(IntegrateModel model, RedisUtil redisUtil) {
        redisUtil.removeHash(IDGENERATOR_REDIS_KEY, model.getId());
    }

    public static void insertTenant(IntegrateModel model, RedisUtil redisUtil) {
        String tenantId = StringUtil.isNotEmpty((String)model.getUserInfo().getTenantId()) ? model.getUserInfo().getTenantId() : "jnpf";
        UserInfo userInfo = model.getUserInfo();
        redisUtil.insertHash(WORKTIMEOUT_REDIS_KEY, tenantId, JsonUtil.getObjectToString((Object)userInfo));
    }

    public static void removeTenant(String tenantId, RedisUtil redisUtil) {
        tenantId = StringUtil.isNotEmpty((String)tenantId) ? tenantId : "jnpf";
        redisUtil.removeHash(WORKTIMEOUT_REDIS_KEY, tenantId);
    }

    public static boolean getIntegrate(IntegrateModel model, RedisUtil redisUtil) {
        String value = redisUtil.getHashValues(IDGENERATORID_REDIS_KEY, model.getId());
        return ObjectUtil.isNotEmpty((Object)value);
    }

    public static void insertIntegrate(IntegrateModel model, RedisUtil redisUtil) {
        redisUtil.insertHash(IDGENERATORID_REDIS_KEY, model.getId(), model.getId());
    }

    public static void removeIntegrate(IntegrateModel model, RedisUtil redisUtil) {
        redisUtil.removeHash(IDGENERATORID_REDIS_KEY, model.getId());
    }
}

