/*
 * Decompiled with CFR 0.152.
 */
package jnpf.integrate.config;

import cn.hutool.core.util.ObjectUtil;
import java.util.Date;
import java.util.List;
import java.util.Set;
import jnpf.integrate.job.Integrate;
import jnpf.integrate.job.QuartzUtil;
import jnpf.integrate.model.nodeJson.IntegrateModel;
import jnpf.util.JsonUtil;
import jnpf.util.RedisUtil;
import org.quartz.JobDataMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class IntegrateListener
implements ApplicationRunner {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private RedisTemplate redisTemplate;

    public void run(ApplicationArguments args) throws Exception {
        Set keysList = this.redisTemplate.keys((Object)"idgenerator_IntegrateList_key*");
        for (String id : keysList) {
            this.redisTemplate.delete((Object)id);
        }
        List hashValues = this.redisUtil.getHashValues("idgenerator_IntegrateModel");
        for (String value : hashValues) {
            Date endTime;
            IntegrateModel integrateModel = (IntegrateModel)JsonUtil.getJsonToBean((String)value, IntegrateModel.class);
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.putAll(JsonUtil.entityToMap((Object)integrateModel));
            Date startTime = new Date(integrateModel.getStartTime());
            Date date = endTime = ObjectUtil.isNotEmpty((Object)integrateModel.getEndTime()) ? new Date(integrateModel.getEndTime()) : null;
            boolean bl = ObjectUtil.isNotEmpty((Object)endTime) ? endTime.getTime() > System.currentTimeMillis() : true;
            boolean isAdd = bl;
            if (!isAdd) continue;
            QuartzUtil.addJob(integrateModel.getId(), integrateModel.getCron(), Integrate.class, jobDataMap, startTime, endTime);
        }
    }
}

