/*
 * Decompiled with CFR 0.152.
 */
package jnpf.generater.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.dev33.satoken.annotation.SaMode;
import cn.xuyanwu.spring.file.storage.FileInfo;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import jnpf.base.ActionResult;
import jnpf.base.entity.DictionaryDataEntity;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.entity.VisualdevReleaseEntity;
import jnpf.base.model.DownloadCodeForm;
import jnpf.base.model.VisualAliasForm;
import jnpf.base.model.read.ReadListVO;
import jnpf.base.model.read.ReadModel;
import jnpf.base.service.DictionaryDataService;
import jnpf.base.service.VisualAliasService;
import jnpf.base.service.VisualdevReleaseService;
import jnpf.base.service.VisualdevService;
import jnpf.base.util.ReadFile;
import jnpf.base.util.VisualUtil;
import jnpf.base.vo.DownloadVO;
import jnpf.base.vo.ListVO;
import jnpf.config.ConfigValueUtil;
import jnpf.constant.MsgCode;
import jnpf.exception.DataException;
import jnpf.generater.service.VisualdevGenService;
import jnpf.util.DesUtil;
import jnpf.util.FileDownloadUtil;
import jnpf.util.FilePathUtil;
import jnpf.util.FileUploadUtils;
import jnpf.util.FileUtil;
import jnpf.util.JsonUtil;
import jnpf.util.NoDataSourceBind;
import jnpf.util.RandomUtil;
import jnpf.util.RedisUtil;
import jnpf.util.ServletUtil;
import jnpf.util.StringUtil;
import jnpf.util.TicketUtil;
import jnpf.util.UploaderUtil;
import jnpf.util.XSSEscape;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="\u4ee3\u7801\u751f\u6210\u5668", description="Generater")
@RestController
@RequestMapping(value={"/api/visualdev/Generater"})
public class VisualdevGenController {
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private VisualdevService visualdevService;
    @Autowired
    private VisualdevReleaseService visualdevReleaseService;
    @Autowired
    private VisualdevGenService visualdevGenService;
    @Autowired
    private DictionaryDataService dictionaryDataApi;
    @Autowired
    private VisualAliasService aliasService;

    @NoDataSourceBind
    @Operation(summary="\u4e0b\u8f7d\u6587\u4ef6")
    @GetMapping(value={"/DownloadVisCode"})
    public void downloadCode() throws DataException {
        String token;
        HttpServletRequest request = ServletUtil.getRequest();
        String reqJson = request.getParameter("encryption");
        String name = request.getParameter("name");
        String fileNameAll = DesUtil.aesDecode((String)reqJson);
        if (!StringUtil.isEmpty((String)fileNameAll)) {
            token = fileNameAll.split("#")[0];
            if (TicketUtil.parseTicket((String)token) == null) {
                throw new DataException(MsgCode.VS014.get(new Object[0]));
            }
        } else {
            throw new DataException(MsgCode.VS014.get(new Object[0]));
        }
        TicketUtil.deleteTicket((String)token);
        String fileName = fileNameAll.split("#")[1];
        String path = FilePathUtil.getFilePath((String)"codetemp");
        byte[] bytes = FileUploadUtils.downloadFileByte((String)path, (String)fileName, (boolean)false);
        FileDownloadUtil.downloadFile((byte[])bytes, (String)fileName, (String)name);
        FileUploadUtils.deleteFileByPathAndFileName((String)path, (String)fileName);
    }

    @Operation(summary="\u83b7\u53d6\u547d\u540d\u7a7a\u95f4")
    @GetMapping(value={"/AreasName"})
    @SaCheckPermission(value={"onlineDev.webDesign", "generator.webForm", "generator.flowForm"}, mode=SaMode.OR)
    public ActionResult getAreasName() {
        String areasName = this.configValueUtil.getCodeAreasName();
        ArrayList<String> areasNameList = new ArrayList<String>(Arrays.asList(areasName.split(",")));
        return ActionResult.success(areasNameList);
    }

    @Operation(summary="\u4e0b\u8f7d\u4ee3\u7801")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @PostMapping(value={"/{id}/Actions/DownloadCode"})
    @SaCheckPermission(value={"onlineDev.webDesign", "generator.webForm", "generator.flowForm"}, mode=SaMode.OR)
    @DSTransactional
    public ActionResult downloadCode(@PathVariable(value="id") String id, @RequestBody DownloadCodeForm downloadCodeForm) throws Exception {
        VisualdevEntity visualdevEntity;
        String s;
        DictionaryDataEntity info;
        if (downloadCodeForm.getModule() != null && (info = this.dictionaryDataApi.getInfo(downloadCodeForm.getModule())) != null) {
            downloadCodeForm.setModule(info.getEnCode());
        }
        if ((s = VisualUtil.checkPublishVisualModel((VisualdevEntity)(visualdevEntity = (VisualdevEntity)JsonUtil.getJsonToBean((Object)this.visualdevReleaseService.getById((Serializable)((Object)id)), VisualdevEntity.class)), (String)MsgCode.VS006.get(new Object[0]))) != null) {
            return ActionResult.fail((String)s);
        }
        String fileName = this.visualdevGenService.codeGengerateV3(visualdevEntity, downloadCodeForm);
        String filePath = FileUploadUtils.getLocalBasePath() + this.configValueUtil.getServiceDirectoryPath() + fileName + ".zip";
        FileUtil.toZip((String)filePath, (boolean)true, (String[])new String[]{FileUploadUtils.getLocalBasePath() + this.configValueUtil.getServiceDirectoryPath() + fileName});
        FileUtil.deleteFileAll((File)new File(FileUploadUtils.getLocalBasePath() + this.configValueUtil.getServiceDirectoryPath() + fileName));
        MultipartFile multipartFile = FileUtil.createFileItem((File)new File(XSSEscape.escapePath((String)filePath)));
        FileInfo fileInfo = FileUploadUtils.uploadFile((MultipartFile)multipartFile, (String)this.configValueUtil.getServiceDirectoryPath(), (String)(fileName + ".zip"));
        FileUtil.deleteFileAll((File)new File(filePath));
        DownloadVO vo = DownloadVO.builder().name(fileInfo.getFilename()).url(UploaderUtil.uploaderVisualFile((String)fileInfo.getFilename()) + "&name=" + fileName + ".zip").build();
        if (vo == null) {
            return ActionResult.fail((String)MsgCode.FA006.get(new Object[0]));
        }
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u9884\u89c8\u4ee3\u7801")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @PostMapping(value={"/{id}/Actions/CodePreview"})
    @SaCheckPermission(value={"onlineDev.webDesign", "generator.webForm", "generator.flowForm"}, mode=SaMode.OR)
    public ActionResult codePreview(@PathVariable(value="id") String id, @RequestBody DownloadCodeForm downloadCodeForm) throws Exception {
        VisualdevReleaseEntity releaseEntity;
        VisualdevEntity visualdevEntity;
        String s;
        DictionaryDataEntity info;
        if (downloadCodeForm.getModule() != null && (info = this.dictionaryDataApi.getInfo(downloadCodeForm.getModule())) != null) {
            downloadCodeForm.setModule(info.getEnCode());
        }
        if ((s = VisualUtil.checkPublishVisualModel((VisualdevEntity)(visualdevEntity = (VisualdevEntity)JsonUtil.getJsonToBean((Object)(releaseEntity = (VisualdevReleaseEntity)this.visualdevReleaseService.getById((Serializable)((Object)id))), VisualdevEntity.class)), (String)"\u9884\u89c8")) != null) {
            return ActionResult.fail((String)s);
        }
        String fileName = this.visualdevGenService.codeGengerateV3(visualdevEntity, downloadCodeForm);
        List dataList = ReadFile.priviewCode((String)(FileUploadUtils.getLocalBasePath() + this.configValueUtil.getServiceDirectoryPath() + fileName));
        FileUtil.deleteFileAll((File)new File(FileUploadUtils.getLocalBasePath() + this.configValueUtil.getServiceDirectoryPath() + fileName));
        if (dataList.size() == 0) {
            return ActionResult.fail((String)MsgCode.FA015.get(new Object[0]));
        }
        if (downloadCodeForm.isContrast()) {
            VisualdevEntity oldEntity = this.visualdevService.getInfo(id);
            boolean statusUpdate = true;
            if (Objects.equals(oldEntity.getState(), 1) && StringUtil.isNotBlank((CharSequence)releaseEntity.getOldContent())) {
                statusUpdate = false;
                VisualdevEntity jsonToBean = (VisualdevEntity)JsonUtil.getJsonToBean((String)releaseEntity.getOldContent(), VisualdevEntity.class);
                oldEntity.setVisualTables(jsonToBean.getVisualTables());
                oldEntity.setFormData(jsonToBean.getFormData());
                oldEntity.setColumnData(jsonToBean.getColumnData());
                oldEntity.setAppColumnData(jsonToBean.getAppColumnData());
                oldEntity.setWebType(jsonToBean.getWebType());
                oldEntity.setDbLinkId(jsonToBean.getDbLinkId());
            }
            String oldFileName = this.visualdevGenService.codeGengerateV3(oldEntity, downloadCodeForm);
            List oldDataList = ReadFile.priviewCode((String)(FileUploadUtils.getLocalBasePath() + this.configValueUtil.getServiceDirectoryPath() + oldFileName));
            FileUtil.deleteFileAll((File)new File(FileUploadUtils.getLocalBasePath() + this.configValueUtil.getServiceDirectoryPath() + oldFileName));
            for (ReadListVO m : dataList) {
                ReadListVO n = oldDataList.stream().filter(t -> m.getFileName().equals(t.getFileName())).findFirst().orElse(null);
                if (!Objects.nonNull(n)) continue;
                List mChildren = m.getChildren();
                List nChildren = n.getChildren();
                for (ReadModel mChild : mChildren) {
                    String nfileContent;
                    ReadModel nChild = nChildren.stream().filter(t -> mChild.getFileName().equals(t.getFileName())).findFirst().orElse(null);
                    String string = nfileContent = Objects.nonNull(nChild) ? nChild.getFileContent() : "";
                    if (statusUpdate) {
                        mChild.setOldFileContent(mChild.getFileContent());
                        mChild.setFileContent(nfileContent);
                        continue;
                    }
                    mChild.setOldFileContent(nfileContent);
                }
            }
        }
        ListVO datas = new ListVO();
        datas.setList(dataList);
        return ActionResult.success((Object)datas);
    }

    @Operation(summary="App\u9884\u89c8(\u540e\u53f0APP\u8868\u5355\u8bbe\u8ba1)")
    @Parameters(value={@Parameter(name="data", description="\u6570\u636e")})
    @PostMapping(value={"/App/Preview"})
    @SaCheckPermission(value={"onlineDev.webDesign", "generator.webForm", "generator.flowForm"}, mode=SaMode.OR)
    public ActionResult appPreview(String data) {
        String id = RandomUtil.uuId();
        this.redisUtil.insert(id, (Object)data, 300L);
        return ActionResult.success((Object)id);
    }

    @Operation(summary="App\u9884\u89c8\u67e5\u770b")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @GetMapping(value={"/App/{id}/Preview"})
    @SaCheckPermission(value={"onlineDev.webDesign", "generator.webForm", "generator.flowForm"}, mode=SaMode.OR)
    public ActionResult preview(@PathVariable(value="id") String id) {
        if (this.redisUtil.exists(id)) {
            Object object = this.redisUtil.getString(id);
            return ActionResult.success((Object)object);
        }
        return ActionResult.fail((String)MsgCode.FA019.get(new Object[0]));
    }

    @Operation(summary="\u83b7\u53d6\u547d\u540d\u89c4\u8303")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @GetMapping(value={"/{id}/Alias/Info"})
    @SaCheckPermission(value={"onlineDev.webDesign", "generator.webForm", "generator.flowForm"}, mode=SaMode.OR)
    public ActionResult getAliasInfo(@PathVariable(value="id") String id) {
        List aliasInfo = this.aliasService.getAliasInfo(id);
        return ActionResult.success((Object)aliasInfo);
    }

    @Operation(summary="\u547d\u540d\u89c4\u8303\u4fdd\u5b58")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @PostMapping(value={"/{id}/Alias/Save"})
    @SaCheckPermission(value={"onlineDev.webDesign", "generator.webForm", "generator.flowForm"}, mode=SaMode.OR)
    public ActionResult aliasSave(@PathVariable(value="id") String id, @RequestBody VisualAliasForm form) {
        this.aliasService.aliasSave(id, form);
        return ActionResult.success((String)MsgCode.SU002.get(new Object[0]));
    }
}

