/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import com.alibaba.fastjson.JSONObject;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jnpf.base.ActionResult;
import jnpf.base.UserInfo;
import jnpf.base.controller.SuperController;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.entity.VisualdevReleaseEntity;
import jnpf.base.entity.VisualdevShortLinkEntity;
import jnpf.base.model.ColumnDataModel;
import jnpf.base.model.OnlineImport.VisualdevModelDataInfoVO;
import jnpf.base.model.VisualDevJsonModel;
import jnpf.base.model.VisualWebTypeEnum;
import jnpf.base.model.shortLink.VisualdevShortLinkConfigVo;
import jnpf.base.model.shortLink.VisualdevShortLinkForm;
import jnpf.base.model.shortLink.VisualdevShortLinkModel;
import jnpf.base.model.shortLink.VisualdevShortLinkPwd;
import jnpf.base.model.shortLink.VisualdevShortLinkVo;
import jnpf.base.service.VisualdevReleaseService;
import jnpf.base.service.VisualdevService;
import jnpf.base.service.VisualdevShortLinkService;
import jnpf.base.util.VisualUtil;
import jnpf.base.vo.PaginationVO;
import jnpf.config.ConfigValueUtil;
import jnpf.constant.MsgCode;
import jnpf.consts.DeviceType;
import jnpf.database.util.TenantDataSourceUtil;
import jnpf.exception.DataException;
import jnpf.exception.LoginException;
import jnpf.exception.WorkFlowException;
import jnpf.model.OnlineDevData;
import jnpf.onlinedev.model.DataInfoVO;
import jnpf.onlinedev.model.PaginationModel;
import jnpf.onlinedev.model.VisualdevModelDataCrForm;
import jnpf.onlinedev.service.VisualDevInfoService;
import jnpf.onlinedev.service.VisualDevListService;
import jnpf.onlinedev.service.VisualdevModelDataService;
import jnpf.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import jnpf.onlinedev.util.onlineDevUtil.OnlineSwapDataUtils;
import jnpf.util.AuthUtil;
import jnpf.util.DesUtil;
import jnpf.util.JsonUtil;
import jnpf.util.Md5Util;
import jnpf.util.NoDataSourceBind;
import jnpf.util.StringUtil;
import jnpf.util.UserProvider;
import jnpf.util.XSSEscape;
import jnpf.util.context.RequestContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u8868\u5355\u5916\u94fe", description="BaseShortLink")
@RestController
@RequestMapping(value={"/api/visualdev/ShortLink"})
public class VisualdevShortLinkController
extends SuperController<VisualdevShortLinkService, VisualdevShortLinkEntity> {
    @Autowired
    private VisualdevShortLinkService visualdevShortLinkService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    protected AuthUtil authUtil;
    @Autowired
    private VisualdevService visualdevService;
    @Autowired
    private VisualdevReleaseService visualdevReleaseService;
    @Autowired
    private VisualdevModelDataService visualdevModelDataService;
    @Autowired
    private OnlineSwapDataUtils onlineSwapDataUtils;
    @Autowired
    private VisualDevListService visualDevListService;
    @Autowired
    private VisualDevInfoService visualDevInfoService;

    @Operation(summary="\u83b7\u53d6\u5916\u94fe\u4fe1\u606f")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @GetMapping(value={"/{id}"})
    @SaCheckPermission(value={"onlineDev.webDesign"})
    public ActionResult getInfo(@PathVariable(value="id") String id) {
        VisualdevShortLinkVo vo;
        VisualdevShortLinkEntity info = (VisualdevShortLinkEntity)this.visualdevShortLinkService.getById((Serializable)((Object)id));
        if (info != null) {
            vo = (VisualdevShortLinkVo)JsonUtil.getJsonToBean((Object)info, VisualdevShortLinkVo.class);
            vo.setAlreadySave(true);
        } else {
            vo = new VisualdevShortLinkVo();
            vo.setId(id);
        }
        vo.setFormLink(this.geturl(id, "form"));
        vo.setColumnLink(this.geturl(id, "list"));
        return ActionResult.success((Object)vo);
    }

    private String geturl(String id, String type) {
        String url = this.configValueUtil.getApiDomain() + "/api/visualdev/ShortLink/trigger/" + id + "?encryption=";
        UserInfo userInfo = UserProvider.getUser();
        JSONObject obj = new JSONObject();
        obj.put("type", (Object)type);
        if (this.configValueUtil.isMultiTenancy()) {
            obj.put("tenantId", (Object)userInfo.getTenantId());
        }
        String encryption = DesUtil.aesOrDecode((String)obj.toJSONString(), (boolean)true, (boolean)true);
        url = url + encryption;
        return url;
    }

    @Operation(summary="\u4fee\u6539\u5916\u94fe\u4fe1\u606f")
    @PutMapping(value={""})
    @SaCheckPermission(value={"onlineDev.webDesign"})
    public ActionResult saveOrupdate(@RequestBody VisualdevShortLinkForm data) {
        VisualdevShortLinkEntity entity = (VisualdevShortLinkEntity)JsonUtil.getJsonToBean((Object)data, VisualdevShortLinkEntity.class);
        if (entity.getFormLink().contains(this.configValueUtil.getApiDomain())) {
            entity.setFormLink(entity.getFormLink().replace(this.configValueUtil.getApiDomain(), ""));
        }
        if (entity.getColumnLink().contains(this.configValueUtil.getApiDomain())) {
            entity.setColumnLink(entity.getColumnLink().replace(this.configValueUtil.getApiDomain(), ""));
        }
        VisualdevShortLinkEntity info = (VisualdevShortLinkEntity)this.visualdevShortLinkService.getById((Serializable)((Object)data.getId()));
        UserInfo userInfo = UserProvider.getUser();
        if (info != null) {
            entity.setLastModifyTime(new Date());
            entity.setLastModifyUserId(userInfo.getUserId());
        } else {
            entity.setCreatorTime(new Date());
            entity.setCreatorUserId(userInfo.getUserId());
        }
        String pcLink = "/formShortLink";
        String appLink = "/pages/formShortLink/index";
        entity.setRealPcLink(pcLink);
        entity.setRealAppLink(appLink);
        entity.setUserId(userInfo.getUserId());
        this.visualdevShortLinkService.saveOrUpdate((Object)entity);
        return ActionResult.success((String)MsgCode.SU002.get(new Object[0]));
    }

    private VisualdevShortLinkModel aesDecodeMatchDatabase(String encryption) throws LoginException {
        String str = DesUtil.aesOrDecode((String)encryption, (boolean)false, (boolean)true);
        if (StringUtil.isEmpty((String)str)) {
            throw new LoginException(MsgCode.VS009.get(new Object[0]));
        }
        VisualdevShortLinkModel model = (VisualdevShortLinkModel)JsonUtil.getJsonToBean((String)str, VisualdevShortLinkModel.class);
        if (this.configValueUtil.isMultiTenancy()) {
            if (StringUtil.isNotEmpty((String)model.getTenantId())) {
                TenantDataSourceUtil.switchTenant((String)model.getTenantId());
            } else {
                throw new LoginException(MsgCode.LOG115.get(new Object[0]));
            }
        }
        return model;
    }

    @NoDataSourceBind
    @Operation(summary="\u5916\u94fe\u8bf7\u6c42\u5165\u53e3")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @GetMapping(value={"/trigger/{id}"})
    public ActionResult getlink(@PathVariable(value="id") String id, @RequestParam(value="encryption") String encryption, HttpServletResponse response) throws LoginException, IOException {
        VisualdevShortLinkModel model = this.aesDecodeMatchDatabase(encryption);
        Object link = "";
        VisualdevShortLinkEntity entity = (VisualdevShortLinkEntity)this.visualdevShortLinkService.getById((Serializable)((Object)id));
        DeviceType deviceType = UserProvider.getDeviceForAgent();
        if (entity != null) {
            link = DeviceType.PC.equals((Object)deviceType) ? this.configValueUtil.getFrontDomain() + entity.getRealPcLink() : this.configValueUtil.getAppDomain() + entity.getRealAppLink();
        } else {
            return ActionResult.fail((String)MsgCode.VS010.get(new Object[0]));
        }
        JSONObject obj = new JSONObject();
        obj.put("modelId", (Object)id);
        obj.put("type", (Object)model.getType());
        if (this.configValueUtil.isMultiTenancy()) {
            obj.put("tenantId", (Object)model.getTenantId());
        }
        String encryptionNew = DesUtil.aesOrDecode((String)obj.toJSONString(), (boolean)true, (boolean)true);
        link = (String)link + "?encryption=" + encryptionNew;
        response.sendRedirect((String)link);
        return ActionResult.success((String)MsgCode.SU000.get(new Object[0]));
    }

    @NoDataSourceBind
    @Operation(summary="\u83b7\u53d6\u5916\u94fe\u914d\u7f6e")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @GetMapping(value={"/getConfig/{id}"})
    public ActionResult getConfig(@PathVariable(value="id") String id, @RequestParam(value="encryption") String encryption) throws LoginException {
        this.aesDecodeMatchDatabase(encryption);
        VisualdevShortLinkEntity info = (VisualdevShortLinkEntity)this.visualdevShortLinkService.getById((Serializable)((Object)id));
        VisualdevShortLinkConfigVo vo = (VisualdevShortLinkConfigVo)JsonUtil.getJsonToBean((Object)info, VisualdevShortLinkConfigVo.class);
        vo.setFormLink(this.geturl(id, "form"));
        vo.setColumnLink(this.geturl(id, "list"));
        return ActionResult.success((Object)vo);
    }

    @NoDataSourceBind
    @Operation(summary="\u5bc6\u7801\u9a8c\u8bc1")
    @PostMapping(value={"/checkPwd"})
    public ActionResult checkPwd(@RequestBody VisualdevShortLinkPwd form) throws LoginException {
        VisualdevShortLinkModel model = this.aesDecodeMatchDatabase(form.getEncryption());
        VisualdevShortLinkEntity info = (VisualdevShortLinkEntity)this.visualdevShortLinkService.getById((Serializable)((Object)form.getId()));
        boolean flag = false;
        if (OnlineDevData.STATE_ENABLE.equals(info.getFormPassUse()) && 0 == form.getType()) {
            if (Md5Util.getStringMd5((String)info.getFormPassword()).equals(form.getPassword())) {
                flag = true;
            }
        } else if (OnlineDevData.STATE_ENABLE.equals(info.getColumnPassUse()) && 1 == form.getType() && Md5Util.getStringMd5((String)info.getColumnPassword()).equals(form.getPassword())) {
            flag = true;
        }
        if (flag) {
            return ActionResult.success();
        }
        return ActionResult.fail((String)MsgCode.VS011.get(new Object[0]));
    }

    @NoDataSourceBind
    @Operation(summary="\u83b7\u53d6\u5217\u8868\u8868\u5355\u914d\u7f6eJSON")
    @GetMapping(value={"/{modelId}/Config"})
    public ActionResult getData(@PathVariable(value="modelId") String modelId, @RequestParam(value="type", required=false) String type, @RequestParam(value="encryption") String encryption) throws WorkFlowException, LoginException {
        VisualdevEntity entity;
        this.aesDecodeMatchDatabase(encryption);
        if ("0".equals(type)) {
            entity = this.visualdevService.getInfo(modelId);
        } else {
            VisualdevReleaseEntity releaseEntity = (VisualdevReleaseEntity)this.visualdevReleaseService.getById((Serializable)((Object)modelId));
            entity = (VisualdevEntity)JsonUtil.getJsonToBean((Object)releaseEntity, VisualdevEntity.class);
        }
        if (entity == null) {
            return ActionResult.fail((String)MsgCode.VS012.get(new Object[0]));
        }
        String s = VisualUtil.checkPublishVisualModel((VisualdevEntity)entity, (String)MsgCode.VS005.get(new Object[0]));
        if (s != null) {
            return ActionResult.fail((String)s);
        }
        DataInfoVO vo = (DataInfoVO)JsonUtil.getJsonToBean((Object)entity, DataInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @NoDataSourceBind
    @Operation(summary="\u5916\u94fe\u6570\u636e\u5217\u8868")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid")})
    @PostMapping(value={"/{modelId}/ListLink"})
    public ActionResult ListLink(@PathVariable(value="modelId") String modelId, @RequestParam(value="encryption") String encryption, @RequestBody PaginationModel paginationModel) throws WorkFlowException, LoginException {
        List realList;
        this.aesDecodeMatchDatabase(encryption);
        VisualdevReleaseEntity visualdevEntity = (VisualdevReleaseEntity)this.visualdevReleaseService.getById((Serializable)((Object)modelId));
        VisualDevJsonModel visualJsonModel = OnlinePublicUtils.getVisualJsonModel((VisualdevReleaseEntity)visualdevEntity);
        if (!RequestContext.isOrignPc()) {
            visualJsonModel.setColumnData(visualJsonModel.getAppColumnData());
        }
        if (VisualWebTypeEnum.DATA_VIEW.getType().equals(visualdevEntity.getWebType())) {
            ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getColumnData(), ColumnDataModel.class);
            realList = this.onlineSwapDataUtils.getInterfaceData(visualdevEntity, paginationModel, columnDataModel);
        } else {
            realList = this.visualDevListService.getDataListLink(visualJsonModel, paginationModel);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)paginationModel, PaginationVO.class);
        return ActionResult.page((List)realList, (PaginationVO)paginationVO);
    }

    @NoDataSourceBind
    @Operation(summary="\u83b7\u53d6\u6570\u636e\u4fe1\u606f(\u5e26\u8f6c\u6362\u6570\u636e)")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid"), @Parameter(name="id", description="\u6570\u636eid")})
    @GetMapping(value={"/{modelId}/{id}/DataChange"})
    public ActionResult infoWithDataChange(@PathVariable(value="modelId") String modelId, @PathVariable(value="id") String id, @RequestParam(value="encryption") String encryption) throws DataException, ParseException, IOException, SQLException, LoginException {
        this.aesDecodeMatchDatabase(encryption);
        modelId = XSSEscape.escape((String)modelId);
        id = XSSEscape.escape((String)id);
        VisualdevEntity visualdevEntity = this.visualdevService.getReleaseInfo(modelId);
        if (!StringUtil.isEmpty((String)visualdevEntity.getVisualTables()) && !"[]".equals(visualdevEntity.getVisualTables())) {
            VisualdevModelDataInfoVO vo = this.visualDevInfoService.getDetailsDataInfo(id, visualdevEntity);
            return ActionResult.success((Object)vo);
        }
        VisualdevModelDataInfoVO vo = this.visualdevModelDataService.infoDataChange(id, visualdevEntity);
        return ActionResult.success((Object)vo);
    }

    @NoDataSourceBind
    @Operation(summary="\u6dfb\u52a0\u6570\u636e")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid"), @Parameter(name="visualdevModelDataCrForm", description="\u529f\u80fd\u6570\u636e\u521b\u5efa\u8868\u5355")})
    @PostMapping(value={"/{modelId}"})
    public ActionResult create(@PathVariable(value="modelId") String modelId, @RequestParam(value="encryption") String encryption, @RequestBody VisualdevModelDataCrForm visualdevModelDataCrForm) throws WorkFlowException, LoginException {
        VisualdevShortLinkModel visualdevShortLinkModel = this.aesDecodeMatchDatabase(encryption);
        VisualdevShortLinkEntity info = (VisualdevShortLinkEntity)this.visualdevShortLinkService.getById((Serializable)((Object)modelId));
        if (1 != info.getFormUse()) {
            return ActionResult.fail((String)MsgCode.VS013.get(new Object[0]));
        }
        String tenantId = visualdevShortLinkModel.getTenantId();
        try {
            if (this.configValueUtil.isMultiTenancy()) {
                if (StringUtil.isNotEmpty((String)tenantId)) {
                    TenantDataSourceUtil.switchTenant((String)tenantId);
                } else {
                    return ActionResult.fail((String)MsgCode.LOG115.get(new Object[0]));
                }
            }
            VisualdevEntity visualdevEntity = this.visualdevService.getReleaseInfo(modelId);
            Map map = JsonUtil.stringToMap((String)visualdevModelDataCrForm.getData());
            this.visualdevModelDataService.visualCreate(visualdevEntity, map, true);
        }
        catch (Exception e) {
            throw new WorkFlowException(e.getMessage(), (Throwable)e);
        }
        return ActionResult.success((String)MsgCode.SU001.get(new Object[0]));
    }
}

