/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.util.fuctionFormVue3;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.model.ColumnDataModel;
import jnpf.base.model.DownloadCodeForm;
import jnpf.base.model.Template6.BtnData;
import jnpf.base.model.Template6.ColumnListField;
import jnpf.base.model.Template7.Template7Model;
import jnpf.base.util.common.DataControlUtils;
import jnpf.base.util.common.GenerateCommon;
import jnpf.base.util.common.GenerateInterface;
import jnpf.base.util.common.GenerateParamModel;
import jnpf.base.util.common.SuperQueryUtil;
import jnpf.generater.model.FormDesign.SearchTypeModel;
import jnpf.model.visualJson.config.HeaderModel;
import jnpf.util.JsonUtil;
import jnpf.util.XSSEscape;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.velocity.VelocityContext;

public class GenerateDataView
implements GenerateInterface {
    @Override
    public List<String> getTemplates(String templatePath, int type, boolean hasImport) {
        ArrayList<String> templates = new ArrayList<String>();
        templates.add(templatePath + File.separator + "index.vue.vm");
        templates.add(File.separator + "helper" + File.separator + "api.ts.vm");
        if (hasImport) {
            templates.add(File.separator + "java" + File.separator + "ExcelVO.java.vm");
            templates.add(File.separator + "java" + File.separator + "ExcelErrorVO.java.vm");
        }
        templates.add(File.separator + "java" + File.separator + "Pagination.java.vm");
        templates.add(File.separator + "java" + File.separator + "Constant.java.vm");
        return templates;
    }

    @Override
    public List<String> getChildTemps(boolean isChild) {
        return null;
    }

    public void generateDataView(GenerateParamModel generateParamModel) throws Exception {
        VisualdevEntity entity = generateParamModel.getEntity();
        DownloadCodeForm downloadCodeForm = generateParamModel.getDownloadCodeForm();
        String fileName = generateParamModel.getFileName();
        Template7Model template7Model = generateParamModel.getTemplate7Model();
        template7Model.setDescription(downloadCodeForm.getDescription());
        template7Model.setClassName(generateParamModel.getClassName());
        String templatesPath = generateParamModel.getTemplatesPath();
        String modelPathName = generateParamModel.getClassName().toLowerCase();
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)entity.getColumnData(), ColumnDataModel.class);
        ColumnDataModel appColumnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)entity.getAppColumnData(), ColumnDataModel.class);
        List btnPcList = JsonUtil.getJsonToList((Object)columnDataModel.getBtnsList(), BtnData.class);
        List columnBtnPcList = JsonUtil.getJsonToList((Object)columnDataModel.getColumnBtnsList(), BtnData.class);
        List btnAppList = JsonUtil.getJsonToList((Object)appColumnDataModel.getBtnsList(), BtnData.class);
        List columnBtnAppList = JsonUtil.getJsonToList((Object)appColumnDataModel.getColumnBtnsList(), BtnData.class);
        ArrayList btnDataList = new ArrayList(btnPcList);
        List collect3 = btnPcList.stream().map(BtnData::getValue).collect(Collectors.toList());
        btnDataList.addAll(btnAppList.stream().filter(t -> !collect3.contains(t.getValue())).collect(Collectors.toList()));
        boolean hasDownloadBtn = btnDataList.stream().anyMatch(btn -> btn.getValue().equals("download"));
        List columnList = JsonUtil.getJsonToList((String)columnDataModel.getColumnList(), ColumnListField.class);
        List searchList = JsonUtil.getJsonToList((String)columnDataModel.getSearchList(), SearchTypeModel.class);
        List columnAppList = JsonUtil.getJsonToList((String)appColumnDataModel.getColumnList(), ColumnListField.class);
        List searchAppList = JsonUtil.getJsonToList((String)appColumnDataModel.getSearchList(), SearchTypeModel.class);
        ArrayList searchListAll = new ArrayList(searchList);
        List cSaArr = searchListAll.stream().map(SearchTypeModel::getId).collect(Collectors.toList());
        searchAppList.stream().forEach(t -> {
            if (!cSaArr.contains(t.getId())) {
                searchListAll.add(t);
                cSaArr.add(t.getId());
            }
        });
        searchListAll.stream().forEach(t -> t.setAfterVModel(t.getId()));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isCloud", "single");
        map.put("isMain", true);
        map.put("package", downloadCodeForm.getModulePackageName());
        map.put("module", downloadCodeForm.getModule());
        map.put("moduleId", entity.getId());
        map.put("className", DataControlUtils.captureName(generateParamModel.getClassName()));
        map.put("genInfo", generateParamModel.getTemplate7Model());
        map.put("hasDownloadBtn", hasDownloadBtn);
        map.put("isList", true);
        map.put("webType", 4);
        map.put("hasPage", columnDataModel.getHasPage());
        map.put("groupTable", columnDataModel.getType() == 3);
        map.put("groupField", columnDataModel.getGroupField());
        map.put("interfaceId", entity.getInterfaceId());
        map.put("interfaceParam", JSONObject.toJSONString((Object)entity.getInterfaceParam()));
        map.put("columnDataStr", JSONObject.toJSONString((Object)GenerateCommon.objRemoveJson(entity.getColumnData())));
        map.put("appColumnDataStr", JSONObject.toJSONString((Object)GenerateCommon.objRemoveJson(entity.getAppColumnData())));
        map.put("columnData", JsonUtil.stringToMap((String)entity.getColumnData()));
        map.put("btnPcList", btnPcList);
        map.put("searchListAll", searchListAll);
        map.put("configurationTotal", columnDataModel.isShowSummary());
        List summaryList = CollectionUtils.isEmpty((Collection)columnDataModel.getSummaryField()) ? Collections.EMPTY_LIST : columnDataModel.getSummaryField();
        map.put("fieldsTotal", JsonUtil.getObjectToString((Object)summaryList));
        ArrayList complexFieldList = new ArrayList();
        ArrayList<Map> complexHeaderList = new ArrayList<Map>();
        if (!Objects.equals(columnDataModel.getType(), 3) && !Objects.equals(columnDataModel.getType(), 5)) {
            for (HeaderModel headerModel : columnDataModel.getComplexHeaderList()) {
                complexFieldList.addAll(headerModel.getChildColumns());
                complexHeaderList.add(JsonUtil.entityToMap((Object)headerModel));
            }
        }
        map.put("complexHeaderList", JsonUtil.getListToJsonArray(complexHeaderList));
        map.put("complexFieldList", JsonUtil.getListToJsonArray(complexFieldList));
        Map columnDataJson = JsonUtil.stringToMap((String)entity.getColumnData());
        String zipName = template7Model.getServiceDirectory() + fileName;
        String htmlTSPath = XSSEscape.escapePath((String)(zipName + File.separator + "html" + File.separator + "web" + File.separator + modelPathName + File.separator + "helper"));
        File htmlJSfile = new File(htmlTSPath);
        if (!htmlJSfile.exists()) {
            htmlJSfile.mkdirs();
        }
        String colData = JSONObject.toJSONString(columnDataJson.get("columnList"), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        String colListJsPath = htmlTSPath + File.separator + "columnList.ts";
        SuperQueryUtil.CreateJsFile(colData, colListJsPath, "columnList");
        String searchData = JSONObject.toJSONString(columnDataJson.get("searchList"), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        String searchListJsPath = htmlTSPath + File.separator + "searchList.ts";
        SuperQueryUtil.CreateJsFile(searchData, searchListJsPath, "searchList");
        GenerateDataView.genControllerFile(template7Model.getServiceDirectory() + fileName, map, templatesPath, downloadCodeForm);
        GenerateCommon.createComplexHeaderExcelVo(zipName, generateParamModel, entity, downloadCodeForm, map);
        GenerateCommon.htmlTemplates(template7Model.getServiceDirectory() + fileName, map, templatesPath, 1, false, downloadCodeForm, this);
    }

    public static void genControllerFile(String path, Map<String, Object> object, String templatePath, DownloadCodeForm downloadCodeForm) throws Exception {
        String controllerTem = templatePath + File.separator + "ViewController.java.vm";
        VelocityContext context = new VelocityContext();
        context.put("context", object);
        String className = object.get("className").toString();
        String controllerDir = path + File.separator + "java" + File.separator + GenerateCommon.getCloudPath("-controller", downloadCodeForm) + File.separator + "controller";
        File controllerSrc = new File(controllerDir);
        if (!controllerSrc.exists()) {
            controllerSrc.mkdirs();
        }
        String fileNames = controllerDir + File.separator + className + "Controller.java";
        GenerateCommon.velocityWriterFile(context, controllerTem, fileNames);
    }
}

