/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.util.custom;

import com.baomidou.mybatisplus.generator.config.ConstVal;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class CustomTemplateEngine
extends AbstractTemplateEngine {
    private static final String DOT_VM = ".vm";
    private VelocityEngine velocityEngine;
    private Map<String, Object> customParams;
    private String path;

    public CustomTemplateEngine(String path) {
        this.path = path;
    }

    public CustomTemplateEngine(Map<String, Object> customParams, String path) {
        this.customParams = customParams;
        this.path = path;
    }

    public CustomTemplateEngine init(ConfigBuilder configBuilder) {
        super.setConfigBuilder(configBuilder);
        if (null == this.velocityEngine) {
            Properties p = new Properties();
            p.setProperty("resource.loader.file.path", this.path);
            p.setProperty("ISO-8859-1", "UTF-8");
            p.setProperty("output.encoding", "UTF-8");
            this.velocityEngine = new VelocityEngine(p);
        }
        return this;
    }

    public void writer(Map<String, Object> objectMap, String templatePath, File outputFile) throws Exception {
        if (templatePath != null && !"".equals(templatePath.trim())) {
            Template template = this.velocityEngine.getTemplate(templatePath, ConstVal.UTF8);
            FileOutputStream fos = new FileOutputStream(outputFile);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, ConstVal.UTF8));
            if (this.customParams != null) {
                objectMap.putAll(this.customParams);
            }
            template.merge((Context)new VelocityContext(objectMap), (Writer)writer);
            writer.close();
        }
    }

    public String templateFilePath(String filePath) {
        if (null != filePath && !filePath.contains(DOT_VM)) {
            StringBuilder fp = new StringBuilder();
            fp.append(filePath).append(DOT_VM);
            return fp.toString();
        }
        return filePath;
    }
}

