/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.util.common;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.builder.CustomFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import jnpf.base.entity.SysConfigEntity;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.model.ColumnDataModel;
import jnpf.base.model.DownloadCodeForm;
import jnpf.base.model.Template6.ColumnListField;
import jnpf.base.model.Template7.Template7Model;
import jnpf.base.model.print.PrintOption;
import jnpf.base.service.PrintDevService;
import jnpf.base.util.common.GenerateInterface;
import jnpf.base.util.common.GenerateParamModel;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.TemplateJsonModel;
import jnpf.model.visualJson.analysis.FormAllModel;
import jnpf.model.visualJson.analysis.FormColumnModel;
import jnpf.model.visualJson.analysis.FormEnum;
import jnpf.model.visualJson.config.HeaderModel;
import jnpf.util.DateUtil;
import jnpf.util.FilePathUtil;
import jnpf.util.FileUploadUtils;
import jnpf.util.JsonUtil;
import jnpf.util.StringUtil;
import jnpf.util.XSSEscape;
import jnpf.util.context.SpringContext;
import jnpf.util.visiual.JnpfKeyConsts;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class GenerateCommon {
    public static final String IS_CLOUD = "single";
    private static PrintDevService printDevService = (PrintDevService)SpringContext.getBean(PrintDevService.class);

    public static String getLocalBasePath() {
        return FileUploadUtils.getLocalBasePath();
    }

    public static String getPath(String type) {
        return FilePathUtil.getFilePath((String)type);
    }

    public static List<PrintOption> getList(List<String> ids) {
        return printDevService.getPrintTemplateOptions(ids);
    }

    public static Template7Model getTemplate7Model(List<SysConfigEntity> list) {
        String author = "";
        String copyright = "";
        String version = "";
        for (SysConfigEntity item : list) {
            if ("companyName".equals(item.getFkey())) {
                author = item.getValue();
            }
            if ("copyright".equals(item.getFkey())) {
                copyright = item.getValue();
            }
            if (!"sysVersion".equals(item.getFkey())) continue;
            version = item.getValue();
        }
        Template7Model temModel = new Template7Model();
        temModel.setServiceDirectory(GenerateCommon.getLocalBasePath() + GenerateCommon.getPath("codetemp"));
        temModel.setCreateDate(DateUtil.daFormat((Date)new Date()));
        temModel.setCreateUser(StringUtil.isNotEmpty((String)author) ? author : "JNPF\u5f00\u53d1\u5e73\u53f0\u7ec4");
        temModel.setCopyright(StringUtil.isNotEmpty((String)copyright) ? copyright : "\u5f15\u8fc8\u4fe1\u606f\u6280\u672f\u6709\u9650\u516c\u53f8\uff08https://www.jnpfsoft.com\uff09");
        temModel.setVersion(StringUtil.isNotEmpty((String)version) ? version : "V5.0.0");
        temModel.setDescription("");
        return temModel;
    }

    public static List<CustomFile> getCustomFileList(GenerateParamModel generateParamModel) {
        Template7Model template7Model = generateParamModel.getTemplate7Model();
        String path = template7Model.getServiceDirectory() + generateParamModel.getFileName() + File.separator;
        DownloadCodeForm downloadCodeForm = generateParamModel.getDownloadCodeForm();
        ArrayList<CustomFile> custFileList = new ArrayList<CustomFile>();
        if (generateParamModel.isMainTable()) {
            custFileList.add(new CustomFile.Builder().templatePath("java/Controller.java.vm").formatNameFunction(tableInfo -> tableInfo.getControllerName()).fileName(".java").filePath(GenerateCommon.getCustomFilePath(path, OutputFile.controller.name(), downloadCodeForm)).enableFileOverride().build());
        }
        custFileList.add(new CustomFile.Builder().templatePath("java/Entity.java.vm").formatNameFunction(tableInfo -> tableInfo.getEntityName()).fileName(".java").filePath(GenerateCommon.getCustomFilePath(path, OutputFile.entity.name(), downloadCodeForm)).enableFileOverride().build());
        custFileList.add(new CustomFile.Builder().templatePath("java/Mapper.java.vm").formatNameFunction(tableInfo -> tableInfo.getMapperName()).fileName(".java").filePath(GenerateCommon.getCustomFilePath(path, OutputFile.mapper.name(), downloadCodeForm)).enableFileOverride().build());
        custFileList.add(new CustomFile.Builder().templatePath("java/Service.java.vm").formatNameFunction(tableInfo -> tableInfo.getServiceName()).fileName(".java").filePath(GenerateCommon.getCustomFilePath(path, OutputFile.service.name(), downloadCodeForm)).enableFileOverride().build());
        custFileList.add(new CustomFile.Builder().templatePath("java/ServiceImpl.java.vm").formatNameFunction(tableInfo -> tableInfo.getServiceImplName()).fileName(".java").filePath(GenerateCommon.getCustomFilePath(path, OutputFile.serviceImpl.name(), downloadCodeForm)).enableFileOverride().build());
        custFileList.add(new CustomFile.Builder().templatePath("java/Mapper.xml.vm").formatNameFunction(tableInfo -> tableInfo.getXmlName()).fileName(".xml").filePath(GenerateCommon.getCustomFilePath(path, OutputFile.xml.name(), downloadCodeForm)).enableFileOverride().build());
        return custFileList;
    }

    public static String getCustomFilePath(String path, String codeName, DownloadCodeForm downloadCodeForm) {
        String eachName = "";
        Object frontName = "";
        String modulName = downloadCodeForm.getModule();
        Object framePath = downloadCodeForm.getModulePackageName();
        switch (codeName) {
            case "controller": {
                framePath = GenerateCommon.getCloudPath("-controller", downloadCodeForm);
                break;
            }
            case "entity": {
                framePath = GenerateCommon.getCloudPath("-entity", downloadCodeForm);
                break;
            }
            case "mapper": {
                framePath = GenerateCommon.getCloudPath("-biz", downloadCodeForm);
                break;
            }
            case "xml": {
                if ("cloud".equals(IS_CLOUD)) {
                    String fileFront = "jnpf-" + modulName + File.separator + "jnpf-" + modulName + "-biz" + File.separator;
                    if ("form".equals(modulName)) {
                        fileFront = "jnpf-workflow" + File.separator + "jnpf-workflow-form" + File.separator + "jnpf-workflow-form-biz" + File.separator;
                    }
                    framePath = fileFront + "src" + File.separator + "main" + File.separator + "resources";
                    return path + File.separator + "java" + File.separator + (String)framePath + File.separator + "mapper" + File.separator;
                }
                return path + File.separator + "resources" + File.separator + "mapper" + File.separator;
            }
            case "service": {
                framePath = GenerateCommon.getCloudPath("-biz", downloadCodeForm);
                break;
            }
            case "serviceImpl": {
                codeName = "impl";
                frontName = "service" + File.separator;
                framePath = GenerateCommon.getCloudPath("-biz", downloadCodeForm);
            }
        }
        return path + File.separator + "java" + File.separator + (String)framePath + File.separator + (String)frontName + codeName + File.separator;
    }

    public static String getCloudPath(String houzui, DownloadCodeForm downloadCodeForm) {
        if ("form".equals(downloadCodeForm.getModule())) {
            return "jnpf-workflow" + File.separator + "jnpf-workflow-form" + File.separator + "jnpf-workflow-" + downloadCodeForm.getModule() + houzui + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + "jnpf" + File.separator + "form";
        }
        String framePath = "jnpf-" + downloadCodeForm.getModule() + File.separator + "jnpf-" + downloadCodeForm.getModule() + houzui + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + downloadCodeForm.getModulePackageName();
        return framePath;
    }

    public static List<ColumnListField> getExpotColumn(List<ColumnListField> columnList) {
        ArrayList<ColumnListField> listOptions = new ArrayList<ColumnListField>();
        columnList.forEach(item -> {
            ColumnListField columnListField = new ColumnListField();
            BeanUtil.copyProperties((Object)item, (Object)columnListField, (String[])new String[0]);
            if (item.getVModel().toLowerCase().startsWith("tablefield")) {
                columnListField.setTableType(Integer.valueOf(2));
                columnListField.setVModel(item.getVModel().split("-")[1]);
            } else if (item.getVModel().toLowerCase().contains("_jnpf_")) {
                columnListField.setTableType(Integer.valueOf(1));
                columnListField.setVModel(item.getVModel().split("_jnpf_")[1]);
            } else {
                columnListField.setTableType(Integer.valueOf(0));
            }
            if ("static".equals(item.getConfig().getDataType())) {
                columnListField.setOptions(JsonUtil.getObjectToString((Object)item.getOptions()));
                if (item.getJnpfKey().equals("checkbox")) {
                    columnListField.setMultiple(Boolean.valueOf(true));
                }
            }
            listOptions.add(columnListField);
        });
        return listOptions;
    }

    public static List<String> getSummaryThousandList(List<FormAllModel> mast, List<FormAllModel> mastTable, Integer type) {
        FieLdsModel fm;
        String suffix = "_name";
        if (type == 4) {
            suffix = "";
        }
        ArrayList<String> thousandsField = new ArrayList<String>();
        for (FormAllModel f : mast) {
            fm = f.getFormColumnModel().getFieLdsModel();
            if (!fm.isThousands()) continue;
            thousandsField.add(fm.getVModel() + suffix);
        }
        for (FormAllModel f : mastTable) {
            fm = f.getFormMastTableModel().getMastTable().getFieLdsModel();
            if (!fm.isThousands()) continue;
            thousandsField.add(f.getFormMastTableModel().getTable() + "." + fm.getVModel() + suffix);
        }
        return thousandsField;
    }

    public static void createComplexHeaderExcelVo(String path, GenerateParamModel generateParamModel, VisualdevEntity entity, DownloadCodeForm downloadCodeForm, Map<String, Object> objectAll) {
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)entity.getColumnData(), ColumnDataModel.class);
        JsonUtil.getListToJsonArray((List)columnDataModel.getComplexHeaderList());
        List complexHeaderList = columnDataModel.getComplexHeaderList();
        String templateName = File.separator + "java" + File.separator + "ExcelVO.java.vm";
        VelocityContext context = new VelocityContext();
        HashMap<String, Object> object = new HashMap<String, Object>();
        object.put("genInfo", generateParamModel.getTemplate7Model());
        object.put("package", generateParamModel.getDownloadCodeForm().getModulePackageName());
        object.put("module", downloadCodeForm.getModule());
        object.put("isMain", true);
        object.put("isComplexVo", true);
        object.put("importFields", objectAll.get("importFields"));
        for (HeaderModel item : complexHeaderList) {
            if (item.getChildColumns().size() <= 0) continue;
            String className = "Complex" + item.getId();
            object.put("complexList", JsonUtil.getListToJsonArray((List)item.getChildColumns()));
            object.put("className", className);
            context.put("context", object);
            String fileNames = GenerateCommon.getFileName(path, templateName, className, downloadCodeForm);
            GenerateCommon.velocityWriterFile(context, templateName, fileNames);
        }
    }

    public static void htmlTemplates(String path, Map<String, Object> object, String templatePath, int type, boolean hasImport, DownloadCodeForm downloadCodeForm, GenerateInterface codeUtil) throws Exception {
        List<String> templates = codeUtil.getTemplates(templatePath, type, hasImport);
        VelocityContext context = new VelocityContext();
        context.put("context", object);
        for (String template : templates) {
            String className = object.get("className").toString();
            String fileNames = GenerateCommon.getFileName(path, template, className, downloadCodeForm);
            GenerateCommon.velocityWriterFile(context, template, fileNames);
        }
    }

    public static String getFileName(String path, String template, String className, DownloadCodeForm downloadCodeForm) {
        String framePath = GenerateCommon.getCloudPath("-entity", downloadCodeForm);
        String modelfolder = downloadCodeForm.getMainClassName();
        String modelPath = XSSEscape.escapePath((String)(path + File.separator + "java" + File.separator + framePath + File.separator + "model" + File.separator + modelfolder.toLowerCase()));
        String htmlPath = XSSEscape.escapePath((String)(path + File.separator + "html" + File.separator + "web" + File.separator + modelfolder.toLowerCase()));
        File htmlfile = new File(htmlPath);
        File modelfile = new File(modelPath);
        if (!htmlfile.exists()) {
            htmlfile.mkdirs();
        }
        if (!modelfile.exists()) {
            modelfile.mkdirs();
        }
        if (template.contains("extraForm.vue.vm") || template.contains("ExtraForm.vue.vm")) {
            return htmlPath + File.separator + "ExtraForm.vue";
        }
        if (template.contains("Form.vue.vm")) {
            return htmlPath + File.separator + "Form.vue";
        }
        if (template.contains("FormPopup.vue.vm")) {
            return htmlPath + File.separator + "FormPopup.vue";
        }
        if (template.contains("index.vue.vm")) {
            return htmlPath + File.separator + "index.vue";
        }
        if (template.contains("indexEdit.vue.vm")) {
            return htmlPath + File.separator + "index.vue";
        }
        if (template.contains("Detail.vue.vm")) {
            return htmlPath + File.separator + "Detail.vue";
        }
        if (template.contains("api.ts.vm")) {
            String htmlTSPath = XSSEscape.escapePath((String)(path + File.separator + "html" + File.separator + "web" + File.separator + modelfolder.toLowerCase() + File.separator + "helper"));
            File htmlJSfile = new File(htmlTSPath);
            if (!htmlJSfile.exists() && !"form".equals(downloadCodeForm.getModule())) {
                htmlJSfile.mkdirs();
            }
            return htmlPath + File.separator + "helper" + File.separator + "api.ts";
        }
        if (template.contains("InfoVO.java.vm")) {
            return modelPath + File.separator + className + "InfoVO.java";
        }
        if (template.contains("Form.java.vm")) {
            return modelPath + File.separator + className + "Form.java";
        }
        if (template.contains("ListVO.java.vm")) {
            return modelPath + File.separator + className + "ListVO.java";
        }
        if (template.contains("GroupVO.java.vm")) {
            return modelPath + File.separator + className + "GroupVO.java";
        }
        if (template.contains("Pagination.java.vm")) {
            return modelPath + File.separator + className + "Pagination.java";
        }
        if (template.contains("ExcelVO.java.vm")) {
            return modelPath + File.separator + className + "ExcelVO.java";
        }
        if (template.contains("ExcelErrorVO.java.vm")) {
            return modelPath + File.separator + className + "ExcelErrorVO.java";
        }
        if (template.contains("Model.java.vm")) {
            return modelPath + File.separator + className + "Model.java";
        }
        if (template.contains("ListVO.java.vm")) {
            return modelPath + File.separator + className + "ListVO.java";
        }
        if (template.contains("Constant.java.vm")) {
            return modelPath + File.separator + className + "Constant.java";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void velocityWriterFile(VelocityContext context, String template, String fileNames) {
        block11: {
            try {
                StringWriter sw = new StringWriter();
                try {
                    Template tpl = Velocity.getTemplate((String)template, (String)"UTF-8");
                    tpl.merge((Context)context, (Writer)sw);
                    if (fileNames == null) break block11;
                    File file = new File(XSSEscape.escapePath((String)fileNames));
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    FileOutputStream fos = new FileOutputStream(file);
                    try {
                        IOUtils.write((String)sw.toString(), (OutputStream)fos, (String)"UTF-8");
                        IOUtils.closeQuietly((Writer)sw);
                        IOUtils.closeQuietly((OutputStream)fos);
                    }
                    finally {
                        if (Collections.singletonList(fos).get(0) != null) {
                            fos.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(sw).get(0) != null) {
                        sw.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("\u6e32\u67d3\u6a21\u677f\u5931\u8d25\uff0c\u8868\u540d\uff1a" + String.valueOf(e));
            }
        }
    }

    public static Map<String, Object> getInterTemplateJson(List<FormAllModel> allModels, Map<String, String> childTableKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (FormAllModel item : allModels) {
            FieLdsModel fieLdsModel;
            if (FormEnum.mast.getMessage().equals(item.getJnpfKey()) && StringUtil.isNotEmpty((String)(fieLdsModel = (FieLdsModel)BeanUtil.copyProperties((Object)item.getFormColumnModel().getFieLdsModel(), FieLdsModel.class, (String[])new String[0])).getVModel())) {
                map.put(fieLdsModel.getVModel(), GenerateCommon.getTemJsonModel(fieLdsModel, childTableKey));
            }
            if (FormEnum.mastTable.getMessage().equals(item.getJnpfKey()) && StringUtil.isNotEmpty((String)(fieLdsModel = (FieLdsModel)BeanUtil.copyProperties((Object)item.getFormMastTableModel().getMastTable().getFieLdsModel(), FieLdsModel.class, (String[])new String[0])).getVModel())) {
                map.put(item.getFormMastTableModel().getVModel(), GenerateCommon.getTemJsonModel(fieLdsModel, childTableKey));
            }
            if (!FormEnum.table.getMessage().equals(item.getJnpfKey())) continue;
            List childList = item.getChildList().getChildList();
            for (FormColumnModel columnModel : childList) {
                FieLdsModel fieLdsModel2 = (FieLdsModel)BeanUtil.copyProperties((Object)columnModel.getFieLdsModel(), FieLdsModel.class, (String[])new String[0]);
                if (!StringUtil.isNotEmpty((String)fieLdsModel2.getVModel())) continue;
                HashMap<String, String> childTableMap = new HashMap<String, String>();
                childTableMap.put(item.getChildList().getTableModel(), item.getChildList().getAliasLowName());
                map.put(item.getChildList().getAliasLowName() + fieLdsModel2.getVModel(), GenerateCommon.getTemJsonModel(fieLdsModel2, childTableMap));
            }
        }
        return map;
    }

    private static List<TemplateJsonModel> getTemJsonModel(FieLdsModel fieLdsModel, Map<String, String> childTableKey) {
        List templateJson = fieLdsModel.getConfig().getTemplateJson();
        List json = templateJson.size() > 0 ? templateJson : JsonUtil.getJsonToList((String)fieLdsModel.getTemplateJson(), TemplateJsonModel.class);
        for (TemplateJsonModel t : json) {
            if (t.getRelationField() == null || !t.getRelationField().contains("-") || !Objects.equals(t.getSourceType(), 1)) continue;
            String[] split = t.getRelationField().split("-");
            t.setRelationField(childTableKey.get(split[0]) + "List-" + split[1]);
        }
        return json;
    }

    public static List<String> getNotSystemFields(List<FormAllModel> mast, List<FormAllModel> mastTable, List<FormAllModel> childTable, GenerateParamModel generateParamModel) {
        ArrayList<String> list = new ArrayList<String>();
        String table = generateParamModel.getTable();
        boolean mainTable = generateParamModel.isMainTable();
        ArrayList<FormColumnModel> fields = new ArrayList<FormColumnModel>();
        for (FormAllModel fam : mast) {
            if (!mainTable) continue;
            fields.add(fam.getFormColumnModel());
        }
        for (FormAllModel fam : mastTable) {
            if (!table.equals(fam.getFormMastTableModel().getTable())) continue;
            fields.add(fam.getFormMastTableModel().getMastTable());
        }
        for (FormAllModel fam : childTable) {
            if (!table.equals(fam.getChildList().getTableName())) continue;
            fields.addAll(fam.getChildList().getChildList());
        }
        for (FormColumnModel fcm : fields) {
            if (JnpfKeyConsts.getSystemKey().contains(fcm.getFieLdsModel().getConfig().getJnpfKey()) || !StringUtil.isNotEmpty((String)fcm.getFieLdsModel().getFieldAlias())) continue;
            list.add(fcm.getFieLdsModel().getFieldAlias().toUpperCase());
        }
        return list;
    }

    public static String objRemoveJson(String str) {
        JSONObject object = JSONObject.parseObject((String)str);
        JSONArray columnList = object.getJSONArray("columnList");
        GenerateCommon.removeJson(columnList);
        object.put("columnList", (Object)columnList);
        JSONArray searchList = object.getJSONArray("searchList");
        GenerateCommon.removeJson(searchList);
        object.put("searchList", (Object)searchList);
        JSONObject ruleList = object.getJSONObject("ruleList");
        GenerateCommon.ruleRemoveJson(ruleList);
        object.put("ruleList", (Object)ruleList);
        JSONObject ruleListApp = object.getJSONObject("ruleListApp");
        GenerateCommon.ruleRemoveJson(ruleListApp);
        object.put("ruleListApp", (Object)ruleListApp);
        JSONArray columnOptions = object.getJSONArray("columnOptions");
        GenerateCommon.removeJson(columnOptions);
        object.put("columnOptions", (Object)columnOptions);
        JSONArray defaultColumnList = object.getJSONArray("defaultColumnList");
        GenerateCommon.removeJson(defaultColumnList);
        object.put("defaultColumnList", (Object)defaultColumnList);
        JSONArray sortList = object.getJSONArray("sortList");
        GenerateCommon.removeJson(sortList);
        object.put("sortList", (Object)sortList);
        JSONArray fields = object.getJSONArray("fields");
        GenerateCommon.removeJson(fields);
        object.put("fields", (Object)fields);
        object.remove((Object)"funcs");
        return object.toJSONString();
    }

    private static void ruleRemoveJson(JSONObject ruleList) {
        JSONArray conditionList;
        if (ruleList != null && (conditionList = ruleList.getJSONArray("conditionList")) != null) {
            for (Object o : conditionList) {
                JSONObject obj = (JSONObject)o;
                JSONArray groups = obj.getJSONArray("groups");
                GenerateCommon.removeJson(groups);
                obj.put("groups", (Object)groups);
            }
            ruleList.put("conditionList", (Object)conditionList);
        }
    }

    public static void removeJson(JSONArray jsonArray) {
        if (jsonArray == null || jsonArray.size() == 0) {
            return;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject config;
            ArrayList childrenListAll = new ArrayList(){
                {
                    this.add(FormEnum.card.getMessage());
                    this.add(FormEnum.row.getMessage());
                    this.add(FormEnum.tab.getMessage());
                    this.add(FormEnum.collapse.getMessage());
                    this.add(FormEnum.collapseItem.getMessage());
                    this.add(FormEnum.tabItem.getMessage());
                    this.add(FormEnum.tableGrid.getMessage());
                    this.add(FormEnum.tableGridTr.getMessage());
                    this.add(FormEnum.tableGridTd.getMessage());
                }
            };
            JSONObject jsonObject = (JSONObject)jsonArray.get(i);
            String jnpfkey = jsonObject.getJSONObject("__config__").getString("jnpfKey");
            if (childrenListAll.contains(jnpfkey) || StringUtil.isEmpty((String)jnpfkey)) {
                config = jsonObject.getJSONObject("__config__");
                config.remove((Object)"on");
                JSONArray childArray = config.getJSONArray("children");
                GenerateCommon.removeJson(childArray);
                config.put("children", (Object)childArray);
                jsonObject.put("__config__", (Object)config);
            } else if (FormEnum.table.getMessage().equals(jnpfkey)) {
                JSONObject configA = jsonObject.getJSONObject("__config__");
                configA.remove((Object)"on");
                JSONArray children = configA.getJSONArray("children");
                for (int k = 0; k < children.size(); ++k) {
                    JSONObject childrenObject = (JSONObject)children.get(k);
                    childrenObject.remove((Object)"on");
                    JSONObject config2 = childrenObject.getJSONObject("__config__");
                    config2.remove((Object)"on");
                    if (!"static".equals(config2.get((Object)"dataType"))) {
                        childrenObject.remove((Object)"options");
                        config2.remove((Object)"options");
                    }
                    childrenObject.put("__config__", (Object)config2);
                }
                configA.put("children", (Object)children);
                if (!"static".equals(configA.get((Object)"dataType"))) {
                    jsonObject.remove((Object)"options");
                    configA.remove((Object)"options");
                }
                jsonObject.put("__config__", (Object)configA);
            }
            jsonObject.remove((Object)"on");
            config = jsonObject.getJSONObject("__config__");
            config.remove((Object)"on");
            if (!"static".equals(config.get((Object)"dataType"))) {
                jsonObject.remove((Object)"options");
                config.remove((Object)"options");
            }
            jsonObject.put("__config__", (Object)config);
        }
    }

    public static String delNotSupport(Object obj) {
        if (obj instanceof JSONArray) {
            List collect = JsonUtil.getJsonToJsonArray((String)JsonUtil.getObjectToString((Object)obj)).stream().filter(t -> !"calculate".equals(JsonUtil.entityToMap((Object)t).get("jnpfKey"))).collect(Collectors.toList());
            return JSONObject.toJSONString(collect, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat});
        }
        return JSONObject.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat});
    }
}

