/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.util.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.model.DownloadCodeForm;
import jnpf.base.model.form.DraftJsonModel;
import jnpf.base.model.form.FormDraftJsonModel;
import jnpf.base.util.common.AliasModel;
import jnpf.base.util.common.DataControlUtils;
import jnpf.base.util.common.GenerateParamModel;
import jnpf.model.OnlineDevData;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.FormCloumnUtil;
import jnpf.model.visualJson.FormDataModel;
import jnpf.model.visualJson.TableModel;
import jnpf.model.visualJson.analysis.FormAllModel;
import jnpf.model.visualJson.analysis.FormColumnModel;
import jnpf.model.visualJson.analysis.FormColumnTableModel;
import jnpf.model.visualJson.analysis.FormEnum;
import jnpf.model.visualJson.analysis.FormMastTableModel;
import jnpf.model.visualJson.analysis.RecursionForm;
import jnpf.model.visualJson.config.ConfigModel;
import jnpf.util.JsonUtil;
import jnpf.util.StringUtil;

public class FunctionFormPublicUtil {
    public static VisualdevEntity exportFlowFormJson(VisualdevEntity entity, GenerateParamModel generateParamModel) {
        DraftJsonModel engineModel;
        VisualdevEntity visualdevEntity = new VisualdevEntity();
        visualdevEntity.setEnCode(entity.getEnCode());
        visualdevEntity.setFullName(entity.getFullName());
        visualdevEntity.setType(OnlineDevData.FORM_TYPE_SYS);
        visualdevEntity.setWebType(entity.getWebType());
        visualdevEntity.setCategory(entity.getCategory());
        visualdevEntity.setDescription(entity.getDescription());
        visualdevEntity.setSortCode(entity.getSortCode());
        visualdevEntity.setCreatorTime(entity.getCreatorTime());
        visualdevEntity.setCreatorUserId(entity.getCreatorUserId());
        visualdevEntity.setVisualTables(entity.getVisualTables());
        visualdevEntity.setDbLinkId(entity.getDbLinkId());
        DownloadCodeForm downloadCodeForm = generateParamModel.getDownloadCodeForm();
        String appUrl = "/pages/apply/" + generateParamModel.getClassName();
        visualdevEntity.setAppUrlAddress(appUrl);
        String formFileName = "/Form.vue";
        String webUrl = "extend/" + generateParamModel.getClassName().toLowerCase() + formFileName;
        visualdevEntity.setUrlAddress(webUrl);
        String downloadClassName = generateParamModel.getClassName().substring(0, 1).toUpperCase() + generateParamModel.getClassName().substring(1);
        String interfaceUrl = "/api/" + downloadCodeForm.getModule() + "/" + downloadClassName;
        visualdevEntity.setInterfaceUrl(interfaceUrl);
        ArrayList<FormAllModel> formAllModel = new ArrayList<FormAllModel>();
        FunctionFormPublicUtil.forDataMode(entity, formAllModel);
        List mastList = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        ArrayList<DraftJsonModel> tempJson = new ArrayList<DraftJsonModel>();
        for (FormAllModel mastModel : mastList) {
            FieLdsModel fieLdsModel = mastModel.getFormColumnModel().getFieLdsModel();
            Object model = fieLdsModel.getVModel();
            ConfigModel config = fieLdsModel.getConfig();
            if (!StringUtil.isNotEmpty((String)model)) continue;
            DraftJsonModel engineModel2 = new DraftJsonModel();
            String label = config.getLabel();
            engineModel2.setFiledId((String)model);
            engineModel2.setFiledName(label);
            engineModel2.setRequired(Boolean.valueOf(config.isRequired()));
            engineModel2.setJnpfKey(config.getJnpfKey());
            engineModel2.setMultiple(fieLdsModel.getMultiple().booleanValue());
            tempJson.add(engineModel2);
        }
        List tableList = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        Map<String, AliasModel> tableListAll = generateParamModel.getTableAliseMap();
        for (Object model : tableList) {
            String table = model.getChildList().getTableName();
            String name = DataControlUtils.initialLowercase(tableListAll.get(table).getAliasName());
            FormColumnTableModel childList = model.getChildList();
            String label = childList.getLabel();
            boolean required = childList.isRequired();
            engineModel = new DraftJsonModel();
            engineModel.setFiledId(name + "List");
            engineModel.setFiledName(label);
            engineModel.setRequired(Boolean.valueOf(required));
            tempJson.add(engineModel);
            for (FormColumnModel columnModel : model.getChildList().getChildList()) {
                String vModel = columnModel.getFieLdsModel().getVModel();
                String childLable = columnModel.getFieLdsModel().getConfig().getLabel();
                ConfigModel config = columnModel.getFieLdsModel().getConfig();
                if (!StringUtil.isNotEmpty((String)vModel)) continue;
                DraftJsonModel childModel = new DraftJsonModel();
                childModel.setFiledId(name + "List-" + vModel);
                childModel.setFiledName(label + "-" + childLable);
                childModel.setRequired(Boolean.valueOf(config.isRequired()));
                childModel.setJnpfKey(config.getJnpfKey());
                childModel.setMultiple(columnModel.getFieLdsModel().getMultiple().booleanValue());
                tempJson.add(childModel);
            }
        }
        List mastTableList = formAllModel.stream().filter(t -> FormEnum.mastTable.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        for (FormAllModel mastTableModel : mastTableList) {
            FormMastTableModel formMastTableModel = mastTableModel.getFormMastTableModel();
            FieLdsModel fieLdsModel = formMastTableModel.getMastTable().getFieLdsModel();
            String model = formMastTableModel.getVModel();
            ConfigModel config = fieLdsModel.getConfig();
            if (!StringUtil.isNotEmpty((String)model)) continue;
            engineModel = new DraftJsonModel();
            String label = config.getLabel();
            engineModel.setFiledId(model);
            engineModel.setFiledName(label);
            engineModel.setRequired(Boolean.valueOf(config.isRequired()));
            engineModel.setJnpfKey(config.getJnpfKey());
            engineModel.setMultiple(fieLdsModel.getMultiple().booleanValue());
            tempJson.add(engineModel);
        }
        FormDraftJsonModel draftJsonModel = new FormDraftJsonModel();
        String Tem = JsonUtil.getObjectToString(tempJson);
        visualdevEntity.setFormData(Tem);
        draftJsonModel.setDraftJson(Tem);
        draftJsonModel.setTableJson(entity.getVisualTables());
        return visualdevEntity;
    }

    private static void forDataMode(VisualdevEntity entity, List<FormAllModel> formAllModel) {
        FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFormData(), FormDataModel.class);
        List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        List tableModelList = JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class);
        RecursionForm recursionForm = new RecursionForm(list, tableModelList);
        FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
    }
}

