/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.util.common;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.analysis.FormAllModel;
import jnpf.model.visualJson.analysis.FormColumnModel;
import jnpf.model.visualJson.analysis.FormColumnTableModel;
import jnpf.model.visualJson.analysis.FormEnum;
import jnpf.model.visualJson.config.RuleConfig;
import jnpf.util.JsonUtil;
import jnpf.util.StringUtil;

public class DataControlUtils {
    public static String captureName(String name) {
        char[] ch = name.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            if (i != 0) continue;
            ch[0] = Character.toUpperCase(ch[0]);
        }
        StringBuffer a = new StringBuffer();
        a.append(ch);
        return a.toString();
    }

    public static String initialLowercase(String name) {
        char[] ch = name.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            if (i != 0) continue;
            ch[0] = Character.toLowerCase(ch[0]);
        }
        StringBuffer a = new StringBuffer();
        a.append(ch);
        return a.toString();
    }

    public static String getPlaceholder(String jnpfKey) {
        String placeholderName = "\u8bf7\u9009\u62e9";
        switch (jnpfKey) {
            case "billRule": 
            case "modifyUser": 
            case "createUser": 
            case "input": 
            case "textarea": {
                placeholderName = "\u8bf7\u8f93\u5165";
                break;
            }
        }
        return placeholderName;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public static FieLdsModel setAbleIDs(FieLdsModel fieLdsModel) {
        if (fieLdsModel.getAbleDepIds() != null) {
            fieLdsModel.setAbleDepIds(JSONObject.toJSONString((Object)fieLdsModel.getAbleDepIds()));
        }
        if (fieLdsModel.getAblePosIds() != null) {
            fieLdsModel.setAblePosIds(JSONObject.toJSONString((Object)fieLdsModel.getAblePosIds()));
        }
        if (fieLdsModel.getAbleUserIds() != null) {
            fieLdsModel.setAbleUserIds(JSONObject.toJSONString((Object)fieLdsModel.getAbleUserIds()));
        }
        if (fieLdsModel.getAbleRoleIds() != null) {
            fieLdsModel.setAbleRoleIds(JSONObject.toJSONString((Object)fieLdsModel.getAbleRoleIds()));
        }
        if (fieLdsModel.getAbleGroupIds() != null) {
            fieLdsModel.setAbleGroupIds(JSONObject.toJSONString((Object)fieLdsModel.getAbleGroupIds()));
        }
        if (fieLdsModel.getAbleIds() != null) {
            fieLdsModel.setAbleIds(JSONObject.toJSONString((Object)fieLdsModel.getAbleIds()));
        }
        if (fieLdsModel.getConfig().getRegList() != null) {
            String o1 = JSONObject.toJSONString((Object)JsonUtil.getObjectToString((Object)fieLdsModel.getConfig().getRegList()));
            fieLdsModel.getConfig().setReg(o1);
        }
        return fieLdsModel;
    }

    public static Map<String, String> getBillRule(List<FormAllModel> formAllModel) {
        HashMap<String, String> billRuleMap = new HashMap<String, String>();
        for (FormAllModel t : formAllModel) {
            FieLdsModel fieLdsModel;
            String ruleJson;
            if (FormEnum.mast.getMessage().equals(t.getJnpfKey()) && StringUtil.isNotEmpty((String)(ruleJson = DataControlUtils.getRuleJson(fieLdsModel = t.getFormColumnModel().getFieLdsModel())))) {
                billRuleMap.put(fieLdsModel.getVModel(), ruleJson);
            }
            if (FormEnum.mastTable.getMessage().equals(t.getJnpfKey()) && StringUtil.isNotEmpty((String)(ruleJson = DataControlUtils.getRuleJson(fieLdsModel = t.getFormMastTableModel().getMastTable().getFieLdsModel())))) {
                billRuleMap.put(fieLdsModel.getVModel(), ruleJson);
            }
            if (!FormEnum.table.getMessage().equals(t.getJnpfKey())) continue;
            FormColumnTableModel childModel = t.getChildList();
            String aliasLowName = childModel.getAliasLowName();
            List childList = childModel.getChildList();
            for (FormColumnModel child : childList) {
                FieLdsModel fieLdsModel2 = child.getFieLdsModel();
                String ruleJson2 = DataControlUtils.getRuleJson(fieLdsModel2);
                if (!StringUtil.isNotEmpty((String)ruleJson2)) continue;
                billRuleMap.put(aliasLowName + "_" + fieLdsModel2.getVModel(), ruleJson2);
            }
        }
        return billRuleMap;
    }

    private static String getRuleJson(FieLdsModel fieLdsModel) {
        RuleConfig ruleConfig;
        Integer ruleType = fieLdsModel.getConfig().getRuleType();
        if (Objects.equals(ruleType, 2) && (ruleConfig = fieLdsModel.getConfig().getRuleConfig()) != null) {
            return JsonUtil.getObjectToString((Object)JsonUtil.getObjectToString((Object)ruleConfig));
        }
        return null;
    }
}

