/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.util.app;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.model.ColumnDataModel;
import jnpf.base.model.DownloadCodeForm;
import jnpf.base.model.Template6.BtnData;
import jnpf.base.model.Template6.ColumnListField;
import jnpf.base.model.Template7.Template7Model;
import jnpf.base.model.VisualWebTypeEnum;
import jnpf.base.util.app.AppGenModel;
import jnpf.base.util.common.AliasModel;
import jnpf.base.util.common.DataControlUtils;
import jnpf.base.util.common.GenerateCommon;
import jnpf.base.util.common.SuperQueryUtil;
import jnpf.database.model.superQuery.SuperJsonModel;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.FormCloumnUtil;
import jnpf.model.visualJson.FormDataModel;
import jnpf.model.visualJson.TableModel;
import jnpf.model.visualJson.TemplateJsonModel;
import jnpf.model.visualJson.analysis.FormAllModel;
import jnpf.model.visualJson.analysis.FormColumnModel;
import jnpf.model.visualJson.analysis.FormColumnTableModel;
import jnpf.model.visualJson.analysis.FormEnum;
import jnpf.model.visualJson.analysis.FormMastTableModel;
import jnpf.model.visualJson.analysis.RecursionForm;
import jnpf.model.visualJson.config.ConfigModel;
import jnpf.model.visualJson.config.TabConfigModel;
import jnpf.util.JsonUtil;
import jnpf.util.StringUtil;
import jnpf.util.XSSEscape;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class AppGenUtil {
    private List<String> noShow = ImmutableList.of((Object)"calculate");

    public void htmlTemplates(AppGenModel appGenModel) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        VisualdevEntity entity = appGenModel.getEntity();
        DownloadCodeForm downloadCodeForm = appGenModel.getDownloadCodeForm();
        ArrayList<FormAllModel> formAllModel = new ArrayList<FormAllModel>();
        boolean isView = this.isView(appGenModel);
        HashMap<String, String> tableNameAll = new HashMap<String, String>();
        if (!isView) {
            tableNameAll.putAll(this.forDataMode(appGenModel, formAllModel));
        }
        FormDataModel model = appGenModel.getModel();
        List<FormAllModel> mast = this.mast(formAllModel);
        ArrayList<Map<String, Object>> child = new ArrayList<Map<String, Object>>();
        this.childModel(formAllModel, child, tableNameAll);
        this.mastTableModel(formAllModel, map, tableNameAll);
        this.templateJson(formAllModel);
        map.put("moduleId", appGenModel.getEntity().getId());
        map.put("children", child);
        map.put("groupTable", appGenModel.getGroupTable());
        map.put("type", appGenModel.getType());
        map.put("fields", mast);
        map.put("package", "jnpf");
        map.put("isModel", "true");
        map.put("labelSuffix", model.getLabelSuffix());
        map.put("flowEnCode", entity.getEnCode());
        map.put("flowId", entity.getId());
        map.put("webType", entity.getWebType());
        map.put("isFlow", Objects.equals(downloadCodeForm.getEnableFlow(), 1));
        map.put("module", model.getAreasName());
        map.put("className", DataControlUtils.captureName(model.getClassName()));
        this.formData(map, appGenModel, formAllModel);
        List<String> getTemplate = this.getTemplate(appGenModel);
        Template7Model templateModel = appGenModel.getTemplate7Model();
        String path = templateModel.getServiceDirectory() + appGenModel.getFileName();
        boolean type = this.isForm(appGenModel);
        this.htmlTemplates(map, getTemplate, path, DataControlUtils.initialLowercase(model.getClassName()), isView ? false : !type);
    }

    private void templateJson(List<FormAllModel> formAllModel) {
        for (FormAllModel model : formAllModel) {
            List templateJsonModelList;
            ArrayList templateJsonAll;
            if (FormEnum.mast.getMessage().equals(model.getJnpfKey())) {
                templateJsonAll = new ArrayList();
                templateJsonAll.addAll(model.getFormColumnModel().getFieLdsModel().getConfig().getTemplateJson());
                templateJsonModelList = JsonUtil.getJsonToList((String)model.getFormColumnModel().getFieLdsModel().getTemplateJson(), TemplateJsonModel.class);
                templateJsonAll.addAll(templateJsonModelList);
                model.getFormColumnModel().getFieLdsModel().getConfig().setTemplateJson(templateJsonAll);
            }
            if (!FormEnum.mastTable.getMessage().equals(model.getJnpfKey())) continue;
            templateJsonAll = new ArrayList();
            templateJsonAll.addAll(model.getFormMastTableModel().getMastTable().getFieLdsModel().getConfig().getTemplateJson());
            templateJsonModelList = JsonUtil.getJsonToList((String)model.getFormMastTableModel().getMastTable().getFieLdsModel().getTemplateJson(), TemplateJsonModel.class);
            templateJsonAll.addAll(templateJsonModelList);
            model.getFormMastTableModel().getMastTable().getFieLdsModel().getConfig().setTemplateJson(templateJsonAll);
        }
    }

    private List<String> getTemplate(AppGenModel appGenModel) {
        String template = this.tempPath(appGenModel);
        VisualdevEntity entity = appGenModel.getEntity();
        DownloadCodeForm downloadCodeForm = appGenModel.getDownloadCodeForm();
        boolean isView = this.isView(appGenModel);
        ArrayList<String> templates = new ArrayList<String>();
        if (isView) {
            templates.add(template + File.separator + "app" + File.separator + "index.vue.vm");
        } else {
            boolean index;
            boolean isType = !VisualWebTypeEnum.FORM.getType().equals(entity.getWebType());
            templates.add(template + File.separator + "app" + File.separator + "form.vue.vm");
            if (VisualWebTypeEnum.FORM_LIST.getType().equals(entity.getWebType())) {
                boolean detail;
                ColumnDataModel appColumnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)entity.getColumnData(), ColumnDataModel.class);
                List columnBtnDataList = JsonUtil.getJsonToList((Object)appColumnDataModel.getColumnBtnsList(), BtnData.class);
                boolean bl = detail = columnBtnDataList.stream().filter(t -> "detail".equals(t.getValue())).count() > 0L;
                if (downloadCodeForm.getEnableFlow() == 0 && isType && detail) {
                    templates.add(template + File.separator + "app" + File.separator + "detail.vue.vm");
                }
            }
            boolean bl = index = !VisualWebTypeEnum.FORM.getType().equals(entity.getWebType()) || downloadCodeForm.getEnableFlow() == 1;
            if (index) {
                templates.add(template + File.separator + "app" + File.separator + "index.vue.vm");
            }
        }
        return templates;
    }

    private String getFileNames(String path, String template, String className, boolean isIndex) {
        path = XSSEscape.escapePath((String)path);
        className = XSSEscape.escapePath((String)className);
        String pathName = className.substring(0, 1).toLowerCase() + className.substring(1);
        if (template.contains("index.vue.vm") || template.contains("detail.vue.vm")) {
            String indexHtmlPath = path + File.separator + "html" + File.separator + "app";
            File indexfile = new File(indexHtmlPath = indexHtmlPath + (isIndex ? File.separator + "index" + File.separator + pathName : File.separator + pathName));
            if (!indexfile.exists()) {
                indexfile.mkdirs();
            }
            className = template.contains("index.vue.vm") ? "index" : "detail";
            return indexHtmlPath + File.separator + className + ".vue";
        }
        if (template.contains("form.vue.vm")) {
            String formHtmlPath = path + File.separator + "html" + File.separator + "app";
            File formfile = new File(formHtmlPath = formHtmlPath + (isIndex ? File.separator + "form" + File.separator + pathName : File.separator + pathName));
            if (!formfile.exists()) {
                formfile.mkdirs();
            }
            className = isIndex ? "index" : "form";
            return formHtmlPath + File.separator + className + ".vue";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void htmlTemplates(Object object, List<String> templates, String path, String className, boolean isIndex) {
        VelocityContext context = new VelocityContext();
        context.put("context", object);
        for (String template : templates) {
            try {
                StringWriter sw = new StringWriter();
                try {
                    Template tpl = Velocity.getTemplate((String)template, (String)"UTF-8");
                    tpl.merge((Context)context, (Writer)sw);
                    String fileNames = this.getFileNames(path, template, className, isIndex);
                    if (fileNames == null) continue;
                    File file = new File(fileNames);
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    FileOutputStream fos = new FileOutputStream(file);
                    try {
                        IOUtils.write((String)sw.toString(), (OutputStream)fos, (String)"UTF-8");
                        IOUtils.closeQuietly((Writer)sw);
                        IOUtils.closeQuietly((OutputStream)fos);
                    }
                    finally {
                        if (Collections.singletonList(fos).get(0) == null) continue;
                        fos.close();
                    }
                }
                finally {
                    if (Collections.singletonList(sw).get(0) == null) continue;
                    sw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("\u6e32\u67d3\u6a21\u677f\u5931\u8d25\uff0c\u8868\u540d\uff1a" + String.valueOf(e));
            }
        }
    }

    private List<FormAllModel> mast(List<FormAllModel> formAllModel) {
        List<FormAllModel> mast = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        for (int i = 0; i < mast.size(); ++i) {
            FieLdsModel fieLdsModel = mast.get(i).getFormColumnModel().getFieLdsModel();
            this.model(fieLdsModel);
            String vmodel = fieLdsModel.getVModel();
            if (!StringUtil.isEmpty((String)vmodel)) continue;
            mast.remove(i);
            --i;
        }
        return mast;
    }

    private Map<String, List<FormAllModel>> mastTableModel(List<FormAllModel> formAllModel, Map<String, Object> map, Map<String, String> tableNameAll) {
        List mastTable = formAllModel.stream().filter(t -> FormEnum.mastTable.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        Map<String, List<FormAllModel>> mastListAll = mastTable.stream().collect(Collectors.groupingBy(e -> e.getFormMastTableModel().getTable()));
        HashMap<String, CallSite> mastTableNameAll = new HashMap<String, CallSite>();
        HashMap<String, List<FormAllModel>> mastTableList = new HashMap<String, List<FormAllModel>>();
        for (String mastkey : mastListAll.keySet()) {
            List<FormAllModel> mastList = mastListAll.get(mastkey);
            for (FormAllModel fieLdsList : mastList) {
                FieLdsModel fieLdsModel = fieLdsList.getFormMastTableModel().getMastTable().getFieLdsModel();
                this.model(fieLdsModel);
            }
            mastListAll.put(mastkey, mastList);
            String tableName = tableNameAll.get(mastkey);
            String name = tableName.substring(0, 1).toUpperCase() + tableName.substring(1);
            mastTableNameAll.put(mastkey, (CallSite)((Object)name));
            mastTableList.put(tableName.toLowerCase(), mastList);
        }
        map.put("mastTableName", mastTableNameAll);
        map.put("tableName", tableNameAll);
        map.put("mastTable", mastTableList);
        return mastListAll;
    }

    private void childModel(List<FormAllModel> formAllModel, List<Map<String, Object>> child, Map<String, String> tableNameAll) {
        List table = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        for (FormAllModel formModel : table) {
            FormColumnTableModel childList = formModel.getChildList();
            ArrayList<String> thousandsField = new ArrayList<String>();
            ArrayList<String> summaryField = new ArrayList<String>();
            HashMap<Object, String> summaryFieldName = new HashMap<Object, String>();
            String tableName = childList.getTableName();
            List summaryFieldAll = JsonUtil.getJsonToList((String)childList.getSummaryField(), String.class);
            String name = tableNameAll.get(tableName);
            String className = name.substring(0, 1).toLowerCase() + name.substring(1);
            List tableList = childList.getChildList();
            ArrayList<FormColumnModel> childFieldList = new ArrayList<FormColumnModel>();
            for (int i = 0; i < tableList.size(); ++i) {
                String[] fieldList;
                FormColumnModel columnModel = (FormColumnModel)tableList.get(i);
                FieLdsModel fieLdsModel = columnModel.getFieLdsModel();
                ConfigModel config = fieLdsModel.getConfig();
                this.model(fieLdsModel);
                if (fieLdsModel.isThousands()) {
                    thousandsField.add(fieLdsModel.getVModel());
                }
                if (!fieLdsModel.getConfig().getNoShow().booleanValue() && summaryFieldAll.contains(fieLdsModel.getVModel())) {
                    summaryField.add(fieLdsModel.getVModel());
                    summaryFieldName.put(fieLdsModel.getVModel(), config.getLabel());
                    if (StringUtil.isNotEmpty((String)config.getLabelI18nCode())) {
                        summaryFieldName.put(fieLdsModel.getVModel() + "_i18n", config.getLabelI18nCode());
                    }
                }
                ArrayList templateJsonAll = new ArrayList();
                templateJsonAll.addAll(fieLdsModel.getConfig().getTemplateJson());
                List templateJsonModelList = JsonUtil.getJsonToList((String)fieLdsModel.getTemplateJson(), TemplateJsonModel.class);
                templateJsonAll.addAll(templateJsonModelList);
                for (TemplateJsonModel templateJsonModel : templateJsonAll) {
                    if (!StringUtil.isNotEmpty((String)templateJsonModel.getRelationField()) || !Objects.equals(templateJsonModel.getSourceType(), 1) || (fieldList = templateJsonModel.getRelationField().split("-")).length <= 1) continue;
                    templateJsonModel.setRelationField(className + "-" + fieldList[1]);
                }
                for (TemplateJsonModel templateJsonModel : templateJsonModelList) {
                    if (!StringUtil.isNotEmpty((String)templateJsonModel.getRelationField()) || !Objects.equals(templateJsonModel.getSourceType(), 1) || (fieldList = templateJsonModel.getRelationField().split("-")).length <= 1) continue;
                    templateJsonModel.setRelationField(className + "List-" + fieldList[1]);
                }
                fieLdsModel.setTemplateJson(JsonUtil.getObjectToString((Object)templateJsonModelList));
                fieLdsModel.getConfig().setTemplateJson(templateJsonAll);
                FieLdsModel childField = (FieLdsModel)JsonUtil.getJsonToBean((Object)fieLdsModel, FieLdsModel.class);
                ConfigModel configModel = (ConfigModel)JsonUtil.getJsonToBean((Object)config, ConfigModel.class);
                ArrayList defaultValue = configModel.getDefaultValue();
                if (defaultValue instanceof String) {
                    defaultValue = "";
                } else if (defaultValue instanceof BigDecimal) {
                    defaultValue = 0;
                } else if (defaultValue instanceof List) {
                    defaultValue = new ArrayList();
                }
                configModel.setDefaultValue((Object)defaultValue);
                childField.setConfig(configModel);
                FormColumnModel childColumn = new FormColumnModel();
                childColumn.setFieLdsModel(childField);
                childFieldList.add(childColumn);
            }
            childList.setThousandsField(thousandsField);
            childList.setSummaryField(JsonUtil.getObjectToString(summaryField));
            childList.setSummaryFieldName(JsonUtil.getObjectToString(summaryFieldName));
            childList.setChildList(tableList);
            childList.setChildFieldList(childFieldList);
            Map childs = JsonUtil.entityToMap((Object)childList);
            childs.put("className", className);
            childs.put("children", childList);
            child.add(childs);
        }
    }

    private void model(FieLdsModel fieLdsModel) {
        ConfigModel configModel = fieLdsModel.getConfig();
        String jnpfKey = configModel.getJnpfKey();
        if (configModel.getDefaultValue() instanceof String) {
            configModel.setValueType("String");
        }
        if (configModel.getDefaultValue() == null) {
            configModel.setValueType("undefined");
            if ("areaSelect".equals(jnpfKey)) {
                configModel.setDefaultValue(new ArrayList());
                configModel.setValueType(null);
            }
        }
        if ("switch".equals(jnpfKey) && configModel.getDefaultValue() instanceof Boolean) {
            Boolean defaultValue = (Boolean)configModel.getDefaultValue();
            configModel.setDefaultValue((Object)(defaultValue != false ? 1 : 0));
        }
        if ("treeSelect".equals(jnpfKey)) {
            configModel.setValueType(fieLdsModel.getMultiple() != false ? configModel.getValueType() : "undefined");
        }
        fieLdsModel.setConfig(configModel);
    }

    private void formData(Map<String, Object> map, AppGenModel appGenModel, List<FormAllModel> formAllModel) throws IOException {
        FormDataModel model = appGenModel.getModel();
        map.put("formRef", model.getFormRef());
        map.put("hasConfirmAndAddBtn", false);
        map.put("formModel", model.getFormModel());
        map.put("size", model.getSize());
        map.put("labelPosition", model.getLabelPosition());
        map.put("labelWidth", model.getLabelWidth());
        map.put("formRules", model.getFormRules());
        map.put("gutter", model.getGutter());
        map.put("disabled", model.getDisabled());
        map.put("span", model.getSpan());
        map.put("formBtns", model.getFormBtns());
        map.put("idGlobal", model.getIdGlobal());
        map.put("popupType", model.getPopupType());
        map.put("form", formAllModel);
        boolean isPage = this.isPage(appGenModel);
        boolean type = this.isForm(appGenModel);
        boolean isView = this.isView(appGenModel);
        if (isPage) {
            ArrayList columnList = new ArrayList();
            String page = "1";
            String sort = "";
            String defaultSidx = "";
            int pageSize = 20;
            boolean thousands = false;
            SuperJsonModel ruleQueryJson = new SuperJsonModel();
            VisualdevEntity entity = appGenModel.getEntity();
            if (StringUtil.isNotEmpty((String)entity.getColumnData())) {
                String columnData = entity.getColumnData();
                ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)columnData, ColumnDataModel.class);
                page = columnDataModel.getHasPage() != false ? "0" : "1";
                sort = columnDataModel.getSort();
                pageSize = columnDataModel.getPageSize();
                defaultSidx = columnDataModel.getDefaultSidx();
                thousands = columnDataModel.isThousands();
                this.columnData(formAllModel, columnDataModel, map);
                List btns = StringUtil.isNotEmpty((Collection)columnDataModel.getBtnsList()) ? JsonUtil.getJsonToList((Object)columnDataModel.getBtnsList(), BtnData.class) : new ArrayList();
                btns.addAll(StringUtil.isNotEmpty((Collection)columnDataModel.getColumnBtnsList()) ? JsonUtil.getJsonToList((Object)columnDataModel.getColumnBtnsList(), BtnData.class) : new ArrayList());
                columnList.addAll(btns.stream().filter(t -> t.isShow()).collect(Collectors.toList()));
                ruleQueryJson = columnDataModel.getRuleListApp();
                Template7Model templateModel = appGenModel.getTemplate7Model();
                String path = templateModel.getServiceDirectory() + appGenModel.getFileName();
                boolean index = isView ? false : !type;
                String columnPath = path + File.separator + "html" + File.separator + "app" + File.separator + (String)(index ? "index" + File.separator : "") + DataControlUtils.initialLowercase(model.getClassName()) + File.separator;
                File indexfile = new File(columnPath);
                if (!indexfile.exists()) {
                    indexfile.mkdirs();
                }
                String jsonString = JSONObject.toJSONString((Object)JsonUtil.getJsonToJsonArray((String)columnDataModel.getColumnList()), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat});
                SuperQueryUtil.CreateJsFile(jsonString, columnPath + "columnList.js", "columnList");
            }
            List<FormAllModel> mast = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
            List<FormAllModel> mastTable = formAllModel.stream().filter(t -> FormEnum.mastTable.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
            List<String> thousandsField = GenerateCommon.getSummaryThousandList(mast, mastTable, 4);
            map.put("page", page);
            map.put("sort", sort);
            map.put("defaultSidx", defaultSidx);
            map.put("pageSize", pageSize);
            map.put("columnBtnsList", columnList);
            map.put("thousands", thousands);
            map.put("thousandsField", JsonUtil.getObjectToString(thousandsField));
            map.put("ruleQueryJson", JSONObject.toJSONString((Object)ruleQueryJson));
        }
        String pKeyName = appGenModel.getPKeyName();
        map.put("pKeyName", pKeyName);
    }

    private void columnData(List<FormAllModel> formAllModel, ColumnDataModel columnDataModel, Map<String, Object> map) {
        HashMap<String, String> column;
        List mast = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        List mastTable = formAllModel.stream().filter(t -> FormEnum.mastTable.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        List columnListAll = JsonUtil.getJsonToList((String)columnDataModel.getColumnList(), ColumnListField.class);
        HashMap mastTableList = new HashMap();
        HashMap childColumnList = new HashMap();
        ArrayList<ColumnListField> columnMastList = new ArrayList<ColumnListField>();
        for (ColumnListField columnList : columnListAll) {
            String prop = columnList.getProp();
            FormAllModel model = mastTable.stream().filter(t -> t.getFormMastTableModel().getVModel().equals(prop)).findFirst().orElse(null);
            if (model == null) {
                String[] split = prop.split("-");
                if (split.length == 1) {
                    columnMastList.add(columnList);
                    continue;
                }
                ArrayList<ColumnListField> childList = childColumnList.get(split[0]) != null ? (List)childColumnList.get(split[0]) : new ArrayList<ColumnListField>();
                String vModel = split[1];
                columnList.setVModel(vModel);
                childList.add(columnList);
                childColumnList.put(split[0], childList);
                continue;
            }
            FormMastTableModel formMastTableModel = model.getFormMastTableModel();
            String tableName = formMastTableModel.getTable();
            List<FormAllModel> columnListList = mastTableList.get(tableName) != null ? (List)mastTableList.get(tableName) : new ArrayList();
            model.setFormMastTableModel(formMastTableModel);
            columnListList.add(model);
            mastTableList.put(tableName, columnListList);
        }
        map.put("childColumnList", childColumnList);
        map.put("columnList", columnMastList);
        map.put("columnMastList", mastTableList);
        map.put("AppColumnList", columnDataModel.getColumnList());
        List sortListAll = columnListAll.stream().filter(t -> t.getSortable()).collect(Collectors.toList());
        ArrayList<ColumnListField> sortList = new ArrayList<ColumnListField>();
        for (int i = 0; i < sortListAll.size(); ++i) {
            ColumnListField field = (ColumnListField)sortListAll.get(i);
            if (this.noShow.contains(field.getJnpfKey())) continue;
            sortList.add(field);
        }
        map.put("sortList", sortList);
        map.put("defaultSortConfig", columnDataModel.getDefaultSortConfig());
        List searchVOListAll = JsonUtil.getJsonToList((String)columnDataModel.getSearchList(), FieLdsModel.class);
        ArrayList<FieLdsModel> searchVOList = new ArrayList<FieLdsModel>();
        ArrayList<FieLdsModel> mastTableSearch = new ArrayList<FieLdsModel>();
        ArrayList<FieLdsModel> childSearch = new ArrayList<FieLdsModel>();
        ArrayList<FieLdsModel> mastSearch = new ArrayList<FieLdsModel>();
        LinkedList searchAll = new LinkedList();
        LinkedList tabSearch = new LinkedList();
        int isTab = 0;
        for (FieLdsModel columnSearch : searchVOListAll) {
            ArrayList templateJsonAll = new ArrayList();
            ConfigModel config = columnSearch.getConfig();
            templateJsonAll.addAll(config.getTemplateJson());
            List templateJsonModelList = JsonUtil.getJsonToList((String)columnSearch.getTemplateJson(), TemplateJsonModel.class);
            templateJsonAll.addAll(templateJsonModelList);
            config.setTemplateJson(templateJsonAll);
            column = new HashMap<String, String>();
            String vmodel = columnSearch.getId();
            boolean isMast = mast.stream().filter(t -> vmodel.equals(t.getFormColumnModel().getFieLdsModel().getVModel())).count() > 0L;
            boolean isMastTable = mastTable.stream().filter(t -> vmodel.equals(t.getFormMastTableModel().getVModel())).count() > 0L;
            Object value = columnSearch.getValue();
            if (value instanceof String) {
                config.setValueType("String");
            }
            if (isMast) {
                column.put("key", "mastSearch");
                mastSearch.add(columnSearch);
            } else if (isMastTable) {
                column.put("key", "mastTableSearch");
                mastTableSearch.add(columnSearch);
            } else {
                columnSearch.setVModel(vmodel.replaceAll("-", "_"));
                column.put("key", "childSearch");
                childSearch.add(columnSearch);
            }
            column.put("html", (String)columnSearch);
            if (this.noShow.contains(config.getJnpfKey())) continue;
            searchVOList.add(columnSearch);
            searchAll.add(column);
        }
        TabConfigModel tabConfig = ObjectUtil.isNotEmpty((Object)columnDataModel.getTabConfig()) ? columnDataModel.getTabConfig() : new TabConfigModel();
        String fieldsModel = tabConfig.getRelationField();
        if (tabConfig.isOn() && StringUtil.isNotEmpty((String)fieldsModel)) {
            for (FormAllModel item : mast) {
                FieLdsModel fieLdsModel = item.getFormColumnModel().getFieLdsModel();
                if (!fieLdsModel.getVModel().equals(fieldsModel)) continue;
                column = new HashMap();
                column.put("key", "tab");
                column.put("html", (String)fieLdsModel);
                tabSearch.add(column);
                ++isTab;
            }
            for (FormAllModel item : mastTable) {
                FieLdsModel mastTableModel = item.getFormMastTableModel().getMastTable().getFieLdsModel();
                if (!mastTableModel.getVModel().equals(fieldsModel)) continue;
                column = new HashMap();
                column.put("key", "tab");
                column.put("html", (String)mastTableModel);
                tabSearch.add(column);
                ++isTab;
            }
        }
        map.put("tabSearch", tabSearch);
        map.put("hasAllTab", isTab > 0 ? tabConfig.isHasAllTab() : false);
        map.put("isTab", isTab > 0);
        map.put("isKeyword", searchVOList.stream().filter(t -> t.getIsKeyword()).count() > 0L);
        map.put("searchAll", searchAll);
        map.put("searchList", mastTableSearch);
        map.put("childSearch", childSearch);
        map.put("mastsearchList", mastSearch);
        map.put("useDataPermission", columnDataModel.getUseDataPermission() != null ? columnDataModel.getUseDataPermission() : false);
        map.put("useBtnPermission", columnDataModel.getUseBtnPermission() != null ? columnDataModel.getUseBtnPermission() : false);
        map.put("useFormPermission", columnDataModel.getUseFormPermission() != null ? columnDataModel.getUseFormPermission() : false);
        map.put("useColumnPermission", columnDataModel.getUseColumnPermission() != null ? columnDataModel.getUseColumnPermission() : false);
    }

    private Map<String, String> forDataMode(AppGenModel appGenModel, List<FormAllModel> formAllModel) {
        VisualdevEntity entity = appGenModel.getEntity();
        FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFormData(), FormDataModel.class);
        List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        List tableModelList = JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class);
        RecursionForm recursionForm = new RecursionForm(list, tableModelList);
        ArrayList formAllModelAll = new ArrayList();
        FormCloumnUtil.recursionFormGen((RecursionForm)recursionForm, formAllModelAll);
        for (FormAllModel allModel : formAllModelAll) {
            String tipLabel;
            FieLdsModel fieLdsModel;
            boolean add = true;
            if (FormEnum.mast.getMessage().equals(allModel.getJnpfKey())) {
                fieLdsModel = allModel.getFormColumnModel().getFieLdsModel();
                boolean bl = add = !this.noShow.contains(fieLdsModel.getConfig().getJnpfKey());
                if (ObjectUtil.isNotEmpty((Object)fieLdsModel.getConfig().getTipLabel())) {
                    tipLabel = fieLdsModel.getConfig().getTipLabel().replaceAll("\n", " ");
                    fieLdsModel.getConfig().setTipLabel(tipLabel);
                }
            }
            if (FormEnum.mastTable.getMessage().equals(allModel.getJnpfKey())) {
                fieLdsModel = allModel.getFormMastTableModel().getMastTable().getFieLdsModel();
                boolean bl = add = !this.noShow.contains(fieLdsModel.getConfig().getJnpfKey());
                if (ObjectUtil.isNotEmpty((Object)fieLdsModel.getConfig().getTipLabel())) {
                    tipLabel = fieLdsModel.getConfig().getTipLabel().replaceAll("\n", " ");
                    fieLdsModel.getConfig().setTipLabel(tipLabel);
                }
            }
            if (FormEnum.table.getMessage().equals(allModel.getJnpfKey())) {
                List childListAll = allModel.getChildList().getChildList();
                ArrayList<FormColumnModel> childList = new ArrayList<FormColumnModel>();
                for (int k = 0; k < childListAll.size(); ++k) {
                    FormColumnModel formColumnModel = (FormColumnModel)childListAll.get(k);
                    FieLdsModel fieLdsModel2 = formColumnModel.getFieLdsModel();
                    if (ObjectUtil.isNotEmpty((Object)fieLdsModel2.getConfig().getTipLabel())) {
                        String tipLabel2 = fieLdsModel2.getConfig().getTipLabel().replaceAll("\n", " ");
                        fieLdsModel2.getConfig().setTipLabel(tipLabel2);
                    }
                    if (this.noShow.contains(fieLdsModel2.getConfig().getJnpfKey())) continue;
                    childList.add(formColumnModel);
                }
                allModel.getChildList().setChildList(childList);
            }
            if (!add) continue;
            formAllModel.add(allModel);
        }
        HashMap<String, String> tableNameAll = new HashMap<String, String>();
        Map<String, AliasModel> tableAliseMap = appGenModel.getTableAliseMap();
        for (String key : tableAliseMap.keySet()) {
            tableNameAll.put(key, tableAliseMap.get(key).getAliasName());
        }
        return tableNameAll;
    }

    private String tempPath(AppGenModel appGenModel) {
        String tempPath = appGenModel.getTemplatePath();
        VisualdevEntity entity = appGenModel.getEntity();
        DownloadCodeForm downloadCodeForm = appGenModel.getDownloadCodeForm();
        boolean isView = this.isView(appGenModel);
        if (isView) {
            tempPath = "TemplateCode2";
        } else if (VisualWebTypeEnum.FORM.getType().equals(entity.getWebType())) {
            tempPath = downloadCodeForm.getEnableFlow() == 1 ? "TemplateCode5" : "TemplateCode4";
        } else if (VisualWebTypeEnum.FORM_LIST.getType().equals(entity.getWebType())) {
            tempPath = downloadCodeForm.getEnableFlow() == 1 ? "TemplateCode3" : "TemplateCode2";
        }
        return tempPath;
    }

    private boolean isPage(AppGenModel appGenModel) {
        VisualdevEntity entity = appGenModel.getEntity();
        boolean type = !VisualWebTypeEnum.FORM.getType().equals(entity.getWebType());
        return type;
    }

    private boolean isForm(AppGenModel appGenModel) {
        VisualdevEntity entity = appGenModel.getEntity();
        boolean type = VisualWebTypeEnum.FORM_LIST.getType().equals(entity.getWebType()) && appGenModel.getDownloadCodeForm().getEnableFlow() == 0;
        return type;
    }

    private boolean isView(AppGenModel appGenModel) {
        VisualdevEntity entity = appGenModel.getEntity();
        boolean type = VisualWebTypeEnum.DATA_VIEW.getType().equals(entity.getWebType());
        return type;
    }
}

