/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.util;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.StrUtil;
import cn.xuyanwu.spring.file.storage.FileInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.model.ColumnDataModel;
import jnpf.base.model.ExportSelectedModel;
import jnpf.base.model.Template6.ColumnListField;
import jnpf.base.vo.DownloadVO;
import jnpf.config.ConfigValueUtil;
import jnpf.database.model.dbtable.JdbcTableModel;
import jnpf.database.model.interfaces.DbSourceOrDbLink;
import jnpf.excel.ExcelExportStyler;
import jnpf.excel.ExcelHelper;
import jnpf.model.ExcelModel;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.FormDataModel;
import jnpf.model.visualJson.config.HeaderModel;
import jnpf.util.DateUtil;
import jnpf.util.ExcelUtil;
import jnpf.util.FileUploadUtils;
import jnpf.util.JsonUtil;
import jnpf.util.StringUtil;
import jnpf.util.UploaderUtil;
import jnpf.util.context.SpringContext;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class VisualUtils {
    private static final Logger log = LoggerFactory.getLogger(VisualUtils.class);
    private static ConfigValueUtil configValueUtil = (ConfigValueUtil)SpringContext.getBean(ConfigValueUtil.class);

    private static FileInfo getFileInfo(MultipartFile multipartFile, String fileName) {
        String temporaryFilePath = configValueUtil.getTemporaryFilePath();
        FileInfo fileInfo = FileUploadUtils.uploadFile((MultipartFile)multipartFile, (String)temporaryFilePath, (String)fileName);
        return fileInfo;
    }

    public static List<FieLdsModel> deleteMoreVmodel(FieLdsModel model) {
        if ("".equals(model.getVModel()) && model.getConfig().getChildren() != null) {
            List childModelList = JsonUtil.getJsonToList((Object)model.getConfig().getChildren(), FieLdsModel.class);
            return childModelList;
        }
        return null;
    }

    public static String getpKey(DbSourceOrDbLink dbSourceOrDbLink, String mainTable) throws SQLException {
        String pKeyName = "f_id";
        String tmpKey = JdbcTableModel.getPrimaryExculde((DbSourceOrDbLink)dbSourceOrDbLink, (String)mainTable, (String[])new String[]{configValueUtil.getMultiTenantColumn()});
        if (StrUtil.isNotEmpty((CharSequence)tmpKey)) {
            pKeyName = tmpKey;
        }
        return pKeyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DownloadVO createModelExcel(VisualdevEntity visualdevEntity, List<Map<String, Object>> list, Collection<String> keys, String sheetName, String preName, ExcelModel excelModel) {
        boolean SheetTitleWithField = !sheetName.equals("\u8868\u5355\u4fe1\u606f");
        DownloadVO vo = DownloadVO.builder().build();
        try {
            List<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> map : list) {
                int i = 0;
                for (String key : keys) {
                    if (key.toLowerCase().startsWith("tablefield")) {
                        String tableField = key.substring(0, key.indexOf("-"));
                        String field = key.substring(key.indexOf("-") + 1);
                        Object object = map.get(tableField);
                        if (object == null) continue;
                        List childList = (List)object;
                        for (Map childMap : childList) {
                            if (childMap.get(field) == null) continue;
                            ++i;
                        }
                        continue;
                    }
                    Object o = map.get(key);
                    if (o == null) continue;
                    ++i;
                }
                if (map.get("errorsInfo") != null) {
                    ++i;
                }
                if (i <= 0) continue;
                dataList.add(map);
            }
            FormDataModel formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getFormData(), FormDataModel.class);
            List fieLdsModelList = JsonUtil.getJsonToList((String)formDataModel.getFields(), FieLdsModel.class);
            ArrayList<FieLdsModel> allFields = new ArrayList<FieLdsModel>();
            VisualUtils.recursionFields(fieLdsModelList, allFields);
            HashMap mainMap = new HashMap();
            allFields.stream().filter(a -> !a.getConfig().getJnpfKey().equals("table")).forEach(m -> mainMap.put(m.getVModel(), m.getConfig().getLabel()));
            List childFields = allFields.stream().filter(a -> a.getConfig().getJnpfKey().equals("table")).collect(Collectors.toList());
            ArrayList<ExportSelectedModel> allExportModelList = new ArrayList<ExportSelectedModel>();
            for (String string : keys) {
                ExportSelectedModel exportSelectedModel = new ExportSelectedModel();
                if (string.toLowerCase().startsWith("tablefield")) {
                    ArrayList<ExportSelectedModel> childList;
                    String tableField = string.substring(0, string.indexOf("-"));
                    String field = string.substring(string.indexOf("-") + 1);
                    FieLdsModel childTableModel = childFields.stream().filter(t -> tableField.equals(t.getVModel())).findFirst().orElse(null);
                    FieLdsModel fieldKey = childTableModel.getConfig().getChildren().stream().filter(t -> field.equals(t.getVModel())).findFirst().orElse(null);
                    String label = fieldKey.getConfig().getLabel();
                    exportSelectedModel.setTableField(tableField);
                    exportSelectedModel.setField(field);
                    exportSelectedModel.setLabel(label);
                    ExportSelectedModel childModel = allExportModelList.stream().filter(t -> tableField.equals(t.getTableField())).findFirst().orElse(null);
                    if (childModel != null) {
                        childList = childModel.getSelectedModelList();
                        childList.add(exportSelectedModel);
                        continue;
                    }
                    childList = new ArrayList<ExportSelectedModel>();
                    childList.add(exportSelectedModel);
                    ExportSelectedModel newChild = new ExportSelectedModel();
                    newChild.setTableField(childTableModel.getVModel());
                    newChild.setSelectedModelList(childList);
                    newChild.setLabel(childTableModel.getConfig().getLabel());
                    allExportModelList.add(newChild);
                    continue;
                }
                exportSelectedModel.setField(string);
                exportSelectedModel.setLabel((String)mainMap.get(string));
                allExportModelList.add(exportSelectedModel);
            }
            List<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
            if (sheetName.equals("\u9519\u8bef\u62a5\u544a")) {
                entitys.add(new ExcelExportEntity("\u5f02\u5e38\u539f\u56e0", (Object)"errorsInfo", 30));
            }
            for (ExportSelectedModel selectModel : allExportModelList) {
                ExcelExportEntity exportEntity;
                if (StringUtil.isNotEmpty((String)selectModel.getTableField())) {
                    exportEntity = new ExcelExportEntity(selectModel.getLabel() + "(" + selectModel.getTableField() + ")", (Object)selectModel.getTableField());
                    exportEntity.setList(selectModel.getSelectedModelList().stream().map(m -> new ExcelExportEntity(m.getLabel() + (String)(SheetTitleWithField ? "(" + selectModel.getTableField() + "-" + m.getField() + ")" : ""), (Object)m.getField())).collect(Collectors.toList()));
                } else {
                    exportEntity = new ExcelExportEntity(selectModel.getLabel() + (String)(SheetTitleWithField ? "(" + selectModel.getField() + ")" : ""), (Object)selectModel.getField());
                }
                entitys.add(exportEntity);
            }
            ArrayList<ExcelExportEntity> arrayList = new ArrayList<ExcelExportEntity>(entitys);
            ArrayList<Map<String, Object>> mergerList = new ArrayList<Map<String, Object>>(list);
            ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getColumnData(), ColumnDataModel.class);
            List complexHeaderList = columnDataModel.getComplexHeaderList();
            if (!Objects.equals(columnDataModel.getType(), 3) && !Objects.equals(columnDataModel.getType(), 5)) {
                boolean isLineEidtExport = SheetTitleWithField ? Objects.equals(columnDataModel.getType(), 4) : false;
                entitys = VisualUtils.complexHeaderHandel(entitys, complexHeaderList, isLineEidtExport);
                dataList = VisualUtils.complexHeaderDataHandel(dataList, complexHeaderList, isLineEidtExport);
            }
            ExportParams exportParams = new ExportParams(null, sheetName);
            exportParams.setStyle(ExcelExportStyler.class);
            if (sheetName.equals("\u9519\u8bef\u62a5\u544a")) {
                exportParams.setFreezeCol(1);
            }
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    if (dataList.size() == 0) {
                        dataList.add(new HashMap());
                    }
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, dataList);
                    VisualUtils.mergerVertical((Workbook)workbook, arrayList, mergerList);
                    ExcelHelper helper = new ExcelHelper();
                    helper.init((Workbook)workbook, exportParams, entitys, excelModel);
                    helper.doPreHandle();
                    helper.doPostHandle();
                }
                String fileName = preName + ".xls";
                if (sheetName.equals("\u9519\u8bef\u62a5\u544a")) {
                    fileName = preName + "_" + DateUtil.dateNow((String)"yyyyMMddHHmmss") + ".xls";
                }
                MultipartFile multipartFile = ExcelUtil.workbookToCommonsMultipartFile((Workbook)workbook, (String)fileName);
                FileInfo fileInfo = VisualUtils.getFileInfo(multipartFile, fileName);
                vo.setName(fileInfo.getFilename());
                vo.setUrl(UploaderUtil.uploaderFile((String)(fileInfo.getFilename() + "#Temporary")) + "&name=" + fileName);
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    public static void recursionFields(List<FieLdsModel> fieLdsModelList, List<FieLdsModel> allFields) {
        for (FieLdsModel fieLdsModel : fieLdsModelList) {
            if ("table".equals(fieLdsModel.getConfig().getJnpfKey())) {
                allFields.add(fieLdsModel);
                continue;
            }
            if (fieLdsModel.getConfig().getChildren() != null) {
                VisualUtils.recursionFields(fieLdsModel.getConfig().getChildren(), allFields);
                continue;
            }
            if (!StringUtil.isNotEmpty((String)fieLdsModel.getVModel())) continue;
            allFields.add(fieLdsModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DownloadVO createModelExcelApiData(String columnData, List<Map<String, Object>> list, Collection<String> keys, String sheetName, String preName, ExcelModel excelModel) {
        DownloadVO vo = DownloadVO.builder().build();
        try {
            ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)columnData, ColumnDataModel.class);
            List columnListAll = JsonUtil.getJsonToList((String)columnDataModel.getColumnList(), ColumnListField.class);
            List<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
            if (sheetName.equals("\u9519\u8bef\u62a5\u544a")) {
                entitys.add(new ExcelExportEntity("\u5f02\u5e38\u539f\u56e0", (Object)"errorsInfo"));
            }
            for (ColumnListField selectModel : columnListAll) {
                if (!keys.contains(selectModel.getProp())) continue;
                ExcelExportEntity exportEntity = new ExcelExportEntity(selectModel.getLabel());
                exportEntity.setKey((Object)selectModel.getProp());
                exportEntity.setName(selectModel.getLabel());
                entitys.add(exportEntity);
            }
            ArrayList<ExcelExportEntity> mergerEntitys = new ArrayList<ExcelExportEntity>(entitys);
            ArrayList<Map<String, Object>> mergerList = new ArrayList<Map<String, Object>>(list);
            List complexHeaderList = columnDataModel.getComplexHeaderList();
            if (!Objects.equals(columnDataModel.getType(), 3) && !Objects.equals(columnDataModel.getType(), 5)) {
                entitys = VisualUtils.complexHeaderHandel(entitys, complexHeaderList, false);
                list = VisualUtils.complexHeaderDataHandel(list, complexHeaderList, false);
            }
            ExportParams exportParams = new ExportParams(null, sheetName);
            exportParams.setStyle(ExcelExportStyler.class);
            if (sheetName.equals("\u9519\u8bef\u62a5\u544a")) {
                exportParams.setFreezeCol(1);
            }
            exportParams.setStyle(ExcelExportStyler.class);
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    if (list.size() == 0) {
                        list.add(new HashMap());
                    }
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                    VisualUtils.mergerVertical((Workbook)workbook, mergerEntitys, mergerList);
                    ExcelHelper helper = new ExcelHelper();
                    helper.init((Workbook)workbook, exportParams, entitys, excelModel);
                    helper.doPreHandle();
                    helper.doPostHandle();
                }
                String fileName = preName + DateUtil.dateNow((String)"yyyyMMddHHmmss") + ".xls";
                MultipartFile multipartFile = ExcelUtil.workbookToCommonsMultipartFile((Workbook)workbook, (String)fileName);
                FileInfo fileInfo = VisualUtils.getFileInfo(multipartFile, fileName);
                vo.setName(fileInfo.getFilename());
                vo.setUrl(UploaderUtil.uploaderFile((String)(fileInfo.getFilename() + "#Temporary")) + "&name=" + fileName);
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    public static String exampleExcelMessage(FieLdsModel model) {
        String value = "";
        String jnpfKey = model.getConfig().getJnpfKey();
        boolean multiple = model.getMultiple();
        if ("checkbox".equals(jnpfKey)) {
            value = "\u9009\u9879\u4e00,\u9009\u9879\u4e8c";
        } else if ("select".equals(jnpfKey)) {
            value = multiple ? "\u9009\u9879\u4e00,\u9009\u9879\u4e8c" : "";
        } else if ("cascader".equals(jnpfKey)) {
            value = multiple ? "\u9009\u98791/\u9009\u98791-1,\u9009\u98792/\u9009\u98792-1" : "\u9009\u98791/\u9009\u98791-1";
        } else if ("datePicker".equals(jnpfKey)) {
            value = model.getFormat();
        } else if ("timePicker".equals(jnpfKey)) {
            value = model.getFormat();
        } else if ("organizeSelect".equals(jnpfKey)) {
            value = multiple ? "\u516c\u53f8\u540d\u79f0/\u90e8\u95e8\u540d\u79f0,\u516c\u53f8\u540d\u79f01/\u90e8\u95e8\u540d\u79f01" : "\u516c\u53f8\u540d\u79f0/\u90e8\u95e8\u540d\u79f0";
        } else if ("depSelect".equals(jnpfKey)) {
            value = multiple ? "\u90e8\u95e8\u540d\u79f0/\u90e8\u95e8\u7f16\u7801,\u90e8\u95e8\u540d\u79f01/\u90e8\u95e8\u7f16\u78011" : "\u90e8\u95e8\u540d\u79f0/\u90e8\u95e8\u7f16\u7801";
        } else if ("posSelect".equals(jnpfKey)) {
            value = multiple ? "\u5c97\u4f4d\u540d\u79f0/\u5c97\u4f4d\u7f16\u7801,\u5c97\u4f4d\u540d\u79f01/\u5c97\u4f4d\u7f16\u78011" : "\u5c97\u4f4d\u540d\u79f0/\u5c97\u4f4d\u7f16\u7801";
        } else if ("userSelect".equals(jnpfKey)) {
            value = multiple ? "\u59d3\u540d/\u8d26\u53f7,\u59d3\u540d1/\u8d26\u53f71" : "\u59d3\u540d/\u8d26\u53f7";
        } else if ("roleSelect".equals(jnpfKey)) {
            value = multiple ? "\u89d2\u8272\u540d\u79f0/\u89d2\u8272\u7f16\u7801,\u89d2\u8272\u540d\u79f01/\u89d2\u8272\u7f16\u78011" : "\u89d2\u8272\u540d\u79f0/\u89d2\u8272\u7f16\u7801";
        } else if ("groupSelect".equals(jnpfKey)) {
            value = multiple ? "\u5206\u7ec4\u540d\u79f0/\u5206\u7ec4\u7f16\u7801,\u5206\u7ec4\u540d\u79f01/\u5206\u7ec4\u7f16\u78011" : "\u5206\u7ec4\u540d\u79f0/\u5206\u7ec4\u7f16\u7801";
        } else if ("usersSelect".equals(jnpfKey)) {
            value = multiple ? "\u59d3\u540d/\u8d26\u53f7,\u516c\u53f8\u540d\u79f0,\u90e8\u95e8\u540d\u79f0/\u90e8\u95e8\u7f16\u7801,\u5c97\u4f4d\u540d\u79f0/\u5c97\u4f4d\u7f16\u7801,\u89d2\u8272\u540d\u79f0/\u89d2\u8272\u7f16\u7801,\u5206\u7ec4\u540d\u79f0/\u5206\u7ec4\u7f16\u7801" : "\u59d3\u540d/\u8d26\u53f7";
        } else if ("treeSelect".equals(jnpfKey)) {
            value = multiple ? "\u9009\u98791,\u9009\u98792" : "\u9009\u98791";
        } else if ("areaSelect".equals(jnpfKey)) {
            Integer level = model.getLevel();
            if (level == 0) {
                String string = value = multiple ? "\u7701,\u77011" : "\u7701";
            }
            if (level == 1) {
                String string = value = multiple ? "\u7701/\u5e02,\u77011/\u5e021" : "\u7701/\u5e02";
            }
            if (level == 2) {
                String string = value = multiple ? "\u7701/\u5e02/\u533a,\u77011/\u5e021/\u533a1" : "\u7701/\u5e02/\u533a";
            }
            if (level == 3) {
                value = multiple ? "\u7701/\u5e02/\u533a/\u8857\u9053,\u77011/\u5e021/\u533a1/\u8857\u90531" : "\u7701/\u5e02/\u533a/\u8857\u9053";
            }
        } else {
            value = "";
        }
        return value;
    }

    public static List<ExcelExportEntity> complexHeaderHandel(List<ExcelExportEntity> dataList, List<HeaderModel> complexHeaderList, boolean isLineEidtExport) {
        ArrayList complexHeaderListStr = new ArrayList();
        complexHeaderList.forEach(item -> complexHeaderListStr.addAll(item.getChildColumns()));
        HashMap<String, Integer> complexMap1 = new HashMap<String, Integer>();
        ArrayList<ExcelExportEntity> dataListRes = new ArrayList<ExcelExportEntity>();
        int n = 0;
        for (ExcelExportEntity entity : dataList) {
            String entityKey;
            String string = entityKey = isLineEidtExport ? entity.getKey().toString().split("_name")[0] : entity.getKey().toString();
            if (complexHeaderListStr.contains(entityKey)) {
                for (HeaderModel item2 : complexHeaderList) {
                    ArrayList<ExcelExportEntity> list;
                    ExcelExportEntity export;
                    if (item2.getChildColumns() == null || item2.getChildColumns().size() <= 0 || !item2.getChildColumns().contains(entityKey)) continue;
                    if (complexMap1.get(item2.getId()) == null) {
                        complexMap1.put(item2.getId(), n);
                        export = new ExcelExportEntity(item2.getFullName() + "(" + item2.getId() + ")", (Object)item2.getId());
                        list = new ArrayList<ExcelExportEntity>();
                        export.setList(list);
                        dataListRes.add(export);
                        ++n;
                    } else {
                        export = (ExcelExportEntity)dataListRes.get((Integer)complexMap1.get(item2.getId()));
                    }
                    list = export.getList() != null ? export.getList() : new ArrayList();
                    list.add(entity);
                    export.setList(list);
                    dataListRes.set((Integer)complexMap1.get(item2.getId()), export);
                }
                continue;
            }
            dataListRes.add(entity);
            ++n;
        }
        return dataListRes;
    }

    public static List<Map<String, Object>> complexHeaderDataHandel(List<Map<String, Object>> dataListRes, List<HeaderModel> complexHeaderList, boolean isLineEidtExport) {
        ArrayList complexHeaderListStr = new ArrayList();
        complexHeaderList.forEach(item -> complexHeaderListStr.addAll(item.getChildColumns()));
        ArrayList<String> complexMap1 = new ArrayList<String>();
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(dataListRes);
        for (Map map : dataList) {
            HashSet keyset = new HashSet(map.keySet());
            for (String key : keyset) {
                String keyName = isLineEidtExport ? key.split("_name")[0] : key;
                if (!complexHeaderListStr.contains(keyName)) continue;
                for (HeaderModel item2 : complexHeaderList) {
                    if (!item2.getChildColumns().contains(keyName)) continue;
                    if (complexMap1.contains(item2.getId())) {
                        List list1 = (List)map.get(item2.getId());
                        final HashMap obj = list1 != null && list1.get(0) != null ? (Map)list1.get(0) : new HashMap();
                        obj.put(key, map.get(key));
                        map.put(item2.getId(), new ArrayList(){
                            {
                                this.add(obj);
                            }
                        });
                        continue;
                    }
                    complexMap1.add(item2.getId());
                    final HashMap obj = new HashMap();
                    obj.put(key, map.get(key));
                    map.put(item2.getId(), new ArrayList(){
                        {
                            this.add(obj);
                        }
                    });
                }
            }
        }
        return dataList;
    }

    public static List<Map<String, Object>> complexHeaderHandelOnline(List<Map<String, Object>> dataList, List<HeaderModel> complexHeaderList) {
        ArrayList complexHeaderListStr = new ArrayList();
        complexHeaderList.forEach(item -> complexHeaderListStr.addAll(item.getChildColumns()));
        List uploadColumn = dataList.stream().map(t -> t.get("id")).collect(Collectors.toList());
        HashMap<String, Integer> complexMap1 = new HashMap<String, Integer>();
        ArrayList<Map<String, Object>> dataListRes = new ArrayList<Map<String, Object>>();
        int n = 0;
        for (HeaderModel headerModel : complexHeaderList) {
            List complexHasColumn;
            if (headerModel.getChildColumns().size() <= 0 || (complexHasColumn = headerModel.getChildColumns().stream().filter(t -> uploadColumn.contains(t)).collect(Collectors.toList())).size() <= 0) continue;
            complexMap1.put(headerModel.getId(), n);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", headerModel.getId());
            map.put("fullName", headerModel.getFullName());
            map.put("jnpfKey", "complexHeader");
            dataListRes.add(map);
            ++n;
        }
        for (Map map : dataList) {
            if (complexHeaderListStr.contains(map.get("id"))) {
                for (HeaderModel item3 : complexHeaderList) {
                    if (!item3.getChildColumns().contains(map.get("id"))) continue;
                    Map map2 = (Map)dataListRes.get((Integer)complexMap1.get(item3.getId()));
                    List<Map> listmap = new ArrayList<Map>();
                    if (map2.get("children") == null) {
                        listmap.add(map);
                    } else {
                        listmap = (List)map2.get("children");
                        listmap.add(map);
                    }
                    map2.put("children", listmap);
                    dataListRes.set((Integer)complexMap1.get(item3.getId()), map2);
                }
                continue;
            }
            dataListRes.add(map);
        }
        return dataListRes;
    }

    public static List<Map<String, Object>> complexImportsDataOnline(List<Map<String, Object>> dataList, VisualdevEntity entity) {
        ArrayList<Map<String, Object>> listRes = new ArrayList();
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)entity.getColumnData(), ColumnDataModel.class);
        List complexHeaderList = columnDataModel.getComplexHeaderList();
        if (!Objects.equals(columnDataModel.getType(), 3) && !Objects.equals(columnDataModel.getType(), 5)) {
            for (Map<String, Object> mapone : dataList) {
                for (HeaderModel item : complexHeaderList) {
                    List listC;
                    Object remove = mapone.remove(item.getId());
                    if (remove == null || (listC = (List)remove).size() <= 0) continue;
                    mapone.putAll((Map)listC.get(0));
                }
                listRes.add(mapone);
            }
        } else {
            listRes = dataList;
        }
        return listRes;
    }

    public static void mergerVertical(Workbook workbook, List<ExcelExportEntity> entityList, List<Map<String, Object>> dataList) {
        Sheet sheet = workbook.getSheetAt(0);
        int firstRow = 0;
        int lastRow = 0;
        for (Map<String, Object> obj : dataList) {
            int size = 1;
            List hasChildList = entityList.stream().filter(t -> t.getKey().toString().toLowerCase().contains("tablefield")).collect(Collectors.toList());
            if (hasChildList.size() > 0) {
                for (ExcelExportEntity item : hasChildList) {
                    List arr;
                    String key = String.valueOf(item.getKey());
                    if (!(obj.get(key) instanceof List) || (arr = (List)obj.get(key)).size() <= size) continue;
                    size = arr.size();
                }
            }
            int headSize = 1;
            List collect = entityList.stream().filter(t -> t.getList() != null).collect(Collectors.toList());
            if (collect.size() >= 1) {
                headSize = 2;
            }
            if (size == 0) {
                lastRow = firstRow = lastRow == 0 ? headSize : lastRow + 1;
                continue;
            }
            firstRow = lastRow == 0 ? headSize : lastRow + 1;
            lastRow = firstRow + size - 1;
            int m = 0;
            for (int n = 0; n < entityList.size(); ++n) {
                ExcelExportEntity export = entityList.get(n);
                if (export.getList() == null && firstRow != lastRow) {
                    sheet.addMergedRegionUnsafe(new CellRangeAddress(firstRow, lastRow, m, m));
                }
                if (export.getList() != null) {
                    m += export.getList().size();
                    continue;
                }
                ++m;
            }
        }
    }
}

