/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import jnpf.base.model.dbtable.vo.DbFieldVO;
import jnpf.base.model.form.VisualTableModel;
import jnpf.base.util.ConcurrencyUtils;
import jnpf.base.util.ServiceBaseUtil;
import jnpf.constant.MsgCode;
import jnpf.database.model.dbfield.DbFieldModel;
import jnpf.database.model.dbtable.DbTableFieldModel;
import jnpf.database.model.entity.DbLinkEntity;
import jnpf.database.util.DataSourceUtil;
import jnpf.exception.WorkFlowException;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.TableFields;
import jnpf.model.visualJson.TableModel;
import jnpf.model.visualJson.analysis.FormColumnTableModel;
import jnpf.model.visualJson.analysis.FormEnum;
import jnpf.util.JsonUtil;
import jnpf.util.RandomUtil;
import jnpf.util.StringUtil;
import jnpf.util.TableFeildsEnum;
import jnpf.util.visiual.JnpfKeyConsts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VisualDevTableCre {
    private static final Logger log = LoggerFactory.getLogger(VisualDevTableCre.class);
    @Autowired
    private ServiceBaseUtil serviceUtil;
    @Autowired
    private DataSourceUtil dataSourceUtil;

    private void fieldsTableName(JSONArray jsonArray, List<TableModel> tableModels) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            ArrayList childrenListAll = new ArrayList(){
                {
                    this.add(FormEnum.card.getMessage());
                    this.add(FormEnum.row.getMessage());
                    this.add(FormEnum.tab.getMessage());
                    this.add(FormEnum.collapse.getMessage());
                    this.add(FormEnum.collapseItem.getMessage());
                    this.add(FormEnum.tabItem.getMessage());
                    this.add(FormEnum.tableGrid.getMessage());
                    this.add(FormEnum.tableGridTr.getMessage());
                    this.add(FormEnum.tableGridTd.getMessage());
                    this.add(FormEnum.STEPS.getMessage());
                    this.add(FormEnum.STEP_ITEM.getMessage());
                }
            };
            JSONObject jsonObject = (JSONObject)jsonArray.get(i);
            String jnpfkey = jsonObject.getJSONObject("__config__").getString("jnpfKey");
            if (childrenListAll.contains(jnpfkey) || StringUtil.isEmpty((String)jnpfkey)) {
                JSONArray childArray = jsonObject.getJSONObject("__config__").getJSONArray("children");
                this.fieldsTableName(childArray, tableModels);
                jsonObject.getJSONObject("__config__").put("children", (Object)childArray);
                continue;
            }
            if (FormEnum.table.getMessage().equals(jnpfkey)) {
                JSONArray childrenList = new JSONArray();
                JSONArray children = jsonObject.getJSONObject("__config__").getJSONArray("children");
                String tableModel = "";
                for (int k = 0; k < children.size(); ++k) {
                    JSONObject childrenObject = (JSONObject)children.get(k);
                    this.fieldsModel(childrenObject, tableModels);
                    if (StringUtil.isEmpty((String)tableModel)) {
                        tableModel = childrenObject.getJSONObject("__config__").getString("relationTable");
                    }
                    childrenList.add((Object)childrenObject);
                }
                jsonObject.getJSONObject("__config__").put("tableName", (Object)tableModel);
                jsonObject.getJSONObject("__config__").put("children", (Object)childrenList);
                continue;
            }
            this.fieldsModel(jsonObject, tableModels);
        }
    }

    private TableModel fieldsModel(JSONObject jsonObject, List<TableModel> tableModels) {
        String model;
        Boolean isSubTable;
        List childTableAll;
        TableModel childTableaa;
        String vModel = jsonObject.getString("__vModel__");
        String relationField = StringUtil.isNotEmpty((String)jsonObject.getString("relationField")) ? jsonObject.getString("relationField") : "";
        String jnpfkey = jsonObject.getJSONObject("__config__").getString("jnpfKey");
        TableModel tableName = tableModels.stream().filter(t -> "1".equals(t.getTypeId())).findFirst().orElse(null);
        if (tableName != null) {
            jsonObject.getJSONObject("__config__").put("tableName", (Object)tableName.getTable());
        }
        if ((childTableaa = (TableModel)(childTableAll = tableModels.stream().filter(t -> "0".equals(t.getTypeId())).collect(Collectors.toList())).stream().filter(t -> t.getFields().stream().filter(k -> k.getField().equals(vModel)).count() > 0L).findFirst().orElse(null)) != null) {
            jsonObject.getJSONObject("__config__").put("relationTable", (Object)childTableaa.getTable());
        }
        if ((FormEnum.relationFormAttr.getMessage().equals(jnpfkey) || FormEnum.popupAttr.getMessage().equals(jnpfkey)) && StringUtil.isNotEmpty((String)relationField)) {
            isSubTable = jsonObject.getJSONObject("__config__").getBooleanValue("isSubTable");
            model = relationField.split("_jnpfTable_")[0];
            jsonObject.put("relationField", (Object)(model + "_jnpfTable_" + tableName.getTable() + (isSubTable != false ? "0" : "1")));
        }
        if ("billRule".equals(jnpfkey) && StringUtil.isNotEmpty((String)relationField)) {
            isSubTable = jsonObject.getJSONObject("__config__").getBooleanValue("isSubTable");
            model = relationField.split("_jnpfTable_")[0];
            jsonObject.put("relationField", (Object)(model + "_jnpfTable_" + tableName.getTable() + (isSubTable != false ? "0" : "1")));
        }
        return childTableaa;
    }

    public List<TableModel> tableList(VisualTableModel visualTableModel) throws WorkFlowException {
        JSONArray jsonArray = visualTableModel.getJsonArray();
        List formAllModel = visualTableModel.getFormAllModel();
        String table = visualTableModel.getTable();
        String linkId = visualTableModel.getLinkId();
        String fullName = visualTableModel.getFullName();
        int primaryKey = visualTableModel.getPrimaryKey();
        LinkedList<TableModel> tableModelList = new LinkedList<TableModel>();
        HashMap<String, CallSite> tableNameList = new HashMap<String, CallSite>();
        DbLinkEntity dbLink = this.serviceUtil.getDbLink(linkId);
        String type = dbLink != null ? dbLink.getDbType() : this.dataSourceUtil.getDbType();
        boolean isUpperCase = "DM".equals(type) || "Oracle".equals(type);
        boolean isLowerCase = "PostgreSQL".equals(type) || "KingbaseES".equals(type);
        table = this.tableName(table, isUpperCase, isLowerCase);
        String relationField = this.tableName(TableFeildsEnum.FID.getField(), isUpperCase, isLowerCase);
        String tableField = this.tableName(TableFeildsEnum.FOREIGN.getField(), isUpperCase, isLowerCase);
        try {
            ArrayList<DbFieldModel> fieldList = new ArrayList<DbFieldModel>();
            HashMap<String, ArrayList<DbFieldModel>> tableListAll = new HashMap<String, ArrayList<DbFieldModel>>();
            for (Object model : formAllModel) {
                if (FormEnum.mast.getMessage().equals(model.getJnpfKey())) {
                    FieLdsModel fieLdsModel = model.getFormColumnModel().getFieLdsModel();
                    this.fieldList(fieLdsModel, table, fieldList);
                    continue;
                }
                if (!FormEnum.table.getMessage().equals(model.getJnpfKey())) continue;
                String tableName = "ct" + RandomUtil.uuId();
                FormColumnTableModel fieLdsModel = model.getChildList();
                ArrayList<DbFieldModel> tableList = new ArrayList<DbFieldModel>();
                String tableModel = fieLdsModel.getTableModel();
                List fieldsList = fieLdsModel.getChildList().stream().map(t -> t.getFieLdsModel()).collect(Collectors.toList());
                for (FieLdsModel tableFieLdsModel : fieldsList) {
                    this.fieldList(tableFieLdsModel, tableName, tableList);
                }
                this.dbTableField(tableList, true, primaryKey, isLowerCase, tableField, relationField);
                tableNameList.put(tableModel, (CallSite)((Object)tableName));
                tableListAll.put(tableModel, tableList);
            }
            this.dbTableField(fieldList, false, primaryKey, isLowerCase, tableField, relationField);
            fieldList.add(ConcurrencyUtils.getDbFieldModel(TableFeildsEnum.TENANTID, isUpperCase, isLowerCase));
            fieldList.add(ConcurrencyUtils.getDbFieldModel(TableFeildsEnum.FLOWID, isUpperCase, isLowerCase));
            fieldList.add(ConcurrencyUtils.getDbFieldModel(TableFeildsEnum.VERSION, isUpperCase, isLowerCase));
            fieldList.add(ConcurrencyUtils.getDbFieldModel(TableFeildsEnum.FLOWTASKID, isUpperCase, isLowerCase));
            if (visualTableModel.getLogicalDelete().booleanValue()) {
                fieldList.add(ConcurrencyUtils.getDbFieldModel(TableFeildsEnum.DELETEMARK, isUpperCase, isLowerCase));
                fieldList.add(ConcurrencyUtils.getDbFieldModel(TableFeildsEnum.DELETETIME, isUpperCase, isLowerCase));
                fieldList.add(ConcurrencyUtils.getDbFieldModel(TableFeildsEnum.DELETEUSERID, isUpperCase, isLowerCase));
            }
            ArrayList<DbTableFieldModel> dbTableList = new ArrayList<DbTableFieldModel>();
            for (String key : tableListAll.keySet()) {
                String tableName = this.tableName((String)tableNameList.get(key), isUpperCase, isLowerCase);
                List datableList = (List)tableListAll.get(key);
                datableList.add(ConcurrencyUtils.getDbFieldModel(TableFeildsEnum.TENANTID, isUpperCase, isLowerCase));
                if (visualTableModel.getLogicalDelete().booleanValue()) {
                    datableList.add(ConcurrencyUtils.getDbFieldModel(TableFeildsEnum.DELETEMARK, isUpperCase, isLowerCase));
                    datableList.add(ConcurrencyUtils.getDbFieldModel(TableFeildsEnum.DELETETIME, isUpperCase, isLowerCase));
                    datableList.add(ConcurrencyUtils.getDbFieldModel(TableFeildsEnum.DELETEUSERID, isUpperCase, isLowerCase));
                }
                DbTableFieldModel dbTable = this.dbTable(linkId, tableName, datableList, true, fullName);
                dbTableList.add(dbTable);
                this.tableModel(tableModelList, datableList, tableName, table, true, tableField, relationField);
            }
            this.tableModel(tableModelList, fieldList, table, table, false, tableField, relationField);
            DbTableFieldModel dbTable = this.dbTable(linkId, table, fieldList, false, fullName);
            dbTableList.add(dbTable);
            this.serviceUtil.createTable(dbTableList);
            this.fieldsTableName(jsonArray, tableModelList);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8868\u65b0\u589e\u9519\u8bef:{}", (Object)e.getMessage());
            throw new WorkFlowException(MsgCode.FM013.get(new Object[]{e.getMessage()}), (Throwable)e);
        }
        return tableModelList;
    }

    private String tableName(String tableName, boolean isUpperCase, boolean isLowerCase) {
        String resultName = isUpperCase ? tableName.toUpperCase() : (isLowerCase ? tableName.toLowerCase() : tableName);
        return resultName;
    }

    private void fieldList(FieLdsModel fieLdsModel, String table, List<DbFieldModel> tableList) {
        String vmodel = fieLdsModel.getVModel();
        String lable = fieLdsModel.getConfig().getLabel();
        String jnpfkey = fieLdsModel.getConfig().getJnpfKey();
        fieLdsModel.getConfig().setTableName(table);
        if (StringUtil.isNotEmpty((String)vmodel)) {
            DbFieldModel fieldForm = new DbFieldModel();
            fieldForm.setNullSign("NULL");
            fieldForm.setDataType("varchar");
            fieldForm.setLength("255");
            fieldForm.setIsPrimaryKey(Boolean.valueOf(false));
            if (StringUtil.isNotEmpty((String)fieLdsModel.getVModel())) {
                ArrayList date;
                if (JnpfKeyConsts.getTextField().contains(jnpfkey)) {
                    fieldForm.setDataType("text");
                }
                if ((date = new ArrayList(){
                    {
                        this.add("modifyTime");
                        this.add("createTime");
                        this.add("datePicker");
                    }
                }).contains(jnpfkey)) {
                    fieldForm.setDataType("datetime");
                }
                if ("inputNumber".equals(jnpfkey) || "calculate".equals(jnpfkey) || "slider".equals(jnpfkey)) {
                    fieldForm.setDataType("decimal");
                    String precision = "15";
                    if (fieLdsModel.getPrecision() != null) {
                        precision = String.valueOf(fieLdsModel.getPrecision());
                    }
                    fieldForm.setLength("38," + precision);
                }
                if ("rate".equals(jnpfkey)) {
                    fieldForm.setDataType("decimal");
                    fieldForm.setLength("38,1");
                }
                if ("location".equals(jnpfkey)) {
                    fieldForm.setLength("500");
                }
                fieldForm.setField(vmodel);
                fieldForm.setComment(lable);
                tableList.add(fieldForm);
            }
        }
    }

    private void dbTableField(List<DbFieldModel> tableList, boolean isforeign, int primaryKey, boolean isPostgreOrKingbase, String tableField, String relationField) {
        boolean autoPrimaryKey;
        boolean bl = autoPrimaryKey = primaryKey == 2;
        String dataType = autoPrimaryKey ? (isPostgreOrKingbase ? "int" : "bigint") : "varchar";
        DbFieldModel tableKey = new DbFieldModel();
        tableKey.setNullSign("NOT NULL");
        tableKey.setDataType(dataType);
        tableKey.setLength(TableFeildsEnum.FID.getLength());
        tableKey.setIsPrimaryKey(Boolean.valueOf(true));
        tableKey.setField(relationField);
        tableKey.setIsAutoIncrement(Boolean.valueOf(autoPrimaryKey));
        tableKey.setComment(TableFeildsEnum.FID.getComment());
        tableList.add(tableKey);
        if (isforeign) {
            DbFieldModel tableForeignKey = new DbFieldModel();
            tableForeignKey.setNullSign("NULL");
            tableForeignKey.setDataType(dataType);
            tableForeignKey.setLength(TableFeildsEnum.FOREIGN.getLength());
            tableForeignKey.setIsPrimaryKey(Boolean.valueOf(false));
            tableForeignKey.setField(tableField);
            tableForeignKey.setComment(TableFeildsEnum.FOREIGN.getComment());
            tableList.add(tableForeignKey);
        }
    }

    private void tableModel(List<TableModel> tableModelList, List<DbFieldModel> dbtable, String table, String mastTable, boolean isforeign, String tableField, String relationField) {
        TableModel tableModel = new TableModel();
        tableModel.setRelationField(isforeign ? relationField : "");
        tableModel.setRelationTable(isforeign ? mastTable : "");
        tableModel.setTable(table);
        tableModel.setComment(isforeign ? "\u5b50\u8868" : "\u4e3b\u8868");
        tableModel.setTableField(isforeign ? tableField : "");
        tableModel.setTypeId(isforeign ? "0" : "1");
        List voList = dbtable.stream().map(DbFieldVO::new).collect(Collectors.toList());
        tableModel.setFields(JsonUtil.getJsonToList(voList, TableFields.class));
        tableModelList.add(tableModel);
    }

    private DbTableFieldModel dbTable(String linkId, String tableName, List<DbFieldModel> tableFieldList, boolean isforeign, String fullName) {
        String s;
        DbTableFieldModel dbTable = new DbTableFieldModel();
        dbTable.setDbLinkId(linkId);
        dbTable.setTable(tableName);
        dbTable.setDbFieldModelList(tableFieldList);
        String string = s = isforeign ? "\u5b50\u8868" : "\u4e3b\u8868";
        if (fullName.contains("&")) {
            fullName = fullName.replace("&", " ");
        }
        dbTable.setComment(String.format("%s-%s", fullName, s));
        return dbTable;
    }
}

