/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jnpf.base.entity.BillNumEntity;
import jnpf.base.service.BillNumService;
import jnpf.constant.MsgCode;
import jnpf.exception.DataException;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.config.ConfigModel;
import jnpf.model.visualJson.config.PrefixSuffixModel;
import jnpf.model.visualJson.config.RuleConfig;
import jnpf.util.DateUtil;
import jnpf.util.JsonUtil;
import jnpf.util.PadUtil;
import jnpf.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VisualBillUtil {
    private final Object $lock = new Object[0];
    @Autowired
    private BillNumService billNumService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getBillNumber(String visualId, FieLdsModel fieLdsModel, Map<String, Object> data, Object thisValue) {
        Object object = this.$lock;
        synchronized (object) {
            String jnpfKey = fieLdsModel.getConfig().getJnpfKey();
            if ("billRule".equals(jnpfKey) && fieLdsModel.getConfig().getRuleType() != null && Objects.equals(fieLdsModel.getConfig().getRuleType(), 2) && ObjectUtil.isEmpty((Object)thisValue)) {
                String suffFixStr;
                ConfigModel config = fieLdsModel.getConfig();
                RuleConfig ruleConfig = config.getRuleConfig();
                Integer type = ruleConfig.getType();
                String flowId = null;
                if (data.get("flowId") != null && StringUtil.isNotEmpty((String)data.get("flowId").toString())) {
                    flowId = data.get("flowId").toString();
                }
                StringBuilder strNumber = new StringBuilder();
                String preFixStr = VisualBillUtil.setPreSuffFix(data, ruleConfig.getPrefixList());
                if (StringUtil.isNotEmpty((String)preFixStr) && preFixStr.length() > 100) {
                    throw new DataException(MsgCode.VS027.get(new Object[]{config.getLabel()}));
                }
                strNumber.append(preFixStr);
                String ruleId = config.getFormId();
                BillNumEntity billNum = this.billNumService.getBillNum(ruleId, visualId, flowId);
                switch (type) {
                    case 2: {
                        if (ObjectUtil.equal((Object)ruleConfig.getRandomType(), (Object)1)) {
                            strNumber.append(RandomUtil.randomNumbers((int)ruleConfig.getRandomDigit()));
                        } else {
                            strNumber.append(RandomUtil.randomStringUpper((int)ruleConfig.getRandomDigit()));
                        }
                        if (billNum == null) break;
                        this.billNumService.removeByRuleId(ruleId, visualId, flowId);
                        break;
                    }
                    case 3: {
                        strNumber.append(IdUtil.randomUUID().toUpperCase());
                        if (billNum == null) break;
                        this.billNumService.removeByRuleId(ruleId, visualId, flowId);
                        break;
                    }
                    default: {
                        RuleConfig rule = (RuleConfig)BeanUtil.copyProperties((Object)ruleConfig, RuleConfig.class, (String[])new String[0]);
                        rule.setRandomDigit(null);
                        rule.setRandomType(null);
                        String ruleJosn = JsonUtil.getObjectToString((Object)rule);
                        String dateFormat = VisualBillUtil.getTimeFormat(ruleConfig.getDateFormat());
                        String dateValue = "no".equals(dateFormat) ? "" : DateUtil.dateNow((String)dateFormat);
                        Integer digit = ruleConfig.getDigit();
                        StringBuilder maxStr = new StringBuilder();
                        for (int i = 0; i < digit; ++i) {
                            maxStr.append("9");
                        }
                        Integer maxValue = Integer.parseInt(maxStr.toString());
                        Integer startNumber = Integer.parseInt(ruleConfig.getStartNumber());
                        Integer thisNum = 0;
                        if (billNum != null) {
                            String dateValueOld;
                            if (ruleJosn.equals(billNum.getRuleConfig()) && (StringUtil.isEmpty((String)(dateValueOld = billNum.getDateValue())) || dateValueOld.equals(dateValue))) {
                                thisNum = billNum.getNum() + 1;
                                if (startNumber + thisNum > maxValue) {
                                    thisNum = 0;
                                }
                            }
                        } else {
                            billNum = new BillNumEntity();
                        }
                        billNum.setRuleId(ruleId);
                        billNum.setVisualId(visualId);
                        billNum.setFlowId(flowId);
                        billNum.setDateValue(dateValue);
                        billNum.setNum(thisNum);
                        billNum.setRuleConfig(ruleJosn);
                        this.billNumService.saveBillNum(billNum);
                        if (!"no".equals(dateValue)) {
                            strNumber.append(dateValue);
                        }
                        strNumber.append(PadUtil.padRight((String)String.valueOf(startNumber + thisNum), (int)ruleConfig.getDigit(), (char)'0'));
                    }
                }
                if (StringUtil.isNotEmpty((String)(suffFixStr = VisualBillUtil.setPreSuffFix(data, ruleConfig.getSuffixList()))) && suffFixStr.length() > 100) {
                    throw new DataException(MsgCode.VS027.get(new Object[]{config.getLabel()}));
                }
                strNumber.append(suffFixStr);
                return strNumber.toString();
            }
            return thisValue;
        }
    }

    private static String getTimeFormat(String dateFor) {
        String dateForValue = "no";
        if (StringUtil.isEmpty((String)dateFor)) {
            return dateForValue;
        }
        switch (dateFor) {
            case "YYYY": {
                dateForValue = "yyyy";
                break;
            }
            case "YYYYMM": {
                dateForValue = "yyyyMM";
                break;
            }
            case "YYYYMMDD": {
                dateForValue = "yyyyMMdd";
                break;
            }
            case "YYYYMMDDHH": {
                dateForValue = "yyyyMMddHH";
                break;
            }
            case "YYYYMMDDHHmm": {
                dateForValue = "yyyyMMddHHmm";
                break;
            }
            case "YYYYMMDDHHmmss": {
                dateForValue = "yyyyMMddHHmmss";
                break;
            }
            case "YYYYMMDDHHmmssSSS": {
                dateForValue = "yyyyMMddHHmmssSSS";
            }
        }
        return dateForValue;
    }

    private static String setPreSuffFix(Map<String, Object> data, List<PrefixSuffixModel> list) {
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isNotEmpty(list)) {
            for (PrefixSuffixModel prefix : list) {
                if (Objects.equals(prefix.getSourceType(), 2)) {
                    sb.append(prefix.getRelationField());
                    continue;
                }
                if (!StringUtil.isNotEmpty((String)prefix.getRelationField()) || data.get(prefix.getRelationField()) == null) continue;
                sb.append(data.get(prefix.getRelationField()));
            }
        }
        return sb.toString();
    }
}

