/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.util;

import com.baomidou.dynamic.datasource.annotation.DS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jnpf.base.Page;
import jnpf.base.Pagination;
import jnpf.base.entity.DictionaryDataEntity;
import jnpf.base.service.BillRuleService;
import jnpf.base.service.DataInterfaceService;
import jnpf.base.service.DbLinkService;
import jnpf.base.service.DbTableService;
import jnpf.base.service.DictionaryDataService;
import jnpf.base.service.DictionaryTypeService;
import jnpf.database.model.dbfield.DbFieldModel;
import jnpf.database.model.dbfield.base.DbFieldModelBase;
import jnpf.database.model.dbtable.DbTableFieldModel;
import jnpf.database.model.entity.DbLinkEntity;
import jnpf.permission.entity.OrganizeEntity;
import jnpf.permission.entity.PositionEntity;
import jnpf.permission.entity.RoleEntity;
import jnpf.permission.entity.UserEntity;
import jnpf.permission.entity.UserRelationEntity;
import jnpf.permission.model.user.vo.UserByRoleVO;
import jnpf.permission.service.OrganizeService;
import jnpf.permission.service.PositionService;
import jnpf.permission.service.RoleService;
import jnpf.permission.service.UserRelationService;
import jnpf.permission.service.UserService;
import jnpf.util.JsonUtil;
import jnpf.util.StringUtil;
import jnpf.util.enums.DictionaryDataEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DS(value="")
public class ServiceBaseUtil {
    @Autowired
    private DbLinkService dblinkService;
    @Autowired
    private DbTableService dbTableService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private BillRuleService billRuleService;
    @Autowired
    private DataInterfaceService dataInterfaceService;

    public DbLinkEntity getDbLink(String dbLink) {
        DbLinkEntity link = StringUtil.isNotEmpty((String)dbLink) ? this.dblinkService.getInfo(dbLink) : null;
        return link;
    }

    public void createTable(List<DbTableFieldModel> dbTable) throws Exception {
        for (DbTableFieldModel dbTableFieldModel : dbTable) {
            this.dbTableService.createTable(dbTableFieldModel);
        }
    }

    public void addField(DbTableFieldModel dbTable) throws Exception {
        this.dbTableService.addField(dbTable);
    }

    public List<DbFieldModelBase> getDbTableModel(String linkId, String table) throws Exception {
        List dbFieldModelList = this.dbTableService.getDbTableModel(linkId, table).getDbFieldModelList();
        List list = JsonUtil.getJsonToList((Object)dbFieldModelList, DbFieldModelBase.class);
        return list;
    }

    public List<DbFieldModel> getFieldList(String linkId, String table) throws Exception {
        return this.dbTableService.getFieldList(linkId, table);
    }

    public List<DictionaryDataEntity> getDiList() {
        List dictionList = this.dictionaryDataService.getList((String)this.dictionaryTypeService.getInfoByEnCode(DictionaryDataEnum.FLOWWOEK_ENGINE.getDictionaryTypeId()).getId());
        return dictionList;
    }

    public List<DictionaryDataEntity> getDictionName(List<String> id) {
        List dictionList = this.dictionaryDataService.getDictionName(id);
        return dictionList;
    }

    public List<UserRelationEntity> getListByUserIdAll(List<String> id) {
        List list = this.userRelationService.getListByUserIdAll(id);
        return list;
    }

    public List<UserRelationEntity> getListByObjectIdAll(List<String> id) {
        List list = this.userRelationService.getListByObjectIdAll(id);
        return list;
    }

    public String getAdmin() {
        UserEntity admin = this.userService.getUserByAccount("admin");
        return (String)admin.getId();
    }

    public List<UserEntity> getUserName(List<String> id) {
        List<UserEntity> list = this.getUserName(id, false);
        return list;
    }

    public List<UserEntity> getListByManagerId(String managerId) {
        ArrayList<UserEntity> list = StringUtil.isNotEmpty((String)managerId) ? this.userService.getListByManagerId(managerId, null) : new ArrayList<UserEntity>();
        return list;
    }

    public List<UserEntity> getUserName(List<String> id, boolean enableMark) {
        List list = this.userService.getUserName(id);
        if (enableMark) {
            list = list.stream().filter(t -> t.getEnabledMark() != 0).collect(Collectors.toList());
        }
        return list;
    }

    public List<UserEntity> getUserName(List<String> id, Pagination pagination) {
        List list = this.userService.getUserName(id, pagination);
        return list;
    }

    public UserEntity getUserInfo(String id) {
        UserEntity entity = null;
        if (StringUtil.isNotEmpty((String)id)) {
            entity = id.equalsIgnoreCase("admin") ? this.userService.getUserByAccount(id) : this.userService.getInfo(id);
        }
        return entity;
    }

    public UserEntity getByRealName(String realName) {
        UserEntity entity = StringUtil.isNotEmpty((String)realName) ? this.userService.getByRealName(realName) : null;
        return entity;
    }

    public List<UserByRoleVO> getListByAuthorize(String organizeId) {
        List list = this.userService.getListByAuthorize(organizeId, new Page());
        return list;
    }

    public String getBillNumber(String enCode) {
        String billNo = "";
        try {
            billNo = this.billRuleService.getBillNumber(enCode, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return billNo;
    }

    public void useBillNumber(String enCode) {
        this.billRuleService.useBillNumber(enCode);
    }

    public List<RoleEntity> getListByIds(List<String> id) {
        List list = this.roleService.getListByIds(id, null, false);
        return list;
    }

    public List<OrganizeEntity> getOrganizeName(List<String> id) {
        List list = this.organizeService.getOrganizeName(id);
        return list;
    }

    public OrganizeEntity getOrganizeInfo(String id) {
        OrganizeEntity entity = StringUtil.isNotEmpty((String)id) ? this.organizeService.getInfo(id) : null;
        return entity;
    }

    public OrganizeEntity getOrganizeFullName(String fullName) {
        OrganizeEntity entity = this.organizeService.getByFullName(fullName);
        return entity;
    }

    public List<OrganizeEntity> getOrganizeId(String organizeId) {
        ArrayList<OrganizeEntity> organizeList = new ArrayList<OrganizeEntity>();
        this.organizeService.getOrganizeId(organizeId, organizeList);
        Collections.reverse(organizeList);
        return organizeList;
    }

    public List<OrganizeEntity> getDepartmentAll(String organizeId) {
        List departmentAll = this.organizeService.getDepartmentAll(organizeId);
        return departmentAll;
    }

    public String getCurrentOrganizeName(Object obj, String showLevel) {
        if (obj == null) {
            return null;
        }
        String value = String.valueOf(obj);
        String orgName = "";
        if (value != null) {
            String orgId = "";
            try {
                List jsonToList = JsonUtil.getJsonToList((String)value, String.class);
                orgId = (String)jsonToList.get(jsonToList.size() - 1);
            }
            catch (Exception e) {
                orgId = value;
            }
            OrganizeEntity organizeEntity = this.getOrganizeInfo(orgId);
            if ("all".equals(showLevel)) {
                if (organizeEntity != null) {
                    List<OrganizeEntity> organizeList = this.getOrganizeId((String)organizeEntity.getId());
                    orgName = organizeList.stream().map(OrganizeEntity::getFullName).collect(Collectors.joining("/"));
                }
            } else {
                orgName = organizeEntity != null && "department".equals(organizeEntity.getCategory()) ? organizeEntity.getFullName() : " ";
            }
        }
        return orgName;
    }

    public List<PositionEntity> getPositionName(List<String> id) {
        List list = this.positionService.getPositionName(id, false);
        return list;
    }

    public PositionEntity getPositionFullName(String fullName) {
        PositionEntity entity = this.positionService.getByFullName(fullName);
        return entity;
    }

    public PositionEntity getPositionInfo(String id) {
        PositionEntity entity = StringUtil.isNotEmpty((String)id) ? this.positionService.getInfo(id) : null;
        return entity;
    }

    public void infoToId(String interId, Map<String, String> parameterMap) {
        this.dataInterfaceService.infoToId(interId, null, parameterMap);
    }
}

