/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.util;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jnpf.util.JsonUtil;
import jnpf.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;

public class OnlineFilterUtil {
    Map<String, SqlTable> subSqlTableMap;
    Map<String, Object> params;
    private String fieldName;
    private String operator;
    private String logic;
    private String jnpfKey;
    private String field;
    private String fieldValue;
    private String fieldValue2;
    private List<String> selectIgnore;
    private String showLevel;
    private String dbType;
    private String format;
    private String precision;

    public QueryExpressionDSL.QueryExpressionWhereBuilder solveValue(QueryExpressionDSL.QueryExpressionWhereBuilder where, SqlTable sqlTable) {
        if (!this.preHandle()) {
            return where;
        }
        MyType myType = this.myControl(this.jnpfKey);
        if (this.fieldValue == null) {
            this.fieldValue = "";
        }
        try {
            ArrayList<String> splitKey = new ArrayList<String>(){
                {
                    this.add("datePicker");
                    this.add("timePicker");
                    this.add("inputNumber");
                    this.add("createTime");
                    this.add("modifyTime");
                }
            };
            if (splitKey.contains(this.jnpfKey) && "between".equals(this.operator)) {
                List data = JsonUtil.getJsonToList((String)this.fieldValue, String.class);
                this.fieldValue = (String)data.get(0);
                this.fieldValue2 = (String)data.get(1);
            }
            this.selectIgnore = new ArrayList<String>(){
                {
                    this.add("organizeSelect");
                    this.add("areaSelect");
                    this.add("cascader");
                    this.add("checkbox");
                    this.add("depSelect");
                }
            };
            String fieldKey = "";
            if (this.field.indexOf("-") > 0) {
                fieldKey = this.field.split("-")[0];
                sqlTable = this.subSqlTableMap.get(fieldKey);
                this.field = this.field.split("-")[1];
            }
            if (this.field.indexOf("_jnpf_") > 0) {
                sqlTable = this.subSqlTableMap.get(this.field);
                this.field = this.field.split("_jnpf_")[1];
            }
            myType.judge(where, sqlTable, this.field);
            return where;
        }
        catch (Exception e) {
            return where;
        }
    }

    private boolean preHandle() {
        if (this.params != null) {
            Boolean onlySubTable = (Boolean)this.params.get("onlySubTable");
            if (onlySubTable.booleanValue() && !this.field.contains("_jnpf_") && !this.field.contains("-")) {
                return false;
            }
            if (onlySubTable.booleanValue() && this.field.contains("_jnpf_")) {
                return false;
            }
        }
        return true;
    }

    public MyType myControl(String jnpfKey) {
        return switch (jnpfKey) {
            case "input", "textarea", "billRule", "popupTableSelect", "relationForm", "relationFormAttr", "popupSelect", "popupAttr" -> new BasicControl();
            case "calculate", "inputNumber" -> new NumControl();
            case "datePicker", "createTime", "modifyTime" -> new DateControl();
            case "timePicker" -> new TimeControl();
            default -> new SelectControl();
        };
    }

    private String convertSqlServerLike(String val) {
        if ("SQLServer".equals(this.dbType)) {
            val = val.replaceAll("\\[", "[[]");
        }
        return val;
    }

    private void convertSqlServerLike() {
        if ("SQLServer".equals(this.dbType)) {
            this.fieldValue = this.convertSqlServerLike(this.fieldValue);
        }
    }

    public Map<String, SqlTable> getSubSqlTableMap() {
        return this.subSqlTableMap;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getLogic() {
        return this.logic;
    }

    public String getJnpfKey() {
        return this.jnpfKey;
    }

    public String getField() {
        return this.field;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public String getFieldValue2() {
        return this.fieldValue2;
    }

    public List<String> getSelectIgnore() {
        return this.selectIgnore;
    }

    public String getShowLevel() {
        return this.showLevel;
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getFormat() {
        return this.format;
    }

    public String getPrecision() {
        return this.precision;
    }

    public void setSubSqlTableMap(Map<String, SqlTable> subSqlTableMap) {
        this.subSqlTableMap = subSqlTableMap;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setLogic(String logic) {
        this.logic = logic;
    }

    public void setJnpfKey(String jnpfKey) {
        this.jnpfKey = jnpfKey;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
    }

    public void setFieldValue2(String fieldValue2) {
        this.fieldValue2 = fieldValue2;
    }

    public void setSelectIgnore(List<String> selectIgnore) {
        this.selectIgnore = selectIgnore;
    }

    public void setShowLevel(String showLevel) {
        this.showLevel = showLevel;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setPrecision(String precision) {
        this.precision = precision;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OnlineFilterUtil)) {
            return false;
        }
        OnlineFilterUtil other = (OnlineFilterUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, SqlTable> this$subSqlTableMap = this.getSubSqlTableMap();
        Map<String, SqlTable> other$subSqlTableMap = other.getSubSqlTableMap();
        if (this$subSqlTableMap == null ? other$subSqlTableMap != null : !((Object)this$subSqlTableMap).equals(other$subSqlTableMap)) {
            return false;
        }
        Map<String, Object> this$params = this.getParams();
        Map<String, Object> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        String this$operator = this.getOperator();
        String other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
            return false;
        }
        String this$logic = this.getLogic();
        String other$logic = other.getLogic();
        if (this$logic == null ? other$logic != null : !this$logic.equals(other$logic)) {
            return false;
        }
        String this$jnpfKey = this.getJnpfKey();
        String other$jnpfKey = other.getJnpfKey();
        if (this$jnpfKey == null ? other$jnpfKey != null : !this$jnpfKey.equals(other$jnpfKey)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$fieldValue = this.getFieldValue();
        String other$fieldValue = other.getFieldValue();
        if (this$fieldValue == null ? other$fieldValue != null : !this$fieldValue.equals(other$fieldValue)) {
            return false;
        }
        String this$fieldValue2 = this.getFieldValue2();
        String other$fieldValue2 = other.getFieldValue2();
        if (this$fieldValue2 == null ? other$fieldValue2 != null : !this$fieldValue2.equals(other$fieldValue2)) {
            return false;
        }
        List<String> this$selectIgnore = this.getSelectIgnore();
        List<String> other$selectIgnore = other.getSelectIgnore();
        if (this$selectIgnore == null ? other$selectIgnore != null : !((Object)this$selectIgnore).equals(other$selectIgnore)) {
            return false;
        }
        String this$showLevel = this.getShowLevel();
        String other$showLevel = other.getShowLevel();
        if (this$showLevel == null ? other$showLevel != null : !this$showLevel.equals(other$showLevel)) {
            return false;
        }
        String this$dbType = this.getDbType();
        String other$dbType = other.getDbType();
        if (this$dbType == null ? other$dbType != null : !this$dbType.equals(other$dbType)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$precision = this.getPrecision();
        String other$precision = other.getPrecision();
        return !(this$precision == null ? other$precision != null : !this$precision.equals(other$precision));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OnlineFilterUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, SqlTable> $subSqlTableMap = this.getSubSqlTableMap();
        result = result * 59 + ($subSqlTableMap == null ? 43 : ((Object)$subSqlTableMap).hashCode());
        Map<String, Object> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        String $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
        String $logic = this.getLogic();
        result = result * 59 + ($logic == null ? 43 : $logic.hashCode());
        String $jnpfKey = this.getJnpfKey();
        result = result * 59 + ($jnpfKey == null ? 43 : $jnpfKey.hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $fieldValue = this.getFieldValue();
        result = result * 59 + ($fieldValue == null ? 43 : $fieldValue.hashCode());
        String $fieldValue2 = this.getFieldValue2();
        result = result * 59 + ($fieldValue2 == null ? 43 : $fieldValue2.hashCode());
        List<String> $selectIgnore = this.getSelectIgnore();
        result = result * 59 + ($selectIgnore == null ? 43 : ((Object)$selectIgnore).hashCode());
        String $showLevel = this.getShowLevel();
        result = result * 59 + ($showLevel == null ? 43 : $showLevel.hashCode());
        String $dbType = this.getDbType();
        result = result * 59 + ($dbType == null ? 43 : $dbType.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : $precision.hashCode());
        return result;
    }

    public String toString() {
        return "OnlineFilterUtil(subSqlTableMap=" + String.valueOf(this.getSubSqlTableMap()) + ", params=" + String.valueOf(this.getParams()) + ", fieldName=" + this.getFieldName() + ", operator=" + this.getOperator() + ", logic=" + this.getLogic() + ", jnpfKey=" + this.getJnpfKey() + ", field=" + this.getField() + ", fieldValue=" + this.getFieldValue() + ", fieldValue2=" + this.getFieldValue2() + ", selectIgnore=" + String.valueOf(this.getSelectIgnore()) + ", showLevel=" + this.getShowLevel() + ", dbType=" + this.getDbType() + ", format=" + this.getFormat() + ", precision=" + this.getPrecision() + ")";
    }

    private abstract class MyType {
        private MyType() {
        }

        abstract void judge(QueryExpressionDSL.QueryExpressionWhereBuilder var1, SqlTable var2, String var3);
    }

    class BasicControl
    extends MyType {
        BasicControl() {
        }

        @Override
        void judge(QueryExpressionDSL.QueryExpressionWhereBuilder where, SqlTable sqlTable, String field) {
            if ("&&".equals(OnlineFilterUtil.this.logic)) {
                switch (OnlineFilterUtil.this.operator) {
                    case "null": {
                        ArrayList<AndOrCriteriaGroup> group = new ArrayList<AndOrCriteriaGroup>();
                        group.add(SqlBuilder.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isEqualTo((Object)""), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNull(), group);
                        break;
                    }
                    case "notNull": {
                        ArrayList<AndOrCriteriaGroup> group2 = new ArrayList<AndOrCriteriaGroup>();
                        group2.add(SqlBuilder.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotEqualTo((Object)""), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotNull(), group2);
                        break;
                    }
                    case "==": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isEqualTo((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<>": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotEqualTo((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "like": {
                        OnlineFilterUtil.this.convertSqlServerLike();
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLike((Object)("%" + OnlineFilterUtil.this.fieldValue + "%")), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "notLike": {
                        OnlineFilterUtil.this.convertSqlServerLike();
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotLike((Object)("%" + OnlineFilterUtil.this.fieldValue + "%")), new AndOrCriteriaGroup[0]);
                    }
                }
            } else {
                switch (OnlineFilterUtil.this.operator) {
                    case "null": {
                        ArrayList<AndOrCriteriaGroup> group = new ArrayList<AndOrCriteriaGroup>();
                        group.add(SqlBuilder.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isEqualTo((Object)""), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNull(), group);
                        break;
                    }
                    case "notNull": {
                        ArrayList<AndOrCriteriaGroup> group2 = new ArrayList<AndOrCriteriaGroup>();
                        group2.add(SqlBuilder.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotEqualTo((Object)""), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotNull(), group2);
                        break;
                    }
                    case "==": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isEqualTo((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<>": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotEqualTo((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "like": {
                        OnlineFilterUtil.this.convertSqlServerLike();
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLike((Object)("%" + OnlineFilterUtil.this.fieldValue + "%")), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "notLike": {
                        OnlineFilterUtil.this.convertSqlServerLike();
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotLike((Object)("%" + OnlineFilterUtil.this.fieldValue + "%")), new AndOrCriteriaGroup[0]);
                    }
                }
            }
        }
    }

    class NumControl
    extends MyType {
        NumControl() {
        }

        @Override
        void judge(QueryExpressionDSL.QueryExpressionWhereBuilder where, SqlTable sqlTable, String field) {
            BigDecimal num1 = null;
            BigDecimal num2 = null;
            if (StringUtil.isNotEmpty((String)OnlineFilterUtil.this.fieldValue)) {
                num1 = new BigDecimal(OnlineFilterUtil.this.fieldValue);
            }
            if (StringUtil.isNotEmpty((String)OnlineFilterUtil.this.fieldValue2)) {
                num2 = new BigDecimal(OnlineFilterUtil.this.fieldValue2);
            }
            if (StringUtils.isNotBlank((CharSequence)OnlineFilterUtil.this.precision)) {
                String zeroNum = "0." + StringUtils.repeat((String)"0", (int)Integer.parseInt(OnlineFilterUtil.this.precision));
                DecimalFormat numFormat = new DecimalFormat(zeroNum);
                String fieldPrecisionValue = numFormat.format(new BigDecimal(OnlineFilterUtil.this.fieldValue));
                num1 = new BigDecimal(fieldPrecisionValue);
                if (OnlineFilterUtil.this.fieldValue2 != null) {
                    String fieldPrecisionValue2 = numFormat.format(new BigDecimal(OnlineFilterUtil.this.fieldValue2));
                    num2 = new BigDecimal(fieldPrecisionValue2);
                }
            }
            if ("&&".equals(OnlineFilterUtil.this.logic)) {
                switch (OnlineFilterUtil.this.operator) {
                    case "null": {
                        ArrayList group = new ArrayList();
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNull(), group);
                        break;
                    }
                    case "notNull": {
                        ArrayList group2 = new ArrayList();
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotNull(), group2);
                        break;
                    }
                    case "==": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isEqualTo((Object)num1), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<>": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotEqualTo((Object)num1), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case ">": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isGreaterThan((Object)num1), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLessThan((Object)num1), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case ">=": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)num1), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<=": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLessThanOrEqualTo((Object)num1), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "between": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)num1), new AndOrCriteriaGroup[0]);
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLessThanOrEqualTo((Object)num2), new AndOrCriteriaGroup[0]);
                    }
                }
            } else {
                switch (OnlineFilterUtil.this.operator) {
                    case "null": {
                        ArrayList group = new ArrayList();
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNull(), group);
                        break;
                    }
                    case "notNull": {
                        ArrayList group2 = new ArrayList();
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotNull(), group2);
                        break;
                    }
                    case "==": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isEqualTo((Object)num1), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<>": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotEqualTo((Object)num1), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case ">": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isGreaterThan((Object)num1), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLessThan((Object)num1), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case ">=": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)num1), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<=": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLessThanOrEqualTo((Object)num1), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "between": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)num1), new AndOrCriteriaGroup[0]);
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLessThanOrEqualTo((Object)num2), new AndOrCriteriaGroup[0]);
                    }
                }
            }
        }
    }

    class DateControl
    extends MyType {
        DateControl() {
        }

        @Override
        void judge(QueryExpressionDSL.QueryExpressionWhereBuilder where, SqlTable sqlTable, String field) {
            Long time = null;
            Long time2 = null;
            Date date = new Date();
            Date date2 = new Date();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{OnlineFilterUtil.this.fieldValue})) {
                time = Long.valueOf(OnlineFilterUtil.this.fieldValue);
                date = new Date(time);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{OnlineFilterUtil.this.fieldValue2})) {
                time2 = Long.valueOf(OnlineFilterUtil.this.fieldValue2);
                date2 = "datePicker".equals(OnlineFilterUtil.this.jnpfKey) ? new Date(time2 + 86400000L - 1000L) : new Date(time2);
            }
            if ("&&".equals(OnlineFilterUtil.this.logic)) {
                switch (OnlineFilterUtil.this.operator) {
                    case "null": {
                        ArrayList group = new ArrayList();
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNull(), group);
                        break;
                    }
                    case "notNull": {
                        ArrayList group2 = new ArrayList();
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotNull(), group2);
                        break;
                    }
                    case "==": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isEqualTo((Object)date), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<>": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotEqualTo((Object)date), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case ">": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isGreaterThan((Object)date), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLessThan((Object)date), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case ">=": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)date), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<=": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLessThanOrEqualTo((Object)date), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "between": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)date), new AndOrCriteriaGroup[0]);
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLessThanOrEqualTo((Object)date2), new AndOrCriteriaGroup[0]);
                    }
                }
            } else {
                switch (OnlineFilterUtil.this.operator) {
                    case "null": {
                        ArrayList group = new ArrayList();
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNull(), group);
                        break;
                    }
                    case "notNull": {
                        ArrayList group2 = new ArrayList();
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotNull(), group2);
                        break;
                    }
                    case "==": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isEqualTo((Object)date), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<>": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotEqualTo((Object)date), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case ">": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isGreaterThan((Object)date), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLessThan((Object)date), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case ">=": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)date), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<=": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLessThanOrEqualTo((Object)date), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "between": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)date), new AndOrCriteriaGroup[0]);
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLessThanOrEqualTo((Object)date2), new AndOrCriteriaGroup[0]);
                    }
                }
            }
        }
    }

    class TimeControl
    extends MyType {
        TimeControl() {
        }

        @Override
        void judge(QueryExpressionDSL.QueryExpressionWhereBuilder where, SqlTable sqlTable, String field) {
            if ("&&".equals(OnlineFilterUtil.this.logic)) {
                switch (OnlineFilterUtil.this.operator) {
                    case "null": {
                        ArrayList group = new ArrayList();
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNull(), group);
                        break;
                    }
                    case "notNull": {
                        ArrayList group2 = new ArrayList();
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotNull(), group2);
                        break;
                    }
                    case "==": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isEqualTo((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<>": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotEqualTo((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case ">": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isGreaterThan((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLessThan((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case ">=": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<=": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLessThanOrEqualTo((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "between": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLessThanOrEqualTo((Object)OnlineFilterUtil.this.fieldValue2), new AndOrCriteriaGroup[0]);
                    }
                }
            } else {
                switch (OnlineFilterUtil.this.operator) {
                    case "null": {
                        ArrayList group = new ArrayList();
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNull(), group);
                        break;
                    }
                    case "notNull": {
                        ArrayList group2 = new ArrayList();
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotNull(), group2);
                        break;
                    }
                    case "==": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isEqualTo((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<>": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotEqualTo((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case ">": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isGreaterThan((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLessThan((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case ">=": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<=": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLessThanOrEqualTo((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "between": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLessThanOrEqualTo((Object)OnlineFilterUtil.this.fieldValue2), new AndOrCriteriaGroup[0]);
                    }
                }
            }
        }
    }

    class SelectControl
    extends MyType {
        SelectControl() {
        }

        @Override
        void judge(QueryExpressionDSL.QueryExpressionWhereBuilder where, SqlTable sqlTable, String field) {
            ArrayList list = new ArrayList();
            if (OnlineFilterUtil.this.selectIgnore.contains(OnlineFilterUtil.this.jnpfKey) && StringUtils.isBlank((CharSequence)OnlineFilterUtil.this.fieldValue)) {
                OnlineFilterUtil.this.fieldValue = "[]";
            }
            if ("&&".equals(OnlineFilterUtil.this.logic)) {
                switch (OnlineFilterUtil.this.operator) {
                    case "null": {
                        ArrayList<AndOrCriteriaGroup> group = new ArrayList<AndOrCriteriaGroup>();
                        if (!"Oracle".equals(OnlineFilterUtil.this.dbType)) {
                            group.add(SqlBuilder.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isEqualTo((Object)""), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                        }
                        group.add(SqlBuilder.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isEqualTo((Object)"[]"), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNull(), group);
                        break;
                    }
                    case "notNull": {
                        ArrayList<AndOrCriteriaGroup> group2 = new ArrayList<AndOrCriteriaGroup>();
                        if (!"Oracle".equals(OnlineFilterUtil.this.dbType)) {
                            group2.add(SqlBuilder.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotEqualTo((Object)""), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                        }
                        group2.add(SqlBuilder.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotEqualTo((Object)"[]"), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotNull(), group2);
                        break;
                    }
                    case "==": {
                        OnlineFilterUtil.this.convertSqlServerLike();
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLike((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<>": {
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotLike((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "like": {
                        OnlineFilterUtil.this.convertSqlServerLike();
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLike((Object)("%" + OnlineFilterUtil.this.fieldValue + "%")), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "notLike": {
                        OnlineFilterUtil.this.convertSqlServerLike();
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotLike((Object)("%" + OnlineFilterUtil.this.fieldValue + "%")), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "in": {
                        ArrayList<String> dataList = this.solveListValue(OnlineFilterUtil.this.fieldValue);
                        if (dataList.size() > 0) {
                            ArrayList<AndOrCriteriaGroup> group3 = new ArrayList<AndOrCriteriaGroup>();
                            String valueFirst = "";
                            for (int i = 0; i < dataList.size(); ++i) {
                                String value = (String)dataList.get(i);
                                value = OnlineFilterUtil.this.convertSqlServerLike(value);
                                AndOrCriteriaGroup condition = null;
                                if (i == 0) {
                                    valueFirst = value;
                                    continue;
                                }
                                condition = SqlBuilder.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLike((Object)("%" + value + "%")), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]);
                                group3.add(condition);
                            }
                            where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLike((Object)("%" + valueFirst + "%")), group3);
                        }
                        if (!"cascader".equals(OnlineFilterUtil.this.jnpfKey) && !"organizeSelect".equals(OnlineFilterUtil.this.jnpfKey) && !"areaSelect".equals(OnlineFilterUtil.this.jnpfKey)) break;
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotNull(), new AndOrCriteriaGroup[0]);
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotEqualTo((Object)"[]"), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "notIn": {
                        ArrayList<String> dataList2 = this.solveListValue(OnlineFilterUtil.this.fieldValue);
                        if (dataList2.size() > 0) {
                            for (int i = 0; i < dataList2.size(); ++i) {
                                String value = (String)dataList2.get(i);
                                where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotLike((Object)("%" + value + "%")), new AndOrCriteriaGroup[0]);
                            }
                        }
                        if (!"cascader".equals(OnlineFilterUtil.this.jnpfKey) && !"organizeSelect".equals(OnlineFilterUtil.this.jnpfKey) && !"areaSelect".equals(OnlineFilterUtil.this.jnpfKey)) break;
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotNull(), new AndOrCriteriaGroup[0]);
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotEqualTo((Object)"[]"), new AndOrCriteriaGroup[0]);
                    }
                }
            } else {
                switch (OnlineFilterUtil.this.operator) {
                    case "null": {
                        ArrayList<AndOrCriteriaGroup> group = new ArrayList<AndOrCriteriaGroup>();
                        if (!"Oracle".equals(OnlineFilterUtil.this.dbType)) {
                            group.add(SqlBuilder.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isEqualTo((Object)""), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                        }
                        group.add(SqlBuilder.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isEqualTo((Object)"[]"), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNull(), group);
                        break;
                    }
                    case "notNull": {
                        ArrayList<AndOrCriteriaGroup> group2 = new ArrayList<AndOrCriteriaGroup>();
                        if (!"Oracle".equals(OnlineFilterUtil.this.dbType)) {
                            group2.add(SqlBuilder.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotEqualTo((Object)""), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                        }
                        group2.add(SqlBuilder.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotEqualTo((Object)"[]"), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotNull(), group2);
                        break;
                    }
                    case "==": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isEqualTo((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "<>": {
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotEqualTo((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "like": {
                        OnlineFilterUtil.this.convertSqlServerLike();
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLike((Object)("%" + OnlineFilterUtil.this.fieldValue + "%")), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "notLike": {
                        OnlineFilterUtil.this.convertSqlServerLike();
                        where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotLike((Object)("%" + OnlineFilterUtil.this.fieldValue + "%")), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "in": {
                        if (OnlineFilterUtil.this.selectIgnore.contains(OnlineFilterUtil.this.jnpfKey)) {
                            OnlineFilterUtil.this.convertSqlServerLike();
                            where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isLike((Object)OnlineFilterUtil.this.fieldValue), new AndOrCriteriaGroup[0]);
                        } else if (list.size() > 0) {
                            where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isIn(list), new AndOrCriteriaGroup[0]);
                        }
                        if (!"cascader".equals(OnlineFilterUtil.this.jnpfKey) && !"organizeSelect".equals(OnlineFilterUtil.this.jnpfKey) && !"areaSelect".equals(OnlineFilterUtil.this.jnpfKey)) break;
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotNull(), new AndOrCriteriaGroup[0]);
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotEqualTo((Object)"[]"), new AndOrCriteriaGroup[0]);
                        break;
                    }
                    case "notIn": {
                        if (OnlineFilterUtil.this.selectIgnore.contains(OnlineFilterUtil.this.jnpfKey)) {
                            List data = JsonUtil.getJsonToList((String)OnlineFilterUtil.this.fieldValue, String.class);
                            if (data.size() > 0) {
                                where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotLike((Object)data), new AndOrCriteriaGroup[0]);
                            }
                        } else if (list != null && list.size() > 0) {
                            where.or((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotIn(list), new AndOrCriteriaGroup[0]);
                        }
                        if (!"cascader".equals(OnlineFilterUtil.this.jnpfKey) && !"organizeSelect".equals(OnlineFilterUtil.this.jnpfKey) && !"areaSelect".equals(OnlineFilterUtil.this.jnpfKey)) break;
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotNull(), new AndOrCriteriaGroup[0]);
                        where.and((BindableColumn)sqlTable.column(field), (VisitableCondition)SqlBuilder.isNotEqualTo((Object)"[]"), new AndOrCriteriaGroup[0]);
                    }
                }
            }
        }

        private ArrayList<String> solveListValue(String fieldValue) {
            ArrayList<String> result = new ArrayList<String>();
            try {
                List list = JsonUtil.getJsonToList((String)fieldValue, List.class);
                for (List listSub : list) {
                    result.add(JSONArray.toJSONString((Object)listSub));
                    String value = (String)listSub.get(listSub.size() - 1);
                    result.add(value);
                }
            }
            catch (Exception e) {
                List list = JsonUtil.getJsonToList((String)fieldValue, String.class);
                result.add(JSONArray.toJSONString((Object)list));
                result.addAll(list);
            }
            return result;
        }
    }
}

