/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import jnpf.base.util.DateTimeFormatConstant;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.config.ConfigModel;
import jnpf.util.JsonUtil;
import jnpf.util.StringUtil;
import jnpf.util.TableFeildsEnum;
import jnpf.util.visiual.JnpfKeyConsts;

public class FormPublicUtils {
    public static void recursionFieldsExceptChild(List<FieLdsModel> allFields, List<FieLdsModel> fieLdsModelList) {
        for (FieLdsModel fieLdsModel : fieLdsModelList) {
            ConfigModel config = fieLdsModel.getConfig();
            String jnpfKey = config.getJnpfKey();
            if ("table".equals(jnpfKey)) {
                allFields.add(fieLdsModel);
                continue;
            }
            if (config.getChildren() != null) {
                FormPublicUtils.recursionFieldsExceptChild(allFields, config.getChildren());
                continue;
            }
            if (jnpfKey == null) continue;
            allFields.add(fieLdsModel);
        }
    }

    public static String getTimeFormat(String time) {
        return switch (time.length()) {
            case 16 -> time + ":00";
            case 19 -> time;
            case 21 -> time.substring(0, time.length() - 2);
            case 10 -> time + " 00:00:00";
            case 8 -> "2000-01-01 " + time;
            case 7 -> time + "-01 00:00:00";
            case 4 -> time + "-01-01 00:00:00";
            default -> "";
        };
    }

    public static String getLastTimeFormat(String time) {
        return switch (time.length()) {
            case 16 -> time + ":00";
            case 19 -> time;
            case 10 -> time + " 23:59:59";
            case 8 -> "2000-01-01 " + time;
            case 7 -> {
                String[] split = time.split("-");
                Calendar cale = Calendar.getInstance();
                cale.set(1, Integer.valueOf(split[0]));
                cale.set(2, Integer.valueOf(split[1]) - 1);
                int lastDay = cale.getActualMaximum(5);
                cale.set(5, lastDay);
                cale.set(11, 23);
                cale.set(13, 59);
                cale.set(12, 59);
                yield jnpf.util.DateUtil.daFormatHHMMSS((Long)cale.getTime().getTime());
            }
            case 4 -> time + "-12-31 23:59:59";
            default -> "";
        };
    }

    public static boolean dateTimeCondition(FieLdsModel swapDataVo, String format, Object value, Map<String, Object> data, String jnpfKey) {
        String endTimeRelationField;
        String endTimeTarget;
        String endTimeType;
        String endTimeValue;
        long endTimeLong;
        String startTimeRelationField;
        String startTimeTarget;
        String startTimeType;
        String startTimeValue;
        long startTimeLong;
        long valueTimeLong;
        if (value instanceof String) {
            valueTimeLong = DateUtil.parse((CharSequence)String.valueOf(value), (String)format).getTime();
        } else {
            String timeFormat = FormPublicUtils.getTimeFormat(String.valueOf(value));
            valueTimeLong = jnpf.util.DateUtil.stringToDate((String)timeFormat).getTime();
        }
        boolean timeHasRangeError = false;
        if (swapDataVo.getConfig().getStartTimeRule().booleanValue() && (startTimeLong = FormPublicUtils.getDateTimeLong(data, jnpfKey, startTimeValue = swapDataVo.getConfig().getStartTimeValue(), startTimeType = swapDataVo.getConfig().getStartTimeType(), startTimeTarget = swapDataVo.getConfig().getStartTimeTarget(), startTimeRelationField = swapDataVo.getConfig().getStartRelationField(), format)) != 0L && valueTimeLong < startTimeLong) {
            timeHasRangeError = true;
        }
        if (swapDataVo.getConfig().getEndTimeRule().booleanValue() && (endTimeLong = FormPublicUtils.getDateTimeLong(data, jnpfKey, endTimeValue = swapDataVo.getConfig().getEndTimeValue(), endTimeType = swapDataVo.getConfig().getEndTimeType(), endTimeTarget = swapDataVo.getConfig().getEndTimeTarget(), endTimeRelationField = swapDataVo.getConfig().getEndRelationField(), format)) != 0L && valueTimeLong > endTimeLong) {
            timeHasRangeError = true;
        }
        return timeHasRangeError;
    }

    public static long getDateTimeLong(Map<String, Object> data, String jnpfKey, String timeValue, String timeType, String timeTarget, String stringimeRelationField, String format) {
        if (StringUtil.isEmpty((String)timeValue)) {
            timeValue = "0";
        }
        long startTimeLong = 0L;
        long timestampInMillis = new Date().getTime();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            String s = sdf.format(new Date());
            timestampInMillis = sdf.parse(s).getTime();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        switch (timeType) {
            case "1": {
                if ("datePicker".equals(jnpfKey)) {
                    startTimeLong = Long.parseLong(timeValue);
                    break;
                }
                String newDateStr = jnpf.util.DateUtil.daFormat((Date)new Date()) + " " + timeValue + (timeValue.length() > 6 ? "" : ":00");
                startTimeLong = jnpf.util.DateUtil.stringToDate((String)newDateStr).getTime();
                break;
            }
            case "2": {
                if (stringimeRelationField == null) break;
                String fieldValue = "";
                if (stringimeRelationField.toLowerCase().contains("tablefield")) {
                    String[] split = stringimeRelationField.split("-");
                    fieldValue = data.get(split[1]) != null ? data.get(split[1]).toString() : "";
                } else {
                    Map mainAndMast = data.get("mainAndMast") != null ? JsonUtil.entityToMap((Object)data.get("mainAndMast")) : data;
                    String string = fieldValue = mainAndMast.get(stringimeRelationField) != null ? mainAndMast.get(stringimeRelationField).toString() : "";
                }
                if (!StringUtil.isNotEmpty((String)fieldValue)) break;
                String timeFormat = FormPublicUtils.getTimeFormat(fieldValue);
                startTimeLong = DateUtil.parse((CharSequence)timeFormat, (String)"yyyy-MM-dd HH:mm:ss").getTime();
                break;
            }
            case "3": {
                startTimeLong = timestampInMillis;
                break;
            }
            case "4": {
                Calendar caledel = Calendar.getInstance();
                caledel.setTimeInMillis(timestampInMillis);
                if ("datePicker".equals(jnpfKey)) {
                    switch (timeTarget) {
                        case "1": {
                            caledel.set(1, caledel.get(1) - Integer.valueOf(timeValue));
                            break;
                        }
                        case "2": {
                            caledel.set(2, caledel.get(2) - Integer.valueOf(timeValue));
                            break;
                        }
                        case "3": {
                            caledel.set(5, caledel.get(5) - Integer.valueOf(timeValue));
                        }
                    }
                } else {
                    switch (timeTarget) {
                        case "1": {
                            caledel.set(11, caledel.get(11) - Integer.valueOf(timeValue));
                            break;
                        }
                        case "2": {
                            caledel.set(12, caledel.get(12) - Integer.valueOf(timeValue));
                            break;
                        }
                        case "3": {
                            caledel.set(13, caledel.get(13) - Integer.valueOf(timeValue));
                        }
                    }
                }
                startTimeLong = caledel.getTime().getTime();
                break;
            }
            case "5": {
                Calendar cale = Calendar.getInstance();
                cale.setTimeInMillis(timestampInMillis);
                if ("datePicker".equals(jnpfKey)) {
                    switch (timeTarget) {
                        case "1": {
                            cale.set(1, cale.get(1) + Integer.valueOf(timeValue));
                            break;
                        }
                        case "2": {
                            cale.set(2, cale.get(2) + Integer.valueOf(timeValue));
                            break;
                        }
                        case "3": {
                            cale.set(5, cale.get(5) + Integer.valueOf(timeValue));
                        }
                    }
                } else {
                    switch (timeTarget) {
                        case "1": {
                            cale.set(11, cale.get(11) + Integer.valueOf(timeValue));
                            break;
                        }
                        case "2": {
                            cale.set(12, cale.get(12) + Integer.valueOf(timeValue));
                            break;
                        }
                        case "3": {
                            cale.set(13, cale.get(13) + Integer.valueOf(timeValue));
                        }
                    }
                }
                startTimeLong = cale.getTime().getTime();
                break;
            }
        }
        return startTimeLong;
    }

    public static Object getDataConversion(Object value) {
        if (value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof BigDecimal) {
            return value;
        }
        Object dataValue = FormPublicUtils.getDataConversion(null, value, false, "/");
        return dataValue;
    }

    public static Object getDataConversion(Map<String, Object> redis, Object value, boolean isMultiple, String separator) {
        Object dataValue;
        block10: {
            dataValue = value;
            boolean iszhuanhuan = redis != null;
            try {
                List list = JsonUtil.getJsonToList((String)String.valueOf(value), List.class);
                dataValue = list;
                if (iszhuanhuan) {
                    StringJoiner joiner = new StringJoiner(",");
                    for (List listChild : list) {
                        StringJoiner aa = new StringJoiner(separator);
                        for (Object object : listChild) {
                            String value1 = redis.get(String.valueOf(object)) != null ? String.valueOf(redis.get(String.valueOf(object))) : "";
                            if (!StringUtil.isNotEmpty((String)value1)) continue;
                            aa.add(value1);
                        }
                        joiner.add(aa.toString());
                    }
                    dataValue = joiner.toString();
                }
            }
            catch (Exception e) {
                try {
                    List list = JsonUtil.getJsonToList((String)String.valueOf(value), String.class);
                    dataValue = list;
                    if (iszhuanhuan) {
                        if (isMultiple) {
                            separator = ",";
                        }
                        StringJoiner joiner = new StringJoiner(separator);
                        for (Object listChild : list) {
                            String value1 = redis.get(String.valueOf(listChild)) != null ? String.valueOf(redis.get(String.valueOf(listChild))) : "";
                            if (!StringUtil.isNotEmpty((String)value1)) continue;
                            joiner.add(value1);
                        }
                        dataValue = joiner.toString();
                    }
                }
                catch (Exception e1) {
                    dataValue = String.valueOf(value);
                    if (!iszhuanhuan) break block10;
                    dataValue = redis.get(String.valueOf(value)) != null ? String.valueOf(redis.get(String.valueOf(value))) : "";
                }
            }
        }
        return dataValue;
    }

    public static List<Map<String, Object>> addIdToList(List<Map<String, Object>> dataList, String key) {
        return dataList.stream().map(data -> {
            data.put("id", data.get(key));
            String flwoId = null;
            if (data.get(TableFeildsEnum.FLOWID.getField()) != null) {
                flwoId = String.valueOf(data.get(TableFeildsEnum.FLOWID.getField()));
            }
            if (data.get(TableFeildsEnum.FLOWID.getField().toUpperCase()) != null) {
                flwoId = String.valueOf(data.get(TableFeildsEnum.FLOWID.getField().toUpperCase()));
            }
            data.put("flowId", flwoId);
            String flowTaskId = null;
            if (data.get(TableFeildsEnum.FLOWTASKID.getField()) != null) {
                flowTaskId = String.valueOf(data.get(TableFeildsEnum.FLOWTASKID.getField()));
            }
            if (data.get(TableFeildsEnum.FLOWTASKID.getField().toUpperCase()) != null) {
                flowTaskId = String.valueOf(data.get(TableFeildsEnum.FLOWTASKID.getField().toUpperCase()));
            }
            data.put("flowTaskId", flowTaskId);
            return data;
        }).collect(Collectors.toList());
    }

    public static void relationGetJnpfId(Map<String, Object> dataMap, String jnpfKey, Object obj, String vModel) {
        String vModeljnpfId = vModel + "_jnpfId";
        switch (jnpfKey) {
            case "createTime": 
            case "modifyTime": 
            case "datePicker": {
                Long dateTime = DateTimeFormatConstant.getDateObjToLong(dataMap.get(vModel));
                dataMap.put(vModeljnpfId, dateTime != null ? dateTime : dataMap.get(vModel));
                break;
            }
            case "table": {
                break;
            }
            case "switch": 
            case "slider": 
            case "rate": 
            case "calculate": 
            case "inputNumber": {
                dataMap.put(vModeljnpfId, ObjectUtil.isNotEmpty((Object)obj) ? new BigDecimal(String.valueOf(obj)) : dataMap.get(vModel));
                break;
            }
            default: {
                dataMap.put(vModeljnpfId, obj);
            }
        }
        if (JnpfKeyConsts.getArraysKey().contains(jnpfKey) && obj != null) {
            String o = String.valueOf(obj);
            try {
                List jsonToList = JsonUtil.getJsonToList((String)o, List.class);
                ArrayList res = new ArrayList();
                for (List listChild : jsonToList) {
                    ArrayList res2 = new ArrayList();
                    for (Object object : listChild) {
                        if (object == null || !StringUtil.isNotEmpty((String)String.valueOf(object))) continue;
                        res2.add(object);
                    }
                    res.add(res2);
                }
                dataMap.put(vModeljnpfId, res);
            }
            catch (Exception e) {
                try {
                    List jsonToList = JsonUtil.getJsonToList((String)o, Object.class);
                    dataMap.put(vModeljnpfId, jsonToList);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

