/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.util;

import cn.hutool.core.util.ObjectUtil;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import jnpf.base.util.DateTimeFormatConstant;
import jnpf.base.util.FormPublicUtils;
import jnpf.base.util.ServiceBaseUtil;
import jnpf.database.util.DynamicDataSourceUtil;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.permission.entity.PositionEntity;
import jnpf.permission.entity.UserEntity;
import jnpf.util.DateUtil;
import jnpf.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FormInfoUtils {
    private static final Logger log = LoggerFactory.getLogger(FormInfoUtils.class);
    @Autowired
    private ServiceBaseUtil serviceUtil;

    public Map<String, Object> swapDataInfoType(List<FieLdsModel> modelList, Map<String, Object> dataMap) {
        dataMap = Optional.ofNullable(dataMap).orElse(new HashMap());
        try {
            DynamicDataSourceUtil.switchToDataSource(null);
            ArrayList systemConditions = new ArrayList(){
                {
                    this.add("currOrganize");
                    this.add("currDept");
                    this.add("currPosition");
                }
            };
            ArrayList nullIsList = new ArrayList(){
                {
                    this.add("uploadFile");
                    this.add("uploadImg");
                }
            };
            block34: for (FieLdsModel swapDataVo : modelList) {
                String jnpfKey = swapDataVo.getConfig().getJnpfKey();
                String vModel = swapDataVo.getVModel();
                FormInfoUtils.swapClob(dataMap, vModel);
                FormPublicUtils.relationGetJnpfId(dataMap, jnpfKey, dataMap.get(vModel), vModel);
                Object value = dataMap.get(vModel);
                if (value == null || ObjectUtil.isEmpty(value)) {
                    if (systemConditions.contains(jnpfKey)) {
                        dataMap.put(vModel, " ");
                    }
                    if (!nullIsList.contains(jnpfKey)) continue;
                    dataMap.put(vModel, Collections.emptyList());
                    continue;
                }
                switch (jnpfKey) {
                    case "uploadFile": 
                    case "uploadImg": {
                        List fileList = new ArrayList();
                        try {
                            fileList = JsonUtil.getJsonToListMap((String)dataMap.get(vModel).toString());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        dataMap.put(vModel, fileList);
                        continue block34;
                    }
                    case "datePicker": {
                        Long dateTime = DateTimeFormatConstant.getDateObjToLong(dataMap.get(vModel));
                        dataMap.put(vModel, dateTime != null ? dateTime : dataMap.get(vModel));
                        continue block34;
                    }
                    case "createTime": 
                    case "modifyTime": {
                        String pattern = DateTimeFormatConstant.YEAR_MOnTH_DHMS;
                        Long time = DateTimeFormatConstant.getDateObjToLong(dataMap.get(vModel));
                        dataMap.put(vModel, time != null ? DateUtil.dateToString((Date)new Date(time), (String)pattern) : "");
                        continue block34;
                    }
                    case "switch": 
                    case "slider": 
                    case "rate": 
                    case "calculate": 
                    case "inputNumber": {
                        dataMap.put(vModel, value != null ? new BigDecimal(String.valueOf(value)) : null);
                        continue block34;
                    }
                    case "currPosition": {
                        PositionEntity positionEntity = this.serviceUtil.getPositionInfo(String.valueOf(value));
                        dataMap.put(vModel, Objects.nonNull(positionEntity) ? positionEntity.getFullName() : value);
                        continue block34;
                    }
                    case "createUser": 
                    case "modifyUser": {
                        UserEntity userEntity = this.serviceUtil.getUserInfo(String.valueOf(value));
                        String userValue = Objects.nonNull(userEntity) ? (userEntity.getAccount().equalsIgnoreCase("admin") ? "\u7ba1\u7406\u5458/admin" : userEntity.getRealName() + "/" + userEntity.getAccount()) : String.valueOf(value);
                        dataMap.put(vModel, userValue);
                        continue block34;
                    }
                    case "currOrganize": {
                        String currentOrganizeName = this.serviceUtil.getCurrentOrganizeName(value, swapDataVo.getShowLevel());
                        dataMap.put(vModel, currentOrganizeName);
                        continue block34;
                    }
                    case "input": {
                        if (dataMap.get(vModel) == null) continue block34;
                        dataMap.put(vModel, String.valueOf(dataMap.get(vModel)));
                        continue block34;
                    }
                }
                dataMap.put(vModel, FormPublicUtils.getDataConversion(value));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            DynamicDataSourceUtil.clearSwitchDataSource();
        }
        return dataMap;
    }

    public static void swapClob(Map<String, Object> map, String key) {
        if (map != null && map.get(key) != null && map.get(key) instanceof Clob) {
            Clob clob = (Clob)map.get(key);
            StringBuilder sb = new StringBuilder();
            int length = 0;
            try (Reader reader = clob.getCharacterStream();){
                int bytesRead;
                length = (int)clob.length();
                char[] buffer = new char[length];
                while ((bytesRead = reader.read(buffer)) != -1) {
                    sb.append(buffer, 0, bytesRead);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            map.put(key, sb.toString());
        }
    }
}

