/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import jnpf.base.ActionResult;
import jnpf.base.ActionResultCode;
import jnpf.base.entity.VisualdevEntity;
import jnpf.config.ConfigValueUtil;
import jnpf.constant.MsgCode;
import jnpf.exception.WorkFlowException;
import jnpf.util.JsonUtil;
import jnpf.util.ServletUtil;
import jnpf.util.wxutil.HttpUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowFormHttpReqUtils {
    private static ConfigValueUtil configValueUtil;

    @Autowired
    public void setConfigValueUtil(ConfigValueUtil configValueUtil) {
        FlowFormHttpReqUtils.configValueUtil = configValueUtil;
    }

    public Map<String, Object> info(VisualdevEntity visualdevEntity, String id, String token) {
        String requestURL = this.getReqURL(visualdevEntity, id);
        JSONObject jsonObject = HttpUtil.httpRequest((String)requestURL, (String)"GET", null, (String[])new String[]{token});
        ActionResult actionResult = (ActionResult)JSON.toJavaObject((JSON)jsonObject, ActionResult.class);
        if (actionResult == null) {
            return new HashMap<String, Object>();
        }
        Object data = actionResult.getData();
        return data != null ? JsonUtil.entityToMap((Object)data) : new HashMap();
    }

    public boolean isUpdate(VisualdevEntity visualdevEntity, String id, String token) {
        String requestURL = this.getReqURL(visualdevEntity, id);
        JSONObject jsonObject = HttpUtil.httpRequest((String)requestURL, (String)"GET", null, (String[])new String[]{token});
        ActionResult actionResult = (ActionResult)JSON.toJavaObject((JSON)jsonObject, ActionResult.class);
        return actionResult != null && actionResult.getData() != null;
    }

    public void create(VisualdevEntity visualdevEntity, String id, String token, Map<String, Object> map) throws WorkFlowException {
        boolean b;
        String requestURL = this.getReqURL(visualdevEntity, id);
        map.remove("id");
        JSONObject jsonObject = HttpUtil.httpRequest((String)requestURL, (String)"POST", (String)JsonUtil.getObjectToString(map), (String[])new String[]{token});
        ActionResult actionResult = (ActionResult)JSON.toJavaObject((JSON)jsonObject, ActionResult.class);
        boolean bl = b = actionResult != null && ActionResultCode.Success.getCode().equals(actionResult.getCode());
        if (!b) {
            String msg = actionResult != null ? actionResult.getMsg() : MsgCode.FM001.get(new Object[0]);
            throw new WorkFlowException(msg);
        }
    }

    public void update(VisualdevEntity visualdevEntity, String id, String token, Map<String, Object> map) throws WorkFlowException {
        boolean b;
        String requestURL = this.getReqURL(visualdevEntity, id);
        JSONObject jsonObject = HttpUtil.httpRequest((String)requestURL, (String)"PUT", (String)JsonUtil.getObjectToString(map), (String[])new String[]{token});
        ActionResult actionResult = (ActionResult)JSON.toJavaObject((JSON)jsonObject, ActionResult.class);
        boolean bl = b = actionResult != null && ActionResultCode.Success.getCode().equals(actionResult.getCode());
        if (!b) {
            String msg = actionResult != null ? actionResult.getMsg() : MsgCode.FM001.get(new Object[0]);
            throw new WorkFlowException(msg);
        }
    }

    public void saveOrUpdate(VisualdevEntity visualdevEntity, String id, String token, Map<String, Object> map) throws WorkFlowException {
        boolean update = this.isUpdate(visualdevEntity, id, token);
        if (update) {
            this.update(visualdevEntity, id, token, map);
        } else {
            this.create(visualdevEntity, id, token, map);
        }
    }

    private String getReqURL(VisualdevEntity visualdevEntity, String id) {
        HttpServletRequest request = ServletUtil.getRequest();
        Object requestURL = visualdevEntity.getInterfaceUrl();
        boolean isHttp = ((String)requestURL).toLowerCase().startsWith("http");
        if (!isHttp) {
            requestURL = configValueUtil.getApiDomain() + (String)requestURL;
        }
        return (String)requestURL + "/" + id;
    }

    public void delete(VisualdevEntity visualdevEntity, String id, String token) throws WorkFlowException {
        boolean b;
        String requestURL = this.getReqURL(visualdevEntity, id) + "?forceDel=true";
        JSONObject jsonObject = HttpUtil.httpRequest((String)requestURL, (String)"DELETE", null, (String[])new String[]{token});
        ActionResult actionResult = (ActionResult)JSON.toJavaObject((JSON)jsonObject, ActionResult.class);
        boolean bl = b = actionResult != null && ActionResultCode.Success.getCode().equals(actionResult.getCode());
        if (!b) {
            String msg = actionResult != null ? actionResult.getMsg() : MsgCode.FM001.get(new Object[0]);
            throw new WorkFlowException(msg);
        }
    }
}

