/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import jnpf.base.UserInfo;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.mapper.FlowFormDataMapper;
import jnpf.base.model.VisualConst;
import jnpf.base.model.VisualDevJsonModel;
import jnpf.base.model.flow.DataModel;
import jnpf.base.util.DateTimeFormatConstant;
import jnpf.base.util.FormInfoUtils;
import jnpf.base.util.ServiceBaseUtil;
import jnpf.base.util.VisualBillUtil;
import jnpf.config.ConfigValueUtil;
import jnpf.constant.MsgCode;
import jnpf.database.model.dbtable.JdbcTableModel;
import jnpf.database.model.entity.DbLinkEntity;
import jnpf.database.model.interfaces.DbSourceOrDbLink;
import jnpf.database.util.ConnUtil;
import jnpf.database.util.DbTypeUtil;
import jnpf.database.util.DynamicDataSourceUtil;
import jnpf.database.util.TenantDataSourceUtil;
import jnpf.exception.DataException;
import jnpf.exception.WorkFlowException;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.FormCloumnUtil;
import jnpf.model.visualJson.FormDataModel;
import jnpf.model.visualJson.TableFields;
import jnpf.model.visualJson.TableModel;
import jnpf.model.visualJson.analysis.FormAllModel;
import jnpf.model.visualJson.analysis.FormColumnModel;
import jnpf.model.visualJson.analysis.FormColumnTableModel;
import jnpf.model.visualJson.analysis.FormEnum;
import jnpf.model.visualJson.analysis.FormMastTableModel;
import jnpf.model.visualJson.analysis.RecursionForm;
import jnpf.permission.entity.OrganizeEntity;
import jnpf.permission.entity.UserEntity;
import jnpf.util.JsonUtil;
import jnpf.util.RandomUtil;
import jnpf.util.StringUtil;
import jnpf.util.TableFeildsEnum;
import jnpf.util.UserProvider;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.delete.DeleteDSL;
import org.mybatis.dynamic.sql.delete.DeleteModel;
import org.mybatis.dynamic.sql.delete.render.DeleteStatementProvider;
import org.mybatis.dynamic.sql.insert.GeneralInsertDSL;
import org.mybatis.dynamic.sql.insert.render.GeneralInsertStatementProvider;
import org.mybatis.dynamic.sql.render.RenderingStrategies;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.update.UpdateDSL;
import org.mybatis.dynamic.sql.update.UpdateModel;
import org.mybatis.dynamic.sql.update.render.UpdateStatementProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowFormDataUtil {
    private static final Logger log = LoggerFactory.getLogger(FlowFormDataUtil.class);
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private ServiceBaseUtil serviceUtil;
    @Autowired
    private FlowFormDataMapper flowFormDataMapper;
    @Autowired
    private FormInfoUtils formInfoUtils;
    @Autowired
    private VisualBillUtil visualBillUtil;

    public String getTableKey(Connection conn, String tableName) throws SQLException {
        String databaseProductName;
        String pKeyName = JdbcTableModel.getPrimaryExculde((Connection)conn, (String)tableName, (String[])new String[]{this.configValueUtil.getMultiTenantColumn()});
        if (StringUtil.isEmpty((String)pKeyName)) {
            pKeyName = TableFeildsEnum.FID.getField();
        }
        if (DbTypeUtil.needToUpperCase((String)(databaseProductName = conn.getMetaData().getDatabaseProductName().trim()))) {
            pKeyName = pKeyName.toUpperCase();
        }
        return pKeyName;
    }

    public String getKey(TableModel tableModel, String databaseProductName) {
        String pKeyName;
        boolean toUpperCase = false;
        if (StringUtil.isNotEmpty((String)databaseProductName) && DbTypeUtil.needToUpperCase((String)databaseProductName)) {
            toUpperCase = !toUpperCase;
        }
        String string = pKeyName = toUpperCase ? TableFeildsEnum.FID.getField().toUpperCase() : TableFeildsEnum.FID.getField();
        if (tableModel != null && tableModel.getFields() != null) {
            TableFields tableFields = tableModel.getFields().stream().filter(t -> Objects.equals(t.getPrimaryKey(), 1) && !t.getField().toLowerCase().contains(TableFeildsEnum.TENANTID.getField())).findFirst().orElse(null);
            pKeyName = Objects.nonNull(tableFields) ? tableFields.getField() : pKeyName;
        }
        return pKeyName;
    }

    public String getFlowTaskId(TableModel tableModel, String databaseProductName) {
        String pKeyName;
        boolean toUpperCase = false;
        if (StringUtil.isNotEmpty((String)databaseProductName) && DbTypeUtil.needToUpperCase((String)databaseProductName)) {
            toUpperCase = !toUpperCase;
        }
        String string = pKeyName = toUpperCase ? TableFeildsEnum.FLOWTASKID.getField().toUpperCase() : TableFeildsEnum.FLOWTASKID.getField();
        if (tableModel != null && tableModel.getFields() != null) {
            TableFields tableFields = tableModel.getFields().stream().filter(t -> t.getField().toLowerCase().contains(TableFeildsEnum.FLOWTASKID.getField())).findFirst().orElse(null);
            pKeyName = Objects.nonNull(tableFields) ? tableFields.getField() : pKeyName;
        }
        return pKeyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getEditDataInfo(VisualdevEntity visualdevEntity, String id) {
        HashMap<String, Object> allDataMap = new HashMap<String, Object>();
        FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)visualdevEntity.getFormData(), FormDataModel.class);
        Object mainId = id;
        boolean autoIncrement = Objects.equals(formData.getPrimaryKeyPolicy(), 2);
        if (autoIncrement) {
            mainId = Long.parseLong(id);
        }
        String version = "";
        if (formData.getConcurrencyLock().booleanValue()) {
            version = TableFeildsEnum.VERSION.getField();
        }
        List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        List tableModelList = JsonUtil.getJsonToList((String)visualdevEntity.getVisualTables(), TableModel.class);
        RecursionForm recursionForm = new RecursionForm();
        recursionForm.setList(list);
        recursionForm.setTableModelList(tableModelList);
        ArrayList formAllModel = new ArrayList();
        FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
        List mast = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        List table = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        List mastTable = formAllModel.stream().filter(t -> FormEnum.mastTable.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        TableModel mainTable = tableModelList.stream().filter(t -> t.getTypeId().equals("1")).findFirst().orElse(null);
        DbLinkEntity linkEntity = this.serviceUtil.getDbLink(visualdevEntity.getDbLinkId());
        try {
            DynamicDataSourceUtil.switchToDataSource((DbLinkEntity)linkEntity);
            Connection conn = ConnUtil.getConnOrDefault((DbSourceOrDbLink)linkEntity);
            try {
                String dbType = conn.getMetaData().getDatabaseProductName();
                String pKeyName = this.getKey(mainTable, dbType);
                SqlTable mainSqlTable = SqlTable.of((String)mainTable.getTable());
                String flowTaskId = this.getFlowTaskId(mainTable, dbType);
                ArrayList<AndOrCriteriaGroup> groupList = new ArrayList<AndOrCriteriaGroup>();
                groupList.add(SqlBuilder.or((BindableColumn)mainSqlTable.column(flowTaskId), (VisitableCondition)SqlBuilder.isEqualTo((Object)mainId.toString()), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                SelectStatementProvider render = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{mainSqlTable.allColumns()}).from(mainSqlTable).where((BindableColumn)mainSqlTable.column(pKeyName), (VisitableCondition)SqlBuilder.isEqualTo((Object)mainId), groupList)).build()).render(RenderingStrategies.MYBATIS3);
                Map mainAllMap = Optional.ofNullable(this.flowFormDataMapper.selectOneMappedRow(render)).orElse(new HashMap());
                if (mainAllMap.size() == 0) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    return hashMap;
                }
                List mainTableFields = mast.stream().filter(m -> StringUtil.isNotEmpty((String)m.getFormColumnModel().getFieLdsModel().getVModel())).map(s -> s.getFormColumnModel().getFieLdsModel().getVModel()).collect(Collectors.toList());
                if (StringUtil.isNotEmpty((String)version)) {
                    mainTableFields.add(version);
                }
                mainTableFields.add(pKeyName);
                mainTableFields.add(flowTaskId);
                List mainTableBasicColumn = mainTableFields.stream().map(m -> SqlTable.of((String)mainTable.getTable()).column(m)).collect(Collectors.toList());
                SelectStatementProvider mainRender = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select(mainTableBasicColumn).from(mainSqlTable).where((BindableColumn)mainSqlTable.column(pKeyName), (VisitableCondition)SqlBuilder.isEqualTo((Object)mainId), groupList)).build()).render(RenderingStrategies.MYBATIS3);
                Map<String, Object> mainMap = this.flowFormDataMapper.selectOneMappedRow(mainRender);
                if (ObjectUtil.isNotEmpty((Object)mainMap)) {
                    List<FieLdsModel> mainFieldList = mast.stream().filter(m -> StringUtil.isNotEmpty((String)m.getFormColumnModel().getFieLdsModel().getVModel())).map(t -> t.getFormColumnModel().getFieLdsModel()).collect(Collectors.toList());
                    mainMap = this.formInfoUtils.swapDataInfoType(mainFieldList, mainMap);
                    allDataMap.putAll(mainMap);
                    allDataMap.put("flowTaskId", mainMap.get(flowTaskId));
                }
                Map<String, List<FormMastTableModel>> groupByTableNames = mastTable.stream().map(mt -> mt.getFormMastTableModel()).collect(Collectors.groupingBy(ma -> ma.getTable()));
                for (Map.Entry<String, List<FormMastTableModel>> next : groupByTableNames.entrySet()) {
                    SelectStatementProvider mastRender;
                    List childMapList;
                    boolean fogIdTypeString;
                    String childTableName = next.getKey();
                    List<FormMastTableModel> childMastTableList = next.getValue();
                    TableModel childTableModel = tableModelList.stream().filter(t -> t.getTable().equals(childTableName)).findFirst().orElse(null);
                    SqlTable mastSqlTable = SqlTable.of((String)childTableName);
                    List mastTableBasicColumn = childMastTableList.stream().filter(m -> StringUtil.isNotEmpty((String)m.getField())).map(m -> mastSqlTable.column(m.getField())).collect(Collectors.toList());
                    String mainField = childTableModel.getRelationField();
                    Object mainValue = new CaseInsensitiveMap(mainAllMap).get((Object)mainField);
                    String childFoIdFiled = childTableModel.getTableField();
                    TableFields fogIdField = childTableModel.getFields().stream().filter(t -> t.getField().equals(childFoIdFiled)).findFirst().orElse(null);
                    boolean bl = fogIdTypeString = Objects.nonNull(fogIdField) ? fogIdField.getDataType().toLowerCase().contains("varchar") : false;
                    if (fogIdTypeString) {
                        mainValue = mainValue.toString();
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)(childMapList = this.flowFormDataMapper.selectManyMappedRows(mastRender = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select(mastTableBasicColumn).from(mastSqlTable).where((BindableColumn)mastSqlTable.column(childFoIdFiled), (VisitableCondition)SqlBuilder.isEqualTo((Object)mainValue), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3))))) continue;
                    Map soloDataMap = (Map)childMapList.get(0);
                    Map<String, Object> renameKeyMap = new HashMap<String, Object>();
                    for (Map.Entry entry : soloDataMap.entrySet()) {
                        FormMastTableModel model = childMastTableList.stream().filter(child -> child.getField().equalsIgnoreCase(String.valueOf(entry.getKey()))).findFirst().orElse(null);
                        renameKeyMap.put(model.getVModel(), entry.getValue());
                    }
                    List<FieLdsModel> columnChildFields = childMastTableList.stream().map(cl -> cl.getMastTable().getFieLdsModel()).collect(Collectors.toList());
                    renameKeyMap = this.formInfoUtils.swapDataInfoType(columnChildFields, renameKeyMap);
                    allDataMap.putAll(renameKeyMap);
                }
                table.stream().map(t -> t.getChildList()).forEach(t1 -> {
                    try {
                        SelectStatementProvider childRender;
                        List childMapList;
                        String childTableName = t1.getTableName();
                        TableModel tableModel = tableModelList.stream().filter(tm -> tm.getTable().equals(childTableName)).findFirst().orElse(null);
                        SqlTable childSqlTable = SqlTable.of((String)childTableName);
                        List childFields = t1.getChildList().stream().filter(t2 -> StringUtil.isNotEmpty((String)t2.getFieLdsModel().getVModel())).map(t2 -> childSqlTable.column(t2.getFieLdsModel().getVModel())).collect(Collectors.toList());
                        childFields.add(childSqlTable.column(tableModel.getTableField()));
                        String childKeyName = this.getKey(tableModel, dbType);
                        childFields.add(childSqlTable.column(childKeyName));
                        String mainField = tableModel.getRelationField();
                        Object mainValue = new CaseInsensitiveMap(mainAllMap).get((Object)mainField);
                        String childFoIdFiled = tableModel.getTableField();
                        TableFields fogIdField = tableModel.getFields().stream().filter(t -> t.getField().equals(childFoIdFiled)).findFirst().orElse(null);
                        if (VisualConst.DB_INT_ALL.contains(fogIdField.getField().toLowerCase())) {
                            mainValue = Long.parseLong(String.valueOf(mainValue));
                        }
                        if (ObjectUtil.isNotEmpty((Object)(childMapList = this.flowFormDataMapper.selectManyMappedRows(childRender = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select(childFields).from(childSqlTable).where((BindableColumn)childSqlTable.column(childFoIdFiled), (VisitableCondition)SqlBuilder.isEqualTo((Object)mainValue), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3))))) {
                            List childFieldModels = t1.getChildList().stream().map(t2 -> t2.getFieLdsModel()).collect(Collectors.toList());
                            childMapList = childMapList.stream().map(c1 -> {
                                try {
                                    return this.formInfoUtils.swapDataInfoType(childFieldModels, (Map<String, Object>)c1);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    return c1;
                                }
                            }).collect(Collectors.toList());
                            HashMap childMap = new HashMap(1);
                            childMap.put(t1.getTableModel(), childMapList);
                            allDataMap.putAll(childMap);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                for (String key : allDataMap.keySet()) {
                    if (!pKeyName.equalsIgnoreCase(key)) continue;
                    allDataMap.put("id", allDataMap.get(key));
                    break;
                }
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DynamicDataSourceUtil.clearSwitchDataSource();
        }
        return allDataMap;
    }

    @DSTransactional
    public Map<String, Object> create(DataModel dataModel) throws WorkFlowException {
        try {
            Map<String, Object> result = this.createDataList(dataModel);
            return result;
        }
        catch (DataException dataException) {
            throw new WorkFlowException(dataException.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u65b0\u589e\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new WorkFlowException(MsgCode.FA028.get(new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> createDataList(DataModel dataModel) throws SQLException, DataException {
        HashMap<String, Object> result;
        block8: {
            result = new HashMap(16);
            List tableModelList = dataModel.getTableModelList();
            List formAllModel = dataModel.getFormAllModel();
            if (tableModelList.size() > 0) {
                DbLinkEntity link = dataModel.getLink();
                DynamicDataSourceUtil.switchToDataSource((DbLinkEntity)link);
                try {
                    Connection conn = ConnUtil.getConnOrDefault((DbSourceOrDbLink)link);
                    try {
                        String dbType = conn.getMetaData().getDatabaseProductName().trim();
                        dataModel.setDbType(dbType);
                        this.createMast(formAllModel, dataModel, result);
                        this.createTable(formAllModel, dataModel, result);
                        this.createMastTable(formAllModel, dataModel, result);
                        break block8;
                    }
                    finally {
                        if (Collections.singletonList(conn).get(0) != null) {
                            conn.close();
                        }
                    }
                }
                finally {
                    DynamicDataSourceUtil.clearSwitchDataSource();
                }
            }
            result = this.createAll(dataModel, formAllModel);
        }
        return result;
    }

    private void createTable(List<FormAllModel> formAllModel, DataModel dataModel, Map<String, Object> result) throws SQLException {
        List tableModelList = dataModel.getTableModelList();
        Map dataNewMap = dataModel.getDataNewMap();
        boolean autoIncrement = Objects.equals(dataModel.getPrimaryKeyPolicy(), 2);
        String flowId = "";
        if (dataNewMap.get("flowId") != null && StringUtil.isNotEmpty((String)dataNewMap.get("flowId").toString())) {
            flowId = dataNewMap.get("flowId").toString();
        }
        UserEntity userEntity = dataModel.getUserEntity();
        List tableForm = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        HashMap childMap = new HashMap();
        HashMap chidTable = new HashMap();
        tableForm.stream().forEach(t -> {
            FormColumnTableModel childListAll = t.getChildList();
            String tableModel = childListAll.getTableModel();
            List childList = childListAll.getChildList().stream().filter(g -> StringUtil.isNotEmpty((String)g.getFieLdsModel().getVModel())).collect(Collectors.toList());
            childMap.put(tableModel, childList);
            String tableName = childListAll.getTableName();
            Optional<TableModel> first = tableModelList.stream().filter(k -> k.getTable().equals(tableName)).findFirst();
            if (first.isPresent()) {
                TableModel childTable = first.get();
                chidTable.put(tableModel, childTable);
            }
        });
        for (String key : childMap.keySet()) {
            List chidList = dataNewMap.get(key) != null ? (List)dataNewMap.get(key) : new ArrayList();
            List formColumnModels = (List)childMap.get(key);
            TableModel tableModel = (TableModel)chidTable.get(key);
            String table = tableModel.getTable();
            String childKeyName = this.getKey(tableModel, dataModel.getDbType());
            String foreignKey = tableModel.getTableField();
            TableFields foreignField = tableModel.getFields().stream().filter(t -> t.getField().equalsIgnoreCase(foreignKey)).findFirst().orElse(null);
            if (foreignField == null) {
                throw new SQLException(MsgCode.COD001.get(new Object[0]));
            }
            Object foreignValue = dataNewMap.get(tableModel.getRelationField());
            if (VisualConst.DB_INT_ALL.contains(foreignField.getDataType())) {
                foreignValue = Long.parseLong(String.valueOf(foreignValue));
            }
            SqlTable sqlTable = SqlTable.of((String)table);
            for (Map objectMap : chidList) {
                if (StringUtil.isNotEmpty((String)flowId)) {
                    objectMap.put("flowId", flowId);
                }
                GeneralInsertDSL generalInsertDSL = SqlBuilder.insertInto((SqlTable)sqlTable).set(sqlTable.column(foreignKey)).toValue(foreignValue);
                for (FormColumnModel column : formColumnModels) {
                    boolean hasOperate;
                    FieLdsModel fieLdsModel = column.getFieLdsModel();
                    String childKey = fieLdsModel.getVModel();
                    if (Objects.equals(foreignKey, childKey)) continue;
                    Object data = objectMap.get(childKey);
                    String fieldKey = fieLdsModel.getConfig().getParentVModel() + "-" + childKey;
                    if (CollectionUtils.isNotEmpty((Collection)dataModel.getFlowFormOperates()) && !(hasOperate = this.isHasOperate(dataModel, fieldKey))) continue;
                    data = this.create(fieLdsModel, data, true, userEntity, dataModel.isLinkOpen());
                    data = this.visualBillUtil.getBillNumber(dataModel.getVisualId(), fieLdsModel, objectMap, data);
                    this.getDSL(sqlTable, null, generalInsertDSL, fieLdsModel.getFormat(), childKey, data);
                }
                if (!autoIncrement) {
                    generalInsertDSL = generalInsertDSL.set(sqlTable.column(childKeyName)).toValue((Object)RandomUtil.uuId());
                }
                this.addTenantId(generalInsertDSL, sqlTable);
                GeneralInsertStatementProvider insertRender = generalInsertDSL.build().render(RenderingStrategies.MYBATIS3);
                this.flowFormDataMapper.generalInsert(insertRender);
            }
        }
    }

    private void createMastTable(List<FormAllModel> formAllModel, DataModel dataModel, Map<String, Object> result) throws SQLException {
        List tableModelList = dataModel.getTableModelList();
        Map dataNewMap = dataModel.getDataNewMap();
        Integer primaryKeyPolicy = dataModel.getPrimaryKeyPolicy();
        UserEntity userEntity = dataModel.getUserEntity();
        Map<String, List<FormAllModel>> mastTableAll = formAllModel.stream().filter(t -> FormEnum.mastTable.getMessage().equals(t.getJnpfKey())).collect(Collectors.groupingBy(e -> e.getFormMastTableModel().getTable()));
        for (String key : mastTableAll.keySet()) {
            Optional<TableModel> first = tableModelList.stream().filter(t -> t.getTable().equals(key)).findFirst();
            if (!first.isPresent()) {
                throw new SQLException(MsgCode.COD001.get(new Object[0]));
            }
            TableModel tableModel = first.get();
            String tableModelTable = tableModel.getTable();
            String childKeyName = this.getKey(tableModel, dataModel.getDbType());
            String foreignKey = tableModel.getTableField();
            TableFields foreignField = tableModel.getFields().stream().filter(t -> t.getField().equalsIgnoreCase(foreignKey)).findFirst().orElse(null);
            if (foreignField == null) {
                throw new SQLException(MsgCode.COD001.get(new Object[0]));
            }
            Object foreignValue = dataNewMap.get(tableModel.getRelationField());
            if (VisualConst.DB_INT_ALL.contains(foreignField.getDataType())) {
                foreignValue = Long.parseLong(String.valueOf(foreignValue));
            }
            List<FormAllModel> masTableList = mastTableAll.get(key);
            SqlTable sqlTable = SqlTable.of((String)tableModelTable);
            GeneralInsertDSL generalInsertDSL = SqlBuilder.insertInto((SqlTable)sqlTable).set(sqlTable.column(foreignKey)).toValue(foreignValue);
            for (FormAllModel model : masTableList) {
                boolean hasOperate;
                FormMastTableModel formMastTableModel = model.getFormMastTableModel();
                FormColumnModel mastTable = formMastTableModel.getMastTable();
                FieLdsModel fieLdsModel = mastTable.getFieLdsModel();
                String mostTableKey = fieLdsModel.getVModel();
                String field = formMastTableModel.getField();
                if (StringUtil.isEmpty((String)mostTableKey) || Objects.equals(foreignKey, field)) continue;
                Object data = dataNewMap.get(mostTableKey);
                if (CollectionUtils.isNotEmpty((Collection)dataModel.getFlowFormOperates()) && !(hasOperate = this.isHasOperate(dataModel, mostTableKey))) continue;
                data = this.create(fieLdsModel, data, true, userEntity, dataModel.isLinkOpen());
                data = this.visualBillUtil.getBillNumber(dataModel.getVisualId(), fieLdsModel, dataNewMap, data);
                result.put(mostTableKey, data);
                this.getDSL(sqlTable, null, generalInsertDSL, fieLdsModel.getFormat(), field, data);
            }
            if (primaryKeyPolicy == 1) {
                generalInsertDSL = generalInsertDSL.set(sqlTable.column(childKeyName)).toValue((Object)RandomUtil.uuId());
            }
            this.addTenantId(generalInsertDSL, sqlTable);
            GeneralInsertStatementProvider insertRender = generalInsertDSL.build().render(RenderingStrategies.MYBATIS3);
            this.flowFormDataMapper.generalInsert(insertRender);
        }
    }

    private void createMast(List<FormAllModel> formAllModel, DataModel dataModel, Map<String, Object> result) throws SQLException {
        List tableModelList = dataModel.getTableModelList();
        Map dataNewMap = dataModel.getDataNewMap();
        Object mainId = dataModel.getMainId();
        boolean autoIncrement = Objects.equals(dataModel.getPrimaryKeyPolicy(), 2);
        if (autoIncrement) {
            mainId = Long.parseLong(dataModel.getMainId());
        }
        UserEntity userEntity = dataModel.getUserEntity();
        Optional<TableModel> first = tableModelList.stream().filter(t -> "1".equals(t.getTypeId())).findFirst();
        if (!first.isPresent()) {
            throw new SQLException(MsgCode.COD001.get(new Object[0]));
        }
        TableModel tableModel = first.get();
        String mastTableName = tableModel.getTable();
        List mastForm = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getJnpfKey())).filter(t -> StringUtil.isNotEmpty((String)t.getFormColumnModel().getFieLdsModel().getVModel())).collect(Collectors.toList());
        String keyName = this.getKey(tableModel, dataModel.getDbType());
        SqlTable sqlTable = SqlTable.of((String)mastTableName);
        String flowTaskId = this.getFlowTaskId(tableModel, dataModel.getDbType());
        GeneralInsertDSL generalInsertDSL = SqlBuilder.insertInto((SqlTable)sqlTable).set(sqlTable.column(keyName)).toValue(mainId).set(sqlTable.column(flowTaskId)).toValue((Object)mainId.toString());
        if (autoIncrement) {
            generalInsertDSL = SqlBuilder.insertInto((SqlTable)sqlTable).set(sqlTable.column(flowTaskId)).toValue((Object)mainId.toString());
        }
        for (FormAllModel model : mastForm) {
            boolean hasOperate;
            FieLdsModel fieLdsModel = model.getFormColumnModel().getFieLdsModel();
            String field = fieLdsModel.getVModel();
            Object data = dataNewMap.get(field);
            Object object = data = data instanceof List ? JsonUtil.getObjectToString(data) : data;
            if (CollectionUtils.isNotEmpty((Collection)dataModel.getFlowFormOperates()) && !(hasOperate = this.isHasOperate(dataModel, field))) continue;
            data = this.create(fieLdsModel, data, true, userEntity, dataModel.isLinkOpen());
            data = this.visualBillUtil.getBillNumber(dataModel.getVisualId(), fieLdsModel, dataNewMap, data);
            if ("billRule".equals(fieLdsModel.getConfig().getJnpfKey())) {
                dataNewMap.put(field, data);
            }
            this.getDSL(sqlTable, null, generalInsertDSL, fieLdsModel.getFormat(), field, data);
        }
        if (dataModel.getConcurrencyLock().booleanValue()) {
            generalInsertDSL = generalInsertDSL.set(sqlTable.column(TableFeildsEnum.VERSION.getField())).toValue(dataNewMap.get(TableFeildsEnum.VERSION.getField()));
        }
        if (dataNewMap.get("flowId") != null && StringUtil.isNotEmpty((String)dataNewMap.get("flowId").toString())) {
            generalInsertDSL = generalInsertDSL.set(sqlTable.column(TableFeildsEnum.FLOWID.getField())).toValue(dataNewMap.get("flowId"));
        }
        this.addTenantId(generalInsertDSL, sqlTable);
        GeneralInsertStatementProvider insertRender = generalInsertDSL.build().render(RenderingStrategies.MYBATIS3);
        this.flowFormDataMapper.generalInsert(insertRender);
        this.getRealMainId(dataModel, tableModel, keyName, autoIncrement, mastTableName, mainId);
        dataNewMap.put(keyName, dataModel.getMainId());
    }

    private void getRealMainId(DataModel dataModel, TableModel tableModel, String realIdKey, boolean autoIncrement, String mastTableName, Object flowTaskId) {
        if (autoIncrement) {
            String flowTaskKey = this.getFlowTaskId(tableModel, dataModel.getDbType());
            ArrayList<String> mastFile = new ArrayList<String>();
            mastFile.add(flowTaskKey);
            mastFile.add(realIdKey);
            SqlTable mastSqlTable = SqlTable.of((String)mastTableName);
            SelectStatementProvider mastRender = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((Collection)mastFile.stream().map(m -> mastSqlTable.column(m)).collect(Collectors.toList())).from(mastSqlTable).where((BindableColumn)mastSqlTable.column(flowTaskKey), (VisitableCondition)SqlBuilder.isEqualTo((Object)flowTaskId.toString()), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            Map map = this.flowFormDataMapper.selectOneMappedRow(mastRender);
            dataModel.setMainId(map.get(realIdKey) != null ? map.get(realIdKey).toString() : dataModel.getMainId());
        }
    }

    private Object create(FieLdsModel fieLdsModel, Object dataValue, boolean isTable, UserEntity userEntity, boolean isLink) {
        String jnpfKey = fieLdsModel.getConfig().getJnpfKey();
        String rule = fieLdsModel.getConfig().getRule();
        String format = DateTimeFormatConstant.getFormat(fieLdsModel.getFormat());
        Object value = dataValue;
        if (isLink) {
            ArrayList<String> systemAttList = new ArrayList<String>();
            systemAttList.add("createUser");
            systemAttList.add("currOrganize");
            systemAttList.add("currPosition");
            systemAttList.add("currDept");
            systemAttList.add("modifyUser");
            if (systemAttList.contains(jnpfKey)) {
                return null;
            }
        }
        switch (jnpfKey) {
            case "createUser": {
                value = userEntity.getId();
                break;
            }
            case "createTime": {
                value = new Date();
                break;
            }
            case "currOrganize": 
            case "currDept": {
                value = this.getCurrentOrgIds(userEntity.getOrganizeId(), fieLdsModel.getShowLevel());
                break;
            }
            case "modifyTime": {
                value = null;
                break;
            }
            case "modifyUser": {
                value = null;
                break;
            }
            case "currPosition": {
                value = userEntity.getPositionId();
                break;
            }
            case "billRule": {
                if (fieLdsModel.getConfig().getRuleType() != null && !Objects.equals(fieLdsModel.getConfig().getRuleType(), 1)) break;
                try {
                    value = this.serviceUtil.getBillNumber(rule);
                }
                catch (Exception e) {
                    value = null;
                }
                break;
            }
            case "datePicker": {
                if (!isTable) break;
                try {
                    if (dataValue == null || "".equals(dataValue)) {
                        return null;
                    }
                    if (dataValue instanceof String) {
                        try {
                            SimpleDateFormat formatter = new SimpleDateFormat(format);
                            value = formatter.parse(dataValue.toString());
                            break;
                        }
                        catch (ParseException var3) {
                            return null;
                        }
                    }
                    value = new Date(Long.valueOf(String.valueOf(dataValue)));
                }
                catch (Exception exception) {}
                break;
            }
            case "inputNumber": 
            case "calculate": {
                if (!isTable) break;
                try {
                    value = new BigDecimal(String.valueOf(dataValue));
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                if (!isTable) break;
                value = this.valueToNull(value);
            }
        }
        return value;
    }

    private Map<String, Object> createAll(DataModel dataModel, List<FormAllModel> formAllModel) {
        Map dataNewMap = dataModel.getDataNewMap();
        UserEntity userEntity = dataModel.getUserEntity();
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        List mastForm = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        List tableForm = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        for (String key : dataNewMap.keySet()) {
            FormAllModel model = mastForm.stream().filter(t -> key.equals(t.getFormColumnModel().getFieLdsModel().getVModel())).findFirst().orElse(null);
            if (model != null) {
                FieLdsModel fieLdsModel = model.getFormColumnModel().getFieLdsModel();
                Object data = dataNewMap.get(key);
                data = this.create(fieLdsModel, data, false, userEntity, dataModel.isLinkOpen());
                result.put(key, data);
                continue;
            }
            FormAllModel childModel = tableForm.stream().filter(t -> key.equals(t.getChildList().getTableModel())).findFirst().orElse(null);
            if (childModel == null) continue;
            List childList = childModel.getChildList().getChildList();
            List childDataMap = (List)dataNewMap.get(key);
            ArrayList childResult = new ArrayList();
            for (Map objectMap : childDataMap) {
                HashMap childOneResult = new HashMap(16);
                for (String childKey : objectMap.keySet()) {
                    FormColumnModel columnModel = childList.stream().filter(t -> childKey.equals(t.getFieLdsModel().getVModel())).findFirst().orElse(null);
                    if (columnModel == null) continue;
                    FieLdsModel fieLdsModel = columnModel.getFieLdsModel();
                    Object data = objectMap.get(childKey);
                    data = this.create(fieLdsModel, data, false, userEntity, dataModel.isLinkOpen());
                    childOneResult.put(childKey, data);
                }
                childResult.add(childOneResult);
            }
            result.put(key, childResult);
        }
        return result;
    }

    @DSTransactional
    public Map<String, Object> update(DataModel dataModel) throws WorkFlowException {
        try {
            Map<String, Object> result = this.updateDataList(dataModel);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4fee\u6539\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new WorkFlowException(MsgCode.FA029.get(new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> updateDataList(DataModel dataModel) throws SQLException, DataException {
        HashMap<String, Object> result;
        block8: {
            result = new HashMap(16);
            List tableModelList = dataModel.getTableModelList();
            List formAllModel = dataModel.getFormAllModel();
            if (tableModelList.size() > 0) {
                DbLinkEntity link = dataModel.getLink();
                DynamicDataSourceUtil.switchToDataSource((DbLinkEntity)link);
                try {
                    Connection conn = ConnUtil.getConnOrDefault((DbSourceOrDbLink)link);
                    try {
                        String dbType = conn.getMetaData().getDatabaseProductName().trim();
                        dataModel.setDbType(dbType);
                        conn.setAutoCommit(false);
                        this.updateMast(formAllModel, dataModel, conn, result);
                        this.updateTable(formAllModel, dataModel, conn, result);
                        this.updateMastTable(formAllModel, dataModel, conn, result);
                        break block8;
                    }
                    finally {
                        if (Collections.singletonList(conn).get(0) != null) {
                            conn.close();
                        }
                    }
                }
                finally {
                    DynamicDataSourceUtil.clearSwitchDataSource();
                }
            }
            result = this.updateAll(dataModel, formAllModel);
        }
        return result;
    }

    private void updateTable(List<FormAllModel> formAllModel, DataModel dataModel, Connection conn, Map<String, Object> result) throws SQLException {
        Boolean onlyUpdate = dataModel.getOnlyUpdate();
        List tableModelList = dataModel.getTableModelList();
        Map dataNewMap = dataModel.getDataNewMap();
        Map oldMainData = dataModel.getOldMainData();
        if (MapUtils.isEmpty((Map)oldMainData)) {
            return;
        }
        boolean autoIncrement = Objects.equals(dataModel.getPrimaryKeyPolicy(), 2);
        String flowId = "";
        if (dataNewMap.get("flowId") != null && StringUtil.isNotEmpty((String)dataNewMap.get("flowId").toString())) {
            flowId = dataNewMap.get("flowId").toString();
        }
        List tableForm = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        HashMap childMap = new HashMap();
        HashMap chidTable = new HashMap();
        tableForm.stream().forEach(t -> {
            FormColumnTableModel childListAll = t.getChildList();
            String tableModel = childListAll.getTableModel();
            List childList = childListAll.getChildList().stream().filter(g -> StringUtil.isNotEmpty((String)g.getFieLdsModel().getVModel())).collect(Collectors.toList());
            childMap.put(tableModel, childList);
            String tableName = childListAll.getTableName();
            Optional<TableModel> first = tableModelList.stream().filter(k -> k.getTable().equals(tableName)).findFirst();
            if (first.isPresent()) {
                TableModel childTable = first.get();
                chidTable.put(tableModel, childTable);
            }
        });
        for (String key : childMap.keySet()) {
            List chidList = dataNewMap.get(key) != null ? (List)dataNewMap.get(key) : new ArrayList();
            List formColumnModels = (List)childMap.get(key);
            TableModel tableModel = (TableModel)chidTable.get(key);
            String table = tableModel.getTable();
            SqlTable sqlTable = SqlTable.of((String)table);
            String childPrimary = this.getKey(tableModel, dataModel.getDbType());
            String foreignKey = tableModel.getTableField();
            TableFields foreignField = tableModel.getFields().stream().filter(t -> t.getField().equalsIgnoreCase(foreignKey)).findFirst().orElse(null);
            if (foreignField == null) {
                throw new SQLException(MsgCode.COD001.get(new Object[0]));
            }
            Object foreignValue = dataNewMap.get(tableModel.getRelationField());
            Object oldForeignValue = oldMainData.get(tableModel.getRelationField());
            if (VisualConst.DB_INT_ALL.contains(foreignField.getDataType())) {
                foreignValue = Long.parseLong(String.valueOf(foreignValue));
                oldForeignValue = Long.parseLong(String.valueOf(oldForeignValue));
            }
            SelectStatementProvider render = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{sqlTable.column(childPrimary)}).from(sqlTable).where((BindableColumn)sqlTable.column(foreignKey), (VisitableCondition)SqlBuilder.isEqualTo(oldForeignValue), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            List childIdList = this.flowFormDataMapper.selectManyMappedRows(render).stream().map(t -> new CaseInsensitiveMap(t).get((Object)childPrimary)).collect(Collectors.toList());
            List formDataIdList = chidList.stream().filter(t -> new CaseInsensitiveMap(t).containsKey((Object)childPrimary)).map(t -> new CaseInsensitiveMap(t).get((Object)childPrimary)).collect(Collectors.toList());
            List deleteList = childIdList.stream().filter(t -> !formDataIdList.contains(t)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(deleteList) && !onlyUpdate.booleanValue()) {
                DeleteStatementProvider deleteRender = ((DeleteModel)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)sqlTable).where((BindableColumn)sqlTable.column(childPrimary), (VisitableCondition)SqlBuilder.isIn(deleteList), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
                this.flowFormDataMapper.delete(deleteRender);
            }
            for (Map objectMap : chidList) {
                objectMap = new CaseInsensitiveMap(objectMap);
                if (StringUtil.isNotEmpty((String)flowId)) {
                    objectMap.put("flowId", flowId);
                }
                GeneralInsertDSL generalInsertDSL = SqlBuilder.insertInto((SqlTable)sqlTable).set(sqlTable.column(foreignKey)).toValue(foreignValue);
                UpdateDSL updateModelUpdateDSL = SqlBuilder.update((SqlTable)sqlTable).set(sqlTable.column(foreignKey)).equalTo(foreignValue);
                for (FormColumnModel column : formColumnModels) {
                    boolean hasOperate;
                    FieLdsModel fieLdsModel = column.getFieLdsModel();
                    String childKey = fieLdsModel.getVModel();
                    String jnpfkey = fieLdsModel.getConfig().getJnpfKey();
                    Object data = objectMap.get(childKey);
                    String fieldKey = fieLdsModel.getConfig().getParentVModel() + "-" + childKey;
                    if (foreignKey.equalsIgnoreCase(childKey) || CollectionUtils.isNotEmpty((Collection)dataModel.getFlowFormOperates()) && !(hasOperate = this.isHasOperate(dataModel, fieldKey)) || (objectMap.get(childPrimary) == null || !childIdList.contains(objectMap.get(childPrimary)) ? "modifyUser".equals(jnpfkey) || "modifyTime".equals(jnpfkey) : "currOrganize".equals(jnpfkey) || "currPosition".equals(jnpfkey) || "createTime".equals(jnpfkey) || "createUser".equals(jnpfkey))) continue;
                    data = this.update(fieLdsModel, data, true, objectMap.get(childPrimary) == null);
                    data = this.visualBillUtil.getBillNumber(dataModel.getVisualId(), fieLdsModel, objectMap, data);
                    this.getDSL(sqlTable, null, generalInsertDSL, fieLdsModel.getFormat(), childKey, data);
                    this.getDSL(sqlTable, (UpdateDSL<UpdateModel>)updateModelUpdateDSL, null, fieLdsModel.getFormat(), childKey, data);
                }
                if (objectMap.get(childPrimary) != null && childIdList.contains(objectMap.get(childPrimary))) {
                    updateModelUpdateDSL.where((BindableColumn)sqlTable.column(childPrimary), (VisitableCondition)SqlBuilder.isEqualTo(objectMap.get(childPrimary)), new AndOrCriteriaGroup[0]);
                    UpdateStatementProvider render1 = ((UpdateModel)updateModelUpdateDSL.build()).render(RenderingStrategies.MYBATIS3);
                    this.flowFormDataMapper.update(render1);
                    continue;
                }
                if (!autoIncrement) {
                    generalInsertDSL = generalInsertDSL.set(sqlTable.column(childPrimary)).toValue((Object)RandomUtil.uuId());
                }
                this.addTenantId(generalInsertDSL, sqlTable);
                GeneralInsertStatementProvider insertRender = generalInsertDSL.build().render(RenderingStrategies.MYBATIS3);
                this.flowFormDataMapper.generalInsert(insertRender);
            }
        }
    }

    private void updateMastTable(List<FormAllModel> formAllModel, DataModel dataModel, Connection conn, Map<String, Object> result) throws SQLException {
        List tableModelList = dataModel.getTableModelList();
        Map dataNewMap = dataModel.getDataNewMap();
        Map oldMainData = dataModel.getOldMainData();
        if (MapUtils.isEmpty((Map)oldMainData)) {
            return;
        }
        Map<String, List<FormAllModel>> mastTableAll = formAllModel.stream().filter(t -> FormEnum.mastTable.getMessage().equals(t.getJnpfKey())).collect(Collectors.groupingBy(e -> e.getFormMastTableModel().getTable()));
        for (String key : mastTableAll.keySet()) {
            List<FormAllModel> masTableList = mastTableAll.get(key);
            Optional<TableModel> first = tableModelList.stream().filter(t -> t.getTable().equals(key)).findFirst();
            if (!first.isPresent()) {
                throw new SQLException(MsgCode.COD001.get(new Object[0]));
            }
            TableModel tableModel = first.get();
            String tableModelTable = tableModel.getTable();
            SqlTable sqlTable = SqlTable.of((String)tableModelTable);
            String childKeyName = this.getKey(tableModel, dataModel.getDbType());
            String foreignKey = tableModel.getTableField();
            TableFields foreignField = tableModel.getFields().stream().filter(t -> t.getField().equalsIgnoreCase(foreignKey)).findFirst().orElse(null);
            if (foreignField == null) {
                throw new SQLException(MsgCode.COD001.get(new Object[0]));
            }
            Object foreignValue = dataNewMap.get(tableModel.getRelationField());
            Object oldForeignValue = oldMainData.get(tableModel.getRelationField());
            if (VisualConst.DB_INT_ALL.contains(foreignField.getDataType())) {
                foreignValue = Long.parseLong(String.valueOf(foreignValue));
                oldForeignValue = Long.parseLong(String.valueOf(oldForeignValue));
            }
            UpdateDSL updateModelUpdateDSL = SqlBuilder.update((SqlTable)sqlTable).set(sqlTable.column(foreignKey)).equalTo(foreignValue);
            for (FormAllModel model : masTableList) {
                boolean hasOperate;
                FormMastTableModel formMastTableModel = model.getFormMastTableModel();
                FormColumnModel mastTable = formMastTableModel.getMastTable();
                FieLdsModel fieLdsModel = mastTable.getFieLdsModel();
                String mostTableKey = fieLdsModel.getVModel();
                String jnpfkey = fieLdsModel.getConfig().getJnpfKey();
                Object data = dataNewMap.get(mostTableKey);
                String field = formMastTableModel.getField();
                if (foreignKey.equalsIgnoreCase(field) || CollectionUtils.isNotEmpty((Collection)dataModel.getFlowFormOperates()) && !(hasOperate = this.isHasOperate(dataModel, mostTableKey)) || "currOrganize".equals(jnpfkey) || "currPosition".equals(jnpfkey) || "createTime".equals(jnpfkey) || "createUser".equals(jnpfkey)) continue;
                data = this.update(fieLdsModel, data, true, false);
                data = this.visualBillUtil.getBillNumber(dataModel.getVisualId(), fieLdsModel, dataNewMap, data);
                this.getDSL(sqlTable, (UpdateDSL<UpdateModel>)updateModelUpdateDSL, null, fieLdsModel.getFormat(), field, data);
            }
            UpdateStatementProvider updateStatementProvider = ((UpdateModel)((UpdateDSL.UpdateWhereBuilder)updateModelUpdateDSL.where((BindableColumn)sqlTable.column(foreignKey), (VisitableCondition)SqlBuilder.isEqualTo(oldForeignValue), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            this.flowFormDataMapper.update(updateStatementProvider);
        }
    }

    private void updateMast(List<FormAllModel> formAllModel, DataModel dataModel, Connection conn, Map<String, Object> result) throws SQLException {
        List tableModelList = dataModel.getTableModelList();
        Map dataNewMap = dataModel.getDataNewMap();
        List mastForm = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getJnpfKey())).filter(t -> StringUtil.isNotEmpty((String)t.getFormColumnModel().getFieLdsModel().getVModel())).collect(Collectors.toList());
        Optional<TableModel> first = tableModelList.stream().filter(t -> "1".equals(t.getTypeId())).findFirst();
        if (!first.isPresent()) {
            throw new SQLException(MsgCode.COD001.get(new Object[0]));
        }
        TableModel tableModel = first.get();
        String mastTableName = tableModel.getTable();
        SqlTable sqlTable = SqlTable.of((String)mastTableName);
        TableFields keyFieldModel = tableModel.getFields().stream().filter(t -> Objects.equals(t.getPrimaryKey(), 1) && !t.getField().toLowerCase().contains(TableFeildsEnum.TENANTID.getField())).findFirst().orElse(null);
        if (keyFieldModel == null) {
            throw new SQLException(MsgCode.COD001.get(new Object[0]));
        }
        String keyName = keyFieldModel.getField();
        Object mainId = dataModel.getMainId();
        if (VisualConst.DB_INT_ALL.contains(keyFieldModel.getField().toLowerCase())) {
            mainId = Long.parseLong(dataModel.getMainId());
        }
        dataNewMap.put(keyName, mainId);
        SelectStatementProvider render = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{sqlTable.allColumns()}).from(sqlTable).where((BindableColumn)sqlTable.column(keyName), (VisitableCondition)SqlBuilder.isEqualTo((Object)mainId), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
        List maps = this.flowFormDataMapper.selectManyMappedRows(render);
        if (CollectionUtils.isEmpty((Collection)maps)) {
            return;
        }
        dataModel.setOldMainData((Map)maps.get(0));
        UpdateDSL updateModelUpdateDSL = SqlBuilder.update((SqlTable)sqlTable);
        int num = 0;
        for (FormAllModel model : mastForm) {
            boolean hasOperate;
            FieLdsModel fieLdsModel = model.getFormColumnModel().getFieLdsModel();
            String jnpfkey = fieLdsModel.getConfig().getJnpfKey();
            String field = fieLdsModel.getVModel();
            Object data = dataNewMap.get(field);
            if (CollectionUtils.isNotEmpty((Collection)dataModel.getFlowFormOperates()) && !(hasOperate = this.isHasOperate(dataModel, field)) || "currOrganize".equals(jnpfkey) || "currPosition".equals(jnpfkey) || "createTime".equals(jnpfkey) || "createUser".equals(jnpfkey)) continue;
            data = this.update(fieLdsModel, data, true, false);
            data = this.visualBillUtil.getBillNumber(dataModel.getVisualId(), fieLdsModel, dataNewMap, data);
            this.getDSL(sqlTable, (UpdateDSL<UpdateModel>)updateModelUpdateDSL, null, fieLdsModel.getFormat(), field, data);
            ++num;
        }
        if (dataModel.getConcurrencyLock().booleanValue()) {
            updateModelUpdateDSL = updateModelUpdateDSL.set(sqlTable.column(TableFeildsEnum.VERSION.getField())).equalTo(dataNewMap.get(TableFeildsEnum.VERSION.getField()));
        }
        if (dataNewMap.get("flowId") != null && StringUtil.isNotEmpty((String)dataNewMap.get("flowId").toString())) {
            updateModelUpdateDSL = updateModelUpdateDSL.set(sqlTable.column(TableFeildsEnum.FLOWID.getField())).equalTo(dataNewMap.get("flowId"));
        }
        UpdateStatementProvider updateStatementProvider = ((UpdateModel)((UpdateDSL.UpdateWhereBuilder)updateModelUpdateDSL.where((BindableColumn)sqlTable.column(keyName), (VisitableCondition)SqlBuilder.isEqualTo((Object)mainId), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
        if (num > 0) {
            this.flowFormDataMapper.update(updateStatementProvider);
        }
    }

    private Map<String, Object> updateAll(DataModel dataModel, List<FormAllModel> formAllModel) {
        Map dataNewMap = dataModel.getDataNewMap();
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        List mastForm = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        List tableForm = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        for (String key : dataNewMap.keySet()) {
            FormAllModel model = mastForm.stream().filter(t -> key.equals(t.getFormColumnModel().getFieLdsModel().getVModel())).findFirst().orElse(null);
            if (model != null) {
                FieLdsModel fieLdsModel = model.getFormColumnModel().getFieLdsModel();
                Object data = dataNewMap.get(key);
                data = this.update(fieLdsModel, data, false, false);
                result.put(key, data);
                continue;
            }
            FormAllModel childModel = tableForm.stream().filter(t -> key.equals(t.getChildList().getTableModel())).findFirst().orElse(null);
            if (childModel == null) continue;
            List childDataMap = (List)dataNewMap.get(key);
            ArrayList childResult = new ArrayList();
            for (Map objectMap : childDataMap) {
                HashMap childOneResult = new HashMap(16);
                for (String childKey : objectMap.keySet()) {
                    FormColumnModel columnModel = childModel.getChildList().getChildList().stream().filter(t -> childKey.equals(t.getFieLdsModel().getVModel())).findFirst().orElse(null);
                    if (columnModel == null) continue;
                    FieLdsModel fieLdsModel = columnModel.getFieLdsModel();
                    Object data = objectMap.get(childKey);
                    data = this.update(fieLdsModel, data, false, false);
                    childOneResult.put(childKey, data);
                }
                childResult.add(childOneResult);
            }
            result.put(key, childResult);
        }
        return result;
    }

    private Object update(FieLdsModel fieLdsModel, Object dataValue, boolean isTable, boolean childNeedAdd) {
        String jnpfKey = fieLdsModel.getConfig().getJnpfKey();
        String rule = fieLdsModel.getConfig().getRule();
        String format = DateTimeFormatConstant.getFormat(fieLdsModel.getFormat());
        UserInfo userInfo = UserProvider.getUser();
        Object value = dataValue;
        switch (jnpfKey) {
            case "createUser": {
                value = userInfo.getUserId();
                break;
            }
            case "createTime": {
                value = new Date();
                break;
            }
            case "currOrganize": 
            case "currDept": {
                value = this.getCurrentOrgIds(userInfo.getOrganizeId(), fieLdsModel.getShowLevel());
                break;
            }
            case "modifyTime": {
                if (childNeedAdd) break;
                value = new Date();
                break;
            }
            case "modifyUser": {
                if (childNeedAdd) break;
                value = userInfo.getUserId();
                break;
            }
            case "currPosition": {
                value = userInfo.getPositionIds() != null && userInfo.getPositionIds().length > 0 ? userInfo.getPositionIds()[0] : "";
                break;
            }
            case "billRule": {
                if (!Objects.equals(fieLdsModel.getConfig().getRuleType(), 1) || !childNeedAdd && !ObjectUtil.isEmpty((Object)dataValue)) break;
                try {
                    value = this.serviceUtil.getBillNumber(rule);
                }
                catch (Exception e) {
                    value = null;
                }
                break;
            }
            case "datePicker": {
                if (!isTable) break;
                try {
                    if (dataValue == null || "".equals(dataValue)) {
                        return null;
                    }
                    if (dataValue instanceof String) {
                        try {
                            SimpleDateFormat formatter = new SimpleDateFormat(format);
                            value = formatter.parse(dataValue.toString());
                            break;
                        }
                        catch (ParseException var3) {
                            return null;
                        }
                    }
                    value = new Date(Long.valueOf(String.valueOf(dataValue)));
                }
                catch (Exception exception) {}
                break;
            }
            case "inputNumber": 
            case "calculate": {
                if (!isTable) break;
                try {
                    value = new BigDecimal(String.valueOf(dataValue));
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                if (!isTable) break;
                value = this.valueToNull(value);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DSTransactional
    public boolean deleteTable(String id, VisualDevJsonModel visualDevJsonModel, DbLinkEntity linkEntity) throws Exception {
        Boolean logicalDelete = visualDevJsonModel.getFormData().getLogicalDelete();
        Integer primaryKeyPolicy = visualDevJsonModel.getFormData().getPrimaryKeyPolicy();
        List tableModels = visualDevJsonModel.getVisualTables();
        TableModel mainTableModel = tableModels.stream().filter(t -> "1".equals(t.getTypeId())).findFirst().orElse(null);
        String mainTable = mainTableModel.getTable();
        DynamicDataSourceUtil.switchToDataSource((DbLinkEntity)linkEntity);
        try {
            Connection conn = ConnUtil.getConnOrDefault((DbSourceOrDbLink)linkEntity);
            try {
                SelectStatementProvider queryMain;
                Map mainMap;
                String dbType = conn.getMetaData().getDatabaseProductName().trim();
                String pKeyName = this.getKey(mainTableModel, dbType);
                String flowTaskId = this.getFlowTaskId(mainTableModel, dbType);
                ArrayList<AndOrCriteriaGroup> groupList = new ArrayList<AndOrCriteriaGroup>();
                groupList.add(SqlBuilder.or((BindableColumn)SqlTable.of((String)mainTable).column(flowTaskId), (VisitableCondition)SqlBuilder.isEqualTo((Object)id), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                boolean autoIncrement = Objects.equals(primaryKeyPolicy, 2);
                Object selectId = id;
                if (autoIncrement) {
                    selectId = Long.parseLong(id);
                }
                if (MapUtils.isNotEmpty((Map)(mainMap = this.flowFormDataMapper.selectOneMappedRow(queryMain = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{SqlTable.of((String)mainTable).allColumns()}).from(SqlTable.of((String)mainTable)).where((BindableColumn)SqlTable.of((String)mainTable).column(pKeyName), (VisitableCondition)SqlBuilder.isEqualTo((Object)selectId), groupList)).build()).render(RenderingStrategies.MYBATIS3))))) {
                    Object realId = mainMap.get(pKeyName);
                    if (logicalDelete.booleanValue()) {
                        SqlTable sqlt = SqlTable.of((String)mainTable);
                        UpdateDSL updateModelUpdateDSL = SqlBuilder.update((SqlTable)sqlt);
                        updateModelUpdateDSL.set(sqlt.column(TableFeildsEnum.DELETEMARK.getField())).equalTo((Object)1);
                        updateModelUpdateDSL.set(sqlt.column(TableFeildsEnum.DELETETIME.getField())).equalTo((Object)new Date());
                        updateModelUpdateDSL.set(sqlt.column(TableFeildsEnum.DELETEUSERID.getField())).equalTo((Object)UserProvider.getUser().getUserId());
                        UpdateStatementProvider mainUpdate = ((UpdateModel)((UpdateDSL.UpdateWhereBuilder)updateModelUpdateDSL.where((BindableColumn)SqlTable.of((String)mainTable).column(pKeyName), (VisitableCondition)SqlBuilder.isEqualTo(realId), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
                        this.flowFormDataMapper.update(mainUpdate);
                    } else {
                        DeleteStatementProvider mainDelete = ((DeleteModel)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)SqlTable.of((String)mainTable)).where((BindableColumn)SqlTable.of((String)mainTable).column(pKeyName), (VisitableCondition)SqlBuilder.isEqualTo(realId), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
                        this.flowFormDataMapper.delete(mainDelete);
                    }
                    if (tableModels.size() > 1) {
                        tableModels.remove(mainTableModel);
                        for (TableModel table : tableModels) {
                            Object relationFieldValue = mainMap.get(table.getRelationField());
                            String tableField = table.getTableField();
                            if (logicalDelete.booleanValue()) {
                                SqlTable sqlt = SqlTable.of((String)table.getTable());
                                UpdateDSL updateModelUpdateDSL = SqlBuilder.update((SqlTable)sqlt);
                                updateModelUpdateDSL.set(sqlt.column(TableFeildsEnum.DELETEMARK.getField())).equalTo((Object)1);
                                updateModelUpdateDSL.set(sqlt.column(TableFeildsEnum.DELETETIME.getField())).equalTo((Object)new Date());
                                updateModelUpdateDSL.set(sqlt.column(TableFeildsEnum.DELETEUSERID.getField())).equalTo((Object)UserProvider.getUser().getUserId());
                                UpdateStatementProvider mainUpdate = ((UpdateModel)((UpdateDSL.UpdateWhereBuilder)updateModelUpdateDSL.where((BindableColumn)SqlTable.of((String)table.getTable()).column(tableField), (VisitableCondition)SqlBuilder.isEqualTo(relationFieldValue), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
                                this.flowFormDataMapper.update(mainUpdate);
                                continue;
                            }
                            DeleteStatementProvider childDeleteProvider = ((DeleteModel)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)SqlTable.of((String)table.getTable())).where((BindableColumn)SqlTable.of((String)table.getTable()).column(tableField), (VisitableCondition)SqlBuilder.isEqualTo(relationFieldValue), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
                            this.flowFormDataMapper.delete(childDeleteProvider);
                        }
                    }
                }
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        }
        finally {
            DynamicDataSourceUtil.clearSwitchDataSource();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getVersion(String table, DbLinkEntity linkEntity, Map dataMap, Object id) {
        boolean canUpdate = true;
        try {
            DynamicDataSourceUtil.switchToDataSource((DbLinkEntity)linkEntity);
            Connection conn = ConnUtil.getConnOrDefault((DbSourceOrDbLink)linkEntity);
            try {
                String pKeyName = this.getTableKey(conn, table);
                SqlTable sqlTable = SqlTable.of((String)table);
                SelectStatementProvider render = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{sqlTable.column(TableFeildsEnum.VERSION.getField())}).from(sqlTable).where((BindableColumn)sqlTable.column(pKeyName), (VisitableCondition)SqlBuilder.isEqualTo((Object)id), new AndOrCriteriaGroup[0])).and((BindableColumn)sqlTable.column(TableFeildsEnum.VERSION.getField()), (VisitableCondition)SqlBuilder.isEqualTo(dataMap.get(TableFeildsEnum.VERSION.getField())), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
                int count = this.flowFormDataMapper.selectManyMappedRows(render).size();
                canUpdate = count > 0;
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        }
        catch (SQLException | DataException e) {
            log.error("\u5207\u6362\u6570\u636e\u6e90\u5f02\u5e38");
        }
        finally {
            DynamicDataSourceUtil.clearSwitchDataSource();
        }
        return canUpdate;
    }

    private void getDSL(SqlTable sqlTable, UpdateDSL<UpdateModel> updateModelUpdateDSL, GeneralInsertDSL generalInsertDSL, String format, String field, Object data) {
        String dateFunc;
        boolean dataTimestamp = StringUtil.isNotEmpty((String)format) ? format.length() > 10 : true;
        String string = dateFunc = dataTimestamp ? "to_timestamp" : "to_date";
        if (data == null || StringUtil.isEmpty((String)data.toString())) {
            if (generalInsertDSL != null) {
                generalInsertDSL = generalInsertDSL.set(sqlTable.column(field)).toNull();
            } else {
                updateModelUpdateDSL = updateModelUpdateDSL.set(sqlTable.column(field)).equalToNull();
            }
        } else if (generalInsertDSL != null) {
            generalInsertDSL = generalInsertDSL.set(sqlTable.column(field)).toValue(data);
        } else {
            updateModelUpdateDSL = updateModelUpdateDSL.set(sqlTable.column(field)).equalTo(data);
        }
    }

    private Object valueToNull(Object value) {
        if (value instanceof List || value instanceof String[][]) {
            List l = (List)value;
            value = l.size() > 0 ? JsonUtil.getObjectToString((Object)value) : null;
        } else if (value instanceof CharSequence && (StrUtil.isEmpty((CharSequence)((CharSequence)value)) || "[]".equals(value))) {
            value = null;
        }
        return value;
    }

    public String getCurrentOrgIds(String orgId, String showLevel) {
        String orgIds = null;
        OrganizeEntity organizeEntity = this.serviceUtil.getOrganizeInfo(orgId);
        if (organizeEntity != null && StringUtil.isNotEmpty((String)organizeEntity.getOrganizeIdTree())) {
            String[] split = organizeEntity.getOrganizeIdTree().split(",");
            String string = orgIds = split.length > 0 ? JsonUtil.getObjectToString(Arrays.asList(split)) : null;
        }
        if (!"all".equals(showLevel) && organizeEntity != null && "company".equals(organizeEntity.getCategory())) {
            orgIds = null;
        }
        return orgIds;
    }

    public String getCurrentOrganizeName(Object value, String showLevel) {
        return this.serviceUtil.getCurrentOrganizeName(value, showLevel);
    }

    private boolean isHasOperate(DataModel dataModel, String field) {
        boolean hasOperate = true;
        for (Map item : dataModel.getFlowFormOperates()) {
            if (!field.equals(item.get("id")) || item.get("write") != null && !"false".equals(item.get("write").toString())) continue;
            hasOperate = false;
        }
        return hasOperate;
    }

    private void addTenantId(GeneralInsertDSL generalInsertDSL, SqlTable sqlTable) {
        String tenantId = TenantDataSourceUtil.getTenantColumn();
        generalInsertDSL.set(sqlTable.column(TableFeildsEnum.TENANTID.getField())).toValue((Object)tenantId);
    }
}

