/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.util;

import cn.hutool.core.bean.BeanUtil;
import java.util.List;
import jnpf.base.util.ServiceBaseUtil;
import jnpf.constant.MsgCode;
import jnpf.database.model.dbfield.DbFieldModel;
import jnpf.database.model.dbfield.base.DbFieldModelBase;
import jnpf.database.model.dbtable.DbTableFieldModel;
import jnpf.exception.WorkFlowException;
import jnpf.model.visualJson.TableModel;
import jnpf.util.TableFeildsEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConcurrencyUtils {
    @Autowired
    private ServiceBaseUtil serviceUtil;

    public static DbFieldModel getDbFieldModel(TableFeildsEnum tableFeildsEnum, boolean isUpperCase, boolean isLowerCase) {
        DbFieldModel dbFieldModel = new DbFieldModel();
        BeanUtil.copyProperties((Object)tableFeildsEnum, (Object)dbFieldModel, (String[])new String[0]);
        String field = dbFieldModel.getField();
        field = isUpperCase ? field.toUpperCase() : (isLowerCase ? field.toLowerCase() : field);
        dbFieldModel.setField(field);
        dbFieldModel.setIsPrimaryKey(tableFeildsEnum.getPrimaryKey());
        if (TableFeildsEnum.TENANTID.equals((Object)tableFeildsEnum)) {
            dbFieldModel.setDefaultValue("0");
        }
        return dbFieldModel;
    }

    public void createVersion(List<DbFieldModelBase> fieldList, String type, List<DbFieldModel> addList) {
        this.addFeild(TableFeildsEnum.VERSION, fieldList, type, addList);
    }

    public void createFlowTaskId(List<DbFieldModelBase> fieldList, String type, List<DbFieldModel> addList) {
        this.addFeild(TableFeildsEnum.FLOWTASKID, fieldList, type, addList);
    }

    public void createTenantId(List<DbFieldModelBase> fieldList, String type, List<DbFieldModel> addList) {
        this.addFeild(TableFeildsEnum.TENANTID, fieldList, type, addList);
    }

    public void creDeleteMark(List<DbFieldModelBase> fieldList, String type, List<DbFieldModel> addList) {
        this.addFeild(TableFeildsEnum.DELETEMARK, fieldList, type, addList);
        this.addFeild(TableFeildsEnum.DELETETIME, fieldList, type, addList);
        this.addFeild(TableFeildsEnum.DELETEUSERID, fieldList, type, addList);
    }

    public void createFlowEngine(List<DbFieldModelBase> fieldList, String type, List<DbFieldModel> addList) {
        this.addFeild(TableFeildsEnum.FLOWID, fieldList, type, addList);
    }

    private void addFeild(TableFeildsEnum tableFeildsEnum, List<DbFieldModelBase> fieldList, String type, List<DbFieldModel> fieldOneList) {
        boolean hasVersion;
        boolean isUpperCase = "DM".equals(type) || "Oracle".equals(type);
        boolean isLowerCase = "PostgreSQL".equals(type) || "KingbaseES".equals(type);
        DbFieldModelBase dbFieldModel = fieldList.stream().filter(f -> f.getField().equalsIgnoreCase(tableFeildsEnum.getField())).findFirst().orElse(null);
        boolean bl = hasVersion = dbFieldModel != null;
        if (!hasVersion) {
            DbFieldModel dbTableModel1 = ConcurrencyUtils.getDbFieldModel(tableFeildsEnum, isUpperCase, isLowerCase);
            fieldOneList.add(dbTableModel1);
        }
    }

    public boolean checkAutoIncrement(int primaryKeyPolicy, String dbLinkId, List<TableModel> tableList) throws Exception {
        boolean isIncre = primaryKeyPolicy == 2;
        String strategy = primaryKeyPolicy == 1 ? "[\u96ea\u82b1ID]" : "[\u81ea\u589e\u957fid]";
        for (TableModel tableModel : tableList) {
            List<DbFieldModel> data = this.serviceUtil.getFieldList(dbLinkId, tableModel.getTable());
            DbFieldModel dbFieldModel = data.stream().filter(DbFieldModelBase::getIsPrimaryKey).findFirst().orElse(null);
            if (dbFieldModel == null) {
                throw new WorkFlowException(MsgCode.FM011.get(new Object[]{tableModel.getTable()}));
            }
            if (!isIncre != (dbFieldModel.getIsAutoIncrement() != null && dbFieldModel.getIsAutoIncrement() != false)) continue;
            throw new WorkFlowException(MsgCode.FM012.get(new Object[]{strategy, tableModel.getTable()}));
        }
        return true;
    }

    public void addFileds(String table, String linkId, List<DbFieldModel> addList) throws Exception {
        if (CollectionUtils.isNotEmpty(addList)) {
            DbTableFieldModel dbTableFieldModel = new DbTableFieldModel();
            dbTableFieldModel.setDbFieldModelList(addList);
            dbTableFieldModel.setUpdateNewTable(table);
            dbTableFieldModel.setUpdateOldTable(table);
            dbTableFieldModel.setDbLinkId(linkId);
            this.serviceUtil.addField(dbTableFieldModel);
        }
    }
}

