/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import jnpf.base.entity.SuperBaseEntity;
import jnpf.base.entity.SuperExtendEntity;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.entity.VisualdevReleaseEntity;
import jnpf.base.mapper.VisualdevMapper;
import jnpf.base.model.PaginationVisualdev;
import jnpf.base.model.dbtable.vo.DbFieldVO;
import jnpf.base.model.form.VisualTableModel;
import jnpf.base.service.DbLinkService;
import jnpf.base.service.FilterService;
import jnpf.base.service.SuperServiceImpl;
import jnpf.base.service.VisualdevReleaseService;
import jnpf.base.service.VisualdevService;
import jnpf.base.service.impl.DbTableServiceImpl;
import jnpf.base.util.ConcurrencyUtils;
import jnpf.base.util.VisualDevTableCre;
import jnpf.base.util.VisualUtils;
import jnpf.constant.JnpfConst;
import jnpf.constant.MsgCode;
import jnpf.database.constant.DbAliasConst;
import jnpf.database.model.dbfield.DbFieldModel;
import jnpf.database.model.dbfield.base.DbFieldModelBase;
import jnpf.database.model.dbtable.DbTableFieldModel;
import jnpf.database.model.entity.DbLinkEntity;
import jnpf.database.model.interfaces.DbSourceOrDbLink;
import jnpf.database.util.DataSourceUtil;
import jnpf.exception.WorkFlowException;
import jnpf.model.OnlineDevData;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.FormCloumnUtil;
import jnpf.model.visualJson.FormDataModel;
import jnpf.model.visualJson.TableFields;
import jnpf.model.visualJson.TableModel;
import jnpf.model.visualJson.analysis.FormAllModel;
import jnpf.model.visualJson.analysis.FormEnum;
import jnpf.model.visualJson.analysis.FormMastTableModel;
import jnpf.model.visualJson.analysis.RecursionForm;
import jnpf.model.visualJson.config.ConfigModel;
import jnpf.util.JsonUtil;
import jnpf.util.RandomUtil;
import jnpf.util.StringUtil;
import jnpf.util.UserProvider;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisualdevServiceImpl
extends SuperServiceImpl<VisualdevMapper, VisualdevEntity>
implements VisualdevService {
    @Autowired
    private VisualDevTableCre visualDevTableCreUtil;
    @Autowired
    private ConcurrencyUtils concurrencyUtils;
    @Autowired
    private DbTableServiceImpl dbTableService;
    @Autowired
    private DbLinkService dblinkService;
    @Autowired
    private DataSourceUtil dataSourceUtil;
    @Autowired
    private FilterService filterService;
    @Autowired
    private VisualdevReleaseService visualdevReleaseService;

    @Override
    public List<VisualdevEntity> getList(PaginationVisualdev paginationVisualdev) {
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().select(new SFunction[]{SuperBaseEntity.SuperIBaseEntity::getId, VisualdevEntity::getCategory, VisualdevEntity::getEnCode, VisualdevEntity::getFullName, SuperBaseEntity.SuperCBaseEntity::getCreatorTime, SuperBaseEntity.SuperCBaseEntity::getCreatorUserId, SuperBaseEntity.SuperCUBaseEntity::getLastModifyTime, SuperBaseEntity.SuperCUBaseEntity::getLastModifyUserId, SuperExtendEntity.SuperExtendDEEntity::getEnabledMark, SuperExtendEntity::getSortCode, VisualdevEntity::getState, VisualdevEntity::getType, VisualdevEntity::getWebType, VisualdevEntity::getVisualTables, VisualdevEntity::getPlatformRelease});
        if (!StringUtil.isEmpty((String)paginationVisualdev.getKeyword())) {
            flag = true;
            queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(VisualdevEntity::getFullName, (Object)paginationVisualdev.getKeyword())).or()).like(VisualdevEntity::getEnCode, (Object)paginationVisualdev.getKeyword()));
        }
        if (ObjectUtil.isNotEmpty((Object)paginationVisualdev.getType())) {
            queryWrapper.lambda().eq(VisualdevEntity::getType, (Object)paginationVisualdev.getType());
        }
        if (StringUtil.isNotEmpty((String)paginationVisualdev.getCategory())) {
            flag = true;
            queryWrapper.lambda().eq(VisualdevEntity::getCategory, (Object)paginationVisualdev.getCategory());
        }
        if (paginationVisualdev.getWebType() != null) {
            flag = true;
            queryWrapper.lambda().eq(VisualdevEntity::getWebType, (Object)paginationVisualdev.getWebType());
        }
        if (StringUtil.isNotEmpty((String)paginationVisualdev.getIsRelease())) {
            flag = true;
            List<String> releaseList = Arrays.asList(paginationVisualdev.getIsRelease().split(","));
            if (releaseList.size() > 1) {
                List jsonToList = JsonUtil.getJsonToList(releaseList, Integer.class);
                queryWrapper.lambda().in(VisualdevEntity::getState, (Collection)jsonToList);
            } else if (releaseList.size() == 1) {
                queryWrapper.lambda().eq(VisualdevEntity::getState, (Object)paginationVisualdev.getIsRelease());
            }
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(SuperExtendEntity::getSortCode)).orderByDesc(SuperBaseEntity.SuperCBaseEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(SuperBaseEntity.SuperCUBaseEntity::getLastModifyTime);
        }
        Page page = new Page(paginationVisualdev.getCurrentPage(), paginationVisualdev.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return paginationVisualdev.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public List<VisualdevEntity> getPageList(PaginationVisualdev paginationVisualdev) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().select(new SFunction[]{SuperBaseEntity.SuperIBaseEntity::getId, VisualdevReleaseEntity::getFullName, VisualdevReleaseEntity::getType, VisualdevReleaseEntity::getEnCode});
        if (paginationVisualdev.getWebType() != null) {
            ImmutableList webType = ImmutableList.of((Object)1, (Object)2, (Object)4);
            if (Objects.equals(paginationVisualdev.getWebType(), 1)) {
                webType = ImmutableList.of((Object)2);
            } else if (Objects.equals(paginationVisualdev.getWebType(), 2)) {
                webType = ImmutableList.of((Object)1, (Object)2);
            }
            queryWrapper.lambda().in(VisualdevReleaseEntity::getWebType, (Collection)webType);
        }
        if (!StringUtil.isEmpty((String)paginationVisualdev.getKeyword())) {
            queryWrapper.lambda().like(VisualdevReleaseEntity::getFullName, (Object)paginationVisualdev.getKeyword());
        }
        if (ObjectUtil.isNotEmpty((Object)paginationVisualdev.getType())) {
            queryWrapper.lambda().eq(VisualdevReleaseEntity::getType, (Object)paginationVisualdev.getType());
        }
        if (StringUtil.isNotEmpty((String)paginationVisualdev.getCategory())) {
            queryWrapper.lambda().eq(VisualdevReleaseEntity::getCategory, (Object)paginationVisualdev.getCategory());
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(SuperExtendEntity::getSortCode)).orderByDesc(SuperBaseEntity.SuperCBaseEntity::getCreatorTime);
        Page page = new Page(paginationVisualdev.getCurrentPage(), paginationVisualdev.getPageSize());
        IPage userPage = this.visualdevReleaseService.page((IPage)page, (Wrapper)queryWrapper);
        List list = JsonUtil.getJsonToList((Object)userPage.getRecords(), VisualdevEntity.class);
        return paginationVisualdev.setData(list, page.getTotal());
    }

    @Override
    public List<VisualdevEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(SuperExtendEntity::getSortCode)).orderByDesc(SuperBaseEntity.SuperCBaseEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public VisualdevEntity getInfo(String id) {
        if (StringUtil.isBlank((CharSequence)id)) {
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SuperBaseEntity.SuperIBaseEntity::getId, (Object)id);
        return (VisualdevEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public VisualdevEntity getReleaseInfo(String id) {
        VisualdevReleaseEntity visualdevReleaseEntity = (VisualdevReleaseEntity)this.visualdevReleaseService.getById((Serializable)((Object)id));
        VisualdevEntity visualdevEntity = null;
        if (visualdevReleaseEntity != null) {
            visualdevEntity = (VisualdevEntity)JsonUtil.getJsonToBean((Object)visualdevReleaseEntity, VisualdevEntity.class);
        }
        if (visualdevEntity == null) {
            visualdevEntity = (VisualdevEntity)this.getById((Serializable)((Object)id));
        }
        return visualdevEntity;
    }

    @Override
    public Map<String, String> getTableMap(String formData) {
        HashMap<String, String> tableMap = new HashMap<String, String>();
        if (StringUtil.isEmpty((String)formData)) {
            return tableMap;
        }
        FormDataModel formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)formData, FormDataModel.class);
        String fields = formDataModel.getFields();
        List list = JsonUtil.getJsonToList((String)fields, FieLdsModel.class);
        list.forEach(item -> this.solveTableName((FieLdsModel)item, tableMap));
        return tableMap;
    }

    private void solveTableName(FieLdsModel item, Map tableMap) {
        ConfigModel config = item.getConfig();
        if (config != null) {
            List children = config.getChildren();
            if ("table".equals(config.getJnpfKey()) && children != null && children.size() > 0) {
                FieLdsModel fieLdsModel = (FieLdsModel)children.get(0);
                String parentVModel = item.getVModel();
                String relationTable = fieLdsModel.getConfig().getRelationTable();
                if (StringUtil.isNotBlank((CharSequence)relationTable)) {
                    tableMap.put(parentVModel, relationTable);
                }
            }
            if (children != null) {
                children.forEach(item2 -> this.solveTableName((FieLdsModel)item2, tableMap));
            }
        }
    }

    @Override
    public Boolean create(VisualdevEntity entity) {
        FormDataModel formDataModel;
        if (StringUtil.isEmpty((String)((String)entity.getId()))) {
            entity.setId((Object)RandomUtil.uuId());
        }
        if (OnlineDevData.FORM_TYPE_DEV.equals(entity.getType()) && (formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFormData(), FormDataModel.class)) != null) {
            int primaryKeyPolicy = formDataModel.getPrimaryKeyPolicy();
            List tableModels = JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class);
            if (tableModels.size() > 0) {
                Map<String, String> tableMap = this.getTableMap(entity.getFormData());
                this.filterService.saveRuleList((String)entity.getId(), entity, 1, 1, tableMap);
                for (TableModel tableModel : tableModels) {
                    Boolean isAutoIncre = this.getPrimaryDbField(entity.getDbLinkId(), tableModel.getTable());
                    if (primaryKeyPolicy == 1) {
                        if (isAutoIncre == null || !isAutoIncre.booleanValue()) continue;
                        throw new WorkFlowException(MsgCode.VS022.get(new Object[]{tableModel.getTable()}));
                    }
                    if (primaryKeyPolicy != 2 || isAutoIncre != null && isAutoIncre.booleanValue()) continue;
                    throw new WorkFlowException(MsgCode.VS023.get(new Object[]{tableModel.getTable()}));
                }
                try {
                    String tableJsonMap = this.addDbFileds(entity.getDbLinkId(), tableModels, formDataModel);
                    if (StringUtil.isNotEmpty((String)tableJsonMap)) {
                        entity.setVisualTables(tableJsonMap);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        entity.setEnabledMark(Integer.valueOf(0));
        entity.setState(Integer.valueOf(0));
        entity.setCreatorTime(new Date());
        entity.setCreatorUserId(UserProvider.getLoginUserId());
        entity.setLastModifyTime(null);
        entity.setLastModifyUserId(null);
        this.setIgnoreLogicDelete().removeById((Serializable)entity.getId());
        boolean result = this.setIgnoreLogicDelete().saveOrUpdate((Object)entity);
        this.clearIgnoreLogicDelete();
        return result;
    }

    private String addDbFileds(String dbLinkId, List<TableModel> visualTables, FormDataModel formDataModel) throws Exception {
        if (CollectionUtils.isEmpty(visualTables)) {
            return null;
        }
        ArrayList<Map> tableJsonMap = new ArrayList<Map>();
        Boolean concurrencyLock = formDataModel.getConcurrencyLock();
        Boolean logicalDelete = formDataModel.getLogicalDelete();
        for (TableModel tableModel : visualTables) {
            boolean isMainTable = tableModel.getTypeId().equals("1");
            List dbFieldModelList = this.dbTableService.getFieldList(dbLinkId, tableModel.getTable());
            List fieldList = JsonUtil.getJsonToList((Object)dbFieldModelList, DbFieldModelBase.class);
            ArrayList<DbFieldModel> addList = new ArrayList<DbFieldModel>();
            DbLinkEntity dbLink = this.dblinkService.getInfo(dbLinkId);
            String type = dbLink != null ? dbLink.getDbType() : this.dataSourceUtil.getDbType();
            this.concurrencyUtils.createTenantId(fieldList, type, addList);
            if (logicalDelete.booleanValue()) {
                this.concurrencyUtils.creDeleteMark(fieldList, type, addList);
            }
            if (isMainTable && concurrencyLock.booleanValue()) {
                this.concurrencyUtils.createVersion(fieldList, type, addList);
            }
            if (isMainTable) {
                this.concurrencyUtils.createFlowEngine(fieldList, type, addList);
                this.concurrencyUtils.createFlowTaskId(fieldList, type, addList);
            }
            this.concurrencyUtils.addFileds(tableModel.getTable(), dbLinkId, addList);
            ArrayList<DbFieldVO> voList = new ArrayList<DbFieldVO>();
            ArrayList<DbFieldModel> listAll = new ArrayList<DbFieldModel>();
            listAll.addAll(fieldList);
            listAll.addAll(addList);
            for (DbFieldModelBase dbFieldModelBase : listAll) {
                DbFieldVO tableFields = new DbFieldVO();
                tableFields.setField(dbFieldModelBase.getField());
                tableFields.setFieldName(dbFieldModelBase.getComment());
                tableFields.setDataType(dbFieldModelBase.getDataType());
                tableFields.setDataLength(dbFieldModelBase.getLength());
                tableFields.setPrimaryKey(DbAliasConst.PRIMARY_KEY.getNum((Object)dbFieldModelBase.getIsPrimaryKey()));
                tableFields.setAllowNull(DbAliasConst.ALLOW_NULL.getNum((Object)dbFieldModelBase.getNullSign()));
                tableFields.setAutoIncrement(DbAliasConst.AUTO_INCREMENT.getNum((Object)dbFieldModelBase.getIsAutoIncrement()));
                tableFields.setIdentity(DbAliasConst.AUTO_INCREMENT.getNum((Object)dbFieldModelBase.getIsAutoIncrement()));
                voList.add(tableFields);
            }
            Map stringObjectMap = JsonUtil.entityToMap((Object)tableModel);
            stringObjectMap.put("fields", voList);
            tableJsonMap.add(stringObjectMap);
        }
        return JsonUtil.getObjectToString(tableJsonMap);
    }

    @Override
    public boolean update(String id, VisualdevEntity entity) throws Exception {
        FormDataModel formDataModel;
        entity.setId((Object)id);
        entity.setLastModifyUserId(UserProvider.getUser().getUserId());
        if (OnlineDevData.FORM_TYPE_DEV.equals(entity.getType()) && (formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFormData(), FormDataModel.class)) != null) {
            int primaryKeyPolicy = formDataModel.getPrimaryKeyPolicy();
            List visualTables = JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class);
            if (visualTables.size() > 0 && formDataModel != null) {
                try {
                    String tableJsonMap = this.addDbFileds(entity.getDbLinkId(), visualTables, formDataModel);
                    if (StringUtil.isNotEmpty((String)tableJsonMap)) {
                        entity.setVisualTables(tableJsonMap);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.concurrencyUtils.checkAutoIncrement(primaryKeyPolicy, entity.getDbLinkId(), visualTables);
            }
        }
        return this.updateById(entity);
    }

    @Override
    public Integer getObjByEncode(String encode, Integer type) {
        QueryWrapper visualWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)visualWrapper.lambda().eq(VisualdevEntity::getEnCode, (Object)encode)).eq(VisualdevEntity::getType, (Object)type);
        Integer count = (int)this.count((Wrapper)visualWrapper);
        return count;
    }

    @Override
    public Integer getCountByName(String name, Integer type) {
        QueryWrapper visualWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)visualWrapper.lambda().eq(VisualdevEntity::getFullName, (Object)name)).eq(VisualdevEntity::getType, (Object)type);
        Integer count = (int)this.count((Wrapper)visualWrapper);
        return count;
    }

    @Override
    public void createTable(VisualdevEntity entity) throws WorkFlowException {
        FormDataModel formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFormData(), FormDataModel.class);
        Boolean concurrencyLock = formDataModel.getConcurrencyLock();
        int primaryKeyPolicy = formDataModel.getPrimaryKeyPolicy();
        Boolean logicalDelete = formDataModel.getLogicalDelete();
        Map formMap = JsonUtil.stringToMap((String)entity.getFormData());
        List list = JsonUtil.getJsonToList(formMap.get("fields"), FieLdsModel.class);
        JSONArray formJsonArray = JsonUtil.getJsonToJsonArray((String)String.valueOf(formMap.get("fields")));
        List visualTables = JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class);
        ArrayList formAllModel = new ArrayList();
        RecursionForm recursionForm = new RecursionForm();
        recursionForm.setTableModelList(visualTables);
        recursionForm.setList(list);
        FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
        String tableName = "mt" + RandomUtil.uuId();
        String dbLinkId = entity.getDbLinkId();
        VisualTableModel model = new VisualTableModel(formJsonArray, formAllModel, tableName, dbLinkId, entity.getFullName(), concurrencyLock.booleanValue(), Integer.valueOf(primaryKeyPolicy), logicalDelete);
        List<TableModel> tableModelList = this.visualDevTableCreUtil.tableList(model);
        formMap.put("fields", formJsonArray);
        entity.setFormData(JsonUtil.getObjectToString((Object)formMap));
        entity.setVisualTables(JsonUtil.getObjectToString(tableModelList));
    }

    @Override
    public Boolean getPrimaryDbField(String linkId, String table) throws Exception {
        DbTableFieldModel dbTableModel = this.dbTableService.getDbTableModel(linkId, table);
        List data = dbTableModel.getDbFieldModelList();
        DbFieldModel dbFieldModel = data.stream().filter(DbFieldModelBase::getIsPrimaryKey).findFirst().orElse(null);
        if (dbFieldModel != null) {
            return dbFieldModel.getIsAutoIncrement() != null && dbFieldModel.getIsAutoIncrement() != false;
        }
        return null;
    }

    @Override
    public List<VisualdevEntity> selectorList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().select(new SFunction[]{SuperBaseEntity.SuperIBaseEntity::getId, VisualdevEntity::getFullName, VisualdevEntity::getWebType, VisualdevEntity::getType, VisualdevEntity::getCategory});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<TableFields> storedFieldList(VisualdevEntity entity) {
        ArrayList<TableFields> resultList = new ArrayList<TableFields>();
        if (entity != null) {
            try {
                DbLinkEntity linkEntity = null;
                if (StringUtil.isNotEmpty((String)entity.getDbLinkId())) {
                    linkEntity = this.dblinkService.getInfo(entity.getDbLinkId());
                }
                List listTable = JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class);
                String mainTable = ((TableModel)listTable.stream().filter(t -> "1".equals(t.getTypeId())).findFirst().orElse(null)).getTable();
                String pKeyName = VisualUtils.getpKey((DbSourceOrDbLink)linkEntity, mainTable);
                resultList.add(new TableFields(pKeyName, "\u8868\u5355\u4e3b\u952e"));
                FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFormData(), FormDataModel.class);
                List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
                ArrayList formAllModel = new ArrayList();
                RecursionForm recursionForm = new RecursionForm();
                recursionForm.setTableModelList(JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class));
                recursionForm.setList(list);
                FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
                List mast = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
                List mastTable = formAllModel.stream().filter(t -> FormEnum.mastTable.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
                for (FormAllModel item : mast) {
                    FieLdsModel fieLdsModel = item.getFormColumnModel().getFieLdsModel();
                    VisualdevServiceImpl.addField(fieLdsModel.getVModel(), fieLdsModel, resultList);
                }
                for (FormAllModel item : mastTable) {
                    FormMastTableModel formMastTableModel = item.getFormMastTableModel();
                    FieLdsModel fieLdsModel = formMastTableModel.getMastTable().getFieLdsModel();
                    VisualdevServiceImpl.addField(formMastTableModel.getVModel(), fieLdsModel, resultList);
                }
            }
            catch (Exception e) {
                this.log.error(e.getMessage());
            }
        }
        return resultList;
    }

    private static void addField(String realVmodel, FieLdsModel fieLdsModel, List<TableFields> resultList) {
        List<String> list = Arrays.asList("input", "billRule");
        if (StringUtil.isNotEmpty((String)fieLdsModel.getVModel()) && list.contains(fieLdsModel.getConfig().getJnpfKey())) {
            resultList.add(new TableFields(realVmodel + JnpfConst.FIELD_SUFFIX_JNPFID, fieLdsModel.getConfig().getLabel()));
        }
    }
}

