/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.base.CaseFormat;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jnpf.base.entity.VisualAliasEntity;
import jnpf.base.entity.VisualdevReleaseEntity;
import jnpf.base.mapper.VisualAliasMapper;
import jnpf.base.model.VisualAliasForm;
import jnpf.base.service.SuperServiceImpl;
import jnpf.base.service.VisualAliasService;
import jnpf.base.service.VisualdevReleaseService;
import jnpf.base.util.common.AliasModel;
import jnpf.constant.GenerateConstant;
import jnpf.constant.MsgCode;
import jnpf.exception.DataException;
import jnpf.model.visualJson.TableFields;
import jnpf.model.visualJson.TableModel;
import jnpf.util.JsonUtil;
import jnpf.util.RandomUtil;
import jnpf.util.StringUtil;
import jnpf.util.UserProvider;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VisualAliasServiceImpl
extends SuperServiceImpl<VisualAliasMapper, VisualAliasEntity>
implements VisualAliasService {
    @Autowired
    private VisualdevReleaseService visualdevReleaseService;

    @Override
    public List<VisualAliasEntity> getList(String visualId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(VisualAliasEntity::getVisualId, (Object)visualId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<TableModel> getAliasInfo(String id) {
        VisualdevReleaseEntity visualdevEntity = (VisualdevReleaseEntity)this.visualdevReleaseService.getById((Serializable)((Object)id));
        List tableModels = JsonUtil.getJsonToList((String)visualdevEntity.getVisualTables(), TableModel.class);
        List<VisualAliasEntity> list = this.getList(id);
        for (TableModel tableModel : tableModels) {
            tableModel.setComment(tableModel.getTableName());
            VisualAliasEntity tableAlias = list.stream().filter(t -> tableModel.getTable().equals(t.getTableName()) && t.getFieldName() == null).findFirst().orElse(null);
            if (tableAlias != null) {
                tableModel.setAliasName(tableAlias.getAliasName());
            }
            List fields = tableModel.getFields();
            List newFields = fields.stream().filter(t -> !GenerateConstant.SYS_KEYWORD.contains(t.getField().toLowerCase())).collect(Collectors.toList());
            for (TableFields field : newFields) {
                VisualAliasEntity fieldAlias = list.stream().filter(t -> tableModel.getTable().equals(t.getTableName()) && t.getFieldName() != null && field.getField().equals(t.getFieldName())).findFirst().orElse(null);
                if (fieldAlias == null) continue;
                field.setAliasName(fieldAlias.getAliasName());
            }
            tableModel.setFields(newFields);
        }
        return tableModels;
    }

    @Override
    @Transactional
    public void aliasSave(String id, VisualAliasForm form) {
        List tableList = form.getTableList();
        List<VisualAliasEntity> list = this.getList(id);
        ArrayList<String> tableNameList = new ArrayList<String>();
        List listKeyword = GenerateConstant.getAllKeyWord();
        String regex = "[a-zA-Z_][a-zA-Z0-9_]*";
        for (TableModel tableModel : tableList) {
            VisualAliasEntity tableAlias = list.stream().filter(t -> tableModel.getTable().equals(t.getTableName()) && t.getFieldName() == null).findFirst().orElse(null);
            if (StringUtil.isNotEmpty((String)tableModel.getAliasName())) {
                if (tableNameList.contains(tableModel.getAliasName())) {
                    throw new DataException(tableModel.getAliasName() + MsgCode.VS018.get(new Object[0]));
                }
                tableNameList.add(tableModel.getAliasName());
                if (listKeyword.contains(tableModel.getAliasName().toLowerCase())) {
                    throw new DataException(MsgCode.SYS128.get(new Object[]{tableModel.getTable() + "-" + tableModel.getAliasName()}));
                }
                if (!tableModel.getAliasName().matches(regex)) {
                    throw new DataException(MsgCode.VS021.get(new Object[]{tableModel.getTable()}));
                }
                if (this.twoCharactesUpperCase(tableModel.getAliasName())) {
                    throw new DataException(MsgCode.VS026.get(new Object[0]));
                }
                if (tableAlias != null) {
                    tableAlias.setAliasName(tableModel.getAliasName());
                } else {
                    tableAlias = new VisualAliasEntity();
                    tableAlias.setId((Object)RandomUtil.uuId());
                    tableAlias.setVisualId(id);
                    tableAlias.setTableName(tableModel.getTable());
                    tableAlias.setAliasName(tableModel.getAliasName());
                }
                this.saveOrUpdate(tableAlias);
            } else if (tableAlias != null) {
                this.removeById(tableAlias);
            }
            ArrayList<String> fieldNameList = new ArrayList<String>();
            for (TableFields field : tableModel.getFields()) {
                VisualAliasEntity fieldAlias = list.stream().filter(t -> tableModel.getTable().equals(t.getTableName()) && t.getFieldName() != null && field.getField().equals(t.getFieldName())).findFirst().orElse(null);
                if (StringUtil.isNotEmpty((String)field.getAliasName())) {
                    if (listKeyword.contains(field.getAliasName().toLowerCase())) {
                        throw new DataException(MsgCode.SYS128.get(new Object[]{field.getField() + "-" + field.getAliasName()}));
                    }
                    if (!field.getAliasName().matches(regex)) {
                        throw new DataException(MsgCode.VS021.get(new Object[]{field.getField()}));
                    }
                    if (this.twoCharactesUpperCase(field.getAliasName())) {
                        throw new DataException(MsgCode.VS026.get(new Object[0]));
                    }
                    if (fieldNameList.contains(field.getAliasName())) {
                        throw new DataException(field.getAliasName() + MsgCode.VS020.get(new Object[0]));
                    }
                    fieldNameList.add(field.getAliasName());
                    if (fieldAlias != null) {
                        fieldAlias.setAliasName(field.getAliasName());
                    } else {
                        fieldAlias = new VisualAliasEntity();
                        fieldAlias.setId((Object)RandomUtil.uuId());
                        fieldAlias.setVisualId(id);
                        fieldAlias.setTableName(tableModel.getTable());
                        fieldAlias.setFieldName(field.getField());
                        fieldAlias.setAliasName(field.getAliasName());
                    }
                    this.saveOrUpdate(fieldAlias);
                    continue;
                }
                if (fieldAlias == null) continue;
                this.removeById(fieldAlias);
            }
        }
    }

    @Override
    public Map<String, AliasModel> getAllFiledsAlias(String id) {
        HashMap<String, AliasModel> tableMap = new HashMap<String, AliasModel>();
        VisualdevReleaseEntity visualdevEntity = (VisualdevReleaseEntity)this.visualdevReleaseService.getById((Serializable)((Object)id));
        List tableModels = JsonUtil.getJsonToList((String)visualdevEntity.getVisualTables(), TableModel.class);
        List<VisualAliasEntity> list = this.getList(id);
        for (TableModel tableModel : tableModels) {
            AliasModel aliasModel = new AliasModel();
            aliasModel.setTableName(tableModel.getTable());
            VisualAliasEntity tableAlias = list.stream().filter(t -> tableModel.getTable().equals(t.getTableName()) && t.getFieldName() == null).findFirst().orElse(null);
            if (tableAlias != null) {
                aliasModel.setAliasName(tableAlias.getAliasName());
            } else {
                aliasModel.setAliasName(tableModel.getTable());
            }
            List fields = tableModel.getFields();
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            for (TableFields field : fields) {
                String fieldAliasName;
                String name;
                VisualAliasEntity fieldAlias = list.stream().filter(t -> tableModel.getTable().equals(t.getTableName()) && t.getFieldName() != null && field.getField().equals(t.getFieldName())).findFirst().orElse(null);
                if (fieldAlias != null) {
                    fieldMap.put(field.getField(), fieldAlias.getAliasName());
                    continue;
                }
                if (GenerateConstant.SYS_KEYWORD.contains(field.getField().toLowerCase())) {
                    name = field.getField().toLowerCase();
                    name = name.startsWith("f_") ? name.substring(2) : name;
                    fieldAliasName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
                    fieldMap.put(field.getField(), fieldAliasName);
                    continue;
                }
                name = field.getField();
                fieldAliasName = this.twoToLowerCase(name);
                fieldMap.put(field.getField(), fieldAliasName);
            }
            aliasModel.setFieldsMap(fieldMap);
            tableMap.put(tableModel.getTable(), aliasModel);
        }
        return tableMap;
    }

    @Override
    public void copy(String visualId, String uuid) {
        List<VisualAliasEntity> list = this.getList(visualId);
        if (CollectionUtils.isNotEmpty(list)) {
            for (VisualAliasEntity entity : list) {
                VisualAliasEntity copy = (VisualAliasEntity)BeanUtil.copyProperties((Object)entity, VisualAliasEntity.class, (String[])new String[0]);
                this.copyEntity(copy, uuid);
            }
        }
    }

    @Override
    public void copyEntity(VisualAliasEntity copy, String visualId) {
        copy.setId((Object)RandomUtil.uuId());
        copy.setVisualId(visualId);
        copy.setCreatorTime(new Date());
        copy.setCreatorUserId(UserProvider.getUser().getUserId());
        copy.setLastModifyUserId(null);
        copy.setLastModifyTime(null);
        this.save(copy);
    }

    @Override
    public void removeByVisualId(String visualId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(VisualAliasEntity::getVisualId, (Object)visualId);
        this.remove((Wrapper)queryWrapper);
    }

    public boolean twoCharactesUpperCase(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        if (name.length() == 1) {
            return Character.isUpperCase(name.charAt(0));
        }
        if (name.length() >= 2) {
            return Character.isUpperCase(name.charAt(0)) || Character.isUpperCase(name.charAt(1));
        }
        return false;
    }

    public String twoToLowerCase(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return name;
        }
        if ((name = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name)).length() <= 2) {
            return name.toLowerCase();
        }
        if (name.length() > 2) {
            return name.substring(0, 2).toLowerCase() + name.substring(2);
        }
        return name;
    }
}

