/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.service.impl;

import com.google.common.base.CaseFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jnpf.base.model.ai.VisualAiModel;
import jnpf.base.service.VisualAiService;
import jnpf.constant.GenerateConstant;
import jnpf.model.ai.AiFormFieldModel;
import jnpf.model.ai.AiFormModel;
import jnpf.service.OpenAiService;
import jnpf.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisualAiServiceImpl
implements VisualAiService {
    @Autowired
    private OpenAiService openAiService;

    @Override
    public VisualAiModel form(String keyword) {
        VisualAiModel visualAiModel = new VisualAiModel();
        ArrayList<AiFormModel> aiModelList = new ArrayList<AiFormModel>();
        List list = this.openAiService.generatorModelVO(keyword);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (int i = 0; i < list.size(); ++i) {
                AiFormModel aiFormModel = (AiFormModel)list.get(i);
                if (Objects.equals(0, i)) {
                    String enCode = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, aiFormModel.getTableName());
                    visualAiModel.setFullName(aiFormModel.getTableTitle());
                    visualAiModel.setEnCode(enCode);
                    aiFormModel.setIsMain(Boolean.valueOf(true));
                } else {
                    aiFormModel.setIsMain(Boolean.valueOf(false));
                }
                ArrayList<AiFormFieldModel> fields = new ArrayList<AiFormFieldModel>();
                List fieldList = aiFormModel.getFields();
                if (CollectionUtils.isNotEmpty((Collection)fieldList)) {
                    int index = 1;
                    String formatIndex = String.format("%03d", index);
                    for (int j = 0; j < fieldList.size(); ++j) {
                        AiFormFieldModel aiFormFieldModel = (AiFormFieldModel)fieldList.get(j);
                        String fieldName = aiFormFieldModel.getFieldName();
                        String jnpfKey = aiFormFieldModel.getFieldComponent();
                        if (VisualAiServiceImpl.containsChinese(fieldName) || GenerateConstant.containKeyword((String)fieldName)) {
                            String suffix = "_num" + formatIndex;
                            aiFormFieldModel.setFieldName(jnpfKey + suffix);
                            ++index;
                        }
                        ArrayList<String> jnpfKeyList = new ArrayList<String>();
                        for (String s : "- input - textarea - inputNumber - switch - radio - checkbox - select - datePicker - timePicker - uploadFile - uploadImg - colorPicker - rate - slider - editor - depSelect - posSelect - userSelect - roleSelect - areaSelect - signature - sign - location".split("-")) {
                            if (!StringUtil.isNotBlank((CharSequence)s)) continue;
                            jnpfKeyList.add(s.trim());
                        }
                        if (!jnpfKeyList.contains(jnpfKey)) {
                            aiFormFieldModel.setFieldComponent("input");
                        }
                        if (!aiFormModel.getIsMain().booleanValue()) {
                            ArrayList<String> childNotRadio = new ArrayList<String>();
                            childNotRadio.add("radio");
                            childNotRadio.add("checkbox");
                            ArrayList<String> childNotOther = new ArrayList<String>();
                            childNotOther.add("textarea");
                            childNotOther.add("link");
                            childNotOther.add("button");
                            childNotOther.add("alert");
                            childNotOther.add("barcode");
                            childNotOther.add("qrcode");
                            if (childNotRadio.contains(jnpfKey)) {
                                aiFormFieldModel.setFieldComponent("select");
                            } else if (childNotOther.contains(jnpfKey)) {
                                aiFormFieldModel.setFieldComponent("input");
                            }
                        }
                        if (!VisualAiServiceImpl.containsKeyWord(aiFormFieldModel.getFieldName())) continue;
                        fields.add(aiFormFieldModel);
                    }
                }
                aiFormModel.setFields(fields);
                aiModelList.add(aiFormModel);
            }
        }
        visualAiModel.setAiModelList(aiModelList);
        return visualAiModel;
    }

    private static boolean containsChinese(String str) {
        if (StringUtil.isEmpty((String)str)) {
            return true;
        }
        Pattern pattern = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    private static boolean containsKeyWord(String str) {
        return !str.toLowerCase().endsWith("_fk");
    }
}

