/*
 * Decompiled with CFR 0.152.
 */
package jnpf.base.service.impl;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jnpf.base.entity.FilterEntity;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.mapper.FilterMapper;
import jnpf.base.model.filter.RuleInfo;
import jnpf.base.service.FilterService;
import jnpf.base.service.SuperServiceImpl;
import jnpf.base.util.OnlineFilterUtil;
import jnpf.database.util.DbTypeUtil;
import jnpf.database.util.DynamicDataSourceUtil;
import jnpf.util.JsonUtil;
import jnpf.util.RandomUtil;
import jnpf.util.context.RequestContext;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.DerivedColumn;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.where.WhereModel;
import org.springframework.stereotype.Service;

@Service
public class FilterServiceImpl
extends SuperServiceImpl<FilterMapper, FilterEntity>
implements FilterService {
    @Override
    public void saveRuleList(String moduleId, VisualdevEntity visualdevEntity, Integer app, Integer pc, Map<String, String> tableMap) {
        if (MapUtils.isEmpty(tableMap)) {
            return;
        }
        String columnData = visualdevEntity.getColumnData();
        String appColumnData = visualdevEntity.getAppColumnData();
        if (columnData == null || columnData.length() == 0) {
            columnData = "{}";
        }
        if (appColumnData == null || appColumnData.length() == 0) {
            appColumnData = "{}";
        }
        Map config = (Map)JsonUtil.getJsonToBean((String)columnData, Map.class);
        String ruleList = JSONUtil.toJsonStr(config.get("ruleList"));
        Map configApp = (Map)JsonUtil.getJsonToBean((String)appColumnData, Map.class);
        String ruleListApp = JSONUtil.toJsonStr(configApp.get("ruleListApp"));
        FilterEntity entity = new FilterEntity();
        entity.setId((Object)RandomUtil.uuId());
        entity.setModuleId(moduleId);
        this.replaceRealValue(app, pc, tableMap, ruleList, ruleListApp, entity);
        entity.setCreatorTime(new Date());
        entity.setLastModifyTime(new Date());
        this.save(entity);
    }

    @Override
    public void updateRuleList(String moduleId, VisualdevEntity visualdevEntity, Integer app, Integer pc, Map<String, String> tableMap) {
        if (MapUtils.isEmpty(tableMap)) {
            return;
        }
        String columnData = visualdevEntity.getColumnData();
        String appColumnData = visualdevEntity.getAppColumnData();
        if (columnData == null || columnData.length() == 0) {
            columnData = "{}";
        }
        if (appColumnData == null || appColumnData.length() == 0) {
            appColumnData = "{}";
        }
        Map config = (Map)JsonUtil.getJsonToBean((String)columnData, Map.class);
        String ruleList = JSONUtil.toJsonStr(config.get("ruleList"));
        Map configApp = (Map)JsonUtil.getJsonToBean((String)appColumnData, Map.class);
        String ruleListApp = JSONUtil.toJsonStr(configApp.get("ruleListApp"));
        List list = ((FilterMapper)this.getBaseMapper()).selectList((Wrapper)new QueryWrapper().lambda().eq(FilterEntity::getModuleId, (Object)moduleId));
        if (list == null || list.size() == 0) {
            this.saveRuleList(moduleId, visualdevEntity, app, pc, tableMap);
        } else {
            FilterEntity entity = (FilterEntity)list.get(0);
            this.replaceRealValue(app, pc, tableMap, ruleList, ruleListApp, entity);
            entity.setLastModifyTime(new Date());
            this.updateById(entity);
        }
    }

    private void replaceRealValue(Integer app, Integer pc, Map<String, String> tableMap, String ruleList, String ruleListApp, FilterEntity entity) {
        if (app == 1 && StringUtils.isNotBlank((CharSequence)ruleListApp)) {
            for (String key : tableMap.keySet()) {
                ruleListApp = ruleListApp.replaceAll(key, tableMap.get(key));
            }
            entity.setConfigApp(ruleListApp);
        }
        if (pc == 1 && StringUtils.isNotBlank((CharSequence)ruleList)) {
            for (String key : tableMap.keySet()) {
                ruleList = ruleList.replaceAll(key, tableMap.get(key));
            }
            entity.setConfig(ruleList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleWhereCondition(SqlTable sqlTable, QueryExpressionDSL.QueryExpressionWhereBuilder where, String id, Map<String, SqlTable> subSqlTableMap, String databaseProductName, Map<String, Object> params) {
        try {
            DynamicDataSourceUtil.switchToDataSource(null);
            List<RuleInfo> ruleInfos = this.getCondition(id);
            QueryExpressionDSL.QueryExpressionWhereBuilder whereFilter = SqlBuilder.select((BasicColumn[])new BasicColumn[]{sqlTable.allColumns()}).from(sqlTable).where();
            for (int i = 0; i < ruleInfos.size(); ++i) {
                RuleInfo info = ruleInfos.get(i);
                OnlineFilterUtil genUtil = (OnlineFilterUtil)JsonUtil.getJsonToBean((Object)info, OnlineFilterUtil.class);
                genUtil.setDbType(DbTypeUtil.getDbEncodeByProductName((String)databaseProductName));
                genUtil.setSubSqlTableMap(subSqlTableMap);
                genUtil.setParams(params);
                genUtil.solveValue(whereFilter, sqlTable);
            }
            Method method = whereFilter.getClass().getDeclaredMethod("buildWhereModel", new Class[0]);
            method.setAccessible(true);
            WhereModel invoke = (WhereModel)method.invoke((Object)whereFilter, new Object[0]);
            List groupList = invoke.subCriteria();
            where.and((BindableColumn)DerivedColumn.of((String)"1"), (VisitableCondition)SqlBuilder.isEqualTo((Object)1), groupList);
        }
        catch (Exception exception) {
        }
        finally {
            DynamicDataSourceUtil.clearSwitchDataSource();
        }
    }

    @Override
    public void handleWhereCondition(SqlTable sqlTable, QueryExpressionDSL.QueryExpressionWhereBuilder where, String id, Map<String, SqlTable> subSqlTableMap, String databaseProductName) {
        this.handleWhereCondition(sqlTable, where, id, subSqlTableMap, databaseProductName, null);
    }

    @Override
    public List<RuleInfo> getCondition(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return new ArrayList<RuleInfo>();
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().eq(FilterEntity::getModuleId, (Object)id);
        FilterEntity entity = (FilterEntity)this.getOne((Wrapper)wrapper);
        boolean isApp = !RequestContext.isOrignPc();
        String config = isApp ? entity.getConfigApp() : entity.getConfig();
        List<Object> ruleInfos = new ArrayList<RuleInfo>();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{config})) {
            ruleInfos = JsonUtil.getJsonToList((String)config, RuleInfo.class);
        }
        return ruleInfos;
    }
}

