/*
 * Decompiled with CFR 0.152.
 */
package jnpf.util;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jnpf.database.model.superQuery.SuperJsonModel;
import jnpf.database.model.superQuery.SuperQueryJsonModel;
import jnpf.emnus.SearchMethodEnum;
import jnpf.model.QueryAllModel;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.config.ConfigModel;
import jnpf.onlinedev.util.onlineDevUtil.OnlineProductSqlUtils;

public class QueryUtil {
    private SearchMethodEnum symbol;
    private boolean and;
    private String jnpfKey;
    private String vModel;
    private Object fieldValue;
    private Object fieldValueTwo;
    private Map<String, Class> classMap;
    private String dbType;
    private Boolean isSqlServer = false;
    private List<String> dataList = new ArrayList<String>();

    public <T> MPJLambdaWrapper<T> queryList(QueryAllModel queryAllModel) {
        MPJLambdaWrapper wrapper = queryAllModel.getWrapper();
        this.classMap = queryAllModel.getClassMap();
        this.dbType = queryAllModel.getDbType();
        this.isSqlServer = "Microsoft SQL Server".equalsIgnoreCase(this.dbType);
        List<List<SuperJsonModel>> superJsonModelList = queryAllModel.getQueryList();
        for (List<SuperJsonModel> list : superJsonModelList) {
            boolean flag = false;
            for (SuperJsonModel superJsonModel : list) {
                if (superJsonModel.getConditionList().size() <= 0) continue;
                for (SuperQueryJsonModel item : superJsonModel.getConditionList()) {
                    if (item.getGroups().size() <= 0) continue;
                    flag = true;
                }
            }
            if (list.size() <= 0 || !flag) continue;
            wrapper.and(gw -> {
                for (SuperJsonModel superJsonModel : list) {
                    String matchLogic = superJsonModel.getMatchLogic();
                    Boolean authorizeLogic = superJsonModel.getAuthorizeLogic();
                    boolean isAddMatchLogic = SearchMethodEnum.And.getSymbol().equalsIgnoreCase(matchLogic);
                    List conditionList = superJsonModel.getConditionList();
                    if (conditionList.size() == 0) continue;
                    OnlineProductSqlUtils.superList((List)conditionList, (boolean)true);
                    if (authorizeLogic.booleanValue()) {
                        gw.and(tw -> this.queryWrapperList((MPJLambdaWrapper)tw, conditionList, isAddMatchLogic));
                        continue;
                    }
                    gw.or(tw -> this.queryWrapperList((MPJLambdaWrapper)tw, conditionList, isAddMatchLogic));
                }
            });
        }
        return wrapper;
    }

    private <T> void queryWrapperList(MPJLambdaWrapper<T> tw, List<SuperQueryJsonModel> conditionList, boolean isAddMatchLogic) {
        for (SuperQueryJsonModel superQueryJsonModel : conditionList) {
            String logic = superQueryJsonModel.getLogic();
            this.and = SearchMethodEnum.And.getSymbol().equalsIgnoreCase(logic);
            List queryList = superQueryJsonModel.getGroups();
            if (queryList.size() <= 0) continue;
            this.queryWrapper(tw, queryList, isAddMatchLogic);
        }
    }

    private <T> void queryWrapper(MPJLambdaWrapper<T> tw, List<FieLdsModel> queryListAll, boolean isAnd) {
        if (isAnd) {
            tw.and(qw -> this.query((MPJLambdaWrapper)qw, queryListAll));
        } else {
            tw.or(qw -> this.query((MPJLambdaWrapper)qw, queryListAll));
        }
    }

    private <T> void query(MPJLambdaWrapper<T> qw, List<FieLdsModel> queryListAll) {
        for (final FieLdsModel fieLdsModel : queryListAll) {
            ArrayList queryList = new ArrayList(){
                {
                    this.add(fieLdsModel);
                }
            };
            if (this.and) {
                qw.and(ew -> this.fieldsModel((MPJLambdaWrapper)ew, queryList));
                continue;
            }
            qw.or(ew -> this.fieldsModel((MPJLambdaWrapper)ew, queryList));
        }
    }

    private void fieldsModel(MPJLambdaWrapper wrapper, List<FieLdsModel> queryList) {
        for (FieLdsModel fieLdsModel : queryList) {
            ConfigModel config = fieLdsModel.getConfig();
            this.jnpfKey = config.getJnpfKey();
            this.symbol = SearchMethodEnum.getSearchMethod((String)fieLdsModel.getSymbol());
            this.vModel = fieLdsModel.getVModel();
            if (!this.and) {
                wrapper.or();
            }
            String table = ObjectUtil.isNotEmpty((Object)config.getRelationTable()) ? config.getRelationTable() : config.getTableName();
            Class tClass = this.classMap.get(table);
            try {
                Field[] declaredFields;
                Field declaredField = null;
                for (Field item : declaredFields = tClass.getDeclaredFields()) {
                    String tableFieldName;
                    String string = tableFieldName = item.getAnnotation(TableField.class) == null ? "" : item.getAnnotation(TableField.class).value();
                    if (!this.vModel.equalsIgnoreCase(tableFieldName) && !item.getName().equals(this.vModel)) continue;
                    declaredField = item;
                    break;
                }
                declaredField.setAccessible(true);
                this.vModel = table + "." + declaredField.getAnnotation(TableField.class).value();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.fieldValue = fieLdsModel.getFieldValueOne();
            this.fieldValueTwo = fieLdsModel.getFieldValueTwo();
            this.dataList = fieLdsModel.getDataList();
            this.getSymbolWrapper(wrapper);
        }
    }

    private void getNullWrapper(MPJLambdaWrapper<?> wrapper) {
        if (!this.and) {
            wrapper.or(t -> t.isNull((Object)this.vModel));
        } else {
            wrapper.and(t -> t.isNull((Object)this.vModel));
        }
    }

    private void getNotNullWrapper(MPJLambdaWrapper<?> wrapper) {
        if (!this.and) {
            wrapper.or(t -> t.isNotNull((Object)this.vModel));
        } else {
            wrapper.and(t -> t.isNotNull((Object)this.vModel));
        }
    }

    private void getInWrapper(MPJLambdaWrapper<?> wrapper) {
        if (!this.and) {
            wrapper.or(qw -> {
                block3: for (String id : this.dataList) {
                    if (this.isSqlServer.booleanValue()) {
                        id = String.valueOf(id).replaceAll("\\[", "[[]");
                    }
                    switch (this.symbol) {
                        case Included: {
                            ((MPJLambdaWrapper)qw.or()).like((Object)this.vModel, (Object)id);
                            continue block3;
                        }
                    }
                    qw.notLike((Object)this.vModel, (Object)id);
                }
            });
        } else {
            wrapper.and(qw -> {
                block3: for (String id : this.dataList) {
                    if (this.isSqlServer.booleanValue()) {
                        id = String.valueOf(id).replaceAll("\\[", "[[]");
                    }
                    switch (this.symbol) {
                        case Included: {
                            ((MPJLambdaWrapper)qw.or()).like((Object)this.vModel, (Object)id);
                            continue block3;
                        }
                    }
                    qw.notLike((Object)this.vModel, (Object)id);
                }
            });
        }
    }

    private void getSymbolWrapper(MPJLambdaWrapper<?> wrapper) {
        switch (this.symbol) {
            case IsNull: {
                this.getNullWrapper(wrapper);
                break;
            }
            case IsNotNull: {
                this.getNotNullWrapper(wrapper);
                break;
            }
            case Equal: {
                wrapper.eq((Object)this.vModel, this.fieldValue);
                break;
            }
            case NotEqual: {
                wrapper.ne((Object)this.vModel, this.fieldValue);
                break;
            }
            case GreaterThan: {
                wrapper.gt((Object)this.vModel, this.fieldValue);
                break;
            }
            case LessThan: {
                wrapper.lt((Object)this.vModel, this.fieldValue);
                break;
            }
            case GreaterThanOrEqual: {
                wrapper.ge((Object)this.vModel, this.fieldValue);
                break;
            }
            case LessThanOrEqual: {
                wrapper.le((Object)this.vModel, this.fieldValue);
                break;
            }
            case Like: {
                if (this.isSqlServer.booleanValue()) {
                    this.fieldValue = String.valueOf(this.fieldValue).replaceAll("\\[", "[[]");
                }
                wrapper.like((Object)this.vModel, this.fieldValue);
                break;
            }
            case NotLike: {
                if (this.isSqlServer.booleanValue()) {
                    this.fieldValue = String.valueOf(this.fieldValue).replaceAll("\\[", "[[]");
                }
                wrapper.notLike((Object)this.vModel, this.fieldValue);
                break;
            }
            case Included: 
            case NotIncluded: {
                this.getInWrapper(wrapper);
                break;
            }
            case Between: {
                wrapper.between((Object)this.vModel, this.fieldValue, this.fieldValueTwo);
                break;
            }
        }
    }

    public SearchMethodEnum getSymbol() {
        return this.symbol;
    }

    public boolean isAnd() {
        return this.and;
    }

    public String getJnpfKey() {
        return this.jnpfKey;
    }

    public String getVModel() {
        return this.vModel;
    }

    public Object getFieldValue() {
        return this.fieldValue;
    }

    public Object getFieldValueTwo() {
        return this.fieldValueTwo;
    }

    public Map<String, Class> getClassMap() {
        return this.classMap;
    }

    public String getDbType() {
        return this.dbType;
    }

    public Boolean getIsSqlServer() {
        return this.isSqlServer;
    }

    public List<String> getDataList() {
        return this.dataList;
    }

    public void setSymbol(SearchMethodEnum symbol) {
        this.symbol = symbol;
    }

    public void setAnd(boolean and) {
        this.and = and;
    }

    public void setJnpfKey(String jnpfKey) {
        this.jnpfKey = jnpfKey;
    }

    public void setVModel(String vModel) {
        this.vModel = vModel;
    }

    public void setFieldValue(Object fieldValue) {
        this.fieldValue = fieldValue;
    }

    public void setFieldValueTwo(Object fieldValueTwo) {
        this.fieldValueTwo = fieldValueTwo;
    }

    public void setClassMap(Map<String, Class> classMap) {
        this.classMap = classMap;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void setIsSqlServer(Boolean isSqlServer) {
        this.isSqlServer = isSqlServer;
    }

    public void setDataList(List<String> dataList) {
        this.dataList = dataList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryUtil)) {
            return false;
        }
        QueryUtil other = (QueryUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAnd() != other.isAnd()) {
            return false;
        }
        Boolean this$isSqlServer = this.getIsSqlServer();
        Boolean other$isSqlServer = other.getIsSqlServer();
        if (this$isSqlServer == null ? other$isSqlServer != null : !((Object)this$isSqlServer).equals(other$isSqlServer)) {
            return false;
        }
        SearchMethodEnum this$symbol = this.getSymbol();
        SearchMethodEnum other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        String this$jnpfKey = this.getJnpfKey();
        String other$jnpfKey = other.getJnpfKey();
        if (this$jnpfKey == null ? other$jnpfKey != null : !this$jnpfKey.equals(other$jnpfKey)) {
            return false;
        }
        String this$vModel = this.getVModel();
        String other$vModel = other.getVModel();
        if (this$vModel == null ? other$vModel != null : !this$vModel.equals(other$vModel)) {
            return false;
        }
        Object this$fieldValue = this.getFieldValue();
        Object other$fieldValue = other.getFieldValue();
        if (this$fieldValue == null ? other$fieldValue != null : !this$fieldValue.equals(other$fieldValue)) {
            return false;
        }
        Object this$fieldValueTwo = this.getFieldValueTwo();
        Object other$fieldValueTwo = other.getFieldValueTwo();
        if (this$fieldValueTwo == null ? other$fieldValueTwo != null : !this$fieldValueTwo.equals(other$fieldValueTwo)) {
            return false;
        }
        Map<String, Class> this$classMap = this.getClassMap();
        Map<String, Class> other$classMap = other.getClassMap();
        if (this$classMap == null ? other$classMap != null : !((Object)this$classMap).equals(other$classMap)) {
            return false;
        }
        String this$dbType = this.getDbType();
        String other$dbType = other.getDbType();
        if (this$dbType == null ? other$dbType != null : !this$dbType.equals(other$dbType)) {
            return false;
        }
        List<String> this$dataList = this.getDataList();
        List<String> other$dataList = other.getDataList();
        return !(this$dataList == null ? other$dataList != null : !((Object)this$dataList).equals(other$dataList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAnd() ? 79 : 97);
        Boolean $isSqlServer = this.getIsSqlServer();
        result = result * 59 + ($isSqlServer == null ? 43 : ((Object)$isSqlServer).hashCode());
        SearchMethodEnum $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        String $jnpfKey = this.getJnpfKey();
        result = result * 59 + ($jnpfKey == null ? 43 : $jnpfKey.hashCode());
        String $vModel = this.getVModel();
        result = result * 59 + ($vModel == null ? 43 : $vModel.hashCode());
        Object $fieldValue = this.getFieldValue();
        result = result * 59 + ($fieldValue == null ? 43 : $fieldValue.hashCode());
        Object $fieldValueTwo = this.getFieldValueTwo();
        result = result * 59 + ($fieldValueTwo == null ? 43 : $fieldValueTwo.hashCode());
        Map<String, Class> $classMap = this.getClassMap();
        result = result * 59 + ($classMap == null ? 43 : ((Object)$classMap).hashCode());
        String $dbType = this.getDbType();
        result = result * 59 + ($dbType == null ? 43 : $dbType.hashCode());
        List<String> $dataList = this.getDataList();
        result = result * 59 + ($dataList == null ? 43 : ((Object)$dataList).hashCode());
        return result;
    }

    public String toString() {
        return "QueryUtil(symbol=" + String.valueOf(this.getSymbol()) + ", and=" + this.isAnd() + ", jnpfKey=" + this.getJnpfKey() + ", vModel=" + this.getVModel() + ", fieldValue=" + String.valueOf(this.getFieldValue()) + ", fieldValueTwo=" + String.valueOf(this.getFieldValueTwo()) + ", classMap=" + String.valueOf(this.getClassMap()) + ", dbType=" + this.getDbType() + ", isSqlServer=" + this.getIsSqlServer() + ", dataList=" + String.valueOf(this.getDataList()) + ")";
    }
}

