/*
 * Decompiled with CFR 0.152.
 */
package jnpf.util;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Connection;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import jnpf.annotation.JnpfField;
import jnpf.base.ActionResult;
import jnpf.base.UserInfo;
import jnpf.base.entity.DictionaryDataEntity;
import jnpf.base.entity.ModuleEntity;
import jnpf.base.entity.ProvinceEntity;
import jnpf.base.entity.SuperBaseEntity;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.entity.VisualdevReleaseEntity;
import jnpf.base.model.ColumnDataModel;
import jnpf.base.model.OnlineImport.ExcelImportModel;
import jnpf.base.model.OnlineImport.ImportDataModel;
import jnpf.base.model.OnlineImport.ImportFormCheckUniqueModel;
import jnpf.base.model.OnlineImport.VisualdevModelDataInfoVO;
import jnpf.base.model.datainterface.DataInterfaceActionVo;
import jnpf.base.model.datainterface.DataInterfaceModel;
import jnpf.base.model.datainterface.DataInterfacePage;
import jnpf.base.model.filter.RuleInfo;
import jnpf.base.service.BillRuleService;
import jnpf.base.service.DataInterfaceService;
import jnpf.base.service.DbLinkService;
import jnpf.base.service.DictionaryDataService;
import jnpf.base.service.FilterService;
import jnpf.base.service.ModuleService;
import jnpf.base.service.ProvinceService;
import jnpf.base.service.VisualdevService;
import jnpf.base.util.DateTimeFormatConstant;
import jnpf.base.util.FlowFormDataUtil;
import jnpf.base.util.FormCheckUtils;
import jnpf.base.util.FormPublicUtils;
import jnpf.base.util.VisualBillUtil;
import jnpf.base.util.VisualUtils;
import jnpf.base.util.common.DataControlUtils;
import jnpf.base.vo.DownloadVO;
import jnpf.base.vo.PageListVO;
import jnpf.base.vo.PaginationVO;
import jnpf.database.model.entity.DbLinkEntity;
import jnpf.database.model.interfaces.DbSourceOrDbLink;
import jnpf.database.model.superQuery.ConditionJsonModel;
import jnpf.database.model.superQuery.SuperJsonModel;
import jnpf.database.model.superQuery.SuperQueryConditionModel;
import jnpf.database.model.superQuery.SuperQueryJsonModel;
import jnpf.database.util.ConnUtil;
import jnpf.database.util.DynamicDataSourceUtil;
import jnpf.exception.DataException;
import jnpf.exception.WorkFlowException;
import jnpf.flowable.entity.TaskEntity;
import jnpf.model.ExcelModel;
import jnpf.model.OnlineDevData;
import jnpf.model.QueryAllModel;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.FormDataModel;
import jnpf.model.visualJson.TableModel;
import jnpf.model.visualJson.TemplateJsonModel;
import jnpf.model.visualJson.config.ConfigModel;
import jnpf.model.visualJson.config.RuleConfig;
import jnpf.onlinedev.model.OnlineDevEnum.CacheKeyEnum;
import jnpf.onlinedev.model.PaginationModel;
import jnpf.onlinedev.model.PaginationModelExport;
import jnpf.onlinedev.model.VisualErrInfo;
import jnpf.onlinedev.service.VisualDevInfoService;
import jnpf.onlinedev.service.VisualdevModelDataService;
import jnpf.onlinedev.util.onlineDevUtil.OnlineDevListUtils;
import jnpf.onlinedev.util.onlineDevUtil.OnlineProductSqlUtils;
import jnpf.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import jnpf.onlinedev.util.onlineDevUtil.OnlineSwapDataUtils;
import jnpf.permission.entity.GroupEntity;
import jnpf.permission.entity.OrganizeEntity;
import jnpf.permission.entity.PositionEntity;
import jnpf.permission.entity.RoleEntity;
import jnpf.permission.entity.UserEntity;
import jnpf.permission.service.AuthorizeService;
import jnpf.permission.service.GroupService;
import jnpf.permission.service.OrganizeService;
import jnpf.permission.service.PositionService;
import jnpf.permission.service.RoleService;
import jnpf.permission.service.UserRelationService;
import jnpf.permission.service.UserService;
import jnpf.util.DateUtil;
import jnpf.util.GenUtil;
import jnpf.util.JsonUtil;
import jnpf.util.QueryUtil;
import jnpf.util.RedisUtil;
import jnpf.util.StringUtil;
import jnpf.util.TableFeildsEnum;
import jnpf.util.TenantHolder;
import jnpf.util.UserProvider;
import jnpf.util.context.RequestContext;
import jnpf.workflow.service.TaskApi;
import jnpf.workflow.service.TemplateApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GeneraterSwapUtil {
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private FilterService filterService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private UserService userService;
    @Autowired
    private VisualdevService visualdevService;
    @Autowired
    private VisualDevInfoService visualDevInfoService;
    @Autowired
    private DataInterfaceService dataInterfaceService;
    @Autowired
    private VisualdevModelDataService visualdevModelDataService;
    @Autowired
    private ProvinceService provinceService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private BillRuleService billRuleService;
    @Autowired
    private VisualBillUtil visualBillUtil;
    @Autowired
    private GroupService groupService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private DbLinkService dbLinkService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private FlowFormDataUtil flowFormDataUtil;
    @Autowired
    private DbLinkService dblinkService;
    @Autowired
    private OnlineSwapDataUtils swapDataUtils;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private TaskApi taskApi;
    @Autowired
    private TemplateApi templateApi;
    @Autowired
    private FormCheckUtils formCheckUtils;
    public final String regEx = "[\\[\\]\"]";
    private static long DEFAULT_CACHE_TIME = 300L;

    public String dateSwap(String date, String format) {
        if (StringUtil.isNotEmpty((String)date)) {
            DateTimeFormatter ftf = DateTimeFormatter.ofPattern(format);
            if (date.contains(",")) {
                String[] dates = date.split(",");
                long time1 = Long.parseLong(dates[0]);
                long time2 = Long.parseLong(dates[1]);
                String value1 = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(time1), ZoneId.systemDefault()));
                String value2 = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(time2), ZoneId.systemDefault()));
                return value1 + "\u81f3" + value2;
            }
            long time = Long.parseLong(date);
            String value = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()));
            return value;
        }
        return date;
    }

    public String provinceData(String data, Map<String, Object> localCache) {
        Map proMap = new HashMap();
        if (localCache != null && localCache.containsKey("__pro_map")) {
            proMap = (Map)localCache.get("__pro_map");
        }
        if (StringUtil.isNotEmpty((String)data)) {
            try {
                if (data.contains("[[")) {
                    String[][] provinceDataS;
                    ArrayList<String> addList = new ArrayList<String>();
                    for (String[] AddressData : provinceDataS = (String[][])JsonUtil.getJsonToBean((String)data, String[][].class)) {
                        ArrayList<String> provList = new ArrayList<String>(Arrays.asList(AddressData));
                        ArrayList<String> nameList = new ArrayList<String>();
                        if (localCache != null) {
                            for (String info : provList) {
                                nameList.add((String)proMap.get(info));
                            }
                        } else {
                            List proList = this.provinceService.getProList(provList);
                            for (ProvinceEntity info : proList) {
                                nameList.add(info.getFullName());
                            }
                        }
                        addList.add(String.join((CharSequence)"/", nameList));
                    }
                    return String.join((CharSequence)";", addList);
                }
                if (data.contains("[")) {
                    List provList = JsonUtil.getJsonToList((String)data, String.class);
                    ArrayList<String> nameList = new ArrayList<String>();
                    if (localCache != null) {
                        for (String info : provList) {
                            nameList.add((String)proMap.get(info));
                        }
                    } else {
                        List proList = this.provinceService.getProList(provList);
                        for (ProvinceEntity info : proList) {
                            nameList.add(info.getFullName());
                        }
                    }
                    return String.join((CharSequence)"/", nameList);
                }
                String[] strs = data.split(",");
                ArrayList<String> provList = new ArrayList<String>(Arrays.asList(strs));
                ArrayList<String> proNameList = new ArrayList<String>();
                if (localCache != null) {
                    for (String info : provList) {
                        proNameList.add((String)proMap.get(info));
                    }
                } else {
                    List proList = this.provinceService.getProList(provList);
                    for (ProvinceEntity info : proList) {
                        proNameList.add(info.getFullName());
                    }
                }
                return String.join((CharSequence)"/", proNameList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public Map<String, Object> localCache() {
        String dsName = Optional.ofNullable(TenantHolder.getDatasourceId()).orElse("");
        HashMap<String, Object> localCache = new HashMap<String, Object>();
        if (!localCache.containsKey("__pro_map")) {
            Map proMap = this.redisUtil.getMap(String.format("%s-%s-%d", dsName, "province", 1));
            ArrayList<Map> proMapList = new ArrayList<Map>();
            if (proMap.size() == 0) {
                for (i = 1; i <= 4; ++i) {
                    String redisKey = String.format("%s-%s-%d", dsName, "province", i);
                    if (this.redisUtil.exists(redisKey)) continue;
                    List provinceEntityList = this.provinceService.getProListBytype(String.valueOf(i));
                    HashMap provinceMap = new HashMap(16);
                    if (provinceEntityList != null) {
                        provinceEntityList.stream().forEach(p -> provinceMap.put((String)p.getId(), p.getFullName()));
                    }
                    proMapList.add(provinceMap);
                    this.redisUtil.insert(redisKey, provinceMap, 604800L);
                }
            } else {
                for (i = 1; i <= 4; ++i) {
                    proMapList.add(this.redisUtil.getMap(String.format("%s-%s-%d", dsName, "province", i)));
                }
            }
            HashMap proMapr = new HashMap();
            proMapList.forEach(item -> proMapr.putAll(item));
            localCache.put("__pro_map", proMapr);
        }
        return localCache;
    }

    public String comSelectValue(String value, String showLevel) {
        if (StringUtil.isNotEmpty((String)String.valueOf(value))) {
            OrganizeEntity organizeEntity = this.organizeService.getInfo(String.valueOf(value));
            if ("all".equals(showLevel)) {
                List organizeListAll = this.organizeService.getList(false);
                String[] organizeTreeId = StringUtil.isNotEmpty((String)organizeEntity.getOrganizeIdTree()) ? organizeEntity.getOrganizeIdTree().split(",") : new String[]{};
                List organizeTreeList = Arrays.asList(organizeTreeId).stream().filter(t -> !t.isEmpty()).collect(Collectors.toList());
                StringJoiner joiner = new StringJoiner("/");
                for (int i = 0; i < organizeTreeList.size(); ++i) {
                    String id = (String)organizeTreeList.get(i);
                    OrganizeEntity entity = organizeListAll.stream().filter(t -> ((String)t.getId()).equals(id)).findFirst().orElse(null);
                    if (entity == null) continue;
                    joiner.add(entity.getFullName());
                }
                value = joiner.toString();
            } else if (organizeEntity != null) {
                if (organizeEntity.getCategory().equals("company")) {
                    return " ";
                }
                value = organizeEntity.getFullName();
            }
        } else {
            value = " ";
        }
        return value;
    }

    public String comSelectValues(String ids, Boolean mul) {
        String Separator;
        ArrayList<String> comValueList = new ArrayList<String>();
        if (StringUtil.isEmpty((String)ids)) {
            return null;
        }
        String string = Separator = mul != false ? "," : "/";
        if (ids.contains("[[")) {
            String[][] idArrays;
            for (String[] array : idArrays = (String[][])JsonUtil.getJsonToBean((String)ids, String[][].class)) {
                ArrayList<String> idList = new ArrayList<String>();
                for (String s : array) {
                    OrganizeEntity info = this.organizeService.getInfo(s);
                    idList.add(Objects.nonNull(info) ? info.getFullName() : s);
                }
                String orgCom = idList.stream().collect(Collectors.joining("/"));
                comValueList.add(orgCom);
            }
            return comValueList.stream().collect(Collectors.joining(";"));
        }
        if (ids.contains("[")) {
            List idList = JsonUtil.getJsonToList((String)ids, String.class);
            ArrayList<String> nameList = new ArrayList<String>();
            for (String orgId : idList) {
                OrganizeEntity info = this.organizeService.getInfo(orgId);
                nameList.add(Objects.nonNull(info) ? info.getFullName() : orgId);
            }
            return nameList.stream().collect(Collectors.joining(Separator));
        }
        String[] idList = (ids = ids.replaceAll("\"", "")).split(",");
        if (idList.length > 0) {
            ArrayList<String> comSelectList = new ArrayList<String>();
            for (String id : idList) {
                OrganizeEntity organizeEntity = this.organizeService.getInfo(id);
                if (organizeEntity == null) continue;
                comSelectList.add(organizeEntity.getFullName());
            }
            return String.join((CharSequence)",", comSelectList);
        }
        return null;
    }

    public String posSelectValue(String id) {
        if (StringUtil.isNotEmpty((String)id)) {
            PositionEntity positionApiInfo = this.positionService.getInfo(id);
            if (ObjectUtil.isNotEmpty((Object)positionApiInfo)) {
                return positionApiInfo.getFullName();
            }
            return id;
        }
        return " ";
    }

    public String posSelectValues(String ids) {
        if (StringUtil.isEmpty((String)ids)) {
            return "";
        }
        ArrayList<String> posList = new ArrayList<String>();
        if (ids.contains("[")) {
            List idList = JsonUtil.getJsonToList((String)ids, String.class);
            ArrayList<String> nameList = new ArrayList<String>();
            for (String orgId : idList) {
                PositionEntity info = this.positionService.getInfo(orgId);
                nameList.add(Objects.nonNull(info) ? info.getFullName() : orgId);
            }
            posList = nameList;
        } else {
            String[] idList = ids.split(",");
            if (idList.length > 0) {
                for (String id : idList) {
                    PositionEntity positionEntity = this.positionService.getInfo(id);
                    if (!ObjectUtil.isNotEmpty((Object)positionEntity)) continue;
                    posList.add(positionEntity.getFullName());
                }
            }
        }
        return String.join((CharSequence)",", posList);
    }

    public String userSelectValue(String id) {
        if (StringUtil.isNotEmpty((String)id)) {
            UserEntity userEntity = this.userService.getInfo(id);
            if (ObjectUtil.isNotEmpty((Object)userEntity)) {
                return userEntity.getRealName() + "/" + userEntity.getAccount();
            }
            return id;
        }
        return "";
    }

    public String userSelectValues(String ids) {
        Map userMap;
        String dsName = Optional.ofNullable(TenantHolder.getDatasourceId()).orElse("");
        String redisKey = dsName + CacheKeyEnum.USER.getName();
        if (this.redisUtil.exists(redisKey)) {
            userMap = this.redisUtil.getMap(redisKey);
            userMap = Optional.ofNullable(userMap).orElse(new HashMap(20));
        } else {
            userMap = this.userService.getUserMap();
            this.redisUtil.insert(redisKey, (Object)userMap, DEFAULT_CACHE_TIME);
        }
        if (StringUtil.isEmpty((String)ids)) {
            return ids;
        }
        if (ids.contains("[")) {
            ArrayList<String> nameList = new ArrayList<String>();
            List jsonToList = JsonUtil.getJsonToList((String)ids, String.class);
            for (String userId : jsonToList) {
                nameList.add(Objects.nonNull(userMap.get(userId)) ? userMap.get(userId).toString() : userId);
            }
            return String.join((CharSequence)";", nameList);
        }
        ArrayList<String> userInfoList = new ArrayList<String>();
        String[] idList = ids.split(",");
        if (idList.length > 0) {
            for (String userId : idList) {
                userInfoList.add(Objects.nonNull(userMap.get(userId)) ? userMap.get(userId).toString() : userId);
            }
        }
        return String.join((CharSequence)"-", userInfoList);
    }

    public String usersSelectValues(String ids) {
        if (StringUtil.isEmpty((String)ids)) {
            return ids;
        }
        List dataNoSwapInMethod = OnlinePublicUtils.getDataNoSwapInMethod((Object)ids);
        StringJoiner valueJoin = new StringJoiner(",");
        block14: for (String data : dataNoSwapInMethod) {
            String type;
            String id = data.contains("--") ? data.substring(0, data.lastIndexOf("--")) : data;
            switch (type = data.contains("--") ? data.substring(data.lastIndexOf("--") + 2) : "") {
                case "role": {
                    RoleEntity roleEntity = this.roleService.getInfo(id);
                    if (roleEntity != null) {
                        valueJoin.add(roleEntity.getFullName());
                        continue block14;
                    }
                    valueJoin.add(data);
                    continue block14;
                }
                case "position": {
                    PositionEntity positionEntity = this.positionService.getInfo(id);
                    if (positionEntity != null) {
                        valueJoin.add(positionEntity.getFullName());
                        continue block14;
                    }
                    valueJoin.add(data);
                    continue block14;
                }
                case "company": 
                case "department": {
                    OrganizeEntity organizeEntity = this.organizeService.getInfo(id);
                    if (organizeEntity != null) {
                        valueJoin.add(organizeEntity.getFullName());
                        continue block14;
                    }
                    valueJoin.add(data);
                    continue block14;
                }
                case "group": {
                    GroupEntity groupEntity = this.groupService.getInfo(id);
                    if (groupEntity != null) {
                        valueJoin.add(groupEntity.getFullName());
                        continue block14;
                    }
                    valueJoin.add(data);
                    continue block14;
                }
            }
            UserEntity userEntity = this.userService.getInfo(id);
            if (userEntity != null) {
                valueJoin.add(userEntity.getRealName() + "/" + userEntity.getAccount());
                continue;
            }
            valueJoin.add(data);
        }
        return valueJoin.toString();
    }

    public String switchSelectValue(String data, String activeTxt, String inactiveTxt) {
        if (StringUtil.isNotEmpty((String)data)) {
            if (data.equals("0") || data.equals("false")) {
                return inactiveTxt;
            }
            if (data.equals("1") || data.equals("true")) {
                return activeTxt;
            }
            return data;
        }
        return null;
    }

    public VisualdevEntity visualdevEntity(String id) {
        return this.visualdevService.getInfo(id);
    }

    public String swapRelationFormValue(String vmodel, String value, String modelId, Map<String, Object> formDataMaps) {
        if (StringUtil.isEmpty((String)value)) {
            return "";
        }
        try {
            VisualdevModelDataInfoVO infoVO = null;
            VisualdevEntity entity = this.visualdevService.getInfo(modelId);
            infoVO = !StringUtil.isEmpty((String)entity.getVisualTables()) && !"[]".equals(entity.getVisualTables()) ? this.visualDevInfoService.getDetailsDataInfo(value, entity) : this.visualdevModelDataService.infoDataChange(value, entity);
            if (infoVO != null) {
                Map formDataMap;
                Map map = formDataMap = infoVO.getData() != null ? JsonUtil.stringToMap((String)infoVO.getData()) : new HashMap();
                if (formDataMap.size() > 0) {
                    formDataMaps.putAll(formDataMap);
                    formDataMap = OnlinePublicUtils.mapKeyToLower(formDataMap);
                    value = String.valueOf(formDataMap.get(vmodel.toLowerCase()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public String getPopupSelectValue(String interfaceId, String propsValue, String relationField, String dataValue, Map<String, Object> dataMaps, String json, int num, Map<String, Object> dataAll) {
        if (StringUtil.isEmpty((String)interfaceId)) {
            return null;
        }
        List list = JsonUtil.getJsonToList((String)json, TemplateJsonModel.class);
        HashMap<String, String> infoMap = new HashMap<String, String>();
        ArrayList<DataInterfaceModel> listParam = new ArrayList<DataInterfaceModel>();
        for (TemplateJsonModel templateJsonModel : list) {
            DataInterfaceModel dataInterfaceModel = (DataInterfaceModel)JsonUtil.getJsonToBean((Object)templateJsonModel, DataInterfaceModel.class);
            String defaultV = "";
            if (StringUtil.isNotEmpty((String)templateJsonModel.getRelationField())) {
                String[] mastTable = templateJsonModel.getRelationField().split("_jnpf_");
                String[] child = templateJsonModel.getRelationField().split("-");
                if (mastTable.length > 1) {
                    if (dataAll.get(mastTable[0]) instanceof Map) {
                        Map mastTableData = (Map)dataAll.get(mastTable[0]);
                        infoMap.put(templateJsonModel.getField(), String.valueOf(mastTableData.get(mastTable[1])));
                        defaultV = String.valueOf(mastTableData.get(mastTable[1]));
                    }
                } else if (child.length > 1) {
                    if (dataAll.get(child[0]) instanceof List) {
                        List chidList = (List)dataAll.get(child[0]);
                        for (int i = 0; i < chidList.size(); ++i) {
                            Map objectMap = (Map)chidList.get(i);
                            if (i != num) continue;
                            infoMap.put(templateJsonModel.getField(), String.valueOf(objectMap.get(child[1])));
                            defaultV = String.valueOf(objectMap.get(child[1]));
                        }
                    }
                } else {
                    infoMap.put(templateJsonModel.getField(), String.valueOf(dataAll.get(templateJsonModel.getRelationField())));
                    defaultV = String.valueOf(String.valueOf(dataAll.get(templateJsonModel.getRelationField())));
                }
            }
            dataInterfaceModel.setDefaultValue((Object)defaultV);
            listParam.add(dataInterfaceModel);
        }
        if (StringUtil.isNotEmpty((String)dataValue)) {
            Map dataMap;
            DataInterfacePage dataInterfacePage = new DataInterfacePage();
            dataInterfacePage.setParamList(listParam);
            dataInterfacePage.setInterfaceId(interfaceId);
            List<String> ids = new ArrayList<String>();
            if (dataValue.startsWith("[")) {
                ids = JsonUtil.getJsonToList((String)dataValue, String.class);
            } else {
                ids.add(dataValue);
            }
            dataInterfacePage.setIds(ids);
            dataInterfacePage.setPropsValue(propsValue);
            dataInterfacePage.setRelationField(relationField);
            List dataInterfaceDataList = this.dataInterfaceService.infoToInfo(interfaceId, dataInterfacePage);
            if (dataValue.contains("[")) {
                List valueList = JsonUtil.getJsonToList((String)dataValue, String.class);
                ArrayList swapValue = new ArrayList();
                for (String va : valueList) {
                    dataInterfaceDataList.stream().filter(map -> map.get(propsValue).equals(va)).forEach(modelMap -> swapValue.add(String.valueOf(modelMap.get(relationField))));
                }
                return swapValue.stream().collect(Collectors.joining(","));
            }
            if (dataInterfaceDataList != null && (dataMap = (Map)dataInterfaceDataList.stream().filter(d -> d.get(propsValue).equals(dataValue)).findFirst().orElse(null)) != null) {
                dataMaps.putAll(dataMap);
                return String.valueOf(dataMap.get(relationField));
            }
            return null;
        }
        return null;
    }

    public String getPopupSelectValue(String interfaceId, String propsValue, String relationField, String dataValue, Map<String, Object> dataMaps) {
        if (StringUtil.isEmpty((String)interfaceId)) {
            return null;
        }
        if (StringUtil.isNotEmpty((String)dataValue)) {
            List dataInterfaceDataList;
            Object data = this.dataInterfaceService.infoToId(interfaceId, null, null).getData();
            if (data instanceof ActionResult) {
                ActionResult actionVo = (ActionResult)data;
                dataInterfaceDataList = (List)actionVo.getData();
            } else {
                dataInterfaceDataList = (List)data;
            }
            if (dataValue.contains("[")) {
                List valueList = JsonUtil.getJsonToList((String)dataValue, String.class);
                ArrayList swapValue = new ArrayList();
                for (String va : valueList) {
                    dataInterfaceDataList.stream().filter(map -> map.get(propsValue).equals(va)).forEach(modelMap -> swapValue.add(String.valueOf(modelMap.get(relationField))));
                }
                return swapValue.stream().collect(Collectors.joining(","));
            }
            Map dataMap = dataInterfaceDataList.stream().filter(d -> d.get(propsValue).equals(dataValue)).findFirst().orElse(null);
            if (dataMap != null) {
                dataMaps.putAll(dataMap);
                return String.valueOf(dataMap.get(relationField));
            }
            return null;
        }
        return null;
    }

    public String getFileNameInJson(String fileJson) {
        if (StringUtil.isNotEmpty((String)fileJson) && !"null".equals(fileJson)) {
            return fileJson;
        }
        return "";
    }

    public String getDicName(String feild, String dictionaryTypeId) {
        if (StringUtil.isNotEmpty((String)feild)) {
            String[] feilds = (feild = feild.replaceAll("[\\[\\]\"]", "")).split(",");
            if (feilds.length > 1) {
                StringBuilder feildsValue = new StringBuilder();
                for (String feil : feilds) {
                    DictionaryDataEntity dictionaryDataEntity = this.dictionaryDataService.getSwapInfo(feil, dictionaryTypeId);
                    if (dictionaryDataEntity != null) {
                        feildsValue.append(dictionaryDataEntity.getFullName() + ",");
                        continue;
                    }
                    feildsValue.append(feil + ",");
                }
                String finalValue = StringUtil.isEmpty((CharSequence)feildsValue) || feildsValue.equals("") ? feildsValue.toString() : feildsValue.substring(0, feildsValue.length() - 1);
                return finalValue;
            }
            DictionaryDataEntity dictionaryDataentity = this.dictionaryDataService.getSwapInfo(feild, dictionaryTypeId);
            if (dictionaryDataentity != null) {
                return dictionaryDataentity.getFullName();
            }
            return feild;
        }
        if (StringUtil.isNotEmpty((String)feild)) {
            List list = this.dictionaryDataService.getDicList(dictionaryTypeId);
        }
        return feild;
    }

    public String getDicName(String feild, String dictionaryTypeId, String keyName, boolean isMultiple, String separator) {
        Object dataConversion = "";
        String redisKey = dictionaryTypeId + "-" + feild + "-" + keyName;
        if (StringUtil.isNotEmpty((String)feild)) {
            List dicList;
            if (this.redisUtil.exists(redisKey)) {
                List tmpList = this.redisUtil.get(redisKey, 0L, -1L);
                dicList = JsonUtil.getJsonToList((Object)tmpList, DictionaryDataEntity.class);
            } else {
                dicList = this.dictionaryDataService.getDicList(dictionaryTypeId);
                this.redisUtil.insert(redisKey, (Object)dicList, DEFAULT_CACHE_TIME);
            }
            HashMap<String, String> idMap = new HashMap<String, String>(dicList.size());
            HashMap<String, String> enCodeMap = new HashMap<String, String>(dicList.size());
            for (DictionaryDataEntity dd : dicList) {
                idMap.put((String)dd.getId(), dd.getFullName());
                enCodeMap.put(dd.getEnCode(), dd.getFullName());
            }
            if (StringUtil.isNotEmpty((String)separator)) {
                separator = "/";
            }
            dataConversion = "enCode".equals(keyName) ? FormPublicUtils.getDataConversion(enCodeMap, (Object)feild, (boolean)isMultiple, (String)separator) : FormPublicUtils.getDataConversion(idMap, (Object)feild, (boolean)isMultiple, (String)separator);
        }
        return dataConversion.toString();
    }

    public String getDynName(String urlId, String label, String value, String feildValue, String json, int num, Map<String, Object> dataAll) {
        List list = JsonUtil.getJsonToList((String)json, TemplateJsonModel.class);
        HashMap<String, String> infoMap = list.size() > 0 ? new HashMap<String, String>() : null;
        for (TemplateJsonModel templateJsonModel : list) {
            if (!StringUtil.isNotEmpty((String)templateJsonModel.getRelationField())) continue;
            String[] mastTable = templateJsonModel.getRelationField().split("_jnpf_");
            String[] child = templateJsonModel.getRelationField().split("-");
            if (mastTable.length > 1) {
                if (!(dataAll.get(mastTable[0]) instanceof Map)) continue;
                Map mastTableData = (Map)dataAll.get(mastTable[0]);
                infoMap.put(templateJsonModel.getField(), String.valueOf(mastTableData.get(mastTable[1])));
                continue;
            }
            if (child.length > 1) {
                if (!(dataAll.get(child[0]) instanceof List)) continue;
                List chidList = (List)dataAll.get(child[0]);
                for (int i = 0; i < chidList.size(); ++i) {
                    Map objectMap = (Map)chidList.get(i);
                    if (i != num) continue;
                    infoMap.put(templateJsonModel.getField(), String.valueOf(objectMap.get(child[1])));
                }
                continue;
            }
            infoMap.put(templateJsonModel.getField(), String.valueOf(dataAll.get(templateJsonModel.getRelationField())));
        }
        if (StringUtil.isNotEmpty((String)feildValue)) {
            feildValue = feildValue.replaceAll("[\\[\\]\"]", "");
            HashMap a = new HashMap();
            ActionResult object = this.dataInterfaceService.infoToId(urlId, null, infoMap);
            if (object.getData() != null && object.getData() instanceof DataInterfaceActionVo) {
                DataInterfaceActionVo vo = (DataInterfaceActionVo)object.getData();
                List dataList = (List)vo.getData();
                String[] feildValues = feildValue.split(",");
                if (feildValues.length > 0) {
                    StringBuilder feildVa = new StringBuilder();
                    for (String feild : feildValues) {
                        for (Map data : dataList) {
                            if (!String.valueOf(data.get(value)).equals(feild)) continue;
                            feildVa.append(String.valueOf(data.get(label)) + ",");
                        }
                    }
                    String finalValue = StringUtil.isEmpty((CharSequence)feildVa) || feildVa.equals("") ? feildVa.toString() : feildVa.substring(0, feildVa.length() - 1);
                    return finalValue;
                }
                Iterator iterator = dataList.iterator();
                if (iterator.hasNext()) {
                    Map data = (Map)iterator.next();
                    if (feildValue.equals(String.valueOf(data.get(value)))) {
                        return data.get(label).toString();
                    }
                    return feildValue;
                }
            }
            return feildValue;
        }
        return feildValue;
    }

    public String getDynName(String urlId, String name, String id, String children, String feildValue, boolean mul) {
        ArrayList result = new ArrayList();
        String sep = ",";
        if (mul) {
            sep = "/";
        }
        if (StringUtil.isNotEmpty((String)feildValue)) {
            HashMap a = new HashMap();
            ActionResult object = this.dataInterfaceService.infoToId(urlId, null, null);
            List dataList = (List)object.getData();
            JSONArray dataAll = JsonUtil.getListToJsonArray((List)dataList);
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            this.treeToList(id, name, children, dataAll, list);
            String value = feildValue.replaceAll("\\[", "").replaceAll("\\]", "");
            HashMap resultMap = new HashMap();
            list.stream().forEach(t -> resultMap.put(String.valueOf(t.get(id)), String.valueOf(t.get(name))));
            if (feildValue.startsWith("[[")) {
                String[][] fv = (String[][])JsonUtil.getJsonToBean((String)feildValue, String[][].class);
                StringJoiner f1 = new StringJoiner(",");
                for (String[] f : fv) {
                    StringJoiner v1 = new StringJoiner("/");
                    for (String v : f) {
                        v1.add((CharSequence)resultMap.get(v));
                    }
                    f1.add(v1.toString());
                }
                return f1.toString();
            }
            if (feildValue.startsWith("[")) {
                List fvs = JsonUtil.getJsonToList((String)feildValue, String.class);
                return fvs.stream().map(m -> (String)resultMap.get(m)).collect(Collectors.joining(sep));
            }
            return (String)resultMap.get(feildValue);
        }
        return feildValue;
    }

    public String getDynName(String urlId, String name, String id, String children, String feildValue, boolean mul, boolean isFullPath, String json, int num, Map<String, Object> dataAll1) {
        List list = JsonUtil.getJsonToList((String)json, TemplateJsonModel.class);
        HashMap<String, String> infoMap = list.size() > 0 ? new HashMap<String, String>() : null;
        for (TemplateJsonModel templateJsonModel : list) {
            if (!StringUtil.isNotEmpty((String)templateJsonModel.getRelationField())) continue;
            String[] mastTable = templateJsonModel.getRelationField().split("_jnpf_");
            String[] child = templateJsonModel.getRelationField().split("-");
            if (mastTable.length > 1) {
                if (!(dataAll1.get(mastTable[0]) instanceof Map)) continue;
                Map mastTableData = (Map)dataAll1.get(mastTable[0]);
                infoMap.put(templateJsonModel.getField(), String.valueOf(mastTableData.get(mastTable[1])));
                continue;
            }
            if (child.length > 1) {
                if (!(dataAll1.get(child[0]) instanceof List)) continue;
                List chidList = (List)dataAll1.get(child[0]);
                for (int i = 0; i < chidList.size(); ++i) {
                    Map objectMap = (Map)chidList.get(i);
                    if (i != num) continue;
                    infoMap.put(templateJsonModel.getField(), String.valueOf(objectMap.get(child[1])));
                }
                continue;
            }
            infoMap.put(templateJsonModel.getField(), String.valueOf(dataAll1.get(templateJsonModel.getRelationField())));
        }
        if (StringUtil.isNotEmpty((String)feildValue)) {
            HashMap a = new HashMap();
            ActionResult data = this.dataInterfaceService.infoToId(urlId, null, infoMap);
            List dataList = (List)data.getData();
            JSONArray dataAll = JsonUtil.getListToJsonArray((List)dataList);
            ArrayList<Map<String, Object>> datalist = new ArrayList<Map<String, Object>>();
            this.treeToList(id, name, children, dataAll, datalist);
            String value = feildValue.replaceAll("\\[", "").replaceAll("\\]", "");
            HashMap resultMap = new HashMap();
            datalist.stream().forEach(t -> resultMap.put(String.valueOf(t.get(id)), String.valueOf(t.get(name))));
            Object dataConversion = FormPublicUtils.getDataConversion(resultMap, (Object)feildValue, (boolean)mul, (String)"/");
            feildValue = String.valueOf(dataConversion);
        }
        return feildValue;
    }

    private void treeToList(String id, String fullName, String children, JSONArray data, List<Map<String, Object>> result) {
        if (data != null) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject ob = data.getJSONObject(i);
                HashMap<String, String> tree = new HashMap<String, String>(16);
                tree.put(id, String.valueOf(ob.get((Object)id)));
                tree.put(fullName, String.valueOf(ob.get((Object)fullName)));
                result.add(tree);
                if (ob.get((Object)children) == null) continue;
                JSONArray childArray = ob.getJSONArray(children);
                this.treeToList(id, fullName, children, childArray, result);
            }
        }
    }

    @DS(value="")
    public String getBillNumber(String encode, Boolean isCache) throws DataException {
        return this.billRuleService.getBillNumber(encode, isCache.booleanValue());
    }

    @DS(value="")
    public String getBillNumber2(String visualId, String ruleId, String ruleJson, Object obj) throws DataException {
        Map dataMap = JsonUtil.entityToMap((Object)obj);
        FieLdsModel fieLdsModel = new FieLdsModel();
        ConfigModel config = new ConfigModel();
        config.setRuleType(Integer.valueOf(2));
        config.setJnpfKey("billRule");
        config.setFormId(ruleId);
        RuleConfig ruleConfig = (RuleConfig)JsonUtil.getJsonToBean((String)ruleJson, RuleConfig.class);
        config.setRuleConfig(ruleConfig);
        fieLdsModel.setConfig(config);
        Object billNumber = this.visualBillUtil.getBillNumber(visualId, fieLdsModel, dataMap, null);
        return billNumber.toString();
    }

    public VisualdevEntity getVisualEntity(String visualId) {
        VisualdevEntity info = this.visualdevService.getInfo(visualId);
        if (info != null) {
            return info;
        }
        return new VisualdevEntity();
    }

    @DS(value="")
    public UserEntity getUser(String userId) {
        return this.userService.getInfo(userId);
    }

    public String getGroupSelect(String groupIds) {
        if (StringUtil.isEmpty((String)groupIds)) {
            return groupIds;
        }
        ArrayList<String> swapList = new ArrayList<String>();
        if (groupIds.contains("[")) {
            List groups = JsonUtil.getJsonToList((String)groupIds, String.class);
            for (String g : groups) {
                GroupEntity info = this.groupService.getInfo(g);
                String s = info != null ? info.getFullName() : "";
                swapList.add(s);
            }
        } else {
            GroupEntity info = this.groupService.getInfo(groupIds);
            swapList.add(info != null ? info.getFullName() : "");
        }
        return swapList.stream().collect(Collectors.joining(","));
    }

    public String getRoleSelect(String roleIds) {
        if (StringUtil.isEmpty((String)roleIds)) {
            return roleIds;
        }
        ArrayList<String> swapList = new ArrayList<String>();
        if (roleIds.contains("[")) {
            List groups = JsonUtil.getJsonToList((String)roleIds, String.class);
            for (String g : groups) {
                RoleEntity info = this.roleService.getInfo(g);
                String s = info != null ? info.getFullName() : "";
                swapList.add(s);
            }
        } else {
            RoleEntity info = this.roleService.getInfo(roleIds);
            swapList.add(info != null ? info.getFullName() : "");
        }
        return swapList.stream().collect(Collectors.joining(","));
    }

    public Integer getCondition(SuperQueryConditionModel conditionModel, Object entity, int num) {
        QueryWrapper queryWrapper = conditionModel.getObj();
        List queryConditionModels = conditionModel.getConditionList();
        String op = conditionModel.getMatchLogic();
        String tableName = conditionModel.getTableName();
        ArrayList<ConditionJsonModel> useCondition = new ArrayList<ConditionJsonModel>();
        for (ConditionJsonModel queryConditionModel : queryConditionModels) {
            String s1;
            String child;
            if (!queryConditionModel.getTableName().equalsIgnoreCase(tableName)) continue;
            if (queryConditionModel.getField().contains("jnpf")) {
                child = queryConditionModel.getField();
                s1 = child.substring(child.lastIndexOf("jnpf_")).replace("jnpf_", "");
                queryConditionModel.setField(s1);
            }
            if (queryConditionModel.getField().startsWith("tableField")) {
                child = queryConditionModel.getField();
                s1 = child.substring(child.indexOf("-") + 1);
                queryConditionModel.setField(s1);
            }
            useCondition.add(queryConditionModel);
        }
        if (queryConditionModels.size() < 1 || useCondition.size() < 1) {
            return num;
        }
        if (useCondition.size() > 0) {
            ++num;
        }
        for (ConditionJsonModel queryConditionModel : useCondition) {
            Long o1;
            String startTime;
            String jnpfKey = queryConditionModel.getJnpfKey();
            String fieldValue = queryConditionModel.getFieldValue();
            if (StringUtil.isEmpty((String)fieldValue)) {
                if (jnpfKey.equals("cascader") || jnpfKey.equals("checkbox") || jnpfKey.equals("organizeSelect") || jnpfKey.equals("areaSelect")) {
                    queryConditionModel.setFieldValue("[]");
                } else {
                    queryConditionModel.setFieldValue("");
                }
                if (queryConditionModel.getSymbol().equals("like")) {
                    queryConditionModel.setSymbol("==");
                } else if (queryConditionModel.getSymbol().equals("notLike")) {
                    queryConditionModel.setSymbol("<>");
                }
            }
            if (jnpfKey.equals("datePicker")) {
                startTime = "";
                if (StringUtil.isNotEmpty((String)fieldValue)) {
                    o1 = Long.valueOf(fieldValue);
                    startTime = DateUtil.daFormatHHMMSS((Long)o1);
                }
                queryConditionModel.setFieldValue(startTime);
                continue;
            }
            if (!jnpfKey.equals("createTime") && !jnpfKey.equals("modifyTime")) continue;
            startTime = "";
            if (StringUtil.isNotEmpty((String)fieldValue)) {
                o1 = Long.valueOf(fieldValue);
                startTime = DateUtil.daFormatHHMMSS((Long)o1);
            }
            queryConditionModel.setFieldValue(startTime);
        }
        Class<?> aClass = entity.getClass();
        queryWrapper.and(tw -> {
            for (ConditionJsonModel conditionJsonModel : useCondition) {
                String conditionField = conditionJsonModel.getField();
                String jnpfKey = conditionJsonModel.getJnpfKey();
                Field declaredField = null;
                try {
                    declaredField = aClass.getDeclaredField(conditionField);
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
                declaredField.setAccessible(true);
                String field = declaredField.getAnnotation(TableField.class).value();
                String fieldValue = conditionJsonModel.getFieldValue();
                String symbol = conditionJsonModel.getSymbol();
                if ("AND".equalsIgnoreCase(op)) {
                    if (symbol.equals("==")) {
                        tw.and(qw -> {
                            ArrayList multJnpf = new ArrayList(){
                                {
                                    this.add("cascader");
                                    this.add("organizeSelect");
                                    this.add("areaSelect");
                                    this.add("select");
                                    this.add("treeSelect");
                                }
                            };
                            if ("checkbox".equals(jnpfKey) || multJnpf.contains(jnpfKey) && conditionJsonModel.isFormMultiple()) {
                                Object eavalue = "";
                                if (fieldValue.contains("[")) {
                                    eavalue = "[" + fieldValue + "]";
                                } else {
                                    JSONArray jarr = new JSONArray();
                                    jarr.add((Object)fieldValue);
                                    eavalue = jarr.toJSONString();
                                }
                                qw.eq((Object)field, eavalue);
                            } else if (!jnpfKey.equals("inputNumber") && !jnpfKey.equals("calculate")) {
                                qw.eq((Object)field, (Object)fieldValue);
                            } else if (StringUtil.isNotEmpty((String)fieldValue)) {
                                qw.eq((Object)field, (Object)fieldValue);
                            }
                            if (StringUtil.isEmpty((String)fieldValue)) {
                                qw.or(ew -> ew.isNull((Object)field));
                            }
                        });
                        continue;
                    }
                    if (symbol.equals(">=")) {
                        tw.ge((Object)field, (Object)fieldValue);
                        continue;
                    }
                    if (symbol.equals("<=")) {
                        tw.and(ew -> {
                            ew.le((Object)field, (Object)fieldValue);
                            ew.and(qw -> qw.ne((Object)field, (Object)""));
                        });
                        continue;
                    }
                    if (symbol.equals(">")) {
                        tw.gt((Object)field, (Object)fieldValue);
                        continue;
                    }
                    if (symbol.equals("<")) {
                        tw.and(ew -> {
                            ew.lt((Object)field, (Object)fieldValue);
                            ew.and(qw -> qw.ne((Object)field, (Object)""));
                        });
                        continue;
                    }
                    if (symbol.equals("<>")) {
                        tw.and(ew -> {
                            ew.ne((Object)field, (Object)fieldValue);
                            if (StringUtil.isNotEmpty((String)fieldValue)) {
                                ew.or(qw -> qw.isNull((Object)field));
                            } else {
                                ew.and(qw -> qw.isNotNull((Object)field));
                            }
                        });
                        continue;
                    }
                    if (symbol.equals("like")) {
                        tw.and(ew -> {
                            if (StringUtil.isNotEmpty((String)fieldValue)) {
                                ew.like((Object)field, (Object)fieldValue);
                            } else {
                                ew.isNull((Object)field);
                            }
                        });
                        continue;
                    }
                    if (!symbol.equals("notLike")) continue;
                    tw.and(ew -> {
                        if (StringUtil.isNotEmpty((String)fieldValue)) {
                            ew.notLike((Object)field, (Object)fieldValue);
                            ew.or(qw -> qw.isNull((Object)field));
                        } else {
                            ew.isNotNull((Object)field);
                        }
                    });
                    continue;
                }
                if (symbol.equals("==")) {
                    tw.or(qw -> qw.eq((Object)field, (Object)fieldValue));
                    continue;
                }
                if (symbol.equals(">=")) {
                    tw.or(qw -> qw.ge((Object)field, (Object)fieldValue));
                    continue;
                }
                if (symbol.equals("<=")) {
                    tw.or(qw -> qw.le((Object)field, (Object)fieldValue));
                    continue;
                }
                if (symbol.equals(">")) {
                    tw.or(qw -> qw.gt((Object)field, (Object)fieldValue));
                    continue;
                }
                if (symbol.equals("<")) {
                    tw.or(qw -> qw.lt((Object)field, (Object)fieldValue));
                    continue;
                }
                if (symbol.equals("<>")) {
                    tw.or(qw -> qw.ne((Object)field, (Object)fieldValue));
                    if (!StringUtil.isNotEmpty((String)fieldValue)) continue;
                    tw.or(qw -> qw.isNull((Object)field));
                    continue;
                }
                if (symbol.equals("like")) {
                    if (StringUtil.isNotEmpty((String)fieldValue)) {
                        tw.or(qw -> qw.like((Object)field, (Object)fieldValue));
                        continue;
                    }
                    tw.or(qw -> qw.isNull((Object)field));
                    continue;
                }
                if (!symbol.equals("notLike")) continue;
                if (StringUtil.isNotEmpty((String)fieldValue)) {
                    tw.or(qw -> qw.notLike((Object)field, (Object)fieldValue));
                    tw.or(qw -> qw.isNull((Object)field));
                    continue;
                }
                tw.or(qw -> qw.isNotNull((Object)field));
            }
        });
        return num;
    }

    public List<String> getIntersection(List<List<String>> lists) {
        if (lists == null || lists.size() == 0) {
            return new ArrayList<String>();
        }
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>(lists);
        for (int i = 0; i < arrayList.size(); ++i) {
            List<String> list = arrayList.get(i);
            if (list != null && list.size() != 0) continue;
            return new ArrayList<String>();
        }
        List<String> intersection = arrayList.get(0);
        for (int i = 0; i < arrayList.size(); ++i) {
            List<String> list = arrayList.get(i);
            intersection.retainAll((Collection)arrayList.get(i));
        }
        return intersection;
    }

    public Map<String, Object> putCache(Map<String, Object> localCache) {
        Map depMap = this.organizeService.getOrgEncodeAndName("department");
        localCache.put("_dep_map", depMap);
        Map comMap = this.organizeService.getOrgNameAndId("");
        localCache.put("_com_map", comMap);
        Map posMap = this.positionService.getPosEncodeAndName();
        localCache.put("_pos_map", posMap);
        Map userMap = this.userService.getUserNameAndIdMap();
        localCache.put("_user_map", userMap);
        Map roleMap = this.roleService.getRoleNameAndIdMap();
        localCache.put("_role_map", roleMap);
        Map groupMap = this.groupService.getGroupEncodeMap();
        localCache.put("_group_map", groupMap);
        return localCache;
    }

    private boolean timeInRange(JnpfField jnpfField, Date parse) {
        boolean flag = true;
        if (StringUtil.isNotEmpty((String)jnpfField.startTime())) {
            Long startTime = Long.parseLong(jnpfField.startTime());
            flag = parse.after(new Date(startTime));
        }
        if (flag && StringUtil.isNotEmpty((String)jnpfField.endTime())) {
            Long endTime = Long.parseLong(jnpfField.endTime());
            flag = parse.before(new Date(endTime));
        }
        return flag;
    }

    private List<String> checkOptionsControl(boolean multiple, Map<String, Object> insMap, String vModel, String label, Map<String, Object> cacheMap, List<String> valueList, StringJoiner errInfo) {
        boolean error = false;
        if (!multiple && valueList.size() > 1) {
            error = true;
            errInfo.add(label + "\u975e\u591a\u9009");
        }
        ArrayList<String> dataList = new ArrayList<String>();
        if (!error) {
            boolean errorHapen = false;
            for (String va : valueList) {
                Object vo = cacheMap.get(va);
                if (vo == null) {
                    errorHapen = true;
                    continue;
                }
                dataList.add(vo.toString());
            }
            if (errorHapen) {
                errInfo.add(label + "\u503c\u4e0d\u6b63\u786e");
            } else {
                insMap.put(vModel, !multiple ? dataList.get(0) : JsonUtil.getObjectToString(dataList));
            }
        }
        return dataList;
    }

    public static void getOptions(String label, String value, String Children, JSONArray data, List<Map<String, Object>> options) {
        for (int i = 0; i < data.size(); ++i) {
            JSONObject ob = data.getJSONObject(i);
            HashMap<String, String> tree = new HashMap<String, String>(16);
            tree.put(value, String.valueOf(ob.get((Object)value)));
            tree.put(label, String.valueOf(ob.get((Object)label)));
            options.add(tree);
            if (ob.get((Object)Children) == null) continue;
            JSONArray childrenArray = ob.getJSONArray(Children);
            GeneraterSwapUtil.getOptions(label, value, Children, childrenArray, options);
        }
    }

    public List<String> usersSelectQuery(String value) {
        ArrayList<String> userSList = new ArrayList<String>();
        String userValue = value.substring(0, value.indexOf("--"));
        UserEntity userEntity = this.userService.getInfo(userValue);
        if (userEntity != null) {
            List groupRel = Optional.ofNullable(this.userRelationService.getListByObjectType(userValue, "Group")).orElse(new ArrayList());
            List orgRel = Optional.ofNullable(this.userRelationService.getListByObjectType(userValue, "Organize")).orElse(new ArrayList());
            List posRel = Optional.ofNullable(this.userRelationService.getListByObjectType(userValue, "Position")).orElse(new ArrayList());
            List roleRel = Optional.ofNullable(this.userRelationService.getListByObjectType(userValue, "Role")).orElse(new ArrayList());
            if (groupRel.size() > 0) {
                for (Object split : groupRel) {
                    userSList.add(split.getObjectId());
                }
            }
            if (StringUtil.isNotEmpty((String)userEntity.getOrganizeId())) {
                ArrayList allUpOrgIDs = new ArrayList();
                this.organizeService.upWardRecursion(allUpOrgIDs, userEntity.getOrganizeId());
                for (String orgID : allUpOrgIDs) {
                    userSList.add(orgID);
                }
            }
            if (posRel.size() > 0) {
                for (Object split : posRel) {
                    userSList.add(split.getObjectId());
                }
            }
            if (roleRel.size() > 0) {
                for (Object split : roleRel) {
                    userSList.add(split.getObjectId());
                }
            }
            return userSList;
        }
        return null;
    }

    public List<String> usersSelectQuery(List<String> values) {
        ArrayList<String> userSList = new ArrayList<String>();
        for (String value : values) {
            String userValue = value.substring(0, value.indexOf("--"));
            UserEntity userEntity = this.userService.getInfo(userValue);
            if (userEntity == null) continue;
            List groupRel = Optional.ofNullable(this.userRelationService.getListByObjectType(userValue, "Group")).orElse(new ArrayList());
            List orgRel = Optional.ofNullable(this.userRelationService.getListByObjectType(userValue, "Organize")).orElse(new ArrayList());
            List posRel = Optional.ofNullable(this.userRelationService.getListByObjectType(userValue, "Position")).orElse(new ArrayList());
            List roleRel = Optional.ofNullable(this.userRelationService.getListByObjectType(userValue, "Role")).orElse(new ArrayList());
            if (groupRel.size() > 0) {
                for (Object split : groupRel) {
                    userSList.add(split.getObjectId());
                }
            }
            if (StringUtil.isNotEmpty((String)userEntity.getOrganizeId())) {
                Object split;
                ArrayList allUpOrgIDs = new ArrayList();
                this.organizeService.upWardRecursion(allUpOrgIDs, userEntity.getOrganizeId());
                split = allUpOrgIDs.iterator();
                while (split.hasNext()) {
                    String orgID = (String)split.next();
                    userSList.add(orgID);
                }
            }
            if (posRel.size() > 0) {
                for (Object split : posRel) {
                    userSList.add(split.getObjectId());
                }
            }
            if (roleRel.size() <= 0) continue;
            for (Object split : roleRel) {
                userSList.add(split.getObjectId());
            }
        }
        return userSList;
    }

    @DS(value="")
    public List<RuleInfo> getFilterCondition(String id) {
        return this.filterService.getCondition(id);
    }

    public static List convertToList(Object obj) {
        return OnlineSwapDataUtils.convertToList((Object)obj);
    }

    public static String convertValueToString(String obj, boolean mult, boolean isOrg) {
        return OnlineSwapDataUtils.convertValueToString((String)obj, (boolean)mult, (boolean)isOrg);
    }

    public DbLinkEntity getDataSource(String dbLink) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DbLinkEntity::getFullName, (Object)dbLink);
        return (DbLinkEntity)this.dblinkService.getOne((Wrapper)queryWrapper);
    }

    public static String selectStaitcSwap(String param, String options, String key, String label, boolean multiple) {
        ArrayList<String> textList = new ArrayList<String>();
        List optionsList = JsonUtil.getJsonToList((String)options, Map.class);
        if (multiple) {
            List jsonToList = JsonUtil.getJsonToList((String)param, String.class);
            for (String list1 : jsonToList) {
                if (list1.contains("[")) {
                    ArrayList<String> textList2 = new ArrayList<String>();
                    List jsonToList2 = JsonUtil.getJsonToList((String)list1, String.class);
                    for (String str : jsonToList2) {
                        textList2.add(GeneraterSwapUtil.loop(optionsList, str, key, label));
                    }
                    textList.add(String.join((CharSequence)"/", textList2));
                    continue;
                }
                textList.add(GeneraterSwapUtil.loop(optionsList, list1, key, label));
            }
        } else if (param.contains("[")) {
            ArrayList<String> textList2 = new ArrayList<String>();
            List jsonToList = JsonUtil.getJsonToList((String)param, String.class);
            for (String str : jsonToList) {
                textList2.add(GeneraterSwapUtil.loop(optionsList, str, key, label));
            }
            textList.add(String.join((CharSequence)"/", textList2));
        } else {
            textList.add(GeneraterSwapUtil.loop(optionsList, param, key, label));
        }
        return String.join((CharSequence)",", textList);
    }

    public static String loop(List<Map> options, String oneData, String key, String label) {
        for (int i = 0; i < options.size(); ++i) {
            List children;
            String loop;
            if (options.get(i).get(key).equals(oneData)) {
                return options.get(i).get(label).toString();
            }
            if (options.get(i).get("children") == null || (loop = GeneraterSwapUtil.loop(children = JsonUtil.getJsonToList(options.get(i).get("children"), Map.class), oneData, key, label)) == null) continue;
            return loop;
        }
        return null;
    }

    public String getFlowTempJsonId(String formId) throws WorkFlowException {
        String flowTemjsonId = "";
        return flowTemjsonId;
    }

    public static void swapDatetime(Object form) {
        Field[] declaredFields;
        for (Field f : declaredFields = form.getClass().getDeclaredFields()) {
            try {
                JnpfField annotation;
                if (f.getType().getName().startsWith("jnpf.model")) {
                    Object o;
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    if ((o = f.get(form)) == null) continue;
                    GeneraterSwapUtil.swapDatetime(o);
                    f.set(form, o);
                    continue;
                }
                if (List.class.isAssignableFrom(f.getType())) {
                    Type type = f.getGenericType();
                    if (!(type instanceof ParameterizedType)) continue;
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    List list = GeneraterSwapUtil.getList(f, f.get(form));
                    for (Object o : list) {
                        GeneraterSwapUtil.swapDatetime(o);
                    }
                    if (list.size() <= 0) continue;
                    f.set(form, list);
                    continue;
                }
                if (f.getAnnotation(JnpfField.class) == null || !"date".equals((annotation = f.getAnnotation(JnpfField.class)).jnpfKey()) || StringUtil.isEmpty((String)annotation.format())) continue;
                String format = annotation.format();
                f.setAccessible(true);
                if (f.get(form) == null || Long.parseLong(String.valueOf(f.get(form))) <= 0L) continue;
                Date date = new Date(Long.parseLong(String.valueOf(f.get(form))));
                String completionStr = "";
                switch (format) {
                    case "yyyy": {
                        completionStr = "-01-01 00:00:00";
                        break;
                    }
                    case "yyyy-MM": {
                        completionStr = "-01 00:00:00";
                        break;
                    }
                    case "yyyy-MM-dd": {
                        completionStr = " 00:00:00";
                        break;
                    }
                    case "yyyy-MM-dd HH": {
                        completionStr = ":00:00";
                        break;
                    }
                    case "yyyy-MM-dd HH:mm": {
                        completionStr = ":00";
                        break;
                    }
                }
                String datestr = DateUtil.dateToString((Date)date, (String)format);
                long time = DateUtil.stringToDate((String)(datestr + completionStr)).getTime();
                f.set(form, String.valueOf(time));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static List getList(Field field, Object object) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        if (object != null) {
            try {
                Class<?> clzz = object.getClass();
                Method sizeMethod = clzz.getDeclaredMethod("size", new Class[0]);
                if (!sizeMethod.isAccessible()) {
                    sizeMethod.setAccessible(true);
                }
                int size = (Integer)sizeMethod.invoke(object, new Object[0]);
                for (int i = 0; i < size; ++i) {
                    Method getMethod = clzz.getDeclaredMethod("get", Integer.TYPE);
                    if (!getMethod.isAccessible()) {
                        getMethod.setAccessible(true);
                    }
                    Object invoke = getMethod.invoke(object, i);
                    resultList.add(invoke);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    public static String getDecimalStr(Object decimalValue) {
        if (Objects.isNull(decimalValue)) {
            return "";
        }
        if (decimalValue instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)decimalValue;
            return bd.toPlainString();
        }
        return String.valueOf(decimalValue);
    }

    public String getCurrentOrgIds(String orgId, String showLevel) {
        return this.flowFormDataUtil.getCurrentOrgIds(orgId, showLevel);
    }

    public String getCurrentOrganizeName(Object value, String showLevel) {
        return this.flowFormDataUtil.getCurrentOrganizeName(value, showLevel);
    }

    public static Map<String, Object> getMastTabelData(Object data, String tableName) {
        Map map = JsonUtil.entityToMap((Object)data);
        HashMap<String, Object> mapRes = new HashMap<String, Object>();
        for (String key : map.keySet()) {
            String[] jnpf_s = key.split("_jnpf_");
            if (jnpf_s.length != 2 || !jnpf_s[0].contains(tableName)) continue;
            mapRes.put(jnpf_s[1], map.get(key));
        }
        return mapRes;
    }

    public List<Map<String, Object>> swapDataList(List<Map<String, Object>> realList, String formDataStr, String columnDataStr, String moduleId, boolean inlineEdit) {
        FormDataModel formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)formDataStr, FormDataModel.class);
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)columnDataStr, ColumnDataModel.class);
        List fieLdsModels = JsonUtil.getJsonToList((String)formDataModel.getFields(), FieLdsModel.class);
        ArrayList fields = new ArrayList();
        VisualUtils.recursionFields((List)fieLdsModels, fields);
        if (OnlineDevData.COLUMNTYPE_FIVE.equals(columnDataModel.getType())) {
            realList.forEach(item -> item.put(columnDataModel.getParentField() + "_id", item.get(columnDataModel.getParentField())));
        }
        realList = this.swapDataUtils.getSwapList(realList, fields, moduleId, Boolean.valueOf(inlineEdit));
        return realList;
    }

    @DS(value="")
    public void getFlowStatus(List<Map<String, Object>> realList) throws WorkFlowException {
        this.swapDataUtils.getFlowStatus(realList);
    }

    public List<Map<String, Object>> swapDataList(List<Map<String, Object>> realList, String columnDataStr, String subField) {
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)columnDataStr, ColumnDataModel.class);
        if (OnlineDevData.COLUMNTYPE_THREE.equals(columnDataModel.getType())) {
            realList = OnlineDevListUtils.groupData(realList, (ColumnDataModel)columnDataModel);
        }
        if (OnlineDevData.COLUMNTYPE_FIVE.equals(columnDataModel.getType())) {
            columnDataModel.setSubField(subField);
            realList = OnlineDevListUtils.treeListData((List)realList, (ColumnDataModel)columnDataModel);
        }
        return realList;
    }

    public Map<String, Object> swapDataForm(Map<String, Object> dataMap, String formDataStr, Map<String, String> tableField, Map<String, String> tableRename) {
        FormDataModel formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)formDataStr, FormDataModel.class);
        List fieLdsModels = JsonUtil.getJsonToList((String)formDataModel.getFields(), FieLdsModel.class);
        ArrayList<FieLdsModel> fields = new ArrayList<FieLdsModel>();
        VisualUtils.recursionFields((List)fieLdsModels, fields);
        this.swapDataUtils.getFLowFields(dataMap);
        return this.swapDataForm(dataMap, fields, null, tableField, tableRename);
    }

    private Map<String, Object> swapDataForm(Map<String, Object> dataMap, List<FieLdsModel> fields, Map<String, Object> mainMap, Map<String, String> tableField, Map<String, String> tableRename) {
        if (dataMap == null || dataMap.isEmpty()) {
            return new HashMap<String, Object>();
        }
        block31: for (FieLdsModel item : fields) {
            Object vModel;
            String jnpfKey;
            block40: {
                ArrayList nullIsList;
                ArrayList systemConditions;
                block38: {
                    ArrayList multOne;
                    ArrayList multTow;
                    Boolean isMultiple;
                    block39: {
                        jnpfKey = item.getConfig().getJnpfKey();
                        vModel = item.getVModel();
                        String dataType = item.getConfig().getDataType();
                        isMultiple = Objects.nonNull(item.getMultiple()) ? item.getMultiple() : false;
                        FormPublicUtils.relationGetJnpfId(dataMap, (String)jnpfKey, (Object)dataMap.get(vModel), (String)vModel);
                        systemConditions = new ArrayList(){
                            {
                                this.add("currOrganize");
                                this.add("currDept");
                                this.add("currPosition");
                            }
                        };
                        multTow = new ArrayList(){
                            {
                                this.add("cascader");
                                this.add("checkbox");
                                this.add("areaSelect");
                                this.add("organizeSelect");
                            }
                        };
                        multOne = new ArrayList(){
                            {
                                this.add("checkbox");
                            }
                        };
                        nullIsList = new ArrayList(){
                            {
                                this.add("uploadFile");
                                this.add("uploadImg");
                            }
                        };
                        if (!Objects.nonNull(dataMap.get(vModel))) break block38;
                        if (!multTow.contains(jnpfKey) || !isMultiple.booleanValue()) break block39;
                        dataMap.replace((String)vModel, JSONObject.parseArray((String)dataMap.get(vModel).toString(), List.class));
                        break block40;
                    }
                    if (!multTow.contains(jnpfKey) && !isMultiple.booleanValue() && !multOne.contains(jnpfKey)) break block40;
                    dataMap.replace((String)vModel, JSONObject.parseArray((String)dataMap.get(vModel).toString(), String.class));
                    break block40;
                }
                if (!"table".equals(jnpfKey)) {
                    if (systemConditions.contains(jnpfKey)) {
                        dataMap.put((String)vModel, " ");
                    }
                    if (!nullIsList.contains(jnpfKey)) continue;
                    dataMap.put((String)vModel, Collections.emptyList());
                    continue;
                }
            }
            switch (jnpfKey) {
                case "rate": 
                case "slider": {
                    BigDecimal value = new BigDecimal(0);
                    if (dataMap.get(vModel) != null) {
                        value = new BigDecimal(dataMap.get(vModel).toString());
                    }
                    dataMap.put((String)vModel, value);
                    break;
                }
                case "switch": {
                    dataMap.put((String)vModel, dataMap.get(vModel) != null ? Integer.valueOf(Integer.parseInt(String.valueOf(dataMap.get(vModel)))) : null);
                    break;
                }
                case "datePicker": {
                    Long dateTime = DateTimeFormatConstant.getDateObjToLong((Object)dataMap.get(vModel));
                    dataMap.put((String)vModel, dateTime != null ? dateTime : dataMap.get(vModel));
                    break;
                }
                case "currOrganize": 
                case "currDept": {
                    dataMap.put((String)vModel, this.getCurrentOrganizeName(dataMap.get(vModel), item.getShowLevel()));
                    break;
                }
                case "createUser": 
                case "modifyUser": {
                    UserEntity userEntity = this.userService.getInfo(String.valueOf(dataMap.get(vModel)));
                    String userValue = Objects.nonNull(userEntity) ? (userEntity.getAccount().equalsIgnoreCase("admin") ? "\u7ba1\u7406\u5458/admin" : userEntity.getRealName() + "/" + userEntity.getAccount()) : String.valueOf(dataMap.get(vModel));
                    dataMap.put((String)vModel, userValue);
                    break;
                }
                case "currPosition": {
                    PositionEntity positionEntity = this.positionService.getInfo(String.valueOf(dataMap.get(vModel)));
                    dataMap.put((String)vModel, Objects.nonNull(positionEntity) ? positionEntity.getFullName() : " ");
                    break;
                }
                case "createTime": 
                case "modifyTime": {
                    if (!ObjectUtil.isNotEmpty((Object)dataMap.get(vModel))) continue block31;
                    Long dateLong = Long.parseLong(String.valueOf(dataMap.get(vModel)));
                    String dateStr = DateUtil.dateFormat((Date)new Date(dateLong));
                    dataMap.put((String)vModel, dateStr);
                    break;
                }
                case "uploadFile": 
                case "uploadImg": {
                    if (!ObjectUtil.isNotEmpty((Object)dataMap.get(vModel))) continue block31;
                    List fileList = new ArrayList();
                    try {
                        fileList = JsonUtil.getJsonToListMap((String)dataMap.get(vModel).toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    dataMap.put((String)vModel, fileList);
                    break;
                }
                case "table": {
                    List childList;
                    List childrens = item.getConfig().getChildren();
                    String childTableRename = "";
                    try {
                        childTableRename = tableRename.get(tableField.get(vModel));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (StringUtil.isNotEmpty((String)childTableRename)) {
                        vModel = childTableRename + "List";
                    }
                    if (CollectionUtils.isEmpty((Collection)(childList = (List)dataMap.get(vModel = DataControlUtils.initialLowercase((String)vModel))))) break;
                    for (int i = 0; i < childList.size(); ++i) {
                        Map childMap = (Map)childList.get(i);
                        childList.set(i, this.swapDataForm(childMap, childrens, dataMap, tableField, tableRename));
                    }
                    dataMap.put((String)vModel, childList);
                    break;
                }
                default: {
                    dataMap.put((String)vModel, dataMap.get(vModel));
                }
            }
        }
        return dataMap;
    }

    public Map<String, Object> swapDataDetail(Map<String, Object> map, String formDataStr, String moduleId, boolean inlineEdit) {
        FormDataModel formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)formDataStr, FormDataModel.class);
        List fieLdsModels = JsonUtil.getJsonToList((String)formDataModel.getFields(), FieLdsModel.class);
        ArrayList fields = new ArrayList();
        VisualUtils.recursionFields((List)fieLdsModels, fields);
        if (map != null) {
            final Map finalMap = map;
            List realList = new ArrayList(){
                {
                    this.add(finalMap);
                }
            };
            realList = this.swapDataUtils.getSwapInfo(realList, fields, moduleId, Boolean.valueOf(inlineEdit), null);
            map = (Map)realList.get(0);
        }
        return map;
    }

    public ExcelImportModel importData(String formData, List<Map<String, Object>> dataList, ImportFormCheckUniqueModel uniqueModel, Map<String, String> table, String tableListStr) throws WorkFlowException {
        ExcelImportModel importModel = new ExcelImportModel();
        Map localCache = this.swapDataUtils.getlocalCache();
        ArrayList<HashMap<String, Object>> failResult = new ArrayList<HashMap<String, Object>>();
        FormDataModel formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)formData, FormDataModel.class);
        List fieLdsModels = JsonUtil.getJsonToList((String)formDataModel.getFields(), FieLdsModel.class);
        ArrayList fields = new ArrayList();
        VisualUtils.recursionFields((List)fieLdsModels, fields);
        uniqueModel.setMain(true);
        uniqueModel.setPrimaryKeyPolicy(formDataModel.getPrimaryKeyPolicy());
        uniqueModel.setLogicalDelete(formDataModel.getLogicalDelete());
        uniqueModel.setMain(true);
        uniqueModel.setTableModelList(JsonUtil.getJsonToList((String)tableListStr, TableModel.class));
        String mainFlowID = null;
        if (StringUtil.isNotEmpty((String)uniqueModel.getFlowId())) {
            mainFlowID = uniqueModel.getFlowId();
            List<String> flowIds = this.getFlowIds(uniqueModel.getFlowId());
            uniqueModel.setFlowIdList(flowIds);
        }
        try {
            int len = dataList.size();
            for (int i = 0; i < len; ++i) {
                Map<String, Object> data = dataList.get(i);
                data.put("flowId", mainFlowID);
                data.put(TableFeildsEnum.FLOWID.getField(), mainFlowID);
                HashMap<String, Object> resultMap = new HashMap<String, Object>(data);
                StringJoiner errInfo = new StringJoiner(",");
                HashMap<String, Object> errorMap = new HashMap<String, Object>(data);
                List errList = this.swapDataUtils.checkExcelData(fields, data, localCache, resultMap, errorMap, uniqueModel);
                VisualErrInfo visualErrInfo = this.formCheckUtils.checkBusinessKey(fields, resultMap, uniqueModel.getTableModelList(), formDataModel, null);
                if (uniqueModel.isUpdate()) {
                    if (ObjectUtil.isNotEmpty((Object)visualErrInfo) && StringUtil.isNotEmpty((String)visualErrInfo.getId())) {
                        uniqueModel.setId(visualErrInfo.getId());
                        if (StringUtil.isNotEmpty((String)visualErrInfo.getFlowTaskId())) {
                            String finalTaskId = visualErrInfo.getFlowTaskId();
                            ArrayList<String> flowIdList = new ArrayList<String>();
                            flowIdList.add(finalTaskId);
                            List tasks = this.taskApi.getInfosSubmit(flowIdList.toArray(new String[0]), new SFunction[]{TaskEntity::getStatus, SuperBaseEntity.SuperIBaseEntity::getId});
                            if (tasks.size() > 0) {
                                boolean errorMsg = tasks.stream().filter(t -> Objects.equals(t.getStatus(), 0)).count() == 0L;
                                String msg = "\u5df2\u53d1\u8d77\u6d41\u7a0b\uff0c\u5bfc\u5165\u5931\u8d25";
                                if (errorMsg) {
                                    errorMap.put("errorsInfo", msg);
                                    failResult.add(errorMap);
                                    continue;
                                }
                            }
                        }
                    } else {
                        excelHas = this.formCheckUtils.checkBusinessKeyExcel(formDataModel, resultMap, uniqueModel);
                        if (StringUtil.isNotEmpty((String)excelHas)) {
                            continue;
                        }
                    }
                } else {
                    if (ObjectUtil.isNotEmpty((Object)visualErrInfo) && StringUtil.isNotEmpty((String)visualErrInfo.getErrMsg())) {
                        errorMap.put("errorsInfo", visualErrInfo.getErrMsg());
                        failResult.add(errorMap);
                        continue;
                    }
                    excelHas = this.formCheckUtils.checkBusinessKeyExcel(formDataModel, resultMap, uniqueModel);
                    if (StringUtil.isNotEmpty((String)excelHas)) {
                        errorMap.put("errorsInfo", excelHas);
                        failResult.add(errorMap);
                        continue;
                    }
                }
                this.swapDataUtils.checkUnique(fields, data, errList, uniqueModel);
                errList.stream().forEach(t -> {
                    if (StringUtil.isNotEmpty((String)t)) {
                        errInfo.add((CharSequence)t);
                    }
                });
                if (errInfo.length() > 0) {
                    errorMap.put("errorsInfo", errInfo.toString());
                    failResult.add(errorMap);
                    continue;
                }
                List importDataModel = uniqueModel.getImportDataModel();
                ImportDataModel model = new ImportDataModel();
                model.setId(uniqueModel.getId());
                HashMap map = new HashMap(16);
                HashMap tableMap = new HashMap(16);
                for (Object key : resultMap.keySet().toArray()) {
                    if (table.get(key) == null) continue;
                    tableMap.put((CallSite)((Object)(table.get(key) + "List")), resultMap.remove(key));
                }
                resultMap.putAll(map);
                resultMap.putAll(tableMap);
                model.setResultData(resultMap);
                importDataModel.add(model);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkFlowException("\u5bfc\u5165\u5f02\u5e38\uff01");
        }
        importModel.setFnum(failResult.size());
        importModel.setSnum(dataList.size() - failResult.size());
        importModel.setResultType(failResult.size() > 0 ? 1 : 0);
        importModel.setFailResult(failResult);
        return importModel;
    }

    public List<RuleInfo> getFilterRules(String columnStr, String appColumnStr) {
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)columnStr, ColumnDataModel.class);
        ColumnDataModel appColumnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)appColumnStr, ColumnDataModel.class);
        List ruleList = JsonUtil.getJsonToList((Object)columnDataModel.getRuleList().getConditionList(), Map.class);
        List appRuleList = JsonUtil.getJsonToList((Object)appColumnDataModel.getRuleList().getConditionList(), Map.class);
        boolean isPc = RequestContext.isOrignPc();
        List res = JsonUtil.getJsonToList((Object)ruleList, RuleInfo.class);
        if (!isPc) {
            res = JsonUtil.getJsonToList((Object)appRuleList, RuleInfo.class);
        }
        return res;
    }

    public QueryWrapper wrapperHandle(String columnStr, String appColumnStr, QueryWrapper<?> wrapper, Class<?> aClass, String type, String tableName) {
        try {
            wrapper.apply(" 1=1 ", new Object[0]);
            List<RuleInfo> ruleInfos = this.getFilterRules(columnStr, appColumnStr);
            for (RuleInfo info : ruleInfos) {
                String field = info.getField();
                if ("main".equals(type) && field.contains("-") || "main".equals(type) && field.contains("_jnpf_") || "sub".equals(type) && !field.contains("-") || "sub-jnpf".equals(type) && !field.contains("_jnpf_")) continue;
                String fieldName = field;
                String table = "";
                if (field.contains("-")) {
                    fieldName = field.split("-")[1];
                    if (!tableName.equals(field.split("-")[0])) continue;
                }
                if (field.contains("_jnpf_")) {
                    fieldName = field.split("_jnpf_")[1];
                    table = field.split("_jnpf_")[0];
                    table = table.replace("jnpf_", "");
                }
                if ("sub-jnpf".equals(type) && !tableName.equals(table)) continue;
                Field declaredField = aClass.getDeclaredField(fieldName);
                declaredField.setAccessible(true);
                String fieldDb = declaredField.getAnnotation(TableField.class).value();
                GenUtil genUtil = (GenUtil)JsonUtil.getJsonToBean((Object)info, GenUtil.class);
                genUtil.setOperator(info.getOperator());
                genUtil.solveValue(wrapper, fieldDb);
            }
            return wrapper;
        }
        catch (Exception e) {
            return wrapper;
        }
    }

    public boolean onlyMainFilter(String columnStr, String appColumnStr) {
        List<RuleInfo> ruleInfos = this.getFilterRules(columnStr, appColumnStr);
        for (RuleInfo info : ruleInfos) {
            if (!info.getField().contains("_jnpf_") && !info.getField().contains("-")) continue;
            return false;
        }
        return true;
    }

    public static String swapDatetime(String formDataStr, Object obj, Map<String, String> tableRename) {
        String reName;
        FormDataModel formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)formDataStr, FormDataModel.class);
        List fieLdsModels = JsonUtil.getJsonToList((String)formDataModel.getFields(), FieLdsModel.class);
        Map map = JsonUtil.entityToMap((Object)obj);
        for (String tabelRealName : tableRename.keySet()) {
            reName = DataControlUtils.initialLowercase((String)tableRename.get(tabelRealName));
            map.put(tabelRealName + "List", map.get(reName + "List"));
        }
        OnlineSwapDataUtils.swapDatetime((List)fieLdsModels, (Map)map);
        for (String tabelRealName : tableRename.keySet()) {
            if (map.get(tabelRealName + "List") == null) continue;
            reName = DataControlUtils.initialLowercase((String)tableRename.get(tabelRealName));
            JSONArray listToJsonArray = JsonUtil.getListToJsonArray((List)((List)map.get(tabelRealName + "List")));
            map.replace(reName + "List", listToJsonArray);
        }
        return JsonUtil.getObjectToString((Object)map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DS(value="")
    public MPJLambdaWrapper getConditionAllTable(QueryAllModel queryAllModel) {
        String ruleQuery;
        UserInfo userInfo = UserProvider.getUser();
        try {
            DbLinkEntity linkEntity = queryAllModel.getDbLink() != null ? this.getDataSource(queryAllModel.getDbLink()) : null;
            DynamicDataSourceUtil.switchToDataSource((DbLinkEntity)linkEntity);
            Connection connection = ConnUtil.getConnOrDefault((DbSourceOrDbLink)linkEntity);
            try {
                queryAllModel.setDbType(connection.getMetaData().getDatabaseProductName().trim());
            }
            finally {
                if (Collections.singletonList(connection).get(0) != null) {
                    connection.close();
                }
            }
        }
        catch (Exception linkEntity) {
        }
        finally {
            DynamicDataSourceUtil.clearSwitchDataSource();
        }
        Map systemParam = OnlineProductSqlUtils.getSystemParam();
        MPJLambdaWrapper wrapper = queryAllModel.getWrapper();
        ArrayList<List<SuperJsonModel>> superList = new ArrayList<List<SuperJsonModel>>();
        String superQuery = queryAllModel.getSuperJson();
        if (StringUtil.isNotEmpty((String)superQuery)) {
            ArrayList<SuperJsonModel> list = new ArrayList<SuperJsonModel>();
            SuperJsonModel jsonToBean = (SuperJsonModel)JsonUtil.getJsonToBean((String)queryAllModel.getSuperJson(), SuperJsonModel.class);
            list.add(jsonToBean);
            superList.add(list);
        }
        if (StringUtil.isNotEmpty((String)(ruleQuery = queryAllModel.getRuleJson()))) {
            ArrayList<SuperJsonModel> list = new ArrayList<SuperJsonModel>();
            SuperJsonModel superJsonModel = (SuperJsonModel)JsonUtil.getJsonToBean((String)queryAllModel.getRuleJson(), SuperJsonModel.class);
            list.add(superJsonModel);
            superList.add(list);
        }
        if (queryAllModel.getModuleId() != null && !userInfo.getIsAdministrator().booleanValue() && !this.authorizeService.getUserCurrentStanding(userInfo.getUserId(), Integer.valueOf(2))) {
            List authorizeListAll = this.authorizeService.getConditionSql(queryAllModel.getModuleId());
            if (authorizeListAll.size() > 0) {
                superList.add(authorizeListAll);
            } else {
                return null;
            }
        }
        for (List list : superList) {
            for (SuperJsonModel superJsonModel : list) {
                for (SuperQueryJsonModel superQueryJsonModel : superJsonModel.getConditionList()) {
                    for (FieLdsModel fieLdsModel : superQueryJsonModel.getGroups()) {
                        OnlineProductSqlUtils.replaceSystemParam((Map)systemParam, (FieLdsModel)fieLdsModel);
                    }
                }
            }
        }
        QueryUtil queryUtil = new QueryUtil();
        queryAllModel.setQueryList(superList);
        queryUtil.queryList(queryAllModel);
        return wrapper;
    }

    @DS(value="")
    public PageListVO getInterfaceData(String interfaceId, String interfaceParam, Object pagination, String columnData, boolean isPc) {
        VisualdevReleaseEntity visualdevEntity = new VisualdevReleaseEntity();
        visualdevEntity.setInterfaceId(interfaceId);
        visualdevEntity.setInterfaceParam(interfaceParam);
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)columnData, ColumnDataModel.class);
        PaginationModelExport jsonToBean = (PaginationModelExport)JsonUtil.getJsonToBean((Object)pagination, PaginationModelExport.class);
        jsonToBean.setQueryJson(JsonUtil.getObjectToString((Object)pagination));
        List<Map<String, Object>> interfaceData = this.swapDataUtils.getInterfaceData(visualdevEntity, (PaginationModel)jsonToBean, columnDataModel);
        if (isPc && columnDataModel.getType() == 3) {
            interfaceData = this.swapDataList(interfaceData, columnData, null);
        }
        PageListVO vo = new PageListVO();
        vo.setList((List)interfaceData);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)jsonToBean, PaginationVO.class);
        vo.setPagination(page);
        return vo;
    }

    @DS(value="")
    public DownloadVO exportInterfaceData(String interfaceId, String interfaceParam, Object pagination, String columnData) {
        VisualdevReleaseEntity visualdevEntity = new VisualdevReleaseEntity();
        visualdevEntity.setInterfaceId(interfaceId);
        visualdevEntity.setInterfaceParam(interfaceParam);
        ColumnDataModel columnDataModel = (ColumnDataModel)JsonUtil.getJsonToBean((String)columnData, ColumnDataModel.class);
        PaginationModelExport jsonToBean = (PaginationModelExport)JsonUtil.getJsonToBean((Object)pagination, PaginationModelExport.class);
        jsonToBean.setQueryJson(JsonUtil.getObjectToString((Object)pagination));
        List realList = this.swapDataUtils.getInterfaceData(visualdevEntity, (PaginationModel)jsonToBean, columnDataModel);
        ModuleEntity menuInfo = this.moduleService.getInfo(jsonToBean.getMenuId());
        String[] keys = jsonToBean.getSelectKey();
        List<Object> selectIds = Arrays.asList(jsonToBean.getSelectIds());
        realList = "2".equals(jsonToBean.getDataType()) ? realList.stream().filter(t -> selectIds.contains(t.get(columnDataModel.getViewKey()))).collect(Collectors.toList()) : realList;
        DownloadVO vo = VisualUtils.createModelExcelApiData((String)columnData, realList, Arrays.asList(keys), (String)"\u8868\u5355\u4fe1\u606f", (String)menuInfo.getFullName(), (ExcelModel)new ExcelModel());
        return vo;
    }

    @DS(value="")
    public String getMenuName(String menuId) {
        ModuleEntity menuInfo;
        String name = "";
        if (StringUtil.isNotEmpty((String)menuId) && (menuInfo = this.moduleService.getInfo(menuId)) != null && StringUtil.isNotEmpty((String)menuInfo.getFullName())) {
            name = menuInfo.getFullName();
        }
        return name;
    }

    @DS(value="")
    public ExcelModel getExcelParams(String formJson, List<String> selectKey) {
        return this.swapDataUtils.getDefaultValue(formJson, selectKey);
    }

    @DS(value="")
    public List<String> getFlowIds(String templateId) {
        ArrayList<String> flowIds = new ArrayList<String>();
        if (StringUtil.isNotEmpty((String)templateId)) {
            flowIds.addAll(this.templateApi.getFlowIdsByTemplateId(templateId));
            if (CollectionUtils.isNotEmpty(flowIds)) {
                return flowIds;
            }
            String templateByVersionId = this.templateApi.getTemplateByVersionId(templateId);
            if (StringUtil.isNotEmpty((String)templateByVersionId)) {
                flowIds.addAll(this.templateApi.getFlowIdsByTemplateId(templateByVersionId));
            }
        }
        if (CollectionUtils.isEmpty(flowIds)) {
            flowIds.add("noFlowVer");
        }
        return flowIds;
    }

    @DS(value="")
    public String deleteFlowTask(String flowTaskId) {
        String errMsg = "";
        TaskEntity taskEntity = this.taskApi.getInfoSubmit(flowTaskId, new SFunction[]{SuperBaseEntity.SuperIBaseEntity::getId, TaskEntity::getParentId, TaskEntity::getFullName, TaskEntity::getStatus});
        if (taskEntity != null) {
            try {
                this.taskApi.delete(taskEntity);
            }
            catch (Exception e) {
                errMsg = e.getMessage();
            }
        }
        return errMsg;
    }
}

