/*
 * Decompiled with CFR 0.152.
 */
package jnpf.util;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jnpf.util.JsonUtil;
import org.apache.commons.lang3.StringUtils;

public class GenUtil {
    private String fieldName;
    private String operator;
    private String logic;
    private String jnpfKey;
    private String field;
    private String fieldValue;
    private String fieldValue2;
    private List<String> selectIgnore;
    private String dbType;
    private String format;
    private String precision;

    public QueryWrapper<?> solveValue(QueryWrapper<?> wrapper, String fieldDb) {
        MyType myType = this.myControl(this.jnpfKey);
        if ("||".equals(this.logic)) {
            wrapper.or();
        }
        if (this.fieldValue == null) {
            this.fieldValue = "";
        }
        try {
            ArrayList<String> splitKey = new ArrayList<String>(){
                {
                    this.add("datePicker");
                    this.add("timePicker");
                    this.add("inputNumber");
                    this.add("createTime");
                    this.add("modifyTime");
                }
            };
            if (splitKey.contains(this.jnpfKey) && "between".equals(this.operator)) {
                List data = JsonUtil.getJsonToList((String)this.fieldValue, String.class);
                this.fieldValue = (String)data.get(0);
                this.fieldValue2 = (String)data.get(1);
            }
            this.selectIgnore = new ArrayList<String>(){
                {
                    this.add("organizeSelect");
                    this.add("areaSelect");
                    this.add("cascader");
                    this.add("checkbox");
                    this.add("depSelect");
                }
            };
            myType.judge(wrapper, fieldDb);
            return wrapper;
        }
        catch (Exception e) {
            return wrapper;
        }
    }

    public MyType myControl(String jnpfKey) {
        MyType myType = null;
        switch (jnpfKey) {
            case "input": 
            case "textarea": 
            case "billRule": 
            case "popupTableSelect": 
            case "relationForm": 
            case "relationFormAttr": 
            case "popupSelect": 
            case "popupAttr": {
                myType = new BasicControl();
                break;
            }
            case "calculate": 
            case "inputNumber": {
                myType = new NumControl();
                break;
            }
            case "datePicker": 
            case "createTime": 
            case "modifyTime": {
                myType = new DateControl();
                break;
            }
            case "timePicker": {
                myType = new TimeControl();
                break;
            }
            default: {
                myType = new SelectControl();
            }
        }
        return myType;
    }

    public void getNullWrapper(QueryWrapper<?> wrapper, String fieldDb) {
        if ("||".equals(this.logic)) {
            wrapper.or(t -> {
                t.isNull((Object)fieldDb);
                ((QueryWrapper)t.or()).eq((Object)fieldDb, (Object)"");
                ((QueryWrapper)t.or()).eq((Object)fieldDb, (Object)"[]");
            });
        } else {
            wrapper.and(t -> {
                t.isNull((Object)fieldDb);
                ((QueryWrapper)t.or()).eq((Object)fieldDb, (Object)"");
                ((QueryWrapper)t.or()).eq((Object)fieldDb, (Object)"[]");
            });
        }
    }

    private void getNotNullWrapper(QueryWrapper<?> wrapper, String fieldDb) {
        if ("||".equals(this.logic)) {
            wrapper.or(t -> {
                t.isNotNull((Object)fieldDb);
                t.ne((Object)fieldDb, (Object)"");
                t.ne((Object)fieldDb, (Object)"[]");
            });
        } else {
            wrapper.and(t -> {
                t.isNotNull((Object)fieldDb);
                t.ne((Object)fieldDb, (Object)"");
                t.ne((Object)fieldDb, (Object)"[]");
            });
        }
    }

    private ArrayList<String> solveListValue(String fieldValue) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            List list = JsonUtil.getJsonToList((String)fieldValue, List.class);
            for (List listSub : list) {
                result.add(JSONArray.toJSONString((Object)listSub));
                String value = (String)listSub.get(listSub.size() - 1);
                result.add(value);
            }
        }
        catch (Exception e) {
            List list = JsonUtil.getJsonToList((String)fieldValue, String.class);
            result.add(JSONArray.toJSONString((Object)list));
            String value = (String)list.get(list.size() - 1);
            result.add(value);
        }
        return result;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getLogic() {
        return this.logic;
    }

    public String getJnpfKey() {
        return this.jnpfKey;
    }

    public String getField() {
        return this.field;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public String getFieldValue2() {
        return this.fieldValue2;
    }

    public List<String> getSelectIgnore() {
        return this.selectIgnore;
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getFormat() {
        return this.format;
    }

    public String getPrecision() {
        return this.precision;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setLogic(String logic) {
        this.logic = logic;
    }

    public void setJnpfKey(String jnpfKey) {
        this.jnpfKey = jnpfKey;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
    }

    public void setFieldValue2(String fieldValue2) {
        this.fieldValue2 = fieldValue2;
    }

    public void setSelectIgnore(List<String> selectIgnore) {
        this.selectIgnore = selectIgnore;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setPrecision(String precision) {
        this.precision = precision;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenUtil)) {
            return false;
        }
        GenUtil other = (GenUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        String this$operator = this.getOperator();
        String other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
            return false;
        }
        String this$logic = this.getLogic();
        String other$logic = other.getLogic();
        if (this$logic == null ? other$logic != null : !this$logic.equals(other$logic)) {
            return false;
        }
        String this$jnpfKey = this.getJnpfKey();
        String other$jnpfKey = other.getJnpfKey();
        if (this$jnpfKey == null ? other$jnpfKey != null : !this$jnpfKey.equals(other$jnpfKey)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$fieldValue = this.getFieldValue();
        String other$fieldValue = other.getFieldValue();
        if (this$fieldValue == null ? other$fieldValue != null : !this$fieldValue.equals(other$fieldValue)) {
            return false;
        }
        String this$fieldValue2 = this.getFieldValue2();
        String other$fieldValue2 = other.getFieldValue2();
        if (this$fieldValue2 == null ? other$fieldValue2 != null : !this$fieldValue2.equals(other$fieldValue2)) {
            return false;
        }
        List<String> this$selectIgnore = this.getSelectIgnore();
        List<String> other$selectIgnore = other.getSelectIgnore();
        if (this$selectIgnore == null ? other$selectIgnore != null : !((Object)this$selectIgnore).equals(other$selectIgnore)) {
            return false;
        }
        String this$dbType = this.getDbType();
        String other$dbType = other.getDbType();
        if (this$dbType == null ? other$dbType != null : !this$dbType.equals(other$dbType)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$precision = this.getPrecision();
        String other$precision = other.getPrecision();
        return !(this$precision == null ? other$precision != null : !this$precision.equals(other$precision));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        String $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
        String $logic = this.getLogic();
        result = result * 59 + ($logic == null ? 43 : $logic.hashCode());
        String $jnpfKey = this.getJnpfKey();
        result = result * 59 + ($jnpfKey == null ? 43 : $jnpfKey.hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $fieldValue = this.getFieldValue();
        result = result * 59 + ($fieldValue == null ? 43 : $fieldValue.hashCode());
        String $fieldValue2 = this.getFieldValue2();
        result = result * 59 + ($fieldValue2 == null ? 43 : $fieldValue2.hashCode());
        List<String> $selectIgnore = this.getSelectIgnore();
        result = result * 59 + ($selectIgnore == null ? 43 : ((Object)$selectIgnore).hashCode());
        String $dbType = this.getDbType();
        result = result * 59 + ($dbType == null ? 43 : $dbType.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : $precision.hashCode());
        return result;
    }

    public String toString() {
        return "GenUtil(fieldName=" + this.getFieldName() + ", operator=" + this.getOperator() + ", logic=" + this.getLogic() + ", jnpfKey=" + this.getJnpfKey() + ", field=" + this.getField() + ", fieldValue=" + this.getFieldValue() + ", fieldValue2=" + this.getFieldValue2() + ", selectIgnore=" + String.valueOf(this.getSelectIgnore()) + ", dbType=" + this.getDbType() + ", format=" + this.getFormat() + ", precision=" + this.getPrecision() + ")";
    }

    abstract class MyType {
        MyType() {
        }

        abstract void judge(QueryWrapper<?> var1, String var2);
    }

    class BasicControl
    extends MyType {
        BasicControl() {
        }

        @Override
        void judge(QueryWrapper<?> wrapper, String fieldDb) {
            switch (GenUtil.this.operator) {
                case "null": {
                    GenUtil.this.getNullWrapper(wrapper, fieldDb);
                    break;
                }
                case "notNull": {
                    GenUtil.this.getNotNullWrapper(wrapper, fieldDb);
                    break;
                }
                case "==": {
                    wrapper.eq((Object)fieldDb, (Object)GenUtil.this.fieldValue);
                    break;
                }
                case "<>": {
                    wrapper.ne((Object)fieldDb, (Object)GenUtil.this.fieldValue);
                    break;
                }
                case "like": {
                    wrapper.like((Object)fieldDb, (Object)GenUtil.this.fieldValue);
                    break;
                }
                case "notLike": {
                    wrapper.notLike((Object)fieldDb, (Object)GenUtil.this.fieldValue);
                }
            }
        }
    }

    class NumControl
    extends MyType {
        NumControl() {
        }

        @Override
        void judge(QueryWrapper<?> wrapper, String fieldDb) {
            BigDecimal num1 = new BigDecimal(GenUtil.this.fieldValue);
            BigDecimal num2 = null;
            if (GenUtil.this.fieldValue2 != null) {
                num2 = new BigDecimal(GenUtil.this.fieldValue2);
            }
            if (StringUtils.isNotBlank((CharSequence)GenUtil.this.precision)) {
                String zeroNum = "0." + StringUtils.repeat((String)"0", (int)Integer.parseInt(GenUtil.this.precision));
                DecimalFormat numFormat = new DecimalFormat(zeroNum);
                String fieldPrecisionValue = numFormat.format(new BigDecimal(GenUtil.this.fieldValue));
                num1 = new BigDecimal(fieldPrecisionValue);
                if (GenUtil.this.fieldValue2 != null) {
                    String fieldPrecisionValue2 = numFormat.format(new BigDecimal(GenUtil.this.fieldValue2));
                    num2 = new BigDecimal(fieldPrecisionValue2);
                }
            }
            switch (GenUtil.this.operator) {
                case "null": {
                    GenUtil.this.getNullWrapper(wrapper, fieldDb);
                    break;
                }
                case "notNull": {
                    GenUtil.this.getNotNullWrapper(wrapper, fieldDb);
                    break;
                }
                case "==": {
                    wrapper.eq((Object)fieldDb, (Object)num1);
                    break;
                }
                case "<>": {
                    wrapper.ne((Object)fieldDb, (Object)num1);
                    break;
                }
                case ">": {
                    wrapper.gt((Object)fieldDb, (Object)num1);
                    break;
                }
                case "<": {
                    wrapper.lt((Object)fieldDb, (Object)num1);
                    break;
                }
                case ">=": {
                    wrapper.ge((Object)fieldDb, (Object)num1);
                    break;
                }
                case "<=": {
                    wrapper.le((Object)fieldDb, (Object)num1);
                    break;
                }
                case "between": {
                    wrapper.between((Object)fieldDb, (Object)num1, (Object)num2);
                }
            }
        }
    }

    class DateControl
    extends MyType {
        DateControl() {
        }

        @Override
        void judge(QueryWrapper<?> wrapper, String fieldDb) {
            Long time = null;
            Long time2 = null;
            Date date = new Date();
            Date date2 = new Date();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{GenUtil.this.fieldValue})) {
                time = Long.valueOf(GenUtil.this.fieldValue);
                date = new Date(time);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{GenUtil.this.fieldValue2})) {
                time2 = Long.valueOf(GenUtil.this.fieldValue2);
                date2 = "datePicker".equals(GenUtil.this.jnpfKey) ? new Date(time2 + 86400000L - 1000L) : new Date(time2);
            }
            switch (GenUtil.this.operator) {
                case "null": {
                    GenUtil.this.getNullWrapper(wrapper, fieldDb);
                    break;
                }
                case "notNull": {
                    GenUtil.this.getNotNullWrapper(wrapper, fieldDb);
                    break;
                }
                case "==": {
                    if ("datePicker".equals(GenUtil.this.jnpfKey)) {
                        wrapper.between((Object)fieldDb, (Object)date, (Object)new Date(time + 86400000L));
                        break;
                    }
                    wrapper.eq((Object)fieldDb, (Object)date);
                    break;
                }
                case "<>": {
                    wrapper.ne((Object)fieldDb, (Object)date);
                    break;
                }
                case ">": {
                    wrapper.gt((Object)fieldDb, (Object)date);
                    break;
                }
                case "<": {
                    wrapper.lt((Object)fieldDb, (Object)date);
                    break;
                }
                case ">=": {
                    wrapper.ge((Object)fieldDb, (Object)date);
                    break;
                }
                case "<=": {
                    wrapper.le((Object)fieldDb, (Object)date);
                    break;
                }
                case "between": {
                    wrapper.between((Object)fieldDb, (Object)date, (Object)date2);
                }
            }
        }
    }

    class TimeControl
    extends MyType {
        TimeControl() {
        }

        @Override
        void judge(QueryWrapper<?> wrapper, String fieldDb) {
            switch (GenUtil.this.operator) {
                case "null": {
                    GenUtil.this.getNullWrapper(wrapper, fieldDb);
                    break;
                }
                case "notNull": {
                    GenUtil.this.getNotNullWrapper(wrapper, fieldDb);
                    break;
                }
                case "==": {
                    wrapper.eq((Object)fieldDb, (Object)GenUtil.this.fieldValue);
                    break;
                }
                case "<>": {
                    wrapper.ne((Object)fieldDb, (Object)GenUtil.this.fieldValue);
                    break;
                }
                case ">": {
                    wrapper.gt((Object)fieldDb, (Object)GenUtil.this.fieldValue);
                    break;
                }
                case "<": {
                    wrapper.lt((Object)fieldDb, (Object)GenUtil.this.fieldValue);
                    break;
                }
                case ">=": {
                    wrapper.ge((Object)fieldDb, (Object)GenUtil.this.fieldValue);
                    break;
                }
                case "<=": {
                    wrapper.le((Object)fieldDb, (Object)GenUtil.this.fieldValue);
                    break;
                }
                case "between": {
                    wrapper.between((Object)fieldDb, (Object)GenUtil.this.fieldValue, (Object)GenUtil.this.fieldValue2);
                }
            }
        }
    }

    class SelectControl
    extends MyType {
        SelectControl() {
        }

        @Override
        void judge(QueryWrapper<?> wrapper, String fieldDb) {
            List<String> list = GenUtil.this.solveListValue(GenUtil.this.fieldValue);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{GenUtil.this.fieldValue}) && GenUtil.this.fieldValue.charAt(0) == '[' && !GenUtil.this.selectIgnore.contains(GenUtil.this.jnpfKey)) {
                list = JSONUtil.toList((String)GenUtil.this.fieldValue, String.class);
            }
            if (GenUtil.this.selectIgnore.contains(GenUtil.this.jnpfKey) && StringUtils.isBlank((CharSequence)GenUtil.this.fieldValue)) {
                GenUtil.this.fieldValue = "[]";
            }
            switch (GenUtil.this.operator) {
                case "null": {
                    GenUtil.this.getNullWrapper(wrapper, fieldDb);
                    break;
                }
                case "notNull": {
                    GenUtil.this.getNotNullWrapper(wrapper, fieldDb);
                    break;
                }
                case "==": {
                    wrapper.eq((Object)fieldDb, (Object)GenUtil.this.fieldValue);
                    break;
                }
                case "<>": {
                    wrapper.ne((Object)fieldDb, (Object)GenUtil.this.fieldValue);
                    break;
                }
                case "like": {
                    wrapper.like((Object)fieldDb, (Object)GenUtil.this.fieldValue);
                    break;
                }
                case "notLike": {
                    wrapper.notLike((Object)fieldDb, (Object)GenUtil.this.fieldValue);
                    break;
                }
                case "in": {
                    if (list.size() <= 0) break;
                    List<String> finalList = list;
                    if ("||".equals(GenUtil.this.logic)) {
                        wrapper.or(t -> {
                            if (finalList.size() > 0) {
                                for (int i = 0; i < finalList.size(); ++i) {
                                    String value = (String)finalList.get(i);
                                    if (i == 0) {
                                        t.like((Object)fieldDb, (Object)value);
                                        continue;
                                    }
                                    ((QueryWrapper)t.or()).like((Object)fieldDb, (Object)value);
                                }
                            }
                        });
                    } else {
                        wrapper.and(t -> {
                            if (finalList.size() > 0) {
                                for (int i = 0; i < finalList.size(); ++i) {
                                    String value = (String)finalList.get(i);
                                    if (i == 0) {
                                        t.like((Object)fieldDb, (Object)value);
                                        continue;
                                    }
                                    ((QueryWrapper)t.or()).like((Object)fieldDb, (Object)value);
                                }
                            }
                        });
                    }
                    if (!"cascader".equals(GenUtil.this.jnpfKey) && !"organizeSelect".equals(GenUtil.this.jnpfKey) && !"areaSelect".equals(GenUtil.this.jnpfKey)) break;
                    GenUtil.this.getNotNullWrapper(wrapper, fieldDb);
                    break;
                }
                case "notIn": {
                    if (list.size() <= 0) break;
                    List<String> finalList1 = list;
                    if ("||".equals(GenUtil.this.logic)) {
                        wrapper.or(t -> {
                            if (finalList1.size() > 0) {
                                for (int i = 0; i < finalList1.size(); ++i) {
                                    String value = (String)finalList1.get(i);
                                    if (i == 0) {
                                        t.notLike((Object)fieldDb, (Object)value);
                                        continue;
                                    }
                                    t.notLike((Object)fieldDb, (Object)value);
                                }
                            }
                        });
                    } else {
                        wrapper.and(t -> {
                            if (finalList1.size() > 0) {
                                for (int i = 0; i < finalList1.size(); ++i) {
                                    String value = (String)finalList1.get(i);
                                    if (i == 0) {
                                        t.notLike((Object)fieldDb, (Object)value);
                                        continue;
                                    }
                                    t.notLike((Object)fieldDb, (Object)value);
                                }
                            }
                        });
                    }
                    if (!"cascader".equals(GenUtil.this.jnpfKey) && !"organizeSelect".equals(GenUtil.this.jnpfKey) && !"areaSelect".equals(GenUtil.this.jnpfKey)) break;
                    GenUtil.this.getNotNullWrapper(wrapper, fieldDb);
                }
            }
        }
    }
}

