/*
 * Decompiled with CFR 0.152.
 */
package jnpf.portal.controller;

import cn.dev33.satoken.stp.StpUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jnpf.base.ActionResult;
import jnpf.base.controller.SuperController;
import jnpf.constant.MsgCode;
import jnpf.portal.entity.PortalEntity;
import jnpf.portal.model.PortalCustomPrimary;
import jnpf.portal.model.PortalDataForm;
import jnpf.portal.model.PortalInfoAuthVO;
import jnpf.portal.model.PortalReleaseForm;
import jnpf.portal.model.PortalReleaseVO;
import jnpf.portal.model.ReleaseModel;
import jnpf.portal.service.PortalDataService;
import jnpf.portal.service.PortalService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u95e8\u6237\u5c55\u793a\u754c\u9762", description="Portal")
@RequestMapping(value={"/api/visualdev/Portal"})
public class PortalDataController
extends SuperController<PortalService, PortalEntity> {
    private static final Logger log = LoggerFactory.getLogger(PortalDataController.class);
    @Autowired
    private PortalDataService portalDataService;

    @Operation(summary="\u8bbe\u7f6e\u9ed8\u8ba4\u95e8\u6237")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @PutMapping(value={"/{id}/Actions/SetDefault"})
    @Transactional
    public ActionResult<String> SetDefault(@PathVariable(value="id") String id, String platform) {
        this.portalDataService.setCurrentDefault(platform, id);
        return ActionResult.success((String)MsgCode.SU016.get(new Object[0]));
    }

    @Operation(summary="\u95e8\u6237\u81ea\u5b9a\u4e49\u4fdd\u5b58")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @PutMapping(value={"/Custom/Save/{id}"})
    public ActionResult<String> customSave(@PathVariable(value="id") String id, @RequestBody PortalDataForm portalDataForm) throws Exception {
        StpUtil.checkPermissionOr((String[])new String[]{"onlineDev.visualPortal", id});
        portalDataForm.setPortalId(id);
        this.portalDataService.createOrUpdate(new PortalCustomPrimary(portalDataForm.getPlatform(), portalDataForm.getPortalId()), portalDataForm.getFormData());
        return ActionResult.success((String)MsgCode.SU002.getMsg());
    }

    @Operation(summary="\u95e8\u6237\u53d1\u5e03(\u540c\u6b65)")
    @Parameters(value={@Parameter(name="portalId", description="\u95e8\u6237\u4e3b\u952e")})
    @PutMapping(value={"/Actions/release/{portalId}"})
    @Transactional(rollbackFor={Exception.class})
    public ActionResult<PortalReleaseVO> release(@PathVariable(value="portalId") String portalId, @RequestBody @Valid PortalReleaseForm form) throws Exception {
        if (form.getPcPortal() == 1) {
            this.portalDataService.release("Web", portalId, form.getPcPortalSystemId(), "Web", form);
        }
        if (form.getAppPortal() == 1) {
            this.portalDataService.release("App", portalId, form.getAppPortalSystemId(), "App", form);
        }
        ReleaseModel releaseSystemModel = new ReleaseModel();
        releaseSystemModel.setPc(form.getPc());
        releaseSystemModel.setPcSystemId(form.getPcSystemId());
        releaseSystemModel.setPcModuleParentId(form.getPcModuleParentId());
        releaseSystemModel.setApp(form.getApp());
        releaseSystemModel.setAppSystemId(form.getAppSystemId());
        releaseSystemModel.setAppModuleParentId(form.getAppModuleParentId());
        releaseSystemModel.setPcModuleParentId(form.getPcModuleParentId());
        releaseSystemModel.setAppModuleParentId(form.getAppModuleParentId());
        this.portalDataService.releaseModule(releaseSystemModel, portalId);
        return ActionResult.success((String)MsgCode.SU011.get(new Object[0]));
    }

    @Operation(summary="\u4e2a\u4eba\u95e8\u6237\u8be6\u60c5")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @GetMapping(value={"/{id}/auth"})
    public ActionResult<PortalInfoAuthVO> infoAuth(@PathVariable(value="id") String id, String platform, String systemId) {
        platform = platform.equalsIgnoreCase("pc") || platform.equalsIgnoreCase("Web") ? "Web" : "App";
        try {
            return ActionResult.success((Object)this.portalDataService.getDataFormView(id, platform));
        }
        catch (Exception e) {
            return ActionResult.fail((String)e.getMessage());
        }
    }
}

