/*
 * Decompiled with CFR 0.152.
 */
package jnpf.portal.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.dev33.satoken.stp.StpUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import jnpf.base.ActionResult;
import jnpf.base.controller.SuperController;
import jnpf.base.model.VisualFunctionModel;
import jnpf.base.model.base.SystemListVO;
import jnpf.base.vo.DownloadVO;
import jnpf.base.vo.ListVO;
import jnpf.base.vo.PageListVO;
import jnpf.base.vo.PaginationVO;
import jnpf.config.ConfigValueUtil;
import jnpf.constant.MsgCode;
import jnpf.emnus.ExportModelTypeEnum;
import jnpf.emnus.ModuleTypeEnum;
import jnpf.portal.entity.PortalEntity;
import jnpf.portal.model.PortalCrForm;
import jnpf.portal.model.PortalExportDataVo;
import jnpf.portal.model.PortalInfoVO;
import jnpf.portal.model.PortalModPrimary;
import jnpf.portal.model.PortalPagination;
import jnpf.portal.model.PortalSelectVO;
import jnpf.portal.model.PortalUpForm;
import jnpf.portal.model.PortalViewPrimary;
import jnpf.portal.service.PortalDataService;
import jnpf.portal.service.PortalService;
import jnpf.util.FileExport;
import jnpf.util.FileUtil;
import jnpf.util.JsonUtil;
import jnpf.util.JsonUtilEx;
import jnpf.util.RandomUtil;
import jnpf.util.StringUtil;
import jnpf.util.UserProvider;
import jnpf.util.treeutil.newtreeutil.TreeDotUtils2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Tag(name="\u53ef\u89c6\u5316\u95e8\u6237", description="Portal")
@RequestMapping(value={"/api/visualdev/Portal"})
public class PortalController
extends SuperController<PortalService, PortalEntity> {
    private static final Logger log = LoggerFactory.getLogger(PortalController.class);
    @Autowired
    private PortalService portalService;
    @Autowired
    private FileExport fileExport;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private PortalDataService portalDataService;

    @Operation(summary="\u95e8\u6237\u5217\u8868")
    @GetMapping
    @SaCheckPermission(value={"onlineDev.visualPortal"})
    public ActionResult list(PortalPagination portalPagination) {
        List modelAll = this.portalService.getModelList(portalPagination);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)portalPagination, PaginationVO.class);
        return ActionResult.page((List)modelAll, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u95e8\u6237\u6811\u5f62\u5217\u8868")
    @Parameters(value={@Parameter(name="type", description="\u7c7b\u578b\uff1a0-\u95e8\u6237\u8bbe\u8ba1,1-\u914d\u7f6e\u8def\u5f84")})
    @GetMapping(value={"/Selector"})
    public ActionResult<ListVO<PortalSelectVO>> listSelect(String platform, String type) {
        ArrayList modelList = new ArrayList();
        if (StringUtil.isNotEmpty((String)type)) {
            modelList.addAll(this.portalService.getModList(new PortalViewPrimary(platform, null)));
        } else {
            modelList.addAll(this.portalService.getModSelectList());
        }
        List sumTrees = TreeDotUtils2.convertListToTreeDot(modelList);
        List jsonToList = JsonUtil.getJsonToList((Object)sumTrees, PortalSelectVO.class);
        return ActionResult.success((Object)new ListVO(jsonToList));
    }

    @Operation(summary="\u95e8\u6237\u8be6\u60c5")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @GetMapping(value={"/{id}"})
    public ActionResult<PortalInfoVO> info(@PathVariable(value="id") String id, String platform) throws Exception {
        StpUtil.checkPermissionOr((String[])new String[]{"onlineDev.visualPortal", id});
        PortalEntity entity = this.portalService.getInfo(id);
        if (entity == null) {
            return ActionResult.fail((String)MsgCode.FA001.get(new Object[0]));
        }
        PortalInfoVO vo = (PortalInfoVO)JsonUtil.getJsonToBean((String)JsonUtilEx.getObjectToStringDateFormat((Object)entity, (String)"yyyy-MM-dd HH:mm:ss"), PortalInfoVO.class);
        vo.setFormData(this.portalDataService.getModelDataForm(new PortalModPrimary(id)));
        VisualFunctionModel releaseInfo = this.portalService.getReleaseInfo((String)entity.getId());
        vo.setPcPortalIsRelease(releaseInfo.getPcPortalIsRelease());
        vo.setPcPortalReleaseName(releaseInfo.getPcPortalReleaseName());
        vo.setAppPortalIsRelease(releaseInfo.getAppPortalIsRelease());
        vo.setAppPortalReleaseName(releaseInfo.getAppPortalReleaseName());
        vo.setPcIsRelease(releaseInfo.getPcIsRelease());
        vo.setPcReleaseName(releaseInfo.getPcReleaseName());
        vo.setAppIsRelease(releaseInfo.getAppIsRelease());
        vo.setAppReleaseName(releaseInfo.getAppReleaseName());
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u5220\u9664\u95e8\u6237")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @DeleteMapping(value={"/{id}"})
    @SaCheckPermission(value={"onlineDev.visualPortal"})
    @DSTransactional
    public ActionResult<String> delete(@PathVariable(value="id") String id) {
        PortalEntity entity = this.portalService.getInfo(id);
        if (entity != null) {
            try {
                this.portalService.delete(entity);
            }
            catch (Exception e) {
                return ActionResult.fail((String)e.getMessage());
            }
        }
        return ActionResult.success((String)MsgCode.SU003.get(new Object[0]));
    }

    @Operation(summary="\u521b\u5efa\u95e8\u6237")
    @PostMapping
    @SaCheckPermission(value={"onlineDev.visualPortal"})
    @DSTransactional
    public ActionResult<String> create(@RequestBody @Valid PortalCrForm portalCrForm) throws Exception {
        PortalEntity entity = (PortalEntity)JsonUtil.getJsonToBean((Object)portalCrForm, PortalEntity.class);
        entity.setId((Object)RandomUtil.uuId());
        if (this.portalService.isExistByFullName(entity.getFullName(), (String)entity.getId()).booleanValue()) {
            return ActionResult.fail((String)MsgCode.EXIST001.get(new Object[0]));
        }
        if (this.portalService.isExistByEnCode(entity.getEnCode(), (String)entity.getId()).booleanValue()) {
            return ActionResult.fail((String)MsgCode.EXIST002.get(new Object[0]));
        }
        if (Objects.equals(entity.getType(), 1)) {
            entity.setEnabledLock(null);
        }
        this.portalService.create(entity);
        this.portalDataService.createOrUpdate(new PortalModPrimary((String)entity.getId()), portalCrForm.getFormData());
        return ActionResult.success((String)MsgCode.SU001.get(new Object[0]), (Object)((String)entity.getId()));
    }

    @Operation(summary="\u590d\u5236\u529f\u80fd")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @PostMapping(value={"/{id}/Actions/Copy"})
    @SaCheckPermission(value={"onlineDev.visualPortal"})
    public ActionResult copyInfo(@PathVariable(value="id") String id) throws Exception {
        PortalEntity entity = this.portalService.getInfo(id);
        entity.setEnabledMark(Integer.valueOf(0));
        String copyNum = UUID.randomUUID().toString().substring(0, 5);
        entity.setFullName(entity.getFullName() + ".\u526f\u672c" + copyNum);
        entity.setLastModifyTime(null);
        entity.setLastModifyUserId(null);
        entity.setId((Object)RandomUtil.uuId());
        entity.setEnCode(entity.getEnCode() + copyNum);
        entity.setCreatorTime(new Date());
        entity.setCreatorUserId(UserProvider.getUser().getUserId());
        PortalEntity entity1 = (PortalEntity)JsonUtil.getJsonToBean((Object)entity, PortalEntity.class);
        if (entity1.getEnCode().length() > 50 || entity1.getFullName().length() > 50) {
            return ActionResult.fail((String)MsgCode.PRI006.get(new Object[0]));
        }
        this.portalService.create(entity1);
        this.portalDataService.createOrUpdate(new PortalModPrimary((String)entity1.getId()), this.portalDataService.getModelDataForm(new PortalModPrimary(id)));
        return ActionResult.success((String)MsgCode.SU007.get(new Object[0]));
    }

    @Operation(summary="\u4fee\u6539\u95e8\u6237")
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e")})
    @PutMapping(value={"/{id}"})
    @SaCheckPermission(value={"onlineDev.visualPortal"})
    @DSTransactional
    public ActionResult<String> update(@PathVariable(value="id") String id, @RequestBody @Valid PortalUpForm portalUpForm) throws Exception {
        PortalEntity originEntity = this.portalService.getInfo(portalUpForm.getId());
        if (originEntity == null) {
            ActionResult.fail((String)MsgCode.FA002.get(new Object[0]));
        }
        if (!originEntity.getFullName().equals(portalUpForm.getFullName()) && StringUtil.isNotEmpty((String)portalUpForm.getFullName()) && this.portalService.isExistByFullName(portalUpForm.getFullName(), portalUpForm.getId()).booleanValue()) {
            return ActionResult.fail((String)MsgCode.EXIST001.get(new Object[0]));
        }
        if (!originEntity.getEnCode().equals(portalUpForm.getEnCode()) && StringUtil.isNotEmpty((String)portalUpForm.getEnCode()) && this.portalService.isExistByEnCode(portalUpForm.getEnCode(), portalUpForm.getId()).booleanValue()) {
            return ActionResult.fail((String)MsgCode.EXIST002.get(new Object[0]));
        }
        if (Objects.equals(portalUpForm.getType(), 1)) {
            portalUpForm.setEnabledLock(null);
        }
        if (Objects.equals(originEntity.getState(), 1)) {
            originEntity.setState(Integer.valueOf(2));
            portalUpForm.setState(Integer.valueOf(2));
        }
        this.portalDataService.createOrUpdate(new PortalModPrimary(portalUpForm.getId()), portalUpForm.getFormData());
        if (StringUtil.isNotEmpty((String)portalUpForm.getFullName()) && StringUtil.isNotEmpty((String)portalUpForm.getEnCode())) {
            this.portalService.update(id, (PortalEntity)JsonUtil.getJsonToBean((Object)portalUpForm, PortalEntity.class));
        } else {
            this.portalService.update(id, originEntity);
        }
        return ActionResult.success((String)MsgCode.SU004.get(new Object[0]));
    }

    @Operation(summary="\u95e8\u6237\u5bfc\u51fa")
    @Parameters(value={@Parameter(name="modelId", description="\u6a21\u677fid")})
    @PostMapping(value={"/{modelId}/Actions/Export"})
    @SaCheckPermission(value={"onlineDev.visualPortal"})
    public ActionResult exportFunction(@PathVariable(value="modelId") String modelId) throws Exception {
        PortalEntity entity = this.portalService.getInfo(modelId);
        if (entity != null) {
            PortalExportDataVo vo = new PortalExportDataVo();
            BeanUtils.copyProperties((Object)entity, (Object)vo);
            vo.setId((String)entity.getId());
            vo.setModelType(ExportModelTypeEnum.Portal.getMessage());
            vo.setFormData(this.portalDataService.getModelDataForm(new PortalModPrimary((String)entity.getId())));
            DownloadVO downloadVO = this.fileExport.exportFile((Object)vo, this.configValueUtil.getTemporaryFilePath(), entity.getFullName(), ModuleTypeEnum.VISUAL_PORTAL.getTableName());
            return ActionResult.success((Object)downloadVO);
        }
        return ActionResult.success((String)MsgCode.FA001.get(new Object[0]));
    }

    @Operation(summary="\u95e8\u6237\u5bfc\u5165")
    @Parameters(value={@Parameter(name="file", description="\u5bfc\u5165\u6587\u4ef6")})
    @PostMapping(value={"/Actions/Import"}, consumes={"multipart/form-data"})
    @SaCheckPermission(value={"onlineDev.visualPortal"})
    public ActionResult importFunction(@RequestPart(value="file") MultipartFile multipartFile, @RequestParam(value="type") Integer type) throws Exception {
        if (FileUtil.existsSuffix((MultipartFile)multipartFile, (String)ModuleTypeEnum.VISUAL_PORTAL.getTableName())) {
            return ActionResult.fail((String)MsgCode.IMP002.get(new Object[0]));
        }
        String fileContent = FileUtil.getFileContent((MultipartFile)multipartFile);
        PortalExportDataVo vo = (PortalExportDataVo)JsonUtil.getJsonToBean((String)fileContent, PortalExportDataVo.class);
        if (vo.getModelType() == null || !vo.getModelType().equals(ExportModelTypeEnum.Portal.getMessage())) {
            return ActionResult.fail((String)MsgCode.VS410.get(new Object[0]));
        }
        PortalEntity entity = (PortalEntity)JsonUtil.getJsonToBean((String)fileContent, PortalEntity.class);
        StringJoiner errList = new StringJoiner("\u3001");
        String copyNum = UUID.randomUUID().toString().substring(0, 5);
        if (this.portalService.getInfo((String)entity.getId()) != null) {
            if (Objects.equals(type, 0)) {
                errList.add("ID");
            } else {
                entity.setId(null);
            }
        }
        if (this.portalService.isExistByEnCode(entity.getEnCode(), null).booleanValue()) {
            if (Objects.equals(type, 0)) {
                errList.add(MsgCode.IMP009.get(new Object[0]));
            } else {
                entity.setEnCode(entity.getEnCode() + copyNum);
            }
        }
        if (this.portalService.isExistByFullName(entity.getFullName(), null).booleanValue()) {
            if (Objects.equals(type, 0)) {
                errList.add(MsgCode.IMP008.get(new Object[0]));
            } else {
                entity.setFullName(entity.getFullName() + ".\u526f\u672c" + copyNum);
            }
        }
        if (Objects.equals(type, 0) && errList.length() > 0) {
            return ActionResult.fail((String)(String.valueOf(errList) + MsgCode.IMP007.get(new Object[0])));
        }
        this.portalService.setIgnoreLogicDelete().removeById((Serializable)entity.getId());
        this.portalService.clearIgnoreLogicDelete();
        entity.setEnabledMark(Integer.valueOf(0));
        entity.setSortCode(Long.valueOf(0L));
        entity.setCreatorTime(new Date());
        entity.setCreatorUserId(UserProvider.getUser().getUserId());
        entity.setLastModifyTime(null);
        entity.setLastModifyUserId(null);
        this.portalService.create(entity);
        this.portalDataService.createOrUpdate(new PortalModPrimary((String)entity.getId()), vo.getFormData());
        return ActionResult.success((String)MsgCode.IMP001.get(new Object[0]));
    }

    @Operation(summary="\u95e8\u6237\u7ba1\u7406\u4e0b\u62c9\u5217\u8868")
    @GetMapping(value={"/manage/Selector/{systemId}"})
    public ActionResult<PageListVO<PortalSelectVO>> getManageSelectorList(@PathVariable String systemId, PortalPagination portalPagination) {
        portalPagination.setType(null);
        List voList = this.portalService.getManageSelectorPage(portalPagination, systemId);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)portalPagination, PaginationVO.class);
        return ActionResult.page((List)voList, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u95e8\u6237\u83b7\u53d6\u7cfb\u7edf\u4e0b\u62c9")
    @GetMapping(value={"/systemFilter/{id}"})
    public ActionResult<ListVO<SystemListVO>> systemFilterList(@PathVariable(value="id") String id, String category) {
        List systemListVOS = this.portalService.systemFilterList(id, category);
        return ActionResult.success((Object)new ListVO(systemListVOS));
    }
}

