/*
 * Decompiled with CFR 0.152.
 */
package jnpf.portal.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import jnpf.base.ActionResult;
import jnpf.base.vo.ListVO;
import jnpf.flowable.model.operator.OperatorVo;
import jnpf.flowable.model.task.TaskPagination;
import jnpf.message.model.NoticeModel;
import jnpf.message.model.message.NoticeVO;
import jnpf.message.service.MessageService;
import jnpf.portal.model.EmailVO;
import jnpf.portal.model.FlowTodo;
import jnpf.portal.model.FlowTodoCountVO;
import jnpf.portal.model.FlowTodoVO;
import jnpf.portal.model.MyFlowTodoVO;
import jnpf.service.EmailReceiveService;
import jnpf.util.JsonUtil;
import jnpf.workflow.service.TaskApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u4e3b\u9875\u63a7\u5236\u5668", description="Home")
@RestController
@RequestMapping(value={"api/visualdev/Dashboard"})
public class DashboardController {
    @Autowired
    private TaskApi taskApi;
    @Autowired
    private EmailReceiveService emailReceiveService;
    @Autowired
    private MessageService messageService;

    @Operation(summary="\u83b7\u53d6\u6211\u7684\u5f85\u529e")
    @PostMapping(value={"/FlowTodoCount"})
    public ActionResult getFlowTodoCount(@RequestBody FlowTodo flowTodo) {
        FlowTodoCountVO vo = new FlowTodoCountVO();
        TaskPagination pagination = new TaskPagination();
        pagination.setDelegateType(Boolean.valueOf(true));
        pagination.setPageSize(1L);
        pagination.setCurrentPage(1L);
        pagination.setFlowCategory(String.join((CharSequence)",", flowTodo.getFlowToSignType()));
        pagination.setCategory("0");
        this.taskApi.getWaitList(pagination);
        vo.setFlowToSign(Long.valueOf(pagination.getTotal()));
        pagination.setFlowCategory(String.join((CharSequence)",", flowTodo.getFlowTodoType()));
        pagination.setCategory("1");
        this.taskApi.getWaitList(pagination);
        vo.setFlowTodo(Long.valueOf(pagination.getTotal()));
        pagination.setFlowCategory(String.join((CharSequence)",", flowTodo.getFlowDoingType()));
        pagination.setCategory("2");
        this.taskApi.getWaitList(pagination);
        vo.setFlowDoing(Long.valueOf(pagination.getTotal()));
        pagination.setTotal(0L);
        pagination.setFlowCategory(String.join((CharSequence)",", flowTodo.getFlowDoneType()));
        this.taskApi.getTrialList(pagination);
        vo.setFlowDone(Long.valueOf(pagination.getTotal()));
        pagination.setFlowCategory(String.join((CharSequence)",", flowTodo.getFlowCirculateType()));
        this.taskApi.getCirculateList(pagination);
        vo.setFlowCirculate(Long.valueOf(pagination.getTotal()));
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u83b7\u53d6\u901a\u77e5\u516c\u544a")
    @PostMapping(value={"/Notice"})
    public ActionResult getNotice(@RequestBody NoticeModel noticeModel) {
        List list = JsonUtil.getJsonToList((Object)this.messageService.getNoticeList(noticeModel.getTypeList()), NoticeVO.class);
        ListVO voList = new ListVO();
        voList.setList(list);
        return ActionResult.success((Object)voList);
    }

    @Operation(summary="\u83b7\u53d6\u672a\u8bfb\u90ae\u4ef6")
    @GetMapping(value={"/Email"})
    public ActionResult getEmail() {
        List list = JsonUtil.getJsonToList((Object)this.emailReceiveService.getDashboardReceiveList(), EmailVO.class);
        ListVO voList = new ListVO();
        voList.setList(list);
        return ActionResult.success((Object)voList);
    }

    @Operation(summary="\u83b7\u53d6\u5f85\u529e\u4e8b\u9879")
    @GetMapping(value={"/FlowTodo"})
    public ActionResult getFlowTodo(@RequestParam(value="type") Integer type) {
        TaskPagination pagination = new TaskPagination();
        pagination.setDelegateType(Boolean.valueOf(true));
        pagination.setPageSize(10L);
        pagination.setCurrentPage(1L);
        pagination.setCategory(switch (type) {
            case 1 -> "0";
            case 2 -> "1";
            default -> "2";
        });
        List waitList = this.taskApi.getWaitList(pagination);
        ArrayList<FlowTodoVO> list = new ArrayList<FlowTodoVO>();
        for (OperatorVo operatorVo : waitList) {
            FlowTodoVO vo = (FlowTodoVO)JsonUtil.getJsonToBean((Object)operatorVo, FlowTodoVO.class);
            vo.setTaskNodeId(operatorVo.getNodeCode());
            vo.setTaskOperatorId(operatorVo.getId());
            vo.setType(Integer.valueOf(2));
            list.add(vo);
        }
        ListVO voList = new ListVO();
        voList.setList(list);
        return ActionResult.success((Object)voList);
    }

    @Operation(summary="\u83b7\u53d6\u6211\u7684\u5f85\u529e\u4e8b\u9879")
    @GetMapping(value={"/MyFlowTodo"})
    public ActionResult getMyFlowTodo() {
        TaskPagination pagination = new TaskPagination();
        pagination.setCategory("2");
        List list = JsonUtil.getJsonToList((Object)this.taskApi.getWaitList(pagination), MyFlowTodoVO.class);
        ListVO voList = new ListVO();
        voList.setList(list);
        return ActionResult.success((Object)voList);
    }
}

