/*
 * Decompiled with CFR 0.152.
 */
package jnpf.onlinedev.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jnpf.base.ActionResult;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.service.VisualdevService;
import jnpf.base.vo.DownloadVO;
import jnpf.config.ConfigValueUtil;
import jnpf.constant.MsgCode;
import jnpf.emnus.ExportModelTypeEnum;
import jnpf.emnus.ModuleTypeEnum;
import jnpf.exception.WorkFlowException;
import jnpf.onlinedev.model.BaseDevModelVO;
import jnpf.util.DateUtil;
import jnpf.util.FileExport;
import jnpf.util.FileUtil;
import jnpf.util.JsonUtil;
import jnpf.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="0\u4ee3\u7801app\u65e0\u8868\u5f00\u53d1", description="ModelAppData")
@RestController
@RequestMapping(value={"/api/visualdev/OnlineDev/App"})
public class VisualdevModelAppController {
    @Autowired
    private VisualdevService visualdevService;
    @Autowired
    private FileExport fileExport;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @Operation(summary="\u529f\u80fd\u5bfc\u51fa")
    @PostMapping(value={"/{modelId}/Actions/ExportData"})
    public ActionResult exportData(@PathVariable(value="modelId") String modelId) {
        VisualdevEntity visualdevEntity = this.visualdevService.getInfo(modelId);
        BaseDevModelVO vo = (BaseDevModelVO)JsonUtil.getJsonToBean((Object)visualdevEntity, BaseDevModelVO.class);
        vo.setModelType(ExportModelTypeEnum.App.getMessage());
        DownloadVO downloadVO = this.fileExport.exportFile((Object)vo, this.configValueUtil.getTemporaryFilePath(), visualdevEntity.getFullName(), ModuleTypeEnum.VISUAL_APP.getTableName());
        return ActionResult.success((Object)downloadVO);
    }

    @Operation(summary="\u529f\u80fd\u5bfc\u5165")
    @PostMapping(value={"/Model/Actions/ImportData"}, consumes={"multipart/form-data"})
    public ActionResult ImportData(@RequestPart(value="file") MultipartFile multipartFile) throws WorkFlowException {
        VisualdevEntity entity;
        if (FileUtil.existsSuffix((MultipartFile)multipartFile, (String)ModuleTypeEnum.VISUAL_APP.getTableName())) {
            return ActionResult.fail((String)MsgCode.IMP002.get(new Object[0]));
        }
        String fileContent = FileUtil.getFileContent((MultipartFile)multipartFile);
        BaseDevModelVO vo = (BaseDevModelVO)JsonUtil.getJsonToBean((String)fileContent, BaseDevModelVO.class);
        if (vo.getModelType() == null || !vo.getModelType().equals(ExportModelTypeEnum.App.getMessage())) {
            return ActionResult.fail((String)MsgCode.VS410.get(new Object[0]));
        }
        VisualdevEntity visualdevEntity = (VisualdevEntity)JsonUtil.getJsonToBean((Object)vo, VisualdevEntity.class);
        String modelId = (String)visualdevEntity.getId();
        if (StringUtil.isNotEmpty((String)modelId) && (entity = this.visualdevService.getInfo(modelId)) != null) {
            return ActionResult.fail((String)MsgCode.VS411.get(new Object[0]));
        }
        visualdevEntity.setCreatorTime(DateUtil.getNowDate());
        visualdevEntity.setLastModifyTime(null);
        this.visualdevService.create(visualdevEntity);
        return ActionResult.success((String)MsgCode.IMP001.get(new Object[0]));
    }
}

