/*
 * Decompiled with CFR 0.152.
 */
package jnpf.onlinedev.controller;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jnpf.base.ActionResult;
import jnpf.base.UserInfo;
import jnpf.base.entity.SuperBaseEntity;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.entity.VisualdevReleaseEntity;
import jnpf.base.model.OnlineImport.VisualdevModelDataInfoVO;
import jnpf.base.model.VisualDevJsonModel;
import jnpf.base.model.flow.DataModel;
import jnpf.base.model.flow.FlowFormDataModel;
import jnpf.base.service.DbLinkService;
import jnpf.base.service.FlowFormRelationService;
import jnpf.base.service.VisualdevReleaseService;
import jnpf.base.service.VisualdevService;
import jnpf.base.util.FlowFormDataUtil;
import jnpf.base.util.FlowFormHttpReqUtils;
import jnpf.database.model.entity.DbLinkEntity;
import jnpf.exception.DataException;
import jnpf.onlinedev.model.PaginationModel;
import jnpf.onlinedev.model.VisualParamModel;
import jnpf.onlinedev.service.VisualDevInfoService;
import jnpf.onlinedev.service.VisualDevListService;
import jnpf.onlinedev.service.VisualdevModelDataService;
import jnpf.onlinedev.util.onlineDevUtil.FlowFormCustomUtils;
import jnpf.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import jnpf.util.JsonUtil;
import jnpf.util.StringUtil;
import jnpf.util.TableFeildsEnum;
import jnpf.util.UserProvider;
import jnpf.visual.service.VisualdevApi;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VisualdevForFlowController
implements VisualdevApi {
    @Autowired
    private VisualdevReleaseService visualdevReleaseService;
    @Autowired
    private VisualdevService visualdevService;
    @Autowired
    private VisualDevListService visualDevListService;
    @Autowired
    private VisualDevInfoService visualDevInfoService;
    @Autowired
    private FlowFormHttpReqUtils flowFormHttpReqUtils;
    @Autowired
    private FlowFormCustomUtils flowFormCustomUtils;
    @Autowired
    private FlowFormDataUtil flowDataUtil;
    @Autowired
    private DbLinkService dblinkService;
    @Autowired
    private FlowFormRelationService flowFormRelationService;
    @Autowired
    private VisualdevModelDataService visualdevModelDataService;

    public ActionResult saveOrUpdate(FlowFormDataModel flowFormDataModel) {
        DataModel dataModel = null;
        try {
            String id = flowFormDataModel.getId();
            String formId = flowFormDataModel.getFormId();
            String flowId = flowFormDataModel.getFlowId();
            Map map = flowFormDataModel.getMap();
            List formOperates = flowFormDataModel.getFormOperates();
            VisualdevReleaseEntity entity = (VisualdevReleaseEntity)this.visualdevReleaseService.getById((Serializable)((Object)formId));
            VisualdevEntity visualdevEntity = (VisualdevEntity)JsonUtil.getJsonToBean((Object)entity, VisualdevEntity.class);
            map.put("flowId", flowId);
            if (map.get(TableFeildsEnum.VERSION.getField().toUpperCase()) != null) {
                map.put(TableFeildsEnum.VERSION.getField(), map.get(TableFeildsEnum.VERSION.getField().toUpperCase()));
            }
            if (entity.getType() == 2) {
                map.put("formOperates", formOperates);
                this.flowFormHttpReqUtils.saveOrUpdate(visualdevEntity, id, UserProvider.getToken(), map);
            } else {
                try {
                    dataModel = this.flowFormCustomUtils.saveOrUpdate(visualdevEntity, flowFormDataModel);
                }
                catch (SQLException sqlException) {
                    sqlException.printStackTrace();
                }
                catch (DataException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return ActionResult.fail((String)e.getMessage());
        }
        return ActionResult.success((Object)dataModel);
    }

    public boolean delete(String formId, String id) {
        try {
            VisualdevReleaseEntity entity = (VisualdevReleaseEntity)this.visualdevReleaseService.getById((Serializable)((Object)formId));
            VisualdevEntity visualdevEntity = (VisualdevEntity)JsonUtil.getJsonToBean((Object)entity, VisualdevEntity.class);
            if (entity.getType() == 2) {
                this.flowFormHttpReqUtils.delete(visualdevEntity, id, UserProvider.getToken());
            } else {
                VisualDevJsonModel visualJsonModel = OnlinePublicUtils.getVisualJsonModel((VisualdevEntity)visualdevEntity);
                DbLinkEntity linkEntity = StringUtil.isNotEmpty((String)visualdevEntity.getDbLinkId()) ? this.dblinkService.getInfo(visualdevEntity.getDbLinkId()) : null;
                this.flowDataUtil.deleteTable(id, visualJsonModel, linkEntity);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public ActionResult info(String formId, String id) {
        ActionResult result = new ActionResult();
        HashMap allDataMap = new HashMap();
        VisualdevReleaseEntity entity = (VisualdevReleaseEntity)this.visualdevReleaseService.getById((Serializable)((Object)formId));
        VisualdevEntity visualdevEntity = (VisualdevEntity)JsonUtil.getJsonToBean((Object)entity, VisualdevEntity.class);
        result.setCode(Integer.valueOf(visualdevEntity == null ? 400 : 200));
        result.setMsg(visualdevEntity == null ? "\u8868\u5355\u4fe1\u606f\u4e0d\u5b58\u5728" : "");
        if (visualdevEntity != null) {
            boolean b;
            boolean bl = b = visualdevEntity.getType() == 2;
            if (b) {
                allDataMap.putAll(this.flowFormHttpReqUtils.info(visualdevEntity, id, UserProvider.getToken()));
            } else {
                allDataMap.putAll(this.flowFormCustomUtils.info(visualdevEntity, id));
            }
        }
        result.setData(allDataMap);
        return result;
    }

    public VisualdevEntity getFormConfig(String formId) {
        VisualdevReleaseEntity entity = (VisualdevReleaseEntity)this.visualdevReleaseService.getById((Serializable)((Object)formId));
        VisualdevEntity visualdevEntity = (VisualdevEntity)JsonUtil.getJsonToBean((Object)entity, VisualdevEntity.class);
        return visualdevEntity;
    }

    public List<VisualdevEntity> getFormConfigList(List<String> formIds) {
        List list = this.visualdevReleaseService.selectByIds(formIds, new SFunction[]{SuperBaseEntity.SuperIBaseEntity::getId, VisualdevReleaseEntity::getEnCode, VisualdevReleaseEntity::getFullName, VisualdevReleaseEntity::getType});
        return CollectionUtils.isNotEmpty((Collection)list) ? JsonUtil.getJsonToList((Object)list, VisualdevEntity.class) : new ArrayList();
    }

    public void saveFlowIdByFormIds(String flowId, List<String> formIds) {
        this.flowFormRelationService.saveFlowIdByFormIds(flowId, formIds);
    }

    public VisualdevEntity getReleaseInfo(String formId) {
        return this.visualdevService.getReleaseInfo(formId);
    }

    public List<Map<String, Object>> getListWithTableList(VisualDevJsonModel visualDevJsonModel, PaginationModel pagination, UserInfo userInfo) {
        return this.visualDevListService.getListWithTableList(visualDevJsonModel, pagination, userInfo);
    }

    public VisualdevModelDataInfoVO getEditDataInfo(String id, VisualdevEntity visualdevEntity) {
        return this.visualDevInfoService.getEditDataInfo(id, visualdevEntity);
    }

    public DataModel visualCreate(VisualParamModel model) throws Exception {
        return this.visualdevModelDataService.visualCreate(model.getVisualdevEntity(), model.getData());
    }

    public DataModel visualUpdate(VisualParamModel model) throws Exception {
        return this.visualdevModelDataService.visualUpdate(model);
    }

    public void visualDelete(VisualParamModel model) throws Exception {
        this.visualdevModelDataService.visualDelete(model.getVisualdevEntity(), model.getDataList());
    }

    public void deleteByTableName(FlowFormDataModel model) throws Exception {
        this.visualdevModelDataService.deleteByTableName(model);
    }
}

