/*
 * Decompiled with CFR 0.152.
 */
package jnpf.onlinedev.controller;

import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.util.ObjectUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import jnpf.base.ActionResult;
import jnpf.constant.MsgCode;
import jnpf.onlinedev.entity.VisualPersonalEntity;
import jnpf.onlinedev.model.personalList.VisualPersPagiantion;
import jnpf.onlinedev.model.personalList.VisualPersonalForm;
import jnpf.onlinedev.model.personalList.VisualPersonalInfo;
import jnpf.onlinedev.service.VisualPersonalService;
import jnpf.util.JsonUtil;
import jnpf.util.RandomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5728\u7ebf\u5f00\u53d1\u4e2a\u6027\u5316\u5217\u8868", description="OnlinePersonal")
@RestController
@RequestMapping(value={"/api/visualdev/personal"})
public class VisualPersonalController {
    private static final Logger log = LoggerFactory.getLogger(VisualPersonalController.class);
    @Autowired
    private VisualPersonalService visualPersonalService;

    @Operation(summary="\u5217\u8868")
    @Parameters(value={@Parameter(name="menuId", description="\u83dc\u5355id")})
    @GetMapping
    public ActionResult getList(VisualPersPagiantion pagiantion) {
        StpUtil.checkPermissionOr((String[])new String[]{pagiantion.getMenuId()});
        List listVo = this.visualPersonalService.getListVo(pagiantion.getMenuId());
        return ActionResult.success((Object)listVo);
    }

    @Operation(summary="\u65b0\u5efa")
    @Parameters(value={@Parameter(name="form", description="\u4e2a\u6027\u5316\u5217\u8868\u89c6\u56fe\u8868\u5355")})
    @PostMapping
    public ActionResult create(@RequestBody VisualPersonalForm form) {
        StpUtil.checkPermissionOr((String[])new String[]{form.getMenuId()});
        VisualPersonalEntity entity = (VisualPersonalEntity)JsonUtil.getJsonToBean((Object)form, VisualPersonalEntity.class);
        if (ObjectUtil.isEmpty((Object)form.getId()) || "systemId".equals(form.getId())) {
            if (form.getFullName().length() > 6) {
                return ActionResult.fail((String)MsgCode.EXIST005.get(new Object[0]));
            }
            if (this.visualPersonalService.isExistByFullName(form.getFullName(), null, form.getMenuId())) {
                return ActionResult.fail((String)MsgCode.EXIST001.get(new Object[0]));
            }
            List list = this.visualPersonalService.getList(form.getMenuId());
            if (list.size() >= 5) {
                return ActionResult.fail((String)MsgCode.VS028.get(new Object[0]));
            }
            entity.setId((Object)RandomUtil.uuId());
            entity.setStatus(Integer.valueOf(0));
            entity.setType(Integer.valueOf(1));
            this.visualPersonalService.save((Object)entity);
        }
        return ActionResult.success((String)MsgCode.SU001.get(new Object[0]), (Object)((String)entity.getId()));
    }

    @Operation(summary="\u8be6\u60c5")
    @Parameters(value={@Parameter(name="id", description="\u4e2a\u6027\u5316id"), @Parameter(name="menuId", description="\u83dc\u5355id")})
    @GetMapping(value={"/{id}"})
    public ActionResult info(@PathVariable(value="id") String id, VisualPersPagiantion pagiantion) {
        StpUtil.checkPermissionOr((String[])new String[]{pagiantion.getMenuId()});
        VisualPersonalInfo info = this.visualPersonalService.getInfo(id);
        return ActionResult.success((Object)info);
    }

    @Operation(summary="\u4fee\u6539")
    @Parameters(value={@Parameter(name="id", description="\u89c6\u56feid"), @Parameter(name="form", description="\u8868\u5355\u6570\u636e")})
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody VisualPersonalForm form) {
        StpUtil.checkPermissionOr((String[])new String[]{form.getMenuId()});
        if (this.visualPersonalService.getById((Serializable)((Object)id)) != null) {
            if (form.getFullName().length() > 6) {
                return ActionResult.fail((String)MsgCode.EXIST005.get(new Object[0]));
            }
            if (this.visualPersonalService.isExistByFullName(form.getFullName(), id, form.getMenuId())) {
                return ActionResult.fail((String)MsgCode.EXIST001.get(new Object[0]));
            }
            VisualPersonalEntity entity = (VisualPersonalEntity)JsonUtil.getJsonToBean((Object)form, VisualPersonalEntity.class);
            boolean b = this.visualPersonalService.updateById((Object)entity);
            if (b) {
                return ActionResult.success((String)MsgCode.SU004.get(new Object[0]));
            }
        }
        return ActionResult.success((String)MsgCode.FA002.get(new Object[0]));
    }

    @Operation(summary="\u8bbe\u7f6e\u9ed8\u8ba4")
    @Parameters(value={@Parameter(name="id", description="\u89c6\u56feid"), @Parameter(name="menuId", description="\u83dc\u5355id")})
    @PutMapping(value={"/{id}/setDefault"})
    public ActionResult updateStatus(@PathVariable(value="id") String id, VisualPersPagiantion pagiantion) {
        StpUtil.checkPermissionOr((String[])new String[]{pagiantion.getMenuId()});
        List list = this.visualPersonalService.getList(pagiantion.getMenuId());
        for (VisualPersonalEntity entity : list) {
            if (((String)entity.getId()).equals(id)) {
                entity.setStatus(Integer.valueOf(1));
                continue;
            }
            entity.setStatus(Integer.valueOf(0));
        }
        boolean b = this.visualPersonalService.updateBatchById((Collection)list);
        if (b) {
            return ActionResult.success((String)MsgCode.SU004.get(new Object[0]));
        }
        return ActionResult.success((String)MsgCode.FA002.get(new Object[0]));
    }

    @Operation(summary="\u5220\u9664")
    @Parameters(value={@Parameter(name="id", description="\u89c6\u56feid"), @Parameter(name="menuId", description="\u83dc\u5355id")})
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id, VisualPersPagiantion pagiantion) {
        boolean b;
        StpUtil.checkPermissionOr((String[])new String[]{pagiantion.getMenuId()});
        if (this.visualPersonalService.getById((Serializable)((Object)id)) != null && (b = this.visualPersonalService.removeById((Serializable)((Object)id)))) {
            return ActionResult.success((String)MsgCode.SU003.get(new Object[0]));
        }
        return ActionResult.success((String)MsgCode.FA003.get(new Object[0]));
    }
}

