/*
 * Decompiled with CFR 0.152.
 */
package jnpf.onlinedev.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import jnpf.base.ActionResult;
import jnpf.base.vo.PageListVO;
import jnpf.base.vo.PaginationVO;
import jnpf.onlinedev.entity.VisualLogEntity;
import jnpf.onlinedev.model.log.VisualLogPage;
import jnpf.onlinedev.model.log.VisualLogVo;
import jnpf.onlinedev.service.VisualLogService;
import jnpf.permission.entity.UserEntity;
import jnpf.permission.service.UserService;
import jnpf.util.DateUtil;
import jnpf.util.JsonUtil;
import jnpf.util.UploaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5728\u7ebf\u5f00\u53d1\u6570\u636e\u65e5\u5fd7", description="OnlineLog")
@RestController
@RequestMapping(value={"/api/visualdev/OnlineLog"})
public class VisualLogController {
    private static final Logger log = LoggerFactory.getLogger(VisualLogController.class);
    @Autowired
    private VisualLogService visualLogService;
    @Autowired
    private UserService userService;

    @Operation(summary="\u5217\u8868")
    @GetMapping
    public ActionResult<PageListVO<VisualLogVo>> list(VisualLogPage page) {
        List list = this.visualLogService.getList(page);
        List userId = list.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList());
        List userList = this.userService.getUserName(userId);
        ArrayList<VisualLogVo> listVo = new ArrayList<VisualLogVo>();
        for (VisualLogEntity entity : list) {
            VisualLogVo vo = (VisualLogVo)JsonUtil.getJsonToBean((Object)entity, VisualLogVo.class);
            UserEntity userEntity = userList.stream().filter(t -> vo.getCreatorUserId().equals(t.getId())).findFirst().orElse(null);
            if (userEntity != null) {
                vo.setCreatorUserName(userEntity.getRealName());
                vo.setHeadIcon(UploaderUtil.uploaderImg((String)userEntity.getHeadIcon()));
            }
            vo.setCreatorTime(DateUtil.dateToString((Date)entity.getCreatorTime(), (String)"yyyy-MM-dd HH:mm"));
            listVo.add(vo);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)page, PaginationVO.class);
        return ActionResult.page(listVo, (PaginationVO)paginationVO);
    }
}

