/*
 * Decompiled with CFR 0.152.
 */
package jnpf.onlinedev.util.onlineDevUtil;

import cn.hutool.core.util.ObjectUtil;
import java.util.ArrayList;
import java.util.List;
import jnpf.database.model.superQuery.SuperQueryJsonModel;
import jnpf.emnus.SearchMethodEnum;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.config.ConfigModel;
import jnpf.onlinedev.util.onlineDevUtil.OnlineProductSqlUtils;
import jnpf.permission.model.authorize.OnlineDynamicSqlModel;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.DerivedColumn;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.VisitableCondition;

public class OnlineQuerySqlUtils {
    private SearchMethodEnum symbol;
    private boolean and;
    private String jnpfKey;
    private String vModel;
    private Object fieldValue;
    private Object fieldValueTwo;
    private VisitableCondition sqlCondition = null;
    private BindableColumn<Object> sqlColumn = null;
    private List<AndOrCriteriaGroup> groupList = new ArrayList<AndOrCriteriaGroup>();
    private boolean isSqlServer = false;
    private boolean isOracle = false;
    private boolean isAddMatchLogic = false;
    private List<String> dataList = new ArrayList<String>();

    public List<AndOrCriteriaGroup> getSuperSql(List<SuperQueryJsonModel> conditionList, List<OnlineDynamicSqlModel> sqlModelList, String databaseProductName, String matchLogic) {
        this.isSqlServer = databaseProductName.equalsIgnoreCase("Microsoft SQL Server");
        this.isOracle = databaseProductName.equalsIgnoreCase("oracle");
        this.isAddMatchLogic = SearchMethodEnum.And.getSymbol().equalsIgnoreCase(matchLogic);
        ArrayList<AndOrCriteriaGroup> groupQueryList = new ArrayList<AndOrCriteriaGroup>();
        OnlineProductSqlUtils.superList(conditionList, false);
        for (SuperQueryJsonModel queryJsonModel : conditionList) {
            List fieLdsModelList = queryJsonModel.getGroups();
            String logic = queryJsonModel.getLogic();
            this.and = SearchMethodEnum.And.getSymbol().equalsIgnoreCase(logic);
            ArrayList<AndOrCriteriaGroup> groupListAll = new ArrayList<AndOrCriteriaGroup>();
            for (FieLdsModel fieLdsModel : fieLdsModelList) {
                String tableName;
                ConfigModel config = fieLdsModel.getConfig();
                this.sqlCondition = null;
                this.sqlColumn = null;
                this.groupList = new ArrayList<AndOrCriteriaGroup>();
                this.jnpfKey = config.getJnpfKey();
                this.symbol = SearchMethodEnum.getSearchMethod((String)fieLdsModel.getSymbol());
                this.vModel = fieLdsModel.getVModel();
                this.fieldValue = fieLdsModel.getFieldValueOne();
                this.fieldValueTwo = fieLdsModel.getFieldValueTwo();
                this.dataList = fieLdsModel.getDataList();
                String string = tableName = ObjectUtil.isNotEmpty((Object)config.getRelationTable()) ? config.getRelationTable() : config.getTableName();
                OnlineDynamicSqlModel onlineDynamicSqlModel = sqlModelList.stream().filter(sql -> sql.getTableName().equals(tableName)).findFirst().orElse(null);
                if (onlineDynamicSqlModel == null) continue;
                this.getSymbolWrapper(onlineDynamicSqlModel);
                groupListAll.addAll(this.groupList);
            }
            if (groupListAll.size() <= 0) continue;
            if (this.isAddMatchLogic) {
                groupQueryList.add(SqlBuilder.and((BindableColumn)DerivedColumn.of((String)"1"), (VisitableCondition)SqlBuilder.isEqualTo((Object)(this.and ? 1 : 2)), (AndOrCriteriaGroup[])groupListAll.toArray(new AndOrCriteriaGroup[groupListAll.size()])));
                continue;
            }
            groupQueryList.add(SqlBuilder.or((BindableColumn)DerivedColumn.of((String)"1"), (VisitableCondition)SqlBuilder.isEqualTo((Object)(this.and ? 1 : 2)), (AndOrCriteriaGroup[])groupListAll.toArray(new AndOrCriteriaGroup[groupListAll.size()])));
        }
        return groupQueryList;
    }

    private void getSymbolWrapper(OnlineDynamicSqlModel onlineDynamicSqlModel) {
        SqlTable sqlTable = onlineDynamicSqlModel.getSqlTable();
        this.sqlColumn = sqlTable.column(this.vModel);
        ArrayList<AndOrCriteriaGroup> list = new ArrayList<AndOrCriteriaGroup>();
        switch (this.symbol) {
            case IsNull: {
                this.sqlCondition = SqlBuilder.isNull();
                list.add(SqlBuilder.and((BindableColumn)sqlTable.column(this.vModel), (VisitableCondition)this.sqlCondition, (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                break;
            }
            case IsNotNull: {
                this.sqlCondition = SqlBuilder.isNotNull();
                list.add(SqlBuilder.and((BindableColumn)sqlTable.column(this.vModel), (VisitableCondition)this.sqlCondition, (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                break;
            }
            case Equal: {
                this.sqlCondition = SqlBuilder.isEqualTo((Object)this.fieldValue);
                list.add(SqlBuilder.and((BindableColumn)sqlTable.column(this.vModel), (VisitableCondition)this.sqlCondition, (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                break;
            }
            case NotEqual: {
                this.sqlCondition = SqlBuilder.isNotEqualTo((Object)this.fieldValue);
                list.add(SqlBuilder.and((BindableColumn)sqlTable.column(this.vModel), (VisitableCondition)this.sqlCondition, (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                break;
            }
            case GreaterThan: {
                this.sqlCondition = SqlBuilder.isGreaterThan((Object)this.fieldValue);
                list.add(SqlBuilder.and((BindableColumn)sqlTable.column(this.vModel), (VisitableCondition)this.sqlCondition, (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                break;
            }
            case LessThan: {
                this.sqlCondition = SqlBuilder.isLessThan((Object)this.fieldValue);
                list.add(SqlBuilder.and((BindableColumn)sqlTable.column(this.vModel), (VisitableCondition)this.sqlCondition, (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                break;
            }
            case GreaterThanOrEqual: {
                this.sqlCondition = SqlBuilder.isGreaterThanOrEqualTo((Object)this.fieldValue);
                list.add(SqlBuilder.and((BindableColumn)sqlTable.column(this.vModel), (VisitableCondition)this.sqlCondition, (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                break;
            }
            case LessThanOrEqual: {
                this.sqlCondition = SqlBuilder.isLessThanOrEqualTo((Object)this.fieldValue);
                list.add(SqlBuilder.and((BindableColumn)sqlTable.column(this.vModel), (VisitableCondition)this.sqlCondition, (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                break;
            }
            case Like: {
                if (this.isSqlServer) {
                    this.fieldValue = String.valueOf(this.fieldValue).replaceAll("\\[", "[[]");
                }
                this.sqlCondition = SqlBuilder.isLike((Object)("%" + String.valueOf(this.fieldValue) + "%"));
                list.add(SqlBuilder.and((BindableColumn)sqlTable.column(this.vModel), (VisitableCondition)this.sqlCondition, (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                break;
            }
            case NotLike: {
                if (this.isSqlServer) {
                    this.fieldValue = String.valueOf(this.fieldValue).replaceAll("\\[", "[[]");
                }
                this.sqlCondition = SqlBuilder.isNotLike((Object)("%" + String.valueOf(this.fieldValue) + "%"));
                list.add(SqlBuilder.and((BindableColumn)sqlTable.column(this.vModel), (VisitableCondition)this.sqlCondition, (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                break;
            }
            case Included: 
            case NotIncluded: {
                this.getInWrapper(sqlTable, list);
                break;
            }
            case Between: {
                this.sqlCondition = (VisitableCondition)SqlBuilder.isBetween((Object)this.fieldValue).and(this.fieldValueTwo);
                list.add(SqlBuilder.and((BindableColumn)sqlTable.column(this.vModel), (VisitableCondition)((VisitableCondition)SqlBuilder.isBetween((Object)this.fieldValue).and(this.fieldValueTwo)), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                break;
            }
        }
        if (list.size() > 0) {
            int n = 1;
            if (this.symbol.equals((Object)SearchMethodEnum.Included)) {
                n = 2;
            }
            if (this.and) {
                this.groupList.add(SqlBuilder.and((BindableColumn)DerivedColumn.of((String)"1"), (VisitableCondition)SqlBuilder.isEqualTo((Object)n), (AndOrCriteriaGroup[])list.toArray(new AndOrCriteriaGroup[list.size()])));
            } else {
                this.groupList.add(SqlBuilder.or((BindableColumn)DerivedColumn.of((String)"1"), (VisitableCondition)SqlBuilder.isEqualTo((Object)n), (AndOrCriteriaGroup[])list.toArray(new AndOrCriteriaGroup[list.size()])));
            }
        }
    }

    private void getInWrapper(SqlTable sqlTable, List<AndOrCriteriaGroup> list) {
        block3: for (String value : this.dataList) {
            if (this.isSqlServer) {
                value = String.valueOf(value).replaceAll("\\[", "[[]");
            }
            switch (this.symbol) {
                case Included: {
                    this.sqlCondition = SqlBuilder.isLike((Object)("%" + value + "%"));
                    list.add(SqlBuilder.or((BindableColumn)sqlTable.column(this.vModel), (VisitableCondition)SqlBuilder.isLike((Object)("%" + value + "%")), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                    continue block3;
                }
            }
            this.sqlCondition = SqlBuilder.isNotLike((Object)("%" + value + "%"));
            list.add(SqlBuilder.and((BindableColumn)sqlTable.column(this.vModel), (VisitableCondition)SqlBuilder.isNotLike((Object)("%" + value + "%")), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
        }
    }

    public SearchMethodEnum getSymbol() {
        return this.symbol;
    }

    public boolean isAnd() {
        return this.and;
    }

    public String getJnpfKey() {
        return this.jnpfKey;
    }

    public String getVModel() {
        return this.vModel;
    }

    public Object getFieldValue() {
        return this.fieldValue;
    }

    public Object getFieldValueTwo() {
        return this.fieldValueTwo;
    }

    public VisitableCondition getSqlCondition() {
        return this.sqlCondition;
    }

    public BindableColumn<Object> getSqlColumn() {
        return this.sqlColumn;
    }

    public List<AndOrCriteriaGroup> getGroupList() {
        return this.groupList;
    }

    public boolean isSqlServer() {
        return this.isSqlServer;
    }

    public boolean isOracle() {
        return this.isOracle;
    }

    public boolean isAddMatchLogic() {
        return this.isAddMatchLogic;
    }

    public List<String> getDataList() {
        return this.dataList;
    }

    public void setSymbol(SearchMethodEnum symbol) {
        this.symbol = symbol;
    }

    public void setAnd(boolean and) {
        this.and = and;
    }

    public void setJnpfKey(String jnpfKey) {
        this.jnpfKey = jnpfKey;
    }

    public void setVModel(String vModel) {
        this.vModel = vModel;
    }

    public void setFieldValue(Object fieldValue) {
        this.fieldValue = fieldValue;
    }

    public void setFieldValueTwo(Object fieldValueTwo) {
        this.fieldValueTwo = fieldValueTwo;
    }

    public void setSqlCondition(VisitableCondition sqlCondition) {
        this.sqlCondition = sqlCondition;
    }

    public void setSqlColumn(BindableColumn<Object> sqlColumn) {
        this.sqlColumn = sqlColumn;
    }

    public void setGroupList(List<AndOrCriteriaGroup> groupList) {
        this.groupList = groupList;
    }

    public void setSqlServer(boolean isSqlServer) {
        this.isSqlServer = isSqlServer;
    }

    public void setOracle(boolean isOracle) {
        this.isOracle = isOracle;
    }

    public void setAddMatchLogic(boolean isAddMatchLogic) {
        this.isAddMatchLogic = isAddMatchLogic;
    }

    public void setDataList(List<String> dataList) {
        this.dataList = dataList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OnlineQuerySqlUtils)) {
            return false;
        }
        OnlineQuerySqlUtils other = (OnlineQuerySqlUtils)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAnd() != other.isAnd()) {
            return false;
        }
        if (this.isSqlServer() != other.isSqlServer()) {
            return false;
        }
        if (this.isOracle() != other.isOracle()) {
            return false;
        }
        if (this.isAddMatchLogic() != other.isAddMatchLogic()) {
            return false;
        }
        SearchMethodEnum this$symbol = this.getSymbol();
        SearchMethodEnum other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        String this$jnpfKey = this.getJnpfKey();
        String other$jnpfKey = other.getJnpfKey();
        if (this$jnpfKey == null ? other$jnpfKey != null : !this$jnpfKey.equals(other$jnpfKey)) {
            return false;
        }
        String this$vModel = this.getVModel();
        String other$vModel = other.getVModel();
        if (this$vModel == null ? other$vModel != null : !this$vModel.equals(other$vModel)) {
            return false;
        }
        Object this$fieldValue = this.getFieldValue();
        Object other$fieldValue = other.getFieldValue();
        if (this$fieldValue == null ? other$fieldValue != null : !this$fieldValue.equals(other$fieldValue)) {
            return false;
        }
        Object this$fieldValueTwo = this.getFieldValueTwo();
        Object other$fieldValueTwo = other.getFieldValueTwo();
        if (this$fieldValueTwo == null ? other$fieldValueTwo != null : !this$fieldValueTwo.equals(other$fieldValueTwo)) {
            return false;
        }
        VisitableCondition this$sqlCondition = this.getSqlCondition();
        VisitableCondition other$sqlCondition = other.getSqlCondition();
        if (this$sqlCondition == null ? other$sqlCondition != null : !this$sqlCondition.equals(other$sqlCondition)) {
            return false;
        }
        BindableColumn<Object> this$sqlColumn = this.getSqlColumn();
        BindableColumn<Object> other$sqlColumn = other.getSqlColumn();
        if (this$sqlColumn == null ? other$sqlColumn != null : !this$sqlColumn.equals(other$sqlColumn)) {
            return false;
        }
        List<AndOrCriteriaGroup> this$groupList = this.getGroupList();
        List<AndOrCriteriaGroup> other$groupList = other.getGroupList();
        if (this$groupList == null ? other$groupList != null : !((Object)this$groupList).equals(other$groupList)) {
            return false;
        }
        List<String> this$dataList = this.getDataList();
        List<String> other$dataList = other.getDataList();
        return !(this$dataList == null ? other$dataList != null : !((Object)this$dataList).equals(other$dataList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OnlineQuerySqlUtils;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAnd() ? 79 : 97);
        result = result * 59 + (this.isSqlServer() ? 79 : 97);
        result = result * 59 + (this.isOracle() ? 79 : 97);
        result = result * 59 + (this.isAddMatchLogic() ? 79 : 97);
        SearchMethodEnum $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        String $jnpfKey = this.getJnpfKey();
        result = result * 59 + ($jnpfKey == null ? 43 : $jnpfKey.hashCode());
        String $vModel = this.getVModel();
        result = result * 59 + ($vModel == null ? 43 : $vModel.hashCode());
        Object $fieldValue = this.getFieldValue();
        result = result * 59 + ($fieldValue == null ? 43 : $fieldValue.hashCode());
        Object $fieldValueTwo = this.getFieldValueTwo();
        result = result * 59 + ($fieldValueTwo == null ? 43 : $fieldValueTwo.hashCode());
        VisitableCondition $sqlCondition = this.getSqlCondition();
        result = result * 59 + ($sqlCondition == null ? 43 : $sqlCondition.hashCode());
        BindableColumn<Object> $sqlColumn = this.getSqlColumn();
        result = result * 59 + ($sqlColumn == null ? 43 : $sqlColumn.hashCode());
        List<AndOrCriteriaGroup> $groupList = this.getGroupList();
        result = result * 59 + ($groupList == null ? 43 : ((Object)$groupList).hashCode());
        List<String> $dataList = this.getDataList();
        result = result * 59 + ($dataList == null ? 43 : ((Object)$dataList).hashCode());
        return result;
    }

    public String toString() {
        return "OnlineQuerySqlUtils(symbol=" + String.valueOf(this.getSymbol()) + ", and=" + this.isAnd() + ", jnpfKey=" + this.getJnpfKey() + ", vModel=" + this.getVModel() + ", fieldValue=" + String.valueOf(this.getFieldValue()) + ", fieldValueTwo=" + String.valueOf(this.getFieldValueTwo()) + ", sqlCondition=" + String.valueOf(this.getSqlCondition()) + ", sqlColumn=" + String.valueOf(this.getSqlColumn()) + ", groupList=" + String.valueOf(this.getGroupList()) + ", isSqlServer=" + this.isSqlServer() + ", isOracle=" + this.isOracle() + ", isAddMatchLogic=" + this.isAddMatchLogic() + ", dataList=" + String.valueOf(this.getDataList()) + ")";
    }
}

