/*
 * Decompiled with CFR 0.152.
 */
package jnpf.onlinedev.util.onlineDevUtil;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import jnpf.base.entity.DataInterfaceEntity;
import jnpf.base.entity.VisualdevEntity;
import jnpf.base.entity.VisualdevReleaseEntity;
import jnpf.base.model.ColumnDataModel;
import jnpf.base.model.Template6.ColumnListField;
import jnpf.base.model.VisualDevJsonModel;
import jnpf.base.model.VisualWebTypeEnum;
import jnpf.constant.MsgCode;
import jnpf.database.model.superQuery.SuperJsonModel;
import jnpf.database.model.superQuery.SuperQueryJsonModel;
import jnpf.exception.WorkFlowException;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.FormDataModel;
import jnpf.model.visualJson.TableModel;
import jnpf.model.visualJson.analysis.FormEnum;
import jnpf.model.visualJson.analysis.FormModel;
import jnpf.model.visualJson.config.ConfigModel;
import jnpf.onlinedev.model.OnlineDevEnum.MultipleControlEnum;
import jnpf.util.JsonUtil;
import jnpf.util.StringUtil;
import jnpf.util.XSSEscape;
import org.apache.commons.collections4.MapUtils;

public class OnlinePublicUtils {
    public static Boolean isUseTables(String tableJson) {
        if (!StringUtil.isEmpty((String)tableJson) && !"[]".equals(tableJson)) {
            return true;
        }
        return false;
    }

    public static Map<String, Object> mapKeyToLower(Map<String, ?> requestMap) {
        if (requestMap.isEmpty()) {
            return null;
        }
        HashMap<String, Object> responseMap = new HashMap<String, Object>(16);
        Set<String> requestSet = requestMap.keySet();
        Iterator<String> iterator = requestSet.iterator();
        iterator.forEachRemaining(obj -> {
            if (requestMap.get(obj) instanceof Map) {
                responseMap.put(obj.toLowerCase(), OnlinePublicUtils.mapKeyToLower((Map)requestMap.get(obj)));
            } else {
                responseMap.put(obj.toLowerCase(), requestMap.get(obj));
            }
        });
        return responseMap;
    }

    public static Object getFirstOrNull(Map<String, Object> map) {
        Map.Entry<String, Object> entry;
        Object obj = null;
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext() && (obj = (entry = iterator.next()).getValue()) == null) {
        }
        return obj;
    }

    public static void removeUseless(List<FieLdsModel> fieldsModelList) {
        for (int i = 0; i < fieldsModelList.size(); ++i) {
            if (fieldsModelList.get(i).getConfig().getJnpfKey() != null && !fieldsModelList.get(i).getConfig().getJnpfKey().equals("table")) continue;
        }
    }

    public static void recursionFields(List<FieLdsModel> allFields, List<FieLdsModel> fieLdsModelList) {
        for (FieLdsModel fieLdsModel : fieLdsModelList) {
            ConfigModel config = fieLdsModel.getConfig();
            String jnpfKey = config.getJnpfKey();
            if ("table".equals(jnpfKey)) {
                allFields.add(fieLdsModel);
                continue;
            }
            if (config.getChildren() != null) {
                OnlinePublicUtils.recursionFields(allFields, config.getChildren());
                continue;
            }
            if (jnpfKey == null) continue;
            allFields.add(fieLdsModel);
        }
    }

    public static Boolean getMultiple(String var1, String var2) {
        if (var1.startsWith(var2)) {
            return true;
        }
        return false;
    }

    public static Map<String, Object> getDataMap(List<Map<String, Object>> dataList, FieLdsModel swapModel) {
        String label = swapModel.getProps() != null ? swapModel.getProps().getLabel() : "";
        String value = swapModel.getProps() != null ? swapModel.getProps().getValue() : "";
        HashMap<String, Object> dataInterfaceMap = new HashMap<String, Object>();
        dataList.stream().forEach(data -> dataInterfaceMap.put(String.valueOf(data.get(value)), String.valueOf(data.get(label))));
        return dataInterfaceMap;
    }

    public static String getDateByFormat(Long date, String format) {
        DateTimeFormatter ftf = DateTimeFormatter.ofPattern(format);
        String dateString = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(date), ZoneId.of("+8")));
        return dateString;
    }

    public static void recurseFiled(List<FieLdsModel> modelList, List<FieLdsModel> mainFields, List<FieLdsModel> childFields, List<FormModel> models) {
        for (FieLdsModel fieLdsModel : modelList) {
            ConfigModel config = fieLdsModel.getConfig();
            String jnpfkey = config.getJnpfKey();
            List childrenList = config.getChildren();
            boolean isJnpfKey = StringUtil.isEmpty((String)jnpfkey);
            ArrayList keyList = new ArrayList(){
                {
                    this.add(FormEnum.collapseItem.getMessage());
                    this.add(FormEnum.collapseItem.getMessage());
                    this.add(FormEnum.row.getMessage());
                    this.add(FormEnum.card.getMessage());
                    this.add(FormEnum.tab.getMessage());
                    this.add(FormEnum.collapse.getMessage());
                    this.add(FormEnum.tableGrid.getMessage());
                    this.add(FormEnum.tableGridTr.getMessage());
                    this.add(FormEnum.tableGridTd.getMessage());
                }
            };
            if (keyList.contains(jnpfkey) || isJnpfKey) {
                if (childrenList.size() > 0) {
                    OnlinePublicUtils.recurseFiled(childrenList, mainFields, childFields, models);
                    continue;
                }
                mainFields.add(fieLdsModel);
                continue;
            }
            if (FormEnum.table.getMessage().equals(jnpfkey)) {
                childFields.add(fieLdsModel);
                continue;
            }
            if (FormEnum.groupTitle.getMessage().equals(jnpfkey) || FormEnum.divider.getMessage().equals(jnpfkey) || FormEnum.JNPFText.getMessage().equals(jnpfkey)) continue;
            if (FormEnum.QR_CODE.getMessage().equals(jnpfkey) || FormEnum.BARCODE.getMessage().equals(jnpfkey)) {
                FormModel formModel = (FormModel)JsonUtil.getJsonToBean((Object)fieLdsModel, FormModel.class);
                models.add(formModel);
                continue;
            }
            mainFields.add(fieLdsModel);
        }
    }

    public static void recursionFormFields(List<FieLdsModel> allFields, List<FieLdsModel> fieLdsModelList) {
        for (FieLdsModel fieLdsModel : fieLdsModelList) {
            ConfigModel config = fieLdsModel.getConfig();
            String jnpfKey = config.getJnpfKey();
            if ("table".equals(jnpfKey)) {
                allFields.add(fieLdsModel);
                continue;
            }
            if (config.getChildren() != null) {
                OnlinePublicUtils.recursionFormFields(allFields, config.getChildren());
                continue;
            }
            allFields.add(fieLdsModel);
        }
    }

    public static void recursionFormChildFields(List<FieLdsModel> allFields, List<FieLdsModel> fieLdsModelList) {
        for (FieLdsModel fieLdsModel : fieLdsModelList) {
            ConfigModel config = fieLdsModel.getConfig();
            String jnpfKey = config.getJnpfKey();
            if ("table".equals(jnpfKey)) {
                String childVmodel = fieLdsModel.getVModel();
                for (FieLdsModel child : (List)Optional.ofNullable(fieLdsModel.getConfig().getChildren()).orElse(new ArrayList())) {
                    if (child.getVModel() == null) continue;
                    child.setVModel(childVmodel + "-" + child.getVModel());
                    allFields.add(child);
                }
                continue;
            }
            if (config.getChildren() != null) {
                OnlinePublicUtils.recursionFormChildFields(allFields, config.getChildren());
                continue;
            }
            if (!StringUtil.isNotEmpty((String)fieLdsModel.getVModel())) continue;
            allFields.add(fieLdsModel);
        }
    }

    public static void recurseOnlineFiled(List<FieLdsModel> modelList, List<FieLdsModel> mainFields, List<FieLdsModel> childFields) {
        for (FieLdsModel fieLdsModel : modelList) {
            ConfigModel config = fieLdsModel.getConfig();
            String jnpfkey = config.getJnpfKey();
            List childrenList = config.getChildren();
            boolean isJnpfKey = StringUtil.isEmpty((String)jnpfkey);
            if (FormEnum.row.getMessage().equals(jnpfkey) || FormEnum.card.getMessage().equals(jnpfkey) || FormEnum.tab.getMessage().equals(jnpfkey) || FormEnum.collapse.getMessage().equals(jnpfkey) || isJnpfKey) {
                if (childrenList.size() > 0) {
                    OnlinePublicUtils.recurseOnlineFiled(childrenList, mainFields, childFields);
                    continue;
                }
                mainFields.add(fieLdsModel);
                continue;
            }
            if (FormEnum.table.getMessage().equals(jnpfkey)) {
                childFields.add(fieLdsModel);
                continue;
            }
            if (FormEnum.groupTitle.getMessage().equals(jnpfkey) || FormEnum.divider.getMessage().equals(jnpfkey) || FormEnum.JNPFText.getMessage().equals(jnpfkey)) continue;
            mainFields.add(fieLdsModel);
        }
    }

    public static String getDataInMethod(Map<String, Object> redisMap, Object modelData, Boolean isMultiple) {
        String s2;
        String Separator;
        if (redisMap == null || redisMap.isEmpty()) {
            return modelData.toString();
        }
        String string = Separator = isMultiple != false ? ";" : "/";
        if (OnlinePublicUtils.getMultiple(String.valueOf(modelData), MultipleControlEnum.MULTIPLE_JSON_TWO.getMultipleChar()).booleanValue()) {
            String[][] data = (String[][])JsonUtil.getJsonToBean((String)String.valueOf(modelData), String[][].class);
            ArrayList<String> addList = new ArrayList<String>();
            for (String[] AddressData : data) {
                ArrayList<String> adList = new ArrayList<String>();
                for (String s3 : AddressData) {
                    adList.add(String.valueOf(redisMap.get(s3)));
                }
                addList.add(String.join((CharSequence)"/", adList));
            }
            s2 = String.join((CharSequence)";", addList);
        } else if (OnlinePublicUtils.getMultiple(String.valueOf(modelData), MultipleControlEnum.MULTIPLE_JSON_ONE.getMultipleChar()).booleanValue()) {
            List modelDataList = JsonUtil.getJsonToList((String)String.valueOf(modelData), String.class);
            modelDataList = modelDataList.stream().map(s -> String.valueOf(redisMap.get(s))).collect(Collectors.toList());
            s2 = String.join((CharSequence)Separator, modelDataList);
        } else {
            String[] modelDatas = String.valueOf(modelData).split(",");
            StringBuilder dynamicData = new StringBuilder();
            for (int i = 0; i < modelDatas.length; ++i) {
                modelDatas[i] = String.valueOf(Objects.nonNull(redisMap.get(modelDatas[i])) ? redisMap.get(modelDatas[i]) : "");
                dynamicData.append(modelDatas[i] + Separator);
            }
            s2 = dynamicData.deleteCharAt(dynamicData.length() - 1).toString();
        }
        return StringUtil.isEmpty((String)s2) ? modelData.toString() : s2;
    }

    public static List<String> getDataNoSwapInMethod(Object modelData) {
        ArrayList<String> dataValueList = new ArrayList();
        if (OnlinePublicUtils.getMultiple(String.valueOf(modelData), MultipleControlEnum.MULTIPLE_JSON_ONE.getMultipleChar()).booleanValue()) {
            List modelDataList = JsonUtil.getJsonToList((String)String.valueOf(modelData), String.class);
            dataValueList = modelDataList;
        } else {
            String[] modelDatas = String.valueOf(modelData).split(",");
            for (int i = 0; i < modelDatas.length; ++i) {
                dataValueList.add(modelDatas[i]);
            }
        }
        return dataValueList;
    }

    public static VisualDevJsonModel getVisualJsonModel(VisualdevEntity entity) {
        VisualDevJsonModel jsonModel = new VisualDevJsonModel();
        if (entity.getColumnData() != null) {
            jsonModel.setColumnData((ColumnDataModel)JsonUtil.getJsonToBean((String)entity.getColumnData(), ColumnDataModel.class));
        }
        if (entity.getAppColumnData() != null) {
            jsonModel.setAppColumnData((ColumnDataModel)JsonUtil.getJsonToBean((String)entity.getAppColumnData(), ColumnDataModel.class));
        }
        FormDataModel formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFormData(), FormDataModel.class);
        jsonModel.setFormData(formDataModel);
        if (!VisualWebTypeEnum.DATA_VIEW.getType().equals(entity.getWebType())) {
            jsonModel.setFormListModels(JsonUtil.getJsonToList((String)formDataModel.getFields(), FieLdsModel.class));
        }
        jsonModel.setVisualTables(JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class));
        jsonModel.setId((String)entity.getId());
        jsonModel.setDbLinkId(entity.getDbLinkId());
        jsonModel.setFullName(entity.getFullName());
        jsonModel.setType(entity.getType());
        jsonModel.setWebType(entity.getWebType());
        return jsonModel;
    }

    public static VisualDevJsonModel getVisualJsonModel(VisualdevReleaseEntity entity) throws WorkFlowException {
        if (entity == null) {
            throw new WorkFlowException(MsgCode.VS412.get(new Object[0]));
        }
        VisualDevJsonModel jsonModel = new VisualDevJsonModel();
        if (entity.getColumnData() != null) {
            jsonModel.setColumnData((ColumnDataModel)JsonUtil.getJsonToBean((String)entity.getColumnData(), ColumnDataModel.class));
        }
        if (entity.getAppColumnData() != null) {
            jsonModel.setAppColumnData((ColumnDataModel)JsonUtil.getJsonToBean((String)entity.getAppColumnData(), ColumnDataModel.class));
        }
        FormDataModel formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFormData(), FormDataModel.class);
        jsonModel.setFormData(formDataModel);
        if (!VisualWebTypeEnum.DATA_VIEW.getType().equals(entity.getWebType())) {
            jsonModel.setFormListModels(JsonUtil.getJsonToList((String)formDataModel.getFields(), FieLdsModel.class));
        }
        jsonModel.setVisualTables(JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class));
        jsonModel.setId((String)entity.getId());
        jsonModel.setDbLinkId(entity.getDbLinkId());
        jsonModel.setFullName(entity.getFullName());
        jsonModel.setType(entity.getType());
        jsonModel.setWebType(entity.getWebType());
        return jsonModel;
    }

    public static List<Map<String, Object>> toLowerKeyList(List<Map<String, Object>> mapList) {
        ArrayList<Map<String, Object>> newMapList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : mapList) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
            Set<String> sets = map.keySet();
            for (String key : sets) {
                resultMap.put(key.toLowerCase(), map.get(key));
            }
            newMapList.add(resultMap);
        }
        return newMapList;
    }

    public static Object getDataConversion(Object value) {
        Object dataValue = OnlinePublicUtils.getDataConversion(null, value, false, "/");
        return dataValue;
    }

    public static Object getDataConversion(Map<String, Object> redis, Object value, boolean isMultiple, String separator) {
        Object dataValue;
        block10: {
            dataValue = value;
            boolean iszhuanhuan = redis != null;
            try {
                List list = JsonUtil.getJsonToList((String)String.valueOf(value), List.class);
                dataValue = list;
                if (iszhuanhuan) {
                    StringJoiner joiner = new StringJoiner(",");
                    for (List listChild : list) {
                        StringJoiner aa = new StringJoiner(separator);
                        for (Object object : listChild) {
                            String value1 = redis.get(String.valueOf(object)) != null ? String.valueOf(redis.get(String.valueOf(object))) : "";
                            if (!StringUtil.isNotEmpty((String)value1)) continue;
                            aa.add(value1);
                        }
                        joiner.add(aa.toString());
                    }
                    dataValue = joiner.toString();
                }
            }
            catch (Exception e) {
                try {
                    List list = JsonUtil.getJsonToList((String)String.valueOf(value), String.class);
                    dataValue = list;
                    if (iszhuanhuan) {
                        if (isMultiple) {
                            separator = ",";
                        }
                        StringJoiner joiner = new StringJoiner(separator);
                        for (Object listChild : list) {
                            String value1 = redis.get(String.valueOf(listChild)) != null ? String.valueOf(redis.get(String.valueOf(listChild))) : "";
                            if (!StringUtil.isNotEmpty((String)value1)) continue;
                            joiner.add(value1);
                        }
                        dataValue = joiner.toString();
                    }
                }
                catch (Exception e1) {
                    dataValue = String.valueOf(value);
                    if (!iszhuanhuan) break block10;
                    dataValue = redis.get(String.valueOf(value)) != null ? String.valueOf(redis.get(String.valueOf(value))) : "";
                }
            }
        }
        return dataValue;
    }

    public static void getViewQuerySql(DataInterfaceEntity info, List<FieLdsModel> queryCondition, Map<String, String> parameterMap, Map<String, Object> extraMap) {
        if (Objects.equals(info.getType(), 1) && queryCondition.size() > 0) {
            Object searchSqlStr = "";
            for (FieLdsModel item : queryCondition) {
                switch (item.getSearchType()) {
                    case 1: {
                        if (StringUtil.isNotEmpty((String)searchSqlStr)) {
                            searchSqlStr = (String)searchSqlStr + " and t." + item.getVModel() + " = '" + XSSEscape.escape((String)item.getFieldValue()) + "'";
                            break;
                        }
                        searchSqlStr = "t." + item.getVModel() + " = '" + XSSEscape.escape((String)item.getFieldValue()) + "'";
                        break;
                    }
                    case 2: {
                        if (StringUtil.isNotEmpty((String)searchSqlStr)) {
                            searchSqlStr = (String)searchSqlStr + " and t." + item.getVModel() + " like '%" + XSSEscape.escape((String)item.getFieldValue()) + "%'";
                            break;
                        }
                        searchSqlStr = "t." + item.getVModel() + " like '%" + XSSEscape.escape((String)item.getFieldValue()) + "%'";
                        break;
                    }
                    case 3: {
                        if (StringUtil.isNotEmpty((String)searchSqlStr)) {
                            searchSqlStr = (String)searchSqlStr + " and t." + item.getVModel() + " between '" + XSSEscape.escape((String)String.valueOf(item.getFieldValueOne())) + "' and '" + XSSEscape.escape((String)String.valueOf(item.getFieldValueTwo())) + "'";
                            break;
                        }
                        searchSqlStr = "t." + item.getVModel() + " between '" + XSSEscape.escape((String)String.valueOf(item.getFieldValueOne())) + "' and '" + XSSEscape.escape((String)String.valueOf(item.getFieldValueTwo())) + "'";
                        break;
                    }
                    case 4: {
                        List dataList = item.getDataList();
                        if (dataList.size() <= 0) break;
                        searchSqlStr = StringUtil.isNotEmpty((String)searchSqlStr) ? (String)searchSqlStr + " and (" : (String)searchSqlStr + " 1=1 and (";
                        int n = 0;
                        for (String value : dataList) {
                            searchSqlStr = n > 0 ? (String)searchSqlStr + " or t." + item.getVModel() + " like '%" + value + "%'" : (String)searchSqlStr + "t." + item.getVModel() + " like '%" + value + "%'";
                            ++n;
                        }
                        searchSqlStr = (String)searchSqlStr + ") ";
                        break;
                    }
                }
            }
            if (MapUtils.isNotEmpty(extraMap)) {
                for (String key : extraMap.keySet()) {
                    if (StringUtil.isNotEmpty((String)searchSqlStr)) {
                        searchSqlStr = (String)searchSqlStr + " and t." + key + " = '" + XSSEscape.escape((String)extraMap.get(key).toString()) + "'";
                        continue;
                    }
                    searchSqlStr = "t." + key + " = '" + XSSEscape.escape((String)extraMap.get(key).toString()) + "'";
                }
            }
            parameterMap.put("searchSqlStr", (String)searchSqlStr);
        }
    }

    public static List<Map<String, Object>> getViewQueryNotSql(DataInterfaceEntity info, List<FieLdsModel> queryCondition, List<Map<String, Object>> dataRes, Map<String, Object> extraMap) {
        boolean hasExtra = false;
        String key = "";
        if (MapUtils.isNotEmpty(extraMap)) {
            hasExtra = true;
            ArrayList<String> keyList = new ArrayList<String>(extraMap.keySet());
            key = (String)keyList.get(0);
        }
        ArrayList<Map<String, Object>> dataInterfaceList = new ArrayList<Map<String, Object>>();
        if (!Objects.equals(info.getType(), 1) && queryCondition.size() > 0) {
            for (Map<String, Object> map : dataRes) {
                if (!OnlinePublicUtils.mapCompar(queryCondition, map)) continue;
                if (hasExtra) {
                    if (!Objects.equals(map.get(key), extraMap.get(key))) continue;
                    dataInterfaceList.add(map);
                    continue;
                }
                dataInterfaceList.add(map);
            }
        } else {
            for (Map<String, Object> map : dataRes) {
                if (hasExtra) {
                    if (!Objects.equals(map.get(key), extraMap.get(key))) continue;
                    dataInterfaceList.add(map);
                    continue;
                }
                dataInterfaceList.add(map);
            }
        }
        return dataInterfaceList;
    }

    public static boolean mapCompar(List<FieLdsModel> searchList, Map<String, Object> hashMap2) {
        boolean isChange = false;
        block5: for (FieLdsModel item : searchList) {
            String realValue = hashMap2.get(item.getVModel()) == null ? "" : (String)hashMap2.get(item.getVModel());
            switch (item.getSearchType()) {
                case 2: {
                    if (realValue.indexOf(item.getFieldValue()) < 0) continue block5;
                    isChange = true;
                    break;
                }
                case 3: {
                    ArrayList longList = new ArrayList(){
                        {
                            this.add("inputNumber");
                            this.add("datePicker");
                        }
                    };
                    if (longList.contains(item.getConfig().getJnpfKey())) {
                        Long valueLong = Long.parseLong(realValue);
                        Long valueLongOne = (Long)item.getFieldValueOne();
                        Long valueLongTwo = (Long)item.getFieldValueTwo();
                        if (valueLong < valueLongOne || valueLong > valueLongTwo) continue block5;
                        isChange = true;
                        break;
                    }
                    String valueLongOne = (String)item.getFieldValueOne();
                    String valueLongTwo = (String)item.getFieldValueTwo();
                    if (realValue.compareTo(valueLongOne) < 0 || realValue.compareTo(valueLongTwo) > 0) continue block5;
                    isChange = true;
                    break;
                }
                case 4: {
                    List dataList = item.getDataList();
                    for (String value : dataList) {
                        isChange = value.indexOf(realValue) >= 0;
                    }
                    if (!isChange) continue block5;
                    return true;
                }
                default: {
                    isChange = item.getFieldValue().equals(realValue);
                }
            }
        }
        return isChange;
    }

    public static List<String> getAllTableName(List<ColumnListField> modelList, List<SuperJsonModel> listQuery, Map<String, String> fieldTableMap) {
        ArrayList<String> list = new ArrayList<String>();
        for (ColumnListField item : modelList) {
            String table;
            String string = table = StringUtil.isNotEmpty((String)item.getConfig().getRelationTable()) ? item.getConfig().getRelationTable() : item.getConfig().getTableName();
            if (StringUtil.isBlank((CharSequence)table)) {
                table = fieldTableMap.get(item.getConfig().getParentVModel());
            }
            list.add(table);
        }
        for (SuperJsonModel superJsonModel : listQuery) {
            if (superJsonModel.getConditionList() == null || superJsonModel.getConditionList().size() <= 0) continue;
            List conditionList = superJsonModel.getConditionList();
            for (SuperQueryJsonModel sqj : conditionList) {
                if (sqj.getGroups() == null || sqj.getGroups().size() <= 0) continue;
                List groups = sqj.getGroups();
                for (FieLdsModel item : groups) {
                    String table = StringUtil.isNotEmpty((String)item.getConfig().getRelationTable()) ? item.getConfig().getRelationTable() : item.getConfig().getTableName();
                    list.add(table);
                }
            }
        }
        return list.stream().distinct().collect(Collectors.toList());
    }

    public static void getAllFields(List<FieLdsModel> allFields, List<FieLdsModel> fieLdsModelList) {
        for (FieLdsModel fieLdsModel : fieLdsModelList) {
            ConfigModel config = fieLdsModel.getConfig();
            String jnpfKey = config.getJnpfKey();
            if ("table".equals(jnpfKey)) {
                allFields.addAll(config.getChildren());
                continue;
            }
            if (config.getChildren() != null) {
                OnlinePublicUtils.getAllFields(allFields, config.getChildren());
                continue;
            }
            if (!StringUtil.isNotEmpty((String)fieLdsModel.getVModel())) continue;
            allFields.add(fieLdsModel);
        }
    }
}

