/*
 * Decompiled with CFR 0.152.
 */
package jnpf.onlinedev.util.onlineDevUtil;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import jnpf.base.UserInfo;
import jnpf.base.entity.SuperBaseEntity;
import jnpf.base.model.ColumnDataModel;
import jnpf.base.model.Template6.ColumnListField;
import jnpf.base.model.VisualDevJsonModel;
import jnpf.base.util.DateTimeFormatConstant;
import jnpf.base.util.FlowFormDataUtil;
import jnpf.database.model.entity.DbLinkEntity;
import jnpf.database.model.interfaces.DbSourceOrDbLink;
import jnpf.database.model.superQuery.SuperJsonModel;
import jnpf.database.model.superQuery.SuperQueryJsonModel;
import jnpf.database.util.ConnUtil;
import jnpf.database.util.DbTypeUtil;
import jnpf.database.util.DynamicDataSourceUtil;
import jnpf.emnus.SearchMethodEnum;
import jnpf.exception.DataException;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.TableModel;
import jnpf.model.visualJson.analysis.FormAllModel;
import jnpf.model.visualJson.analysis.FormColumnModel;
import jnpf.model.visualJson.analysis.FormEnum;
import jnpf.model.visualJson.config.ConfigModel;
import jnpf.model.visualJson.config.TabConfigModel;
import jnpf.onlinedev.model.OnlineDevListModel.OnlineColumnChildFieldModel;
import jnpf.onlinedev.model.OnlineDevListModel.OnlineColumnFieldModel;
import jnpf.onlinedev.model.OnlineDevListModel.VisualColumnSearchVO;
import jnpf.onlinedev.model.PaginationModel;
import jnpf.onlinedev.util.onlineDevUtil.OnlineDatabaseUtils;
import jnpf.onlinedev.util.onlineDevUtil.OnlinePublicUtils;
import jnpf.onlinedev.util.onlineDevUtil.OnlineQuerySqlUtils;
import jnpf.onlinedev.util.onlineDevUtil.OnlineSwapDataUtils;
import jnpf.permission.entity.OrganizeEntity;
import jnpf.permission.entity.UserEntity;
import jnpf.permission.model.authorize.AuthorizeConditionEnum;
import jnpf.permission.model.authorize.OnlineDynamicSqlModel;
import jnpf.permission.service.AuthorizeService;
import jnpf.permission.service.OrganizeAdministratorService;
import jnpf.permission.service.OrganizeService;
import jnpf.permission.service.UserRelationService;
import jnpf.permission.service.UserService;
import jnpf.util.DateUtil;
import jnpf.util.JsonUtil;
import jnpf.util.StringUtil;
import jnpf.util.TableFeildsEnum;
import jnpf.util.UserProvider;
import jnpf.util.context.RequestContext;
import jnpf.util.context.SpringContext;
import jnpf.util.visiual.JnpfKeyConsts;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.DerivedColumn;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;

public class OnlineProductSqlUtils {
    private static FlowFormDataUtil flowDataUtil = (FlowFormDataUtil)SpringContext.getBean(FlowFormDataUtil.class);
    private static UserService userApi = (UserService)SpringContext.getBean(UserService.class);
    private static UserRelationService userRelationApi = (UserRelationService)SpringContext.getBean(UserRelationService.class);
    private static OrganizeService organizeApi = (OrganizeService)SpringContext.getBean(OrganizeService.class);
    private static AuthorizeService authorizeUtil = (AuthorizeService)SpringContext.getBean(AuthorizeService.class);
    private static OrganizeAdministratorService organizeAdminTratorApi = (OrganizeAdministratorService)SpringContext.getBean(OrganizeAdministratorService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getColumnListSql(List<OnlineDynamicSqlModel> sqlModels, VisualDevJsonModel visualDevJsonModel, List<String> columnFieldList, DbLinkEntity linkEntity) {
        try {
            columnFieldList = columnFieldList.stream().distinct().collect(Collectors.toList());
            ColumnDataModel columnData = visualDevJsonModel.getColumnData();
            List modelList = JsonUtil.getJsonToList((String)columnData.getColumnList(), ColumnListField.class);
            Connection conn = ConnUtil.getConnOrDefault((DbSourceOrDbLink)linkEntity);
            try {
                String groupField;
                boolean contains;
                List tableModelList = visualDevJsonModel.getVisualTables();
                String databaseProductName = conn.getMetaData().getDatabaseProductName().trim();
                boolean isClobDbType = DbTypeUtil.needToUpperCase((String)databaseProductName);
                TableModel mainTable = tableModelList.stream().filter(model -> model.getTypeId().equals("1")).findFirst().orElse(null);
                String pKeyName = flowDataUtil.getKey(mainTable, databaseProductName);
                String reg = "^[jnpf_]\\S*_jnpf\\S*";
                List<String> mainTableFields = columnFieldList.stream().filter(s -> !s.matches(reg) && !s.toLowerCase().contains("tablefield")).collect(Collectors.toList());
                mainTableFields.add(pKeyName);
                for (TableModel tableModel : tableModelList) {
                    String relationField = tableModel.getRelationField();
                    if (!StringUtil.isNotEmpty((String)relationField) || mainTableFields.contains(relationField)) continue;
                    mainTableFields.add(relationField);
                }
                if (visualDevJsonModel.getFormData().getConcurrencyLock().booleanValue()) {
                    mainTableFields.add(TableFeildsEnum.VERSION.getField());
                }
                String flowidField = TableFeildsEnum.FLOWID.getField();
                String flowTaskId = TableFeildsEnum.FLOWTASKID.getField();
                if (isClobDbType) {
                    flowidField = TableFeildsEnum.FLOWID.getField().toUpperCase();
                    flowTaskId = TableFeildsEnum.FLOWTASKID.getField().toUpperCase();
                }
                mainTableFields.add(flowidField);
                mainTableFields.add(flowTaskId);
                if (columnData != null && ObjectUtil.isNotEmpty((Object)columnData.getType()) && columnData.getType() == 3 && !(contains = columnFieldList.contains(groupField = visualDevJsonModel.getColumnData().getGroupField()))) {
                    if (groupField.startsWith("jnpf_")) {
                        columnFieldList.add(groupField);
                    } else {
                        mainTableFields.add(groupField);
                    }
                }
                List childFieldList = columnFieldList.stream().filter(s -> s.matches(reg)).map(child -> {
                    OnlineColumnFieldModel fieldModel = new OnlineColumnFieldModel();
                    String s1 = child.substring(child.lastIndexOf("jnpf_")).replace("jnpf_", "");
                    String s2 = child.substring(child.indexOf("_") + 1, child.lastIndexOf("_jnpf"));
                    fieldModel.setTableName(s2);
                    fieldModel.setField(s1);
                    fieldModel.setOriginallyField(child);
                    return fieldModel;
                }).collect(Collectors.toList());
                List ColumnTableNameList = childFieldList.stream().map(t -> t.getTableName().toLowerCase()).collect(Collectors.toList());
                List tableModelList1 = tableModelList.stream().filter(t -> ColumnTableNameList.contains(t.getTable().toLowerCase())).collect(Collectors.toList());
                ArrayList<OnlineColumnChildFieldModel> classifyFieldList = new ArrayList<OnlineColumnChildFieldModel>(10);
                for (TableModel t2 : tableModelList1) {
                    OnlineColumnChildFieldModel childFieldModel = new OnlineColumnChildFieldModel();
                    childFieldModel.setTable(t2.getTable());
                    childFieldModel.setRelationField(t2.getRelationField());
                    childFieldModel.setTableField(t2.getTableField());
                    classifyFieldList.add(childFieldModel);
                }
                for (OnlineDynamicSqlModel dycModel : sqlModels) {
                    if (dycModel.isMain()) {
                        List<BasicColumn> mainSqlColumns = OnlineProductSqlUtils.getBasicColumns(mainTableFields, sqlModels, dycModel, modelList, isClobDbType);
                        dycModel.setColumns(mainSqlColumns);
                        continue;
                    }
                    if (classifyFieldList.size() <= 0) continue;
                    Map<String, List<OnlineColumnFieldModel>> mastTableCols = childFieldList.stream().collect(Collectors.groupingBy(OnlineColumnFieldModel::getTableName));
                    List onlineColumnFieldModels = Optional.ofNullable(mastTableCols.get(dycModel.getTableName())).orElse(new ArrayList());
                    List<BasicColumn> mastSqlCols = OnlineProductSqlUtils.getBasicColumnsChild(modelList, dycModel, onlineColumnFieldModels, isClobDbType);
                    dycModel.setColumns(mastSqlCols);
                }
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
        }
        catch (DataException e) {
            e.printStackTrace();
        }
    }

    public static List<BasicColumn> getGroupBySqlTable(List<OnlineDynamicSqlModel> sqlModels, VisualDevJsonModel visualDevJsonModel, List<String> columnFieldList, boolean isClobDbType) {
        ArrayList<BasicColumn> basicColumns = new ArrayList<BasicColumn>();
        try {
            columnFieldList = columnFieldList.stream().distinct().collect(Collectors.toList());
            List tableModelList = visualDevJsonModel.getVisualTables();
            String reg = "^[jnpf_]\\S*_jnpf\\S*";
            List<String> mainTableFields = columnFieldList.stream().filter(s -> !s.matches(reg) && !s.toLowerCase().contains("tablefield")).collect(Collectors.toList());
            if (visualDevJsonModel.getFormData().getConcurrencyLock().booleanValue()) {
                mainTableFields.add(TableFeildsEnum.VERSION.getField());
            }
            String flowidField = TableFeildsEnum.FLOWID.getField();
            if (isClobDbType) {
                flowidField = TableFeildsEnum.FLOWID.getField().toUpperCase();
            }
            mainTableFields.add(flowidField);
            List childFieldList = columnFieldList.stream().filter(s -> s.matches(reg)).map(child -> {
                OnlineColumnFieldModel fieldModel = new OnlineColumnFieldModel();
                String s1 = child.substring(child.lastIndexOf("jnpf_")).replace("jnpf_", "");
                String s2 = child.substring(child.indexOf("_") + 1, child.lastIndexOf("_jnpf"));
                fieldModel.setTableName(s2);
                fieldModel.setField(s1);
                fieldModel.setOriginallyField(child);
                return fieldModel;
            }).collect(Collectors.toList());
            List ColumnTableNameList = childFieldList.stream().map(t -> t.getTableName().toLowerCase()).collect(Collectors.toList());
            List tableModelList1 = tableModelList.stream().filter(t -> ColumnTableNameList.contains(t.getTable().toLowerCase())).collect(Collectors.toList());
            ArrayList<OnlineColumnChildFieldModel> classifyFieldList = new ArrayList<OnlineColumnChildFieldModel>(10);
            for (TableModel t2 : tableModelList1) {
                OnlineColumnChildFieldModel childFieldModel = new OnlineColumnChildFieldModel();
                childFieldModel.setTable(t2.getTable());
                childFieldModel.setRelationField(t2.getRelationField());
                childFieldModel.setTableField(t2.getTableField());
                classifyFieldList.add(childFieldModel);
            }
            List modelList = JsonUtil.getJsonToList((String)visualDevJsonModel.getColumnData().getColumnList(), ColumnListField.class);
            for (OnlineDynamicSqlModel dycModel : sqlModels) {
                if (dycModel.isMain()) {
                    List<BasicColumn> mainSqlColumns = OnlineProductSqlUtils.getBasicColumns(mainTableFields, sqlModels, dycModel, modelList, isClobDbType);
                    basicColumns.addAll(mainSqlColumns);
                    continue;
                }
                if (classifyFieldList.size() <= 0) continue;
                Map<String, List<OnlineColumnFieldModel>> mastTableCols = childFieldList.stream().collect(Collectors.groupingBy(OnlineColumnFieldModel::getTableName));
                List onlineColumnFieldModels = Optional.ofNullable(mastTableCols.get(dycModel.getTableName())).orElse(new ArrayList());
                List<BasicColumn> mastSqlCols = OnlineProductSqlUtils.getBasicColumnsChild(modelList, dycModel, onlineColumnFieldModels, isClobDbType);
                basicColumns.addAll(mastSqlCols);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return basicColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getConditionSql(QueryExpressionDSL.QueryExpressionWhereBuilder form, String databaseProductName, List<VisualColumnSearchVO> searchVOList, List<OnlineDynamicSqlModel> sqlModelList) throws SQLException {
        DynamicDataSourceUtil.switchToDataSource(null);
        try {
            boolean isOracle = databaseProductName.equalsIgnoreCase("oracle");
            boolean isPostgre = databaseProductName.equalsIgnoreCase("PostgreSQL");
            boolean isSqlServer = databaseProductName.equalsIgnoreCase("Microsoft SQL Server");
            block16: for (int k = 0; k < searchVOList.size(); ++k) {
                VisualColumnSearchVO vo = searchVOList.get(k);
                String jnpfKey = "jnpfkey";
                if (Objects.nonNull(vo.getConfig())) {
                    jnpfKey = vo.getConfig().getJnpfKey();
                }
                String tableName = vo.getTable();
                OnlineDynamicSqlModel sqlModel = sqlModelList.stream().filter(sql -> sql.getTableName().equals(tableName)).findFirst().orElse(null);
                SqlTable sqlTable = sqlModel.getSqlTable();
                String searchType = vo.getSearchType();
                String vModel = vo.getField();
                boolean isSearchMultiple = vo.getSearchMultiple() != null && vo.getSearchMultiple() != false;
                boolean isMultiple = isSearchMultiple || vo.getMultiple() != null && vo.getMultiple() != false;
                List dataValues = new ArrayList<String>();
                SqlColumn sqlColumn = sqlTable.column(vModel);
                ArrayList<AndOrCriteriaGroup> groupList = new ArrayList<AndOrCriteriaGroup>();
                if (isMultiple) {
                    Object tmpValue = vo.getValue();
                    boolean isComSelect = "organizeSelect".equals(jnpfKey);
                    if (isComSelect) {
                        tmpValue = JSONArray.toJSONString((Object)vo.getValue());
                    }
                    if (tmpValue instanceof String) {
                        tmpValue = OnlineSwapDataUtils.convertValueToString((String)tmpValue, true, isComSelect);
                        dataValues = JSON.parseArray((String)((String)tmpValue), String.class);
                    } else {
                        dataValues = JsonUtil.getJsonToList((Object)tmpValue, String.class);
                    }
                } else {
                    boolean isCurOrg = "currOrganize".equals(jnpfKey);
                    if (isCurOrg) {
                        vo.setValue((Object)OnlineSwapDataUtils.getLastOrganizeId(vo.getValue()));
                    }
                    dataValues.add(vo.getValue().toString());
                }
                Object value = vo.getValue().toString();
                if (isMultiple || "checkbox".equals(jnpfKey) || "cascader".equals(jnpfKey) || "currOrganize".equals(jnpfKey) || "areaSelect".equals(jnpfKey) || "usersSelect".equals(jnpfKey)) {
                    searchType = "2";
                }
                if (("input".equals(jnpfKey) || "textarea".equals(jnpfKey)) && "3".equals(searchType)) {
                    searchType = "2";
                }
                if ("1".equals(searchType)) {
                    form.and((BindableColumn)sqlColumn, (VisitableCondition)SqlBuilder.isEqualTo((Object)value), new AndOrCriteriaGroup[0]);
                    continue;
                }
                if ("2".equals(searchType)) {
                    if ("usersSelect".equals(jnpfKey)) {
                        for (String userVal : dataValues) {
                            OnlineProductSqlUtils.convertUserSelectData((BindableColumn)sqlColumn, groupList, userVal, true);
                        }
                    }
                    if (isMultiple) {
                        for (String val : dataValues) {
                            if (isSqlServer) {
                                val = val.replaceAll("\\[", "[[]");
                            }
                            groupList.add(SqlBuilder.or((BindableColumn)sqlColumn, (VisitableCondition)SqlBuilder.isLike((Object)("%" + val + "%")), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]));
                        }
                    }
                    if (isSqlServer) {
                        value = ((String)value).replaceAll("\\[", "[[]");
                    }
                    value = "%" + (String)value + "%";
                    if (groupList.size() > 0) {
                        form.and((BindableColumn)sqlColumn, (VisitableCondition)SqlBuilder.isLike((Object)value), groupList);
                        continue;
                    }
                    form.and((BindableColumn)sqlColumn, (VisitableCondition)SqlBuilder.isLike((Object)value), new AndOrCriteriaGroup[0]);
                    continue;
                }
                if (!"3".equals(searchType)) continue;
                switch (jnpfKey) {
                    case "modifyTime": 
                    case "createTime": 
                    case "datePicker": {
                        JSONArray timeStampArray = (JSONArray)vo.getValue();
                        Long o1 = (Long)timeStampArray.get(0);
                        Long o2 = (Long)timeStampArray.get(1);
                        String format = StringUtil.isEmpty((String)vo.getFormat()) ? "yyyy-MM-dd HH:mm:ss" : DateTimeFormatConstant.getFormat((String)vo.getFormat());
                        String startTime = OnlinePublicUtils.getDateByFormat(o1, format);
                        String endTime = OnlinePublicUtils.getDateByFormat(o2, format);
                        if ("createTime".equals(jnpfKey) || "modifyTime".equals(jnpfKey)) {
                            endTime = endTime.substring(0, 10);
                        }
                        String firstTimeDate = OnlineDatabaseUtils.getTimeFormat(startTime);
                        String lastTimeDate = OnlineDatabaseUtils.getLastTimeFormat(endTime);
                        if (isOracle || isPostgre) {
                            form.and((BindableColumn)sqlTable.column(vModel), (VisitableCondition)SqlBuilder.isBetween((Object)new Date(o1)).and((Object)new Date(o2)), new AndOrCriteriaGroup[0]);
                            continue block16;
                        }
                        form.and((BindableColumn)sqlTable.column(vModel), (VisitableCondition)SqlBuilder.isBetween((Object)firstTimeDate).and((Object)lastTimeDate), new AndOrCriteriaGroup[0]);
                        continue block16;
                    }
                    case "timePicker": {
                        List stringList = JsonUtil.getJsonToList((String)value, String.class);
                        form.and((BindableColumn)sqlTable.column(vModel), (VisitableCondition)SqlBuilder.isBetween((Object)((String)stringList.get(0))).and((Object)((String)stringList.get(1))), new AndOrCriteriaGroup[0]);
                        continue block16;
                    }
                    case "inputNumber": 
                    case "calculate": {
                        BigDecimal firstValue = null;
                        BigDecimal secondValue = null;
                        JSONArray objects = (JSONArray)vo.getValue();
                        for (int i = 0; i < objects.size(); ++i) {
                            Object n = objects.get(i);
                            if (!ObjectUtil.isNotEmpty((Object)n)) continue;
                            if (i == 0) {
                                firstValue = new BigDecimal(String.valueOf(n));
                                continue;
                            }
                            secondValue = new BigDecimal(String.valueOf(n));
                        }
                        if (firstValue != null) {
                            form.and((BindableColumn)sqlTable.column(vModel), (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo(firstValue), new AndOrCriteriaGroup[0]);
                        }
                        if (secondValue == null) continue block16;
                        form.and((BindableColumn)sqlTable.column(vModel), (VisitableCondition)SqlBuilder.isLessThanOrEqualTo(secondValue), new AndOrCriteriaGroup[0]);
                        continue block16;
                    }
                }
            }
        }
        finally {
            DynamicDataSourceUtil.clearSwitchDataSource();
        }
    }

    public static void queryList(List<FormAllModel> formAllModel, VisualDevJsonModel visualDevJsonModel, PaginationModel paginationModel) {
        Map keyJsonMap;
        String extraQueryJson;
        Map keyJsonMap2;
        String queryJson;
        String superQueryJson;
        Object fieLdsModel;
        Object fieLdsModelList;
        Object fieLdsModelList2;
        ColumnDataModel columnData;
        String moduleId = paginationModel.getMenuId();
        boolean isApp = false;
        try {
            isApp = !RequestContext.isOrignPc();
        }
        catch (Exception e) {
            isApp = false;
        }
        Map<String, Object> systemParam = OnlineProductSqlUtils.getSystemParam();
        ColumnDataModel columnDataModel = columnData = visualDevJsonModel.getIsLinkList() == false && isApp ? visualDevJsonModel.getAppColumnData() : visualDevJsonModel.getColumnData();
        if (StringUtil.isNotEmpty((String)moduleId) && columnData.getUseDataPermission() != null && columnData.getUseDataPermission().booleanValue()) {
            List authorizeListAll = authorizeUtil.getConditionSql(moduleId);
            for (SuperJsonModel superJsonModel : authorizeListAll) {
                List conditionList = superJsonModel.getConditionList();
                Iterator iterator = conditionList.iterator();
                while (iterator.hasNext()) {
                    SuperQueryJsonModel superQueryJsonModel = (SuperQueryJsonModel)iterator.next();
                    fieLdsModelList2 = superQueryJsonModel.getGroups();
                    Iterator iterator2 = fieLdsModelList2.iterator();
                    while (iterator2.hasNext()) {
                        FieLdsModel fieLdsModel2 = (FieLdsModel)iterator2.next();
                        OnlineProductSqlUtils.tabelName(fieLdsModel2, formAllModel);
                        OnlineProductSqlUtils.replaceSystemParam(systemParam, fieLdsModel2);
                    }
                }
            }
            visualDevJsonModel.setAuthorize(authorizeListAll);
        }
        if (columnData != null) {
            SuperJsonModel ruleList = isApp ? columnData.getRuleListApp() : columnData.getRuleList();
            SuperJsonModel ruleJsonModel = ruleList != null ? ruleList : new SuperJsonModel();
            List ruleJsonModelList = ruleJsonModel.getConditionList();
            for (SuperQueryJsonModel ruleQueryModel : ruleJsonModelList) {
                fieLdsModelList = ruleQueryModel.getGroups();
                fieLdsModelList2 = fieLdsModelList.iterator();
                while (fieLdsModelList2.hasNext()) {
                    fieLdsModel = (FieLdsModel)fieLdsModelList2.next();
                    fieLdsModel.setVModel(fieLdsModel.getId());
                    OnlineProductSqlUtils.tabelName((FieLdsModel)fieLdsModel, formAllModel);
                    OnlineProductSqlUtils.replaceSystemParam(systemParam, (FieLdsModel)fieLdsModel);
                }
            }
            visualDevJsonModel.setRuleQuery(ruleJsonModel);
        }
        if (StringUtil.isNotEmpty((String)(superQueryJson = paginationModel.getSuperQueryJson()))) {
            SuperJsonModel queryJsonModel = (SuperJsonModel)JsonUtil.getJsonToBean((String)superQueryJson, SuperJsonModel.class);
            List superQueryListAll = queryJsonModel.getConditionList();
            for (SuperQueryJsonModel superQueryJsonModel : superQueryListAll) {
                fieLdsModelList = superQueryJsonModel.getGroups();
                fieLdsModelList2 = fieLdsModelList.iterator();
                while (fieLdsModelList2.hasNext()) {
                    fieLdsModel = (FieLdsModel)fieLdsModelList2.next();
                    fieLdsModel.setVModel(fieLdsModel.getId());
                    OnlineProductSqlUtils.tabelName((FieLdsModel)fieLdsModel, formAllModel);
                    OnlineProductSqlUtils.replaceSystemParam(systemParam, (FieLdsModel)fieLdsModel);
                }
            }
            visualDevJsonModel.setSuperQuery(queryJsonModel);
        }
        if (StringUtil.isNotEmpty((String)(queryJson = paginationModel.getQueryJson()))) {
            keyJsonMap2 = JsonUtil.stringToMap((String)queryJson);
            List searchVOListAll = JsonUtil.getJsonToList((String)columnData.getSearchList(), FieLdsModel.class);
            if (!visualDevJsonModel.getIsLinkList().booleanValue()) {
                searchVOListAll.addAll(OnlineProductSqlUtils.treeRelation(columnData, formAllModel));
            }
            ArrayList<Object> searchVOList = new ArrayList<Object>();
            for (final String model : keyJsonMap2.keySet()) {
                fieLdsModel = searchVOListAll.stream().filter(t -> model.equals(t.getId())).findFirst().orElse(null);
                Object object = keyJsonMap2.get(model);
                if (fieLdsModel == null || "\u6807\u7b7e\u9762\u677f\u5b57\u6bb5".equals(fieLdsModel.getLabel()) && ObjectUtil.isEmpty(object)) continue;
                ConfigModel config = fieLdsModel.getConfig();
                Integer searchType = fieLdsModel.getSearchType();
                String jnpfKey = config.getJnpfKey();
                boolean isMultiple = fieLdsModel.getSearchMultiple() != false || fieLdsModel.getMultiple() != false;
                List type = JnpfKeyConsts.SelectIgnore;
                List base = JnpfKeyConsts.BaseSelect;
                if (isMultiple || type.contains(jnpfKey)) {
                    if (object instanceof String) {
                        object = new ArrayList(){
                            {
                                this.add(String.valueOf(keyJsonMap2.get(model)));
                            }
                        };
                    }
                    searchType = 4;
                }
                if (base.contains(jnpfKey) && searchType == 3) {
                    searchType = 2;
                }
                String symbol = searchType == 1 ? SearchMethodEnum.Equal.getSymbol() : (searchType == 3 ? SearchMethodEnum.Between.getSymbol() : (searchType == 2 ? SearchMethodEnum.Like.getSymbol() : SearchMethodEnum.Included.getSymbol()));
                fieLdsModel.setSymbol(symbol);
                if (object instanceof List) {
                    fieLdsModel.setFieldValue(JsonUtil.getObjectToString(object));
                } else {
                    fieLdsModel.setFieldValue(String.valueOf(object));
                }
                OnlineProductSqlUtils.tabelName((FieLdsModel)fieLdsModel, formAllModel);
                searchVOList.add(fieLdsModel);
            }
            final SuperQueryJsonModel queryJsonModel = new SuperQueryJsonModel();
            queryJsonModel.setGroups(searchVOList);
            SuperJsonModel superJsonModel = new SuperJsonModel();
            superJsonModel.setConditionList((List)new ArrayList(){
                {
                    this.add(queryJsonModel);
                }
            });
            visualDevJsonModel.setQuery(superJsonModel);
        }
        if (StringUtil.isNotEmpty((String)queryJson) && (keyJsonMap2 = JsonUtil.stringToMap((String)queryJson)).get("jnpfKeyword") != null) {
            String keyWord = String.valueOf(keyJsonMap2.get("jnpfKeyword"));
            List searchVOListAll = JsonUtil.getJsonToList((String)columnData.getSearchList(), FieLdsModel.class);
            List collect = searchVOListAll.stream().filter(t -> t.getIsKeyword()).collect(Collectors.toList());
            ArrayList<FieLdsModel> searchVOList = new ArrayList<FieLdsModel>();
            for (FieLdsModel fieLdsModel2 : collect) {
                fieLdsModel2.setFieldValue(keyWord);
                fieLdsModel2.setSymbol(SearchMethodEnum.Like.getSymbol());
                OnlineProductSqlUtils.tabelName(fieLdsModel2, formAllModel);
                searchVOList.add(fieLdsModel2);
            }
            final SuperQueryJsonModel queryJsonModel = new SuperQueryJsonModel();
            queryJsonModel.setLogic(SearchMethodEnum.Or.getSymbol());
            queryJsonModel.setGroups(searchVOList);
            SuperJsonModel superJsonModel = new SuperJsonModel();
            superJsonModel.setConditionList((List)new ArrayList(){
                {
                    this.add(queryJsonModel);
                }
            });
            visualDevJsonModel.setKeyQuery(superJsonModel);
        }
        if (StringUtil.isNotEmpty((String)(extraQueryJson = paginationModel.getExtraQueryJson())) && MapUtils.isNotEmpty((Map)(keyJsonMap = JsonUtil.stringToMap((String)extraQueryJson)))) {
            SuperJsonModel superJsonModel = new SuperJsonModel();
            List<FieLdsModel> extraQueryList = OnlineProductSqlUtils.extraQueryList(keyJsonMap, formAllModel);
            final SuperQueryJsonModel queryJsonModel = new SuperQueryJsonModel();
            queryJsonModel.setGroups(extraQueryList);
            superJsonModel.setConditionList((List)new ArrayList(){
                {
                    this.add(queryJsonModel);
                }
            });
            visualDevJsonModel.setExtraQuery(superJsonModel);
        }
    }

    public static void tabelName(FieLdsModel fieLdsModel, List<FormAllModel> formAllModel) {
        List mast = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        List mastTable = formAllModel.stream().filter(t -> FormEnum.mastTable.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        List childTable = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        if (fieLdsModel != null) {
            FormAllModel childTableModel;
            FormAllModel mastTableModel;
            String vModel = fieLdsModel.getId().split("-")[0];
            String field = fieLdsModel.getId().split("-").length > 1 ? fieLdsModel.getId().split("-")[1] : "";
            FormAllModel mastModel = mast.stream().filter(t -> vModel.equals(t.getFormColumnModel().getFieLdsModel().getVModel())).findFirst().orElse(null);
            if (mastModel != null) {
                fieLdsModel.getConfig().setTableName(mastModel.getFormColumnModel().getFieLdsModel().getConfig().getTableName());
                fieLdsModel.getConfig().setJnpfKey(mastModel.getFormColumnModel().getFieLdsModel().getConfig().getJnpfKey());
            }
            if ((mastTableModel = (FormAllModel)mastTable.stream().filter(t -> vModel.equals(t.getFormMastTableModel().getVModel())).findFirst().orElse(null)) != null) {
                fieLdsModel.getConfig().setTableName(mastTableModel.getFormMastTableModel().getMastTable().getFieLdsModel().getConfig().getTableName());
                fieLdsModel.getConfig().setJnpfKey(mastTableModel.getFormMastTableModel().getMastTable().getFieLdsModel().getConfig().getJnpfKey());
            }
            if ((childTableModel = (FormAllModel)childTable.stream().filter(t -> vModel.equals(t.getChildList().getTableModel())).findFirst().orElse(null)) != null) {
                fieLdsModel.getConfig().setTableName(childTableModel.getChildList().getTableName());
                List childList = childTableModel.getChildList().getChildList();
                for (FormColumnModel formColumnModel : childList) {
                    FieLdsModel childFieLdsModel = formColumnModel.getFieLdsModel();
                    String childModel = childFieLdsModel.getVModel();
                    if (!childModel.equals(field)) continue;
                    fieLdsModel.getConfig().setJnpfKey(childFieLdsModel.getConfig().getJnpfKey());
                }
            }
            OnlineProductSqlUtils.convertUserSelectData(fieLdsModel);
        }
    }

    private static void convertUserSelectData(FieLdsModel fieLdsModel) {
        ArrayList<String> symbolList = new ArrayList<String>();
        symbolList.add(SearchMethodEnum.Equal.getSymbol());
        symbolList.add(SearchMethodEnum.NotEqual.getSymbol());
        String jnpfKey = fieLdsModel.getConfig().getJnpfKey();
        String fieldValue = fieLdsModel.getFieldValue();
        String symbol = fieLdsModel.getSymbol();
        if (StringUtil.isNotEmpty((String)fieldValue)) {
            switch (jnpfKey) {
                case "usersSelect": {
                    if (symbolList.contains(symbol)) break;
                    ArrayList dataValues = new ArrayList();
                    List values = new ArrayList();
                    try {
                        values = JsonUtil.getJsonToList((String)fieldValue, String.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    dataValues.addAll(values);
                    for (String userVal : values) {
                        String userValue = userVal.substring(0, userVal.indexOf("--"));
                        UserEntity userEntity = userApi.getInfo(userValue);
                        if (userEntity == null) continue;
                        dataValues.add(userValue);
                        List groupRel = Optional.ofNullable(userRelationApi.getListByUserId(userValue, "Group")).orElse(new ArrayList());
                        List orgRel = Optional.ofNullable(userRelationApi.getListByUserId(userValue, "Organize")).orElse(new ArrayList());
                        List posRel = Optional.ofNullable(userRelationApi.getListByUserId(userValue, "Position")).orElse(new ArrayList());
                        List roleRel = Optional.ofNullable(userRelationApi.getListByUserId(userValue, "Role")).orElse(new ArrayList());
                        if (groupRel.size() > 0) {
                            for (Object split : groupRel) {
                                dataValues.add(split.getObjectId());
                            }
                        }
                        if (StringUtil.isNotEmpty((String)userEntity.getOrganizeId())) {
                            Object split;
                            ArrayList allUpOrgIDs = new ArrayList();
                            organizeApi.upWardRecursion(allUpOrgIDs, userEntity.getOrganizeId());
                            split = allUpOrgIDs.iterator();
                            while (split.hasNext()) {
                                String orgID = (String)split.next();
                                dataValues.add(orgID);
                            }
                        }
                        if (posRel.size() > 0) {
                            for (Object split : posRel) {
                                dataValues.add(split.getObjectId());
                            }
                        }
                        if (roleRel.size() <= 0) continue;
                        for (Object split : roleRel) {
                            dataValues.add(split.getObjectId());
                        }
                    }
                    fieLdsModel.setFieldValue(JsonUtil.getObjectToString(dataValues));
                    break;
                }
            }
        }
    }

    public static void superList(List<SuperQueryJsonModel> conditionList, boolean convertUser) {
        final List dateControl = JnpfKeyConsts.DateSelect;
        final List numControl = JnpfKeyConsts.NumSelect;
        for (SuperQueryJsonModel queryJsonModel : conditionList) {
            List fieLdsModelList = queryJsonModel.getGroups();
            for (FieLdsModel fieLdsModel : fieLdsModelList) {
                HashSet<String> dataAll;
                ArrayList controlList;
                ArrayList dataList = new ArrayList();
                ConfigModel config = fieLdsModel.getConfig();
                String vModel = fieLdsModel.getVModel().trim();
                String jnpfKey = config.getJnpfKey();
                if (vModel.split("_jnpf_").length > 1) {
                    vModel = vModel.split("_jnpf_")[1];
                }
                if (vModel.split("-").length > 1) {
                    vModel = vModel.split("-")[1];
                }
                String value = fieLdsModel.getFieldValue();
                Object fieldValue = fieLdsModel.getFieldValue();
                Object fieldValueTwo = fieLdsModel.getFieldValue();
                if (fieLdsModel.getFieldValue() == null) {
                    fieldValue = "";
                }
                if ((controlList = new ArrayList(){
                    {
                        this.addAll(numControl);
                        this.addAll(dateControl);
                        this.add("timePicker");
                    }
                }).contains(jnpfKey) && StringUtil.isNotEmpty((String)value) && !SearchMethodEnum.Like.getSymbol().equals(fieLdsModel.getSymbol())) {
                    int num = 0;
                    ArrayList<String> data = new ArrayList<String>();
                    try {
                        data.addAll(JsonUtil.getJsonToList((String)value, String.class));
                    }
                    catch (Exception e) {
                        data.add(value);
                        data.add(value);
                    }
                    String valueOne = (String)data.get(0);
                    String valueTwo = (String)data.get(1);
                    if (numControl.contains(jnpfKey)) {
                        fieldValue = valueOne != null ? new BigDecimal(valueOne) : valueOne;
                        fieldValueTwo = valueTwo != null ? new BigDecimal(valueTwo) : valueTwo;
                        Integer precision = fieLdsModel.getPrecision();
                        if (ObjectUtil.isNotEmpty((Object)precision)) {
                            String zeroNum = "0." + StringUtils.repeat((String)"0", (int)precision);
                            DecimalFormat numFormat = new DecimalFormat(zeroNum);
                            fieldValue = new BigDecimal(numFormat.format(new BigDecimal(valueOne)));
                            if (valueTwo != null) {
                                fieldValueTwo = new BigDecimal(numFormat.format(new BigDecimal(valueTwo)));
                            }
                        }
                        ++num;
                    }
                    if (dateControl.contains(jnpfKey)) {
                        fieldValue = new Date();
                        fieldValueTwo = new Date();
                        if (ObjectUtil.isNotEmpty((Object)valueOne)) {
                            fieldValue = new Date(Long.valueOf(valueOne));
                        }
                        if (ObjectUtil.isNotEmpty((Object)valueTwo)) {
                            fieldValueTwo = new Date(Long.valueOf(valueTwo));
                        }
                        ++num;
                    }
                    if (num == 0) {
                        fieldValue = valueOne;
                        fieldValueTwo = valueTwo;
                    }
                }
                try {
                    List list = (List)JsonUtil.getJsonToBean((String)value, List.class);
                    dataAll = new HashSet();
                    for (int i = 0; i < list.size(); ++i) {
                        ArrayList<String> list1 = new ArrayList<String>();
                        for (int k = 0; k < ((List)list.get(i)).size(); ++k) {
                            list1.add((String)((List)list.get(i)).get(k));
                        }
                        dataAll.add(JSONArray.toJSONString(list1));
                    }
                    dataList = new ArrayList(dataAll);
                }
                catch (Exception e) {
                    try {
                        dataAll = new HashSet<String>();
                        List list = JsonUtil.getJsonToList((String)value, String.class);
                        ArrayList mast = new ArrayList(){
                            {
                                this.add("cascader");
                                this.add("areaSelect");
                                this.add("organizeSelect");
                                this.add("currOrganize");
                            }
                        };
                        if (mast.contains(jnpfKey)) {
                            dataAll.add(JSONArray.toJSONString((Object)list));
                        } else {
                            for (int k = 0; k < list.size(); ++k) {
                                String data = (String)list.get(k);
                                dataAll.add(data);
                            }
                        }
                        dataList.addAll(new ArrayList(dataAll));
                    }
                    catch (Exception e1) {
                        dataList.add(value);
                    }
                }
                if (dataList.size() == 0) {
                    dataList.add("jnpfNullList");
                }
                fieLdsModel.setVModel(vModel);
                fieLdsModel.setFieldValueOne(fieldValue);
                fieLdsModel.setFieldValueTwo(fieldValueTwo);
                fieLdsModel.setDataList(dataList);
                if (!convertUser) continue;
                OnlineProductSqlUtils.convertUserSelectData(fieLdsModel);
            }
        }
    }

    private static List<FieLdsModel> treeRelation(ColumnDataModel columnData, List<FormAllModel> formAllModel) {
        TabConfigModel tabConfig;
        FieLdsModel fieLdsModel;
        boolean isTree;
        List mast = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        List mastTable = formAllModel.stream().filter(t -> FormEnum.mastTable.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        List childTable = formAllModel.stream().filter(t -> FormEnum.table.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        ArrayList<FieLdsModel> fieLdsModelList = new ArrayList<FieLdsModel>();
        List searchVOListAll = JsonUtil.getJsonToList((String)columnData.getSearchList(), FieLdsModel.class);
        String treeDataSource = columnData.getTreeDataSource();
        String treeRelation = columnData.getTreeRelation();
        boolean bl = isTree = searchVOListAll.stream().filter(t -> t.getId().equals(treeRelation)).count() == 0L;
        if (isTree && StringUtil.isNotEmpty((String)treeRelation)) {
            FormAllModel childTableModel;
            FormAllModel mastTableModel;
            String vModel = treeRelation.split("-")[0];
            FormAllModel mastModel = mast.stream().filter(t -> vModel.equals(t.getFormColumnModel().getFieLdsModel().getVModel())).findFirst().orElse(null);
            if (mastModel != null) {
                FieLdsModel fieLdsModel2 = mastModel.getFormColumnModel().getFieLdsModel();
                fieLdsModel2.setId(vModel);
                fieLdsModel2.setSearchType(Integer.valueOf(1));
                Boolean multiple = fieLdsModel2.getMultiple();
                fieLdsModel2.setSymbol(multiple != false && !"organize".equals(treeDataSource) ? SearchMethodEnum.Like.getSymbol() : SearchMethodEnum.Equal.getSymbol());
                fieLdsModelList.add(fieLdsModel2);
            }
            if ((mastTableModel = (FormAllModel)mastTable.stream().filter(t -> vModel.equals(t.getFormMastTableModel().getVModel())).findFirst().orElse(null)) != null) {
                fieLdsModel = mastTableModel.getFormMastTableModel().getMastTable().getFieLdsModel();
                fieLdsModel.setId(vModel);
                fieLdsModel.setSearchType(Integer.valueOf(1));
                Boolean multiple = fieLdsModel.getMultiple();
                fieLdsModel.setSymbol(multiple != false && !"organize".equals(treeDataSource) ? SearchMethodEnum.Like.getSymbol() : SearchMethodEnum.Equal.getSymbol());
                fieLdsModelList.add(fieLdsModel);
            }
            if ((childTableModel = (FormAllModel)childTable.stream().filter(t -> vModel.equals(t.getChildList().getTableModel())).findFirst().orElse(null)) != null) {
                List childList = childTableModel.getChildList().getChildList();
                for (FormColumnModel formColumnModel : childList) {
                    FieLdsModel fieLdsModel3 = formColumnModel.getFieLdsModel();
                    Boolean multiple = fieLdsModel3.getMultiple();
                    if (!treeRelation.equals(vModel + "-" + fieLdsModel3.getVModel())) continue;
                    fieLdsModel3.setSymbol(multiple != false && !"organize".equals(treeDataSource) ? SearchMethodEnum.Like.getSymbol() : SearchMethodEnum.Equal.getSymbol());
                    fieLdsModel3.setId(vModel + "-" + fieLdsModel3.getVModel());
                    fieLdsModel3.setSearchType(Integer.valueOf(1));
                    fieLdsModelList.add(fieLdsModel3);
                }
            }
        }
        if ((Objects.equals(columnData.getType(), 1) || Objects.equals(columnData.getType(), 4) || columnData.getType() == null) && (tabConfig = columnData.getTabConfig()) != null && tabConfig.isOn() && StringUtil.isNotEmpty((String)tabConfig.getRelationField())) {
            FormAllModel mastTableModel;
            String relationField = tabConfig.getRelationField();
            FormAllModel mastModel = mast.stream().filter(t -> relationField.equals(t.getFormColumnModel().getFieLdsModel().getVModel())).findFirst().orElse(null);
            if (mastModel != null) {
                fieLdsModel = mastModel.getFormColumnModel().getFieLdsModel();
                fieLdsModel.setId(relationField);
                fieLdsModel.setSearchType(Integer.valueOf(1));
                fieLdsModel.setLabel("\u6807\u7b7e\u9762\u677f\u5b57\u6bb5");
                fieLdsModel.setSymbol(SearchMethodEnum.Equal.getSymbol());
                fieLdsModelList.add(fieLdsModel);
            }
            if ((mastTableModel = (FormAllModel)mastTable.stream().filter(t -> relationField.equals(t.getFormMastTableModel().getVModel())).findFirst().orElse(null)) != null) {
                FieLdsModel fieLdsModel4 = mastTableModel.getFormMastTableModel().getMastTable().getFieLdsModel();
                fieLdsModel4.setId(relationField);
                fieLdsModel4.setSearchType(Integer.valueOf(1));
                fieLdsModel4.setLabel("\u6807\u7b7e\u9762\u677f\u5b57\u6bb5");
                fieLdsModel4.setSymbol(SearchMethodEnum.Equal.getSymbol());
                fieLdsModelList.add(fieLdsModel4);
            }
        }
        return fieLdsModelList;
    }

    public static void getSuperSql(QueryExpressionDSL.QueryExpressionWhereBuilder where, List<SuperJsonModel> superJsonModelList, List<OnlineDynamicSqlModel> sqlModelList, String databaseProductName, String tableName) {
        ArrayList<AndOrCriteriaGroup> groupQueryList = new ArrayList<AndOrCriteriaGroup>();
        for (SuperJsonModel superJsonModel : superJsonModelList) {
            List<AndOrCriteriaGroup> groupList = OnlineProductSqlUtils.getSuperSql(where, superJsonModel, sqlModelList, databaseProductName, tableName, true);
            boolean and = superJsonModel.getAuthorizeLogic();
            String matchLogic = superJsonModel.getMatchLogic();
            boolean isAddMatchLogic = SearchMethodEnum.And.getSymbol().equalsIgnoreCase(matchLogic);
            if (groupList.size() <= 0) continue;
            AndOrCriteriaGroup andGroup = SqlBuilder.and((BindableColumn)DerivedColumn.of((String)"1"), (VisitableCondition)SqlBuilder.isEqualTo((Object)(isAddMatchLogic ? 1 : 2)), (AndOrCriteriaGroup[])groupList.toArray(new AndOrCriteriaGroup[groupList.size()]));
            AndOrCriteriaGroup orGroup = SqlBuilder.or((BindableColumn)DerivedColumn.of((String)"1"), (VisitableCondition)SqlBuilder.isEqualTo((Object)(isAddMatchLogic ? 1 : 2)), (AndOrCriteriaGroup[])groupList.toArray(new AndOrCriteriaGroup[groupList.size()]));
            groupQueryList.add(and ? andGroup : orGroup);
        }
        if (groupQueryList.size() > 0) {
            where.and((BindableColumn)DerivedColumn.of((String)"1"), (VisitableCondition)SqlBuilder.isEqualTo((Object)1), groupQueryList);
        }
    }

    public static List<AndOrCriteriaGroup> getSuperSql(QueryExpressionDSL.QueryExpressionWhereBuilder where, SuperJsonModel superJsonModel, List<OnlineDynamicSqlModel> sqlModelList, String databaseProductName, String tableName, boolean authorizeLogic) {
        ArrayList<AndOrCriteriaGroup> groupList = new ArrayList<AndOrCriteriaGroup>();
        OnlineQuerySqlUtils onlineQuerySqlUtils = new OnlineQuerySqlUtils();
        ArrayList<SuperQueryJsonModel> conditionList = new ArrayList<SuperQueryJsonModel>();
        List conditionListAll = superJsonModel.getConditionList();
        String matchLogic = superJsonModel.getMatchLogic();
        for (SuperQueryJsonModel queryJsonModel : conditionListAll) {
            ArrayList<FieLdsModel> fieLdsModelList = new ArrayList<FieLdsModel>();
            List groupsList = queryJsonModel.getGroups();
            for (FieLdsModel fieLdsModel : groupsList) {
                String table;
                String string = table = StringUtil.isNotEmpty((String)fieLdsModel.getConfig().getRelationTable()) ? fieLdsModel.getConfig().getRelationTable() : fieLdsModel.getConfig().getTableName();
                if (!StringUtil.isEmpty((String)tableName) && !table.equals(tableName)) continue;
                fieLdsModelList.add(fieLdsModel);
            }
            SuperQueryJsonModel queryModel = new SuperQueryJsonModel();
            queryModel.setLogic(queryJsonModel.getLogic());
            queryModel.setGroups(fieLdsModelList);
            if (fieLdsModelList.size() <= 0) continue;
            conditionList.add(queryModel);
        }
        if (conditionList.size() > 0) {
            groupList.addAll(onlineQuerySqlUtils.getSuperSql(conditionList, sqlModelList, databaseProductName, matchLogic));
        }
        if (!authorizeLogic && groupList.size() > 0) {
            where.and((BindableColumn)DerivedColumn.of((String)"1"), (VisitableCondition)SqlBuilder.isEqualTo((Object)(SearchMethodEnum.And.getSymbol().equalsIgnoreCase(matchLogic) ? 1 : 2)), groupList);
        }
        return groupList;
    }

    private static void convertUserSelectData(BindableColumn sqlColumn, List<AndOrCriteriaGroup> userGroup, String userVal, boolean isLike) {
        String userValue = userVal.substring(0, userVal.indexOf("--"));
        UserEntity userEntity = userApi.getInfo(userValue);
        if (userEntity != null) {
            AndOrCriteriaGroup aog;
            String idValue;
            List groupRel = Optional.ofNullable(userRelationApi.getListByUserId(userValue, "Group")).orElse(new ArrayList());
            List orgRel = Optional.ofNullable(userRelationApi.getListByUserId(userValue, "Organize")).orElse(new ArrayList());
            List posRel = Optional.ofNullable(userRelationApi.getListByUserId(userValue, "Position")).orElse(new ArrayList());
            List roleRel = Optional.ofNullable(userRelationApi.getListByUserId(userValue, "Role")).orElse(new ArrayList());
            if (groupRel.size() > 0) {
                for (Object split : groupRel) {
                    idValue = "%" + split.getObjectId() + "%";
                    aog = isLike ? SqlBuilder.or((BindableColumn)sqlColumn, (VisitableCondition)SqlBuilder.isLike((Object)idValue), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]) : SqlBuilder.and((BindableColumn)sqlColumn, (VisitableCondition)SqlBuilder.isNotLike((Object)idValue), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]);
                    userGroup.add(aog);
                }
            }
            if (StringUtil.isNotEmpty((String)userEntity.getOrganizeId())) {
                ArrayList allUpOrgIDs = new ArrayList();
                organizeApi.upWardRecursion(allUpOrgIDs, userEntity.getOrganizeId());
                for (String orgID : allUpOrgIDs) {
                    idValue = "%" + orgID + "%";
                    AndOrCriteriaGroup aog2 = isLike ? SqlBuilder.or((BindableColumn)sqlColumn, (VisitableCondition)SqlBuilder.isLike((Object)idValue), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]) : SqlBuilder.and((BindableColumn)sqlColumn, (VisitableCondition)SqlBuilder.isNotLike((Object)idValue), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]);
                    userGroup.add(aog2);
                }
            }
            if (posRel.size() > 0) {
                for (Object split : posRel) {
                    idValue = "%" + split.getObjectId() + "%";
                    aog = isLike ? SqlBuilder.or((BindableColumn)sqlColumn, (VisitableCondition)SqlBuilder.isLike((Object)idValue), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]) : SqlBuilder.and((BindableColumn)sqlColumn, (VisitableCondition)SqlBuilder.isNotLike((Object)idValue), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]);
                    userGroup.add(aog);
                }
            }
            if (roleRel.size() > 0) {
                for (Object split : roleRel) {
                    idValue = "%" + split.getObjectId() + "%";
                    aog = isLike ? SqlBuilder.or((BindableColumn)sqlColumn, (VisitableCondition)SqlBuilder.isLike((Object)idValue), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]) : SqlBuilder.and((BindableColumn)sqlColumn, (VisitableCondition)SqlBuilder.isNotLike((Object)idValue), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0]);
                    userGroup.add(aog);
                }
            }
        }
    }

    public static List<BasicColumn> getBasicColumns(List<String> mainTableFields, List<OnlineDynamicSqlModel> sqlModels, OnlineDynamicSqlModel dycModel, List<ColumnListField> columnFieldListAll, boolean isClobDbType) {
        List<BasicColumn> mainSqlColumns = mainTableFields.stream().map(m -> dycModel.getSqlTable().column(m)).collect(Collectors.toList());
        return mainSqlColumns;
    }

    private static List<BasicColumn> getBasicColumnsChild(List<ColumnListField> modelList, OnlineDynamicSqlModel dycModel, List<OnlineColumnFieldModel> onlineColumnFieldModels, boolean isClobDbType) {
        SqlTable mastSqlTable = dycModel.getSqlTable();
        List<BasicColumn> mastSqlCols = onlineColumnFieldModels.stream().map(m -> mastSqlTable.column(m.getField()).as(m.getOriginallyField())).collect(Collectors.toList());
        return mastSqlCols;
    }

    public static Map<String, Object> getSystemParam() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        UserInfo userInfo = UserProvider.getUser();
        if (userInfo == null || StringUtil.isEmpty((String)userInfo.getUserId())) {
            return map;
        }
        map.put(AuthorizeConditionEnum.CURRENTTIME.getCondition(), new Date());
        String depId = userInfo.getDepartmentId();
        map.put(AuthorizeConditionEnum.DEPID.getCondition(), depId);
        ArrayList<String> depList = new ArrayList<String>();
        if (StringUtil.isNotEmpty((String)depId)) {
            depList.add(depId);
            depList.addAll(organizeApi.getDepsByParentId(depId).stream().map(SuperBaseEntity.SuperIBaseEntity::getId).collect(Collectors.toList()));
        }
        map.put(AuthorizeConditionEnum.DEPANDSUBORDINATES.getCondition(), JsonUtil.getObjectToString(depList));
        List<String> positionIdList = new ArrayList<String>();
        if (Objects.nonNull(userInfo.getPositionIds())) {
            positionIdList.addAll(Arrays.asList(userInfo.getPositionIds()));
        }
        positionIdList = positionIdList.stream().filter(t -> StringUtil.isNotEmpty((String)t)).collect(Collectors.toList());
        map.put(AuthorizeConditionEnum.POSITIONID.getCondition(), JsonUtil.getObjectToString(positionIdList));
        String userId = userInfo.getUserId();
        map.put(AuthorizeConditionEnum.USER.getCondition(), userId);
        ArrayList<String> subOrganizeIds = new ArrayList<String>();
        subOrganizeIds.addAll(userApi.getListByManagerId(userInfo.getUserId(), null).stream().map(SuperBaseEntity.SuperIBaseEntity::getId).collect(Collectors.toList()));
        subOrganizeIds.add(userInfo.getUserId());
        map.put(AuthorizeConditionEnum.USERANDUNDER.getCondition(), JsonUtil.getObjectToString(subOrganizeIds));
        map.put(AuthorizeConditionEnum.ORGANIZE.getCondition(), organizeApi.getUserTreeOrgStr(AuthorizeConditionEnum.ORGANIZE));
        map.put(AuthorizeConditionEnum.ORGANIZEANDUNDER.getCondition(), organizeApi.getUserTreeOrgStr(AuthorizeConditionEnum.ORGANIZEANDUNDER));
        map.put(AuthorizeConditionEnum.BRANCHMANAGEORG.getCondition(), organizeApi.getUserTreeOrgStr(AuthorizeConditionEnum.BRANCHMANAGEORG));
        return map;
    }

    public static void replaceSystemParam(Map<String, Object> systemParam, FieLdsModel fieLdsModel) {
        Object valueObj;
        String fieldValue = fieLdsModel.getFieldValue();
        String valueStr = "";
        if (AuthorizeConditionEnum.CURRENTTIME.getCondition().equals(fieldValue)) {
            valueObj = systemParam.get(AuthorizeConditionEnum.CURRENTTIME.getCondition());
            Date currentTime = (Date)valueObj;
            currentTime = DateUtil.stringToDate((String)DateUtil.daFormatHHMMSS((Long)currentTime.getTime()));
            valueStr = String.valueOf(currentTime.getTime());
            fieLdsModel.setFieldValue(valueStr);
        }
        if (AuthorizeConditionEnum.DEPID.getCondition().equals(fieldValue)) {
            valueObj = systemParam.get(AuthorizeConditionEnum.DEPID.getCondition());
            valueStr = Objects.nonNull(valueObj) && StringUtil.isNotEmpty((String)valueObj.toString()) ? valueObj.toString() : AuthorizeConditionEnum.DEPID.getCondition();
            fieLdsModel.setFieldValue(valueStr);
        }
        if (AuthorizeConditionEnum.DEPANDSUBORDINATES.getCondition().equals(fieldValue)) {
            valueStr = systemParam.get(AuthorizeConditionEnum.DEPANDSUBORDINATES.getCondition()).toString();
            fieLdsModel.setFieldValue(valueStr);
        }
        if (AuthorizeConditionEnum.POSITIONID.getCondition().equals(fieldValue)) {
            valueStr = systemParam.get(AuthorizeConditionEnum.POSITIONID.getCondition()).toString();
            fieLdsModel.setFieldValue(valueStr);
        }
        if (AuthorizeConditionEnum.USER.getCondition().equals(fieldValue)) {
            valueStr = systemParam.get(AuthorizeConditionEnum.USER.getCondition()).toString();
            fieLdsModel.setFieldValue(valueStr);
        }
        if (AuthorizeConditionEnum.USERANDUNDER.getCondition().equals(fieldValue)) {
            valueStr = systemParam.get(AuthorizeConditionEnum.USERANDUNDER.getCondition()).toString();
            fieLdsModel.setFieldValue(valueStr);
        }
        if (AuthorizeConditionEnum.ORGANIZE.getCondition().equals(fieldValue)) {
            valueStr = systemParam.get(AuthorizeConditionEnum.ORGANIZE.getCondition()).toString();
            fieLdsModel.setFieldValue(valueStr);
        }
        if (AuthorizeConditionEnum.ORGANIZEANDUNDER.getCondition().equals(fieldValue)) {
            valueStr = systemParam.get(AuthorizeConditionEnum.ORGANIZEANDUNDER.getCondition()).toString();
            fieLdsModel.setFieldValue(valueStr);
        }
        if (AuthorizeConditionEnum.BRANCHMANAGEORG.getCondition().equals(fieldValue)) {
            valueStr = systemParam.get(AuthorizeConditionEnum.BRANCHMANAGEORG.getCondition()).toString();
            fieLdsModel.setFieldValue(valueStr);
        }
    }

    private static List<FieLdsModel> extraQueryList(Map<String, Object> map, List<FormAllModel> formAllModel) {
        ArrayList<FieLdsModel> fieLdsModelList = new ArrayList<FieLdsModel>();
        List mast = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        List mastTable = formAllModel.stream().filter(t -> FormEnum.mastTable.getMessage().equals(t.getJnpfKey())).collect(Collectors.toList());
        for (String key : map.keySet()) {
            FormAllModel mastTableModel;
            Object value = map.get(key);
            FieLdsModel fieLdsModel = null;
            FormAllModel mastModel = mast.stream().filter(t -> key.equals(t.getFormColumnModel().getFieLdsModel().getVModel())).findFirst().orElse(null);
            if (mastModel != null) {
                fieLdsModel = (FieLdsModel)BeanUtil.copyProperties((Object)mastModel.getFormColumnModel().getFieLdsModel(), FieLdsModel.class, (String[])new String[0]);
            }
            if ((mastTableModel = (FormAllModel)mastTable.stream().filter(t -> key.equals(t.getFormMastTableModel().getVModel())).findFirst().orElse(null)) != null) {
                fieLdsModel = (FieLdsModel)BeanUtil.copyProperties((Object)mastTableModel.getFormMastTableModel().getMastTable().getFieLdsModel(), FieLdsModel.class, (String[])new String[0]);
            }
            fieLdsModel.setId(key);
            fieLdsModel.setSearchType(Integer.valueOf(1));
            fieLdsModel.setLabel(fieLdsModel.getConfig().getLabel());
            fieLdsModel.setSymbol(SearchMethodEnum.Equal.getSymbol());
            if (Objects.nonNull(value)) {
                if (value instanceof List) {
                    fieLdsModel.setFieldValue(JsonUtil.getObjectToString((Object)value));
                } else {
                    fieLdsModel.setFieldValue(String.valueOf(value));
                }
            } else {
                fieLdsModel.setSymbol(SearchMethodEnum.IsNull.getSymbol());
            }
            fieLdsModelList.add(fieLdsModel);
        }
        return fieLdsModelList;
    }

    private static String getOrgAllPath(List<String> allIdList) {
        List<List<String>> orgAllPathList = OnlineProductSqlUtils.getOrgAllPathList(allIdList);
        return JsonUtil.getObjectToString(orgAllPathList);
    }

    private static List<List<String>> getOrgAllPathList(List<String> allIdList) {
        ArrayList<List<String>> resOrg = new ArrayList<List<String>>();
        for (String itemOrg : allIdList) {
            String[] split;
            OrganizeEntity organizeEntity = organizeApi.getInfo(itemOrg);
            if (organizeEntity == null || !StringUtil.isNotEmpty((String)organizeEntity.getOrganizeIdTree()) || (split = organizeEntity.getOrganizeIdTree().split(",")).length <= 0) continue;
            resOrg.add(Arrays.asList(split));
        }
        return resOrg;
    }
}

