/*
 * Decompiled with CFR 0.152.
 */
package jnpf.onlinedev.util.onlineDevUtil;

import com.alibaba.fastjson.JSONArray;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import jnpf.base.ActionResult;
import jnpf.base.model.datainterface.DataInterfaceModel;
import jnpf.base.model.datainterface.DataInterfacePage;
import jnpf.base.service.DataInterfaceService;
import jnpf.base.service.DictionaryDataService;
import jnpf.base.service.ProvinceService;
import jnpf.model.visualJson.FieLdsModel;
import jnpf.model.visualJson.TemplateJsonModel;
import jnpf.onlinedev.model.OnlineDevEnum.CacheKeyEnum;
import jnpf.onlinedev.model.OnlineDevEnum.OnlineDataTypeEnum;
import jnpf.onlinedev.util.onlineDevUtil.OnlineExecutorParam;
import jnpf.onlinedev.util.onlineDevUtil.OnlineSwapDataUtils;
import jnpf.permission.service.GroupService;
import jnpf.permission.service.OrganizeService;
import jnpf.permission.service.PositionService;
import jnpf.permission.service.RoleService;
import jnpf.permission.service.UserService;
import jnpf.util.JsonUtil;
import jnpf.util.RedisUtil;
import jnpf.util.StringUtil;
import jnpf.util.ThreadPoolExecutorUtil;
import jnpf.util.data.DataSourceContextHolder;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OnlineExecutor {
    private static final Logger log = LoggerFactory.getLogger(OnlineExecutor.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private UserService userApi;
    @Autowired
    private OrganizeService organizeApi;
    @Autowired
    private PositionService positionApi;
    @Autowired
    private RoleService roleApi;
    @Autowired
    private GroupService groupApi;
    @Autowired
    private ProvinceService areaApi;
    @Autowired
    private DictionaryDataService dictionaryDataApi;
    @Autowired
    private DataInterfaceService dataInterFaceApi;
    private String dsName = "";
    private static long DEFAULT_CACHE_TIME = 300L;
    private static final String KEY_USER = "user";
    private static final String KEY_ORG = "org";
    private static final String KEY_POS = "pos";
    private static final String KEY_ROLE = "role";
    private static final String KEY_GROUP = "group";
    private static final String KEY_PROVINCE = "province";
    private static final String KEY_POP = "pop";
    private static final String KEY_SELECT = "select";
    private static final String KEY_DATATYPE = "datatype";
    private static final String KEY_ORGTREE = "orgtree";

    public void executorRedis(Map<String, Object> localCache, List<FieLdsModel> swapDataVoList, String visualDevId, Boolean inlineEdit, List<Map<String, Object>> list, Map<String, Object> mainAndMast) {
        this.dsName = Optional.ofNullable(DataSourceContextHolder.getDatasourceId()).orElse("");
        HashMap<String, OnlineExecutorParam> listExecutor = new HashMap<String, OnlineExecutorParam>();
        for (int x = 0; x < list.size(); ++x) {
            Map<String, Object> dataMap = list.get(x);
            if (dataMap == null) continue;
            block34: for (FieLdsModel swapDataVo : swapDataVoList) {
                Object redisKey;
                String jnpfKey = swapDataVo.getConfig().getJnpfKey();
                if (StringUtil.isEmpty((String)swapDataVo.getVModel())) continue;
                String swapVModel = swapDataVo.getVModel();
                String dataType = swapDataVo.getConfig().getDataType();
                boolean needUser = false;
                boolean needOrg = false;
                boolean needPos = false;
                boolean needRole = false;
                boolean needGroup = false;
                boolean needProvince = false;
                boolean needOrgTree = false;
                switch (jnpfKey) {
                    case "userSelect": 
                    case "createUser": 
                    case "modifyUser": {
                        needUser = true;
                        break;
                    }
                    case "organizeSelect": 
                    case "depSelect": 
                    case "currDept": 
                    case "currOrganize": {
                        needOrg = true;
                        needOrgTree = true;
                        break;
                    }
                    case "posSelect": 
                    case "currPosition": {
                        needPos = true;
                        break;
                    }
                    case "roleSelect": {
                        needRole = true;
                        break;
                    }
                    case "groupSelect": {
                        needGroup = true;
                        break;
                    }
                    case "usersSelect": {
                        needRole = true;
                        needGroup = true;
                        needPos = true;
                        needOrg = true;
                        needUser = true;
                        break;
                    }
                    case "areaSelect": {
                        needProvince = true;
                        break;
                    }
                    case "popupSelect": 
                    case "popupTableSelect": {
                        List templateJsonModels = JsonUtil.getJsonToList((String)swapDataVo.getTemplateJson(), TemplateJsonModel.class);
                        if (dataMap.get(swapVModel) == null) continue block34;
                        String value = String.valueOf(dataMap.get(swapVModel));
                        ArrayList<DataInterfaceModel> listParam = new ArrayList<DataInterfaceModel>();
                        for (TemplateJsonModel templateJsonModel : templateJsonModels) {
                            String obj;
                            String relationField = templateJsonModel.getRelationField();
                            DataInterfaceModel dataInterfaceModel = (DataInterfaceModel)JsonUtil.getJsonToBean((Object)templateJsonModel, DataInterfaceModel.class);
                            if (StringUtil.isEmpty((String)relationField)) {
                                listParam.add(dataInterfaceModel);
                                continue;
                            }
                            String string = obj = inlineEdit != false ? "" : Optional.ofNullable(dataMap.get(relationField)).orElse("").toString();
                            if (relationField.toLowerCase().contains("tablefield")) {
                                String childField = relationField.split("-")[1];
                                obj = Optional.ofNullable(dataMap.get(childField)).orElse("").toString();
                            } else if (mainAndMast != null) {
                                obj = Optional.ofNullable(mainAndMast.get(relationField)).orElse("").toString();
                            }
                            dataInterfaceModel.setDefaultValue((Object)obj);
                            listParam.add(dataInterfaceModel);
                        }
                        DataInterfacePage dataInterfacePage = new DataInterfacePage();
                        dataInterfacePage.setParamList(listParam);
                        dataInterfacePage.setInterfaceId(swapDataVo.getInterfaceId());
                        List<String> ids = new ArrayList<String>();
                        if (value.startsWith("[")) {
                            ids = JsonUtil.getJsonToList((String)value, String.class);
                        } else {
                            ids.add(value);
                        }
                        dataInterfacePage.setIds(ids);
                        redisKey = String.format("%s-%s-%s-%s", this.dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getInterfaceId(), Base64.getEncoder().encodeToString(JsonUtil.getObjectToString((Object)dataInterfacePage).getBytes(StandardCharsets.UTF_8)));
                        if (localCache.containsKey(redisKey)) break;
                        dataInterfacePage.setPropsValue(swapDataVo.getPropsValue());
                        dataInterfacePage.setRelationField(swapDataVo.getRelationField());
                        listExecutor.putIfAbsent((String)redisKey, new OnlineExecutorParam((String)redisKey, KEY_POP, swapDataVo.getInterfaceId(), dataInterfacePage, swapDataVo.getConfig().getUseCache()));
                        break;
                    }
                    case "cascader": 
                    case "radio": 
                    case "checkbox": 
                    case "select": 
                    case "treeSelect": {
                        List templateList = JsonUtil.getJsonToList((Object)swapDataVo.getConfig().getTemplateJson(), TemplateJsonModel.class);
                        if (templateList.size() <= 0) break;
                        HashMap<String, String> paramMap = new HashMap<String, String>();
                        for (TemplateJsonModel templateJsonModel : templateList) {
                            String obj;
                            String relationField = templateJsonModel.getRelationField();
                            String Field2 = templateJsonModel.getField();
                            String string = obj = inlineEdit != false ? "" : Optional.ofNullable(dataMap.get(relationField)).orElse("").toString();
                            if (StringUtil.isEmpty((String)relationField)) {
                                paramMap.put(Field2, templateJsonModel.getDefaultValue());
                                continue;
                            }
                            if (relationField.toLowerCase().contains("tablefield")) {
                                String childField = relationField.split("-")[1];
                                obj = Optional.ofNullable(dataMap.get(childField)).orElse("").toString();
                            } else if (mainAndMast != null) {
                                obj = Optional.ofNullable(mainAndMast.get(relationField)).orElse("").toString();
                            }
                            paramMap.put(Field2, obj);
                        }
                        redisKey = String.format("%s-%s-%s-%s", this.dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl(), Base64.getEncoder().encodeToString(JsonUtil.getObjectToString(paramMap).getBytes(StandardCharsets.UTF_8)));
                        if (localCache.containsKey(redisKey)) break;
                        listExecutor.putIfAbsent((String)redisKey, new OnlineExecutorParam((String)redisKey, KEY_SELECT, swapDataVo.getConfig().getPropsUrl(), paramMap, swapDataVo.getConfig().getUseCache()));
                        break;
                    }
                }
                if (dataType != null) {
                    String children;
                    String label = swapDataVo.getProps().getLabel() != null ? swapDataVo.getProps().getLabel() : "";
                    String value = swapDataVo.getProps().getValue() != null ? swapDataVo.getProps().getValue() : "";
                    String string = children = swapDataVo.getProps().getChildren() != null ? swapDataVo.getProps().getChildren() : "";
                    if (swapDataVo.getConfig().getJnpfKey().equals("popupSelect") || swapDataVo.getConfig().getJnpfKey().equals("popupTableSelect")) {
                        label = swapDataVo.getRelationField();
                        value = swapDataVo.getPropsValue();
                    }
                    if (dataType.equals(OnlineDataTypeEnum.STATIC.getType()) && !localCache.containsKey(redisKey = String.format("%s-%s-%s", visualDevId, swapDataVo.getConfig().getRelationTable() + swapDataVo.getVModel(), OnlineDataTypeEnum.STATIC.getType()))) {
                        listExecutor.putIfAbsent((String)redisKey, new OnlineExecutorParam((String)redisKey, KEY_DATATYPE, null, swapDataVo));
                    }
                    if (dataType.equals(OnlineDataTypeEnum.DYNAMIC.getType())) {
                        boolean dynamicIsNeedCache;
                        boolean bl = dynamicIsNeedCache = swapDataVo.getConfig().getTemplateJson().size() == 0;
                        if (dynamicIsNeedCache && !localCache.containsKey(redisKey = String.format("%s-%s-%s-%s-%s-%s", this.dsName, OnlineDataTypeEnum.DYNAMIC.getType(), swapDataVo.getConfig().getPropsUrl(), value, label, children))) {
                            listExecutor.putIfAbsent((String)redisKey, new OnlineExecutorParam((String)redisKey, KEY_DATATYPE, null, swapDataVo, swapDataVo.getConfig().getUseCache()));
                        }
                    }
                    if (dataType.equals(OnlineDataTypeEnum.DICTIONARY.getType()) && !localCache.containsKey(redisKey = String.format("%s-%s-%s", this.dsName, OnlineDataTypeEnum.DICTIONARY.getType(), swapDataVo.getConfig().getDictionaryType()))) {
                        listExecutor.putIfAbsent((String)redisKey, new OnlineExecutorParam((String)redisKey, KEY_DATATYPE, null, swapDataVo));
                    }
                }
                if (needUser && !localCache.containsKey(redisKey = this.dsName + CacheKeyEnum.USER.getName())) {
                    listExecutor.putIfAbsent((String)redisKey, new OnlineExecutorParam((String)redisKey, KEY_USER, null, null));
                }
                if (needOrg && !localCache.containsKey(redisKey = this.dsName + CacheKeyEnum.ORG.getName())) {
                    listExecutor.putIfAbsent((String)redisKey, new OnlineExecutorParam((String)redisKey, KEY_ORG, null, null));
                }
                if (needPos && !localCache.containsKey(redisKey = this.dsName + CacheKeyEnum.POS.getName())) {
                    listExecutor.putIfAbsent((String)redisKey, new OnlineExecutorParam((String)redisKey, KEY_POS, null, null));
                }
                if (needRole && !localCache.containsKey(redisKey = this.dsName + CacheKeyEnum.ROLE.getName())) {
                    listExecutor.putIfAbsent((String)redisKey, new OnlineExecutorParam((String)redisKey, KEY_ROLE, null, null));
                }
                if (needGroup && !localCache.containsKey(redisKey = this.dsName + CacheKeyEnum.GROUP.getName())) {
                    listExecutor.putIfAbsent((String)redisKey, new OnlineExecutorParam((String)redisKey, KEY_GROUP, null, null));
                }
                if (!needOrgTree || localCache.containsKey(redisKey = this.dsName + CacheKeyEnum.ORGTREE.getName())) continue;
                listExecutor.putIfAbsent((String)redisKey, new OnlineExecutorParam((String)redisKey, KEY_ORGTREE, null, null));
            }
        }
        if (!listExecutor.isEmpty()) {
            this.execute(localCache, listExecutor);
        }
    }

    private void execute(Map<String, Object> localCache, Map<String, OnlineExecutorParam> listExecutor) {
        CountDownLatch countDownLatch = new CountDownLatch(listExecutor.size());
        for (String key : listExecutor.keySet()) {
            OnlineExecutorParam item = listExecutor.get(key);
            String redisKey = item.getRedisKey();
            ThreadPoolExecutorUtil.getExecutor().execute(() -> {
                try {
                    switch (item.getType()) {
                        case "user": {
                            Map userMap;
                            if (this.redisUtil.exists(redisKey)) {
                                userMap = this.redisUtil.getMap(redisKey);
                                userMap = Optional.ofNullable(userMap).orElse(new HashMap(20));
                            } else {
                                userMap = this.userApi.getUserMap();
                                this.redisUtil.insert(redisKey, (Object)userMap, DEFAULT_CACHE_TIME);
                            }
                            localCache.put("__user_map", userMap);
                            return;
                        }
                        case "org": {
                            Map orgMap;
                            if (this.redisUtil.exists(redisKey)) {
                                orgMap = this.redisUtil.getMap(redisKey);
                                orgMap = Optional.ofNullable(orgMap).orElse(new HashMap(20));
                            } else {
                                orgMap = this.organizeApi.getOrgMap();
                                this.redisUtil.insert(redisKey, (Object)orgMap, DEFAULT_CACHE_TIME);
                            }
                            localCache.put("__org_map", orgMap);
                            return;
                        }
                        case "pos": {
                            Map posMap;
                            if (this.redisUtil.exists(redisKey)) {
                                posMap = this.redisUtil.getMap(redisKey);
                                posMap = Optional.ofNullable(posMap).orElse(new HashMap(20));
                            } else {
                                posMap = this.positionApi.getPosMap();
                                this.redisUtil.insert(redisKey, (Object)posMap, DEFAULT_CACHE_TIME);
                            }
                            localCache.put("__pos_map", posMap);
                            return;
                        }
                        case "role": {
                            Map roleMap;
                            if (this.redisUtil.exists(redisKey)) {
                                roleMap = this.redisUtil.getMap(redisKey);
                                roleMap = Optional.ofNullable(roleMap).orElse(new HashMap(20));
                            } else {
                                roleMap = this.roleApi.getRoleMap();
                                this.redisUtil.insert(redisKey, (Object)roleMap, DEFAULT_CACHE_TIME);
                            }
                            localCache.put("__role_map", roleMap);
                            return;
                        }
                        case "group": {
                            Map groupMap;
                            if (this.redisUtil.exists(redisKey)) {
                                groupMap = this.redisUtil.getMap(redisKey);
                                groupMap = Optional.ofNullable(groupMap).orElse(new HashMap(20));
                            } else {
                                groupMap = this.groupApi.getGroupMap();
                                this.redisUtil.insert(redisKey, (Object)groupMap, DEFAULT_CACHE_TIME);
                            }
                            localCache.put("__group_map", groupMap);
                            return;
                        }
                        case "province": {
                            Map proMap = this.redisUtil.getMap(redisKey);
                            ArrayList<Map> proMapList = new ArrayList<Map>();
                            if (proMap.size() == 0) {
                                for (int i = 1; i <= 4; ++i) {
                                    String string = String.format("%s-%s-%d", this.dsName, KEY_PROVINCE, i);
                                    if (this.redisUtil.exists(string)) continue;
                                    List provinceEntityList = this.areaApi.getProListBytype(String.valueOf(i));
                                    HashMap provinceMap = new HashMap(16);
                                    if (provinceEntityList != null) {
                                        provinceEntityList.stream().forEach(p -> provinceMap.put((String)p.getId(), p.getFullName()));
                                    }
                                    proMapList.add(provinceMap);
                                    this.redisUtil.insert(string, provinceMap, 604800L);
                                }
                            } else {
                                for (int i = 1; i <= 4; ++i) {
                                    proMapList.add(this.redisUtil.getMap(String.format("%s-%s-%d", this.dsName, KEY_PROVINCE, i)));
                                }
                            }
                            localCache.put("__pro_maplist", proMapList);
                            return;
                        }
                        case "pop": {
                            ArrayList mapList = null;
                            if (!this.redisUtil.exists(redisKey)) {
                                mapList = this.dataInterFaceApi.infoToInfo(item.getInterfaceId(), (DataInterfacePage)item.getParam());
                                if (mapList != null && mapList.size() > 0 && item.getUseCache().booleanValue()) {
                                    this.redisUtil.insert(item.getRedisKey(), mapList, DEFAULT_CACHE_TIME);
                                }
                            } else {
                                List list = this.redisUtil.get(redisKey, 0L, -1L);
                                ArrayList tmpMapList = new ArrayList();
                                list.forEach(itemx -> tmpMapList.add(JsonUtil.entityToMap((Object)itemx)));
                                mapList = tmpMapList;
                            }
                            localCache.put(item.getRedisKey(), mapList);
                            return;
                        }
                        case "select": {
                            void var15_24;
                            Object var15_20 = null;
                            if (!this.redisUtil.exists(redisKey)) {
                                List list;
                                ActionResult data = this.dataInterFaceApi.infoToId(item.getInterfaceId(), null, (Map)item.getParam());
                                if (data != null && data.getData() != null && data.getData() instanceof List && CollectionUtils.isNotEmpty((Collection)(list = (List)data.getData())) && item.getUseCache().booleanValue()) {
                                    this.redisUtil.insert(redisKey, (Object)list, DEFAULT_CACHE_TIME);
                                }
                            } else {
                                List tmpList = this.redisUtil.get(redisKey, 0L, -1L);
                                ArrayList tmpMapList = new ArrayList();
                                tmpList.forEach(itemx -> tmpMapList.add(JsonUtil.entityToMap((Object)itemx)));
                                ArrayList arrayList = tmpMapList;
                            }
                            localCache.put(redisKey, var15_24);
                            return;
                        }
                        case "datatype": {
                            FieLdsModel swapDataVo = (FieLdsModel)item.getParam();
                            String dataType = swapDataVo.getConfig().getDataType();
                            String label = swapDataVo.getProps().getLabel() != null ? swapDataVo.getProps().getLabel() : "";
                            String value = swapDataVo.getProps().getValue() != null ? swapDataVo.getProps().getValue() : "";
                            String children = swapDataVo.getProps().getChildren() != null ? swapDataVo.getProps().getChildren() : "";
                            ArrayList<Map<String, Object>> options = new ArrayList();
                            if (swapDataVo.getConfig().getJnpfKey().equals("popupSelect") || swapDataVo.getConfig().getJnpfKey().equals("popupTableSelect")) {
                                label = swapDataVo.getRelationField();
                                value = swapDataVo.getPropsValue();
                            }
                            HashMap dataInterfaceMap = new HashMap(16);
                            String finalValue = value;
                            String finalLabel = label;
                            if (dataType.equals(OnlineDataTypeEnum.STATIC.getType()) && !localCache.containsKey(redisKey)) {
                                if (!this.redisUtil.exists(redisKey)) {
                                    if (swapDataVo.getOptions() != null) {
                                        options = JsonUtil.getJsonToListMap((String)swapDataVo.getOptions());
                                        OnlineSwapDataUtils.getOptions(label, value, children, JsonUtil.getListToJsonArray(options), options);
                                    } else {
                                        options = JsonUtil.getJsonToListMap((String)swapDataVo.getOptions());
                                    }
                                    options.stream().forEach(o -> dataInterfaceMap.put(String.valueOf(o.get(finalValue)), String.valueOf(o.get(finalLabel))));
                                    this.redisUtil.insert(redisKey, dataInterfaceMap, DEFAULT_CACHE_TIME);
                                    localCache.put(redisKey, dataInterfaceMap);
                                } else {
                                    localCache.put(redisKey, this.redisUtil.getMap(redisKey));
                                }
                            }
                            if (dataType.equals(OnlineDataTypeEnum.DYNAMIC.getType())) {
                                boolean dynamicIsNeedCache;
                                boolean bl = dynamicIsNeedCache = swapDataVo.getConfig().getTemplateJson().size() == 0;
                                if (dynamicIsNeedCache && !localCache.containsKey(redisKey)) {
                                    if (!this.redisUtil.exists(redisKey)) {
                                        ActionResult dataRes = this.dataInterFaceApi.infoToId(swapDataVo.getConfig().getPropsUrl(), null, null);
                                        if (dataRes != null && dataRes.getData() != null) {
                                            void var27_47;
                                            ArrayList arrayList = new ArrayList();
                                            if (dataRes.getData() instanceof List) {
                                                List list = (List)dataRes.getData();
                                            }
                                            JSONArray dataAll = JsonUtil.getListToJsonArray((List)var27_47);
                                            OnlineSwapDataUtils.treeToList(label, value, children, dataAll, options);
                                            options.stream().forEach(o -> dataInterfaceMap.put(String.valueOf(o.get(finalValue)), String.valueOf(o.get(finalLabel))));
                                            if (CollectionUtils.isNotEmpty((Collection)var27_47) && item.getUseCache().booleanValue()) {
                                                this.redisUtil.insert(redisKey, dataInterfaceMap, DEFAULT_CACHE_TIME);
                                            }
                                            localCache.put(redisKey, dataInterfaceMap);
                                        }
                                    } else {
                                        localCache.put(redisKey, this.redisUtil.getMap(redisKey));
                                    }
                                }
                            }
                            if (!dataType.equals(OnlineDataTypeEnum.DICTIONARY.getType())) return;
                            if (localCache.containsKey(redisKey)) return;
                            if (!this.redisUtil.exists(redisKey)) {
                                List list = this.dictionaryDataApi.getDicList(swapDataVo.getConfig().getDictionaryType());
                                options = list.stream().map(dic -> {
                                    HashMap<String, Object> dictionaryMap = new HashMap<String, Object>(16);
                                    dictionaryMap.put("id", dic.getId());
                                    dictionaryMap.put("enCode", dic.getEnCode());
                                    dictionaryMap.put("fullName", dic.getFullName());
                                    return dictionaryMap;
                                }).collect(Collectors.toList());
                                String dictionaryData = JsonUtil.getObjectToString(options);
                                this.redisUtil.insert(redisKey, (Object)dictionaryData, DEFAULT_CACHE_TIME);
                                localCache.put(redisKey, options);
                                return;
                            }
                            String dictionaryStringData = this.redisUtil.getString(redisKey).toString();
                            localCache.put(redisKey, JsonUtil.getJsonToListMap((String)dictionaryStringData));
                            return;
                        }
                        case "orgtree": {
                            Map orgTree;
                            if (this.redisUtil.exists(redisKey)) {
                                orgTree = this.redisUtil.getMap(redisKey);
                                orgTree = Optional.ofNullable(orgTree).orElse(new HashMap(20));
                            } else {
                                orgTree = this.organizeApi.getAllOrgsTreeName();
                                this.redisUtil.insert(redisKey, (Object)orgTree, DEFAULT_CACHE_TIME);
                            }
                            localCache.put("__orgTree_map", orgTree);
                            return;
                        }
                    }
                    return;
                }
                catch (Exception e) {
                    log.error("\u7ebf\u7a0b\u6267\u884c\u9519\u8bef\uff1a" + e.getMessage());
                    return;
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            log.error("\u7ebf\u7a0b\u8ba1\u6570\u9519\u8bef\uff1a" + e.getMessage());
        }
    }
}

